/*
 * Decompiled with CFR 0.152.
 */
package com.jgoodies.binding.adapter;

import com.jgoodies.binding.value.ValueModel;
import com.jgoodies.common.base.Preconditions;
import java.beans.PropertyChangeEvent;
import java.beans.PropertyChangeListener;
import javax.swing.SpinnerModel;
import javax.swing.event.ChangeEvent;
import javax.swing.event.ChangeListener;

public final class SpinnerToValueModelConnector {
    private final SpinnerModel spinnerModel;
    private final ValueModel valueModel;
    private final Object defaultValue;
    private final PropertyChangeListener valueChangeHandler;
    private final ChangeListener spinnerChangeHandler;

    public SpinnerToValueModelConnector(SpinnerModel spinnerModel, ValueModel valueModel, Object defaultValue) {
        this.spinnerModel = Preconditions.checkNotNull(spinnerModel, "The %s must not be null.", "spinner model");
        this.valueModel = Preconditions.checkNotNull(valueModel, "The %s must not be null.", "value model");
        this.defaultValue = Preconditions.checkNotNull(defaultValue, "The %s must not be null.", "default value");
        this.valueChangeHandler = this::onValueChanged;
        this.spinnerChangeHandler = this::onSpinnerChanged;
        spinnerModel.addChangeListener(this.spinnerChangeHandler);
        valueModel.addValueChangeListener(this.valueChangeHandler);
    }

    public static void connect(SpinnerModel spinnerModel, ValueModel valueModel, Object defaultValue) {
        new SpinnerToValueModelConnector(spinnerModel, valueModel, defaultValue);
    }

    public void updateSpinnerModel() {
        Object value = this.valueModel.getValue();
        Object valueWithDefault = value != null ? value : this.defaultValue;
        this.setSpinnerModelValueSilently(valueWithDefault);
    }

    public void updateValueModel() {
        this.setValueModelValueSilently(this.spinnerModel.getValue());
    }

    private void setSpinnerModelValueSilently(Object newValue) {
        this.spinnerModel.removeChangeListener(this.spinnerChangeHandler);
        this.spinnerModel.setValue(newValue);
        this.spinnerModel.addChangeListener(this.spinnerChangeHandler);
    }

    private void setValueModelValueSilently(Object newValue) {
        this.valueModel.removeValueChangeListener(this.valueChangeHandler);
        this.valueModel.setValue(newValue);
        this.valueModel.addValueChangeListener(this.valueChangeHandler);
    }

    public void release() {
        this.spinnerModel.removeChangeListener(this.spinnerChangeHandler);
        this.valueModel.removeValueChangeListener(this.valueChangeHandler);
    }

    private void onValueChanged(PropertyChangeEvent evt) {
        this.updateSpinnerModel();
    }

    private void onSpinnerChanged(ChangeEvent evt) {
        this.updateValueModel();
    }
}

