/*
 * Decompiled with CFR 0.152.
 */
package com.jgoodies.common.jsdl.action;

import com.jgoodies.application.internal.Exceptions;
import com.jgoodies.common.base.Preconditions;
import com.jgoodies.common.base.Strings;
import com.jgoodies.common.jsdl.action.ConsumerAction;
import com.jgoodies.common.jsdl.icon.IconValue;
import com.jgoodies.common.jsdl.internal.ActionResource;
import com.jgoodies.common.swing.MnemonicUtils;
import java.awt.event.ActionEvent;
import java.util.function.Consumer;
import javax.swing.Action;
import javax.swing.Icon;
import javax.swing.KeyStroke;

public final class ActionBuilder {
    private Consumer<ActionEvent> handler;
    private String text;
    private KeyStroke accelerator;
    private String shortDescription;
    private String longDescription;
    private String accessibleName;
    private String accessibleDescription;
    private String command;
    private Icon smallIcon;
    private Icon largeIcon;
    private boolean enabled = true;

    public ActionBuilder() {
    }

    public ActionBuilder(ActionResource actionResource) {
        this.smallIcon(actionResource.getIcon());
        this.text(actionResource.getText(), new Object[0]);
        this.shortDescription(actionResource.getShortDescription(), new Object[0]);
        this.longDescription(actionResource.getLongDescription());
        this.accelerator(actionResource.getAccelerator());
    }

    public ActionBuilder handler(Consumer<ActionEvent> handler) {
        this.handler = Preconditions.checkNotNull(handler, "The %s must not be null.", "action handler");
        return this;
    }

    public ActionBuilder handler(Runnable handler) {
        Preconditions.checkNotNull(handler, "The %s must not be null.", "action handler");
        this.handler = evt -> handler.run();
        return this;
    }

    public ActionBuilder text(String markedText, Object ... args) {
        this.text = Strings.get(markedText, args);
        return this;
    }

    public ActionBuilder shortDescription(String description, Object ... args) {
        this.shortDescription = Strings.get(description, args);
        return this;
    }

    public ActionBuilder longDescription(String description) {
        this.longDescription = description;
        return this;
    }

    public ActionBuilder accessibleName(String name) {
        this.accessibleName = name;
        return this;
    }

    public ActionBuilder accessibleDescription(String description) {
        this.accessibleDescription = description;
        return this;
    }

    public ActionBuilder accelerator(KeyStroke keyStroke) {
        this.accelerator = keyStroke;
        return this;
    }

    public ActionBuilder accelerator(String keyStroke) {
        this.accelerator = KeyStroke.getKeyStroke(keyStroke);
        return this;
    }

    public ActionBuilder smallIcon(Icon icon) {
        this.smallIcon = icon;
        return this;
    }

    public ActionBuilder smallIcon(IconValue icon) {
        return this.smallIcon(icon.toIcon());
    }

    public ActionBuilder largeIcon(Icon icon) {
        this.largeIcon = icon;
        return this;
    }

    public ActionBuilder largeIcon(IconValue icon) {
        return this.largeIcon(icon.toIcon());
    }

    public ActionBuilder command(String command) {
        this.command = command;
        return this;
    }

    public ActionBuilder enabled(boolean b) {
        this.enabled = b;
        return this;
    }

    public ActionBuilder disabled() {
        this.enabled = false;
        return this;
    }

    public Action build() {
        if (this.handler == null) {
            throw new Exceptions.ActionConfigurationException("You must provide an action handler (call #handler).");
        }
        ConsumerAction action = new ConsumerAction(this.handler);
        if (Strings.isNotBlank(this.text)) {
            MnemonicUtils.configure(action, this.text);
        } else if (this.smallIcon == null && this.largeIcon == null) {
            throw new Exceptions.ActionConfigurationException("You must provide either a text or an icon (call either #text, #smallIcon, or #largeIcon).");
        }
        action.putValue("SmallIcon", this.smallIcon);
        action.putValue("SwingLargeIconKey", this.largeIcon);
        action.putValue("AcceleratorKey", this.accelerator);
        action.putValue("ShortDescription", this.shortDescription);
        action.putValue("LongDescription", this.longDescription);
        action.putValue("ActionCommandKey", this.command);
        action.putValue("AccessibleNameKey", this.accessibleName);
        action.putValue("AccessibleDescriptionKey", this.accessibleDescription);
        action.setEnabled(this.enabled);
        return action;
    }
}

