/*
 * Decompiled with CFR 0.152.
 */
package com.jgoodies.common.jsdl.list;

import com.jgoodies.common.base.Preconditions;
import com.jgoodies.common.jsdl.action.ActionBean;
import com.jgoodies.common.swing.collect.ArrayListModel;
import com.jgoodies.common.swing.collect.ObservableList2;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.Comparator;
import java.util.List;
import java.util.Objects;
import java.util.function.BiPredicate;
import java.util.function.Function;
import java.util.function.Predicate;
import javax.swing.DefaultListSelectionModel;
import javax.swing.ListModel;
import javax.swing.ListSelectionModel;
import javax.swing.event.ListDataEvent;
import javax.swing.event.ListDataListener;
import javax.swing.event.ListSelectionEvent;
import javax.swing.event.ListSelectionListener;

public class ListViewModel<E>
extends ActionBean {
    protected final ObservableList2<E> items;
    private final ListSelectionModel selectionModel;
    private final ListSelectionModel inclusionModel;
    protected final ListDataListener listDataListener = new ListDataHandler();
    private final ListSelectionListener selectionChangeListener = this::onListSelectionValueChanged;
    private final ListSelectionListener inclusionChangeListener = this::onListInclusionValueChanged;
    private BiPredicate<E, E> selectionComparator;

    public ListViewModel() {
        this.items = new ArrayListModel();
        this.selectionModel = new DefaultListSelectionModel();
        this.inclusionModel = new DefaultListSelectionModel();
        this.items.addListDataListener(this.listDataListener);
        this.selectionModel.addListSelectionListener(this.selectionChangeListener);
        this.inclusionModel.addListSelectionListener(this.inclusionChangeListener);
    }

    public final ListModel<E> getDataModel() {
        return this.displayedList();
    }

    public final ListSelectionModel getSelectionModel() {
        return this.selectionModel;
    }

    public final ListSelectionModel getInclusionModel() {
        return this.inclusionModel;
    }

    public final BiPredicate<E, E> getSelectionComparator() {
        return this.selectionComparator;
    }

    public final void setSelectionComparator(BiPredicate<E, E> comparator) {
        this.selectionComparator = comparator;
    }

    public final void setSelectionComparator(Comparator<E> comparator) {
        this.selectionComparator = (e1, e2) -> comparator.compare(e1, e2) == 0;
    }

    public final void setSelectionComparator(Function<E, Object> mapper) {
        this.setSelectionComparator((E e1, E e2) -> Objects.equals(mapper.apply(e1), mapper.apply(e2)));
    }

    public final List<E> getItems() {
        return Collections.unmodifiableList(this.items);
    }

    public final void setItems(E ... items) {
        this.setItems(items == null ? Collections.EMPTY_LIST : Arrays.asList(items));
    }

    public final void setItems(List<E> items) {
        this.setItemsImpl(items);
    }

    public final E get(int index) {
        return this.items.get(index);
    }

    public final int size() {
        return this.items.size();
    }

    public final void add(E element) {
        this.items.add(element);
    }

    public final void add(int index, E element) {
        this.items.add(index, element);
    }

    public final boolean addAll(Collection<? extends E> c) {
        return this.items.addAll(c);
    }

    public final boolean addAll(int index, Collection<? extends E> c) {
        return this.items.addAll(index, c);
    }

    public final void remove(E element) {
        this.items.remove(element);
    }

    public final E remove(int index) {
        return this.items.remove(index);
    }

    public final boolean removeAll(Collection<?> c) {
        return this.items.removeAll(c);
    }

    public final E setItem(int index, E element) {
        return this.items.set(index, element);
    }

    public final void clear() {
        this.items.clear();
    }

    public final boolean contains(E element) {
        return this.items.contains(element);
    }

    public final boolean isEmpty() {
        return this.items.isEmpty();
    }

    public final void moveSelectedItemDown() {
        if (!this.isSingleSelection() || this.isSelectedLast()) {
            return;
        }
        int oldSelectedIndex = this.getSelectedIndex();
        int newSelectedIndex = oldSelectedIndex + 1;
        E item = this.remove(oldSelectedIndex);
        this.add(newSelectedIndex, item);
        this.setSelectedIndex(newSelectedIndex);
    }

    public final void moveSelectedItemUp() {
        if (!this.isSingleSelection() || this.isSelectedFirst()) {
            return;
        }
        int oldSelectedIndex = this.getSelectedIndex();
        int newSelectedIndex = oldSelectedIndex - 1;
        E item = this.remove(oldSelectedIndex);
        this.add(newSelectedIndex, item);
        this.setSelectedIndex(newSelectedIndex);
    }

    public final int getSelectedIndex() {
        return this.getMinSelectionIndex();
    }

    public final void setSelectedIndex(int index) {
        this.selectionModel.setSelectionInterval(index, index);
    }

    public final List<Integer> getSelectedIndices() {
        return ListViewModel.getSelectedIndices(this.getSelectionModel());
    }

    public final void setSelectedIndices(int ... indices) {
        Preconditions.checkNotNull(indices, "The %s must not be null.", "the array of selected indices");
        ListViewModel.setSelectedIndices(this.getSelectionModel(), indices);
    }

    public final int getMinSelectionIndex() {
        return this.getSelectionModel().getMinSelectionIndex();
    }

    public final int getMaxSelectionIndex() {
        return this.getSelectionModel().getMaxSelectionIndex();
    }

    public final E getSelectedItem() {
        return this.isSingleSelection() ? (E)this.displayedGet(this.getMinSelectionIndex()) : null;
    }

    public final void setSelectedItem(E item) {
        int index = ListViewModel.indexOf(this.items, item, this.selectionComparator);
        this.setSelectedIndex(index);
    }

    public final List<E> getSelectedItems() {
        return this.getSelectedItems(this.getSelectionModel());
    }

    public final void setSelectedItems(E ... itemsToSelect) {
        Preconditions.checkNotNull(itemsToSelect, "The %s must not be null.", "the array of selected items");
        this.setSelectedItems(this.getSelectionModel(), Arrays.asList(itemsToSelect));
    }

    public final void setSelectedItems(List<E> itemsToSelect) {
        Preconditions.checkNotNull(itemsToSelect, "The %s must not be null.", "the list of selected items");
        this.setSelectedItems(this.getSelectionModel(), itemsToSelect);
    }

    public final int getSelectionMode() {
        return this.getSelectionModel().getSelectionMode();
    }

    public final void setSelectionMode(int selectionMode) {
        this.getSelectionModel().setSelectionMode(selectionMode);
    }

    public final boolean hasSelection() {
        return !this.selectionModel.isSelectionEmpty();
    }

    public final boolean isSelectionEmpty() {
        return this.selectionModel.isSelectionEmpty();
    }

    public final boolean isSingleSelection() {
        return this.getMinSelectionIndex() != -1 && this.getMinSelectionIndex() == this.getMaxSelectionIndex();
    }

    public final boolean isMultipleSelection() {
        return !this.isSelectionEmpty() && !this.isSingleSelection();
    }

    public final boolean isSelectedFirst() {
        return this.getMinSelectionIndex() == 0;
    }

    public final boolean isSelectedLast() {
        return this.getMaxSelectionIndex() == this.displayedSize() - 1;
    }

    public final void selectFirst() {
        this.selectionModel.setSelectionInterval(0, 0);
    }

    public final void selectAll() {
        this.selectionModel.setSelectionInterval(0, this.displayedSize() - 1);
    }

    public final void select(Predicate<E> predicate) {
        this.selectionModel.setValueIsAdjusting(true);
        this.selectionModel.clearSelection();
        for (int index = this.displayedSize() - 1; index >= 0; --index) {
            E item = this.get(index);
            if (!predicate.test(item)) continue;
            this.selectionModel.addSelectionInterval(index, index);
        }
        this.selectionModel.setValueIsAdjusting(false);
    }

    public final void clearSelection() {
        this.selectionModel.clearSelection();
    }

    public final List<Integer> getIncludedIndices() {
        return ListViewModel.getSelectedIndices(this.getInclusionModel());
    }

    public final void setIncludedIndices(int ... indices) {
        Preconditions.checkNotNull(indices, "The %s must not be null.", "the array of included indices");
        ListViewModel.setSelectedIndices(this.getInclusionModel(), indices);
    }

    public final List<E> getIncludedItems() {
        return this.getSelectedItems(this.getInclusionModel());
    }

    public final void setIncludedItems(E ... itemsToInclude) {
        Preconditions.checkNotNull(itemsToInclude, "The %s must not be null.", "the array of included items");
        this.setSelectedItems(this.getInclusionModel(), Arrays.asList(itemsToInclude));
    }

    public final void setIncludedItems(List<E> itemsToInclude) {
        Preconditions.checkNotNull(itemsToInclude, "The %s must not be null.", "the list of included items");
        this.setSelectedItems(this.getInclusionModel(), itemsToInclude);
    }

    public final boolean hasInclusions() {
        return !this.getInclusionModel().isSelectionEmpty();
    }

    public final boolean isInclusionEmpty() {
        return this.inclusionModel.isSelectionEmpty();
    }

    public final boolean isIncluded(int index) {
        return this.inclusionModel.isSelectedIndex(index);
    }

    public final void setIncluded(int index, boolean included) {
        if (included) {
            this.inclusionModel.addSelectionInterval(index, index);
        } else {
            this.inclusionModel.removeSelectionInterval(index, index);
        }
        this.items.fireContentsChanged(index);
    }

    public final void toggleInclusion(int index) {
        this.setIncluded(index, !this.isIncluded(index));
    }

    public void includeAll() {
        int minIndex = 0;
        int maxIndex = this.displayedSize() - 1;
        if (maxIndex != -1) {
            this.getInclusionModel().setSelectionInterval(minIndex, maxIndex);
            this.displayedList().fireContentsChanged(minIndex, maxIndex);
        }
    }

    public final void include(Predicate<E> predicate) {
        this.inclusionModel.setValueIsAdjusting(true);
        this.inclusionModel.clearSelection();
        for (int index = this.displayedSize() - 1; index >= 0; --index) {
            E item = this.get(index);
            if (!predicate.test(item)) continue;
            this.inclusionModel.addSelectionInterval(index, index);
        }
        this.inclusionModel.setValueIsAdjusting(false);
    }

    public void clearInclusions() {
        int minIndex = 0;
        int maxIndex = this.displayedSize() - 1;
        this.getInclusionModel().clearSelection();
        if (maxIndex != -1) {
            this.displayedList().fireContentsChanged(minIndex, maxIndex);
        }
    }

    protected final void fireContentsChanged(int index) {
        this.items.fireContentsChanged(index);
    }

    protected final void fireContentsChanged(int index0, int index1) {
        this.items.fireContentsChanged(index0, index1);
    }

    protected void onListDataChanged(ListDataEvent evt) {
    }

    protected void onListSelectionChanged(ListSelectionEvent evt) {
    }

    protected void onListInclusionChanged(ListSelectionEvent evt) {
    }

    private static <E> int indexOf(List<E> list, E element, BiPredicate<E, E> comparator) {
        if (element == null) {
            return -1;
        }
        if (comparator == null) {
            return list.indexOf(element);
        }
        int size = list.size();
        for (int index = 0; index < size; ++index) {
            E item = list.get(index);
            if (!comparator.test(item, element)) continue;
            return index;
        }
        return -1;
    }

    protected void restoreSelection(List<E> oldSelectedItems) {
        this.setSelectedItems(this.getSelectionModel(), oldSelectedItems);
    }

    protected void restoreInclusions(List<E> oldIncludedItems) {
        this.setSelectedItems(this.getInclusionModel(), oldIncludedItems);
    }

    protected void setItemsImpl(List<E> newItems) {
        List<E> oldSelection = this.getSelectedItems();
        this.items.clear();
        this.items.addAll(newItems);
        this.restoreSelection(oldSelection);
    }

    protected ObservableList2<E> displayedList() {
        return this.items;
    }

    protected final E displayedGet(int index) {
        return this.displayedList().get(index);
    }

    protected final int displayedSize() {
        return this.displayedList().size();
    }

    protected static List<Integer> getSelectedIndices(ListSelectionModel listSelectionModel) {
        int minIndex = listSelectionModel.getMinSelectionIndex();
        int maxIndex = listSelectionModel.getMaxSelectionIndex();
        int maxSize = maxIndex - minIndex + 1;
        ArrayList<Integer> indices = new ArrayList<Integer>(maxSize);
        for (int index = minIndex; index <= maxIndex; ++index) {
            if (!listSelectionModel.isSelectedIndex(index)) continue;
            indices.add(index);
        }
        return Collections.unmodifiableList(indices);
    }

    protected static void setSelectedIndices(ListSelectionModel listSelectionModel, int ... indices) {
        listSelectionModel.setValueIsAdjusting(true);
        listSelectionModel.clearSelection();
        for (int index : indices) {
            listSelectionModel.addSelectionInterval(index, index);
        }
        listSelectionModel.setValueIsAdjusting(false);
    }

    protected final List<E> getSelectedItems(ListSelectionModel listSelectionModel) {
        int minIndex = listSelectionModel.getMinSelectionIndex();
        int maxIndex = listSelectionModel.getMaxSelectionIndex();
        int maxSize = maxIndex - minIndex + 1;
        ArrayList<E> items = new ArrayList<E>(maxSize);
        for (int index = minIndex; index <= maxIndex; ++index) {
            if (!listSelectionModel.isSelectedIndex(index)) continue;
            items.add(this.displayedGet(index));
        }
        return Collections.unmodifiableList(items);
    }

    protected final void setSelectedItems(ListSelectionModel listSelectionModel, List<E> itemsToSelect) {
        listSelectionModel.setValueIsAdjusting(true);
        listSelectionModel.clearSelection();
        for (E item : itemsToSelect) {
            int index = ListViewModel.indexOf(this.displayedList(), item, this.selectionComparator);
            if (index == -1) continue;
            listSelectionModel.addSelectionInterval(index, index);
        }
        listSelectionModel.setValueIsAdjusting(false);
    }

    private void onListSelectionValueChanged(ListSelectionEvent evt) {
        if (evt.getValueIsAdjusting()) {
            return;
        }
        this.onListSelectionChanged(evt);
    }

    private void onListInclusionValueChanged(ListSelectionEvent evt) {
        if (evt.getValueIsAdjusting()) {
            return;
        }
        this.onListInclusionChanged(evt);
    }

    private final class ListDataHandler
    implements ListDataListener {
        private ListDataHandler() {
        }

        @Override
        public void contentsChanged(ListDataEvent evt) {
            ListViewModel.this.onListDataChanged(evt);
        }

        @Override
        public void intervalAdded(ListDataEvent evt) {
            ListViewModel.this.onListDataChanged(evt);
        }

        @Override
        public void intervalRemoved(ListDataEvent evt) {
            ListViewModel.this.onListDataChanged(evt);
        }
    }
}

