/*
 * Decompiled with CFR 0.152.
 */
package com.jgoodies.components;

import com.jgoodies.common.base.Preconditions;
import com.jgoodies.common.swing.Listeners;
import com.jgoodies.components.internal.JGCheckBoxListCellRenderer;
import java.awt.event.KeyEvent;
import java.awt.event.MouseEvent;
import java.beans.PropertyChangeEvent;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import java.util.Vector;
import javax.swing.DefaultListSelectionModel;
import javax.swing.JCheckBox;
import javax.swing.JList;
import javax.swing.ListCellRenderer;
import javax.swing.ListModel;
import javax.swing.ListSelectionModel;
import javax.swing.event.ListDataEvent;
import javax.swing.event.ListDataListener;
import javax.swing.event.ListSelectionEvent;
import javax.swing.event.ListSelectionListener;

public class JGCheckBoxList<E>
extends JList<E> {
    private ListSelectionModel inclusionModel;
    private ListSelectionListener listInclusionListener;
    private ListDataListener intervalAddedListener;
    private ListDataListener intervalRemovedListener;

    public JGCheckBoxList(ListModel<E> dataModel) {
        super(dataModel);
        this.init();
    }

    public JGCheckBoxList(E[] listData) {
        super(listData);
        this.init();
    }

    public JGCheckBoxList(Vector<E> listData) {
        super(listData);
        this.init();
    }

    public JGCheckBoxList() {
        this.init();
    }

    private void init() {
        this.inclusionModel = new DefaultListSelectionModel();
        this.inclusionModel.setSelectionMode(2);
        this.listInclusionListener = this::onInclusionListSelectionChanged;
        this.intervalAddedListener = Listeners.listIntervalAdded(this::onListIntervalAdded);
        this.intervalRemovedListener = Listeners.listIntervalRemoved(this::onListIntervalRemoved);
        this.getModel().addListDataListener(this.intervalAddedListener);
        this.getModel().addListDataListener(this.intervalRemovedListener);
        this.getInclusionModel().addListSelectionListener(this.listInclusionListener);
        this.addKeyListener(Listeners.keyPressed(this::onKeyPressed, null));
        this.addMouseListener(Listeners.mousePressed(this::onMousePressed, null));
        this.addPropertyChangeListener("model", this::onModelChanged);
    }

    public final void includeAll() {
        this.inclusionModel.addSelectionInterval(0, this.getModel().getSize() - 1);
    }

    public final void excludeAll() {
        this.inclusionModel.clearSelection();
    }

    public final ListSelectionModel getInclusionModel() {
        return this.inclusionModel;
    }

    public final void setInclusionModel(ListSelectionModel newInclusionModel) {
        Preconditions.checkNotNull(newInclusionModel, "The %s must not be null.", "the inclusion model");
        Preconditions.checkArgument(newInclusionModel.getSelectionMode() == 2, "The included model's selection mode must be MULTIPLE_INTERVAL_SELECTION.");
        ListSelectionModel oldInclusionModel = this.getInclusionModel();
        if (oldInclusionModel != null) {
            oldInclusionModel.removeListSelectionListener(this.listInclusionListener);
        }
        this.inclusionModel = newInclusionModel;
        newInclusionModel.addListSelectionListener(this.listInclusionListener);
    }

    public final List<Integer> getIncludedIndices() {
        int minIndex = this.inclusionModel.getMinSelectionIndex();
        int maxIndex = this.inclusionModel.getMaxSelectionIndex();
        int maxSize = maxIndex - minIndex + 1;
        ArrayList<Integer> indices = new ArrayList<Integer>(maxSize);
        for (int index = minIndex; index <= maxIndex; ++index) {
            if (!this.inclusionModel.isSelectedIndex(index)) continue;
            indices.add(index);
        }
        return Collections.unmodifiableList(indices);
    }

    public final void setIncludedIndices(int ... indices) {
        Preconditions.checkNotNull(indices, "The %s must not be null.", "the array of included indices");
        this.inclusionModel.setValueIsAdjusting(true);
        this.inclusionModel.clearSelection();
        for (int index : indices) {
            this.inclusionModel.addSelectionInterval(index, index);
        }
        this.inclusionModel.setValueIsAdjusting(false);
    }

    public final List<E> getIncludedItems() {
        int minIndex = this.inclusionModel.getMinSelectionIndex();
        int maxIndex = this.inclusionModel.getMaxSelectionIndex();
        int maxSize = maxIndex - minIndex + 1;
        ListModel dataModel = this.getModel();
        ArrayList items = new ArrayList(maxSize);
        for (int index = minIndex; index <= maxIndex; ++index) {
            if (!this.inclusionModel.isSelectedIndex(index)) continue;
            items.add(dataModel.getElementAt(index));
        }
        return Collections.unmodifiableList(items);
    }

    public final void setIncludedItems(E ... includedItems) {
        Preconditions.checkNotNull(includedItems, "The %s must not be null.", "array of included items");
        this.setIncludedItems(Arrays.asList(includedItems));
    }

    public final void setIncludedItems(List<E> includedItems) {
        Preconditions.checkNotNull(includedItems, "The %s must not be null.", "list of included items");
        this.inclusionModel.setValueIsAdjusting(true);
        this.inclusionModel.clearSelection();
        for (int index = 0; index < this.getModel().getSize(); ++index) {
            Object item = this.getModel().getElementAt(index);
            if (!includedItems.contains(item)) continue;
            this.inclusionModel.addSelectionInterval(index, index);
        }
        this.inclusionModel.setValueIsAdjusting(false);
    }

    public final boolean isIncluded(int index) {
        return this.inclusionModel.isSelectedIndex(index);
    }

    public final void setIncluded(int index, boolean included) {
        if (included) {
            this.inclusionModel.addSelectionInterval(index, index);
        } else {
            this.inclusionModel.removeSelectionInterval(index, index);
        }
    }

    @Override
    public final void setCellRenderer(ListCellRenderer<? super E> delegate) {
        super.setCellRenderer(new JGCheckBoxListCellRenderer<E>(delegate));
    }

    private void onKeyPressed(KeyEvent evt) {
        if (evt.isConsumed()) {
            return;
        }
        if (evt.getModifiers() != 0 || evt.getKeyCode() != 32) {
            return;
        }
        this.toggleSelectedIncluded();
        this.repaint();
        evt.consume();
    }

    private void onMousePressed(MouseEvent evt) {
        if (!this.isEnabled()) {
            return;
        }
        if (evt.isConsumed()) {
            return;
        }
        if (evt.getModifiersEx() != 1024) {
            return;
        }
        if (evt.getX() > new JCheckBox().getPreferredSize().width) {
            return;
        }
        int index = this.locationToIndex(evt.getPoint());
        if (index == -1) {
            return;
        }
        this.toggleIncluded(index);
        this.repaint();
        evt.consume();
    }

    private void onModelChanged(PropertyChangeEvent evt) {
        this.excludeAll();
        ListModel oldValue = (ListModel)evt.getOldValue();
        oldValue.removeListDataListener(this.intervalAddedListener);
        oldValue.removeListDataListener(this.intervalRemovedListener);
        ListModel newValue = (ListModel)evt.getNewValue();
        newValue.addListDataListener(this.intervalAddedListener);
        newValue.addListDataListener(this.intervalRemovedListener);
    }

    private void onListIntervalAdded(ListDataEvent evt) {
        int minIndex = Math.min(evt.getIndex0(), evt.getIndex1());
        int maxIndex = Math.max(evt.getIndex0(), evt.getIndex1());
        this.inclusionModel.insertIndexInterval(minIndex, maxIndex - minIndex + 1, true);
    }

    private void onListIntervalRemoved(ListDataEvent evt) {
        this.inclusionModel.removeIndexInterval(evt.getIndex0(), evt.getIndex1());
    }

    private void onInclusionListSelectionChanged(ListSelectionEvent evt) {
        if (!evt.getValueIsAdjusting()) {
            this.repaint();
        }
    }

    private void toggleIncluded(int index) {
        this.setIncluded(index, !this.isIncluded(index));
    }

    private void toggleSelectedIncluded() {
        this.inclusionModel.setValueIsAdjusting(true);
        for (int index : this.getSelectedIndices()) {
            this.toggleIncluded(index);
        }
        this.inclusionModel.setValueIsAdjusting(false);
    }
}

