/*
 * Decompiled with CFR 0.152.
 */
package com.jgoodies.components;

import com.jgoodies.common.base.Preconditions;
import com.jgoodies.common.base.Strings;
import com.jgoodies.components.JGButton;
import com.jgoodies.components.plaf.ComponentSetup;
import javax.accessibility.AccessibleContext;
import javax.swing.Action;
import javax.swing.Icon;
import javax.swing.JButton;

public final class JGCommandLink
extends JGButton {
    public static final String PROPERTY_DESCRIPTION = "description";
    public static final String PROPERTY_ICON_VISIBLE = "iconVisible";
    public static final String PROPERTY_FORCE_STANDARD_ICON = "forceStandardIcon";
    private static final String UI_CLASS_ID = "JSDL.CommandLinkUI";
    private String description;
    private boolean iconVisible;
    private boolean forceStandardIcon;

    public JGCommandLink() {
        this(null, "Mandatory Text", "This optional text describes this command.");
    }

    public JGCommandLink(String text) {
        this(null, text, null, true);
    }

    public JGCommandLink(String text, boolean iconVisible) {
        this(null, text, null, iconVisible);
    }

    public JGCommandLink(Icon icon, String text) {
        this(icon, text, null, true);
    }

    public JGCommandLink(String text, String description) {
        this(null, text, description, true);
    }

    public JGCommandLink(String text, String description, boolean iconVisible) {
        this(null, text, description, iconVisible);
    }

    public JGCommandLink(Icon icon, String text, String description) {
        this(icon, text, description, true);
    }

    public JGCommandLink(Icon icon, String text, String description, boolean iconVisible) {
        this(icon, text, description, iconVisible, false);
    }

    public JGCommandLink(Icon icon, String text, String description, boolean iconVisible, boolean forceStandardIcon) {
        super(Preconditions.checkNotNull(text, "The %s must not be null.", "text"), icon);
        this.setContentAreaFilled(false);
        this.setRolloverEnabled(true);
        this.setDescription(description);
        this.setIconVisible(iconVisible);
        this.setForceStandardIcon(forceStandardIcon);
    }

    public JGCommandLink(Action action) {
        this(action, true);
    }

    public JGCommandLink(Action action, boolean iconVisible) {
        this(action, iconVisible, false);
    }

    public JGCommandLink(Action action, boolean iconVisible, boolean forceStandardIcon) {
        super(Preconditions.checkNotNull(action, "The %s must not be null.", "action"));
        this.setContentAreaFilled(false);
        this.setRolloverEnabled(true);
        this.setIconVisible(iconVisible);
        this.setForceStandardIcon(forceStandardIcon);
    }

    @Override
    public void setText(String newText) {
        Preconditions.checkNotBlank(newText, "The %s must not be null, empty, or whitespace.", "CommandLink text");
        super.setText(newText);
    }

    public String getDescription() {
        return this.description;
    }

    public void setDescription(String newDescription) {
        if (Strings.isNotEmpty(newDescription) && Strings.isBlank(newDescription)) {
            throw new IllegalArgumentException("The CommandLink description must not be whitespace.");
        }
        String oldText = this.getDescription();
        this.description = newDescription;
        this.firePropertyChange(PROPERTY_DESCRIPTION, oldText, newDescription);
    }

    public boolean isIconVisible() {
        return this.iconVisible;
    }

    public void setIconVisible(boolean newValue) {
        boolean oldValue = this.isIconVisible();
        this.iconVisible = newValue;
        this.firePropertyChange(PROPERTY_ICON_VISIBLE, oldValue, newValue);
    }

    public boolean getForceStandardIcon() {
        return this.forceStandardIcon;
    }

    public void setForceStandardIcon(boolean newValue) {
        boolean oldValue = this.getForceStandardIcon();
        this.forceStandardIcon = newValue;
        this.firePropertyChange(PROPERTY_FORCE_STANDARD_ICON, oldValue, newValue);
    }

    @Override
    protected void configurePropertiesFromAction(Action action) {
        super.configurePropertiesFromAction(action);
        String longDescription = action == null ? null : (String)action.getValue("LongDescription");
        this.setDescription(longDescription);
    }

    @Override
    public void updateUI() {
        ComponentSetup.ensureSetup();
        super.updateUI();
    }

    @Override
    public String getUIClassID() {
        return UI_CLASS_ID;
    }

    @Override
    public AccessibleContext getAccessibleContext() {
        if (this.accessibleContext == null) {
            this.accessibleContext = new AccessibleCommandLink();
        }
        return this.accessibleContext;
    }

    protected final class AccessibleCommandLink
    extends JButton.AccessibleJButton {
        protected AccessibleCommandLink() {
            super(JGCommandLink.this);
        }

        @Override
        public String getAccessibleName() {
            if (this.accessibleName != null) {
                return this.accessibleName;
            }
            String text = JGCommandLink.this.getText();
            StringBuilder builder = new StringBuilder();
            String prefix = text == null ? super.getAccessibleName() : text;
            builder.append(prefix);
            builder.append(": ");
            builder.append(JGCommandLink.this.getDescription());
            return builder.toString();
        }
    }
}

