/*
 * Decompiled with CFR 0.152.
 */
package com.jgoodies.components;

import com.jgoodies.common.base.Preconditions;
import com.jgoodies.common.base.Strings;
import com.jgoodies.common.format.EmptyDateFormat;
import com.jgoodies.common.format.EmptyFormat;
import com.jgoodies.common.format.EmptyNumberFormat;
import com.jgoodies.common.jsdl.JSDLCommonSetup;
import com.jgoodies.common.jsdl.action.ConsumerAction;
import com.jgoodies.common.swing.MnemonicUtils;
import com.jgoodies.common.swing.ScreenScaling;
import com.jgoodies.common.swing.focus.FocusTraversalUtils;
import com.jgoodies.components.JGButton;
import com.jgoodies.components.JGCheckBoxMenuItem;
import com.jgoodies.components.JGFormattedTextField;
import com.jgoodies.components.JGHyperlink;
import com.jgoodies.components.JGMenu;
import com.jgoodies.components.JGMenuButton;
import com.jgoodies.components.JGMenuItem;
import com.jgoodies.components.JGPasswordField;
import com.jgoodies.components.JGRadioButtonMenuItem;
import com.jgoodies.components.JGSearchField;
import com.jgoodies.components.JGSplitButton;
import com.jgoodies.components.JGSplitPane;
import com.jgoodies.components.JGStripedTable;
import com.jgoodies.components.JGTextArea;
import com.jgoodies.components.JGTextField;
import com.jgoodies.components.internal.ReadOnlyEditorPane;
import com.jgoodies.components.internal.ReadOnlyFormattedTextField;
import com.jgoodies.components.internal.ReadOnlyTextArea;
import com.jgoodies.components.internal.ReadOnlyTextField;
import com.jgoodies.components.internal.StaticEditorPane;
import com.jgoodies.components.internal.StaticTextArea;
import com.jgoodies.components.plaf.ComponentSetup;
import com.jgoodies.components.renderer.JGBooleanTableCellRenderer;
import com.jgoodies.components.renderer.JGDefaultListCellRenderer;
import com.jgoodies.components.renderer.JGFormatTableCellRenderer;
import com.jgoodies.components.util.ComponentUtils;
import com.jgoodies.layout.factories.ComponentFactory;
import com.jgoodies.layout.factories.DefaultComponentFactory;
import java.awt.Color;
import java.awt.Component;
import java.awt.Font;
import java.awt.event.ActionEvent;
import java.io.IOException;
import java.net.URL;
import java.text.DateFormat;
import java.text.Format;
import java.text.NumberFormat;
import java.time.LocalDate;
import java.time.LocalDateTime;
import java.time.format.DateTimeFormatter;
import java.time.format.FormatStyle;
import java.util.Arrays;
import java.util.List;
import java.util.Vector;
import java.util.function.Function;
import javax.swing.AbstractAction;
import javax.swing.AbstractButton;
import javax.swing.Action;
import javax.swing.BorderFactory;
import javax.swing.Icon;
import javax.swing.InputMap;
import javax.swing.JButton;
import javax.swing.JCheckBox;
import javax.swing.JCheckBoxMenuItem;
import javax.swing.JComboBox;
import javax.swing.JComponent;
import javax.swing.JEditorPane;
import javax.swing.JFormattedTextField;
import javax.swing.JLabel;
import javax.swing.JList;
import javax.swing.JMenu;
import javax.swing.JMenuItem;
import javax.swing.JPopupMenu;
import javax.swing.JRadioButton;
import javax.swing.JRadioButtonMenuItem;
import javax.swing.JScrollPane;
import javax.swing.JTabbedPane;
import javax.swing.JTable;
import javax.swing.JTextArea;
import javax.swing.KeyStroke;
import javax.swing.ListCellRenderer;
import javax.swing.UIManager;
import javax.swing.event.HyperlinkEvent;
import javax.swing.event.HyperlinkListener;
import javax.swing.plaf.basic.BasicHTML;
import javax.swing.table.TableCellRenderer;
import javax.swing.table.TableModel;
import javax.swing.text.DateFormatter;
import javax.swing.text.DefaultFormatterFactory;
import javax.swing.text.JTextComponent;
import javax.swing.text.NumberFormatter;

public class JGComponentFactory
implements ComponentFactory {
    private static JGComponentFactory current;
    protected static int buttonCounter;
    protected static int menuCounter;
    protected static int menuItemCounter;
    private HyperlinkListener defaultHyperlinkListener;
    private TableCellRenderer defaultBooleanRenderer;
    private TableCellRenderer defaultLocalDateRenderer;
    private TableCellRenderer defaultLocalDateTimeRenderer;
    private static final KeyStroke ENTER;
    private static final KeyStroke SHIFT_ENTER;

    protected JGComponentFactory() {
    }

    public static JGComponentFactory getCurrent() {
        ComponentSetup.ensureSetup();
        if (current == null) {
            current = new JGComponentFactory();
        }
        return current;
    }

    public static void setCurrent(JGComponentFactory newInstance) {
        current = newInstance;
    }

    public HyperlinkListener getDefaultHyperlinkListener() {
        return this.defaultHyperlinkListener;
    }

    public void setDefaultHyperlinkListener(HyperlinkListener hyperlinkListener) {
        this.defaultHyperlinkListener = hyperlinkListener;
    }

    public JButton createButton() {
        return this.createButton("Button " + buttonCounter++);
    }

    @Override
    public JButton createButton(Action action) {
        JGButton button = new JGButton(action);
        this.configure(button);
        return button;
    }

    public JButton createButton(String markedText) {
        Preconditions.checkNotBlank(markedText, "The %s must not be null, empty, or whitespace.", "button text");
        JGComponentFactory.checkEllipsis(markedText);
        JGButton button = new JGButton();
        MnemonicUtils.configure(button, markedText);
        this.configure(button);
        return button;
    }

    public JCheckBox createCheckBox(String markedText) {
        return this.createCheckBox(markedText, null);
    }

    public JCheckBox createCheckBox(String markedText, String accessibleName) {
        Preconditions.checkNotBlank(markedText, "The text must not be null, empty, or whitespace.\nA typical design mistake is to label a check box with empty text.\nThese check boxes are difficult to hit with a mouse.\nAnd they may lack the focus indicator.");
        JCheckBox checkBox = new JCheckBox();
        checkBox.setContentAreaFilled(false);
        MnemonicUtils.configure(checkBox, markedText);
        this.configure(checkBox);
        checkBox.getAccessibleContext().setAccessibleName(accessibleName);
        return checkBox;
    }

    public JCheckBoxMenuItem createCheckBoxMenuItem() {
        return this.createCheckBoxMenuItem("Check box item " + menuItemCounter++);
    }

    public JCheckBoxMenuItem createCheckBoxMenuItem(String markedText) {
        Preconditions.checkNotBlank(markedText, "The %s must not be null, empty, or whitespace.", "check box menu item text");
        JGCheckBoxMenuItem item = new JGCheckBoxMenuItem();
        MnemonicUtils.configure(item, markedText);
        this.configure(item);
        return item;
    }

    public JCheckBoxMenuItem createCheckBoxMenuItem(Action action) {
        JCheckBoxMenuItem item = new JCheckBoxMenuItem(action);
        this.configure(item);
        return item;
    }

    public <E> JComboBox<E> createComboBox(E ... items) {
        return this.createComboBox((ListCellRenderer)null, items);
    }

    public <E> JComboBox<E> createComboBox(List<E> items) {
        return this.createComboBox((ListCellRenderer)null, items);
    }

    public <E> JComboBox<E> createComboBox(ListCellRenderer<? super E> cellRenderer, E ... items) {
        Preconditions.checkNotNull(items, "The %s must not be null.", "combo box items");
        return this.createComboBox(cellRenderer, Arrays.asList(items));
    }

    public <E> JComboBox<E> createComboBox(ListCellRenderer<? super E> cellRenderer, List<E> items) {
        Preconditions.checkNotNull(items, "The %s must not be null.", "combo box items");
        JComboBox<? super E> comboBox = new JComboBox<E>(new Vector<E>(items));
        if (cellRenderer != null) {
            comboBox.setRenderer(cellRenderer);
        }
        return comboBox;
    }

    public <E> JComboBox<E> createComboBox(Function<E, String> displayStringFunction, E ... items) {
        return this.createComboBox((ListCellRenderer<? super E>)new JGDefaultListCellRenderer<E>(displayStringFunction), items);
    }

    public <E> JComboBox<E> createComboBox(Function<E, String> displayStringFunction, List<E> items) {
        return this.createComboBox((ListCellRenderer<? super E>)new JGDefaultListCellRenderer<E>(displayStringFunction), items);
    }

    public JGFormattedTextField createDateField() {
        DateFormat editFormat = DateFormat.getDateInstance(3);
        editFormat.setLenient(false);
        DateFormat displayFormat = DateFormat.getDateInstance();
        DateFormatter editFormatter = new DateFormatter(new EmptyDateFormat(editFormat));
        DateFormatter displayFormatter = new DateFormatter(new EmptyDateFormat(displayFormat));
        DefaultFormatterFactory formatterFactory = new DefaultFormatterFactory(editFormatter, displayFormatter);
        return this.createFormattedTextField(formatterFactory);
    }

    public JGFormattedTextField createFormattedTextField(Format format) {
        Preconditions.checkNotNull(format, "The %s must not be null.", "format");
        JGFormattedTextField field = new JGFormattedTextField(format);
        this.configure(field);
        return field;
    }

    public JGFormattedTextField createFormattedTextField(JFormattedTextField.AbstractFormatter formatter) {
        Preconditions.checkNotNull(formatter, "The %s must not be null.", "formatter");
        JGFormattedTextField field = new JGFormattedTextField(formatter);
        this.configure(field);
        return field;
    }

    public JGFormattedTextField createFormattedTextField(JFormattedTextField.AbstractFormatterFactory formatterFactory) {
        Preconditions.checkNotNull(formatterFactory, "The %s must not be null.", "formatter factory");
        JGFormattedTextField field = new JGFormattedTextField(formatterFactory);
        this.configure(field);
        return field;
    }

    @Override
    public JLabel createHeaderLabel(String markedText) {
        return this.createHeaderLabel(markedText, null);
    }

    public JLabel createHeaderLabel(String markedText, Object ... args) {
        JLabel label = this.createLabel(markedText, args);
        label.setFont(this.getHeaderFont());
        label.setForeground(this.getHeaderForeground());
        return label;
    }

    public JGHyperlink createHelpLink() {
        return this.createHelpLink("Help link " + buttonCounter++);
    }

    public JGHyperlink createHelpLink(Action action) {
        String text = (String)action.getValue("Name");
        Preconditions.checkNotBlank(text, "The %s must not be null, empty, or whitespace.", "help link text");
        JGComponentFactory.checkNoEndingEllipsis(text);
        JGComponentFactory.checkNoEndingDotOrExclamationMark(text);
        JGComponentFactory.checkNoMnemonic(action);
        JGHyperlink link = new JGHyperlink(action, false);
        this.configure(link);
        return link;
    }

    public JGHyperlink createHelpLink(String text) {
        Preconditions.checkNotBlank(text, "The %s must not be null, empty, or whitespace.", "help link text");
        JGComponentFactory.checkNoEndingEllipsis(text);
        JGComponentFactory.checkNoEndingDotOrExclamationMark(text);
        JGComponentFactory.checkNoMnemonic(text);
        JGHyperlink link = new JGHyperlink(null, text, false);
        this.configure(link);
        return link;
    }

    public JGHyperlink createHelpLink(String text, String url) {
        Preconditions.checkNotBlank(text, "The %s must not be null, empty, or whitespace.", "help link text");
        return this.createHelpLink(new HelpHyperlinkAction(text, url));
    }

    public JGFormattedTextField createIntegerField() {
        return this.createIntegerField(NumberFormat.getIntegerInstance(), null);
    }

    public JGFormattedTextField createIntegerField(int emptyNumber) {
        return this.createIntegerField(NumberFormat.getIntegerInstance(), emptyNumber);
    }

    public JGFormattedTextField createIntegerField(NumberFormat numberFormat) {
        return this.createIntegerField(numberFormat, null);
    }

    public JGFormattedTextField createIntegerField(NumberFormat numberFormat, int emptyNumber) {
        return this.createIntegerField(numberFormat, (Integer)emptyNumber);
    }

    public JGFormattedTextField createIntegerField(NumberFormat numberFormat, Integer emptyNumber) {
        NumberFormatter numberFormatter = new NumberFormatter(new EmptyNumberFormat(numberFormat, emptyNumber));
        numberFormatter.setValueClass(Integer.class);
        return this.createFormattedTextField(numberFormatter);
    }

    public JLabel createLabel() {
        return this.createLabel("");
    }

    @Override
    public JLabel createLabel(String markedText) {
        return this.createLabel(markedText, null);
    }

    public JLabel createLabel(String markedText, Object ... args) {
        return DefaultComponentFactory.getInstance().createLabel(Strings.get(markedText, args));
    }

    public <E> JList<E> createList(E ... items) {
        Preconditions.checkNotNull(items, "The %s must not be null.", items);
        return this.createList((ListCellRenderer)null, items);
    }

    public <E> JList<E> createList(List<E> items) {
        Preconditions.checkNotNull(items, "The %s must not be null.", items);
        return this.createList((ListCellRenderer)null, items);
    }

    public <E> JList<E> createList(ListCellRenderer<? super E> cellRenderer, E ... items) {
        return this.createList(cellRenderer, Arrays.asList(items));
    }

    public <E> JList<E> createList(ListCellRenderer<? super E> cellRenderer, List<E> items) {
        JList<? super E> list = new JList<E>(new Vector<E>(items));
        if (cellRenderer != null) {
            list.setCellRenderer(cellRenderer);
        }
        return list;
    }

    public <E> JList<E> createList(Function<E, String> displayStringFunction, E ... items) {
        return this.createList((ListCellRenderer<? super E>)new JGDefaultListCellRenderer<E>(displayStringFunction), items);
    }

    public <E> JList<E> createList(Function<E, String> displayStringFunction, List<E> items) {
        return this.createList((ListCellRenderer<? super E>)new JGDefaultListCellRenderer<E>(displayStringFunction), items);
    }

    public JGFormattedTextField createLongField() {
        return this.createLongField(NumberFormat.getIntegerInstance(), null);
    }

    public JGFormattedTextField createLongField(long emptyNumber) {
        return this.createLongField(NumberFormat.getIntegerInstance(), emptyNumber);
    }

    public JGFormattedTextField createLongField(NumberFormat numberFormat) {
        return this.createLongField(numberFormat, null);
    }

    public JGFormattedTextField createLongField(NumberFormat numberFormat, long emptyNumber) {
        return this.createLongField(numberFormat, (Long)emptyNumber);
    }

    public JGFormattedTextField createLongField(NumberFormat numberFormat, Long emptyNumber) {
        NumberFormatter numberFormatter = new NumberFormatter(new EmptyNumberFormat(numberFormat, emptyNumber));
        numberFormatter.setValueClass(Long.class);
        return this.createFormattedTextField(numberFormatter);
    }

    public JMenu createMenu() {
        return this.createMenu("Menu " + menuCounter++);
    }

    public JMenu createMenu(Action action) {
        JGMenu menu = new JGMenu(action);
        this.configure(menu);
        return menu;
    }

    public JMenu createMenu(String markedText) {
        Preconditions.checkNotBlank(markedText, "The %s must not be null, empty, or whitespace.", "menu text");
        JGMenu menu = new JGMenu();
        MnemonicUtils.configure(menu, markedText);
        this.configure(menu);
        return menu;
    }

    public JGMenuButton createMenuButton(JMenuItem ... items) {
        return this.createMenuButton(JGComponentFactory.createMenu(items));
    }

    public JGMenuButton createMenuButton(JPopupMenu menu) {
        String text = "Button " + buttonCounter++;
        return this.createMenuButton(ConsumerAction.noOp(text), menu);
    }

    public JGMenuButton createMenuButton(Action action, JMenuItem ... items) {
        return this.createMenuButton(action, JGComponentFactory.createMenu(items));
    }

    public JGMenuButton createMenuButton(Action action, JPopupMenu menu) {
        JGMenuButton button = new JGMenuButton(action, menu);
        this.configure(button);
        return button;
    }

    public JGMenuButton createMenuButton(String markedText, JMenuItem ... items) {
        return this.createMenuButton(markedText, JGComponentFactory.createMenu(items));
    }

    public JGMenuButton createMenuButton(String markedText, JPopupMenu menu) {
        JGMenuButton button = new JGMenuButton(null, null, menu);
        MnemonicUtils.configure(button, markedText);
        this.configure(button);
        return button;
    }

    public JMenuItem createMenuItem() {
        return this.createMenuItem("Item " + menuItemCounter++);
    }

    public JMenuItem createMenuItem(Action action) {
        JGMenuItem item = new JGMenuItem(action);
        this.configure(item);
        return item;
    }

    public JMenuItem createMenuItem(String markedText) {
        return this.createMenuItem(markedText, null);
    }

    public JMenuItem createMenuItem(String markedText, Icon icon) {
        Preconditions.checkNotBlank(markedText, "The %s must not be null, empty, or whitespace.", "menu item text");
        JGMenuItem item = new JGMenuItem(icon);
        MnemonicUtils.configure(item, markedText);
        this.configure(item);
        return item;
    }

    public JGHyperlink createNavigationLink() {
        return this.createNavigationLink("Navigation link " + buttonCounter++);
    }

    public JGHyperlink createNavigationLink(Action action) {
        String text = (String)action.getValue("Name");
        Preconditions.checkNotBlank(text, "The %s must not be null, empty, or whitespace.", "navigation link text");
        JGComponentFactory.checkNoEndingEllipsis(text);
        JGComponentFactory.checkNoEndingDotOrExclamationMark(text);
        JGComponentFactory.checkNoLeadingProtocol(text);
        JGComponentFactory.checkNoLeadingWWW(text);
        JGComponentFactory.checkNoMnemonic(action);
        JGHyperlink link = new JGHyperlink(action, true);
        link.setVisitedEnabled(true);
        this.configure(link);
        return link;
    }

    public JGHyperlink createNavigationLink(String text) {
        Preconditions.checkNotBlank(text, "The %s must not be null, empty, or whitespace.", "navigation link text");
        JGComponentFactory.checkNoEndingEllipsis(text);
        JGComponentFactory.checkNoEndingPunctuation(text);
        JGComponentFactory.checkNoMnemonic(text);
        JGComponentFactory.checkNoLeadingProtocol(text);
        JGComponentFactory.checkNoLeadingWWW(text);
        JGHyperlink link = new JGHyperlink(null, text, true);
        link.setVisitedEnabled(true);
        this.configure(link);
        return link;
    }

    public JGPasswordField createPasswordField() {
        return this.createPasswordField("");
    }

    public JGPasswordField createPasswordField(String text) {
        return this.createPasswordField(text, null);
    }

    public JGPasswordField createPasswordField(String text, String accessibleName) {
        JGPasswordField field = new JGPasswordField(text);
        field.getAccessibleContext().setAccessibleName(accessibleName);
        this.configure(field);
        return field;
    }

    public JRadioButton createRadioButton(String markedText) {
        return this.createRadioButton(markedText, null);
    }

    public JRadioButton createRadioButton(String markedText, String accessibleName) {
        Preconditions.checkNotBlank(markedText, "The text must not be null, empty, or whitespace.\nRadio buttons with empty text are difficult to hit with a mouse.\nAnd they may lack the focus indicator.");
        JRadioButton radioButton = new JRadioButton();
        radioButton.setContentAreaFilled(false);
        MnemonicUtils.configure(radioButton, markedText);
        this.configure(radioButton);
        radioButton.getAccessibleContext().setAccessibleName(accessibleName);
        return radioButton;
    }

    public JRadioButtonMenuItem createRadioButtonMenuItem() {
        return this.createRadioButtonMenuItem("Item " + menuItemCounter++);
    }

    public JRadioButtonMenuItem createRadioButtonMenuItem(Action action) {
        JGRadioButtonMenuItem item = new JGRadioButtonMenuItem(action);
        this.configure(item);
        return item;
    }

    public JRadioButtonMenuItem createRadioButtonMenuItem(String markedText) {
        return this.createRadioButtonMenuItem(markedText, null);
    }

    public JRadioButtonMenuItem createRadioButtonMenuItem(String markedText, Icon icon) {
        Preconditions.checkNotBlank(markedText, "The %s must not be null, empty, or whitespace.", "radio button menu item text");
        JGRadioButtonMenuItem item = new JGRadioButtonMenuItem(icon);
        MnemonicUtils.configure(item, markedText);
        this.configure(item);
        return item;
    }

    public JEditorPane createReadOnlyEditorPane(URL url) {
        return this.createReadOnlyEditorPane(url, this.getDefaultHyperlinkListener());
    }

    public JEditorPane createReadOnlyEditorPane(URL url, HyperlinkListener hyperlinkListener) {
        ReadOnlyEditorPane editorPane = new ReadOnlyEditorPane("text/html", "");
        editorPane.setFocusable(JSDLCommonSetup.isOptimizedForScreenReader());
        try {
            editorPane.setPage(url);
        }
        catch (IOException e) {
            throw new IllegalArgumentException("Could not set the URL " + url, e);
        }
        if (hyperlinkListener != null) {
            editorPane.addHyperlinkListener(hyperlinkListener);
        }
        return editorPane;
    }

    public JFormattedTextField createReadOnlyFormattedTextField(Format format) {
        return this.createReadOnlyFormattedTextField(format, null);
    }

    public JFormattedTextField createReadOnlyFormattedTextField(Format format, String accessibleName) {
        ReadOnlyFormattedTextField textField = new ReadOnlyFormattedTextField(format);
        textField.getAccessibleContext().setAccessibleName(accessibleName);
        return textField;
    }

    public JFormattedTextField createReadOnlyFormattedTextField(JFormattedTextField.AbstractFormatter formatter) {
        return new ReadOnlyFormattedTextField(formatter);
    }

    public JFormattedTextField createReadOnlyIntegerField() {
        return this.createReadOnlyIntegerField(NumberFormat.getIntegerInstance(), null);
    }

    public JFormattedTextField createReadOnlyIntegerField(int emptyNumber) {
        return this.createReadOnlyIntegerField(NumberFormat.getIntegerInstance(), emptyNumber);
    }

    public JFormattedTextField createReadOnlyIntegerField(NumberFormat numberFormat) {
        return this.createReadOnlyIntegerField(numberFormat, null);
    }

    public JFormattedTextField createReadOnlyIntegerField(NumberFormat numberFormat, int emptyNumber) {
        return this.createReadOnlyIntegerField(numberFormat, (Integer)emptyNumber);
    }

    public JFormattedTextField createReadOnlyIntegerField(NumberFormat numberFormat, Integer emptyNumber) {
        NumberFormatter numberFormatter = new NumberFormatter(new EmptyNumberFormat(numberFormat, emptyNumber));
        numberFormatter.setValueClass(Integer.class);
        return this.createReadOnlyFormattedTextField(numberFormatter);
    }

    @Override
    public JLabel createReadOnlyLabel(String markedText) {
        return this.createReadOnlyLabel(markedText, null);
    }

    public JLabel createReadOnlyLabel(String markedText, Object ... args) {
        return DefaultComponentFactory.getInstance().createReadOnlyLabel(Strings.get(markedText, args));
    }

    public JFormattedTextField createReadOnlyLongField() {
        return this.createReadOnlyLongField(NumberFormat.getIntegerInstance(), null);
    }

    public JFormattedTextField createReadOnlyLongField(long emptyNumber) {
        return this.createReadOnlyLongField(NumberFormat.getIntegerInstance(), emptyNumber);
    }

    public JFormattedTextField createReadOnlyLongField(NumberFormat numberFormat) {
        return this.createReadOnlyLongField(numberFormat, null);
    }

    public JFormattedTextField createReadOnlyLongField(NumberFormat numberFormat, long emptyNumber) {
        return this.createReadOnlyLongField(numberFormat, (Long)emptyNumber);
    }

    public JFormattedTextField createReadOnlyLongField(NumberFormat numberFormat, Long emptyNumber) {
        NumberFormatter numberFormatter = new NumberFormatter(new EmptyNumberFormat(numberFormat, emptyNumber));
        numberFormatter.setValueClass(Long.class);
        return this.createReadOnlyFormattedTextField(numberFormatter);
    }

    public <E> JGStripedTable<E> createReadOnlyTable() {
        JGStripedTable<E> table = this.createTable();
        if (!JSDLCommonSetup.isOptimizedForScreenReader()) {
            ComponentUtils.clearFocusTraversalKeys(table);
            JGComponentFactory.disableEnterBindings(table);
        }
        return table;
    }

    public <E> JGStripedTable<E> createReadOnlyTable(TableModel tableModel) {
        JGStripedTable<E> table = this.createReadOnlyTable();
        table.setModel(tableModel);
        return table;
    }

    public JTextArea createReadOnlyTextArea() {
        return this.createReadOnlyTextArea(null);
    }

    public JTextArea createReadOnlyTextArea(String text) {
        return this.createReadOnlyTextArea(text, null);
    }

    public JTextArea createReadOnlyTextArea(String text, String accessibleName) {
        ReadOnlyTextArea textArea = new ReadOnlyTextArea(text);
        textArea.setLineWrap(true);
        textArea.setWrapStyleWord(true);
        textArea.getAccessibleContext().setAccessibleName(accessibleName);
        return textArea;
    }

    public JGTextField createReadOnlyTextField() {
        return this.createReadOnlyTextField("");
    }

    public JGTextField createReadOnlyTextField(String text) {
        return this.createReadOnlyTextField(text, null);
    }

    public JGTextField createReadOnlyTextField(String text, String accessibleName) {
        ReadOnlyTextField field = new ReadOnlyTextField(text);
        field.getAccessibleContext().setAccessibleName(accessibleName);
        this.configure(field);
        return field;
    }

    public JScrollPane createScrollPane(Component component) {
        JScrollPane scrollPane = new JScrollPane(component);
        this.configure(scrollPane);
        return scrollPane;
    }

    public JGSearchField createSearchField(JGSearchField.SearchMode mode) {
        JGSearchField field = new JGSearchField(mode);
        this.configure(field);
        return field;
    }

    @Override
    public JComponent createSeparator(String markedText, int alignment) {
        return DefaultComponentFactory.getInstance().createSeparator(markedText, alignment);
    }

    public JGSplitButton createSplitButton(JMenuItem ... items) {
        return this.createSplitButton(JGComponentFactory.createMenu(items));
    }

    public JGSplitButton createSplitButton(JPopupMenu menu) {
        String text = "Button " + buttonCounter++;
        return this.createSplitButton(ConsumerAction.noOp(text), menu);
    }

    public JGSplitButton createSplitButton(Action action, JMenuItem ... items) {
        return this.createSplitButton(action, JGComponentFactory.createMenu(items));
    }

    public JGSplitButton createSplitButton(Action action, JPopupMenu menu) {
        JGSplitButton button = new JGSplitButton(action, menu);
        this.configure(button);
        return button;
    }

    public JGSplitButton createSplitButton(String markedText, JMenuItem ... items) {
        return this.createSplitButton(markedText, JGComponentFactory.createMenu(items));
    }

    public JGSplitButton createSplitButton(String markedText, JPopupMenu menu) {
        JGSplitButton button = new JGSplitButton(null, null, menu);
        MnemonicUtils.configure(button, markedText);
        this.configure(button);
        return button;
    }

    public JGSplitPane createSplitPane(int orientation, Component leftComponent, Component rightComponent) {
        JGSplitPane split = new JGSplitPane(orientation, leftComponent, rightComponent);
        split.setBorder(BorderFactory.createEmptyBorder());
        split.setOneTouchExpandable(false);
        return split;
    }

    public JGSplitPane createSplitPane(int orientation, Component leftComponent, Component rightComponent, double resizeWeight) {
        JGSplitPane split = this.createSplitPane(orientation, leftComponent, rightComponent);
        split.setResizeWeight(resizeWeight);
        return split;
    }

    public JTextComponent createStaticText(String plainOrHTMLText, Object ... args) {
        return this.createStaticText(Strings.get(plainOrHTMLText, args), this.getDefaultHyperlinkListener());
    }

    public JTextComponent createStaticText(String plainOrHTMLText, HyperlinkListener hyperlinkListener) {
        return BasicHTML.isHTMLString(plainOrHTMLText) ? this.createStaticHTMLPane(plainOrHTMLText, hyperlinkListener) : this.createStaticTextArea(plainOrHTMLText);
    }

    public JEditorPane createStaticHTMLText() {
        return this.createStaticHTMLText(null, null);
    }

    public JEditorPane createStaticHTMLText(HyperlinkListener hyperlinkListener) {
        return this.createStaticHTMLText(null, hyperlinkListener);
    }

    public JEditorPane createStaticHTMLText(URL url) {
        return this.createStaticHTMLText(url, null);
    }

    public JEditorPane createStaticHTMLText(URL url, HyperlinkListener hyperlinkListener) {
        JEditorPane editorPane = this.createStaticHTMLPane(null, hyperlinkListener);
        if (url != null) {
            try {
                editorPane.setPage(url);
            }
            catch (IOException e) {
                throw new IllegalArgumentException("Could not set the URL " + url, e);
            }
        }
        return editorPane;
    }

    public JScrollPane createStrippedScrollPane(Component component) {
        JScrollPane scrollPane = this.createScrollPane(component);
        scrollPane.setBorder(BorderFactory.createEmptyBorder());
        scrollPane.getVerticalScrollBar().putClientProperty("JScrollBar.isFreeStanding", Boolean.FALSE);
        scrollPane.getHorizontalScrollBar().putClientProperty("JScrollBar.isFreeStanding", Boolean.FALSE);
        return scrollPane;
    }

    public JTabbedPane createTabbedPane() {
        JTabbedPane pane = new JTabbedPane();
        pane.setRequestFocusEnabled(false);
        return pane;
    }

    public <E> JGStripedTable<E> createTable() {
        JGStripedTable table = new JGStripedTable();
        table.setDefaultRenderer(Boolean.class, this.getDefaultBooleanRenderer());
        table.setDefaultRenderer(LocalDate.class, this.getDefaultLocalDateRenderer());
        table.setDefaultRenderer(LocalDateTime.class, this.getDefaultLocalDateTimeRenderer());
        return table;
    }

    public <E> JGStripedTable<E> createTable(TableModel tableModel) {
        JGStripedTable<E> table = this.createTable();
        table.setModel(tableModel);
        return table;
    }

    public JGHyperlink createTaskLink() {
        return this.createTaskLink("Task link " + buttonCounter++);
    }

    public JGHyperlink createTaskLink(Action action) {
        String text = (String)action.getValue("Name");
        Preconditions.checkNotBlank(text, "The %s must not be null, empty, or whitespace.", "task link text");
        JGComponentFactory.checkNoEndingDotOrExclamationMark(text);
        JGComponentFactory.checkNoMnemonic(action);
        JGHyperlink link = new JGHyperlink(action, true);
        this.configure(link);
        return link;
    }

    public JGHyperlink createTaskLink(String text) {
        Preconditions.checkNotBlank(text, "The %s must not be null, empty, or whitespace.", "task link text");
        JGComponentFactory.checkNoMnemonic(text);
        JGComponentFactory.checkNoEndingPunctuation(text);
        JGHyperlink link = new JGHyperlink(null, text, false);
        this.configure(link);
        return link;
    }

    public JGTextField createTextField() {
        return this.createTextField("");
    }

    public JGTextField createTextField(String text) {
        return this.createTextField(text, null);
    }

    public JGTextField createTextField(String text, String accessibleName) {
        JGTextField textField = new JGTextField(text);
        textField.getAccessibleContext().setAccessibleName(accessibleName);
        this.configure(textField);
        return textField;
    }

    public JGTextArea createTextArea() {
        return this.createTextArea(null);
    }

    public JGTextArea createTextArea(String text) {
        return this.createTextArea(text, null);
    }

    public JGTextArea createTextArea(String text, String accessibleName) {
        JGTextArea textArea = new JGTextArea(text);
        textArea.setLineWrap(true);
        textArea.setWrapStyleWord(true);
        textArea.getAccessibleContext().setAccessibleName(accessibleName);
        ComponentUtils.clearFocusTraversalKeys(textArea);
        this.configure(textArea);
        return textArea;
    }

    @Override
    public JLabel createTitle(String markedText) {
        return this.createTitle(markedText, null);
    }

    public JLabel createTitle(String markedText, Object ... args) {
        return DefaultComponentFactory.getInstance().createTitle(Strings.get(markedText, args));
    }

    protected TableCellRenderer createDefaultBooleanRenderer() {
        return JGBooleanTableCellRenderer.INSTANCE;
    }

    protected TableCellRenderer createDefaultLocalDateRenderer() {
        return new JGFormatTableCellRenderer(new EmptyFormat(DateTimeFormatter.ofLocalizedDate(FormatStyle.MEDIUM).toFormat()));
    }

    protected TableCellRenderer createDefaultLocalDateTimeRenderer() {
        return new JGFormatTableCellRenderer(new EmptyFormat(DateTimeFormatter.ofLocalizedDateTime(FormatStyle.MEDIUM).toFormat()));
    }

    protected JEditorPane createStaticHTMLPane(String htmlText, HyperlinkListener hyperlinkListener) {
        StaticEditorPane editorPane = new StaticEditorPane("text/html", htmlText);
        editorPane.setMinimumSize(ScreenScaling.physicalDimension(150, 0));
        editorPane.setFocusable(JSDLCommonSetup.isOptimizedForScreenReader());
        FocusTraversalUtils.markAsStaticText(editorPane);
        if (hyperlinkListener == null) {
            hyperlinkListener = this.getDefaultHyperlinkListener();
        }
        if (hyperlinkListener != null) {
            editorPane.addHyperlinkListener(hyperlinkListener);
        }
        return editorPane;
    }

    protected JTextArea createStaticTextArea(String text) {
        StaticTextArea textArea = new StaticTextArea(text);
        textArea.setMinimumSize(ScreenScaling.physicalDimension(150, 0));
        textArea.setLineWrap(true);
        textArea.setWrapStyleWord(true);
        textArea.setFocusable(JSDLCommonSetup.isOptimizedForScreenReader());
        FocusTraversalUtils.markAsStaticText(textArea);
        return textArea;
    }

    protected void configure(AbstractButton button) {
    }

    protected void configure(JScrollPane scrollPane) {
    }

    protected void configure(JGTextArea area) {
        area.setSelectOnFocusGainEnabled(false);
    }

    protected void configure(JGTextField field) {
    }

    protected void configure(JGFormattedTextField field) {
    }

    protected void configure(JGPasswordField field) {
    }

    protected void configure(JGSearchField field) {
    }

    protected void configureMenuLink(JGHyperlink link) {
        link.setForeground(UIManager.getColor("controlText"));
        link.setVisitedEnabled(false);
    }

    public final void configureMenuLinks(JGHyperlink ... links) {
        for (JGHyperlink link : links) {
            this.configureMenuLink(link);
        }
    }

    protected Font getHeaderFont() {
        Font font = UIManager.getFont("AbstractStyledPane.header.font");
        if (font == null) {
            font = UIManager.getFont("Label.header.font");
        }
        return font;
    }

    protected Color getHeaderForeground() {
        Color foreground = UIManager.getColor("AbstractStyledPane.header.foreground");
        if (foreground == null) {
            foreground = UIManager.getColor("Label.header.foreground");
        }
        return foreground;
    }

    private TableCellRenderer getDefaultBooleanRenderer() {
        if (this.defaultBooleanRenderer == null) {
            this.defaultBooleanRenderer = this.createDefaultBooleanRenderer();
        }
        return this.defaultBooleanRenderer;
    }

    private TableCellRenderer getDefaultLocalDateRenderer() {
        if (this.defaultLocalDateRenderer == null) {
            this.defaultLocalDateRenderer = this.createDefaultLocalDateRenderer();
        }
        return this.defaultLocalDateRenderer;
    }

    private TableCellRenderer getDefaultLocalDateTimeRenderer() {
        if (this.defaultLocalDateTimeRenderer == null) {
            this.defaultLocalDateTimeRenderer = this.createDefaultLocalDateTimeRenderer();
        }
        return this.defaultLocalDateTimeRenderer;
    }

    private static void disableEnterBindings(JTable table) {
        InputMap inputMap = table.getInputMap(1);
        inputMap.put(ENTER, "dummy-binding effectively disabling ENTER");
        inputMap.put(SHIFT_ENTER, "dummy-binding effectively disabling shift ENTER");
    }

    private static JPopupMenu createMenu(JMenuItem ... items) {
        Preconditions.checkNotNullOrEmpty(items, "The %s must not be null or empty.", "menu items");
        JPopupMenu menu = new JPopupMenu();
        for (JMenuItem item : items) {
            menu.add(item);
        }
        return menu;
    }

    private static void checkEllipsis(String text) {
        Preconditions.checkArgument(text == null || !text.endsWith("..."), "The %s ends with three dots \"...\"; use the single ellipsis character '\u2026' (\\u2026) instead.", "text");
    }

    private static void checkNoEndingEllipsis(String text) {
        Preconditions.checkArgument(!text.endsWith("...") && !text.endsWith("\u2026"), "The text must not end with an ellipsis ('\u2026').");
    }

    private static void checkNoEndingPunctuation(String text) {
        Preconditions.checkArgument(!text.endsWith(".") && !text.endsWith("!") && !text.endsWith("?"), "The  text must not end with punctuation ('.', '!', '?').");
    }

    private static void checkNoEndingDotOrExclamationMark(String text) {
        Preconditions.checkArgument(!text.endsWith(".") && !text.endsWith("!"), "The text must not end with dot or exclamation mark ('.', '!').");
    }

    private static void checkNoLeadingProtocol(String text) {
        Preconditions.checkArgument(!Strings.startsWithIgnoreCase(text, "http://"), "The text must not start with \"http://\".");
    }

    private static void checkNoLeadingWWW(String text) {
        Preconditions.checkArgument(!Strings.startsWithIgnoreCase(text, "www"), "The text must not start with \"www.\".");
    }

    private static void checkNoMnemonic(Action action) {
        Object mnemonic = action.getValue("MnemonicKey");
        Preconditions.checkArgument(mnemonic == null || Integer.valueOf(0).equals(mnemonic), "The action must not set a mnemonic.");
    }

    private static void checkNoMnemonic(String text) {
        Preconditions.checkArgument(!MnemonicUtils.containsMarker(text), "The text must not contain a mnemonic marker ('_').");
    }

    static {
        buttonCounter = 1;
        menuCounter = 1;
        menuItemCounter = 1;
        ENTER = KeyStroke.getKeyStroke(10, 0);
        SHIFT_ENTER = KeyStroke.getKeyStroke(10, 1);
    }

    private static final class HelpHyperlinkAction
    extends AbstractAction {
        private final String url;

        private HelpHyperlinkAction(String text, String url) {
            super(Preconditions.checkNotBlank(text, "The %s must not be null, empty, or whitespace.", "text"));
            this.url = Preconditions.checkNotNull(url, "The %s must not be null.", "url");
        }

        @Override
        public void actionPerformed(ActionEvent evt) {
            HyperlinkEvent hyperlinkEvent = new HyperlinkEvent(evt.getSource(), HyperlinkEvent.EventType.ACTIVATED, null, this.url);
            HyperlinkListener handler = JGComponentFactory.getCurrent().getDefaultHyperlinkListener();
            if (handler == null) {
                throw new IllegalStateException("You must invoke JGComponentFactory#setDefaultHyperlinkListener before a text link can be clicked.");
            }
            handler.hyperlinkUpdate(hyperlinkEvent);
        }
    }
}

