/*
 * Decompiled with CFR 0.152.
 */
package com.jgoodies.components.internal;

import java.beans.PropertyChangeEvent;
import java.beans.PropertyChangeListener;
import java.lang.ref.WeakReference;
import javax.swing.event.DocumentEvent;
import javax.swing.event.DocumentListener;
import javax.swing.text.BadLocationException;
import javax.swing.text.DefaultHighlighter;
import javax.swing.text.Document;
import javax.swing.text.Highlighter;
import javax.swing.text.JTextComponent;

public abstract class AbstractUnderlineSupport {
    final String propertyNameEnabled = this.getClass().getName() + ".enabled";
    protected final String keyUnderlinePainterTag = this.getClass().getName() + ".underlinePainterTag";
    protected final String keyWeakDocumentUpdateHandler = this.getClass().getName() + ".weakDocumentUpdateHandler";
    private final PropertyChangeListener documentChangeHandler = this::onDocumentChange;

    public boolean isEnabled(JTextComponent c) {
        return Boolean.TRUE.equals(c.getClientProperty(this.propertyNameEnabled));
    }

    public void setEnabled(JTextComponent c, boolean newValue) {
        boolean oldValue = this.isEnabled(c);
        if (oldValue == newValue) {
            return;
        }
        c.putClientProperty(this.propertyNameEnabled, newValue);
        if (newValue) {
            this.install(c);
        } else {
            this.uninstall(c);
        }
        c.repaint();
    }

    protected void install(JTextComponent c) {
        c.addPropertyChangeListener("document", this.documentChangeHandler);
        this.installDocumentUpdateHandler(c);
        this.updateUnderline(c);
    }

    protected void uninstall(JTextComponent c) {
        c.removePropertyChangeListener("document", this.documentChangeHandler);
        this.uninstallDocumentUpdateHandler(c, c.getDocument());
        Object tag = c.getClientProperty(this.keyUnderlinePainterTag);
        if (tag != null) {
            c.getHighlighter().removeHighlight(tag);
            c.putClientProperty(this.keyUnderlinePainterTag, null);
        }
    }

    protected void updateUnderline(JTextComponent c) {
        Highlighter highlighter = c.getHighlighter();
        int length = c.getDocument().getLength();
        Object tag = c.getClientProperty(this.keyUnderlinePainterTag);
        try {
            if (tag == null) {
                tag = highlighter.addHighlight(0, length, this.createHighlightPainter());
                c.putClientProperty(this.keyUnderlinePainterTag, tag);
            } else {
                highlighter.changeHighlight(tag, 0, length);
            }
        }
        catch (BadLocationException badLocationException) {
            // empty catch block
        }
    }

    protected abstract DefaultHighlighter.DefaultHighlightPainter createHighlightPainter();

    private void installDocumentUpdateHandler(JTextComponent c) {
        DocumentUpdateHandler handler = new DocumentUpdateHandler(c);
        c.getDocument().addDocumentListener(handler);
        c.putClientProperty(this.keyWeakDocumentUpdateHandler, new WeakReference<DocumentUpdateHandler>(handler));
    }

    private void uninstallDocumentUpdateHandler(JTextComponent c, Document oldDocument) {
        DocumentListener handler = this.getDocumentUpdateHandler(c);
        if (handler != null) {
            oldDocument.removeDocumentListener(handler);
        }
        c.putClientProperty(this.keyWeakDocumentUpdateHandler, null);
    }

    private DocumentListener getDocumentUpdateHandler(JTextComponent c) {
        Object value = c.getClientProperty(this.keyWeakDocumentUpdateHandler);
        if (value == null || !(value instanceof WeakReference)) {
            return null;
        }
        return (DocumentListener)((WeakReference)value).get();
    }

    private void onDocumentChange(PropertyChangeEvent evt) {
        JTextComponent target = (JTextComponent)evt.getSource();
        Document oldDocument = (Document)evt.getOldValue();
        this.uninstallDocumentUpdateHandler(target, oldDocument);
        this.installDocumentUpdateHandler(target);
    }

    private final class DocumentUpdateHandler
    implements DocumentListener {
        private final JTextComponent target;

        DocumentUpdateHandler(JTextComponent target) {
            this.target = target;
        }

        @Override
        public void insertUpdate(DocumentEvent e) {
            AbstractUnderlineSupport.this.updateUnderline(this.target);
        }

        @Override
        public void removeUpdate(DocumentEvent e) {
            AbstractUnderlineSupport.this.updateUnderline(this.target);
        }

        @Override
        public void changedUpdate(DocumentEvent e) {
            AbstractUnderlineSupport.this.updateUnderline(this.target);
        }
    }
}

