/*
 * Decompiled with CFR 0.152.
 */
package com.jgoodies.dialogs.core.plaf.basic;

import com.jgoodies.common.base.Strings;
import com.jgoodies.common.base.SystemUtils;
import com.jgoodies.common.swing.MnemonicUtils;
import com.jgoodies.common.swing.focus.FocusTraversalUtils;
import com.jgoodies.components.JGComponentFactory;
import com.jgoodies.dialogs.core.pane.task.TaskPane;
import com.jgoodies.dialogs.core.pane.task.TaskPaneVisualConfiguration;
import com.jgoodies.dialogs.core.plaf.basic.BasicAbstractStyledPaneUI;
import com.jgoodies.layout.builder.ButtonBarBuilder;
import com.jgoodies.layout.builder.FormBuilder;
import com.jgoodies.layout.factories.CC;
import com.jgoodies.layout.factories.Paddings;
import com.jgoodies.layout.layout.CellConstraints;
import com.jgoodies.layout.layout.Sizes;
import java.awt.Color;
import java.awt.Component;
import java.awt.FontMetrics;
import java.awt.Insets;
import java.awt.event.ActionEvent;
import java.beans.PropertyChangeEvent;
import java.beans.PropertyChangeListener;
import javax.swing.ButtonModel;
import javax.swing.Icon;
import javax.swing.JCheckBox;
import javax.swing.JComponent;
import javax.swing.JLabel;
import javax.swing.JProgressBar;
import javax.swing.JToggleButton;
import javax.swing.UIManager;
import javax.swing.event.ChangeEvent;
import javax.swing.plaf.ComponentUI;
import javax.swing.text.JTextComponent;

public class BasicTaskPaneUI
extends BasicAbstractStyledPaneUI {
    protected TaskPane taskPane;
    protected JComponent mainInstructionComponent;
    protected JComponent defaultContent;
    protected JTextComponent contentTextComponent;
    protected JTextComponent expandedTextComponent;
    protected JProgressBar progressBar;
    protected JToggleButton expansionControl;

    public static ComponentUI createUI(JComponent x) {
        return new BasicTaskPaneUI();
    }

    @Override
    public void installUI(JComponent component) {
        this.taskPane = (TaskPane)component;
        super.installUI(component);
    }

    @Override
    public void uninstallUI(JComponent c) {
        super.uninstallUI(c);
        this.taskPane = null;
    }

    @Override
    protected void installComponents() {
        FormBuilder builder = (FormBuilder)((FormBuilder)new FormBuilder().columns(this.getHorizontalLayoutSpec(), new Object[0])).rows(this.getVerticalLayoutSpec(), new Object[0]);
        TaskPaneVisualConfiguration visualConfiguration = (TaskPaneVisualConfiguration)this.taskPane.getVisualConfiguration();
        Color dialogBackground = this.abstractStyledPane.getBackground();
        if (dialogBackground != null) {
            builder.background(dialogBackground);
        }
        if (this.hasMainInstructionText()) {
            int mainInstructionHeight;
            int mainIconHeight;
            JComponent mainIcon = null;
            if (this.hasMainInstructionIcon()) {
                mainIcon = this.buildMainIcon();
                int iconRowHeight = this.getMainIconRowHeight();
                builder.add(mainIcon).xywh(2, 2, 1, iconRowHeight, "right, top");
            }
            this.mainInstructionComponent = this.buildMainInstruction();
            FontMetrics fontMetrics = this.mainInstructionComponent.getFontMetrics(this.mainInstructionComponent.getFont());
            int descent = fontMetrics.getDescent();
            int yOffset = (descent - 1) * -2;
            if (mainIcon != null && (mainIconHeight = ((Component)mainIcon).getPreferredSize().height) > (mainInstructionHeight = this.mainInstructionComponent.getPreferredSize().height)) {
                yOffset = 0;
            }
            Insets mainOffset = new Insets(yOffset, 0, 0, 0);
            CellConstraints mainConstraints = new CellConstraints(3, 2, 1, 1, CellConstraints.DEFAULT, CellConstraints.CENTER, mainOffset);
            builder.add(this.mainInstructionComponent).at(mainConstraints);
        }
        builder.add(visualConfiguration.getHeaderArea()).xywh(1, 1, 4, 3, "fill, fill");
        int contentXStart = this.getContentXStart();
        int contentWidth = this.getContentXEnd() - contentXStart;
        JComponent content = this.getContent();
        if (content != null) {
            builder.add(content).xyw(contentXStart, 5, contentWidth);
            if (this.mainInstructionComponent instanceof JLabel) {
                ((JLabel)this.mainInstructionComponent).setLabelFor(content);
            }
        }
        if (this.hasExpandedText()) {
            this.expandedTextComponent = this.buildExpandedTextComponent();
            builder.add(this.expandedTextComponent).xyw(contentXStart, 6, contentWidth);
        }
        builder.add(visualConfiguration.getContentArea()).xywh(1, 4, 4, 4);
        if (this.taskPane.isProgressVisible()) {
            builder.add(this.buildProgressComponent()).xyw(2, 7, 2);
        }
        builder.add(this.taskPane.getRadioButtonPanel()).xy(3, 8);
        builder.add(this.taskPane.getCommandLinkPanel()).xy(3, 9);
        if (visualConfiguration.isCommandContentVisible()) {
            JComponent commandContent = this.buildCommandContent();
            builder.add(commandContent).xyw(2, 11, 2, CellConstraints.FILL, CellConstraints.CENTER);
            builder.add(visualConfiguration.getCommandArea()).xyw(1, 11, 4);
        }
        this.abstractStyledPane.add((Component)builder.build(), CC.xy(1, 1));
    }

    @Override
    protected void uninstallComponents() {
        super.uninstallComponents();
        this.mainInstructionComponent = null;
        this.defaultContent = null;
        this.contentTextComponent = null;
        this.expandedTextComponent = null;
        this.progressBar = null;
    }

    protected final int getMainIconRowHeight() {
        TaskPaneVisualConfiguration.MainInstructionIconVerticalAlignment alignment = ((TaskPaneVisualConfiguration)this.taskPane.getVisualConfiguration()).getMainInstructionIconVerticalAlignment();
        switch (alignment) {
            case MAIN_INSTRUCTION: {
                return 1;
            }
            case MAIN_INSTRUCTION_AND_CONTENT: {
                return 3;
            }
        }
        throw new IllegalStateException("Unknown main icon alignment: " + (Object)((Object)alignment));
    }

    @Override
    protected PropertyChangeListener createPropertyChangeListener() {
        return new TaskPanePropertyChangeHandler();
    }

    @Override
    protected JComponent buildCommandContent() {
        JComponent commandBar;
        FormBuilder builder = (FormBuilder)((FormBuilder)new FormBuilder().columns("pref, pref:grow", new Object[0])).rows("p, p", new Object[0]);
        if (this.hasExpansionControl() && this.hasVerificationCheckBox()) {
            builder.padding(Paddings.createPadding(Sizes.DLU5, Sizes.ZERO, Sizes.DLU3, Sizes.ZERO));
        }
        ButtonBarBuilder buttonBarBuilder = new ButtonBarBuilder();
        if (this.hasExpansionControl()) {
            builder.add(this.getExpansionControl()).xy(1, 1);
            buttonBarBuilder.addGap(Sizes.DLU14);
            if (this.hasVerificationCheckBox()) {
                JCheckBox checkBox = this.createVerificationCheckBox();
                checkBox.setMargin(new Insets(3, 3, 3, 0));
                builder.add(checkBox).xy(1, 2);
            }
        } else if (this.hasVerificationCheckBox()) {
            builder.add(this.createVerificationCheckBox()).xy(1, 1);
            buttonBarBuilder.addGap(Sizes.DLU14);
        }
        if ((commandBar = this.abstractStyledPane.getCommandBar()) != null) {
            buttonBarBuilder.addGrowing(commandBar);
        }
        return ((FormBuilder)builder.add(buttonBarBuilder.build()).xy(2, 1)).build();
    }

    protected JComponent getContent() {
        if (this.taskPane.getContent() != null) {
            return this.taskPane.getContent();
        }
        this.defaultContent = this.buildDefaultContent();
        return this.defaultContent;
    }

    protected JComponent buildMainIcon() {
        String borderString = String.format("0, 0, 0, %sdlu", ((TaskPaneVisualConfiguration)this.taskPane.getVisualConfiguration()).getGapMainInstructionIconText());
        JLabel label = new JLabel(this.taskPane.getMainInstructionIcon());
        label.setName("mainIcon");
        label.setBorder(Paddings.createPadding(borderString, new Object[0]));
        return label;
    }

    protected JComponent buildMainInstruction() {
        JGComponentFactory factory = JGComponentFactory.getCurrent();
        JLabel c = this.taskPane.getMainInstructionLabelsContent() ? factory.createLabel(this.taskPane.getMainInstructionText()) : factory.createStaticText(this.taskPane.getMainInstructionText(), new Object[0]);
        c.setFont(((TaskPaneVisualConfiguration)this.taskPane.getVisualConfiguration()).getHeaderFont());
        c.setForeground(((TaskPaneVisualConfiguration)this.taskPane.getVisualConfiguration()).getHeaderForeground());
        c.setName("mainInstruction");
        return c;
    }

    protected JComponent buildDefaultContent() {
        this.contentTextComponent = this.buildContentTextComponent();
        return this.contentTextComponent;
    }

    protected JTextComponent buildContentTextComponent() {
        if (!this.hasContentText()) {
            return null;
        }
        return this.createStaticText(this.taskPane.getContentText());
    }

    protected JTextComponent buildExpandedTextComponent() {
        if (!this.hasExpandedText()) {
            return null;
        }
        this.expandedTextComponent = this.createStaticText(this.taskPane.getExpandedText());
        this.expandedTextComponent.setVisible(this.taskPane.isExpanded());
        this.expandedTextComponent.setName("expandedText");
        return this.expandedTextComponent;
    }

    protected JProgressBar getProgressBar() {
        if (this.progressBar == null) {
            this.progressBar = new JProgressBar();
            this.progressBar.setIndeterminate(this.taskPane.isProgressIndeterminate());
            this.progressBar.setValue(this.taskPane.getProgressValue());
            this.progressBar.setName("progressBar");
        }
        return this.progressBar;
    }

    protected JComponent buildProgressComponent() {
        return ((FormBuilder)((FormBuilder)((FormBuilder)new FormBuilder().columns("fill:pref:grow", new Object[0])).rows("6dlu, pref, 6dlu", new Object[0])).add(this.getProgressBar()).xy(1, 2)).build();
    }

    private JToggleButton getExpansionControl() {
        if (this.expansionControl == null) {
            this.expansionControl = this.createExpansionControl();
        }
        this.updateExpansionState();
        return this.expansionControl;
    }

    protected JToggleButton createExpansionControl() {
        Icon deselectedIcon = UIManager.getIcon("CollapsedControl.icon");
        Icon rolloverIcon = UIManager.getIcon("CollapsedControl.rolloverIcon");
        Icon selectedIcon = UIManager.getIcon("ExpandedControl.icon");
        Icon rolloverSelectedIcon = UIManager.getIcon("ExpandedControl.rolloverIcon");
        JCheckBox checkBox = new JCheckBox("more/less", deselectedIcon);
        checkBox.setName("expansion");
        checkBox.setSelectedIcon(selectedIcon);
        checkBox.setRolloverIcon(rolloverIcon);
        checkBox.setRolloverSelectedIcon(rolloverSelectedIcon);
        checkBox.setContentAreaFilled(false);
        checkBox.setRolloverEnabled(true);
        FocusTraversalUtils.markAsPoorDefaultFocusOwner(checkBox);
        if (SystemUtils.IS_OS_MAC) {
            checkBox.putClientProperty("JComponent.sizeVariant", "regular");
            checkBox.putClientProperty("JButton.buttonType", "normal");
        }
        checkBox.addActionListener(this::onExpansionPerformed);
        return checkBox;
    }

    protected void updateExpansionState() {
        boolean expanded = this.taskPane.isExpanded();
        if (this.expansionControl != null) {
            this.expansionControl.setSelected(expanded);
            String markedText = expanded ? this.taskPane.getExpandedControlText() : this.taskPane.getCollapsedControlText();
            MnemonicUtils.configure(this.expansionControl, markedText);
            this.expansionControl.setPressedIcon(expanded ? UIManager.getIcon("ExpandedControl.pressedIcon") : UIManager.getIcon("CollapsedControl.pressedIcon"));
        }
        if (this.expandedTextComponent != null) {
            this.expandedTextComponent.setVisible(expanded);
        }
    }

    protected JCheckBox createVerificationCheckBox() {
        JGComponentFactory factory = JGComponentFactory.getCurrent();
        JCheckBox box = factory.createCheckBox(this.taskPane.getVerificationText());
        box.setName("verification");
        FocusTraversalUtils.markAsPoorDefaultFocusOwner(box);
        box.setSelected(this.taskPane.isVerificationSelected());
        box.getModel().addChangeListener(this::onVerificationSelectionChanged);
        return box;
    }

    protected JTextComponent createStaticText(String text) {
        return JGComponentFactory.getCurrent().createStaticText(text, this.taskPane.getHyperlinkListener());
    }

    @Override
    protected String getVerticalLayoutSpec() {
        TaskPaneVisualConfiguration visualConfiguration = (TaskPaneVisualConfiguration)this.taskPane.getVisualConfiguration();
        boolean hasDefaultText = this.hasContentText() || this.hasExpandedText();
        return String.format("%1$sdlu, p, %2$sdlu, %3$sdlu, %4$s, p, p, p, p, %5$sdlu%6$s, f:[%7$sdlu,p]", visualConfiguration.getMarginHeaderTop(), visualConfiguration.getMarginHeaderBottom(), visualConfiguration.getMarginContentTop(), hasDefaultText ? "p" : "f:p:g", visualConfiguration.getMarginContentBottom(), hasDefaultText ? ":grow" : "", visualConfiguration.isCommandContentVisible() ? visualConfiguration.getMinHeightCommandArea() : 0);
    }

    protected final boolean hasMainInstructionIcon() {
        return this.taskPane.getMainInstructionIcon() != null;
    }

    protected final boolean hasMainInstructionText() {
        return Strings.isNotBlank(this.taskPane.getMainInstructionText());
    }

    protected final boolean hasContentText() {
        return Strings.isNotBlank(this.taskPane.getContentText());
    }

    protected final boolean hasExpansionControl() {
        return Strings.isNotBlank(this.taskPane.getExpandedControlText()) && Strings.isNotBlank(this.taskPane.getCollapsedControlText());
    }

    protected final boolean hasExpandedText() {
        return Strings.isNotBlank(this.taskPane.getExpandedText());
    }

    protected final boolean hasVerificationCheckBox() {
        return Strings.isNotBlank(this.taskPane.getVerificationText());
    }

    @Override
    protected boolean propertyRequiresNoUIHandling(String name) {
        return super.propertyRequiresNoUIHandling(name) || "progressValue".equals(name) || "radioValue".equals(name) || "verificationSelected".equals(name);
    }

    @Override
    protected boolean propertyRequiresRevalidation(String name) {
        return super.propertyRequiresRevalidation(name) || "gapMainInstructionIconText".equals(name);
    }

    private void onExpansionPerformed(ActionEvent e) {
        this.taskPane.setExpanded(!this.taskPane.isExpanded());
    }

    private void onVerificationSelectionChanged(ChangeEvent e) {
        ButtonModel model = (ButtonModel)e.getSource();
        this.taskPane.setVerificationSelected(model.isSelected());
    }

    protected class TaskPanePropertyChangeHandler
    extends BasicAbstractStyledPaneUI.BasicPropertyChangeHandler {
        protected TaskPanePropertyChangeHandler() {
        }

        @Override
        public void propertyChange(PropertyChangeEvent evt) {
            switch (evt.getPropertyName()) {
                case "expanded": {
                    BasicTaskPaneUI.this.updateExpansionState();
                    break;
                }
                case "progressVisible": {
                    this.reinstall();
                    break;
                }
                case "progressValue": {
                    BasicTaskPaneUI.this.getProgressBar().setValue(BasicTaskPaneUI.this.taskPane.getProgressValue());
                    break;
                }
                case "progressIndeterminate": {
                    BasicTaskPaneUI.this.getProgressBar().setIndeterminate(BasicTaskPaneUI.this.taskPane.isProgressIndeterminate());
                    break;
                }
                default: {
                    super.propertyChange(evt);
                }
            }
        }
    }
}

