/*
 * Decompiled with CFR 0.152.
 */
package com.jgoodies.fluent;

import com.jgoodies.common.base.Preconditions;

public final class Badge {
    public static final Badge NONE = new Badge(0);
    public static final Badge ACTIVITY = new Badge('a');
    public static final Badge ALARM = new Badge('b');
    public static final Badge ALERT = new Badge('c');
    public static final Badge ATTENTION = new Badge('d');
    public static final Badge AVAILABLE = new Badge('e');
    public static final Badge AWAY = new Badge('f');
    public static final Badge BUSY = new Badge('g');
    public static final Badge ERROR = new Badge('a');
    public static final Badge NEW_MESSAGE = new Badge('a');
    public static final Badge PAUSED = new Badge('a');
    public static final Badge PLAYING = new Badge('a');
    public static final Badge UNAVAILABLE = new Badge('a');
    private final char glyph;
    private final int value;

    private Badge(char glyph) {
        this.glyph = glyph;
        this.value = -1;
    }

    public Badge(int value) {
        Preconditions.checkArgument(value >= 0, "The value must not be negative.");
        this.value = value;
        this.glyph = (char)65535;
    }

    public boolean isNumeric() {
        return this.glyph == '\uffff';
    }

    public boolean isPositiveNumeric() {
        return this.isNumeric() && this.value != 0;
    }

    public int value() {
        Preconditions.checkState(this.isNumeric(), "Values are available for the numeric badges only.");
        return this.value;
    }

    public String displayString() {
        if (!this.isNumeric()) {
            return Character.toString(this.glyph);
        }
        if (this.value == 0) {
            return "";
        }
        if (this.value > 99) {
            return "99+";
        }
        return Integer.toString(this.value);
    }
}

