/*
 * Decompiled with CFR 0.152.
 */
package com.jgoodies.framework.action;

import com.jgoodies.common.base.Preconditions;
import com.jgoodies.common.jsdl.action.ActionGroup;
import com.jgoodies.components.JGComponentFactory;
import com.jgoodies.framework.action.DefaultMenuBuilder;
import javax.swing.Action;
import javax.swing.JPopupMenu;

public final class DefaultPopupMenuBuilder
implements ActionGroup.ActionGroupBuilder {
    private final JPopupMenu menu;
    private final JGComponentFactory factory;

    public DefaultPopupMenuBuilder() {
        this(new JPopupMenu(), JGComponentFactory.getCurrent());
    }

    public DefaultPopupMenuBuilder(JPopupMenu menu) {
        this(menu, JGComponentFactory.getCurrent());
    }

    public DefaultPopupMenuBuilder(JPopupMenu menu, JGComponentFactory factory) {
        Preconditions.checkNotNull(menu, "The %s must not be null.", "popup menu");
        Preconditions.checkNotNull(factory, "The %s must not be null.", "component factory");
        this.menu = menu;
        this.factory = factory;
    }

    public static JPopupMenu popupMenuFor(ActionGroup group) {
        DefaultPopupMenuBuilder builder = new DefaultPopupMenuBuilder();
        group.build(builder);
        return builder.build();
    }

    @Override
    public void setLabelAction(Action labelAction) {
        if (labelAction != null) {
            this.menu.setLabel((String)labelAction.getValue("Name"));
        }
    }

    @Override
    public void add(Action action) {
        this.menu.add(this.factory.createMenuItem(action));
    }

    @Override
    public void add(ActionGroup group) {
        DefaultMenuBuilder submenuBuilder = new DefaultMenuBuilder();
        group.build(submenuBuilder);
        this.menu.add(submenuBuilder.build());
    }

    @Override
    public void addSeparator() {
        this.menu.addSeparator();
    }

    public JPopupMenu build() {
        int count;
        if (this.menu.getComponentCount() > 0 && this.menu.getComponent(0) instanceof JPopupMenu.Separator) {
            this.menu.remove(0);
        }
        if ((count = this.menu.getComponentCount()) > 0 && this.menu.getComponent(count - 1) instanceof JPopupMenu.Separator) {
            this.menu.remove(count - 1);
        }
        return this.menu;
    }
}

