/*
 * Decompiled with CFR 0.152.
 */
package com.jgoodies.framework.osx;

import com.jgoodies.common.base.SystemUtils;
import com.jgoodies.framework.osx.OSXApplicationHandler8;
import com.jgoodies.framework.osx.OSXApplicationHandler9;
import java.awt.event.ActionListener;
import java.util.logging.Logger;

public final class OSXApplicationMenu {
    private static final String KEY_MAC_APPLICATION_MENU_ABOUT_NAME = "apple.awt.application.name";
    static ActionListener aboutListener;
    static ActionListener prefsListener;
    private static boolean registered;

    private OSXApplicationMenu() {
    }

    public static void setAboutName(String aboutName) {
        try {
            System.setProperty(KEY_MAC_APPLICATION_MENU_ABOUT_NAME, aboutName);
        }
        catch (SecurityException ex) {
            Logger.getLogger(OSXApplicationMenu.class.getName()).warning("Can set the OS X application menu name only in trusted environments.");
        }
    }

    public static synchronized boolean register(ActionListener about, ActionListener preferences) {
        if (about == null && preferences == null) {
            return false;
        }
        aboutListener = about;
        prefsListener = preferences;
        registered = OSXApplicationMenu.register();
        return registered;
    }

    public static boolean isRegisteredAbout() {
        return registered && aboutListener != null;
    }

    public static boolean isRegisteredPreferences() {
        return registered && prefsListener != null;
    }

    public static boolean isRegistered() {
        return registered;
    }

    private static boolean register() {
        if (!SystemUtils.IS_OS_MAC) {
            return false;
        }
        if (SystemUtils.IS_JAVA_8) {
            OSXApplicationHandler8.register();
        } else {
            OSXApplicationHandler9.register();
        }
        return true;
    }

    static {
        registered = false;
    }
}

