/*
 * Decompiled with CFR 0.152.
 */
package com.jgoodies.sandbox.basics.combo;

import com.jgoodies.common.base.Preconditions;
import com.jgoodies.components.internal.TextFieldIcons;
import com.jgoodies.dialogs.core.CommandValue;
import com.jgoodies.dialogs.core.CoreDialogResources;
import com.jgoodies.dialogs.core.util.JSDLUtils;
import com.jgoodies.sandbox.basics.combo.FieldButtonCombo;
import com.jgoodies.sandbox.basics.combo.FieldButtonComboBuilder;
import com.jgoodies.sandbox.completion.FilenameCompletionProcessor;
import com.jgoodies.search.CompletionManager;
import java.awt.Dialog;
import java.awt.FileDialog;
import java.awt.Frame;
import java.awt.Window;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import javax.swing.Icon;

public final class FilenameBrowseComboBuilder {
    private final FieldButtonCombo combo = new FieldButtonComboBuilder().actionListener(new BrowseActionListener()).build();
    private final FilenameCompletionProcessor completionProcessor;
    private final FilenameCompletionProcessor.Mode mode = FilenameCompletionProcessor.Mode.FILES_AND_DIRECTORIES;

    public FilenameBrowseComboBuilder() {
        this.completionProcessor = new FilenameCompletionProcessor(this.mode);
        new CompletionManager(this.completionProcessor).install(this.combo.getField());
        this.defaultButtonText();
    }

    public FilenameBrowseComboBuilder autoCompletionEnabled(boolean b) {
        this.getManager().setAutoCompletionEnabled(b);
        return this;
    }

    public FilenameBrowseComboBuilder completionPrototypeDisplayValue(String prototypeDisplayValue) {
        this.getManager().setCompletionPrototypeDisplayValue(prototypeDisplayValue);
        return this;
    }

    public FilenameBrowseComboBuilder defaultButtonText() {
        this.combo.setButtonText(CommandValue.BROWSE.getMarkedText());
        return this;
    }

    public FilenameBrowseComboBuilder fieldIcon(Icon icon) {
        this.combo.setFieldIcon(icon);
        return this;
    }

    public FilenameBrowseComboBuilder fieldText(String text) {
        this.combo.setFieldText(text);
        return this;
    }

    public FilenameBrowseComboBuilder fieldPrompt(String prompt) {
        this.combo.setFieldPrompt(prompt);
        return this;
    }

    public FilenameBrowseComboBuilder mode(FilenameCompletionProcessor.Mode mode) {
        mode = Preconditions.checkNotNull(mode, "The %s must not be null.", "mode");
        this.completionProcessor.setMode(mode);
        return this;
    }

    public FilenameBrowseComboBuilder prefixCompletionEnabled(boolean b) {
        this.getManager().setPrefixCompletionEnabled(b);
        return this;
    }

    public FilenameBrowseComboBuilder searchIcon() {
        this.fieldIcon(TextFieldIcons.getSearchIcon());
        return this;
    }

    public FilenameBrowseComboBuilder shortButtonText() {
        this.combo.setButtonText(CoreDialogResources.getString("common.browse.short"));
        return this;
    }

    public FieldButtonCombo build() {
        return this.combo;
    }

    private CompletionManager getManager() {
        return CompletionManager.getManager(this.combo.getField());
    }

    final class BrowseActionListener
    implements ActionListener {
        BrowseActionListener() {
        }

        @Override
        public void actionPerformed(ActionEvent evt) {
            Window parent = JSDLUtils.getWindowFor(evt);
            String title = "Choose a File";
            FileDialog dialog = parent instanceof Frame ? new FileDialog((Frame)parent) : new FileDialog((Dialog)parent);
            dialog.setTitle(title);
            dialog.setResizable(true);
            dialog.setVisible(true);
            FilenameBrowseComboBuilder.this.combo.setFieldText(dialog.getFile());
        }
    }
}

