<sect1 id="hd44780-howto">
<title>The HD44780 Driver</title>

<para>
The HD44780 has become the de-facto standard of alphanumeric character displays.
Although the original Hitachi HD44780 is long out of production, its command
set has survived in a variety of (fully or nearly) compatible LCD, VFD and
even OLED displays sold by a broad range of manufacturers all over the world.
To name only a few: KS0066, KS0070, KS0076, LC7985, NT3881, SED1278, ST7066 ...
</para>

<para>
The command set of these displays, which sometimes are advertised as being
"industry standards compatible", is thus the workhorse of controllers for
displays ranging from 8x1 to 20x4 or 40x2 characters.
There are even displays with larger dimensions sporting two controllers,
one for each half of the display.
</para>

<para>
The HD44780 driver supports various ways of connecting HD44780 devices
to your system.
Each of these different ways is called a <emphasis>connection type</emphasis>
of the driver.
</para>

<para>
Depending on the connection type and the display connected, the driver supports
various special features.
<itemizedlist>
  <listitem><para>Input keys</para></listitem>
  <listitem><para>Software controllable brightness / backlight</para></listitem>
  <listitem><para>Software controllable contrast</para></listitem>
  <listitem><para>multiple displays / multi-controller displays</para></listitem>
</itemizedlist>
</para>

<para>
The following table lists the available connection types, sorted by the kind
of connection (parallel port, serial port, USB, I2C, SPI or others).
</para>

<para>
  <table id="hd44780-connection-types">
  <title>HD44780: Connection Types</title>
  <tgroup cols="2" align="left">
    <colspec colname="conectionName"/>
    <colspec colname="conectionDesc"/>
    <spanspec spanname="fullwidth" namest="conectionName" nameend="conectionDesc"/>
    <thead>
      <row>
        <entry>ConnectionType</entry>
        <entry>Wiring / Display Type</entry>
      </row>
    </thead>
    <tbody>
      <!-- parallel -->
      <row>
        <entry spanname="fullwidth">Parallel port connection types:</entry>
      </row>
      <row>
        <entry><literal><link linkend="hd44780-4bit">4bit</link></literal></entry>
        <entry>4-bit wiring. This is the default.</entry>
      </row>
      <row>
        <entry><literal><link linkend="hd44780-8bit-lcdtime">8bit</link></literal></entry>
        <entry>8-bit wiring ("lcdtime" style)</entry>
      </row>
      <row>
        <entry><literal><link linkend="hd44780-8bit-winamp">winamp</link></literal></entry>
        <entry>8-bit wiring ("winamp" style)</entry>
      </row>
      <row>
        <entry><literal><link linkend="hd44780-seriallpt">serialLpt</link></literal></entry>
        <entry>Serial LPT wiring</entry>
      </row>
      <!-- serial -->
      <row>
        <entry spanname="fullwidth">Serial (RS-232) connection types:</entry>
      </row>
      <row>
        <entry><literal><link linkend="hd44780-picanlcd">picanlcd</link></literal></entry>
        <entry>PIC-an-LCD serial device "picanlcd"</entry>
      </row>
      <row>
        <entry><literal><link linkend="hd44780-lcdserializer">lcdserializer</link></literal></entry>
        <entry>LCD serializer "lcdserializer"</entry>
      </row>
      <row>
        <entry><literal><link linkend="hd44780-los-panel">los-panel</link></literal></entry>
        <entry>LCD on Serial panel device "los-panel" (<ulink url="http://mlf.home.xs4all.nl/los/"></ulink>)</entry>
      </row>
      <row>
        <entry><literal><link linkend="hd44780-vdr-lcd">vdr-lcd</link></literal></entry>
        <entry>VDR LCD serial device "vdr-lcd"</entry>
      </row>
      <row>
        <entry><literal><link linkend="hd44780-vdr-wakeup">vdr-wakeup</link></literal></entry>
        <entry>VDR-Wakeup module "vdr-wakeup"</entry>
      </row>
      <!-- USB -->
      <row>
        <entry spanname="fullwidth">USB connection types:</entry>
      </row>
      <row>
        <entry><literal><link linkend="hd44780-pertelian">pertelian</link></literal></entry>
        <entry>Pertelian X2040 LCD display (<ulink url="http://pertelian.com/joomla/index.php?option=com_content&task=view&id=43&Itemid=48"></ulink>)</entry>
      </row>
      <row>
        <entry><literal><link linkend="hd44780-lis2">lis2</link></literal></entry>
        <entry>LIS2 from VLSystem (<ulink url="http://www.vlsys.co.kr"></ulink>)</entry>
      </row>
      <row>
        <entry><literal><link linkend="hd44780-mplay">mplay</link></literal></entry>
        <entry>MPlay Blast from VLSystem (<ulink url="http://www.vlsys.co.kr"></ulink>)</entry>
      </row>
      <row>
        <entry><literal><link linkend="hd44780-usblcd">usblcd</link></literal></entry>
        <entry>USBLCD adapter from Adams IT Services (<ulink url="http://www.usblcd.de/"></ulink>)</entry>
      </row>
      <row>
        <entry><literal><link linkend="hd44780-bwctusb">bwctusb</link></literal></entry>
        <entry>BWCT USB device "bwctusb" (<ulink url="http://www.bwct.de/lcd.html"></ulink>)</entry>
      </row>
      <row>
        <entry><literal><link linkend="hd44780-lcd2usb">lcd2usb</link></literal></entry>
        <entry>Till Harbaum's LCD2USB (<ulink url="http://www.harbaum.org/till/lcd2usb/"></ulink>)</entry>
      </row>
      <row>
        <entry><literal><link linkend="hd44780-usbtiny">usbtiny</link></literal></entry>
        <entry>Dick Streefland's USBtiny (<ulink url="http://www.xs4all.nl/~dicks/avr/usbtiny/"></ulink>)</entry>
      </row>
      <row>
        <entry><literal><link linkend="hd44780-uss720">uss720</link></literal></entry>
        <entry>Belkin USS-720 USB-to-IEEE 1284 Bridge (Belkin F5U002)</entry>
      </row>
      <row>
        <entry><literal><link linkend="hd44780-usb4all">USB-4-all</link></literal></entry>
        <entry>The USB-4-all controller board from Sprut (<ulink url="http://www.sprut.de/electronic/pic/projekte/usb4all/usb4all.htm"></ulink>)</entry>
      </row>
      <row>
        <entry><literal><link linkend="hd44780-ftdi">ftdi</link></literal>
        </entry> <entry>Display connected to a FTDI RS2232 (dual channel) or
        FTDI RS232 (single channel) USB chip</entry>
      </row>
      <!-- I2C -->
      <row>
        <entry spanname="fullwidth">I<superscript>2</superscript>C connection types:</entry>
      </row>
      <row>
        <entry><literal><link linkend="hd44780-i2c">i2c</link></literal></entry>
        <entry>LCD driven by PCF8574(A)/PCA9554(A) connected via I<superscript>2</superscript>C</entry>
      </row>
      <row>
        <entry><literal><link linkend="hd44780-piplate">piplate</link></literal></entry>
        <entry>Adafruit RGB Positive 16x2 LCD+Keypad for Raspberry Pi</entry>
      </row>
      <!-- SPI -->
      <row>
        <entry spanname="fullwidth">SPI (Serial Peripheral Interface):</entry>
      </row>
      <row>
        <entry><literal><link linkend="hd44780-spi">spi</link></literal></entry>
        <entry>Display using a KS0073 or similar in serial mode accessed via Linux SPI device</entry>
      </row>
      <row>
        <entry><literal><link linkend="hd44780-pifacecad">pifacecad</link></literal></entry>
        <entry>PiFace Control and Display for Raspberry Pi</entry>
      </row>
      <!-- Other -->
      <row>
        <entry spanname="fullwidth">Other connection types:</entry>
      </row>
      <row>
        <entry><literal><link linkend="hd44780-ethlcd">ethlcd</link></literal></entry>
        <entry>Display connected via TCP to PoE powered ethlcd device
        (<ulink url="http://manio.skyboo.net/ethlcd/"></ulink>)</entry>
      </row>
      <row>
        <entry><literal><link linkend="hd44780-raspberrypi">raspberrypi</link></literal></entry>
        <entry>LCD connected to the GPIO header of a Raspberry Pi</entry>
      </row>
    </tbody>
  </tgroup>
  </table>

  <tip>
    <para>
    <!-- The above table might be outdated, when you read this. -->
    If you suspect the table above to be outdated, you might want to have a look at
    <filename>server/drivers/hd44780-drivers.h</filename> in <package>LCDproc</package>'s
    source directory which contains the actual translation code.
    </para>
  </tip>
</para>


<sect2 id="hd44780-connections">
<title>Connections</title>

<sect3 id="hd44780-connections-common">
<title>Common connections for all connection types</title>

<para>
No matter what connection type you choose, you will always need some
connections. They are explained here.
</para>

<sect4 id="hd44780-connections-power">
<title>Power</title>

<para>
All variants use the same method of obtaining power. i.e., for each LCD:
</para>

<table id="hd44780-connections-power.table">
<title>HD44780: Power Connections</title>
<tgroup cols="3" align="left">
<colspec colname="lpt1"/>
<colspec colname="lpt2" align="right"/>
  <thead>
    <row>
      <entry namest="lpt1" nameend="lpt2" align="center">LCD</entry>
      <entry morerows="1">Signal</entry>
    </row>
    <row>
       <entry>name</entry>
       <entry>pin</entry>
    </row>
  </thead>
  <tbody>
    <row>
      <entry>V<subscript>EE</subscript></entry>
      <entry>1</entry>
      <entry>GND (connect to any of pins 18 - 25 of you parallel port)</entry>
    </row>
    <row>
      <entry>V<subscript>CC</subscript></entry>
      <entry>2</entry>
      <entry>+5V</entry>
    </row>
    <row>
      <entry>V<subscript>LC</subscript></entry>
      <entry>3</entry>
      <entry>(contrast adjustment)</entry>
    </row>
  </tbody>
</tgroup>
</table>

<warning>
 <para>
 Always double check your power connection, your display will probably
 <emphasis>not</emphasis> survive a reversely connected supply !
 </para>
</warning>

<para>
There are several ways to get 5V:
</para>

<itemizedlist>
  <listitem><para>
    Connect to a 5V line intended for disk drives (the red wire is 5V,
    black is GND).
  </para></listitem>
  <listitem><para>
    Get it from the V<subscript>CC</subscript> and GND pins of an USB connector.
    For the USB connection types this is done automatically, as the circuits
    used there automatically power the LCD.
  </para></listitem>
  <listitem><para>
    Get it from a joystick port (pin 1 and 9 are 5V, 4, 5 and 12 are GND).
    It seems that some soundcards can use these lines for communication,
    so if you want to use this first check whether it really gives a 'clean' 5V.
  </para></listitem>
  <listitem><para>
    If you don't have a backlight, you can sometimes get the needed mA's
    from the LPT port itself. Connect a few diodes from the data pins to
    a capacitor and you have the 5V. If it's strong enough is another question...
  </para></listitem>
  <listitem><para>
    Get it from the keyboard connector. I do not recommend to use this with
    a backlight, as the keyboard connector is often protected with a fuse
    of 100mA or 200mA.
  </para></listitem>
</itemizedlist>

<figure id="hd44780-connections-power.contrast-circuit">
<title>HD44780: Connecting the contrast adjusting pin (V<subscript>LC</subscript>)</title>
<screen>
<![CDATA[

     (variable resistor)
        .------.
 Vcc ---|  10k |--- GND
        `---^--'
           /|\
            |
           Vlc

]]>
</screen>
</figure>

</sect4>

<sect4 id="hd44780-connections-keypad">
<title>Keypad</title>

<para>
You can connect a keypad with most connection types. The maximum supported
number of keys differs per type. There are several ways to connect the keys
to the input pins.
</para>

<sect5 id="hd44780-connections-keypad-direct">
<title>Direct Keys</title>

<para>
If you connect a key like sketched below, then you can only connect one key
per input pin. It is a simple solution if you need only few keys.
</para>

<figure id="hd44780-connections-keypad-direct.circuit">
<title>HD44780: Direct Keys</title>
<screen>
<![CDATA[

      O 5V
      |
      |
      -
     | | 10k
     | |
      -
      |
      +-----------o input  (X)
      |
      |
      o
       \
      o
      |
      |
     === GND

]]>
</screen>
</figure>

<para>
By default, the following keystrokes are generated by the different keys:

<table id="hd44780-connections-keypad-direct.mapping">
 <title>HD44780: Direct Key Mapping</title>
 <tgroup cols="2" align="left">
  <thead>
   <row>
    <entry>key index</entry>
    <entry>mapped string</entry>
   </row>
  </thead>
  <tbody>
   <row>
    <entry>X<subscript>1</subscript></entry>
    <entry><literal>A</literal></entry>
   </row>
   <row>
    <entry>X<subscript>2</subscript></entry>
    <entry><literal>B</literal></entry>
   </row>
   <row>
    <entry>X<subscript>3</subscript></entry>
    <entry><literal>C</literal></entry>
   </row>
   <row>
    <entry>X<subscript>4</subscript></entry>
    <entry><literal>D</literal></entry>
   </row>
   <row>
    <entry>X<subscript>5</subscript></entry>
    <entry><literal>E</literal></entry>
   </row>
  </tbody>
 </tgroup>
</table>

You can change the mapping using the
<property>KeyDirect_<replaceable>NUM</replaceable></property>
configuration option, where <replaceable>NUM</replaceable>
is the subscript to the <literal>X</literal> in the table above.
</para>

</sect5>

<sect5 id="hd44780-connections-keypad-matrix">
<title>Matrix Keys</title>

<para>
Using a matrix, we can connect much more keys. To simplify the drawing here,
we replace all switches with an @ symbol:
</para>

<figure id="hd44780-connections-keypad-matrix.single-circuit">
<title>HD44780: Single Matrix Key</title>
<screen>
<![CDATA[

             X line
                |
                |
  Y line ---+---------
            |   |                    |
            o   |               =  --@--
             \  |                    |
            o   |
            |   |
            +---+
                |
                |

]]>
</screen>
</figure>

<para>
We connect the matrix of keys like this:
</para>

<figure id="hd44780-connections-keypad-matrix.complete-circuit">
<title>HD44780: Complete Key Matrix</title>
<screen>
<![CDATA[

Y1 o---|<---@--@--@
            |  |  |
Y2 o---|<---@--@--@
            |  |  |
Y3 o---|<---@--@--@
            |  |  |
Y4 o---|<---@--@--@            O 5V
            |  |  |            |
    diodes  |  |  |     ___    |
    1N4148  +----------|___|---+
            |  |  |     ___    |
            |  +-------|___|---+
            |  |  |     ___    |
            |  |  +----|___|---+     resistors 22k
            |  |  |
            o  o  o
            X1 X2 X3

]]>
</screen>
</figure>

<para>
As you can see, you need 1 resistor per X line, and 1 diode per Y line.
By default, lcdproc will presume that you have a keypad with a layout
like a telephone connected, with X and Y lines connected as show.
To be more precise, it assumes this mapping:
</para>

<table id="hd44780-connections-keypad-matrix.mapping">
<title>HD44780: Matrix Keypad Layout</title>
<tgroup cols="5" align="left">
  <tbody>
    <row>
      <entry></entry>
      <entry><emphasis>X<subscript>1</subscript></emphasis></entry>
      <entry><emphasis>X<subscript>2</subscript></emphasis></entry>
      <entry><emphasis>X<subscript>3</subscript></emphasis></entry>
      <entry><emphasis>X<subscript>4</subscript></emphasis></entry>
      <entry><emphasis>X<subscript>5</subscript></emphasis></entry>
    </row>
    <row>
      <entry><emphasis>Y<subscript>1</subscript></emphasis></entry>
      <entry><literal>1</literal></entry>
      <entry><literal>2</literal></entry>
      <entry><literal>3</literal></entry>
      <entry><literal>A</literal></entry>
      <entry><literal>E</literal></entry>
    </row>
    <row>
      <entry><emphasis>Y<subscript>2</subscript></emphasis></entry>
      <entry><literal>4</literal></entry>
      <entry><literal>5</literal></entry>
      <entry><literal>6</literal></entry>
      <entry><literal>B</literal></entry>
      <entry><literal>F</literal></entry>
    </row>
    <row>
      <entry><emphasis>Y<subscript>3</subscript></emphasis></entry>
      <entry><literal>7</literal></entry>
      <entry><literal>8</literal></entry>
      <entry><literal>9</literal></entry>
      <entry><literal>C</literal></entry>
      <entry><literal>G</literal></entry>
    </row>
    <row>
      <entry><emphasis>Y<subscript>4</subscript></emphasis></entry>
      <entry><literal>*</literal></entry>
      <entry><literal>0</literal></entry>
      <entry><literal>#</literal></entry>
      <entry><literal>D</literal></entry>
      <entry><literal>H</literal></entry>
    </row>
  </tbody>
</tgroup>
</table>

<para>
This mapping can be changed using the
<property>KeyMatrix_<replaceable>X</replaceable>_<replaceable>Y</replaceable></property>
configuration option, where <replaceable>X</replaceable> and
<replaceable>Y</replaceable> are the subscripts to the respective axes above.
</para>

<para>
If you only need e.g. 10 keys, leave the rest away.
You should modify and recompile the
driver to get an other keypad layout.
</para>

<para>
You can buy arrays of keys that are connected like this in the electronics
shop. They usually call it a matrix keypad. To hook it to lcdproc, you
would only need to add the resistors and diodes.
</para>

<para>
If you want to use just one return line, for example with the serialLpt
wiring, it looks (completely drawn) like this:
</para>

<figure id="hd44780-connections-keypad-matrix.1line-circuit">
<title>HD44780: One Return Line</title>
<screen>
<![CDATA[

                  O 5V
                  |
                 .-.
                 | | 4k7 or 22k
     diodes      | |
     1N4148      '-'
            ___   |
Y1 o---|<---o o---+
            ___   |
Y2 o---|<---o o---+
            ___   |
Y3 o---|<---o o---+
            ___   |
Y4 o---|<---o o---+----o return line

]]>
</screen>
</figure>

<tip>
 <para>
 If the driver generates keypresses without that you actually press a key,
 it might be that the unconnected input lines are picking up
 electromagnetic waves from the air. In that case connect the unconnected
 input lines (pin 10, 11, 12, 13 and 15 of the LPT) to V<subscript>CC</subscript> = 5V.
 </para>
</tip>

</sect5>

</sect4>

<sect4 id="hd44780-connections-backlight">
<title>Backlight</title>

<para>
A small extension allows you to switch the backlight of the display on
and off. At the moment only the <code>4bit</code> and <code>winamp</code>
connection types support this.
The extension uses one output pin, you cannot use that pin for other
functions anymore. The wiring looks like this:
</para>

<figure id="hd44780-connections-backlight.circuit">
<title>HD44780: Backlight Wiring</title>
<screen>
<![CDATA[

                                             O 5V
                                      ___    |
                                 +---|___|---+
LPT Sub-D connector              |   4k7     |
                                 |           |e
                          ___    |       b |/
     BL pin o------------|___|---+---------|
                          1k               |\
                                       BC327 |c
                                             |        LCD connector
                                             |
                                             +--------o 15 backlight

                                             +--------o 16 GND backlight
                                             |
                                            === GND

Note: 4k7 means 4,7 kOhm.
The BC327 transistor has the following connections:

     _____
    |     |
    |BC327|
    |_____|
     | | |
     | | |
     | | |
     c b e

]]>
</screen>
</figure>

<caution>
 <para>
 Sometimes the backlight connections are not on the 'main' connector, but on
 the side. If that is the case, there is usually NO RESISTOR present to limit
 the current through the LEDs. Therefore you should then add a resistor after
 the transistor of about 10 ohm (see display documentation).
 </para>
</caution>

<tip>
 <para>
 If you want the backlight to light a bit while it is "switched off", you can
 add a resistor bypassing the transistor from e to c, with a value of, say
 47ohm or 22ohm. (My 4x20 has an internal resistor of 6ohm, so with 47 ohm
 extra it lights at only 1/9th. I like this. Joris.)
 </para>
</tip>

</sect4>

</sect3>

<sect3 id="hd44780-4bit">
<title>4bit</title>

<para>
This wiring is originally based on "lcdtext" (by Matthias Prinke).
</para>

<table id="hd44780-4bit.base-mapping">
<title>HD44780: 4bit Pinouts (1)</title>
<tgroup cols="5" align="left">
<colspec colname="lpt1"/>
<colspec colname="lpt2" align="right"/>
<colspec colname="base" align="center"/>
<colspec colname="lcd1"/>
<colspec colname="lcd2"/>
  <thead>
    <row>
      <entry namest="lpt1" nameend="lpt2" align="center">printer port</entry>
      <entry morerows="1"><-></entry>
      <entry namest="lcd1" nameend="lcd2" align="center">LCD</entry>
    </row>
    <row>
      <entry>name</entry>
      <entry>pin</entry>
      <entry>name</entry>
      <entry>pin</entry>
    </row>
  </thead>
  <tbody>
    <row>
      <entry></entry>
      <entry></entry>
      <entry>GND</entry>
      <entry>V<subscript>EE</subscript></entry>
      <entry>1</entry>
    </row>
    <row>
      <entry></entry>
      <entry></entry>
      <entry>+5V</entry>
      <entry>V<subscript>CC</subscript></entry>
      <entry>2</entry>
    </row>
    <row>
      <entry></entry>
      <entry></entry>
      <entry>(contrast adjustment)</entry>
      <entry>V<subscript>LC</subscript></entry>
      <entry>3</entry>
    </row>
    <row>
      <entry>D4</entry>
      <entry>6</entry>
      <entry></entry>
      <entry>RS</entry>
      <entry>4</entry>
    </row>
    <row>
      <entry></entry>
      <entry></entry>
      <entry>GND</entry>
      <entry>RW</entry>
      <entry>5</entry>
    </row>
    <row>
      <entry>D6</entry>
      <entry>8</entry>
      <entry></entry>
      <entry>EN</entry>
      <entry>6</entry>
    </row>
    <row>
      <entry>D0</entry>
      <entry>2</entry>
      <entry></entry>
      <entry>D4</entry>
      <entry>11</entry>
    </row>
    <row>
      <entry>D1</entry>
      <entry>3</entry>
      <entry></entry>
      <entry>D5</entry>
      <entry>12</entry>
    </row>
    <row>
      <entry>D2</entry>
      <entry>4</entry>
      <entry></entry>
      <entry>D6</entry>
      <entry>13</entry>
    </row>
    <row>
      <entry>D3</entry>
      <entry>5</entry>
      <entry></entry>
      <entry>D7</entry>
      <entry>14</entry>
    </row>
  </tbody>
</tgroup>
</table>

<note>
<para>
The <literal>RW</literal> (pin 5) line of the display decides whether the display receives data from the
LPT port, or whether it sends data to the LPT port: if grounded it receives, if High or connected
to nothing at all it "sends" (i.e., will not work as intended). So, if you are not sure that
you need it otherwise, then connect it to GND. This certainly applies if you have only one display.
</para>
<para>
Theoretically this wiring sends the data over twice as slow as the
winamp or ext8bit wirings, because it only sends 4 bits at a time.
</para>
</note>

<para>
The <code>4bit</code> connection type supports more than one display connected
to the same parallel port.
If you want to connect more than one display, then wire the all the displays to the
parallel port according to the scheme above with the exception of the <literal>EN</literal>
(pin 6) line of the LCDs.
</para>

<para>
For the second and further displays, you can find the wiring for the <literal>EN</literal>
(pin 6) line in the table below.
</para>

<table id="hd44780-4bit.multi-mapping">
<title>HD44780: 4bit Pinouts (2)</title>
<tgroup cols="5" align="left">
<colspec colname="lpt1"/>
<colspec colname="lpt2" align="right"/>
<colspec colname="base" align="center"/>
<colspec colname="lcd1"/>
<colspec colname="lcd2"/>
  <thead>
    <row>
      <entry namest="lpt1" nameend="lpt2" align="center">printer port</entry>
      <entry morerows="1"><-></entry>
      <entry namest="lcd1" nameend="lcd2" align="center">LCD</entry>
    </row>
    <row>
      <entry>name</entry>
      <entry>pin</entry>
      <entry>name</entry>
      <entry>pin</entry>
    </row>
  </thead>
  <tbody>
    <row>
      <entry>D7</entry>
      <entry>9</entry>
      <entry></entry>
      <entry>EN<subscript>2</subscript></entry>
      <entry>6 of 2<superscript>nd</superscript> display</entry>
    </row>
    <row>
      <entry>D5</entry>
      <entry>7</entry>
      <entry></entry>
      <entry>EN<subscript>3</subscript></entry>
      <entry>6 of 3<superscript>rd</superscript> display</entry>
    </row>
    <row>
      <entry>STR</entry>
      <entry>1</entry>
      <entry></entry>
      <entry>EN<subscript>4</subscript></entry>
      <entry>6 of 4<superscript>th</superscript> display</entry>
    </row>
    <row>
      <entry>LF</entry>
      <entry>14</entry>
      <entry></entry>
      <entry>EN<subscript>5</subscript></entry>
      <entry>6 of 5<superscript>th</superscript> display</entry>
    </row>
    <row>
      <entry>INIT</entry>
      <entry>16</entry>
      <entry></entry>
      <entry>EN<subscript>6</subscript></entry>
      <entry>6 of 6<superscript>th</superscript> display</entry>
    </row>
    <row>
      <entry>SEL</entry>
      <entry>17</entry>
      <entry></entry>
      <entry>EN<subscript>7</subscript></entry>
      <entry>6 of 7<superscript>th</superscript> display</entry>
    </row>
  </tbody>
</tgroup>
</table>

<para>
The optional keypad can be connected as follows:
</para>

<table id="hd44780-4bit.keypad-mapping">
<title>HD44780: 4bit Keypad Pinouts</title>
<tgroup cols="4" align="left">
<colspec colname="lpt1"/>
<colspec colname="lpt2" align="right"/>
<colspec colname="base" align="center"/>
  <thead>
    <row>
      <entry namest="lpt1" nameend="lpt2" align="center">printer port</entry>
      <entry morerows="1"><-></entry>
      <entry align="center">keypad</entry>
      <entry morerows="1">remarks</entry>
    </row>
    <row>
      <entry>name</entry>
      <entry>pin</entry>
      <entry>pin</entry>
    </row>
  </thead>
  <tbody>
    <row>
      <entry>D0</entry>
      <entry>2</entry>
      <entry></entry>
      <entry>Y<subscript>1</subscript></entry>
      <entry></entry>
    </row>
    <row>
      <entry>D1</entry>
      <entry>3</entry>
      <entry></entry>
      <entry>Y<subscript>2</subscript></entry>
      <entry></entry>
    </row>
    <row>
      <entry>D2</entry>
      <entry>4</entry>
      <entry></entry>
      <entry>Y<subscript>3</subscript></entry>
      <entry></entry>
    </row>
    <row>
      <entry>D3</entry>
      <entry>5</entry>
      <entry></entry>
      <entry>Y<subscript>4</subscript></entry>
      <entry></entry>
    </row>
    <row>
      <entry>D4</entry>
      <entry>6</entry>
      <entry></entry>
      <entry>Y<subscript>5</subscript></entry>
      <entry></entry>
    </row>
    <row>
      <entry>D5</entry>
      <entry>7</entry>
      <entry></entry>
      <entry>Y<subscript>6</subscript></entry>
      <entry>Only if not used for backlight or 3<superscript>rd</superscript> controller.</entry>
    </row>
    <row>
      <entry>nSTRB</entry>
      <entry>1</entry>
      <entry></entry>
      <entry>Y<subscript>7</subscript></entry>
      <entry morerows="3">Only if not used for additional controllers.</entry>
    </row>
    <row>
      <entry>nLF</entry>
      <entry>14</entry>
      <entry></entry>
      <entry>Y<subscript>8</subscript></entry>
    </row>
    <row>
      <entry>INIT</entry>
      <entry>16</entry>
      <entry></entry>
      <entry>Y<subscript>9</subscript></entry>
    </row>
    <row>
      <entry>nSEL</entry>
      <entry>17</entry>
      <entry></entry>
      <entry>Y<subscript>10</subscript></entry>
    </row>
    <row>
      <entry>nACK</entry>
      <entry>10</entry>
      <entry></entry>
      <entry>X<subscript>1</subscript></entry>
      <entry></entry>
    </row>
    <row>
      <entry>BUSY</entry>
      <entry>11</entry>
      <entry></entry>
      <entry>X<subscript>2</subscript></entry>
      <entry></entry>
    </row>
    <row>
      <entry>PAPEREND</entry>
      <entry>12</entry>
      <entry></entry>
      <entry>X<subscript>3</subscript></entry>
      <entry></entry>
    </row>
    <row>
      <entry>SELIN</entry>
      <entry>13</entry>
      <entry></entry>
      <entry>X<subscript>4</subscript></entry>
      <entry></entry>
    </row>
    <row>
      <entry>nFAULT</entry>
      <entry>15</entry>
      <entry></entry>
      <entry>X<subscript>5</subscript></entry>
      <entry></entry>
    </row>
  </tbody>
</tgroup>
</table>

<para>
The optional backlight wiring should be connected to D5, pin 7.
</para>

</sect3>

<sect3 id="hd44780-8bit-winamp">
<title>8bit "Winamp"</title>

<para>
This type of connection should work with winamp.
</para>

<table id="hd44780-8bit-winamp.base-mapping">
<title>HD44780: "Winamp" wiring</title>
<tgroup cols="5" align="left">
<colspec colname="lpt1"/>
<colspec colname="lpt2" align="right"/>
<colspec colname="base" align="center"/>
<colspec colname="lcd1"/>
<colspec colname="lcd2"/>
  <thead>
    <row>
      <entry namest="lpt1" nameend="lpt2" align="center">printer port</entry>
      <entry morerows="1"><-></entry>
      <entry namest="lcd1" nameend="lcd2" align="center">LCD</entry>
    </row>
    <row>
      <entry>name</entry>
      <entry>pin</entry>
      <entry>name</entry>
      <entry>pin</entry>
    </row>
  </thead>
  <tbody>
    <row>
      <entry>D0</entry>
      <entry>2</entry>
      <entry></entry>
      <entry>D0</entry>
      <entry>7</entry>
    </row>
    <row>
      <entry>D1</entry>
      <entry>3</entry>
      <entry></entry>
      <entry>D1</entry>
      <entry>8</entry>
    </row>
    <row>
      <entry>D2</entry>
      <entry>4</entry>
      <entry></entry>
      <entry>D2</entry>
      <entry>9</entry>
    </row>
    <row>
      <entry>D3</entry>
      <entry>5</entry>
      <entry></entry>
      <entry>D3</entry>
      <entry>10</entry>
    </row>
    <row>
      <entry>D4</entry>
      <entry>6</entry>
      <entry></entry>
      <entry>D4</entry>
      <entry>11</entry>
    </row>
    <row>
      <entry>D5</entry>
      <entry>7</entry>
      <entry></entry>
      <entry>D5</entry>
      <entry>12</entry>
    </row>
    <row>
      <entry>D6</entry>
      <entry>8</entry>
      <entry></entry>
      <entry>D6</entry>
      <entry>13</entry>
    </row>
    <row>
      <entry>D7</entry>
      <entry>9</entry>
      <entry></entry>
      <entry>D7</entry>
      <entry>14</entry>
    </row>
    <row>
      <entry>nSTRB</entry>
      <entry>1</entry>
      <entry></entry>
      <entry>EN</entry>
      <entry>6</entry>
    </row>
    <row>
      <entry>nLF</entry>
      <entry>14</entry>
      <entry></entry>
      <entry>RW</entry>
      <entry>5 (EN3 6 - LCD 3) (optional (*) )</entry>
    </row>
    <row>
      <entry>INIT</entry>
      <entry>16</entry>
      <entry></entry>
      <entry>RS</entry>
      <entry>4</entry>
    </row>
    <row>
      <entry>nSEL</entry>
      <entry>17</entry>
      <entry></entry>
      <entry>EN2</entry>
      <entry>(6 - LCD 2) (optional)</entry>
    </row>
  </tbody>
</tgroup>
</table>

<para>
(*) on the RW line of the display: this line decides whether the display receives data from the
LPT port, or whether it sends data to the LPT port: if grounded it receives, if High or connected
to nothing at all it "sends" (i.e., will not work as intended). So, if you are not sure that
you need it otherwise, then connect it to GND. This certainly applies if you have only one display.
</para>

<para>
If you want the display to work with the Winamp plugin, wire nLF (pin 14)
to RW of your LCD. You can then use the plugin in bidirectional mode (which
is much faster). With 3 connected LCDs this is not possible.
Note from Benjamin: I haven't tried using winamp while having the third LCD
connected to this line.
</para>

<para>
The optional keypad can be connected as follows:
</para>

<table id="hd44780-8bit-winamp.keypad-mapping">
<title>HD44780: "Winamp" wiring - Keypad</title>
<tgroup cols="4" align="left">
<colspec colname="lpt1"/>
<colspec colname="lpt2" align="right"/>
<colspec colname="base" align="center"/>
  <thead>
    <row>
      <entry namest="lpt1" nameend="lpt2" align="center">printer port</entry>
      <entry morerows="1"><-></entry>
      <entry align="center">keypad</entry>
    </row>
    <row>
      <entry>name</entry>
      <entry>pin</entry>
      <entry>pin</entry>
    </row>
  </thead>
  <tbody>
    <row>
      <entry>D0</entry>
      <entry>2</entry>
      <entry></entry>
      <entry>Y<subscript>1</subscript></entry>
    </row>
    <row>
      <entry>D1</entry>
      <entry>3</entry>
      <entry></entry>
      <entry>Y<subscript>2</subscript></entry>
    </row>
    <row>
      <entry>D2</entry>
      <entry>4</entry>
      <entry></entry>
      <entry>Y<subscript>3</subscript></entry>
    </row>
    <row>
      <entry>D3</entry>
      <entry>5</entry>
      <entry></entry>
      <entry>Y<subscript>4</subscript></entry>
    </row>
    <row>
      <entry>D4</entry>
      <entry>6</entry>
      <entry></entry>
      <entry>Y<subscript>5</subscript></entry>
    </row>
    <row>
      <entry>D5</entry>
      <entry>7</entry>
      <entry></entry>
      <entry>Y<subscript>6</subscript></entry>
    </row>
    <row>
      <entry>D6</entry>
      <entry>8</entry>
      <entry></entry>
      <entry>Y<subscript>7</subscript></entry>
    </row>
    <row>
      <entry>D7</entry>
      <entry>9</entry>
      <entry></entry>
      <entry>Y<subscript>8</subscript></entry>
    </row>
    <row>
      <entry>nACK</entry>
      <entry>10</entry>
      <entry></entry>
      <entry>X<subscript>1</subscript></entry>
    </row>
    <row>
      <entry>BUSY</entry>
      <entry>11</entry>
      <entry></entry>
      <entry>X<subscript>2</subscript></entry>
    </row>
    <row>
      <entry>PAPEREND</entry>
      <entry>12</entry>
      <entry></entry>
      <entry>X<subscript>3</subscript></entry>
    </row>
    <row>
      <entry>SELIN</entry>
      <entry>13</entry>
      <entry></entry>
      <entry>X<subscript>4</subscript></entry>
    </row>
    <row>
      <entry>nFAULT</entry>
      <entry>15</entry>
      <entry></entry>
      <entry>X<subscript>5</subscript></entry>
    </row>
  </tbody>
</tgroup>
</table>

<para>
The optional backlight wiring should be connected to nSEL, pin 17.
</para>

</sect3>

<sect3 id="hd44780-8bit-lcdtime">
<title>8bit "lcdtime"</title>

<para>
This is originally based on "lcdtime" (by Benjamin Tse
<email>blt@ComPorts.com</email>) and allows you to combine the LCD with a LED
bargraph. The LCD is driven by LCDproc and the LEDs by another program
such as portato. Further details can be obtained from:
</para>

<simplelist type="vert" columns="1">
  <member>
    <ulink url="http://www.ibiblio.org/pub/linux/system/status/lcdtime-0.2.tar.gz"></ulink>
  </member>
  <member>
    <ulink url="http://www.ibiblio.org/pub/linux/system/status/meter-0.2.tar.gz"></ulink>
  </member>
  <member>
    <ulink url="http://www.ibiblio.org/pub/linux/system/status/portato-1.2.tar.gz"></ulink>
  </member>
</simplelist>

<para>
The LCD connections are:
</para>

<table id="hd44780-8bit-lcdtime.base-mapping">
<title>HD44780: "lcdtime" wiring</title>
<tgroup cols="5" align="left">
<colspec colname="lpt1"/>
<colspec colname="lpt2" align="right"/>
<colspec colname="base" align="center"/>
<colspec colname="lcd1"/>
<colspec colname="lcd2"/>
  <thead>
    <row>
      <entry namest="lpt1" nameend="lpt2" align="center">printer port</entry>
      <entry morerows="1"><-></entry>
      <entry namest="lcd1" nameend="lcd2" align="center">LCD</entry>
    </row>
    <row>
      <entry>name</entry>
      <entry>pin</entry>
      <entry>name</entry>
      <entry>pin</entry>
    </row>
  </thead>
  <tbody>
    <row>
      <entry>D0</entry>
      <entry>2</entry>
      <entry></entry>
      <entry>D0</entry>
      <entry>7</entry>
    </row>
    <row>
      <entry>D1</entry>
      <entry>3</entry>
      <entry></entry>
      <entry>D1</entry>
      <entry>8</entry>
    </row>
    <row>
      <entry>D2</entry>
      <entry>4</entry>
      <entry></entry>
      <entry>D2</entry>
      <entry>9</entry>
    </row>
    <row>
      <entry>D3</entry>
      <entry>5</entry>
      <entry></entry>
      <entry>D3</entry>
      <entry>10</entry>
    </row>
    <row>
      <entry>D4</entry>
      <entry>6</entry>
      <entry></entry>
      <entry>D4</entry>
      <entry>11</entry>
    </row>
    <row>
      <entry>D5</entry>
      <entry>7</entry>
      <entry></entry>
      <entry>D5</entry>
      <entry>12</entry>
    </row>
    <row>
      <entry>D6</entry>
      <entry>8</entry>
      <entry></entry>
      <entry>D6</entry>
      <entry>13</entry>
    </row>
    <row>
      <entry>D7</entry>
      <entry>9</entry>
      <entry></entry>
      <entry>D7</entry>
      <entry>14</entry>
    </row>
    <row>
      <entry>nSEL</entry>
      <entry>17</entry>
      <entry></entry>
      <entry>-</entry>
      <entry></entry>
    </row>
    <row>
      <entry>nSTRB</entry>
      <entry>1</entry>
      <entry></entry>
      <entry>RS</entry>
      <entry>4</entry>
    </row>
    <row>
      <entry>nLF</entry>
      <entry>14</entry>
      <entry></entry>
      <entry>RW</entry>
      <entry>5 (optional - pull LCD RW low (*)</entry>
    </row>
    <row>
      <entry>INIT</entry>
      <entry>16</entry>
      <entry></entry>
      <entry>EN</entry>
      <entry>6</entry>
    </row>
  </tbody>
</tgroup>
</table>

<para>
(*) on the RW line of the display: this line decides whether the display receives data from the
LPT port, or whether it sends data to the LPT port: if grounded it receives, if High or connected
to nothing at all it "sends" (i.e., will not work as intended). So, if you are not sure that
you need it otherwise, then connect it to GND.
</para>

<para>
See the lcdtime tar-ball (above) for full details of the bargraph
connections.
</para>

<para>
The optional keypad can be connected as follows:
</para>

<table id="hd44780-8bit-lcdtime.keypad-mapping">
<title>HD44780: "lcdtime" wiring - keypad</title>
<tgroup cols="4" align="left">
<colspec colname="lpt1"/>
<colspec colname="lpt2" align="right"/>
<colspec colname="base" align="center"/>
  <thead>
    <row>
      <entry namest="lpt1" nameend="lpt2" align="center">printer port</entry>
      <entry morerows="1"><-></entry>
      <entry align="center">keypad</entry>
    </row>
    <row>
      <entry>name</entry>
      <entry>pin</entry>
      <entry>pin</entry>
    </row>
  </thead>
  <tbody>
    <row>
      <entry>D0</entry>
      <entry>2</entry>
      <entry></entry>
      <entry>Y<subscript>1</subscript></entry>
    </row>
    <row>
      <entry>D1</entry>
      <entry>3</entry>
      <entry></entry>
      <entry>Y<subscript>2</subscript></entry>
    </row>
    <row>
      <entry>D2</entry>
      <entry>4</entry>
      <entry></entry>
      <entry>Y<subscript>3</subscript></entry>
    </row>
    <row>
      <entry>D3</entry>
      <entry>5</entry>
      <entry></entry>
      <entry>Y<subscript>4</subscript></entry>
    </row>
    <row>
      <entry>D4</entry>
      <entry>6</entry>
      <entry></entry>
      <entry>Y<subscript>5</subscript></entry>
    </row>
    <row>
      <entry>D5</entry>
      <entry>7</entry>
      <entry></entry>
      <entry>Y<subscript>6</subscript></entry>
    </row>
    <row>
      <entry>D6</entry>
      <entry>8</entry>
      <entry></entry>
      <entry>Y<subscript>7</subscript></entry>
    </row>
    <row>
      <entry>D7</entry>
      <entry>9</entry>
      <entry></entry>
      <entry>Y<subscript>8</subscript></entry>
    </row>
    <row>
      <entry>nSTRB</entry>
      <entry>1</entry>
      <entry></entry>
      <entry>Y<subscript>9</subscript></entry>
    </row>
    <row>
      <entry>nSEL</entry>
      <entry>17</entry>
      <entry></entry>
      <entry>Y<subscript>10</subscript> (only if not used for backlight)</entry>
    </row>
    <row>
      <entry>nACK</entry>
      <entry>10</entry>
      <entry></entry>
      <entry>X<subscript>1</subscript></entry>
    </row>
    <row>
      <entry>BUSY</entry>
      <entry>11</entry>
      <entry></entry>
      <entry>X<subscript>2</subscript></entry>
    </row>
    <row>
      <entry>PAPEREND</entry>
      <entry>12</entry>
      <entry></entry>
      <entry>X<subscript>3</subscript></entry>
    </row>
    <row>
      <entry>SELIN</entry>
      <entry>13</entry>
      <entry></entry>
      <entry>X<subscript>4</subscript></entry>
    </row>
    <row>
      <entry>nFAULT</entry>
      <entry>15</entry>
      <entry></entry>
      <entry>X<subscript>5</subscript></entry>
    </row>
  </tbody>
</tgroup>
</table>

<para>
The backlight wiring should be attached to nSEL, pin 17. Because the portato
program (mentioned above) also uses this pin to control the bargraph, you
cannot use the backlight control together with the bargraph.
</para>

</sect3>

<sect3 id="hd44780-seriallpt">
<title>Serial LPT</title>

<para>
This interface uses a handful of wires to interface to the
HD44780. Suitable for high noise, long connections. Designed by
Andrew McMeikan <email>andrewm@engineer.com</email>.
</para>

<para>
I (Joris) have extended this driver and the wiring a bit. It now supports
keys again (it had earlier supported keys, but some time did not).
</para>

<para>
Further I have extended the driver and the wiring to be able to run
using 2 instead of 3 output pins. That's even one less pin ! :)
</para>

<para>
Of course the use of fewer lines than the other wirings can not stay
without drawbacks. In this case the simplicity of the long feeding wires
is compensated by some intelligence in the decoding of the data. If you
have no experience with the soldering iron, I do not recommend to build
this wiring.
</para>

<para>
OK, so here is the wiring. First of the 'simple' 3 wires version. IC1 is
the shift register, a 4094. Do not forget to connect the 5V to pin 16 and
GND to pin 8 of the IC.
</para>

<figure id="hd44780-seriallpt.simple-circuit">
<title>HD44780: Serial LPT wiring ('simple')</title>
<screen>
<![CDATA[

                                      IC1
                                   -----------
                                  |   4094    |
                            5V    | shift reg |                    display
                             O    |           |                            keys
                             |   1|           |4
                             +----|STR      Q0|--------------------o 11 D4   Y1
                             |    |           |5
           Data              |   2|         Q1|--------------------o 12 D5   Y2
   D3 5 o-------------------------|D          |6
                             |    |         Q2|--------------------o 13 D6   Y3
                             |   3|           |7
   D4 6 o-------------------------|CK       Q3|--------------------o 14 D7   Y4
                             |    |           |14
                             |  15|         Q4|--------------------o         Y5
                             +----|OE         |13
                                  |         Q5|--------------------o 4  RS   Y6
                                  |           |12
                                  |         Q6|--------------------o         Y7
                                  |           |11
                                  |         Q7|--------------------o         Y8
                                  |           |9
                                  |         QS|--               +--o 5  RW
                                  |         __|10               |
                                  |         QS|--              ===
                                  |           |
                                   -----------

   D2 4 o----------------------------------------------------------o 6 EN

   D7 9 o----------------------------------------------------------o 6 EN2
                                                                     (2nd LCD)


          5V  O-----+--------+-------------------------------+-----o 2 VCC
                    |        |                               |
                    |        |                               |
                    |100n    O 16                           .-.
                   ---      IC1                             | |<---o 3 Vlcd
                   ---       O 8                            | |10k
                    |        |                              '-'
   GND              |        |                               |
 18..25 o-----------+--------+-----------------------+-------+-----o 1 GND
                                                     |
                                                    === GND

]]>
</screen>
</figure>

<para>
The second possible wiring is with 2 output lines. This one is a bit more
complex. If you do not understand the schematic, do not build it.
</para>

<figure id="hd44780-seriallpt.complex-circuit">
<title>HD44780: Serial LPT wiring ('complex')</title>
<screen>
<![CDATA[

                                      IC2
                                   -----------
                                  |  74HCT164 |
                                  | shift reg |                    display
                                  |           |                            keys
           Data                  1|           |3
   D3 5 o---------------------+---|D        Q0|--------------------o 11 D4   Y1
                              |   |           |4
                              |  2|         Q1|--------------------o 12 D5   Y2
                              +---|D          |5
                                  |         Q2|--------------------o 13 D6   Y3
                                  |           |6
                                  |         Q3|--------------------o 14 D7   Y4
                                  |           |10
           Clock                 8|         Q4|--------------------o         Y5
   D4 6 o-------------------------|CK         |11
                                  |         Q5|--------------------o 4  RS   Y6
               ___       9|\ 8   9|_          |12
           +--|___|--+----| >o----|R        Q6|--------------------o         Y7
           |   22k   |    |/      |           |13
           |        ---   IC1     |         Q7|---+             +--o 5  RW
           |        ---           |           |   |     5V      |
           |         |100p         -----------    |     O      ===
           |         |                            |     |
           |        ===                           |    .-.
           |                                      |    | |22k
           +--------------------------------------+    | |
           |                                           '-'
           |   ___      11|\ 10                         |   5|\ 6
           +--|___|--+----| >o-------------------||-----+----| >o--o 6 EN
               22k   |    |/                    22p          |/
                    ---   IC1                                IC1
                    ---
                     |22p
                     |            IC1=74HCT14 (6x Schmitt trigger inverter)
                    ===


        5V  O--+-------+------+------+-----------------------+-----o 2 VCC
               |       |      |      | 13|\ 12               |
               |       |      |      +---| >o-               |
               |100n   O 14   O 14       |/                 .-.
              ---     IC1    IC2                            | |<---o 3 Vlcd
              ---      O 7    O 7       1|\ 2      3|\ 4    | |10k
               |       |      |       +--| >o-   +--| >o-   '-'
   GND         |       |      |       |  |/      |  |/       |
 18..25 o------+-------+------+-------+----------+-----+-----+-----o 1 GND
                                                       |
                                                      === GND

]]>
</screen>
</figure>

<sect4 id="hd44780-seriallpt-keypad">
<title>Serial LPT Keypad</title>

<note>
<para>
To understand this part of the serialLpt documentation, you also need to
read the <link linkend="hd44780-connections-keypad">keypad section</link> in this document.
</para>
</note>

<para>
serialLpt wiring supports a keypad. The 3 wires version supports
8 keys, or if you use multiple return lines up to 8 x 5 = 40 lines. The
2 wires version supports 7 keys, or with multiple return lines
7 x 5 = 35 keys.
</para>

<table id="hd44780-seriallpt-keypad.mapping">
<title>HD44780: Serial LPT - Keypad return lines</title>
<tgroup cols="4" align="left">
<colspec colname="lpt1"/>
<colspec colname="lpt2" align="right"/>
<colspec colname="base" align="center"/>
  <thead>
    <row>
      <entry namest="lpt1" nameend="lpt2" align="center">printer port</entry>
      <entry morerows="1"><-></entry>
      <entry align="center">keypad</entry>
    </row>
    <row>
      <entry>name</entry>
      <entry>pin</entry>
      <entry>pin</entry>
    </row>
  </thead>
  <tbody>
    <row>
      <entry>nACK</entry>
      <entry>10</entry>
      <entry></entry>
      <entry>X<subscript>1</subscript></entry>
    </row>
    <row>
      <entry>BUSY</entry>
      <entry>11</entry>
      <entry></entry>
      <entry>X<subscript>2</subscript></entry>
    </row>
    <row>
      <entry>PAPEREND</entry>
      <entry>12</entry>
      <entry></entry>
      <entry>X<subscript>3</subscript></entry>
    </row>
    <row>
      <entry>SELIN</entry>
      <entry>13</entry>
      <entry></entry>
      <entry>X<subscript>4</subscript></entry>
    </row>
    <row>
      <entry>nFAULT</entry>
      <entry>15</entry>
      <entry></entry>
      <entry>X<subscript>5</subscript></entry>
    </row>
  </tbody>
</tgroup>
</table>

<para>
On lines longer than, say a meter, you should buffer the return line(s).
If you only have 1 return line, you can buffer it with two remaining
buffers from the 74HCT14:
</para>

<figure id="hd44780-seriallpt-keypad.circuit">
<title>HD44780: Serial LPT - Keypad return lines buffered</title>
<screen>
<![CDATA[

               1|\ 2    13|\ 12   ___
   keypad o-----| >o------| >o---|___|---+---o input pin on LPT port
   return       |/        |/      220E   |
                IC1       IC1           ---
                                        --- 1nF
                                         |
                                        ===

]]>
</screen>
</figure>

</sect4>

<sect4 id="hd44780-seriallpt-backlight">
<title>Serial LPT Backlight</title>

<para>
Also a backlight is supported. You will also need a port from the 74HCT14 for
that. The BL output below should be connected to the BL input in the
<link linkend="hd44780-connections-backlight">backlight section</link>
</para>

<figure id="hd44780-seriallpt-backlight.circuit">
<title>HD44780: Serial LPT - Backlight extra circuit</title>
<screen>
<![CDATA[

                 ___       3|\ 4
     Data o-----|___|--+----| >o----o BL output
   LPT-D3       470k   |    |/
                      ---   IC1
                      ---
                       |100nF
                       |
                      ===

]]>
</screen>
</figure>

</sect4>

</sect3>

<sect3 id="hd44780-spi">
<title>spi</title>

<para>
This connection type drives a LCD in serial mode (supported on Hitachi HD66712,
Samsung KS0073 and KS0074 (and clones) controllers) connected to some Linux
SPI device.
</para>
<para>
This connection type is currently only supported on Linux. It is strongly
recommended to use a SPI implementation with hardware support, e.g. on the
Raspberry Pi.
</para>
<para>
As the SPI communication to the display cannot drive a backlight switch, this
connection type features a <replaceable>BacklightDevice</replaceable> option
that can use a GPIO pin exposed via sysfs (see <ulink url="http://elinux.org/GPIO">eLinux GPIO</ulink>).
</para>

</sect3>

<sect3 id="hd44780-ftdi">
<title>FTDI FT2232D USB chip "ftdi"</title>

<para>
You can use a FTDI FT2232D dual channel USB <-> parallel FIFO chip
to connect a display via the USB bus. The chip is switched to bitbang mode
and drives both channels as outputs to control the display in 8bit mode.
</para>

<table id="hd44780-ftdi.base-mapping">
<title>HD44780: 8bit FTDI</title>
<tgroup cols="5" align="left">
<colspec colname="ftdi1"/>
<colspec colname="ftdi2" align="right"/>
<colspec colname="base" align="center"/>
<colspec colname="lcd1"/>
<colspec colname="lcd2"/>
  <thead>
    <row>
      <entry namest="ftdi1" nameend="ftdi2" align="center">FTDI chip</entry>
      <entry morerows="1"><-></entry>
      <entry namest="lcd1" nameend="lcd2" align="center">LCD</entry>
    </row>
    <row>
      <entry>name</entry>
      <entry>pin</entry>
      <entry>name</entry>
      <entry>pin</entry>
    </row>
  </thead>
  <tbody>
    <row>
      <entry>ADBUS0</entry>
      <entry>24</entry>
      <entry></entry>
      <entry>D0</entry>
      <entry>7</entry>
    </row>
    <row>
      <entry>ADBUS1</entry>
      <entry>23</entry>
      <entry></entry>
      <entry>D1</entry>
      <entry>8</entry>
    </row>
    <row>
      <entry>ADBUS2</entry>
      <entry>22</entry>
      <entry></entry>
      <entry>D2</entry>
      <entry>9</entry>
    </row>
    <row>
      <entry>ADBUS3</entry>
      <entry>21</entry>
      <entry></entry>
      <entry>D3</entry>
      <entry>10</entry>
    </row>
    <row>
      <entry>ADBUS4</entry>
      <entry>20</entry>
      <entry></entry>
      <entry>D4</entry>
      <entry>11</entry>
    </row>
    <row>
      <entry>ADBUS5</entry>
      <entry>19</entry>
      <entry></entry>
      <entry>D5</entry>
      <entry>12</entry>
    </row>
    <row>
      <entry>ADBUS6</entry>
      <entry>18</entry>
      <entry></entry>
      <entry>D6</entry>
      <entry>13</entry>
    </row>
    <row>
      <entry>ADBUS7</entry>
      <entry>17</entry>
      <entry></entry>
      <entry>D7</entry>
      <entry>14</entry>
    </row>
    <row>
      <entry>BDBUS0</entry>
      <entry>40</entry>
      <entry></entry>
      <entry>RS</entry>
      <entry>4</entry>
    </row>
    <row>
      <entry>BDBUS1</entry>
      <entry>39</entry>
      <entry></entry>
      <entry>RW</entry>
      <entry>5</entry>
    </row>
    <row>
      <entry>BDBUS2</entry>
      <entry>38</entry>
      <entry></entry>
      <entry>EN</entry>
      <entry>6</entry>
    </row>
    <row>
      <entry>BDBUS3</entry>
      <entry>37</entry>
      <entry></entry>
      <entry>BL</entry>
      <entry>Backlight (optional)</entry>
    </row>
  </tbody>
</tgroup>
</table>

<para>
You can configure the USB vendor/product ID in <filename>LCDd.conf</filename>.
The wiring of the control lines can optionally be reconfigured,
please look at the driver source if you really need that.
</para>

<note><para>
The backlight line is driven high when the backlight is <literal>on</literal>.
Therefore the standard backlight circuit (<xref linkend="hd44780-connections-backlight.circuit"/>)
will not work. Use the following instead.
</para></note>

<figure id="hd44780-ftdi-backlight">
<title>hd44780/ftdi: Backlight Wiring</title>
<screen>
<![CDATA[
                                             O 5V
                                             |
                                             +--------o 15 backlight

                                             +--------o 16 GND backlight
                                             |
                           small resistor   .-.
                           10 - 47 ohm      | |
                           depending on     | |
                           display          '-'
                                             |
                                             |c
                          ___            b |/
     BL pin o------------|___|-------------|
                          4k7              |\
                                       BC547 |e
                                             |
                                            === GND
]]>
</screen>
</figure>


<para>
Alternatively you can use a single channel FTDI FT245BM USB <-> parallel
FIFO chip and use the display in its 4 bit mode.
</para>

<table id="hd44780-ftdi.4bit-mapping">
<title>HD44780: 4bit FTDI</title>
<tgroup cols="5" align="left">
<colspec colname="ftdi1"/>
<colspec colname="ftdi2" align="right"/>
<colspec colname="base" align="center"/>
<colspec colname="lcd1"/>
<colspec colname="lcd2"/>
  <thead>
    <row>
      <entry namest="ftdi1" nameend="ftdi2" align="center">FTDI chip</entry>
      <entry morerows="1"><-></entry>
      <entry namest="lcd1" nameend="lcd2" align="center">LCD</entry>
    </row>
    <row>
      <entry>name</entry>
      <entry>pin</entry>
      <entry>name</entry>
      <entry>pin</entry>
    </row>
  </thead>
  <tbody>
    <row>
      <entry>D0</entry>
      <entry>25</entry>
      <entry></entry>
      <entry>D4</entry>
      <entry>11</entry>
    </row>
    <row>
      <entry>D1</entry>
      <entry>24</entry>
      <entry></entry>
      <entry>D5</entry>
      <entry>12</entry>
    </row>
    <row>
      <entry>D2</entry>
      <entry>23</entry>
      <entry></entry>
      <entry>D6</entry>
      <entry>13</entry>
    </row>
    <row>
      <entry>D3</entry>
      <entry>22</entry>
      <entry></entry>
      <entry>D7</entry>
      <entry>14</entry>
    </row>
    <row>
      <entry>D4</entry>
      <entry>21</entry>
      <entry></entry>
      <entry>EN</entry>
      <entry>6</entry>
    </row>
    <row>
      <entry>D5</entry>
      <entry>20</entry>
      <entry></entry>
      <entry>RS</entry>
      <entry>4</entry>
    </row>
    <row>
      <entry>D6</entry>
      <entry>19</entry>
      <entry></entry>
      <entry>RW</entry>
      <entry>5</entry>
    </row>
    <row>
      <entry>D7</entry>
      <entry>18</entry>
      <entry></entry>
      <entry>BL</entry>
      <entry>Backlight (optional)</entry>
    </row>
  </tbody>
</tgroup>
</table>

<para>
The following special configuration settings are required to use a single
channel FTDI FIFO chip:
</para>

<example id="hd44780-ftdi-4bit-config.example">
<title>HD44780: Configuration for FTDI 4bit</title>
<screen>
<![CDATA[
[hd44780]
ConnectionType=ftdi
ftdi_mode=4
ftdi_line_EN=0x10
ftdi_line_RS=0x20
ftdi_line_RW=0x40
ftdi_line_backlight=0x80
]]>
</screen>
</example>


</sect3>

<sect3 id="hd44780-lis2">
<title>LIS2 USB device "lis2"</title>

<para>
LIS2 from VLSystem (<ulink url="http://www.vlsys.co.kr"></ulink>)
is a full featured USB VFD module with four channel fan controls.
This device can be accessed as a serial device with the help of the kernel
module <filename>ftdi_sio.ko</filename> that maps the USB port to a serial port
(e.g. <filename class="devicefile">/dev/ttyUSB<replaceable>x</replaceable></filename>).
</para>

</sect3>

<sect3 id="hd44780-mplay">
<title>MPlay Blast USB device "mplay"</title>

<para>
MPlay Blast from VLSystem (<ulink url="http://www.vlsys.co.kr"></ulink>)
is a full featured USB VFD module with two channel fan controls and
two channel temperature sensors.
This device can be accessed as a serial device with the help of the kernel
module <filename>ftdi_sio.ko</filename> that maps the USB port to a serial port
(e.g. <filename class="devicefile">/dev/ttyUSB<replaceable>x</replaceable></filename>).
</para>

</sect3>

<sect3 id="hd44780-los-panel">
<title>LCD on Serial panel device "los-panel"</title>

<para>The LoS-Panel is a DIY device built using an Atmel ATtiny2313 and
supports the following features:
<itemizedlist>
  <listitem><para>Drives displays with one controller.</para></listitem>
  <listitem><para>Switchable backlight.</para></listitem>
  <listitem><para>One 4x4 matrix keypad and 4 direct keys.</para></listitem>
</itemizedlist>
</para>

<note>
  <para>
    The direct keys are reported as a fifth column of a matrix keypad to LCDd.
  </para>
  <para>
    Column and rows are reported reverse (column 1 / row 1 is in the lower
    right corner) to LCDd which expects (1/1) to be the upper left corner.
    You have to take this into account when configuring keys.
  </para>
</note>

<para>
See <ulink url="http://mlf.home.xs4all.nl/los/"></ulink>
for more information on this device.
</para>

</sect3>

<sect3 id="hd44780-vdr-lcd">
<title>VDR LCD serial device "vdr-lcd"</title>

<para>
… to be documented …
</para>

<para>
Please address Matteo Pillon for further information.
</para>

</sect3>

<sect3 id="hd44780-vdr-wakeup">
<title>VDR-Wakeup module "vdr-wakeup"</title>

<para>
The VDR-Wake module by Frank Jepsen is a serial IO extension module for the
famous Linux-based VDR that allows to connect an LCD to it and supports LCDproc.
</para>

<para>
See <ulink url="http://www.jepsennet.de/vdr/"></ulink>
(German) for more information on VDR-Wakeup.
</para>

</sect3>

<sect3 id="hd44780-pertelian">
<title>Pertelian X2040 "pertelian"</title>

<para>
The Pertelian X2040 includes an HD44780 display with enclosure and USB
connection.

In order to work with <package>LCDproc</package> in Linux you need
the <filename>usbserial.ko</filename> and <filename>ftdi_sio.ko</filename>
kernel modules loaded. The display will then be available on a
serial port <filename>/dev/ttyUSB<replaceable>x</replaceable></filename>.
</para>

<para>
  See the
  <ulink url="http://pertelian.com/joomla/index.php?option=com_content&task=view&id=43&Itemid=48">
  X4020 product page</ulink> for more information.
</para>

</sect3>


<sect3 id="hd44780-picanlcd">
<title>PIC-an-LCD serial device "picanlcd"</title>

<para>
The PIC-an-LCD module is also supported. It is not connected to the LPT port
but to a serial port, which saves you from a lot of potential problems.
To use it, specify the device to which you have connected the module in the
config file with the <property>Device</property> setting.
The default is <filename>/dev/lcd</filename>.
It does not support a keypad nor backlight switching.
</para>

<note>
<para>
As of 2012 these devices are not sold anymore. Search the Internet Archive for
a copy of <ulink url="http://dalewheat.com/pdf/PIC-an-LCD.pdf" /> if you need
the manual.
</para>
</note>
</sect3>


<sect3 id="hd44780-lcdserializer">
<title>LCD serializer device "lcdserializer"</title>

<para>
LCD serializer connection is technically the same as PIC-an-LCD with the same advantages,
it uses the serial port making things really simple.
Unlike PIC-an-LCD
<ulink url="http://www.mindspring.com/~tcoonan/lcd.html">LCD serializer</ulink>
is not a commercial product. it's just a project found digging on the net and freely available.
You have all the tools and the code to build it yourself and to customize the behaviour of the device.
</para>

<sect4 id="hd44780-lcdserializer-whatyouneed">
<title>What you need</title>

<para>
<itemizedlist>
<listitem><para>Some electronic knowledge and familiarity with the soldering iron</para></listitem>
<listitem><para>A PIC16F84 (I used PIC16F84A) or PIC16C54</para></listitem>
<listitem><para><ulink url="http://jdm.homepage.dk/newpic.htm">JDM PIC programmer</ulink></para></listitem>
<listitem><para><ulink url="http://gputils.sourceforge.net/">gputils</ulink> and <ulink url="http://hyvatti.iki.fi/~jaakko/pic/picprog.html">picprog</ulink> installed on your GNU/Linux box</para></listitem>
</itemizedlist>
</para>
</sect4>

<sect4 id="hd44780-lcdserializer-burning">
<title>Burning the PIC</title>

<para>
First, you need to download the ASM source for your PIC and then make the hex:
</para>

<screen>
<prompt>$</prompt> <userinput>gpasm lcd16f84_custom.asm</userinput>
</screen>

<para>
Now the binary is ready to be flashed to the PIC.
Connect the programmer with the PIC installed and issue the following command to see it burning ;-):
</para>

<screen>
<prompt>$</prompt> <userinput>picprog --erase --burn --input lcd16f84.hex --pic /dev/ttyS0</userinput>
</screen>

</sect4>

<sect4 id="hd44780-lcdserializer-runninglcdproc">
<title>Running lcdproc</title>

<para>
It's time to build the <ulink url="http://www.mindspring.com/~tcoonan/lcdpic.html">operating circuit</ulink>,
remember this driver uses a baud rate of 9600, so JP2 need to be closed.
</para>

<para>
Now power on the board. You should see <computeroutput>OK</computeroutput> on the LCD screen.
Otherwise double-check all the connections.
</para>

<para>
Change <filename>LCDd.conf</filename> to include the following statements in the <code>[hd44780]</code> section:
</para>

<programlisting>
ConnectionType=lcdserializer
Device=/dev/ttyS0
</programlisting>

<para>
Finally, start the daemon and relax watching lcdproc running.
</para>
</sect4>
</sect3>


<sect3 id="hd44780-bwctusb">
<title>BWCT USB LCD module "bwctusb"</title>

<para>
The BWCT USB LCD module, sold by Bernd Walter Computing Technology
(<ulink url="http://www.bwct.de/lcd.html"></ulink>) is a little board
that can be piggy-packed to a HD44780 display and connects that to USB.
</para>

<para>
The board, driven by the <code>bwctusb</code> connection type,
does neither support a keypad for input, nor more than one single-controller
display, nor does it allow setting the backlight or brightness.
But you can set the display's contrast using software
(see the <property>Contrast</property> configuration parameter).
</para>

<sect4 id="hd44780-bwctusb-config">
<title>Special configuration options</title>

<para>
If there is more than one BWCT USB module connected to the system,
the <property>SerialNumber</property> configuration parameter allows
selecting which display is used in LCDd.
</para>

</sect4>

</sect3>


<sect3 id="hd44780-lcd2usb">
<title>Till Harbaum's "lcd2usb"</title>

<para>
<ulink url="http://www.harbaum.org/till/lcd2usb/">LCD2USB</ulink>
is a cheap but powerful do-it-yourself interface to connect HD44780
based displays via USB, consisting of easily available parts only.
The device supports software adjustable contrast and backlight
as well as dual controller displays (required for 4*27 and 4*40).
</para>

<para>
It is based upon an Atmel AVR Mega8 CPU with a pure software implementation
of the USB protocol for the Atmel AVR microcontroller series.
</para>

<para>
The whole interface incl. the hardware layout is under a GPL like license.
This means that you can take these schematics and use it as a basis
for your own interface e.g. for a graphic LCD.
</para>

<para>
Two keys can be connected to the LCD2USB interface board.
They can generate three key events that can be mapped to key names using
the <property>DirectKey_1</property> to <property>DirectKey_3</property> commands:
one for each key and the third if the keys are pressed simultaneously.
With this 3-key setup, menus can be used (see example below).
</para>

<para>
This driver supports the original LCD2USB interface board as described above
as well as compatible devices like those sold by <ulink url="http://www.lcdmodkit.com/">Lcdmod Kit</ulink>
or those developed by <ulink url="http://www.maltepoeggel.de/index.php?site=sp-lcd&lang=en">Malte Pöggel</ulink>.
</para>

<sect4 id="hd44780-lcd2usb-config">
<title>Special configuration options</title>

<para>
Besides the standard configuration options for <code>hd44780</code> displays, the
<code>lcd2usb</code> connection type supports three additional options:
<property>Contrast</property> to set the display's contrast,
<property>Brightness</property> to set the display's brightness when the backlight is switched on and
<property>OffBrightness</property> to set the display's brightness when is backlight is switched off.
All three options expect a number in the range from <literal>0</literal> to <literal>1000</literal>.
</para>

<example id="hd44780-lcd2usb-config.example">
<title>HD44780: Configuration for LCD2USB</title>
<screen>
<![CDATA[
[menu]
MenuKey=Escape
EnterKey=Enter
DownKey=Down

[hd44780]
ConnectionType=lcd2usb
Contrast=850
Brightness=800
OffBrightness=0
Keypad=yes
Backlight=yes
Size=20x2
KeyDirect_1=Enter
KeyDirect_2=Down
KeyDirect_3=Escape
]]>
</screen>
</example>

<tip>
 <para>
  In order to make the <code>lcd2usb</code> connection type work with a 2-controller display
  you may need to set the <property>vSpan</property> config option accordingly.
 </para>
</tip>
</sect4>

</sect3>

<sect3 id="hd44780-usbtiny">
<title>Dick Streefland's "USBtiny"</title>

<para>
<quote><ulink url="http://www.xs4all.nl/~dicks/avr/usbtiny/">USBtiny</ulink>
is a software implementation of the USB low-speed protocol for
the Atmel ATtiny microcontrollers.</quote> It is also the name of a 'reference
circuit' using the ATtiny2313.
</para>

<para>
The reference circuit features an IR receiver for remote controls and a LCD.
Due to hardware limitations of the ATtiny2313 the LCD does not have switchable
backlight, adjustable contrast, any keys, nor does it support displays with
more than one controller. If you want these features and do not require the
IR receiver we recommend to take a look at the <link linkend="hd44780-lcd2usb">LCD2USB</link>
device.
</para>

<note>
  <para>
  LCDproc does not make use of the IR receiver. 3rd party software is required
  to make it do anything, e.g. <ulink url="http://www.lirc.org/">LIRC</ulink>.
  </para>
</note>

</sect3>


<sect3 id="hd44780-uss720">
<title>USS-720 USB-to-IEEE 1284 Bridge (Belkin F5U002) "uss720"</title>

<para>
The USS-720 USB-to-IEEE 1284 Bridge is a fully featured USB to parallel chip that is used
in most (but not all) Belkin F5U002 USB Parallel Printer Adapters.  Because these adapters are
inexpensive and readily available on the second-hand market, they provide an excellent solution
for users who want to experiment with a parallel port but only have USB ports on their computers.
</para>

<para>
Because the chip acts as a parallel port, the driver maintains the same features and wiring as
the 8-bit "winamp" driver. However, because most USB Parallel Printer Adapters use a centronics
printer connector, be sure to convert the pin numbering of the parallel port pins in the "winamp"
wiring to the pin numbering of the centronics port.  Many tables are available on the internet
that illustrate how the pin numbering differs between the two.
</para>

<sect4 id="hd44780-uss720-config">
<title>Special configuration options</title>

<para>
Because several manufacturers used the USS720 chip in their USB Parallel Printer Adapters, the
<property>VendorID</property> and <property>ProductID</property> options are configurable in the
<filename>LCDd.conf</filename> file.
</para>

<note>
<para>
Not all Belkin F5U002 USB Parallel Printer Adapters used the USS720 chip.  Look for the dark grey
adapters with the removable USB cable for best results.
</para>
</note>

</sect4>

</sect3>


<sect3 id="hd44780-i2c">
<title>I<superscript>2</superscript>C with Port-Expander</title>

<para>
If you have an I<superscript>2</superscript>C port available that is supported by your kernel
(through <filename>/dev/i2c*</filename>), you can add a I<superscript>2</superscript>C
port expander there (PCF8574P in this example).
</para>

<figure id="hd44780-i2c.circuit">
<title>HD44780: PCF8574P port expander on I<superscript>2</superscript>C bus</title>
<screen>
<![CDATA[
                                       IC1
                                   -----------
                                  | PCF8574P  |
                                  | I2C-Port- |                            HD44780
                                  | Expander  |                            display
                                  |           |4
                                  |         P0|----------------------------o 11 D4
                                  |           |5
           I2C-Bus              14|         P1|----------------------------o 12 D5
    SCL o-------------------------|SCL        |6
                                  |         P2|----------------------------o 13 D6
                                15|           |7
    SDA o-------------------------|SDA      P3|----------------------------o 14 D7
                                  |           |9
                                  |1        P4|----------------------------o 4  RS
           Set I2C-Address  +-----|A0         |10
           here:            |     |2        P5|----------------------------o 5  RW
           GND: Bit:=0      +-----|A1         |11
           VCC: Bit:=1      |     |3        P6|----------------------------o 6  EN
                            +-----|A1         |                      ___
           Here: 0x00       |     |           |                 +---|___|--o 15 backlight
                           ===    |           |                 |c   10R
                                  |           |12    ___       b|/
                                  |13       P7|-----|___|-----|
                                 -|INT        |      1k       |\
                                  |           |           bc557 |e
                                   -----------                  |
                                                                |
    +5V o-----------+------------------+---------------------+--+----------o 2  VCC
                    |                  |                     |
                    |                  |                     |
                    |10uF              O 16                 .-.
                   ---                IC1                   | |<-----------o 3  Vlcd
                   ---                 O 8                  | |10k
                    |                  |                    '-'
                    |                  |                     |
    GND o-----------+-------+----------+---------------------+-------+-----o 1  GND
                            |                                        |
                           === GND                                   +-----o 16 GND Backlight
]]>
</screen>
</figure>

<sect4 id="hd44780-i2c-config">
<title>Configuration</title>

<example id="hd44780-i2c-config.example">
<title>HD44780: Configuration for I<superscript>2</superscript>C with port expander</title>
<screen>
<![CDATA[
[HD44780]
ConnectionType=i2c
Device=/dev/i2c-0
Port=0x20
Backlight=yes
Size=40x2
DelayBus=false
DelayMult=1
Keypad=no
#i2c_line_RS=0x10
#i2c_line_RW=0x20
#i2c_line_EN=0x40
#i2c_line_BL=0x80
#i2c_line_D4=0x01
#i2c_line_D5=0x02
#i2c_line_D6=0x04
#i2c_line_D7=0x08
# BacklightInvert=yes
# The Backlight Invert is used if a 0 turns the backlight on, and 1 turns it off, i.e. npn transistor
]]>
</screen>
</example>

<para>
If your port expander has different wiring you can re-assign the pins in the config file
</para>

<example id="hd44780-i2c-config.example alternative wiring">
<title>HD44780: Configuration for I<superscript>2</superscript>C with port expander 
Alternative Wiring</title>
<screen>
<![CDATA[
-   PCF8574AP: P0 P1 P2 P3 P4 P5 P6 P7
-              |  |  |  |  |  |  |  |
-   HD44780:   RS RW EN BL D4 D5 D6 D7
]]>
</screen>
</example>

<example id="hd44780-i2c-config.example alternative config">
<title>HD44780: Configuration for I<superscript>2</superscript>C with port expander
alternative config</title>
<screen>
<![CDATA[
[HD44780]
ConnectionType=i2c
Device=/dev/i2c-0
Port=0x20
Size=40x2
DelayBus=false
DelayMult=1
Keypad=no
i2c_line_RS=0x01
i2c_line_RW=0x02
i2c_line_EN=0x04
i2c_line_BL=0x08
i2c_line_D4=0x10
i2c_line_D5=0x20
i2c_line_D6=0x40
i2c_line_D7=0x80
Backlight=yes
BacklightInvert=yes
#The Backlight Invert is used if a 0 turns the backlight on, and 1 turns it off, 
i.e. PNP transistor
]]>
</screen>
</example>

<para>
The <property>Device</property> configuration setting denotes the device file
of your I<superscript>2</superscript>C bus (here <filename>/dev/i2c-0</filename>).
You have to load the kernel standard module <filename>i2c-dev.ko</filename> and
the bus driver, but <emphasis>no</emphasis> I<superscript>2</superscript>C
chip modules (e.g. <filename>pcf8574.ko</filename>)!
</para>

<para>
The <property>Port</property> config option contains the I<superscript>2</superscript>C
address of the I<superscript>2</superscript>C port expander
(here 0x20, the PCF8574 from the example above, with all address bits set to <literal>0</literal>).

Bit 8 of the address (normally <literal>0</literal> in I<superscript>2</superscript>C addresses)
has a special meaning:
It tells the driver to treat the device as PCA9554 or similar,
a device that needs a 2-byte command, and it will be stripped
off the address.
</para>

<table id="hd44780-i2c-config.portexpander-address">
<title>HD44780: Examples of I<superscript>2</superscript>C port expander addresses</title>
<tgroup cols="2" align="left">
  <thead>
    <row>
      <entry><command>Port</command> value</entry>
      <entry>Meaning</entry>
    </row>
  </thead>
  <tbody>
    <row>
      <entry><literal>0x20</literal>…<literal>0x27</literal></entry>
      <entry>PCF8574  with A[012]=<literal>0</literal>…<literal>7</literal></entry>
    </row>
    <row>
      <entry><literal>0x38</literal>…<literal>0x3f</literal></entry>
      <entry>PCF8574A with A[012]=<literal>0</literal>…<literal>7</literal></entry>
    </row>
    <row>
      <entry><literal>0xa0</literal>…<literal>0xa7</literal></entry>
      <entry>PCA9554 with A[012]=<literal>0</literal>…<literal>7</literal></entry>
    </row>
    <row>
      <entry><literal>0xa0</literal>…<literal>0xa7</literal></entry>
      <entry>PCA9554A with A[012]=<literal>0</literal>…<literal>7</literal></entry>
    </row>
  </tbody>
</tgroup>
</table>

</sect4>

</sect3>

<sect3 id="hd44780-ethlcd">
<title>ethlcd Device</title>

<para>
The ethlcd (<ulink url="http://manio.skyboo.net/ethlcd/"></ulink>) device is simply
an LCD display driven by an ATmega microcontroller, controlled and powered by
"home-made" Power over Ethernet. The hardware and software are open source.

<itemizedlist>
<title>Features</title>
<listitem><para>ethernet connection using ENC28J60 ethernet controller</para></listitem>
<listitem><para>Power over Ethernet (data and power using single UTP cable)</para></listitem>
<listitem><para>Atmel's ATmega168 microcontroller</para></listitem>
<listitem><para>6 buttons (MENU, UP, DOWN, LEFT, RIGHT, ENTER)</para></listitem>
<listitem><para>backlight control in three states: ON, Night-Mode (partialy ON) and OFF</para></listitem>
<listitem><para>beeper</para></listitem>
<listitem><para>device act as a TCP server - LCDproc driver is connecting to device just by creating
a TCP socket - no need to PC-side additional hardware besides NIC</para></listitem>
</itemizedlist>
</para>

<figure id="hd44780-connections-ethlcd.block-diagram">
<title>HD44780: ethlcd - block diagram</title>
<screen>
<![CDATA[

   _____________________________________________________
  |                    buttons                          |
  |                       ^                             |
  |                       |                             |
  |  _________       ___________         ____________   |
  | |         |     |           |       |            |  |
  | |         |     |           |       |            |  |
  | |   LCD   |     |           |  SPI  |  ENC28J60  |  |  UTP cable
  | | HD44780 |<--- | ATmega168 | <---> |  ethernet  |<========+------> PC running
  | |         |     |           |       | controller |  |      |         LCDproc
  | |         |     |           |       |            |  |      |
  | |_________|     |___________|       |____________|  |      |
  |                       |                             |      |
  |                       |                             |      |
  |                     beeper                          |      |
  |_____________________________________________________|      |
   ethlcd                                                  AC Adapter

]]>
</screen>
</figure>

<para>
The device is "visible" to LCDproc just like any other HD44780 device. The difference
is the wiring - instead of connecting the display directly to PC (via serial/parallel/usb port),
it is connected via ethernet and the communication is done over TCP connection.
The main feature is - that to power and control the LCD is needed single UTP cable.
To use the driver, specify the device IP address or hostname, on which the ethlcd device
is accessible by setting in config file the <property>Device</property> value.
The default is <filename>ethlcd</filename>.
</para>

</sect3>

<sect3 id="hd44780-usblcd">
<title>USBLCD adapter</title>

<para>
The USBLCD adapter from Adams IT Services (<ulink url="http://www.usblcd.de/"></ulink>)
is a small interface board which allows you to connect an alphanumerical display
module based on the HD44780 or compatible controller to the USB. The display
will be powered by the USB. It features a switchable backlight (on or off) and
can be used with 16x2, 16x4 or 20x4 displays.
</para>

<para>
The <code>usblcd</code> connection type communicates with a kernel
driver by using a device file <filename class="devicefile">/dev/usb/lcd<replaceable>x</replaceable></filename>.
The kernel driver providing this device currently only exists for Linux kernels
newer than 2.4.20-pre7.
</para>

<note>
<para>
As of 2007 these device are not sold anymore. This driver has been ported from
lcdproc 0.4.5 to support existing users.
</para>
</note>
</sect3>

<sect3 id="hd44780-usb4all">
<title>USB-4-all controller</title>

<para>
The USB-4-all controller board from Sprut (<ulink url="http://www.sprut.de/electronic/pic/projekte/usb4all/usb4all.htm"></ulink>)
is a small interface board which allows you to connect different hardware to the USB.
The subdriver for LCDproc supports dual HD44780 displays and a 4x4 keypad as well as
software adjustable contrast and brightness (backlight).
</para>

<table id="hd44780-usb4all-display.mapping">
<title>HD44780: USB-4-all - Display connection</title>
<tgroup cols="4" align="left">
<colspec colname="ctrl1" align="center"/>
<colspec colname="ctrl2" align="center"/>
<colspec colname="lcd1" align="center"/>
<colspec colname="lcd2" align="center"/>
  <thead>
    <row>
      <entry namest="ctrl1" nameend="ctrl2" align="center">USB-4-all</entry>
      <entry align="center">LCD1</entry>
      <entry align="center">LCD2</entry>
    </row>
    <row>
      <entry>name</entry>
      <entry>pin</entry>
      <entry>name</entry>
      <entry>name</entry>
    </row>
  </thead>
  <tbody>
    <row>
      <entry>RB7</entry>
      <entry>28</entry>
      <entry>D7</entry>
      <entry>D7</entry>
    </row>
    <row>
      <entry>RB6</entry>
      <entry>27</entry>
      <entry>D6</entry>
      <entry>D6</entry>
    </row>
    <row>
      <entry>RB5</entry>
      <entry>26</entry>
      <entry>D5</entry>
      <entry>D5</entry>
    </row>
    <row>
      <entry>RB4</entry>
      <entry>25</entry>
      <entry>D4</entry>
      <entry>D4</entry>
    </row>
    <row>
      <entry>RB3</entry>
      <entry>24</entry>
      <entry>R/W</entry>
      <entry>R/W</entry>
    </row>
    <row>
      <entry>RB2</entry>
      <entry>23</entry>
      <entry>RS</entry>
      <entry>RS</entry>
    </row>
    <row>
      <entry>RB0</entry>
      <entry>21</entry>
      <entry>EN</entry>
      <entry> </entry>
    </row>
    <row>
      <entry>RC0</entry>
      <entry>11</entry>
      <entry> </entry>
      <entry>EN</entry>
    </row>
  </tbody>
</tgroup>
</table>

<table id="hd44780-usb4all-keypad.mapping">
<title>HD44780: USB-4-all - Keypad connection</title>
<tgroup cols="3" align="left">
<colspec colname="ctrl1" align="center"/>
<colspec colname="ctrl2" align="center"/>
<colspec colname="keypad" align="center"/>
  <thead>
    <row>
      <entry namest="ctrl1" nameend="ctrl2" align="center">USB-4-all</entry>
      <entry align="center">keypad</entry>
    </row>
    <row>
      <entry>name</entry>
      <entry>pin</entry>
      <entry>name</entry>
    </row>
  </thead>
  <tbody>
    <row>
      <entry>RA0</entry>
      <entry>2</entry>
      <entry>X1</entry>
    </row>
    <row>
      <entry>RA1</entry>
      <entry>3</entry>
      <entry>X2</entry>
    </row>
    <row>
      <entry>RA2</entry>
      <entry>4</entry>
      <entry>X3</entry>
    </row>
    <row>
      <entry>RA3</entry>
      <entry>5</entry>
      <entry>X4</entry>
    </row>
    <row>
      <entry>RA4</entry>
      <entry>6</entry>
      <entry>Y1</entry>
    </row>
    <row>
      <entry>RA5</entry>
      <entry>7</entry>
      <entry>Y2</entry>
    </row>
    <row>
      <entry>RC6</entry>
      <entry>17</entry>
      <entry>Y3</entry>
    </row>
    <row>
      <entry>RC7</entry>
      <entry>18</entry>
      <entry>Y4</entry>
    </row>
  </tbody>
</tgroup>
</table>

<table id="hd44780-usb4all-analog.mapping">
<title>HD44780: USB-4-all - Brightness and contrast connection</title>
<tgroup cols="3" align="left">
<colspec colname="ctrl1" align="center"/>
<colspec colname="ctrl2" align="center"/>
<colspec colname="analog" align="center"/>
  <thead>
    <row>
      <entry namest="ctrl1" nameend="ctrl2" align="center">USB-4-all</entry>
      <entry align="center">Desc</entry>
    </row>
    <row>
      <entry>name</entry>
      <entry>pin</entry>
      <entry> </entry>
    </row>
  </thead>
  <tbody>
    <row>
      <entry>RC1</entry>
      <entry>12</entry>
      <entry>brightness</entry>
    </row>
    <row>
      <entry>RC2</entry>
      <entry>13</entry>
      <entry>contrast</entry>
    </row>
  </tbody>
</tgroup>
</table>


<figure id="hd44780-usb4all-brightness.block-diagram">
<title>HD44780: USB-4-all brightness control</title>
<screen>
<![CDATA[
                          o 5V (PIC Pin 20)
                          |
                          |e
               ___    b |/
   RC1 o------|___|-----|    pnp
               10k      |\
                          |c
                          |
                          -
                         | | 10R
                         | |
                          -
                          |
                          +---> LCD 15 (+ Backlight)

                          +---> LCD 16 (- Backlight)
                          |
                         === GND
]]>
</screen>
</figure>

<figure id="hd44780-usb4all-contrast.block-diagram">
<title>HD44780: USB-4-all contrast control</title>
<screen>
<![CDATA[
                           o 5V (PIC Pin 20)
                           |
                           -
                          | |4,7k
                          | |
                           -
                           |     ____
                           +----|____|-----+----> LCD 3 (Contrast)
                           |c    680R      |
               ___     b |/                |+
   RC2 o------|___|------|  npn           --- 10uF
               22k       |\               ---
                           |e              |
                           |               |
                           |               |
                          ===             === GND
]]>
</screen>
</figure>

</sect3>


<sect3 id="hd44780-raspberrypi">
<title>Raspberry Pi</title>

<para>This connection type supports a LCD connected to the GPIO header P1 on
a Raspberry Pi. Displays with one or two controllers are supported.</para>

<para>It supports a switchable backlight connected to pin P1-11 by default. Use
the switch circuit as described in <xref linkend="hd44780-ftdi-backlight"/>.</para>

<warning>
  <para>The signal level on the GPIO pins is 3.3 V and they are said not to
  be 5 V tolerant. Therefore the R/W pin of the display <emphasis>must
  </emphasis> be wired to GND to prevent 5V logic appearing on the GPIO
  pins. For the same reason the backlight cicuit from <xref linkend=
  "hd44780-connections-backlight.circuit"/> <emphasis>must not</emphasis> be
  used.</para>
  <para>Powering a LCD that uses 5 V from pin P1-02 will work. Powering a
  LCD from 3.3 V (pin P1-01) will only work if it is designed for 3.3 V
  operation.</para>
</warning>

<table id="hd44780-raspberrypi.pin-mapping">
<title>HD44780: Default pin mapping for Raspberry Pi</title>
<tgroup cols="5" align="left">
<colspec colname="rp1"/>
<colspec colname="rpi2" align="right"/>
<colspec colname="base" align="center"/>
<colspec colname="lcd1"/>
<colspec colname="lcd2"/>
  <thead>
    <row>
      <entry namest="rpi1" nameend="rpi2" align="center">Connector</entry>
      <entry morerows="1"><-></entry>
      <entry namest="lcd1" nameend="lcd2" align="center">LCD</entry>
    </row>
    <row>
      <entry>Pin Name</entry>
      <entry>Pin Number</entry>
      <entry>Name</entry>
      <entry>Pin</entry>
    </row>
  </thead>
  <tbody>
    <row>
      <entry>GPIO18</entry>
      <entry>P1-12</entry>
      <entry></entry>
      <entry>D7</entry>
      <entry>14</entry>
    </row>
    <row>
      <entry>GPIO23</entry>
      <entry>P1-16</entry>
      <entry></entry>
      <entry>D6</entry>
      <entry>13</entry>
    </row>
    <row>
      <entry>GPIO24</entry>
      <entry>P1-18</entry>
      <entry></entry>
      <entry>D5</entry>
      <entry>12</entry>
    </row>
    <row>
      <entry>GPIO25</entry>
      <entry>P1-22</entry>
      <entry></entry>
      <entry>D4</entry>
      <entry>11</entry>
    </row>
    <row>
      <entry>GPIO08</entry>
      <entry>P1-24</entry>
      <entry></entry>
      <entry>EN</entry>
      <entry>6</entry>
    </row>
    <row>
      <entry>GPIO07</entry>
      <entry>P1-26</entry>
      <entry></entry>
      <entry>RS</entry>
      <entry>4</entry>
    </row>
    <row>
      <entry>GND</entry>
      <entry>P1-06</entry>
      <entry></entry>
      <entry>RW</entry>
      <entry>5</entry>
    </row>
    <row>
      <entry>GPIO22</entry>
      <entry>P1-15</entry>
      <entry></entry>
      <entry>EN2</entry>
      <entry>Second controller (optional)</entry>
    </row>
    <row>
      <entry>GPIO17</entry>
      <entry>P1-11</entry>
      <entry></entry>
      <entry>BL</entry>
      <entry>Backlight (optional)</entry>
    </row>
  </tbody>
</tgroup>
</table>

<para>GPIO07 and GPIO08 used for RS and EN signal are also used by the SPI
bus. If you loaded the SPI driver you will need to assign them to a different
GPIO, e.g. GPIO04 and GPIO22.</para>

<para>When using a display with two controllers the <literal>vspan</literal>
option has to be configured as well (e.g. <literal>vspan=2,2</literal> for a
40x4 display).</para>

<sect4 id="hd44780-raspberrypi-config">
<title>Special Raspberry Pi configuration options</title>

<para>This connection driver can be configured to use other pins than the
one described in <link linkend="hd44780-raspberrypi.pin-mapping">the table
above</link>. Using the <literal>pin_<replaceable><LCD pin name>
</replaceable></literal> configuration option, any LCD pin can be assigned
to any GPIO pin.</para>

<important>
  <para>The values for the <literal>pin_<replaceable><LCD pin name>
  </replaceable></literal> configuration option are the number part from the
  GPIO signal name, not the pin number from the header connector! To find
  out which signal is routed to which connector pin refer to the <ulink url=
  "http://elinux.org/RPi_Low-level_peripherals">RPi Low-level peripherals</ulink>
  description.</para>
</important>

<para>The connection driver contains a check for possible signal names. You
will receive an error message if you try to assign a pin to a signal that is
not available on connector P1 or P5.</para>

<example id="hd44780-raspberrypi-config.example">
<title>HD44780: Alternate configuration for Raspberry Pi GPIO pins</title>
<screen>
<![CDATA[
[hd44780]
ConnectionType=raspberrypi
Backlight=yes
Size=16x2

pin_D4=25
pin_D5=24
pin_D6=23
pin_D7=18
pin_EN=8
pin_RS=7
pin_BL=17

]]>
</screen>
</example>

</sect4>
</sect3>

<sect3 id="hd44780-piplate">
<title>Adafruit Pi Plate</title>

<para>
The Adafruit RGB Positive 16x2 LCD+Keypad for Raspberry Pi (aka Pi Plate,
see (<ulink url="http://www.adafruit.com/products/1109"></ulink>)) combines
a 16x2 Character LCD, up to 3 backlight pins AND 5 keypad pins using only
the two I<superscript>2</superscript>C pins on the Rasperry Pi.
</para>

<para>
Note that this connection type drives all RGB pins of the backlight at the
same time, resulting in a white backlight. You will need to modify the
source code if you want to have some other color.
</para>

<example id="hd44780-piplate-config.example">
<title>HD44780: Configuration example for Pi Plate connection type</title>
<screen>
<![CDATA[
[hd44780]
ConnectionType=piplate
Device=/dev/i2c-1
Port=0x20
Size=16x2
Backlight=yes

Keypad=yes
KeyDirect_1=Enter
KeyDirect_2=Up
KeyDirect_3=Down
KeyDirect_4=Left
KeyDirect_5=Right
]]>
</screen>
</example>

</sect3>

<sect3 id="hd44780-pifacecad">
<title>PiFace Control and Display</title>

<para>
The <ulink url="http://www.piface.org.uk/products/piface_control_and_display/">PiFace Control and Display for Raspberry Pi</ulink>
from OpenLX SP Ltd combines a 16x2 Character LCD and navigation buttons using
the SPI bus on the Rasperry Pi.
</para>

<note>
<para>
The PiFace Control and Display features a IR receiver, which LCDproc does not
make use of. You have to setup and use LIRC for that. See
<ulink url="http://www.piface.org.uk/guides/setting_up_pifacecad/setting_up_PiFace_CAD_to_use_a_remote/">
Setting up PiFace Control And Display to use a remote</ulink>.
</para>
</note>

<example id="hd44780-pifacecad-config.example">
<title>HD44780: Configuration example for PiFace Control and Display connection type</title>
<screen>
<![CDATA[
[hd44780]
ConnectionType=pifacecad
Device=/dev/spidev0.1
Size=16x2
Backlight=yes

Keypad=yes
KeyMatrix_1_1=Left
KeyMatrix_1_2=Down
KeyMatrix_1_3=Up
KeyMatrix_1_4=Right
KeyMatrix_1_5=Escape
KeyMatrix_1_6=Enter
KeyMatrix_1_7=Left
KeyMatrix_1_8=Right
]]>
</screen>
</example>

</sect3>

</sect2>


<sect2 id="hd44780-compiling">
<title>Compiling</title>

<para>
Make sure that the HD44780 files are built when you run <command>./configure</command>.
This can be done by specifying <option>--enable-drivers=all</option> or by including
<code>hd44780</code> in the list of enabled drivers
(e.g. <option>--enable-drivers=hd44780</option>).
</para>

</sect2>


<!-- ## Hitachi HD44780 driver ## -->
<sect2 id="hd44780-config">
<title>Configuration in LCDd.conf</title>

<sect3 id="hd44780-config-section">
<title>[hd44780]</title>

<variablelist>
<varlistentry>
  <term>
    <property>Port</property> =
    <parameter><replaceable>PORT</replaceable></parameter>
  </term>
  <listitem><para>
    For parallel connections, specify the address of the parallel port the LCD is connected to.
    Common values for <replaceable>PORT</replaceable> are <literal>0x278</literal>,
    <literal>0x378</literal> and <literal>0x3BC</literal>.
    If not given, the default is <literal>0x378</literal>.
  </para><para>
    For I<superscript>2</superscript>C connection types this sets the slave
    address.
  </para></listitem>
</varlistentry>

<varlistentry>
  <term>
    <property>Device</property> =
    <parameter><replaceable>DEVICE</replaceable></parameter>
  </term>
  <listitem><para>
    If you are using a serial or I<superscript>2</superscript>C connection,
    you need to set this parameter to the device your LCD is connected to.
    For example, if the display is connected to the first serial port,
    you have to set it to <filename>/dev/ttyS0</filename>.
    The default value is <filename>/dev/lcd</filename>.
  </para></listitem>
</varlistentry>

<varlistentry>
  <term>
    <property>ConnectionType</property> =
    {
      <!-- Keep this list sorted according to the table in hd44780-drivers.h -->
      <emphasis><parameter><literal>4bit</literal></parameter></emphasis> |
      <parameter><literal>8bit</literal></parameter> |
      <parameter><literal>serialLpt</literal></parameter> |
      <parameter><literal>winamp</literal></parameter> |
      <parameter><literal>picanlcd</literal></parameter> |
      <parameter><literal>lcdserializer</literal></parameter> |
      <parameter><literal>los-panel</literal></parameter> |
      <parameter><literal>vdr-lcd</literal></parameter> |
      <parameter><literal>vdr-wakeup</literal></parameter> |
      <parameter><literal>pertelian</literal></parameter> |
      <parameter><literal>lis2</literal></parameter> |
      <parameter><literal>mplay</literal></parameter> |
      <parameter><literal>usblcd</literal></parameter> |
      <parameter><literal>bwctusb</literal></parameter> |
      <parameter><literal>lcd2usb</literal></parameter> |
      <parameter><literal>usbtiny</literal></parameter> |
      <parameter><literal>uss720</literal></parameter> |
      <parameter><literal>usb4all</literal></parameter> |
      <parameter><literal>ftdi</literal></parameter> |
      <parameter><literal>i2c</literal></parameter> |
      <parameter><literal>piplate</literal></parameter> |
      <parameter><literal>spi</literal></parameter> |
      <parameter><literal>pifacecad</literal></parameter> |
      <parameter><literal>ethlcd</literal></parameter> |
      <parameter><literal>raspberrypi</literal></parameter>
    }
  </term>
  <listitem>
    <para>
    Select the type of the wiring / display connection. See also
    (<xref linkend="hd44780-connection-types"/>).
    </para>
  </listitem>
</varlistentry>

<varlistentry>
  <term>
    <property>Speed</property> =
    <parameter><replaceable>BITRATE</replaceable></parameter>
  </term>
  <listitem><para>
      For a serial connection, set to the serial port bitrate. To use
      the default value for the chosen interface, just set to 0.
  </para></listitem>
</varlistentry>

<varlistentry>
  <term>
    <property>CharMap</property> =
    {
      <emphasis><parameter><literal>hd44780_default</literal></parameter></emphasis> |
      <parameter><literal>hd44780_euro</literal></parameter> |
      <parameter><literal>ea_ks0073</literal></parameter> |
      <parameter><literal>sed12780f_0b</literal></parameter> |
      <parameter><literal>hd44780_koi8_r</literal></parameter> |
      <parameter><literal>hd44780_cp1251</literal></parameter> |
      <parameter><literal>hd44780_8859_5</literal></parameter> |
      <parameter><literal>upd16314</literal></parameter> |
      <parameter><literal>weh001602a_1</literal></parameter> |
      <parameter><literal>none</literal></parameter>
    }
  </term>
  <listitem>
    <para>
      Set the character mapping depending on the display you have:
      <itemizedlist>
        <listitem><para>
          The default, <literal>hd44780_default</literal>, is for "classic"
          HD44780 displays.
        </para></listitem>
        <listitem><para>
          <literal>hd44780_euro</literal> is for displays with a ROM mask
          supporting the european charset (ROM code A02).
        </para></listitem>
        <listitem><para>
          <literal>ea_ks0073</literal> is the charmap for Electronic
          Assembly's KS0073 based displays. These devices have a richer
          charset, including many icons and many more characters of the
          ISO-8859-1 than standard HD44780s.
        </para></listitem>
        <listitem><para>
          <literal>sed12780f_0b</literal> is for some SED 1278 displays.
        </para></listitem>
        <listitem><para>
          The <literal>none</literal> charmap does not translate any characters.
          It displays the characters the display controllers actually has
          stored in its CGROM for that position instead. This setting is
          intended for debugging purpose.
        </para></listitem>
      </itemizedlist>
      You only need to set this parameter if you have a non-standard
      HD44780 display or charmap.
    </para>
    <para>
      If LCDproc was configured with '--enable-extra-charmaps' option the
      following character mappings are available, too:
      <itemizedlist>
        <listitem><para>
          <literal>hd44780_koi8_r</literal> maps input from a client in
          Russian KOI8-R to displays with a ROM mask supporting the european
          charset (ROM code A02).
        </para></listitem>
        <listitem><para>
          <literal>hd44780_cp1251</literal> maps input from a client in
          Russian CP1251 (Windows-1251) to displays with a ROM mask supporting
          the european charset (ROM code A02).
        </para></listitem>
        <listitem><para>
          <literal>hd44780_8859_5</literal>  maps input from a client in
          Russian ISO 8859-5 to displays with a ROM mask supporting the european
          charset (ROM code A02).
        </para></listitem>
        <listitem><para>
          <literal>upd16314</literal> is for displays with a Nec uPD16314
          vacuum fluorescent display (VFD) controller with ROM code 002
          character set. If your display has ROM code 001 character set you
          may use the <literal>hd44780_euro</literal> charmap instead.
        </para></listitem>
        <listitem><para>
          <literal>weh001602a_1</literal> is for displays such as the
          WINSTAR WEH001602A OLED display with bank font 1 (Western Europe I)
          selected. Clients should use ISO 8859-1.
        </para></listitem>
      </itemizedlist>
    </para>
    <tip>
      <para>
      See <filename>server/drivers/hd44780-charset.h</filename>
      in <package>LCDproc</package>'s source directory for the actual
      mappings.
      </para>
    </tip>
  </listitem>
</varlistentry>

<varlistentry>
  <term>
    <property>FontBank</property> =
  </term>
  <listitem><para>
      For some displays such as the WINSTAR WEH001602A, set the
      font bank to be used. Font banks are the followings
      0: English/Japanese
      1: Western Europe I
      2: English/Rusian
      3: Western Europe II
  </para></listitem>
</varlistentry>

<varlistentry>
  <term>
    <property>Keypad</property> = ¶meters.yesnodef;
  </term>
  <listitem><para>
    Tell whether you have a keypad connected.
    You may also need to configure the keypad layout further on in this file.
  </para></listitem>
</varlistentry>

<varlistentry>
  <term>
    <property>Brightness</property> =
    <parameter><replaceable>BRIGHTNESS</replaceable></parameter>
  </term>
  <listitem><para>
    Set the initial brightness when the backlight is on
    for the <literal>lcd2usb</literal> connection type.
    Legal values are <literal>0</literal> - <literal>1000</literal>,
    with <literal>800</literal> being the default.
  </para></listitem>
</varlistentry>

<varlistentry>
  <term>
    <property>OffBrightness</property> =
    <parameter><replaceable>BRIGHTNESS</replaceable></parameter>
  </term>
  <listitem><para>
    Set the initial off-brightness, i.e. the brightness when the backlight is off,
    for the <code>lcd2usb</code> connection type.
    The legal range is <literal>0</literal> - <literal>1000</literal>.
    If not given, it defaults to <literal>300</literal>.
  </para></listitem>
</varlistentry>

<varlistentry>
  <term>
    <property>Contrast</property> =
    <parameter><replaceable>CONTRAST</replaceable></parameter>
  </term>
  <listitem><para>
    Set the initial contrast for the <code>bwctusb</code> and
    <code>lcd2usb</code> connection types.
    Legal values for <replaceable>CONTRAST</replaceable> are
    <literal>0</literal> - <literal>1000</literal>.
    If not given, it defaults to <literal>500</literal> which may
    be too low or too high for the selected connection type.
    So, if the screen is blank or dark, please try playing with
    the contrast a bit.
  </para></listitem>
</varlistentry>

<varlistentry>
  <term>
    <property>Backlight</property> = ¶meters.yesnodef;
  </term>
  <listitem><para>
    Specify if you have a switchable backlight.
  </para></listitem>
</varlistentry>

<varlistentry>
  <term>
    <property>OutputPort</property> = ¶meters.yesnodef;
  </term>
  <listitem><para>
    Tell if you have the additional output port ("bargraph") and you want to
    be able to control it with the lcdproc OUTPUT command.
  </para></listitem>
</varlistentry>

<varlistentry>
  <term>
    <property>Lastline</property> = ¶meters.yesdefno;
  </term>
  <listitem><para>
    Specifies whether the lowest pixel line of a character is pixel addressable
    or if it controls an underline effect.
    The default is <literal>yes</literal>, meaning a pixel addressable last pixel line.
  </para></listitem>
</varlistentry>

<varlistentry>
  <term>
    <property>Size</property> = ¶meters.size;
  </term>
  <listitem><para>
    Specifies the size of the LCD.
    Default: <literal>20x4</literal>
    In case of multiple combined displays, this should be the total size.
  </para></listitem>
</varlistentry>

<varlistentry>
  <term>
    <property>vSpan</property> =
    <parameter>
      <replaceable>HEIGHT</replaceable>
      <literal>,</literal>…
    </parameter>
  </term>
  <listitem><para>
    The "vertical span" when using the driver with multi-controller displays
    or with multiple displays that are treated as a single virtual display.
    It is a comma separated list of the heights of each display.
    In multi-controller displays it lists the number of lines each controller
    is responsible for.
    </para>
    <para>
    E.g. <code>vSpan=2,2,1</code> means you have three physical displays, the first
    two having two lines each, and the third having one line, that together form
    a virtual display that is 5 lines high.
    </para>
    <para>
    The sum of the <replaceable>HEIGHT</replaceable>s must match the total height
    given in <code>Size=</code>.
  </para></listitem>
</varlistentry>

<varlistentry>
  <term>
    <property>ExtendedMode</property> = ¶meters.yesnodef;
  </term>
  <listitem><para>
    If you have a KS0073 or an other 'almost HD44780-compatible', set this
    flag to get into extended,4-line linear addressing mode.
  </para></listitem>
</varlistentry>

<varlistentry>
  <term>
    <property>LineAddress</property> =
    <parameter><replaceable>ADDR</replaceable></parameter>
  </term>
  <listitem><para>
    If the next line of your display doesn't start <literal>0x20</literal> higher in
    DDRAM you can override the default value of the ExtendedMode with this parameter.
  </para></listitem>
</varlistentry>

<varlistentry>
  <term>
    <property>DelayMult</property> =
    <parameter><replaceable>DELAY</replaceable></parameter>
  </term>
  <listitem><para>
    If your display is slow and cannot keep up with the flow of data from
    LCDd, garbage can appear on the LCDd. Set this delay multiplier to
    <literal>2</literal> or <literal>4</literal> to increase the delays.
    The default is <literal>1</literal> for a non-multiplied delay.
  </para></listitem>
</varlistentry>

<varlistentry>
  <term>
    <property>DelayBus</property> = ¶meters.yesdefno;
  </term>
  <listitem><para>
    You can reduce the inserted delays by setting this to <literal>no</literal>.
    On fast PCs it is possible your LCD does not respond correctly.
    Default: <literal>yes</literal>.
  </para></listitem>
</varlistentry>

<varlistentry>
  <term>
    <property>KeepAliveDisplay</property> =
    <parameter><replaceable>SECONDS</replaceable></parameter>
  </term>
  <listitem><para>
    Some displays (e.g. <code>vdr-wakeup</code>) need a message from the driver to
    indicate that it is still alive.
    When set to a value greater than <literal>0</literal> the character in the
    upper left corner is updated every <replaceable>SECONDS</replaceable> seconds.
    The default <literal>0</literal> does not cause any extra updates.
  </para></listitem>
</varlistentry>

<varlistentry>
  <term>
    <property>RefreshDisplay</property> =
    <parameter><replaceable>SECONDS</replaceable></parameter>
  </term>
  <listitem><para>
    If you experience occasional garbage on your display you can use this
    option as workaround. If set to a value greater than <literal>0</literal> it forces a
    full screen refresh every <replaceable>SECONDS</replaceable> seconds.
    Default: <literal>0</literal>.
  </para></listitem>
</varlistentry>

<varlistentry>
  <term>
    <property>KeyDirect_<replaceable>NUM</replaceable></property> =
    <parameter><replaceable>KEY</replaceable></parameter>
  </term>
  <term>
    <property>KeyMatrix_<replaceable>X</replaceable>_<replaceable>Y</replaceable></property> =
    <parameter><replaceable>KEY</replaceable></parameter>
  </term>
  <listitem>
    <para>
      If you have a keypad you can assign keystrings to the keys.
      See the <link linkend="hd44780-connections-keypad">keypad section</link>
      for used terms and the section on the specific connection type how to
      wire it.
    </para>
    <para>
      To map, for example, the directly connected key <literal>4</literal>
      to the string <literal>Enter</literal>, use <code>KeyDirect_4=Enter</code>.
      For matrix keys use the <replaceable>X</replaceable> and
      <replaceable>Y</replaceable> coordinates of the key;
      e.g. <code>KeyMatrix_1_3=Enter</code>.
    </para>
  </listitem>
</varlistentry>

<varlistentry>
  <term>
    <property>VendorID</property> =
    <parameter><replaceable>VENDORID</replaceable></parameter>
  </term>
  <listitem><para>
    USB vendor ID to look for in certain USB connection types.
    When using an FTDI chip with connection type <code>ftdi</code>, the default value is
    <literal>0x4003</literal>.
    When using a USS720 chip with connection type <code>uss720</code>, the default value is
    <literal>0x1293</literal>.
  </para></listitem>
</varlistentry>

<varlistentry>
  <term>
    <property>ProductID</property> =
    <parameter><replaceable>PRODUCTID</replaceable></parameter>
  </term>
  <listitem><para>
    USB product ID to look for in certain USB connection types.
    When using an FTDI chip with connection type <code>ftdi</code>, the default value is
    <literal>0x6001</literal>.
    When using a USS720 chip with connection type <code>uss720</code>, the default value is
    <literal>0x0002</literal>.
  </para></listitem>
</varlistentry>

<varlistentry>
  <term>
    <property>SerialNumber</property> =
    <parameter><replaceable>SERIALNO</replaceable></parameter>
  </term>
  <listitem><para>
    Serial number of the USB device to look for with
    connection type <code>bwctusb</code>.
    If not given, the first BWCT USB module found will be used.
  </para></listitem>
</varlistentry>
</variablelist>

</sect3>

</sect2>


<sect2 id="hd44780-miscellania">
<title>Miscellanea</title>

<para>
This text has originally been taken from a message by Bill Farrow
<email>bfarrow@arrow.bsee.swin.edu.au</email>.
</para>

<para>
Updated February 2000, Benjamin Tse <email>blt@ComPorts.com</email>
</para>

<para>
Updated October 2001, Joris Robijn <email>joris@robijn.net</email>
</para>

<para>
Converted to Docbook March 2002, Rene Wagner <email>reenoo@gmx.de</email>
</para>

<para>
Updated April 2002, Rene Wagner <email>reenoo@gmx.de</email>
</para>

<para>
Updated and extended April 2006 to November 2007, Peter Marschall <email>peter@adpm.de</email>
</para>

</sect2>

</sect1>
