/*
 * Decompiled with CFR 0.152.
 */
package oracle.jrockit.jfr.parser;

import java.io.Closeable;
import java.io.File;
import java.io.IOException;
import java.io.PrintWriter;
import java.io.RandomAccessFile;
import java.nio.MappedByteBuffer;
import java.nio.channels.FileChannel;
import java.util.Iterator;
import javax.xml.transform.TransformerFactory;
import javax.xml.transform.sax.SAXTransformerFactory;
import javax.xml.transform.sax.TransformerHandler;
import javax.xml.transform.stream.StreamResult;
import oracle.jrockit.jfr.parser.ChunkParser;
import oracle.jrockit.jfr.parser.FLREvent;
import oracle.jrockit.jfr.parser.FLRInput;
import oracle.jrockit.jfr.parser.MappedFLRInput;
import oracle.jrockit.jfr.parser.ParseException;
import oracle.jrockit.jfr.parser.RandomAccessFileFLRInput;
import org.xml.sax.ContentHandler;
import org.xml.sax.SAXException;
import org.xml.sax.helpers.AttributesImpl;

@Deprecated
public final class Parser
implements Iterable<ChunkParser>,
Closeable {
    private final FLRInput input;
    private long nextChunk;
    static final String JFR_URI = "http://www.oracle.com/hotspot/jvm/";
    static final String JFR_NS = "jfr";

    public Parser(String string) throws IOException {
        this(string, true);
    }

    public Parser(String string, boolean bl) throws IOException {
        this(new File(string));
    }

    public Parser(File file, boolean bl) throws IOException {
        RandomAccessFile randomAccessFile = new RandomAccessFile(file, "r");
        long l = randomAccessFile.length();
        FLRInput fLRInput = null;
        if (bl && l < 0x3200000L) {
            FileChannel fileChannel = randomAccessFile.getChannel();
            try {
                MappedByteBuffer mappedByteBuffer = fileChannel.map(FileChannel.MapMode.READ_ONLY, 0L, l);
                fLRInput = new MappedFLRInput(mappedByteBuffer);
            }
            catch (IOException iOException) {
                // empty catch block
            }
        }
        if (fLRInput == null) {
            fLRInput = new RandomAccessFileFLRInput(randomAccessFile);
        }
        this.input = fLRInput;
    }

    public Parser(File file) throws IOException {
        this(file, true);
    }

    public ChunkParser next() throws IOException, ParseException {
        if (this.nextChunk >= this.input.size()) {
            return null;
        }
        this.input.position(this.nextChunk);
        ChunkParser chunkParser = new ChunkParser(this.input);
        this.nextChunk = chunkParser.getChunkEnd();
        return chunkParser;
    }

    public void writeXML(ContentHandler contentHandler) throws SAXException, IOException, ParseException {
        ChunkParser chunkParser;
        contentHandler.startElement(JFR_URI, "flightrecording", "jfr:flightrecording", new AttributesImpl());
        while ((chunkParser = this.next()) != null) {
            chunkParser.writeXML(contentHandler);
        }
        contentHandler.endElement(JFR_URI, "flightrecording", "jfr:flightrecording");
    }

    @Override
    public Iterator<ChunkParser> iterator() {
        return new Iterator<ChunkParser>(){
            private ChunkParser p;

            @Override
            public boolean hasNext() {
                try {
                    this.p = Parser.this.next();
                }
                catch (Exception exception) {
                    throw new RuntimeException(exception);
                }
                return this.p != null;
            }

            @Override
            public ChunkParser next() {
                return this.p;
            }

            @Override
            public void remove() {
                throw new UnsupportedOperationException();
            }
        };
    }

    @Override
    public void close() throws IOException {
        this.input.close();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void main(String[] stringArray) throws Exception {
        int n = 0;
        boolean bl = false;
        if (stringArray[0].equals("-xml")) {
            bl = true;
            ++n;
        }
        try (Parser parser = new Parser(stringArray[n]);){
            if (bl) {
                TransformerFactory transformerFactory = TransformerFactory.newInstance();
                if (!transformerFactory.getFeature("http://javax.xml.transform.sax.SAXTransformerFactory/feature")) {
                    throw new SAXException("cannot construct output handler");
                }
                SAXTransformerFactory sAXTransformerFactory = (SAXTransformerFactory)transformerFactory;
                sAXTransformerFactory.setAttribute("indent-number", "3");
                TransformerHandler transformerHandler = sAXTransformerFactory.newTransformerHandler();
                transformerHandler.getTransformer().setOutputProperty("method", "xml");
                transformerHandler.getTransformer().setOutputProperty("indent", "yes");
                transformerHandler.getTransformer().setOutputProperty("encoding", "iso-8859-1");
                PrintWriter printWriter = new PrintWriter(System.out);
                transformerHandler.setResult(new StreamResult(printWriter));
                parser.writeXML(transformerHandler);
                printWriter.flush();
                return;
            }
            try {
                ChunkParser chunkParser;
                while ((chunkParser = parser.next()) != null) {
                    FLREvent fLREvent;
                    System.out.println("new chunk");
                    while ((fLREvent = chunkParser.next()) != null) {
                        System.out.println(fLREvent);
                    }
                }
            }
            finally {
                System.out.flush();
            }
        }
    }
}

