```{py:currentmodule} cantera
```

# Plug Flow Reactor

A plug flow reactor (PFR) represents a one-dimensional steady-state flow in a channel.
Perpendicular to the flow direction, the gas is assumed to be homogenous.
In the axial direction $z$, the state of the gas is allowed to change. However, all
diffusion processes are neglected.

In addition, the interior surface of the reactor may consist of one or more
catalytically active surfaces where heterogeneous reactions occur.

Plug-flow reactors are often used to simulate emission formation and catalytic
processes.

A plug flow reactor is defined by the state variables:

- $\rho$, the density of the fluid phase (in kg/m{sup}`3`)
- $u$, the velocity of the fluid phase (in m/s)
- $p$, the pressure (in Pa)
- $T$, the temperature (in K)
- $Y_k$, the mass fractions for each fluid phase species (dimensionless)
- $\theta_{i,j}$, the coverage of each surface species $i$ on each surface
  $j$ (dimensionless)

The reactor geometry is defined by the length $L$, total volume $V$, and the surface
area $A_{s,j}$ for each surface, where the surface area per unit length is assumed to be
a constant along the length of the reactor.

The governing equations for a PFR are a system of differential-algebraic equations,
which depend on the spatial derivatives of some but not all of the state variables. The
plug flow reactor model in Cantera is implemented by class {ct}`FlowReactor` and
available in Python as the {py:class}`FlowReactor` class.

## Equation of State

The fluid satisfies the ideal gas law:

$$
\rho = \frac{p \overline{W}}{R T}
$$

where $R$ is the universal gas constant and $\overline{W}$ is the mixture molecular
weight.

## Mass Conservation

The net rate per unit cross sectional area at which fluid phase species are generated by
reactions on the walls can be defined as

$$  \dot{m}_s = \sum_j \frac{A_{s,j}}{V} \left(\sum_k \dot{s}_{k,j} W_k\right)  $$

where $\dot{s}_{k,j}$ is the net rate of production of species $k$ on surface $j$ and
$W_k$ is the molecular weight of species $k$. The overall mass conservation equation for
the reactor can then be written as:

$$
u \frac{d\rho}{dz} + \rho \frac{du}{dz} = \dot{m}_s
$$ (pfr-mass)

## Momentum Conservation in the Axial Direction

$$
\rho u \frac{du}{dz} = - u \dot{m}_s - \frac{dp}{dz}
$$ (pfr-momentum)

## Energy Equation

$$
\rho u c_p \frac{dT}{dz} =
   - \sum_k \hat{h}_k \dot{\omega}_k
   - \sum_j \frac{A_{s,j}}{V} \left(\sum_k \hat{h}_k \dot{s}_{k,j}\right)
$$ (pfr-energy)

where $c_p$ is the specific heat capacity at constant pressure of the mixture and
$\hat{h}_k$ is the molar enthalpy of species $k$. Changes in kinetic energy and
gravitational potential energy are neglected.

## Gas Phase Species Equations

$$
\rho u \frac{d Y_k}{dz} = - Y_k \dot{m}_s
                          + \dot{\omega}_k W_k + \sum_j \frac{A_{s,j}}{V} \dot{s}_k W_k
$$ (pfr-species)

## Surface Phase Species Equations

Because the PFR is modeled as steady state, net rate of production for each surface
species must be zero.

$$
\dot{s}_{i,j} = 0,\quad i \ne 0
$$ (pfr-surf-species-i)

To satisfy the constraint that the total surface coverage is 1, the conservation
equation for the first surface species on each surface is replaced by this constraint:

$$
\sum_{i} \theta_{i,j} = 1
$$ (pfr-surf-species-0)

Without this constraint, the solver could find the trivial, non-physical solution
$\theta_{i,j} = 0$ for all species, since this also satisfies the steady-state equations
$\dot{s}_{i,j} = 0$.

## Integrating the PFR Equations

Because diffusion is neglected, downstream parts of the reactor have no influence on
upstream parts. Therefore, PFRs can be integrated as initial value problems, starting
from the composition at the inlet. Some care is required to determine initial values for
the algebraic variables (the surface species coverages) and the time derivatives for the
differential variables (the other state variables) that are consistent with the
governing equations.

To do this, we first solve the steady-state problem for each surface, holding the fluid
phase composition, temperature, and pressure fixed at the inlet values to determine the
values of $\theta_{i,j}(z=0)$. Then, we construct a linear system comprising the ideal
gas law, differentiated with respect to $z$ and equations (1), (2), (3), and (4)
evaluated at $z=0$. This system is then solved to obtain the values of $d\rho/dz$,
$du/dz$, $dp/dz$, $dT/dz$, and $dY_k/dz$ at $z=0$.

## Examples

- [Partial oxidation of methane over a platinum catalyst](/examples/python/reactors/surf_pfr)
- [silicon nitride (Si3N4) deposition from ammonia (NH3) and silicon tetrafluoride
  (SiF4)](/examples/python/reactors/1D_pfr_surfchem)
