// Code generated by private/model/cli/gen-api/main.go. DO NOT EDIT.

// Package kinesisvideowebrtcstorageiface provides an interface to enable mocking the Amazon Kinesis Video WebRTC Storage service client
// for testing your code.
//
// It is important to note that this interface will have breaking changes
// when the service model is updated and adds new API operations, paginators,
// and waiters.
package kinesisvideowebrtcstorageiface

import (
	"github.com/aws/aws-sdk-go/aws"
	"github.com/aws/aws-sdk-go/aws/request"
	"github.com/aws/aws-sdk-go/service/kinesisvideowebrtcstorage"
)

// KinesisVideoWebRTCStorageAPI provides an interface to enable mocking the
// kinesisvideowebrtcstorage.KinesisVideoWebRTCStorage service client's API operation,
// paginators, and waiters. This make unit testing your code that calls out
// to the SDK's service client's calls easier.
//
// The best way to use this interface is so the SDK's service client's calls
// can be stubbed out for unit testing your code with the SDK without needing
// to inject custom request handlers into the SDK's request pipeline.
//
//	// myFunc uses an SDK service client to make a request to
//	// Amazon Kinesis Video WebRTC Storage.
//	func myFunc(svc kinesisvideowebrtcstorageiface.KinesisVideoWebRTCStorageAPI) bool {
//	    // Make svc.JoinStorageSession request
//	}
//
//	func main() {
//	    sess := session.New()
//	    svc := kinesisvideowebrtcstorage.New(sess)
//
//	    myFunc(svc)
//	}
//
// In your _test.go file:
//
//	// Define a mock struct to be used in your unit tests of myFunc.
//	type mockKinesisVideoWebRTCStorageClient struct {
//	    kinesisvideowebrtcstorageiface.KinesisVideoWebRTCStorageAPI
//	}
//	func (m *mockKinesisVideoWebRTCStorageClient) JoinStorageSession(input *kinesisvideowebrtcstorage.JoinStorageSessionInput) (*kinesisvideowebrtcstorage.JoinStorageSessionOutput, error) {
//	    // mock response/functionality
//	}
//
//	func TestMyFunc(t *testing.T) {
//	    // Setup Test
//	    mockSvc := &mockKinesisVideoWebRTCStorageClient{}
//
//	    myfunc(mockSvc)
//
//	    // Verify myFunc's functionality
//	}
//
// It is important to note that this interface will have breaking changes
// when the service model is updated and adds new API operations, paginators,
// and waiters. Its suggested to use the pattern above for testing, or using
// tooling to generate mocks to satisfy the interfaces.
type KinesisVideoWebRTCStorageAPI interface {
	JoinStorageSession(*kinesisvideowebrtcstorage.JoinStorageSessionInput) (*kinesisvideowebrtcstorage.JoinStorageSessionOutput, error)
	JoinStorageSessionWithContext(aws.Context, *kinesisvideowebrtcstorage.JoinStorageSessionInput, ...request.Option) (*kinesisvideowebrtcstorage.JoinStorageSessionOutput, error)
	JoinStorageSessionRequest(*kinesisvideowebrtcstorage.JoinStorageSessionInput) (*request.Request, *kinesisvideowebrtcstorage.JoinStorageSessionOutput)

	JoinStorageSessionAsViewer(*kinesisvideowebrtcstorage.JoinStorageSessionAsViewerInput) (*kinesisvideowebrtcstorage.JoinStorageSessionAsViewerOutput, error)
	JoinStorageSessionAsViewerWithContext(aws.Context, *kinesisvideowebrtcstorage.JoinStorageSessionAsViewerInput, ...request.Option) (*kinesisvideowebrtcstorage.JoinStorageSessionAsViewerOutput, error)
	JoinStorageSessionAsViewerRequest(*kinesisvideowebrtcstorage.JoinStorageSessionAsViewerInput) (*request.Request, *kinesisvideowebrtcstorage.JoinStorageSessionAsViewerOutput)
}

var _ KinesisVideoWebRTCStorageAPI = (*kinesisvideowebrtcstorage.KinesisVideoWebRTCStorage)(nil)
