// Code generated by private/model/cli/gen-api/main.go. DO NOT EDIT.

package augmentedairuntime

import (
	"fmt"
	"time"

	"github.com/aws/aws-sdk-go/aws"
	"github.com/aws/aws-sdk-go/aws/awsutil"
	"github.com/aws/aws-sdk-go/aws/request"
	"github.com/aws/aws-sdk-go/private/protocol"
	"github.com/aws/aws-sdk-go/private/protocol/restjson"
)

const opDeleteHumanLoop = "DeleteHumanLoop"

// DeleteHumanLoopRequest generates a "aws/request.Request" representing the
// client's request for the DeleteHumanLoop operation. The "output" return
// value will be populated with the request's response once the request completes
// successfully.
//
// Use "Send" method on the returned Request to send the API call to the service.
// the "output" return value is not valid until after Send returns without error.
//
// See DeleteHumanLoop for more information on using the DeleteHumanLoop
// API call, and error handling.
//
// This method is useful when you want to inject custom logic or configuration
// into the SDK's request lifecycle. Such as custom headers, or retry logic.
//
//
//    // Example sending a request using the DeleteHumanLoopRequest method.
//    req, resp := client.DeleteHumanLoopRequest(params)
//
//    err := req.Send()
//    if err == nil { // resp is now filled
//        fmt.Println(resp)
//    }
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/sagemaker-a2i-runtime-2019-11-07/DeleteHumanLoop
func (c *AugmentedAIRuntime) DeleteHumanLoopRequest(input *DeleteHumanLoopInput) (req *request.Request, output *DeleteHumanLoopOutput) {
	op := &request.Operation{
		Name:       opDeleteHumanLoop,
		HTTPMethod: "DELETE",
		HTTPPath:   "/human-loops/{HumanLoopName}",
	}

	if input == nil {
		input = &DeleteHumanLoopInput{}
	}

	output = &DeleteHumanLoopOutput{}
	req = c.newRequest(op, input, output)
	req.Handlers.Unmarshal.Swap(restjson.UnmarshalHandler.Name, protocol.UnmarshalDiscardBodyHandler)
	return
}

// DeleteHumanLoop API operation for Amazon Augmented AI Runtime.
//
// Deletes the specified human loop for a flow definition.
//
// If the human loop was deleted, this operation will return a ResourceNotFoundException.
//
// Returns awserr.Error for service API and SDK errors. Use runtime type assertions
// with awserr.Error's Code and Message methods to get detailed information about
// the error.
//
// See the AWS API reference guide for Amazon Augmented AI Runtime's
// API operation DeleteHumanLoop for usage and error information.
//
// Returned Error Types:
//   * ValidationException
//   The request isn't valid. Check the syntax and try again.
//
//   * ResourceNotFoundException
//   We couldn't find the requested resource. Check that your resources exists
//   and were created in the same AWS Region as your request, and try your request
//   again.
//
//   * ThrottlingException
//   You exceeded the maximum number of requests.
//
//   * InternalServerException
//   We couldn't process your request because of an issue with the server. Try
//   again later.
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/sagemaker-a2i-runtime-2019-11-07/DeleteHumanLoop
func (c *AugmentedAIRuntime) DeleteHumanLoop(input *DeleteHumanLoopInput) (*DeleteHumanLoopOutput, error) {
	req, out := c.DeleteHumanLoopRequest(input)
	return out, req.Send()
}

// DeleteHumanLoopWithContext is the same as DeleteHumanLoop with the addition of
// the ability to pass a context and additional request options.
//
// See DeleteHumanLoop for details on how to use this API operation.
//
// The context must be non-nil and will be used for request cancellation. If
// the context is nil a panic will occur. In the future the SDK may create
// sub-contexts for http.Requests. See https://golang.org/pkg/context/
// for more information on using Contexts.
func (c *AugmentedAIRuntime) DeleteHumanLoopWithContext(ctx aws.Context, input *DeleteHumanLoopInput, opts ...request.Option) (*DeleteHumanLoopOutput, error) {
	req, out := c.DeleteHumanLoopRequest(input)
	req.SetContext(ctx)
	req.ApplyOptions(opts...)
	return out, req.Send()
}

const opDescribeHumanLoop = "DescribeHumanLoop"

// DescribeHumanLoopRequest generates a "aws/request.Request" representing the
// client's request for the DescribeHumanLoop operation. The "output" return
// value will be populated with the request's response once the request completes
// successfully.
//
// Use "Send" method on the returned Request to send the API call to the service.
// the "output" return value is not valid until after Send returns without error.
//
// See DescribeHumanLoop for more information on using the DescribeHumanLoop
// API call, and error handling.
//
// This method is useful when you want to inject custom logic or configuration
// into the SDK's request lifecycle. Such as custom headers, or retry logic.
//
//
//    // Example sending a request using the DescribeHumanLoopRequest method.
//    req, resp := client.DescribeHumanLoopRequest(params)
//
//    err := req.Send()
//    if err == nil { // resp is now filled
//        fmt.Println(resp)
//    }
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/sagemaker-a2i-runtime-2019-11-07/DescribeHumanLoop
func (c *AugmentedAIRuntime) DescribeHumanLoopRequest(input *DescribeHumanLoopInput) (req *request.Request, output *DescribeHumanLoopOutput) {
	op := &request.Operation{
		Name:       opDescribeHumanLoop,
		HTTPMethod: "GET",
		HTTPPath:   "/human-loops/{HumanLoopName}",
	}

	if input == nil {
		input = &DescribeHumanLoopInput{}
	}

	output = &DescribeHumanLoopOutput{}
	req = c.newRequest(op, input, output)
	return
}

// DescribeHumanLoop API operation for Amazon Augmented AI Runtime.
//
// Returns information about the specified human loop. If the human loop was
// deleted, this operation will return a ResourceNotFoundException error.
//
// Returns awserr.Error for service API and SDK errors. Use runtime type assertions
// with awserr.Error's Code and Message methods to get detailed information about
// the error.
//
// See the AWS API reference guide for Amazon Augmented AI Runtime's
// API operation DescribeHumanLoop for usage and error information.
//
// Returned Error Types:
//   * ValidationException
//   The request isn't valid. Check the syntax and try again.
//
//   * ResourceNotFoundException
//   We couldn't find the requested resource. Check that your resources exists
//   and were created in the same AWS Region as your request, and try your request
//   again.
//
//   * ThrottlingException
//   You exceeded the maximum number of requests.
//
//   * InternalServerException
//   We couldn't process your request because of an issue with the server. Try
//   again later.
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/sagemaker-a2i-runtime-2019-11-07/DescribeHumanLoop
func (c *AugmentedAIRuntime) DescribeHumanLoop(input *DescribeHumanLoopInput) (*DescribeHumanLoopOutput, error) {
	req, out := c.DescribeHumanLoopRequest(input)
	return out, req.Send()
}

// DescribeHumanLoopWithContext is the same as DescribeHumanLoop with the addition of
// the ability to pass a context and additional request options.
//
// See DescribeHumanLoop for details on how to use this API operation.
//
// The context must be non-nil and will be used for request cancellation. If
// the context is nil a panic will occur. In the future the SDK may create
// sub-contexts for http.Requests. See https://golang.org/pkg/context/
// for more information on using Contexts.
func (c *AugmentedAIRuntime) DescribeHumanLoopWithContext(ctx aws.Context, input *DescribeHumanLoopInput, opts ...request.Option) (*DescribeHumanLoopOutput, error) {
	req, out := c.DescribeHumanLoopRequest(input)
	req.SetContext(ctx)
	req.ApplyOptions(opts...)
	return out, req.Send()
}

const opListHumanLoops = "ListHumanLoops"

// ListHumanLoopsRequest generates a "aws/request.Request" representing the
// client's request for the ListHumanLoops operation. The "output" return
// value will be populated with the request's response once the request completes
// successfully.
//
// Use "Send" method on the returned Request to send the API call to the service.
// the "output" return value is not valid until after Send returns without error.
//
// See ListHumanLoops for more information on using the ListHumanLoops
// API call, and error handling.
//
// This method is useful when you want to inject custom logic or configuration
// into the SDK's request lifecycle. Such as custom headers, or retry logic.
//
//
//    // Example sending a request using the ListHumanLoopsRequest method.
//    req, resp := client.ListHumanLoopsRequest(params)
//
//    err := req.Send()
//    if err == nil { // resp is now filled
//        fmt.Println(resp)
//    }
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/sagemaker-a2i-runtime-2019-11-07/ListHumanLoops
func (c *AugmentedAIRuntime) ListHumanLoopsRequest(input *ListHumanLoopsInput) (req *request.Request, output *ListHumanLoopsOutput) {
	op := &request.Operation{
		Name:       opListHumanLoops,
		HTTPMethod: "GET",
		HTTPPath:   "/human-loops",
		Paginator: &request.Paginator{
			InputTokens:     []string{"NextToken"},
			OutputTokens:    []string{"NextToken"},
			LimitToken:      "MaxResults",
			TruncationToken: "",
		},
	}

	if input == nil {
		input = &ListHumanLoopsInput{}
	}

	output = &ListHumanLoopsOutput{}
	req = c.newRequest(op, input, output)
	return
}

// ListHumanLoops API operation for Amazon Augmented AI Runtime.
//
// Returns information about human loops, given the specified parameters. If
// a human loop was deleted, it will not be included.
//
// Returns awserr.Error for service API and SDK errors. Use runtime type assertions
// with awserr.Error's Code and Message methods to get detailed information about
// the error.
//
// See the AWS API reference guide for Amazon Augmented AI Runtime's
// API operation ListHumanLoops for usage and error information.
//
// Returned Error Types:
//   * ValidationException
//   The request isn't valid. Check the syntax and try again.
//
//   * ResourceNotFoundException
//   We couldn't find the requested resource. Check that your resources exists
//   and were created in the same AWS Region as your request, and try your request
//   again.
//
//   * ThrottlingException
//   You exceeded the maximum number of requests.
//
//   * InternalServerException
//   We couldn't process your request because of an issue with the server. Try
//   again later.
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/sagemaker-a2i-runtime-2019-11-07/ListHumanLoops
func (c *AugmentedAIRuntime) ListHumanLoops(input *ListHumanLoopsInput) (*ListHumanLoopsOutput, error) {
	req, out := c.ListHumanLoopsRequest(input)
	return out, req.Send()
}

// ListHumanLoopsWithContext is the same as ListHumanLoops with the addition of
// the ability to pass a context and additional request options.
//
// See ListHumanLoops for details on how to use this API operation.
//
// The context must be non-nil and will be used for request cancellation. If
// the context is nil a panic will occur. In the future the SDK may create
// sub-contexts for http.Requests. See https://golang.org/pkg/context/
// for more information on using Contexts.
func (c *AugmentedAIRuntime) ListHumanLoopsWithContext(ctx aws.Context, input *ListHumanLoopsInput, opts ...request.Option) (*ListHumanLoopsOutput, error) {
	req, out := c.ListHumanLoopsRequest(input)
	req.SetContext(ctx)
	req.ApplyOptions(opts...)
	return out, req.Send()
}

// ListHumanLoopsPages iterates over the pages of a ListHumanLoops operation,
// calling the "fn" function with the response data for each page. To stop
// iterating, return false from the fn function.
//
// See ListHumanLoops method for more information on how to use this operation.
//
// Note: This operation can generate multiple requests to a service.
//
//    // Example iterating over at most 3 pages of a ListHumanLoops operation.
//    pageNum := 0
//    err := client.ListHumanLoopsPages(params,
//        func(page *augmentedairuntime.ListHumanLoopsOutput, lastPage bool) bool {
//            pageNum++
//            fmt.Println(page)
//            return pageNum <= 3
//        })
//
func (c *AugmentedAIRuntime) ListHumanLoopsPages(input *ListHumanLoopsInput, fn func(*ListHumanLoopsOutput, bool) bool) error {
	return c.ListHumanLoopsPagesWithContext(aws.BackgroundContext(), input, fn)
}

// ListHumanLoopsPagesWithContext same as ListHumanLoopsPages except
// it takes a Context and allows setting request options on the pages.
//
// The context must be non-nil and will be used for request cancellation. If
// the context is nil a panic will occur. In the future the SDK may create
// sub-contexts for http.Requests. See https://golang.org/pkg/context/
// for more information on using Contexts.
func (c *AugmentedAIRuntime) ListHumanLoopsPagesWithContext(ctx aws.Context, input *ListHumanLoopsInput, fn func(*ListHumanLoopsOutput, bool) bool, opts ...request.Option) error {
	p := request.Pagination{
		NewRequest: func() (*request.Request, error) {
			var inCpy *ListHumanLoopsInput
			if input != nil {
				tmp := *input
				inCpy = &tmp
			}
			req, _ := c.ListHumanLoopsRequest(inCpy)
			req.SetContext(ctx)
			req.ApplyOptions(opts...)
			return req, nil
		},
	}

	for p.Next() {
		if !fn(p.Page().(*ListHumanLoopsOutput), !p.HasNextPage()) {
			break
		}
	}

	return p.Err()
}

const opStartHumanLoop = "StartHumanLoop"

// StartHumanLoopRequest generates a "aws/request.Request" representing the
// client's request for the StartHumanLoop operation. The "output" return
// value will be populated with the request's response once the request completes
// successfully.
//
// Use "Send" method on the returned Request to send the API call to the service.
// the "output" return value is not valid until after Send returns without error.
//
// See StartHumanLoop for more information on using the StartHumanLoop
// API call, and error handling.
//
// This method is useful when you want to inject custom logic or configuration
// into the SDK's request lifecycle. Such as custom headers, or retry logic.
//
//
//    // Example sending a request using the StartHumanLoopRequest method.
//    req, resp := client.StartHumanLoopRequest(params)
//
//    err := req.Send()
//    if err == nil { // resp is now filled
//        fmt.Println(resp)
//    }
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/sagemaker-a2i-runtime-2019-11-07/StartHumanLoop
func (c *AugmentedAIRuntime) StartHumanLoopRequest(input *StartHumanLoopInput) (req *request.Request, output *StartHumanLoopOutput) {
	op := &request.Operation{
		Name:       opStartHumanLoop,
		HTTPMethod: "POST",
		HTTPPath:   "/human-loops",
	}

	if input == nil {
		input = &StartHumanLoopInput{}
	}

	output = &StartHumanLoopOutput{}
	req = c.newRequest(op, input, output)
	return
}

// StartHumanLoop API operation for Amazon Augmented AI Runtime.
//
// Starts a human loop, provided that at least one activation condition is met.
//
// Returns awserr.Error for service API and SDK errors. Use runtime type assertions
// with awserr.Error's Code and Message methods to get detailed information about
// the error.
//
// See the AWS API reference guide for Amazon Augmented AI Runtime's
// API operation StartHumanLoop for usage and error information.
//
// Returned Error Types:
//   * ValidationException
//   The request isn't valid. Check the syntax and try again.
//
//   * ThrottlingException
//   You exceeded the maximum number of requests.
//
//   * ServiceQuotaExceededException
//   You exceeded your service quota. Service quotas, also referred to as limits,
//   are the maximum number of service resources or operations for your AWS account.
//   For a list of Amazon A2I service quotes, see Amazon Augmented AI Service
//   Quotes (https://docs.aws.amazon.com/general/latest/gr/a2i.html). Delete some
//   resources or request an increase in your service quota. You can request a
//   quota increase using Service Quotas or the AWS Support Center. To request
//   an increase, see AWS Service Quotas (https://docs.aws.amazon.com/general/latest/gr/aws_service_limits.html)
//   in the AWS General Reference.
//
//   * InternalServerException
//   We couldn't process your request because of an issue with the server. Try
//   again later.
//
//   * ConflictException
//   Your request has the same name as another active human loop but has different
//   input data. You cannot start two human loops with the same name and different
//   input data.
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/sagemaker-a2i-runtime-2019-11-07/StartHumanLoop
func (c *AugmentedAIRuntime) StartHumanLoop(input *StartHumanLoopInput) (*StartHumanLoopOutput, error) {
	req, out := c.StartHumanLoopRequest(input)
	return out, req.Send()
}

// StartHumanLoopWithContext is the same as StartHumanLoop with the addition of
// the ability to pass a context and additional request options.
//
// See StartHumanLoop for details on how to use this API operation.
//
// The context must be non-nil and will be used for request cancellation. If
// the context is nil a panic will occur. In the future the SDK may create
// sub-contexts for http.Requests. See https://golang.org/pkg/context/
// for more information on using Contexts.
func (c *AugmentedAIRuntime) StartHumanLoopWithContext(ctx aws.Context, input *StartHumanLoopInput, opts ...request.Option) (*StartHumanLoopOutput, error) {
	req, out := c.StartHumanLoopRequest(input)
	req.SetContext(ctx)
	req.ApplyOptions(opts...)
	return out, req.Send()
}

const opStopHumanLoop = "StopHumanLoop"

// StopHumanLoopRequest generates a "aws/request.Request" representing the
// client's request for the StopHumanLoop operation. The "output" return
// value will be populated with the request's response once the request completes
// successfully.
//
// Use "Send" method on the returned Request to send the API call to the service.
// the "output" return value is not valid until after Send returns without error.
//
// See StopHumanLoop for more information on using the StopHumanLoop
// API call, and error handling.
//
// This method is useful when you want to inject custom logic or configuration
// into the SDK's request lifecycle. Such as custom headers, or retry logic.
//
//
//    // Example sending a request using the StopHumanLoopRequest method.
//    req, resp := client.StopHumanLoopRequest(params)
//
//    err := req.Send()
//    if err == nil { // resp is now filled
//        fmt.Println(resp)
//    }
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/sagemaker-a2i-runtime-2019-11-07/StopHumanLoop
func (c *AugmentedAIRuntime) StopHumanLoopRequest(input *StopHumanLoopInput) (req *request.Request, output *StopHumanLoopOutput) {
	op := &request.Operation{
		Name:       opStopHumanLoop,
		HTTPMethod: "POST",
		HTTPPath:   "/human-loops/stop",
	}

	if input == nil {
		input = &StopHumanLoopInput{}
	}

	output = &StopHumanLoopOutput{}
	req = c.newRequest(op, input, output)
	req.Handlers.Unmarshal.Swap(restjson.UnmarshalHandler.Name, protocol.UnmarshalDiscardBodyHandler)
	return
}

// StopHumanLoop API operation for Amazon Augmented AI Runtime.
//
// Stops the specified human loop.
//
// Returns awserr.Error for service API and SDK errors. Use runtime type assertions
// with awserr.Error's Code and Message methods to get detailed information about
// the error.
//
// See the AWS API reference guide for Amazon Augmented AI Runtime's
// API operation StopHumanLoop for usage and error information.
//
// Returned Error Types:
//   * ValidationException
//   The request isn't valid. Check the syntax and try again.
//
//   * ResourceNotFoundException
//   We couldn't find the requested resource. Check that your resources exists
//   and were created in the same AWS Region as your request, and try your request
//   again.
//
//   * ThrottlingException
//   You exceeded the maximum number of requests.
//
//   * InternalServerException
//   We couldn't process your request because of an issue with the server. Try
//   again later.
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/sagemaker-a2i-runtime-2019-11-07/StopHumanLoop
func (c *AugmentedAIRuntime) StopHumanLoop(input *StopHumanLoopInput) (*StopHumanLoopOutput, error) {
	req, out := c.StopHumanLoopRequest(input)
	return out, req.Send()
}

// StopHumanLoopWithContext is the same as StopHumanLoop with the addition of
// the ability to pass a context and additional request options.
//
// See StopHumanLoop for details on how to use this API operation.
//
// The context must be non-nil and will be used for request cancellation. If
// the context is nil a panic will occur. In the future the SDK may create
// sub-contexts for http.Requests. See https://golang.org/pkg/context/
// for more information on using Contexts.
func (c *AugmentedAIRuntime) StopHumanLoopWithContext(ctx aws.Context, input *StopHumanLoopInput, opts ...request.Option) (*StopHumanLoopOutput, error) {
	req, out := c.StopHumanLoopRequest(input)
	req.SetContext(ctx)
	req.ApplyOptions(opts...)
	return out, req.Send()
}

// Your request has the same name as another active human loop but has different
// input data. You cannot start two human loops with the same name and different
// input data.
type ConflictException struct {
	_            struct{}                  `type:"structure"`
	RespMetadata protocol.ResponseMetadata `json:"-" xml:"-"`

	Message_ *string `locationName:"Message" type:"string"`
}

// String returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s ConflictException) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s ConflictException) GoString() string {
	return s.String()
}

func newErrorConflictException(v protocol.ResponseMetadata) error {
	return &ConflictException{
		RespMetadata: v,
	}
}

// Code returns the exception type name.
func (s *ConflictException) Code() string {
	return "ConflictException"
}

// Message returns the exception's message.
func (s *ConflictException) Message() string {
	if s.Message_ != nil {
		return *s.Message_
	}
	return ""
}

// OrigErr always returns nil, satisfies awserr.Error interface.
func (s *ConflictException) OrigErr() error {
	return nil
}

func (s *ConflictException) Error() string {
	return fmt.Sprintf("%s: %s", s.Code(), s.Message())
}

// Status code returns the HTTP status code for the request's response error.
func (s *ConflictException) StatusCode() int {
	return s.RespMetadata.StatusCode
}

// RequestID returns the service's response RequestID for request.
func (s *ConflictException) RequestID() string {
	return s.RespMetadata.RequestID
}

type DeleteHumanLoopInput struct {
	_ struct{} `type:"structure" nopayload:"true"`

	// The name of the human loop that you want to delete.
	//
	// HumanLoopName is a required field
	HumanLoopName *string `location:"uri" locationName:"HumanLoopName" min:"1" type:"string" required:"true"`
}

// String returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s DeleteHumanLoopInput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s DeleteHumanLoopInput) GoString() string {
	return s.String()
}

// Validate inspects the fields of the type to determine if they are valid.
func (s *DeleteHumanLoopInput) Validate() error {
	invalidParams := request.ErrInvalidParams{Context: "DeleteHumanLoopInput"}
	if s.HumanLoopName == nil {
		invalidParams.Add(request.NewErrParamRequired("HumanLoopName"))
	}
	if s.HumanLoopName != nil && len(*s.HumanLoopName) < 1 {
		invalidParams.Add(request.NewErrParamMinLen("HumanLoopName", 1))
	}

	if invalidParams.Len() > 0 {
		return invalidParams
	}
	return nil
}

// SetHumanLoopName sets the HumanLoopName field's value.
func (s *DeleteHumanLoopInput) SetHumanLoopName(v string) *DeleteHumanLoopInput {
	s.HumanLoopName = &v
	return s
}

type DeleteHumanLoopOutput struct {
	_ struct{} `type:"structure"`
}

// String returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s DeleteHumanLoopOutput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s DeleteHumanLoopOutput) GoString() string {
	return s.String()
}

type DescribeHumanLoopInput struct {
	_ struct{} `type:"structure" nopayload:"true"`

	// The name of the human loop that you want information about.
	//
	// HumanLoopName is a required field
	HumanLoopName *string `location:"uri" locationName:"HumanLoopName" min:"1" type:"string" required:"true"`
}

// String returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s DescribeHumanLoopInput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s DescribeHumanLoopInput) GoString() string {
	return s.String()
}

// Validate inspects the fields of the type to determine if they are valid.
func (s *DescribeHumanLoopInput) Validate() error {
	invalidParams := request.ErrInvalidParams{Context: "DescribeHumanLoopInput"}
	if s.HumanLoopName == nil {
		invalidParams.Add(request.NewErrParamRequired("HumanLoopName"))
	}
	if s.HumanLoopName != nil && len(*s.HumanLoopName) < 1 {
		invalidParams.Add(request.NewErrParamMinLen("HumanLoopName", 1))
	}

	if invalidParams.Len() > 0 {
		return invalidParams
	}
	return nil
}

// SetHumanLoopName sets the HumanLoopName field's value.
func (s *DescribeHumanLoopInput) SetHumanLoopName(v string) *DescribeHumanLoopInput {
	s.HumanLoopName = &v
	return s
}

type DescribeHumanLoopOutput struct {
	_ struct{} `type:"structure"`

	// The creation time when Amazon Augmented AI created the human loop.
	//
	// CreationTime is a required field
	CreationTime *time.Time `type:"timestamp" required:"true"`

	// A failure code that identifies the type of failure.
	//
	// Possible values: ValidationError, Expired, InternalError
	FailureCode *string `type:"string"`

	// The reason why a human loop failed. The failure reason is returned when the
	// status of the human loop is Failed.
	FailureReason *string `type:"string"`

	// The Amazon Resource Name (ARN) of the flow definition.
	//
	// FlowDefinitionArn is a required field
	FlowDefinitionArn *string `type:"string" required:"true"`

	// The Amazon Resource Name (ARN) of the human loop.
	//
	// HumanLoopArn is a required field
	HumanLoopArn *string `type:"string" required:"true"`

	// The name of the human loop. The name must be lowercase, unique within the
	// Region in your account, and can have up to 63 characters. Valid characters:
	// a-z, 0-9, and - (hyphen).
	//
	// HumanLoopName is a required field
	HumanLoopName *string `min:"1" type:"string" required:"true"`

	// An object that contains information about the output of the human loop.
	HumanLoopOutput *HumanLoopOutput `type:"structure"`

	// The status of the human loop.
	//
	// HumanLoopStatus is a required field
	HumanLoopStatus *string `type:"string" required:"true" enum:"HumanLoopStatus"`
}

// String returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s DescribeHumanLoopOutput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s DescribeHumanLoopOutput) GoString() string {
	return s.String()
}

// SetCreationTime sets the CreationTime field's value.
func (s *DescribeHumanLoopOutput) SetCreationTime(v time.Time) *DescribeHumanLoopOutput {
	s.CreationTime = &v
	return s
}

// SetFailureCode sets the FailureCode field's value.
func (s *DescribeHumanLoopOutput) SetFailureCode(v string) *DescribeHumanLoopOutput {
	s.FailureCode = &v
	return s
}

// SetFailureReason sets the FailureReason field's value.
func (s *DescribeHumanLoopOutput) SetFailureReason(v string) *DescribeHumanLoopOutput {
	s.FailureReason = &v
	return s
}

// SetFlowDefinitionArn sets the FlowDefinitionArn field's value.
func (s *DescribeHumanLoopOutput) SetFlowDefinitionArn(v string) *DescribeHumanLoopOutput {
	s.FlowDefinitionArn = &v
	return s
}

// SetHumanLoopArn sets the HumanLoopArn field's value.
func (s *DescribeHumanLoopOutput) SetHumanLoopArn(v string) *DescribeHumanLoopOutput {
	s.HumanLoopArn = &v
	return s
}

// SetHumanLoopName sets the HumanLoopName field's value.
func (s *DescribeHumanLoopOutput) SetHumanLoopName(v string) *DescribeHumanLoopOutput {
	s.HumanLoopName = &v
	return s
}

// SetHumanLoopOutput sets the HumanLoopOutput field's value.
func (s *DescribeHumanLoopOutput) SetHumanLoopOutput(v *HumanLoopOutput) *DescribeHumanLoopOutput {
	s.HumanLoopOutput = v
	return s
}

// SetHumanLoopStatus sets the HumanLoopStatus field's value.
func (s *DescribeHumanLoopOutput) SetHumanLoopStatus(v string) *DescribeHumanLoopOutput {
	s.HumanLoopStatus = &v
	return s
}

// Attributes of the data specified by the customer. Use these to describe the
// data to be labeled.
type HumanLoopDataAttributes struct {
	_ struct{} `type:"structure"`

	// Declares that your content is free of personally identifiable information
	// or adult content.
	//
	// Amazon SageMaker can restrict the Amazon Mechanical Turk workers who can
	// view your task based on this information.
	//
	// ContentClassifiers is a required field
	ContentClassifiers []*string `type:"list" required:"true" enum:"ContentClassifier"`
}

// String returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s HumanLoopDataAttributes) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s HumanLoopDataAttributes) GoString() string {
	return s.String()
}

// Validate inspects the fields of the type to determine if they are valid.
func (s *HumanLoopDataAttributes) Validate() error {
	invalidParams := request.ErrInvalidParams{Context: "HumanLoopDataAttributes"}
	if s.ContentClassifiers == nil {
		invalidParams.Add(request.NewErrParamRequired("ContentClassifiers"))
	}

	if invalidParams.Len() > 0 {
		return invalidParams
	}
	return nil
}

// SetContentClassifiers sets the ContentClassifiers field's value.
func (s *HumanLoopDataAttributes) SetContentClassifiers(v []*string) *HumanLoopDataAttributes {
	s.ContentClassifiers = v
	return s
}

// An object containing the human loop input in JSON format.
type HumanLoopInput struct {
	_ struct{} `type:"structure"`

	// Serialized input from the human loop. The input must be a string representation
	// of a file in JSON format.
	//
	// InputContent is a required field
	InputContent *string `type:"string" required:"true"`
}

// String returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s HumanLoopInput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s HumanLoopInput) GoString() string {
	return s.String()
}

// Validate inspects the fields of the type to determine if they are valid.
func (s *HumanLoopInput) Validate() error {
	invalidParams := request.ErrInvalidParams{Context: "HumanLoopInput"}
	if s.InputContent == nil {
		invalidParams.Add(request.NewErrParamRequired("InputContent"))
	}

	if invalidParams.Len() > 0 {
		return invalidParams
	}
	return nil
}

// SetInputContent sets the InputContent field's value.
func (s *HumanLoopInput) SetInputContent(v string) *HumanLoopInput {
	s.InputContent = &v
	return s
}

// Information about where the human output will be stored.
type HumanLoopOutput struct {
	_ struct{} `type:"structure"`

	// The location of the Amazon S3 object where Amazon Augmented AI stores your
	// human loop output.
	//
	// OutputS3Uri is a required field
	OutputS3Uri *string `type:"string" required:"true"`
}

// String returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s HumanLoopOutput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s HumanLoopOutput) GoString() string {
	return s.String()
}

// SetOutputS3Uri sets the OutputS3Uri field's value.
func (s *HumanLoopOutput) SetOutputS3Uri(v string) *HumanLoopOutput {
	s.OutputS3Uri = &v
	return s
}

// Summary information about the human loop.
type HumanLoopSummary struct {
	_ struct{} `type:"structure"`

	// When Amazon Augmented AI created the human loop.
	CreationTime *time.Time `type:"timestamp"`

	// The reason why the human loop failed. A failure reason is returned when the
	// status of the human loop is Failed.
	FailureReason *string `type:"string"`

	// The Amazon Resource Name (ARN) of the flow definition used to configure the
	// human loop.
	FlowDefinitionArn *string `type:"string"`

	// The name of the human loop.
	HumanLoopName *string `min:"1" type:"string"`

	// The status of the human loop.
	HumanLoopStatus *string `type:"string" enum:"HumanLoopStatus"`
}

// String returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s HumanLoopSummary) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s HumanLoopSummary) GoString() string {
	return s.String()
}

// SetCreationTime sets the CreationTime field's value.
func (s *HumanLoopSummary) SetCreationTime(v time.Time) *HumanLoopSummary {
	s.CreationTime = &v
	return s
}

// SetFailureReason sets the FailureReason field's value.
func (s *HumanLoopSummary) SetFailureReason(v string) *HumanLoopSummary {
	s.FailureReason = &v
	return s
}

// SetFlowDefinitionArn sets the FlowDefinitionArn field's value.
func (s *HumanLoopSummary) SetFlowDefinitionArn(v string) *HumanLoopSummary {
	s.FlowDefinitionArn = &v
	return s
}

// SetHumanLoopName sets the HumanLoopName field's value.
func (s *HumanLoopSummary) SetHumanLoopName(v string) *HumanLoopSummary {
	s.HumanLoopName = &v
	return s
}

// SetHumanLoopStatus sets the HumanLoopStatus field's value.
func (s *HumanLoopSummary) SetHumanLoopStatus(v string) *HumanLoopSummary {
	s.HumanLoopStatus = &v
	return s
}

// We couldn't process your request because of an issue with the server. Try
// again later.
type InternalServerException struct {
	_            struct{}                  `type:"structure"`
	RespMetadata protocol.ResponseMetadata `json:"-" xml:"-"`

	Message_ *string `locationName:"Message" type:"string"`
}

// String returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s InternalServerException) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s InternalServerException) GoString() string {
	return s.String()
}

func newErrorInternalServerException(v protocol.ResponseMetadata) error {
	return &InternalServerException{
		RespMetadata: v,
	}
}

// Code returns the exception type name.
func (s *InternalServerException) Code() string {
	return "InternalServerException"
}

// Message returns the exception's message.
func (s *InternalServerException) Message() string {
	if s.Message_ != nil {
		return *s.Message_
	}
	return ""
}

// OrigErr always returns nil, satisfies awserr.Error interface.
func (s *InternalServerException) OrigErr() error {
	return nil
}

func (s *InternalServerException) Error() string {
	return fmt.Sprintf("%s: %s", s.Code(), s.Message())
}

// Status code returns the HTTP status code for the request's response error.
func (s *InternalServerException) StatusCode() int {
	return s.RespMetadata.StatusCode
}

// RequestID returns the service's response RequestID for request.
func (s *InternalServerException) RequestID() string {
	return s.RespMetadata.RequestID
}

type ListHumanLoopsInput struct {
	_ struct{} `type:"structure" nopayload:"true"`

	// (Optional) The timestamp of the date when you want the human loops to begin
	// in ISO 8601 format. For example, 2020-02-24.
	CreationTimeAfter *time.Time `location:"querystring" locationName:"CreationTimeAfter" type:"timestamp"`

	// (Optional) The timestamp of the date before which you want the human loops
	// to begin in ISO 8601 format. For example, 2020-02-24.
	CreationTimeBefore *time.Time `location:"querystring" locationName:"CreationTimeBefore" type:"timestamp"`

	// The Amazon Resource Name (ARN) of a flow definition.
	//
	// FlowDefinitionArn is a required field
	FlowDefinitionArn *string `location:"querystring" locationName:"FlowDefinitionArn" type:"string" required:"true"`

	// The total number of items to return. If the total number of available items
	// is more than the value specified in MaxResults, then a NextToken is returned
	// in the output. You can use this token to display the next page of results.
	MaxResults *int64 `location:"querystring" locationName:"MaxResults" min:"1" type:"integer"`

	// A token to display the next page of results.
	NextToken *string `location:"querystring" locationName:"NextToken" type:"string"`

	// Optional. The order for displaying results. Valid values: Ascending and Descending.
	SortOrder *string `location:"querystring" locationName:"SortOrder" type:"string" enum:"SortOrder"`
}

// String returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s ListHumanLoopsInput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s ListHumanLoopsInput) GoString() string {
	return s.String()
}

// Validate inspects the fields of the type to determine if they are valid.
func (s *ListHumanLoopsInput) Validate() error {
	invalidParams := request.ErrInvalidParams{Context: "ListHumanLoopsInput"}
	if s.FlowDefinitionArn == nil {
		invalidParams.Add(request.NewErrParamRequired("FlowDefinitionArn"))
	}
	if s.MaxResults != nil && *s.MaxResults < 1 {
		invalidParams.Add(request.NewErrParamMinValue("MaxResults", 1))
	}

	if invalidParams.Len() > 0 {
		return invalidParams
	}
	return nil
}

// SetCreationTimeAfter sets the CreationTimeAfter field's value.
func (s *ListHumanLoopsInput) SetCreationTimeAfter(v time.Time) *ListHumanLoopsInput {
	s.CreationTimeAfter = &v
	return s
}

// SetCreationTimeBefore sets the CreationTimeBefore field's value.
func (s *ListHumanLoopsInput) SetCreationTimeBefore(v time.Time) *ListHumanLoopsInput {
	s.CreationTimeBefore = &v
	return s
}

// SetFlowDefinitionArn sets the FlowDefinitionArn field's value.
func (s *ListHumanLoopsInput) SetFlowDefinitionArn(v string) *ListHumanLoopsInput {
	s.FlowDefinitionArn = &v
	return s
}

// SetMaxResults sets the MaxResults field's value.
func (s *ListHumanLoopsInput) SetMaxResults(v int64) *ListHumanLoopsInput {
	s.MaxResults = &v
	return s
}

// SetNextToken sets the NextToken field's value.
func (s *ListHumanLoopsInput) SetNextToken(v string) *ListHumanLoopsInput {
	s.NextToken = &v
	return s
}

// SetSortOrder sets the SortOrder field's value.
func (s *ListHumanLoopsInput) SetSortOrder(v string) *ListHumanLoopsInput {
	s.SortOrder = &v
	return s
}

type ListHumanLoopsOutput struct {
	_ struct{} `type:"structure"`

	// An array of objects that contain information about the human loops.
	//
	// HumanLoopSummaries is a required field
	HumanLoopSummaries []*HumanLoopSummary `type:"list" required:"true"`

	// A token to display the next page of results.
	NextToken *string `type:"string"`
}

// String returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s ListHumanLoopsOutput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s ListHumanLoopsOutput) GoString() string {
	return s.String()
}

// SetHumanLoopSummaries sets the HumanLoopSummaries field's value.
func (s *ListHumanLoopsOutput) SetHumanLoopSummaries(v []*HumanLoopSummary) *ListHumanLoopsOutput {
	s.HumanLoopSummaries = v
	return s
}

// SetNextToken sets the NextToken field's value.
func (s *ListHumanLoopsOutput) SetNextToken(v string) *ListHumanLoopsOutput {
	s.NextToken = &v
	return s
}

// We couldn't find the requested resource. Check that your resources exists
// and were created in the same AWS Region as your request, and try your request
// again.
type ResourceNotFoundException struct {
	_            struct{}                  `type:"structure"`
	RespMetadata protocol.ResponseMetadata `json:"-" xml:"-"`

	Message_ *string `locationName:"Message" type:"string"`
}

// String returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s ResourceNotFoundException) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s ResourceNotFoundException) GoString() string {
	return s.String()
}

func newErrorResourceNotFoundException(v protocol.ResponseMetadata) error {
	return &ResourceNotFoundException{
		RespMetadata: v,
	}
}

// Code returns the exception type name.
func (s *ResourceNotFoundException) Code() string {
	return "ResourceNotFoundException"
}

// Message returns the exception's message.
func (s *ResourceNotFoundException) Message() string {
	if s.Message_ != nil {
		return *s.Message_
	}
	return ""
}

// OrigErr always returns nil, satisfies awserr.Error interface.
func (s *ResourceNotFoundException) OrigErr() error {
	return nil
}

func (s *ResourceNotFoundException) Error() string {
	return fmt.Sprintf("%s: %s", s.Code(), s.Message())
}

// Status code returns the HTTP status code for the request's response error.
func (s *ResourceNotFoundException) StatusCode() int {
	return s.RespMetadata.StatusCode
}

// RequestID returns the service's response RequestID for request.
func (s *ResourceNotFoundException) RequestID() string {
	return s.RespMetadata.RequestID
}

// You exceeded your service quota. Service quotas, also referred to as limits,
// are the maximum number of service resources or operations for your AWS account.
// For a list of Amazon A2I service quotes, see Amazon Augmented AI Service
// Quotes (https://docs.aws.amazon.com/general/latest/gr/a2i.html). Delete some
// resources or request an increase in your service quota. You can request a
// quota increase using Service Quotas or the AWS Support Center. To request
// an increase, see AWS Service Quotas (https://docs.aws.amazon.com/general/latest/gr/aws_service_limits.html)
// in the AWS General Reference.
type ServiceQuotaExceededException struct {
	_            struct{}                  `type:"structure"`
	RespMetadata protocol.ResponseMetadata `json:"-" xml:"-"`

	Message_ *string `locationName:"Message" type:"string"`
}

// String returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s ServiceQuotaExceededException) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s ServiceQuotaExceededException) GoString() string {
	return s.String()
}

func newErrorServiceQuotaExceededException(v protocol.ResponseMetadata) error {
	return &ServiceQuotaExceededException{
		RespMetadata: v,
	}
}

// Code returns the exception type name.
func (s *ServiceQuotaExceededException) Code() string {
	return "ServiceQuotaExceededException"
}

// Message returns the exception's message.
func (s *ServiceQuotaExceededException) Message() string {
	if s.Message_ != nil {
		return *s.Message_
	}
	return ""
}

// OrigErr always returns nil, satisfies awserr.Error interface.
func (s *ServiceQuotaExceededException) OrigErr() error {
	return nil
}

func (s *ServiceQuotaExceededException) Error() string {
	return fmt.Sprintf("%s: %s", s.Code(), s.Message())
}

// Status code returns the HTTP status code for the request's response error.
func (s *ServiceQuotaExceededException) StatusCode() int {
	return s.RespMetadata.StatusCode
}

// RequestID returns the service's response RequestID for request.
func (s *ServiceQuotaExceededException) RequestID() string {
	return s.RespMetadata.RequestID
}

type StartHumanLoopInput struct {
	_ struct{} `type:"structure"`

	// Attributes of the specified data. Use DataAttributes to specify if your data
	// is free of personally identifiable information and/or free of adult content.
	DataAttributes *HumanLoopDataAttributes `type:"structure"`

	// The Amazon Resource Name (ARN) of the flow definition associated with this
	// human loop.
	//
	// FlowDefinitionArn is a required field
	FlowDefinitionArn *string `type:"string" required:"true"`

	// An object that contains information about the human loop.
	//
	// HumanLoopInput is a required field
	HumanLoopInput *HumanLoopInput `type:"structure" required:"true"`

	// The name of the human loop.
	//
	// HumanLoopName is a required field
	HumanLoopName *string `min:"1" type:"string" required:"true"`
}

// String returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s StartHumanLoopInput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s StartHumanLoopInput) GoString() string {
	return s.String()
}

// Validate inspects the fields of the type to determine if they are valid.
func (s *StartHumanLoopInput) Validate() error {
	invalidParams := request.ErrInvalidParams{Context: "StartHumanLoopInput"}
	if s.FlowDefinitionArn == nil {
		invalidParams.Add(request.NewErrParamRequired("FlowDefinitionArn"))
	}
	if s.HumanLoopInput == nil {
		invalidParams.Add(request.NewErrParamRequired("HumanLoopInput"))
	}
	if s.HumanLoopName == nil {
		invalidParams.Add(request.NewErrParamRequired("HumanLoopName"))
	}
	if s.HumanLoopName != nil && len(*s.HumanLoopName) < 1 {
		invalidParams.Add(request.NewErrParamMinLen("HumanLoopName", 1))
	}
	if s.DataAttributes != nil {
		if err := s.DataAttributes.Validate(); err != nil {
			invalidParams.AddNested("DataAttributes", err.(request.ErrInvalidParams))
		}
	}
	if s.HumanLoopInput != nil {
		if err := s.HumanLoopInput.Validate(); err != nil {
			invalidParams.AddNested("HumanLoopInput", err.(request.ErrInvalidParams))
		}
	}

	if invalidParams.Len() > 0 {
		return invalidParams
	}
	return nil
}

// SetDataAttributes sets the DataAttributes field's value.
func (s *StartHumanLoopInput) SetDataAttributes(v *HumanLoopDataAttributes) *StartHumanLoopInput {
	s.DataAttributes = v
	return s
}

// SetFlowDefinitionArn sets the FlowDefinitionArn field's value.
func (s *StartHumanLoopInput) SetFlowDefinitionArn(v string) *StartHumanLoopInput {
	s.FlowDefinitionArn = &v
	return s
}

// SetHumanLoopInput sets the HumanLoopInput field's value.
func (s *StartHumanLoopInput) SetHumanLoopInput(v *HumanLoopInput) *StartHumanLoopInput {
	s.HumanLoopInput = v
	return s
}

// SetHumanLoopName sets the HumanLoopName field's value.
func (s *StartHumanLoopInput) SetHumanLoopName(v string) *StartHumanLoopInput {
	s.HumanLoopName = &v
	return s
}

type StartHumanLoopOutput struct {
	_ struct{} `type:"structure"`

	// The Amazon Resource Name (ARN) of the human loop.
	HumanLoopArn *string `type:"string"`
}

// String returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s StartHumanLoopOutput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s StartHumanLoopOutput) GoString() string {
	return s.String()
}

// SetHumanLoopArn sets the HumanLoopArn field's value.
func (s *StartHumanLoopOutput) SetHumanLoopArn(v string) *StartHumanLoopOutput {
	s.HumanLoopArn = &v
	return s
}

type StopHumanLoopInput struct {
	_ struct{} `type:"structure"`

	// The name of the human loop that you want to stop.
	//
	// HumanLoopName is a required field
	HumanLoopName *string `min:"1" type:"string" required:"true"`
}

// String returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s StopHumanLoopInput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s StopHumanLoopInput) GoString() string {
	return s.String()
}

// Validate inspects the fields of the type to determine if they are valid.
func (s *StopHumanLoopInput) Validate() error {
	invalidParams := request.ErrInvalidParams{Context: "StopHumanLoopInput"}
	if s.HumanLoopName == nil {
		invalidParams.Add(request.NewErrParamRequired("HumanLoopName"))
	}
	if s.HumanLoopName != nil && len(*s.HumanLoopName) < 1 {
		invalidParams.Add(request.NewErrParamMinLen("HumanLoopName", 1))
	}

	if invalidParams.Len() > 0 {
		return invalidParams
	}
	return nil
}

// SetHumanLoopName sets the HumanLoopName field's value.
func (s *StopHumanLoopInput) SetHumanLoopName(v string) *StopHumanLoopInput {
	s.HumanLoopName = &v
	return s
}

type StopHumanLoopOutput struct {
	_ struct{} `type:"structure"`
}

// String returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s StopHumanLoopOutput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s StopHumanLoopOutput) GoString() string {
	return s.String()
}

// You exceeded the maximum number of requests.
type ThrottlingException struct {
	_            struct{}                  `type:"structure"`
	RespMetadata protocol.ResponseMetadata `json:"-" xml:"-"`

	Message_ *string `locationName:"Message" type:"string"`
}

// String returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s ThrottlingException) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s ThrottlingException) GoString() string {
	return s.String()
}

func newErrorThrottlingException(v protocol.ResponseMetadata) error {
	return &ThrottlingException{
		RespMetadata: v,
	}
}

// Code returns the exception type name.
func (s *ThrottlingException) Code() string {
	return "ThrottlingException"
}

// Message returns the exception's message.
func (s *ThrottlingException) Message() string {
	if s.Message_ != nil {
		return *s.Message_
	}
	return ""
}

// OrigErr always returns nil, satisfies awserr.Error interface.
func (s *ThrottlingException) OrigErr() error {
	return nil
}

func (s *ThrottlingException) Error() string {
	return fmt.Sprintf("%s: %s", s.Code(), s.Message())
}

// Status code returns the HTTP status code for the request's response error.
func (s *ThrottlingException) StatusCode() int {
	return s.RespMetadata.StatusCode
}

// RequestID returns the service's response RequestID for request.
func (s *ThrottlingException) RequestID() string {
	return s.RespMetadata.RequestID
}

// The request isn't valid. Check the syntax and try again.
type ValidationException struct {
	_            struct{}                  `type:"structure"`
	RespMetadata protocol.ResponseMetadata `json:"-" xml:"-"`

	Message_ *string `locationName:"Message" type:"string"`
}

// String returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s ValidationException) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s ValidationException) GoString() string {
	return s.String()
}

func newErrorValidationException(v protocol.ResponseMetadata) error {
	return &ValidationException{
		RespMetadata: v,
	}
}

// Code returns the exception type name.
func (s *ValidationException) Code() string {
	return "ValidationException"
}

// Message returns the exception's message.
func (s *ValidationException) Message() string {
	if s.Message_ != nil {
		return *s.Message_
	}
	return ""
}

// OrigErr always returns nil, satisfies awserr.Error interface.
func (s *ValidationException) OrigErr() error {
	return nil
}

func (s *ValidationException) Error() string {
	return fmt.Sprintf("%s: %s", s.Code(), s.Message())
}

// Status code returns the HTTP status code for the request's response error.
func (s *ValidationException) StatusCode() int {
	return s.RespMetadata.StatusCode
}

// RequestID returns the service's response RequestID for request.
func (s *ValidationException) RequestID() string {
	return s.RespMetadata.RequestID
}

const (
	// ContentClassifierFreeOfPersonallyIdentifiableInformation is a ContentClassifier enum value
	ContentClassifierFreeOfPersonallyIdentifiableInformation = "FreeOfPersonallyIdentifiableInformation"

	// ContentClassifierFreeOfAdultContent is a ContentClassifier enum value
	ContentClassifierFreeOfAdultContent = "FreeOfAdultContent"
)

// ContentClassifier_Values returns all elements of the ContentClassifier enum
func ContentClassifier_Values() []string {
	return []string{
		ContentClassifierFreeOfPersonallyIdentifiableInformation,
		ContentClassifierFreeOfAdultContent,
	}
}

const (
	// HumanLoopStatusInProgress is a HumanLoopStatus enum value
	HumanLoopStatusInProgress = "InProgress"

	// HumanLoopStatusFailed is a HumanLoopStatus enum value
	HumanLoopStatusFailed = "Failed"

	// HumanLoopStatusCompleted is a HumanLoopStatus enum value
	HumanLoopStatusCompleted = "Completed"

	// HumanLoopStatusStopped is a HumanLoopStatus enum value
	HumanLoopStatusStopped = "Stopped"

	// HumanLoopStatusStopping is a HumanLoopStatus enum value
	HumanLoopStatusStopping = "Stopping"
)

// HumanLoopStatus_Values returns all elements of the HumanLoopStatus enum
func HumanLoopStatus_Values() []string {
	return []string{
		HumanLoopStatusInProgress,
		HumanLoopStatusFailed,
		HumanLoopStatusCompleted,
		HumanLoopStatusStopped,
		HumanLoopStatusStopping,
	}
}

const (
	// SortOrderAscending is a SortOrder enum value
	SortOrderAscending = "Ascending"

	// SortOrderDescending is a SortOrder enum value
	SortOrderDescending = "Descending"
)

// SortOrder_Values returns all elements of the SortOrder enum
func SortOrder_Values() []string {
	return []string{
		SortOrderAscending,
		SortOrderDescending,
	}
}
