// Code generated by private/model/cli/gen-api/main.go. DO NOT EDIT.

// Package cloudcontrolapiiface provides an interface to enable mocking the AWS Cloud Control API service client
// for testing your code.
//
// It is important to note that this interface will have breaking changes
// when the service model is updated and adds new API operations, paginators,
// and waiters.
package cloudcontrolapiiface

import (
	"github.com/aws/aws-sdk-go/aws"
	"github.com/aws/aws-sdk-go/aws/request"
	"github.com/aws/aws-sdk-go/service/cloudcontrolapi"
)

// CloudControlApiAPI provides an interface to enable mocking the
// cloudcontrolapi.CloudControlApi service client's API operation,
// paginators, and waiters. This make unit testing your code that calls out
// to the SDK's service client's calls easier.
//
// The best way to use this interface is so the SDK's service client's calls
// can be stubbed out for unit testing your code with the SDK without needing
// to inject custom request handlers into the SDK's request pipeline.
//
//    // myFunc uses an SDK service client to make a request to
//    // AWS Cloud Control API.
//    func myFunc(svc cloudcontrolapiiface.CloudControlApiAPI) bool {
//        // Make svc.CancelResourceRequest request
//    }
//
//    func main() {
//        sess := session.New()
//        svc := cloudcontrolapi.New(sess)
//
//        myFunc(svc)
//    }
//
// In your _test.go file:
//
//    // Define a mock struct to be used in your unit tests of myFunc.
//    type mockCloudControlApiClient struct {
//        cloudcontrolapiiface.CloudControlApiAPI
//    }
//    func (m *mockCloudControlApiClient) CancelResourceRequest(input *cloudcontrolapi.CancelResourceRequestInput) (*cloudcontrolapi.CancelResourceRequestOutput, error) {
//        // mock response/functionality
//    }
//
//    func TestMyFunc(t *testing.T) {
//        // Setup Test
//        mockSvc := &mockCloudControlApiClient{}
//
//        myfunc(mockSvc)
//
//        // Verify myFunc's functionality
//    }
//
// It is important to note that this interface will have breaking changes
// when the service model is updated and adds new API operations, paginators,
// and waiters. Its suggested to use the pattern above for testing, or using
// tooling to generate mocks to satisfy the interfaces.
type CloudControlApiAPI interface {
	CancelResourceRequest(*cloudcontrolapi.CancelResourceRequestInput) (*cloudcontrolapi.CancelResourceRequestOutput, error)
	CancelResourceRequestWithContext(aws.Context, *cloudcontrolapi.CancelResourceRequestInput, ...request.Option) (*cloudcontrolapi.CancelResourceRequestOutput, error)
	CancelResourceRequestRequest(*cloudcontrolapi.CancelResourceRequestInput) (*request.Request, *cloudcontrolapi.CancelResourceRequestOutput)

	CreateResource(*cloudcontrolapi.CreateResourceInput) (*cloudcontrolapi.CreateResourceOutput, error)
	CreateResourceWithContext(aws.Context, *cloudcontrolapi.CreateResourceInput, ...request.Option) (*cloudcontrolapi.CreateResourceOutput, error)
	CreateResourceRequest(*cloudcontrolapi.CreateResourceInput) (*request.Request, *cloudcontrolapi.CreateResourceOutput)

	DeleteResource(*cloudcontrolapi.DeleteResourceInput) (*cloudcontrolapi.DeleteResourceOutput, error)
	DeleteResourceWithContext(aws.Context, *cloudcontrolapi.DeleteResourceInput, ...request.Option) (*cloudcontrolapi.DeleteResourceOutput, error)
	DeleteResourceRequest(*cloudcontrolapi.DeleteResourceInput) (*request.Request, *cloudcontrolapi.DeleteResourceOutput)

	GetResource(*cloudcontrolapi.GetResourceInput) (*cloudcontrolapi.GetResourceOutput, error)
	GetResourceWithContext(aws.Context, *cloudcontrolapi.GetResourceInput, ...request.Option) (*cloudcontrolapi.GetResourceOutput, error)
	GetResourceRequest(*cloudcontrolapi.GetResourceInput) (*request.Request, *cloudcontrolapi.GetResourceOutput)

	GetResourceRequestStatus(*cloudcontrolapi.GetResourceRequestStatusInput) (*cloudcontrolapi.GetResourceRequestStatusOutput, error)
	GetResourceRequestStatusWithContext(aws.Context, *cloudcontrolapi.GetResourceRequestStatusInput, ...request.Option) (*cloudcontrolapi.GetResourceRequestStatusOutput, error)
	GetResourceRequestStatusRequest(*cloudcontrolapi.GetResourceRequestStatusInput) (*request.Request, *cloudcontrolapi.GetResourceRequestStatusOutput)

	ListResourceRequests(*cloudcontrolapi.ListResourceRequestsInput) (*cloudcontrolapi.ListResourceRequestsOutput, error)
	ListResourceRequestsWithContext(aws.Context, *cloudcontrolapi.ListResourceRequestsInput, ...request.Option) (*cloudcontrolapi.ListResourceRequestsOutput, error)
	ListResourceRequestsRequest(*cloudcontrolapi.ListResourceRequestsInput) (*request.Request, *cloudcontrolapi.ListResourceRequestsOutput)

	ListResourceRequestsPages(*cloudcontrolapi.ListResourceRequestsInput, func(*cloudcontrolapi.ListResourceRequestsOutput, bool) bool) error
	ListResourceRequestsPagesWithContext(aws.Context, *cloudcontrolapi.ListResourceRequestsInput, func(*cloudcontrolapi.ListResourceRequestsOutput, bool) bool, ...request.Option) error

	ListResources(*cloudcontrolapi.ListResourcesInput) (*cloudcontrolapi.ListResourcesOutput, error)
	ListResourcesWithContext(aws.Context, *cloudcontrolapi.ListResourcesInput, ...request.Option) (*cloudcontrolapi.ListResourcesOutput, error)
	ListResourcesRequest(*cloudcontrolapi.ListResourcesInput) (*request.Request, *cloudcontrolapi.ListResourcesOutput)

	ListResourcesPages(*cloudcontrolapi.ListResourcesInput, func(*cloudcontrolapi.ListResourcesOutput, bool) bool) error
	ListResourcesPagesWithContext(aws.Context, *cloudcontrolapi.ListResourcesInput, func(*cloudcontrolapi.ListResourcesOutput, bool) bool, ...request.Option) error

	UpdateResource(*cloudcontrolapi.UpdateResourceInput) (*cloudcontrolapi.UpdateResourceOutput, error)
	UpdateResourceWithContext(aws.Context, *cloudcontrolapi.UpdateResourceInput, ...request.Option) (*cloudcontrolapi.UpdateResourceOutput, error)
	UpdateResourceRequest(*cloudcontrolapi.UpdateResourceInput) (*request.Request, *cloudcontrolapi.UpdateResourceOutput)

	WaitUntilResourceRequestSuccess(*cloudcontrolapi.GetResourceRequestStatusInput) error
	WaitUntilResourceRequestSuccessWithContext(aws.Context, *cloudcontrolapi.GetResourceRequestStatusInput, ...request.WaiterOption) error
}

var _ CloudControlApiAPI = (*cloudcontrolapi.CloudControlApi)(nil)
