// Copyright 2020 Google LLC
//
// Licensed under the Apache License, Version 2.0 (the "License");
// you may not use this file except in compliance with the License.
// You may obtain a copy of the License at
//
//     http://www.apache.org/licenses/LICENSE-2.0
//
// Unless required by applicable law or agreed to in writing, software
// distributed under the License is distributed on an "AS IS" BASIS,
// WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
// See the License for the specific language governing permissions and
// limitations under the License.

// Code generated by protoc-gen-go. DO NOT EDIT.
// versions:
// 	protoc-gen-go v1.26.0
// 	protoc        v3.12.2
// source: google/cloud/workflows/executions/v1/executions.proto

package executions

import (
	context "context"
	reflect "reflect"
	sync "sync"

	_ "google.golang.org/genproto/googleapis/api/annotations"
	grpc "google.golang.org/grpc"
	codes "google.golang.org/grpc/codes"
	status "google.golang.org/grpc/status"
	protoreflect "google.golang.org/protobuf/reflect/protoreflect"
	protoimpl "google.golang.org/protobuf/runtime/protoimpl"
	timestamppb "google.golang.org/protobuf/types/known/timestamppb"
)

const (
	// Verify that this generated code is sufficiently up-to-date.
	_ = protoimpl.EnforceVersion(20 - protoimpl.MinVersion)
	// Verify that runtime/protoimpl is sufficiently up-to-date.
	_ = protoimpl.EnforceVersion(protoimpl.MaxVersion - 20)
)

// Defines possible views for execution resource.
type ExecutionView int32

const (
	// The default / unset value.
	ExecutionView_EXECUTION_VIEW_UNSPECIFIED ExecutionView = 0
	// Includes only basic metadata about the execution.
	// Following fields are returned: name, start_time, end_time, state
	// and workflow_revision_id.
	ExecutionView_BASIC ExecutionView = 1
	// Includes all data.
	ExecutionView_FULL ExecutionView = 2
)

// Enum value maps for ExecutionView.
var (
	ExecutionView_name = map[int32]string{
		0: "EXECUTION_VIEW_UNSPECIFIED",
		1: "BASIC",
		2: "FULL",
	}
	ExecutionView_value = map[string]int32{
		"EXECUTION_VIEW_UNSPECIFIED": 0,
		"BASIC":                      1,
		"FULL":                       2,
	}
)

func (x ExecutionView) Enum() *ExecutionView {
	p := new(ExecutionView)
	*p = x
	return p
}

func (x ExecutionView) String() string {
	return protoimpl.X.EnumStringOf(x.Descriptor(), protoreflect.EnumNumber(x))
}

func (ExecutionView) Descriptor() protoreflect.EnumDescriptor {
	return file_google_cloud_workflows_executions_v1_executions_proto_enumTypes[0].Descriptor()
}

func (ExecutionView) Type() protoreflect.EnumType {
	return &file_google_cloud_workflows_executions_v1_executions_proto_enumTypes[0]
}

func (x ExecutionView) Number() protoreflect.EnumNumber {
	return protoreflect.EnumNumber(x)
}

// Deprecated: Use ExecutionView.Descriptor instead.
func (ExecutionView) EnumDescriptor() ([]byte, []int) {
	return file_google_cloud_workflows_executions_v1_executions_proto_rawDescGZIP(), []int{0}
}

// Describes the current state of the execution. More states may be added
// in the future.
type Execution_State int32

const (
	// Invalid state.
	Execution_STATE_UNSPECIFIED Execution_State = 0
	// The execution is in progress.
	Execution_ACTIVE Execution_State = 1
	// The execution finished successfully.
	Execution_SUCCEEDED Execution_State = 2
	// The execution failed with an error.
	Execution_FAILED Execution_State = 3
	// The execution was stopped intentionally.
	Execution_CANCELLED Execution_State = 4
)

// Enum value maps for Execution_State.
var (
	Execution_State_name = map[int32]string{
		0: "STATE_UNSPECIFIED",
		1: "ACTIVE",
		2: "SUCCEEDED",
		3: "FAILED",
		4: "CANCELLED",
	}
	Execution_State_value = map[string]int32{
		"STATE_UNSPECIFIED": 0,
		"ACTIVE":            1,
		"SUCCEEDED":         2,
		"FAILED":            3,
		"CANCELLED":         4,
	}
)

func (x Execution_State) Enum() *Execution_State {
	p := new(Execution_State)
	*p = x
	return p
}

func (x Execution_State) String() string {
	return protoimpl.X.EnumStringOf(x.Descriptor(), protoreflect.EnumNumber(x))
}

func (Execution_State) Descriptor() protoreflect.EnumDescriptor {
	return file_google_cloud_workflows_executions_v1_executions_proto_enumTypes[1].Descriptor()
}

func (Execution_State) Type() protoreflect.EnumType {
	return &file_google_cloud_workflows_executions_v1_executions_proto_enumTypes[1]
}

func (x Execution_State) Number() protoreflect.EnumNumber {
	return protoreflect.EnumNumber(x)
}

// Deprecated: Use Execution_State.Descriptor instead.
func (Execution_State) EnumDescriptor() ([]byte, []int) {
	return file_google_cloud_workflows_executions_v1_executions_proto_rawDescGZIP(), []int{0, 0}
}

// A running instance of a
// [Workflow](/workflows/docs/reference/rest/v1/projects.locations.workflows).
type Execution struct {
	state         protoimpl.MessageState
	sizeCache     protoimpl.SizeCache
	unknownFields protoimpl.UnknownFields

	// Output only. The resource name of the execution.
	// Format:
	// projects/{project}/locations/{location}/workflows/{workflow}/executions/{execution}
	Name string `protobuf:"bytes,1,opt,name=name,proto3" json:"name,omitempty"`
	// Output only. Marks the beginning of execution.
	StartTime *timestamppb.Timestamp `protobuf:"bytes,2,opt,name=start_time,json=startTime,proto3" json:"start_time,omitempty"`
	// Output only. Marks the end of execution, successful or not.
	EndTime *timestamppb.Timestamp `protobuf:"bytes,3,opt,name=end_time,json=endTime,proto3" json:"end_time,omitempty"`
	// Output only. Current state of the execution.
	State Execution_State `protobuf:"varint,4,opt,name=state,proto3,enum=google.cloud.workflows.executions.v1.Execution_State" json:"state,omitempty"`
	// Input parameters of the execution represented as a JSON string.
	// The size limit is 32KB.
	Argument string `protobuf:"bytes,5,opt,name=argument,proto3" json:"argument,omitempty"`
	// Output only. Output of the execution represented as a JSON string. The
	// value can only be present if the execution's state is `SUCCEEDED`.
	Result string `protobuf:"bytes,6,opt,name=result,proto3" json:"result,omitempty"`
	// Output only. The error which caused the execution to finish prematurely.
	// The value is only present if the execution's state is `FAILED`
	// or `CANCELLED`.
	Error *Execution_Error `protobuf:"bytes,7,opt,name=error,proto3" json:"error,omitempty"`
	// Output only. Revision of the workflow this execution is using.
	WorkflowRevisionId string `protobuf:"bytes,8,opt,name=workflow_revision_id,json=workflowRevisionId,proto3" json:"workflow_revision_id,omitempty"`
}

func (x *Execution) Reset() {
	*x = Execution{}
	if protoimpl.UnsafeEnabled {
		mi := &file_google_cloud_workflows_executions_v1_executions_proto_msgTypes[0]
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		ms.StoreMessageInfo(mi)
	}
}

func (x *Execution) String() string {
	return protoimpl.X.MessageStringOf(x)
}

func (*Execution) ProtoMessage() {}

func (x *Execution) ProtoReflect() protoreflect.Message {
	mi := &file_google_cloud_workflows_executions_v1_executions_proto_msgTypes[0]
	if protoimpl.UnsafeEnabled && x != nil {
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		if ms.LoadMessageInfo() == nil {
			ms.StoreMessageInfo(mi)
		}
		return ms
	}
	return mi.MessageOf(x)
}

// Deprecated: Use Execution.ProtoReflect.Descriptor instead.
func (*Execution) Descriptor() ([]byte, []int) {
	return file_google_cloud_workflows_executions_v1_executions_proto_rawDescGZIP(), []int{0}
}

func (x *Execution) GetName() string {
	if x != nil {
		return x.Name
	}
	return ""
}

func (x *Execution) GetStartTime() *timestamppb.Timestamp {
	if x != nil {
		return x.StartTime
	}
	return nil
}

func (x *Execution) GetEndTime() *timestamppb.Timestamp {
	if x != nil {
		return x.EndTime
	}
	return nil
}

func (x *Execution) GetState() Execution_State {
	if x != nil {
		return x.State
	}
	return Execution_STATE_UNSPECIFIED
}

func (x *Execution) GetArgument() string {
	if x != nil {
		return x.Argument
	}
	return ""
}

func (x *Execution) GetResult() string {
	if x != nil {
		return x.Result
	}
	return ""
}

func (x *Execution) GetError() *Execution_Error {
	if x != nil {
		return x.Error
	}
	return nil
}

func (x *Execution) GetWorkflowRevisionId() string {
	if x != nil {
		return x.WorkflowRevisionId
	}
	return ""
}

// Request for the
// [ListExecutions][]
// method.
type ListExecutionsRequest struct {
	state         protoimpl.MessageState
	sizeCache     protoimpl.SizeCache
	unknownFields protoimpl.UnknownFields

	// Required. Name of the workflow for which the executions should be listed.
	// Format: projects/{project}/locations/{location}/workflows/{workflow}
	Parent string `protobuf:"bytes,1,opt,name=parent,proto3" json:"parent,omitempty"`
	// Maximum number of executions to return per call.
	// Max supported value depends on the selected Execution view: it's 10000 for
	// BASIC and 100 for FULL. The default value used if the field is not
	// specified is 100, regardless of the selected view. Values greater than
	// the max value will be coerced down to it.
	PageSize int32 `protobuf:"varint,2,opt,name=page_size,json=pageSize,proto3" json:"page_size,omitempty"`
	// A page token, received from a previous `ListExecutions` call.
	// Provide this to retrieve the subsequent page.
	//
	// When paginating, all other parameters provided to `ListExecutions` must
	// match the call that provided the page token.
	PageToken string `protobuf:"bytes,3,opt,name=page_token,json=pageToken,proto3" json:"page_token,omitempty"`
	// Optional. A view defining which fields should be filled in the returned executions.
	// The API will default to the BASIC view.
	View ExecutionView `protobuf:"varint,4,opt,name=view,proto3,enum=google.cloud.workflows.executions.v1.ExecutionView" json:"view,omitempty"`
}

func (x *ListExecutionsRequest) Reset() {
	*x = ListExecutionsRequest{}
	if protoimpl.UnsafeEnabled {
		mi := &file_google_cloud_workflows_executions_v1_executions_proto_msgTypes[1]
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		ms.StoreMessageInfo(mi)
	}
}

func (x *ListExecutionsRequest) String() string {
	return protoimpl.X.MessageStringOf(x)
}

func (*ListExecutionsRequest) ProtoMessage() {}

func (x *ListExecutionsRequest) ProtoReflect() protoreflect.Message {
	mi := &file_google_cloud_workflows_executions_v1_executions_proto_msgTypes[1]
	if protoimpl.UnsafeEnabled && x != nil {
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		if ms.LoadMessageInfo() == nil {
			ms.StoreMessageInfo(mi)
		}
		return ms
	}
	return mi.MessageOf(x)
}

// Deprecated: Use ListExecutionsRequest.ProtoReflect.Descriptor instead.
func (*ListExecutionsRequest) Descriptor() ([]byte, []int) {
	return file_google_cloud_workflows_executions_v1_executions_proto_rawDescGZIP(), []int{1}
}

func (x *ListExecutionsRequest) GetParent() string {
	if x != nil {
		return x.Parent
	}
	return ""
}

func (x *ListExecutionsRequest) GetPageSize() int32 {
	if x != nil {
		return x.PageSize
	}
	return 0
}

func (x *ListExecutionsRequest) GetPageToken() string {
	if x != nil {
		return x.PageToken
	}
	return ""
}

func (x *ListExecutionsRequest) GetView() ExecutionView {
	if x != nil {
		return x.View
	}
	return ExecutionView_EXECUTION_VIEW_UNSPECIFIED
}

// Response for the
// [ListExecutions][google.cloud.workflows.executions.v1.Executions.ListExecutions]
// method.
type ListExecutionsResponse struct {
	state         protoimpl.MessageState
	sizeCache     protoimpl.SizeCache
	unknownFields protoimpl.UnknownFields

	// The executions which match the request.
	Executions []*Execution `protobuf:"bytes,1,rep,name=executions,proto3" json:"executions,omitempty"`
	// A token, which can be sent as `page_token` to retrieve the next page.
	// If this field is omitted, there are no subsequent pages.
	NextPageToken string `protobuf:"bytes,2,opt,name=next_page_token,json=nextPageToken,proto3" json:"next_page_token,omitempty"`
}

func (x *ListExecutionsResponse) Reset() {
	*x = ListExecutionsResponse{}
	if protoimpl.UnsafeEnabled {
		mi := &file_google_cloud_workflows_executions_v1_executions_proto_msgTypes[2]
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		ms.StoreMessageInfo(mi)
	}
}

func (x *ListExecutionsResponse) String() string {
	return protoimpl.X.MessageStringOf(x)
}

func (*ListExecutionsResponse) ProtoMessage() {}

func (x *ListExecutionsResponse) ProtoReflect() protoreflect.Message {
	mi := &file_google_cloud_workflows_executions_v1_executions_proto_msgTypes[2]
	if protoimpl.UnsafeEnabled && x != nil {
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		if ms.LoadMessageInfo() == nil {
			ms.StoreMessageInfo(mi)
		}
		return ms
	}
	return mi.MessageOf(x)
}

// Deprecated: Use ListExecutionsResponse.ProtoReflect.Descriptor instead.
func (*ListExecutionsResponse) Descriptor() ([]byte, []int) {
	return file_google_cloud_workflows_executions_v1_executions_proto_rawDescGZIP(), []int{2}
}

func (x *ListExecutionsResponse) GetExecutions() []*Execution {
	if x != nil {
		return x.Executions
	}
	return nil
}

func (x *ListExecutionsResponse) GetNextPageToken() string {
	if x != nil {
		return x.NextPageToken
	}
	return ""
}

// Request for the
// [CreateExecution][google.cloud.workflows.executions.v1.Executions.CreateExecution]
// method.
type CreateExecutionRequest struct {
	state         protoimpl.MessageState
	sizeCache     protoimpl.SizeCache
	unknownFields protoimpl.UnknownFields

	// Required. Name of the workflow for which an execution should be created.
	// Format: projects/{project}/locations/{location}/workflows/{workflow}
	// The latest revision of the workflow will be used.
	Parent string `protobuf:"bytes,1,opt,name=parent,proto3" json:"parent,omitempty"`
	// Required. Execution to be created.
	Execution *Execution `protobuf:"bytes,2,opt,name=execution,proto3" json:"execution,omitempty"`
}

func (x *CreateExecutionRequest) Reset() {
	*x = CreateExecutionRequest{}
	if protoimpl.UnsafeEnabled {
		mi := &file_google_cloud_workflows_executions_v1_executions_proto_msgTypes[3]
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		ms.StoreMessageInfo(mi)
	}
}

func (x *CreateExecutionRequest) String() string {
	return protoimpl.X.MessageStringOf(x)
}

func (*CreateExecutionRequest) ProtoMessage() {}

func (x *CreateExecutionRequest) ProtoReflect() protoreflect.Message {
	mi := &file_google_cloud_workflows_executions_v1_executions_proto_msgTypes[3]
	if protoimpl.UnsafeEnabled && x != nil {
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		if ms.LoadMessageInfo() == nil {
			ms.StoreMessageInfo(mi)
		}
		return ms
	}
	return mi.MessageOf(x)
}

// Deprecated: Use CreateExecutionRequest.ProtoReflect.Descriptor instead.
func (*CreateExecutionRequest) Descriptor() ([]byte, []int) {
	return file_google_cloud_workflows_executions_v1_executions_proto_rawDescGZIP(), []int{3}
}

func (x *CreateExecutionRequest) GetParent() string {
	if x != nil {
		return x.Parent
	}
	return ""
}

func (x *CreateExecutionRequest) GetExecution() *Execution {
	if x != nil {
		return x.Execution
	}
	return nil
}

// Request for the
// [GetExecution][google.cloud.workflows.executions.v1.Executions.GetExecution]
// method.
type GetExecutionRequest struct {
	state         protoimpl.MessageState
	sizeCache     protoimpl.SizeCache
	unknownFields protoimpl.UnknownFields

	// Required. Name of the execution to be retrieved.
	// Format:
	// projects/{project}/locations/{location}/workflows/{workflow}/executions/{execution}
	Name string `protobuf:"bytes,1,opt,name=name,proto3" json:"name,omitempty"`
	// Optional. A view defining which fields should be filled in the returned execution.
	// The API will default to the FULL view.
	View ExecutionView `protobuf:"varint,2,opt,name=view,proto3,enum=google.cloud.workflows.executions.v1.ExecutionView" json:"view,omitempty"`
}

func (x *GetExecutionRequest) Reset() {
	*x = GetExecutionRequest{}
	if protoimpl.UnsafeEnabled {
		mi := &file_google_cloud_workflows_executions_v1_executions_proto_msgTypes[4]
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		ms.StoreMessageInfo(mi)
	}
}

func (x *GetExecutionRequest) String() string {
	return protoimpl.X.MessageStringOf(x)
}

func (*GetExecutionRequest) ProtoMessage() {}

func (x *GetExecutionRequest) ProtoReflect() protoreflect.Message {
	mi := &file_google_cloud_workflows_executions_v1_executions_proto_msgTypes[4]
	if protoimpl.UnsafeEnabled && x != nil {
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		if ms.LoadMessageInfo() == nil {
			ms.StoreMessageInfo(mi)
		}
		return ms
	}
	return mi.MessageOf(x)
}

// Deprecated: Use GetExecutionRequest.ProtoReflect.Descriptor instead.
func (*GetExecutionRequest) Descriptor() ([]byte, []int) {
	return file_google_cloud_workflows_executions_v1_executions_proto_rawDescGZIP(), []int{4}
}

func (x *GetExecutionRequest) GetName() string {
	if x != nil {
		return x.Name
	}
	return ""
}

func (x *GetExecutionRequest) GetView() ExecutionView {
	if x != nil {
		return x.View
	}
	return ExecutionView_EXECUTION_VIEW_UNSPECIFIED
}

// Request for the
// [CancelExecution][google.cloud.workflows.executions.v1.Executions.CancelExecution]
// method.
type CancelExecutionRequest struct {
	state         protoimpl.MessageState
	sizeCache     protoimpl.SizeCache
	unknownFields protoimpl.UnknownFields

	// Required. Name of the execution to be cancelled.
	// Format:
	// projects/{project}/locations/{location}/workflows/{workflow}/executions/{execution}
	Name string `protobuf:"bytes,1,opt,name=name,proto3" json:"name,omitempty"`
}

func (x *CancelExecutionRequest) Reset() {
	*x = CancelExecutionRequest{}
	if protoimpl.UnsafeEnabled {
		mi := &file_google_cloud_workflows_executions_v1_executions_proto_msgTypes[5]
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		ms.StoreMessageInfo(mi)
	}
}

func (x *CancelExecutionRequest) String() string {
	return protoimpl.X.MessageStringOf(x)
}

func (*CancelExecutionRequest) ProtoMessage() {}

func (x *CancelExecutionRequest) ProtoReflect() protoreflect.Message {
	mi := &file_google_cloud_workflows_executions_v1_executions_proto_msgTypes[5]
	if protoimpl.UnsafeEnabled && x != nil {
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		if ms.LoadMessageInfo() == nil {
			ms.StoreMessageInfo(mi)
		}
		return ms
	}
	return mi.MessageOf(x)
}

// Deprecated: Use CancelExecutionRequest.ProtoReflect.Descriptor instead.
func (*CancelExecutionRequest) Descriptor() ([]byte, []int) {
	return file_google_cloud_workflows_executions_v1_executions_proto_rawDescGZIP(), []int{5}
}

func (x *CancelExecutionRequest) GetName() string {
	if x != nil {
		return x.Name
	}
	return ""
}

// Error describes why the execution was abnormally terminated.
type Execution_Error struct {
	state         protoimpl.MessageState
	sizeCache     protoimpl.SizeCache
	unknownFields protoimpl.UnknownFields

	// Error payload returned by the execution, represented as a JSON string.
	Payload string `protobuf:"bytes,1,opt,name=payload,proto3" json:"payload,omitempty"`
	// Human readable error context, helpful for debugging purposes.
	Context string `protobuf:"bytes,2,opt,name=context,proto3" json:"context,omitempty"`
}

func (x *Execution_Error) Reset() {
	*x = Execution_Error{}
	if protoimpl.UnsafeEnabled {
		mi := &file_google_cloud_workflows_executions_v1_executions_proto_msgTypes[6]
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		ms.StoreMessageInfo(mi)
	}
}

func (x *Execution_Error) String() string {
	return protoimpl.X.MessageStringOf(x)
}

func (*Execution_Error) ProtoMessage() {}

func (x *Execution_Error) ProtoReflect() protoreflect.Message {
	mi := &file_google_cloud_workflows_executions_v1_executions_proto_msgTypes[6]
	if protoimpl.UnsafeEnabled && x != nil {
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		if ms.LoadMessageInfo() == nil {
			ms.StoreMessageInfo(mi)
		}
		return ms
	}
	return mi.MessageOf(x)
}

// Deprecated: Use Execution_Error.ProtoReflect.Descriptor instead.
func (*Execution_Error) Descriptor() ([]byte, []int) {
	return file_google_cloud_workflows_executions_v1_executions_proto_rawDescGZIP(), []int{0, 0}
}

func (x *Execution_Error) GetPayload() string {
	if x != nil {
		return x.Payload
	}
	return ""
}

func (x *Execution_Error) GetContext() string {
	if x != nil {
		return x.Context
	}
	return ""
}

var File_google_cloud_workflows_executions_v1_executions_proto protoreflect.FileDescriptor

var file_google_cloud_workflows_executions_v1_executions_proto_rawDesc = []byte{
	0x0a, 0x35, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2f, 0x63, 0x6c, 0x6f, 0x75, 0x64, 0x2f, 0x77,
	0x6f, 0x72, 0x6b, 0x66, 0x6c, 0x6f, 0x77, 0x73, 0x2f, 0x65, 0x78, 0x65, 0x63, 0x75, 0x74, 0x69,
	0x6f, 0x6e, 0x73, 0x2f, 0x76, 0x31, 0x2f, 0x65, 0x78, 0x65, 0x63, 0x75, 0x74, 0x69, 0x6f, 0x6e,
	0x73, 0x2e, 0x70, 0x72, 0x6f, 0x74, 0x6f, 0x12, 0x24, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2e,
	0x63, 0x6c, 0x6f, 0x75, 0x64, 0x2e, 0x77, 0x6f, 0x72, 0x6b, 0x66, 0x6c, 0x6f, 0x77, 0x73, 0x2e,
	0x65, 0x78, 0x65, 0x63, 0x75, 0x74, 0x69, 0x6f, 0x6e, 0x73, 0x2e, 0x76, 0x31, 0x1a, 0x1c, 0x67,
	0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2f, 0x61, 0x70, 0x69, 0x2f, 0x61, 0x6e, 0x6e, 0x6f, 0x74, 0x61,
	0x74, 0x69, 0x6f, 0x6e, 0x73, 0x2e, 0x70, 0x72, 0x6f, 0x74, 0x6f, 0x1a, 0x17, 0x67, 0x6f, 0x6f,
	0x67, 0x6c, 0x65, 0x2f, 0x61, 0x70, 0x69, 0x2f, 0x63, 0x6c, 0x69, 0x65, 0x6e, 0x74, 0x2e, 0x70,
	0x72, 0x6f, 0x74, 0x6f, 0x1a, 0x1f, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2f, 0x61, 0x70, 0x69,
	0x2f, 0x66, 0x69, 0x65, 0x6c, 0x64, 0x5f, 0x62, 0x65, 0x68, 0x61, 0x76, 0x69, 0x6f, 0x72, 0x2e,
	0x70, 0x72, 0x6f, 0x74, 0x6f, 0x1a, 0x19, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2f, 0x61, 0x70,
	0x69, 0x2f, 0x72, 0x65, 0x73, 0x6f, 0x75, 0x72, 0x63, 0x65, 0x2e, 0x70, 0x72, 0x6f, 0x74, 0x6f,
	0x1a, 0x1f, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2f, 0x70, 0x72, 0x6f, 0x74, 0x6f, 0x62, 0x75,
	0x66, 0x2f, 0x74, 0x69, 0x6d, 0x65, 0x73, 0x74, 0x61, 0x6d, 0x70, 0x2e, 0x70, 0x72, 0x6f, 0x74,
	0x6f, 0x22, 0xd0, 0x05, 0x0a, 0x09, 0x45, 0x78, 0x65, 0x63, 0x75, 0x74, 0x69, 0x6f, 0x6e, 0x12,
	0x17, 0x0a, 0x04, 0x6e, 0x61, 0x6d, 0x65, 0x18, 0x01, 0x20, 0x01, 0x28, 0x09, 0x42, 0x03, 0xe0,
	0x41, 0x03, 0x52, 0x04, 0x6e, 0x61, 0x6d, 0x65, 0x12, 0x3e, 0x0a, 0x0a, 0x73, 0x74, 0x61, 0x72,
	0x74, 0x5f, 0x74, 0x69, 0x6d, 0x65, 0x18, 0x02, 0x20, 0x01, 0x28, 0x0b, 0x32, 0x1a, 0x2e, 0x67,
	0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2e, 0x70, 0x72, 0x6f, 0x74, 0x6f, 0x62, 0x75, 0x66, 0x2e, 0x54,
	0x69, 0x6d, 0x65, 0x73, 0x74, 0x61, 0x6d, 0x70, 0x42, 0x03, 0xe0, 0x41, 0x03, 0x52, 0x09, 0x73,
	0x74, 0x61, 0x72, 0x74, 0x54, 0x69, 0x6d, 0x65, 0x12, 0x3a, 0x0a, 0x08, 0x65, 0x6e, 0x64, 0x5f,
	0x74, 0x69, 0x6d, 0x65, 0x18, 0x03, 0x20, 0x01, 0x28, 0x0b, 0x32, 0x1a, 0x2e, 0x67, 0x6f, 0x6f,
	0x67, 0x6c, 0x65, 0x2e, 0x70, 0x72, 0x6f, 0x74, 0x6f, 0x62, 0x75, 0x66, 0x2e, 0x54, 0x69, 0x6d,
	0x65, 0x73, 0x74, 0x61, 0x6d, 0x70, 0x42, 0x03, 0xe0, 0x41, 0x03, 0x52, 0x07, 0x65, 0x6e, 0x64,
	0x54, 0x69, 0x6d, 0x65, 0x12, 0x50, 0x0a, 0x05, 0x73, 0x74, 0x61, 0x74, 0x65, 0x18, 0x04, 0x20,
	0x01, 0x28, 0x0e, 0x32, 0x35, 0x2e, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2e, 0x63, 0x6c, 0x6f,
	0x75, 0x64, 0x2e, 0x77, 0x6f, 0x72, 0x6b, 0x66, 0x6c, 0x6f, 0x77, 0x73, 0x2e, 0x65, 0x78, 0x65,
	0x63, 0x75, 0x74, 0x69, 0x6f, 0x6e, 0x73, 0x2e, 0x76, 0x31, 0x2e, 0x45, 0x78, 0x65, 0x63, 0x75,
	0x74, 0x69, 0x6f, 0x6e, 0x2e, 0x53, 0x74, 0x61, 0x74, 0x65, 0x42, 0x03, 0xe0, 0x41, 0x03, 0x52,
	0x05, 0x73, 0x74, 0x61, 0x74, 0x65, 0x12, 0x1a, 0x0a, 0x08, 0x61, 0x72, 0x67, 0x75, 0x6d, 0x65,
	0x6e, 0x74, 0x18, 0x05, 0x20, 0x01, 0x28, 0x09, 0x52, 0x08, 0x61, 0x72, 0x67, 0x75, 0x6d, 0x65,
	0x6e, 0x74, 0x12, 0x1b, 0x0a, 0x06, 0x72, 0x65, 0x73, 0x75, 0x6c, 0x74, 0x18, 0x06, 0x20, 0x01,
	0x28, 0x09, 0x42, 0x03, 0xe0, 0x41, 0x03, 0x52, 0x06, 0x72, 0x65, 0x73, 0x75, 0x6c, 0x74, 0x12,
	0x50, 0x0a, 0x05, 0x65, 0x72, 0x72, 0x6f, 0x72, 0x18, 0x07, 0x20, 0x01, 0x28, 0x0b, 0x32, 0x35,
	0x2e, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2e, 0x63, 0x6c, 0x6f, 0x75, 0x64, 0x2e, 0x77, 0x6f,
	0x72, 0x6b, 0x66, 0x6c, 0x6f, 0x77, 0x73, 0x2e, 0x65, 0x78, 0x65, 0x63, 0x75, 0x74, 0x69, 0x6f,
	0x6e, 0x73, 0x2e, 0x76, 0x31, 0x2e, 0x45, 0x78, 0x65, 0x63, 0x75, 0x74, 0x69, 0x6f, 0x6e, 0x2e,
	0x45, 0x72, 0x72, 0x6f, 0x72, 0x42, 0x03, 0xe0, 0x41, 0x03, 0x52, 0x05, 0x65, 0x72, 0x72, 0x6f,
	0x72, 0x12, 0x35, 0x0a, 0x14, 0x77, 0x6f, 0x72, 0x6b, 0x66, 0x6c, 0x6f, 0x77, 0x5f, 0x72, 0x65,
	0x76, 0x69, 0x73, 0x69, 0x6f, 0x6e, 0x5f, 0x69, 0x64, 0x18, 0x08, 0x20, 0x01, 0x28, 0x09, 0x42,
	0x03, 0xe0, 0x41, 0x03, 0x52, 0x12, 0x77, 0x6f, 0x72, 0x6b, 0x66, 0x6c, 0x6f, 0x77, 0x52, 0x65,
	0x76, 0x69, 0x73, 0x69, 0x6f, 0x6e, 0x49, 0x64, 0x1a, 0x3b, 0x0a, 0x05, 0x45, 0x72, 0x72, 0x6f,
	0x72, 0x12, 0x18, 0x0a, 0x07, 0x70, 0x61, 0x79, 0x6c, 0x6f, 0x61, 0x64, 0x18, 0x01, 0x20, 0x01,
	0x28, 0x09, 0x52, 0x07, 0x70, 0x61, 0x79, 0x6c, 0x6f, 0x61, 0x64, 0x12, 0x18, 0x0a, 0x07, 0x63,
	0x6f, 0x6e, 0x74, 0x65, 0x78, 0x74, 0x18, 0x02, 0x20, 0x01, 0x28, 0x09, 0x52, 0x07, 0x63, 0x6f,
	0x6e, 0x74, 0x65, 0x78, 0x74, 0x22, 0x54, 0x0a, 0x05, 0x53, 0x74, 0x61, 0x74, 0x65, 0x12, 0x15,
	0x0a, 0x11, 0x53, 0x54, 0x41, 0x54, 0x45, 0x5f, 0x55, 0x4e, 0x53, 0x50, 0x45, 0x43, 0x49, 0x46,
	0x49, 0x45, 0x44, 0x10, 0x00, 0x12, 0x0a, 0x0a, 0x06, 0x41, 0x43, 0x54, 0x49, 0x56, 0x45, 0x10,
	0x01, 0x12, 0x0d, 0x0a, 0x09, 0x53, 0x55, 0x43, 0x43, 0x45, 0x45, 0x44, 0x45, 0x44, 0x10, 0x02,
	0x12, 0x0a, 0x0a, 0x06, 0x46, 0x41, 0x49, 0x4c, 0x45, 0x44, 0x10, 0x03, 0x12, 0x0d, 0x0a, 0x09,
	0x43, 0x41, 0x4e, 0x43, 0x45, 0x4c, 0x4c, 0x45, 0x44, 0x10, 0x04, 0x3a, 0x86, 0x01, 0xea, 0x41,
	0x82, 0x01, 0x0a, 0x2b, 0x77, 0x6f, 0x72, 0x6b, 0x66, 0x6c, 0x6f, 0x77, 0x65, 0x78, 0x65, 0x63,
	0x75, 0x74, 0x69, 0x6f, 0x6e, 0x73, 0x2e, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x61, 0x70, 0x69,
	0x73, 0x2e, 0x63, 0x6f, 0x6d, 0x2f, 0x45, 0x78, 0x65, 0x63, 0x75, 0x74, 0x69, 0x6f, 0x6e, 0x12,
	0x53, 0x70, 0x72, 0x6f, 0x6a, 0x65, 0x63, 0x74, 0x73, 0x2f, 0x7b, 0x70, 0x72, 0x6f, 0x6a, 0x65,
	0x63, 0x74, 0x7d, 0x2f, 0x6c, 0x6f, 0x63, 0x61, 0x74, 0x69, 0x6f, 0x6e, 0x73, 0x2f, 0x7b, 0x6c,
	0x6f, 0x63, 0x61, 0x74, 0x69, 0x6f, 0x6e, 0x7d, 0x2f, 0x77, 0x6f, 0x72, 0x6b, 0x66, 0x6c, 0x6f,
	0x77, 0x73, 0x2f, 0x7b, 0x77, 0x6f, 0x72, 0x6b, 0x66, 0x6c, 0x6f, 0x77, 0x7d, 0x2f, 0x65, 0x78,
	0x65, 0x63, 0x75, 0x74, 0x69, 0x6f, 0x6e, 0x73, 0x2f, 0x7b, 0x65, 0x78, 0x65, 0x63, 0x75, 0x74,
	0x69, 0x6f, 0x6e, 0x7d, 0x22, 0xe4, 0x01, 0x0a, 0x15, 0x4c, 0x69, 0x73, 0x74, 0x45, 0x78, 0x65,
	0x63, 0x75, 0x74, 0x69, 0x6f, 0x6e, 0x73, 0x52, 0x65, 0x71, 0x75, 0x65, 0x73, 0x74, 0x12, 0x41,
	0x0a, 0x06, 0x70, 0x61, 0x72, 0x65, 0x6e, 0x74, 0x18, 0x01, 0x20, 0x01, 0x28, 0x09, 0x42, 0x29,
	0xe0, 0x41, 0x02, 0xfa, 0x41, 0x23, 0x0a, 0x21, 0x77, 0x6f, 0x72, 0x6b, 0x66, 0x6c, 0x6f, 0x77,
	0x73, 0x2e, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x61, 0x70, 0x69, 0x73, 0x2e, 0x63, 0x6f, 0x6d,
	0x2f, 0x57, 0x6f, 0x72, 0x6b, 0x66, 0x6c, 0x6f, 0x77, 0x52, 0x06, 0x70, 0x61, 0x72, 0x65, 0x6e,
	0x74, 0x12, 0x1b, 0x0a, 0x09, 0x70, 0x61, 0x67, 0x65, 0x5f, 0x73, 0x69, 0x7a, 0x65, 0x18, 0x02,
	0x20, 0x01, 0x28, 0x05, 0x52, 0x08, 0x70, 0x61, 0x67, 0x65, 0x53, 0x69, 0x7a, 0x65, 0x12, 0x1d,
	0x0a, 0x0a, 0x70, 0x61, 0x67, 0x65, 0x5f, 0x74, 0x6f, 0x6b, 0x65, 0x6e, 0x18, 0x03, 0x20, 0x01,
	0x28, 0x09, 0x52, 0x09, 0x70, 0x61, 0x67, 0x65, 0x54, 0x6f, 0x6b, 0x65, 0x6e, 0x12, 0x4c, 0x0a,
	0x04, 0x76, 0x69, 0x65, 0x77, 0x18, 0x04, 0x20, 0x01, 0x28, 0x0e, 0x32, 0x33, 0x2e, 0x67, 0x6f,
	0x6f, 0x67, 0x6c, 0x65, 0x2e, 0x63, 0x6c, 0x6f, 0x75, 0x64, 0x2e, 0x77, 0x6f, 0x72, 0x6b, 0x66,
	0x6c, 0x6f, 0x77, 0x73, 0x2e, 0x65, 0x78, 0x65, 0x63, 0x75, 0x74, 0x69, 0x6f, 0x6e, 0x73, 0x2e,
	0x76, 0x31, 0x2e, 0x45, 0x78, 0x65, 0x63, 0x75, 0x74, 0x69, 0x6f, 0x6e, 0x56, 0x69, 0x65, 0x77,
	0x42, 0x03, 0xe0, 0x41, 0x01, 0x52, 0x04, 0x76, 0x69, 0x65, 0x77, 0x22, 0x91, 0x01, 0x0a, 0x16,
	0x4c, 0x69, 0x73, 0x74, 0x45, 0x78, 0x65, 0x63, 0x75, 0x74, 0x69, 0x6f, 0x6e, 0x73, 0x52, 0x65,
	0x73, 0x70, 0x6f, 0x6e, 0x73, 0x65, 0x12, 0x4f, 0x0a, 0x0a, 0x65, 0x78, 0x65, 0x63, 0x75, 0x74,
	0x69, 0x6f, 0x6e, 0x73, 0x18, 0x01, 0x20, 0x03, 0x28, 0x0b, 0x32, 0x2f, 0x2e, 0x67, 0x6f, 0x6f,
	0x67, 0x6c, 0x65, 0x2e, 0x63, 0x6c, 0x6f, 0x75, 0x64, 0x2e, 0x77, 0x6f, 0x72, 0x6b, 0x66, 0x6c,
	0x6f, 0x77, 0x73, 0x2e, 0x65, 0x78, 0x65, 0x63, 0x75, 0x74, 0x69, 0x6f, 0x6e, 0x73, 0x2e, 0x76,
	0x31, 0x2e, 0x45, 0x78, 0x65, 0x63, 0x75, 0x74, 0x69, 0x6f, 0x6e, 0x52, 0x0a, 0x65, 0x78, 0x65,
	0x63, 0x75, 0x74, 0x69, 0x6f, 0x6e, 0x73, 0x12, 0x26, 0x0a, 0x0f, 0x6e, 0x65, 0x78, 0x74, 0x5f,
	0x70, 0x61, 0x67, 0x65, 0x5f, 0x74, 0x6f, 0x6b, 0x65, 0x6e, 0x18, 0x02, 0x20, 0x01, 0x28, 0x09,
	0x52, 0x0d, 0x6e, 0x65, 0x78, 0x74, 0x50, 0x61, 0x67, 0x65, 0x54, 0x6f, 0x6b, 0x65, 0x6e, 0x22,
	0xaf, 0x01, 0x0a, 0x16, 0x43, 0x72, 0x65, 0x61, 0x74, 0x65, 0x45, 0x78, 0x65, 0x63, 0x75, 0x74,
	0x69, 0x6f, 0x6e, 0x52, 0x65, 0x71, 0x75, 0x65, 0x73, 0x74, 0x12, 0x41, 0x0a, 0x06, 0x70, 0x61,
	0x72, 0x65, 0x6e, 0x74, 0x18, 0x01, 0x20, 0x01, 0x28, 0x09, 0x42, 0x29, 0xe0, 0x41, 0x02, 0xfa,
	0x41, 0x23, 0x0a, 0x21, 0x77, 0x6f, 0x72, 0x6b, 0x66, 0x6c, 0x6f, 0x77, 0x73, 0x2e, 0x67, 0x6f,
	0x6f, 0x67, 0x6c, 0x65, 0x61, 0x70, 0x69, 0x73, 0x2e, 0x63, 0x6f, 0x6d, 0x2f, 0x57, 0x6f, 0x72,
	0x6b, 0x66, 0x6c, 0x6f, 0x77, 0x52, 0x06, 0x70, 0x61, 0x72, 0x65, 0x6e, 0x74, 0x12, 0x52, 0x0a,
	0x09, 0x65, 0x78, 0x65, 0x63, 0x75, 0x74, 0x69, 0x6f, 0x6e, 0x18, 0x02, 0x20, 0x01, 0x28, 0x0b,
	0x32, 0x2f, 0x2e, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2e, 0x63, 0x6c, 0x6f, 0x75, 0x64, 0x2e,
	0x77, 0x6f, 0x72, 0x6b, 0x66, 0x6c, 0x6f, 0x77, 0x73, 0x2e, 0x65, 0x78, 0x65, 0x63, 0x75, 0x74,
	0x69, 0x6f, 0x6e, 0x73, 0x2e, 0x76, 0x31, 0x2e, 0x45, 0x78, 0x65, 0x63, 0x75, 0x74, 0x69, 0x6f,
	0x6e, 0x42, 0x03, 0xe0, 0x41, 0x02, 0x52, 0x09, 0x65, 0x78, 0x65, 0x63, 0x75, 0x74, 0x69, 0x6f,
	0x6e, 0x22, 0xac, 0x01, 0x0a, 0x13, 0x47, 0x65, 0x74, 0x45, 0x78, 0x65, 0x63, 0x75, 0x74, 0x69,
	0x6f, 0x6e, 0x52, 0x65, 0x71, 0x75, 0x65, 0x73, 0x74, 0x12, 0x47, 0x0a, 0x04, 0x6e, 0x61, 0x6d,
	0x65, 0x18, 0x01, 0x20, 0x01, 0x28, 0x09, 0x42, 0x33, 0xe0, 0x41, 0x02, 0xfa, 0x41, 0x2d, 0x0a,
	0x2b, 0x77, 0x6f, 0x72, 0x6b, 0x66, 0x6c, 0x6f, 0x77, 0x65, 0x78, 0x65, 0x63, 0x75, 0x74, 0x69,
	0x6f, 0x6e, 0x73, 0x2e, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x61, 0x70, 0x69, 0x73, 0x2e, 0x63,
	0x6f, 0x6d, 0x2f, 0x45, 0x78, 0x65, 0x63, 0x75, 0x74, 0x69, 0x6f, 0x6e, 0x52, 0x04, 0x6e, 0x61,
	0x6d, 0x65, 0x12, 0x4c, 0x0a, 0x04, 0x76, 0x69, 0x65, 0x77, 0x18, 0x02, 0x20, 0x01, 0x28, 0x0e,
	0x32, 0x33, 0x2e, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2e, 0x63, 0x6c, 0x6f, 0x75, 0x64, 0x2e,
	0x77, 0x6f, 0x72, 0x6b, 0x66, 0x6c, 0x6f, 0x77, 0x73, 0x2e, 0x65, 0x78, 0x65, 0x63, 0x75, 0x74,
	0x69, 0x6f, 0x6e, 0x73, 0x2e, 0x76, 0x31, 0x2e, 0x45, 0x78, 0x65, 0x63, 0x75, 0x74, 0x69, 0x6f,
	0x6e, 0x56, 0x69, 0x65, 0x77, 0x42, 0x03, 0xe0, 0x41, 0x01, 0x52, 0x04, 0x76, 0x69, 0x65, 0x77,
	0x22, 0x61, 0x0a, 0x16, 0x43, 0x61, 0x6e, 0x63, 0x65, 0x6c, 0x45, 0x78, 0x65, 0x63, 0x75, 0x74,
	0x69, 0x6f, 0x6e, 0x52, 0x65, 0x71, 0x75, 0x65, 0x73, 0x74, 0x12, 0x47, 0x0a, 0x04, 0x6e, 0x61,
	0x6d, 0x65, 0x18, 0x01, 0x20, 0x01, 0x28, 0x09, 0x42, 0x33, 0xe0, 0x41, 0x02, 0xfa, 0x41, 0x2d,
	0x0a, 0x2b, 0x77, 0x6f, 0x72, 0x6b, 0x66, 0x6c, 0x6f, 0x77, 0x65, 0x78, 0x65, 0x63, 0x75, 0x74,
	0x69, 0x6f, 0x6e, 0x73, 0x2e, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x61, 0x70, 0x69, 0x73, 0x2e,
	0x63, 0x6f, 0x6d, 0x2f, 0x45, 0x78, 0x65, 0x63, 0x75, 0x74, 0x69, 0x6f, 0x6e, 0x52, 0x04, 0x6e,
	0x61, 0x6d, 0x65, 0x2a, 0x44, 0x0a, 0x0d, 0x45, 0x78, 0x65, 0x63, 0x75, 0x74, 0x69, 0x6f, 0x6e,
	0x56, 0x69, 0x65, 0x77, 0x12, 0x1e, 0x0a, 0x1a, 0x45, 0x58, 0x45, 0x43, 0x55, 0x54, 0x49, 0x4f,
	0x4e, 0x5f, 0x56, 0x49, 0x45, 0x57, 0x5f, 0x55, 0x4e, 0x53, 0x50, 0x45, 0x43, 0x49, 0x46, 0x49,
	0x45, 0x44, 0x10, 0x00, 0x12, 0x09, 0x0a, 0x05, 0x42, 0x41, 0x53, 0x49, 0x43, 0x10, 0x01, 0x12,
	0x08, 0x0a, 0x04, 0x46, 0x55, 0x4c, 0x4c, 0x10, 0x02, 0x32, 0xc3, 0x07, 0x0a, 0x0a, 0x45, 0x78,
	0x65, 0x63, 0x75, 0x74, 0x69, 0x6f, 0x6e, 0x73, 0x12, 0xd8, 0x01, 0x0a, 0x0e, 0x4c, 0x69, 0x73,
	0x74, 0x45, 0x78, 0x65, 0x63, 0x75, 0x74, 0x69, 0x6f, 0x6e, 0x73, 0x12, 0x3b, 0x2e, 0x67, 0x6f,
	0x6f, 0x67, 0x6c, 0x65, 0x2e, 0x63, 0x6c, 0x6f, 0x75, 0x64, 0x2e, 0x77, 0x6f, 0x72, 0x6b, 0x66,
	0x6c, 0x6f, 0x77, 0x73, 0x2e, 0x65, 0x78, 0x65, 0x63, 0x75, 0x74, 0x69, 0x6f, 0x6e, 0x73, 0x2e,
	0x76, 0x31, 0x2e, 0x4c, 0x69, 0x73, 0x74, 0x45, 0x78, 0x65, 0x63, 0x75, 0x74, 0x69, 0x6f, 0x6e,
	0x73, 0x52, 0x65, 0x71, 0x75, 0x65, 0x73, 0x74, 0x1a, 0x3c, 0x2e, 0x67, 0x6f, 0x6f, 0x67, 0x6c,
	0x65, 0x2e, 0x63, 0x6c, 0x6f, 0x75, 0x64, 0x2e, 0x77, 0x6f, 0x72, 0x6b, 0x66, 0x6c, 0x6f, 0x77,
	0x73, 0x2e, 0x65, 0x78, 0x65, 0x63, 0x75, 0x74, 0x69, 0x6f, 0x6e, 0x73, 0x2e, 0x76, 0x31, 0x2e,
	0x4c, 0x69, 0x73, 0x74, 0x45, 0x78, 0x65, 0x63, 0x75, 0x74, 0x69, 0x6f, 0x6e, 0x73, 0x52, 0x65,
	0x73, 0x70, 0x6f, 0x6e, 0x73, 0x65, 0x22, 0x4b, 0x82, 0xd3, 0xe4, 0x93, 0x02, 0x3c, 0x12, 0x3a,
	0x2f, 0x76, 0x31, 0x2f, 0x7b, 0x70, 0x61, 0x72, 0x65, 0x6e, 0x74, 0x3d, 0x70, 0x72, 0x6f, 0x6a,
	0x65, 0x63, 0x74, 0x73, 0x2f, 0x2a, 0x2f, 0x6c, 0x6f, 0x63, 0x61, 0x74, 0x69, 0x6f, 0x6e, 0x73,
	0x2f, 0x2a, 0x2f, 0x77, 0x6f, 0x72, 0x6b, 0x66, 0x6c, 0x6f, 0x77, 0x73, 0x2f, 0x2a, 0x7d, 0x2f,
	0x65, 0x78, 0x65, 0x63, 0x75, 0x74, 0x69, 0x6f, 0x6e, 0x73, 0xda, 0x41, 0x06, 0x70, 0x61, 0x72,
	0x65, 0x6e, 0x74, 0x12, 0xe2, 0x01, 0x0a, 0x0f, 0x43, 0x72, 0x65, 0x61, 0x74, 0x65, 0x45, 0x78,
	0x65, 0x63, 0x75, 0x74, 0x69, 0x6f, 0x6e, 0x12, 0x3c, 0x2e, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65,
	0x2e, 0x63, 0x6c, 0x6f, 0x75, 0x64, 0x2e, 0x77, 0x6f, 0x72, 0x6b, 0x66, 0x6c, 0x6f, 0x77, 0x73,
	0x2e, 0x65, 0x78, 0x65, 0x63, 0x75, 0x74, 0x69, 0x6f, 0x6e, 0x73, 0x2e, 0x76, 0x31, 0x2e, 0x43,
	0x72, 0x65, 0x61, 0x74, 0x65, 0x45, 0x78, 0x65, 0x63, 0x75, 0x74, 0x69, 0x6f, 0x6e, 0x52, 0x65,
	0x71, 0x75, 0x65, 0x73, 0x74, 0x1a, 0x2f, 0x2e, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2e, 0x63,
	0x6c, 0x6f, 0x75, 0x64, 0x2e, 0x77, 0x6f, 0x72, 0x6b, 0x66, 0x6c, 0x6f, 0x77, 0x73, 0x2e, 0x65,
	0x78, 0x65, 0x63, 0x75, 0x74, 0x69, 0x6f, 0x6e, 0x73, 0x2e, 0x76, 0x31, 0x2e, 0x45, 0x78, 0x65,
	0x63, 0x75, 0x74, 0x69, 0x6f, 0x6e, 0x22, 0x60, 0x82, 0xd3, 0xe4, 0x93, 0x02, 0x47, 0x22, 0x3a,
	0x2f, 0x76, 0x31, 0x2f, 0x7b, 0x70, 0x61, 0x72, 0x65, 0x6e, 0x74, 0x3d, 0x70, 0x72, 0x6f, 0x6a,
	0x65, 0x63, 0x74, 0x73, 0x2f, 0x2a, 0x2f, 0x6c, 0x6f, 0x63, 0x61, 0x74, 0x69, 0x6f, 0x6e, 0x73,
	0x2f, 0x2a, 0x2f, 0x77, 0x6f, 0x72, 0x6b, 0x66, 0x6c, 0x6f, 0x77, 0x73, 0x2f, 0x2a, 0x7d, 0x2f,
	0x65, 0x78, 0x65, 0x63, 0x75, 0x74, 0x69, 0x6f, 0x6e, 0x73, 0x3a, 0x09, 0x65, 0x78, 0x65, 0x63,
	0x75, 0x74, 0x69, 0x6f, 0x6e, 0xda, 0x41, 0x10, 0x70, 0x61, 0x72, 0x65, 0x6e, 0x74, 0x2c, 0x65,
	0x78, 0x65, 0x63, 0x75, 0x74, 0x69, 0x6f, 0x6e, 0x12, 0xc5, 0x01, 0x0a, 0x0c, 0x47, 0x65, 0x74,
	0x45, 0x78, 0x65, 0x63, 0x75, 0x74, 0x69, 0x6f, 0x6e, 0x12, 0x39, 0x2e, 0x67, 0x6f, 0x6f, 0x67,
	0x6c, 0x65, 0x2e, 0x63, 0x6c, 0x6f, 0x75, 0x64, 0x2e, 0x77, 0x6f, 0x72, 0x6b, 0x66, 0x6c, 0x6f,
	0x77, 0x73, 0x2e, 0x65, 0x78, 0x65, 0x63, 0x75, 0x74, 0x69, 0x6f, 0x6e, 0x73, 0x2e, 0x76, 0x31,
	0x2e, 0x47, 0x65, 0x74, 0x45, 0x78, 0x65, 0x63, 0x75, 0x74, 0x69, 0x6f, 0x6e, 0x52, 0x65, 0x71,
	0x75, 0x65, 0x73, 0x74, 0x1a, 0x2f, 0x2e, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2e, 0x63, 0x6c,
	0x6f, 0x75, 0x64, 0x2e, 0x77, 0x6f, 0x72, 0x6b, 0x66, 0x6c, 0x6f, 0x77, 0x73, 0x2e, 0x65, 0x78,
	0x65, 0x63, 0x75, 0x74, 0x69, 0x6f, 0x6e, 0x73, 0x2e, 0x76, 0x31, 0x2e, 0x45, 0x78, 0x65, 0x63,
	0x75, 0x74, 0x69, 0x6f, 0x6e, 0x22, 0x49, 0x82, 0xd3, 0xe4, 0x93, 0x02, 0x3c, 0x12, 0x3a, 0x2f,
	0x76, 0x31, 0x2f, 0x7b, 0x6e, 0x61, 0x6d, 0x65, 0x3d, 0x70, 0x72, 0x6f, 0x6a, 0x65, 0x63, 0x74,
	0x73, 0x2f, 0x2a, 0x2f, 0x6c, 0x6f, 0x63, 0x61, 0x74, 0x69, 0x6f, 0x6e, 0x73, 0x2f, 0x2a, 0x2f,
	0x77, 0x6f, 0x72, 0x6b, 0x66, 0x6c, 0x6f, 0x77, 0x73, 0x2f, 0x2a, 0x2f, 0x65, 0x78, 0x65, 0x63,
	0x75, 0x74, 0x69, 0x6f, 0x6e, 0x73, 0x2f, 0x2a, 0x7d, 0xda, 0x41, 0x04, 0x6e, 0x61, 0x6d, 0x65,
	0x12, 0xd5, 0x01, 0x0a, 0x0f, 0x43, 0x61, 0x6e, 0x63, 0x65, 0x6c, 0x45, 0x78, 0x65, 0x63, 0x75,
	0x74, 0x69, 0x6f, 0x6e, 0x12, 0x3c, 0x2e, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2e, 0x63, 0x6c,
	0x6f, 0x75, 0x64, 0x2e, 0x77, 0x6f, 0x72, 0x6b, 0x66, 0x6c, 0x6f, 0x77, 0x73, 0x2e, 0x65, 0x78,
	0x65, 0x63, 0x75, 0x74, 0x69, 0x6f, 0x6e, 0x73, 0x2e, 0x76, 0x31, 0x2e, 0x43, 0x61, 0x6e, 0x63,
	0x65, 0x6c, 0x45, 0x78, 0x65, 0x63, 0x75, 0x74, 0x69, 0x6f, 0x6e, 0x52, 0x65, 0x71, 0x75, 0x65,
	0x73, 0x74, 0x1a, 0x2f, 0x2e, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2e, 0x63, 0x6c, 0x6f, 0x75,
	0x64, 0x2e, 0x77, 0x6f, 0x72, 0x6b, 0x66, 0x6c, 0x6f, 0x77, 0x73, 0x2e, 0x65, 0x78, 0x65, 0x63,
	0x75, 0x74, 0x69, 0x6f, 0x6e, 0x73, 0x2e, 0x76, 0x31, 0x2e, 0x45, 0x78, 0x65, 0x63, 0x75, 0x74,
	0x69, 0x6f, 0x6e, 0x22, 0x53, 0x82, 0xd3, 0xe4, 0x93, 0x02, 0x46, 0x22, 0x41, 0x2f, 0x76, 0x31,
	0x2f, 0x7b, 0x6e, 0x61, 0x6d, 0x65, 0x3d, 0x70, 0x72, 0x6f, 0x6a, 0x65, 0x63, 0x74, 0x73, 0x2f,
	0x2a, 0x2f, 0x6c, 0x6f, 0x63, 0x61, 0x74, 0x69, 0x6f, 0x6e, 0x73, 0x2f, 0x2a, 0x2f, 0x77, 0x6f,
	0x72, 0x6b, 0x66, 0x6c, 0x6f, 0x77, 0x73, 0x2f, 0x2a, 0x2f, 0x65, 0x78, 0x65, 0x63, 0x75, 0x74,
	0x69, 0x6f, 0x6e, 0x73, 0x2f, 0x2a, 0x7d, 0x3a, 0x63, 0x61, 0x6e, 0x63, 0x65, 0x6c, 0x3a, 0x01,
	0x2a, 0xda, 0x41, 0x04, 0x6e, 0x61, 0x6d, 0x65, 0x1a, 0x55, 0xca, 0x41, 0x21, 0x77, 0x6f, 0x72,
	0x6b, 0x66, 0x6c, 0x6f, 0x77, 0x65, 0x78, 0x65, 0x63, 0x75, 0x74, 0x69, 0x6f, 0x6e, 0x73, 0x2e,
	0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x61, 0x70, 0x69, 0x73, 0x2e, 0x63, 0x6f, 0x6d, 0xd2, 0x41,
	0x2e, 0x68, 0x74, 0x74, 0x70, 0x73, 0x3a, 0x2f, 0x2f, 0x77, 0x77, 0x77, 0x2e, 0x67, 0x6f, 0x6f,
	0x67, 0x6c, 0x65, 0x61, 0x70, 0x69, 0x73, 0x2e, 0x63, 0x6f, 0x6d, 0x2f, 0x61, 0x75, 0x74, 0x68,
	0x2f, 0x63, 0x6c, 0x6f, 0x75, 0x64, 0x2d, 0x70, 0x6c, 0x61, 0x74, 0x66, 0x6f, 0x72, 0x6d, 0x42,
	0xf1, 0x01, 0x0a, 0x28, 0x63, 0x6f, 0x6d, 0x2e, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2e, 0x63,
	0x6c, 0x6f, 0x75, 0x64, 0x2e, 0x77, 0x6f, 0x72, 0x6b, 0x66, 0x6c, 0x6f, 0x77, 0x73, 0x2e, 0x65,
	0x78, 0x65, 0x63, 0x75, 0x74, 0x69, 0x6f, 0x6e, 0x73, 0x2e, 0x76, 0x31, 0x42, 0x0f, 0x45, 0x78,
	0x65, 0x63, 0x75, 0x74, 0x69, 0x6f, 0x6e, 0x73, 0x50, 0x72, 0x6f, 0x74, 0x6f, 0x50, 0x01, 0x5a,
	0x4e, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2e, 0x67, 0x6f, 0x6c, 0x61, 0x6e, 0x67, 0x2e, 0x6f,
	0x72, 0x67, 0x2f, 0x67, 0x65, 0x6e, 0x70, 0x72, 0x6f, 0x74, 0x6f, 0x2f, 0x67, 0x6f, 0x6f, 0x67,
	0x6c, 0x65, 0x61, 0x70, 0x69, 0x73, 0x2f, 0x63, 0x6c, 0x6f, 0x75, 0x64, 0x2f, 0x77, 0x6f, 0x72,
	0x6b, 0x66, 0x6c, 0x6f, 0x77, 0x73, 0x2f, 0x65, 0x78, 0x65, 0x63, 0x75, 0x74, 0x69, 0x6f, 0x6e,
	0x73, 0x2f, 0x76, 0x31, 0x3b, 0x65, 0x78, 0x65, 0x63, 0x75, 0x74, 0x69, 0x6f, 0x6e, 0x73, 0xea,
	0x41, 0x61, 0x0a, 0x21, 0x77, 0x6f, 0x72, 0x6b, 0x66, 0x6c, 0x6f, 0x77, 0x73, 0x2e, 0x67, 0x6f,
	0x6f, 0x67, 0x6c, 0x65, 0x61, 0x70, 0x69, 0x73, 0x2e, 0x63, 0x6f, 0x6d, 0x2f, 0x57, 0x6f, 0x72,
	0x6b, 0x66, 0x6c, 0x6f, 0x77, 0x12, 0x3c, 0x70, 0x72, 0x6f, 0x6a, 0x65, 0x63, 0x74, 0x73, 0x2f,
	0x7b, 0x70, 0x72, 0x6f, 0x6a, 0x65, 0x63, 0x74, 0x7d, 0x2f, 0x6c, 0x6f, 0x63, 0x61, 0x74, 0x69,
	0x6f, 0x6e, 0x73, 0x2f, 0x7b, 0x6c, 0x6f, 0x63, 0x61, 0x74, 0x69, 0x6f, 0x6e, 0x7d, 0x2f, 0x77,
	0x6f, 0x72, 0x6b, 0x66, 0x6c, 0x6f, 0x77, 0x73, 0x2f, 0x7b, 0x77, 0x6f, 0x72, 0x6b, 0x66, 0x6c,
	0x6f, 0x77, 0x7d, 0x62, 0x06, 0x70, 0x72, 0x6f, 0x74, 0x6f, 0x33,
}

var (
	file_google_cloud_workflows_executions_v1_executions_proto_rawDescOnce sync.Once
	file_google_cloud_workflows_executions_v1_executions_proto_rawDescData = file_google_cloud_workflows_executions_v1_executions_proto_rawDesc
)

func file_google_cloud_workflows_executions_v1_executions_proto_rawDescGZIP() []byte {
	file_google_cloud_workflows_executions_v1_executions_proto_rawDescOnce.Do(func() {
		file_google_cloud_workflows_executions_v1_executions_proto_rawDescData = protoimpl.X.CompressGZIP(file_google_cloud_workflows_executions_v1_executions_proto_rawDescData)
	})
	return file_google_cloud_workflows_executions_v1_executions_proto_rawDescData
}

var file_google_cloud_workflows_executions_v1_executions_proto_enumTypes = make([]protoimpl.EnumInfo, 2)
var file_google_cloud_workflows_executions_v1_executions_proto_msgTypes = make([]protoimpl.MessageInfo, 7)
var file_google_cloud_workflows_executions_v1_executions_proto_goTypes = []interface{}{
	(ExecutionView)(0),             // 0: google.cloud.workflows.executions.v1.ExecutionView
	(Execution_State)(0),           // 1: google.cloud.workflows.executions.v1.Execution.State
	(*Execution)(nil),              // 2: google.cloud.workflows.executions.v1.Execution
	(*ListExecutionsRequest)(nil),  // 3: google.cloud.workflows.executions.v1.ListExecutionsRequest
	(*ListExecutionsResponse)(nil), // 4: google.cloud.workflows.executions.v1.ListExecutionsResponse
	(*CreateExecutionRequest)(nil), // 5: google.cloud.workflows.executions.v1.CreateExecutionRequest
	(*GetExecutionRequest)(nil),    // 6: google.cloud.workflows.executions.v1.GetExecutionRequest
	(*CancelExecutionRequest)(nil), // 7: google.cloud.workflows.executions.v1.CancelExecutionRequest
	(*Execution_Error)(nil),        // 8: google.cloud.workflows.executions.v1.Execution.Error
	(*timestamppb.Timestamp)(nil),  // 9: google.protobuf.Timestamp
}
var file_google_cloud_workflows_executions_v1_executions_proto_depIdxs = []int32{
	9,  // 0: google.cloud.workflows.executions.v1.Execution.start_time:type_name -> google.protobuf.Timestamp
	9,  // 1: google.cloud.workflows.executions.v1.Execution.end_time:type_name -> google.protobuf.Timestamp
	1,  // 2: google.cloud.workflows.executions.v1.Execution.state:type_name -> google.cloud.workflows.executions.v1.Execution.State
	8,  // 3: google.cloud.workflows.executions.v1.Execution.error:type_name -> google.cloud.workflows.executions.v1.Execution.Error
	0,  // 4: google.cloud.workflows.executions.v1.ListExecutionsRequest.view:type_name -> google.cloud.workflows.executions.v1.ExecutionView
	2,  // 5: google.cloud.workflows.executions.v1.ListExecutionsResponse.executions:type_name -> google.cloud.workflows.executions.v1.Execution
	2,  // 6: google.cloud.workflows.executions.v1.CreateExecutionRequest.execution:type_name -> google.cloud.workflows.executions.v1.Execution
	0,  // 7: google.cloud.workflows.executions.v1.GetExecutionRequest.view:type_name -> google.cloud.workflows.executions.v1.ExecutionView
	3,  // 8: google.cloud.workflows.executions.v1.Executions.ListExecutions:input_type -> google.cloud.workflows.executions.v1.ListExecutionsRequest
	5,  // 9: google.cloud.workflows.executions.v1.Executions.CreateExecution:input_type -> google.cloud.workflows.executions.v1.CreateExecutionRequest
	6,  // 10: google.cloud.workflows.executions.v1.Executions.GetExecution:input_type -> google.cloud.workflows.executions.v1.GetExecutionRequest
	7,  // 11: google.cloud.workflows.executions.v1.Executions.CancelExecution:input_type -> google.cloud.workflows.executions.v1.CancelExecutionRequest
	4,  // 12: google.cloud.workflows.executions.v1.Executions.ListExecutions:output_type -> google.cloud.workflows.executions.v1.ListExecutionsResponse
	2,  // 13: google.cloud.workflows.executions.v1.Executions.CreateExecution:output_type -> google.cloud.workflows.executions.v1.Execution
	2,  // 14: google.cloud.workflows.executions.v1.Executions.GetExecution:output_type -> google.cloud.workflows.executions.v1.Execution
	2,  // 15: google.cloud.workflows.executions.v1.Executions.CancelExecution:output_type -> google.cloud.workflows.executions.v1.Execution
	12, // [12:16] is the sub-list for method output_type
	8,  // [8:12] is the sub-list for method input_type
	8,  // [8:8] is the sub-list for extension type_name
	8,  // [8:8] is the sub-list for extension extendee
	0,  // [0:8] is the sub-list for field type_name
}

func init() { file_google_cloud_workflows_executions_v1_executions_proto_init() }
func file_google_cloud_workflows_executions_v1_executions_proto_init() {
	if File_google_cloud_workflows_executions_v1_executions_proto != nil {
		return
	}
	if !protoimpl.UnsafeEnabled {
		file_google_cloud_workflows_executions_v1_executions_proto_msgTypes[0].Exporter = func(v interface{}, i int) interface{} {
			switch v := v.(*Execution); i {
			case 0:
				return &v.state
			case 1:
				return &v.sizeCache
			case 2:
				return &v.unknownFields
			default:
				return nil
			}
		}
		file_google_cloud_workflows_executions_v1_executions_proto_msgTypes[1].Exporter = func(v interface{}, i int) interface{} {
			switch v := v.(*ListExecutionsRequest); i {
			case 0:
				return &v.state
			case 1:
				return &v.sizeCache
			case 2:
				return &v.unknownFields
			default:
				return nil
			}
		}
		file_google_cloud_workflows_executions_v1_executions_proto_msgTypes[2].Exporter = func(v interface{}, i int) interface{} {
			switch v := v.(*ListExecutionsResponse); i {
			case 0:
				return &v.state
			case 1:
				return &v.sizeCache
			case 2:
				return &v.unknownFields
			default:
				return nil
			}
		}
		file_google_cloud_workflows_executions_v1_executions_proto_msgTypes[3].Exporter = func(v interface{}, i int) interface{} {
			switch v := v.(*CreateExecutionRequest); i {
			case 0:
				return &v.state
			case 1:
				return &v.sizeCache
			case 2:
				return &v.unknownFields
			default:
				return nil
			}
		}
		file_google_cloud_workflows_executions_v1_executions_proto_msgTypes[4].Exporter = func(v interface{}, i int) interface{} {
			switch v := v.(*GetExecutionRequest); i {
			case 0:
				return &v.state
			case 1:
				return &v.sizeCache
			case 2:
				return &v.unknownFields
			default:
				return nil
			}
		}
		file_google_cloud_workflows_executions_v1_executions_proto_msgTypes[5].Exporter = func(v interface{}, i int) interface{} {
			switch v := v.(*CancelExecutionRequest); i {
			case 0:
				return &v.state
			case 1:
				return &v.sizeCache
			case 2:
				return &v.unknownFields
			default:
				return nil
			}
		}
		file_google_cloud_workflows_executions_v1_executions_proto_msgTypes[6].Exporter = func(v interface{}, i int) interface{} {
			switch v := v.(*Execution_Error); i {
			case 0:
				return &v.state
			case 1:
				return &v.sizeCache
			case 2:
				return &v.unknownFields
			default:
				return nil
			}
		}
	}
	type x struct{}
	out := protoimpl.TypeBuilder{
		File: protoimpl.DescBuilder{
			GoPackagePath: reflect.TypeOf(x{}).PkgPath(),
			RawDescriptor: file_google_cloud_workflows_executions_v1_executions_proto_rawDesc,
			NumEnums:      2,
			NumMessages:   7,
			NumExtensions: 0,
			NumServices:   1,
		},
		GoTypes:           file_google_cloud_workflows_executions_v1_executions_proto_goTypes,
		DependencyIndexes: file_google_cloud_workflows_executions_v1_executions_proto_depIdxs,
		EnumInfos:         file_google_cloud_workflows_executions_v1_executions_proto_enumTypes,
		MessageInfos:      file_google_cloud_workflows_executions_v1_executions_proto_msgTypes,
	}.Build()
	File_google_cloud_workflows_executions_v1_executions_proto = out.File
	file_google_cloud_workflows_executions_v1_executions_proto_rawDesc = nil
	file_google_cloud_workflows_executions_v1_executions_proto_goTypes = nil
	file_google_cloud_workflows_executions_v1_executions_proto_depIdxs = nil
}

// Reference imports to suppress errors if they are not otherwise used.
var _ context.Context
var _ grpc.ClientConnInterface

// This is a compile-time assertion to ensure that this generated file
// is compatible with the grpc package it is being compiled against.
const _ = grpc.SupportPackageIsVersion6

// ExecutionsClient is the client API for Executions service.
//
// For semantics around ctx use and closing/ending streaming RPCs, please refer to https://godoc.org/google.golang.org/grpc#ClientConn.NewStream.
type ExecutionsClient interface {
	// Returns a list of executions which belong to the workflow with
	// the given name. The method returns executions of all workflow
	// revisions. Returned executions are ordered by their start time (newest
	// first).
	ListExecutions(ctx context.Context, in *ListExecutionsRequest, opts ...grpc.CallOption) (*ListExecutionsResponse, error)
	// Creates a new execution using the latest revision of the given workflow.
	CreateExecution(ctx context.Context, in *CreateExecutionRequest, opts ...grpc.CallOption) (*Execution, error)
	// Returns an execution of the given name.
	GetExecution(ctx context.Context, in *GetExecutionRequest, opts ...grpc.CallOption) (*Execution, error)
	// Cancels an execution of the given name.
	CancelExecution(ctx context.Context, in *CancelExecutionRequest, opts ...grpc.CallOption) (*Execution, error)
}

type executionsClient struct {
	cc grpc.ClientConnInterface
}

func NewExecutionsClient(cc grpc.ClientConnInterface) ExecutionsClient {
	return &executionsClient{cc}
}

func (c *executionsClient) ListExecutions(ctx context.Context, in *ListExecutionsRequest, opts ...grpc.CallOption) (*ListExecutionsResponse, error) {
	out := new(ListExecutionsResponse)
	err := c.cc.Invoke(ctx, "/google.cloud.workflows.executions.v1.Executions/ListExecutions", in, out, opts...)
	if err != nil {
		return nil, err
	}
	return out, nil
}

func (c *executionsClient) CreateExecution(ctx context.Context, in *CreateExecutionRequest, opts ...grpc.CallOption) (*Execution, error) {
	out := new(Execution)
	err := c.cc.Invoke(ctx, "/google.cloud.workflows.executions.v1.Executions/CreateExecution", in, out, opts...)
	if err != nil {
		return nil, err
	}
	return out, nil
}

func (c *executionsClient) GetExecution(ctx context.Context, in *GetExecutionRequest, opts ...grpc.CallOption) (*Execution, error) {
	out := new(Execution)
	err := c.cc.Invoke(ctx, "/google.cloud.workflows.executions.v1.Executions/GetExecution", in, out, opts...)
	if err != nil {
		return nil, err
	}
	return out, nil
}

func (c *executionsClient) CancelExecution(ctx context.Context, in *CancelExecutionRequest, opts ...grpc.CallOption) (*Execution, error) {
	out := new(Execution)
	err := c.cc.Invoke(ctx, "/google.cloud.workflows.executions.v1.Executions/CancelExecution", in, out, opts...)
	if err != nil {
		return nil, err
	}
	return out, nil
}

// ExecutionsServer is the server API for Executions service.
type ExecutionsServer interface {
	// Returns a list of executions which belong to the workflow with
	// the given name. The method returns executions of all workflow
	// revisions. Returned executions are ordered by their start time (newest
	// first).
	ListExecutions(context.Context, *ListExecutionsRequest) (*ListExecutionsResponse, error)
	// Creates a new execution using the latest revision of the given workflow.
	CreateExecution(context.Context, *CreateExecutionRequest) (*Execution, error)
	// Returns an execution of the given name.
	GetExecution(context.Context, *GetExecutionRequest) (*Execution, error)
	// Cancels an execution of the given name.
	CancelExecution(context.Context, *CancelExecutionRequest) (*Execution, error)
}

// UnimplementedExecutionsServer can be embedded to have forward compatible implementations.
type UnimplementedExecutionsServer struct {
}

func (*UnimplementedExecutionsServer) ListExecutions(context.Context, *ListExecutionsRequest) (*ListExecutionsResponse, error) {
	return nil, status.Errorf(codes.Unimplemented, "method ListExecutions not implemented")
}
func (*UnimplementedExecutionsServer) CreateExecution(context.Context, *CreateExecutionRequest) (*Execution, error) {
	return nil, status.Errorf(codes.Unimplemented, "method CreateExecution not implemented")
}
func (*UnimplementedExecutionsServer) GetExecution(context.Context, *GetExecutionRequest) (*Execution, error) {
	return nil, status.Errorf(codes.Unimplemented, "method GetExecution not implemented")
}
func (*UnimplementedExecutionsServer) CancelExecution(context.Context, *CancelExecutionRequest) (*Execution, error) {
	return nil, status.Errorf(codes.Unimplemented, "method CancelExecution not implemented")
}

func RegisterExecutionsServer(s *grpc.Server, srv ExecutionsServer) {
	s.RegisterService(&_Executions_serviceDesc, srv)
}

func _Executions_ListExecutions_Handler(srv interface{}, ctx context.Context, dec func(interface{}) error, interceptor grpc.UnaryServerInterceptor) (interface{}, error) {
	in := new(ListExecutionsRequest)
	if err := dec(in); err != nil {
		return nil, err
	}
	if interceptor == nil {
		return srv.(ExecutionsServer).ListExecutions(ctx, in)
	}
	info := &grpc.UnaryServerInfo{
		Server:     srv,
		FullMethod: "/google.cloud.workflows.executions.v1.Executions/ListExecutions",
	}
	handler := func(ctx context.Context, req interface{}) (interface{}, error) {
		return srv.(ExecutionsServer).ListExecutions(ctx, req.(*ListExecutionsRequest))
	}
	return interceptor(ctx, in, info, handler)
}

func _Executions_CreateExecution_Handler(srv interface{}, ctx context.Context, dec func(interface{}) error, interceptor grpc.UnaryServerInterceptor) (interface{}, error) {
	in := new(CreateExecutionRequest)
	if err := dec(in); err != nil {
		return nil, err
	}
	if interceptor == nil {
		return srv.(ExecutionsServer).CreateExecution(ctx, in)
	}
	info := &grpc.UnaryServerInfo{
		Server:     srv,
		FullMethod: "/google.cloud.workflows.executions.v1.Executions/CreateExecution",
	}
	handler := func(ctx context.Context, req interface{}) (interface{}, error) {
		return srv.(ExecutionsServer).CreateExecution(ctx, req.(*CreateExecutionRequest))
	}
	return interceptor(ctx, in, info, handler)
}

func _Executions_GetExecution_Handler(srv interface{}, ctx context.Context, dec func(interface{}) error, interceptor grpc.UnaryServerInterceptor) (interface{}, error) {
	in := new(GetExecutionRequest)
	if err := dec(in); err != nil {
		return nil, err
	}
	if interceptor == nil {
		return srv.(ExecutionsServer).GetExecution(ctx, in)
	}
	info := &grpc.UnaryServerInfo{
		Server:     srv,
		FullMethod: "/google.cloud.workflows.executions.v1.Executions/GetExecution",
	}
	handler := func(ctx context.Context, req interface{}) (interface{}, error) {
		return srv.(ExecutionsServer).GetExecution(ctx, req.(*GetExecutionRequest))
	}
	return interceptor(ctx, in, info, handler)
}

func _Executions_CancelExecution_Handler(srv interface{}, ctx context.Context, dec func(interface{}) error, interceptor grpc.UnaryServerInterceptor) (interface{}, error) {
	in := new(CancelExecutionRequest)
	if err := dec(in); err != nil {
		return nil, err
	}
	if interceptor == nil {
		return srv.(ExecutionsServer).CancelExecution(ctx, in)
	}
	info := &grpc.UnaryServerInfo{
		Server:     srv,
		FullMethod: "/google.cloud.workflows.executions.v1.Executions/CancelExecution",
	}
	handler := func(ctx context.Context, req interface{}) (interface{}, error) {
		return srv.(ExecutionsServer).CancelExecution(ctx, req.(*CancelExecutionRequest))
	}
	return interceptor(ctx, in, info, handler)
}

var _Executions_serviceDesc = grpc.ServiceDesc{
	ServiceName: "google.cloud.workflows.executions.v1.Executions",
	HandlerType: (*ExecutionsServer)(nil),
	Methods: []grpc.MethodDesc{
		{
			MethodName: "ListExecutions",
			Handler:    _Executions_ListExecutions_Handler,
		},
		{
			MethodName: "CreateExecution",
			Handler:    _Executions_CreateExecution_Handler,
		},
		{
			MethodName: "GetExecution",
			Handler:    _Executions_GetExecution_Handler,
		},
		{
			MethodName: "CancelExecution",
			Handler:    _Executions_CancelExecution_Handler,
		},
	},
	Streams:  []grpc.StreamDesc{},
	Metadata: "google/cloud/workflows/executions/v1/executions.proto",
}
