// Code generated by private/model/cli/gen-api/main.go. DO NOT EDIT.

// Package networkmanageriface provides an interface to enable mocking the AWS Network Manager service client
// for testing your code.
//
// It is important to note that this interface will have breaking changes
// when the service model is updated and adds new API operations, paginators,
// and waiters.
package networkmanageriface

import (
	"github.com/aws/aws-sdk-go/aws"
	"github.com/aws/aws-sdk-go/aws/request"
	"github.com/aws/aws-sdk-go/service/networkmanager"
)

// NetworkManagerAPI provides an interface to enable mocking the
// networkmanager.NetworkManager service client's API operation,
// paginators, and waiters. This make unit testing your code that calls out
// to the SDK's service client's calls easier.
//
// The best way to use this interface is so the SDK's service client's calls
// can be stubbed out for unit testing your code with the SDK without needing
// to inject custom request handlers into the SDK's request pipeline.
//
//    // myFunc uses an SDK service client to make a request to
//    // AWS Network Manager.
//    func myFunc(svc networkmanageriface.NetworkManagerAPI) bool {
//        // Make svc.AcceptAttachment request
//    }
//
//    func main() {
//        sess := session.New()
//        svc := networkmanager.New(sess)
//
//        myFunc(svc)
//    }
//
// In your _test.go file:
//
//    // Define a mock struct to be used in your unit tests of myFunc.
//    type mockNetworkManagerClient struct {
//        networkmanageriface.NetworkManagerAPI
//    }
//    func (m *mockNetworkManagerClient) AcceptAttachment(input *networkmanager.AcceptAttachmentInput) (*networkmanager.AcceptAttachmentOutput, error) {
//        // mock response/functionality
//    }
//
//    func TestMyFunc(t *testing.T) {
//        // Setup Test
//        mockSvc := &mockNetworkManagerClient{}
//
//        myfunc(mockSvc)
//
//        // Verify myFunc's functionality
//    }
//
// It is important to note that this interface will have breaking changes
// when the service model is updated and adds new API operations, paginators,
// and waiters. Its suggested to use the pattern above for testing, or using
// tooling to generate mocks to satisfy the interfaces.
type NetworkManagerAPI interface {
	AcceptAttachment(*networkmanager.AcceptAttachmentInput) (*networkmanager.AcceptAttachmentOutput, error)
	AcceptAttachmentWithContext(aws.Context, *networkmanager.AcceptAttachmentInput, ...request.Option) (*networkmanager.AcceptAttachmentOutput, error)
	AcceptAttachmentRequest(*networkmanager.AcceptAttachmentInput) (*request.Request, *networkmanager.AcceptAttachmentOutput)

	AssociateConnectPeer(*networkmanager.AssociateConnectPeerInput) (*networkmanager.AssociateConnectPeerOutput, error)
	AssociateConnectPeerWithContext(aws.Context, *networkmanager.AssociateConnectPeerInput, ...request.Option) (*networkmanager.AssociateConnectPeerOutput, error)
	AssociateConnectPeerRequest(*networkmanager.AssociateConnectPeerInput) (*request.Request, *networkmanager.AssociateConnectPeerOutput)

	AssociateCustomerGateway(*networkmanager.AssociateCustomerGatewayInput) (*networkmanager.AssociateCustomerGatewayOutput, error)
	AssociateCustomerGatewayWithContext(aws.Context, *networkmanager.AssociateCustomerGatewayInput, ...request.Option) (*networkmanager.AssociateCustomerGatewayOutput, error)
	AssociateCustomerGatewayRequest(*networkmanager.AssociateCustomerGatewayInput) (*request.Request, *networkmanager.AssociateCustomerGatewayOutput)

	AssociateLink(*networkmanager.AssociateLinkInput) (*networkmanager.AssociateLinkOutput, error)
	AssociateLinkWithContext(aws.Context, *networkmanager.AssociateLinkInput, ...request.Option) (*networkmanager.AssociateLinkOutput, error)
	AssociateLinkRequest(*networkmanager.AssociateLinkInput) (*request.Request, *networkmanager.AssociateLinkOutput)

	AssociateTransitGatewayConnectPeer(*networkmanager.AssociateTransitGatewayConnectPeerInput) (*networkmanager.AssociateTransitGatewayConnectPeerOutput, error)
	AssociateTransitGatewayConnectPeerWithContext(aws.Context, *networkmanager.AssociateTransitGatewayConnectPeerInput, ...request.Option) (*networkmanager.AssociateTransitGatewayConnectPeerOutput, error)
	AssociateTransitGatewayConnectPeerRequest(*networkmanager.AssociateTransitGatewayConnectPeerInput) (*request.Request, *networkmanager.AssociateTransitGatewayConnectPeerOutput)

	CreateConnectAttachment(*networkmanager.CreateConnectAttachmentInput) (*networkmanager.CreateConnectAttachmentOutput, error)
	CreateConnectAttachmentWithContext(aws.Context, *networkmanager.CreateConnectAttachmentInput, ...request.Option) (*networkmanager.CreateConnectAttachmentOutput, error)
	CreateConnectAttachmentRequest(*networkmanager.CreateConnectAttachmentInput) (*request.Request, *networkmanager.CreateConnectAttachmentOutput)

	CreateConnectPeer(*networkmanager.CreateConnectPeerInput) (*networkmanager.CreateConnectPeerOutput, error)
	CreateConnectPeerWithContext(aws.Context, *networkmanager.CreateConnectPeerInput, ...request.Option) (*networkmanager.CreateConnectPeerOutput, error)
	CreateConnectPeerRequest(*networkmanager.CreateConnectPeerInput) (*request.Request, *networkmanager.CreateConnectPeerOutput)

	CreateConnection(*networkmanager.CreateConnectionInput) (*networkmanager.CreateConnectionOutput, error)
	CreateConnectionWithContext(aws.Context, *networkmanager.CreateConnectionInput, ...request.Option) (*networkmanager.CreateConnectionOutput, error)
	CreateConnectionRequest(*networkmanager.CreateConnectionInput) (*request.Request, *networkmanager.CreateConnectionOutput)

	CreateCoreNetwork(*networkmanager.CreateCoreNetworkInput) (*networkmanager.CreateCoreNetworkOutput, error)
	CreateCoreNetworkWithContext(aws.Context, *networkmanager.CreateCoreNetworkInput, ...request.Option) (*networkmanager.CreateCoreNetworkOutput, error)
	CreateCoreNetworkRequest(*networkmanager.CreateCoreNetworkInput) (*request.Request, *networkmanager.CreateCoreNetworkOutput)

	CreateDevice(*networkmanager.CreateDeviceInput) (*networkmanager.CreateDeviceOutput, error)
	CreateDeviceWithContext(aws.Context, *networkmanager.CreateDeviceInput, ...request.Option) (*networkmanager.CreateDeviceOutput, error)
	CreateDeviceRequest(*networkmanager.CreateDeviceInput) (*request.Request, *networkmanager.CreateDeviceOutput)

	CreateGlobalNetwork(*networkmanager.CreateGlobalNetworkInput) (*networkmanager.CreateGlobalNetworkOutput, error)
	CreateGlobalNetworkWithContext(aws.Context, *networkmanager.CreateGlobalNetworkInput, ...request.Option) (*networkmanager.CreateGlobalNetworkOutput, error)
	CreateGlobalNetworkRequest(*networkmanager.CreateGlobalNetworkInput) (*request.Request, *networkmanager.CreateGlobalNetworkOutput)

	CreateLink(*networkmanager.CreateLinkInput) (*networkmanager.CreateLinkOutput, error)
	CreateLinkWithContext(aws.Context, *networkmanager.CreateLinkInput, ...request.Option) (*networkmanager.CreateLinkOutput, error)
	CreateLinkRequest(*networkmanager.CreateLinkInput) (*request.Request, *networkmanager.CreateLinkOutput)

	CreateSite(*networkmanager.CreateSiteInput) (*networkmanager.CreateSiteOutput, error)
	CreateSiteWithContext(aws.Context, *networkmanager.CreateSiteInput, ...request.Option) (*networkmanager.CreateSiteOutput, error)
	CreateSiteRequest(*networkmanager.CreateSiteInput) (*request.Request, *networkmanager.CreateSiteOutput)

	CreateSiteToSiteVpnAttachment(*networkmanager.CreateSiteToSiteVpnAttachmentInput) (*networkmanager.CreateSiteToSiteVpnAttachmentOutput, error)
	CreateSiteToSiteVpnAttachmentWithContext(aws.Context, *networkmanager.CreateSiteToSiteVpnAttachmentInput, ...request.Option) (*networkmanager.CreateSiteToSiteVpnAttachmentOutput, error)
	CreateSiteToSiteVpnAttachmentRequest(*networkmanager.CreateSiteToSiteVpnAttachmentInput) (*request.Request, *networkmanager.CreateSiteToSiteVpnAttachmentOutput)

	CreateVpcAttachment(*networkmanager.CreateVpcAttachmentInput) (*networkmanager.CreateVpcAttachmentOutput, error)
	CreateVpcAttachmentWithContext(aws.Context, *networkmanager.CreateVpcAttachmentInput, ...request.Option) (*networkmanager.CreateVpcAttachmentOutput, error)
	CreateVpcAttachmentRequest(*networkmanager.CreateVpcAttachmentInput) (*request.Request, *networkmanager.CreateVpcAttachmentOutput)

	DeleteAttachment(*networkmanager.DeleteAttachmentInput) (*networkmanager.DeleteAttachmentOutput, error)
	DeleteAttachmentWithContext(aws.Context, *networkmanager.DeleteAttachmentInput, ...request.Option) (*networkmanager.DeleteAttachmentOutput, error)
	DeleteAttachmentRequest(*networkmanager.DeleteAttachmentInput) (*request.Request, *networkmanager.DeleteAttachmentOutput)

	DeleteConnectPeer(*networkmanager.DeleteConnectPeerInput) (*networkmanager.DeleteConnectPeerOutput, error)
	DeleteConnectPeerWithContext(aws.Context, *networkmanager.DeleteConnectPeerInput, ...request.Option) (*networkmanager.DeleteConnectPeerOutput, error)
	DeleteConnectPeerRequest(*networkmanager.DeleteConnectPeerInput) (*request.Request, *networkmanager.DeleteConnectPeerOutput)

	DeleteConnection(*networkmanager.DeleteConnectionInput) (*networkmanager.DeleteConnectionOutput, error)
	DeleteConnectionWithContext(aws.Context, *networkmanager.DeleteConnectionInput, ...request.Option) (*networkmanager.DeleteConnectionOutput, error)
	DeleteConnectionRequest(*networkmanager.DeleteConnectionInput) (*request.Request, *networkmanager.DeleteConnectionOutput)

	DeleteCoreNetwork(*networkmanager.DeleteCoreNetworkInput) (*networkmanager.DeleteCoreNetworkOutput, error)
	DeleteCoreNetworkWithContext(aws.Context, *networkmanager.DeleteCoreNetworkInput, ...request.Option) (*networkmanager.DeleteCoreNetworkOutput, error)
	DeleteCoreNetworkRequest(*networkmanager.DeleteCoreNetworkInput) (*request.Request, *networkmanager.DeleteCoreNetworkOutput)

	DeleteCoreNetworkPolicyVersion(*networkmanager.DeleteCoreNetworkPolicyVersionInput) (*networkmanager.DeleteCoreNetworkPolicyVersionOutput, error)
	DeleteCoreNetworkPolicyVersionWithContext(aws.Context, *networkmanager.DeleteCoreNetworkPolicyVersionInput, ...request.Option) (*networkmanager.DeleteCoreNetworkPolicyVersionOutput, error)
	DeleteCoreNetworkPolicyVersionRequest(*networkmanager.DeleteCoreNetworkPolicyVersionInput) (*request.Request, *networkmanager.DeleteCoreNetworkPolicyVersionOutput)

	DeleteDevice(*networkmanager.DeleteDeviceInput) (*networkmanager.DeleteDeviceOutput, error)
	DeleteDeviceWithContext(aws.Context, *networkmanager.DeleteDeviceInput, ...request.Option) (*networkmanager.DeleteDeviceOutput, error)
	DeleteDeviceRequest(*networkmanager.DeleteDeviceInput) (*request.Request, *networkmanager.DeleteDeviceOutput)

	DeleteGlobalNetwork(*networkmanager.DeleteGlobalNetworkInput) (*networkmanager.DeleteGlobalNetworkOutput, error)
	DeleteGlobalNetworkWithContext(aws.Context, *networkmanager.DeleteGlobalNetworkInput, ...request.Option) (*networkmanager.DeleteGlobalNetworkOutput, error)
	DeleteGlobalNetworkRequest(*networkmanager.DeleteGlobalNetworkInput) (*request.Request, *networkmanager.DeleteGlobalNetworkOutput)

	DeleteLink(*networkmanager.DeleteLinkInput) (*networkmanager.DeleteLinkOutput, error)
	DeleteLinkWithContext(aws.Context, *networkmanager.DeleteLinkInput, ...request.Option) (*networkmanager.DeleteLinkOutput, error)
	DeleteLinkRequest(*networkmanager.DeleteLinkInput) (*request.Request, *networkmanager.DeleteLinkOutput)

	DeleteResourcePolicy(*networkmanager.DeleteResourcePolicyInput) (*networkmanager.DeleteResourcePolicyOutput, error)
	DeleteResourcePolicyWithContext(aws.Context, *networkmanager.DeleteResourcePolicyInput, ...request.Option) (*networkmanager.DeleteResourcePolicyOutput, error)
	DeleteResourcePolicyRequest(*networkmanager.DeleteResourcePolicyInput) (*request.Request, *networkmanager.DeleteResourcePolicyOutput)

	DeleteSite(*networkmanager.DeleteSiteInput) (*networkmanager.DeleteSiteOutput, error)
	DeleteSiteWithContext(aws.Context, *networkmanager.DeleteSiteInput, ...request.Option) (*networkmanager.DeleteSiteOutput, error)
	DeleteSiteRequest(*networkmanager.DeleteSiteInput) (*request.Request, *networkmanager.DeleteSiteOutput)

	DeregisterTransitGateway(*networkmanager.DeregisterTransitGatewayInput) (*networkmanager.DeregisterTransitGatewayOutput, error)
	DeregisterTransitGatewayWithContext(aws.Context, *networkmanager.DeregisterTransitGatewayInput, ...request.Option) (*networkmanager.DeregisterTransitGatewayOutput, error)
	DeregisterTransitGatewayRequest(*networkmanager.DeregisterTransitGatewayInput) (*request.Request, *networkmanager.DeregisterTransitGatewayOutput)

	DescribeGlobalNetworks(*networkmanager.DescribeGlobalNetworksInput) (*networkmanager.DescribeGlobalNetworksOutput, error)
	DescribeGlobalNetworksWithContext(aws.Context, *networkmanager.DescribeGlobalNetworksInput, ...request.Option) (*networkmanager.DescribeGlobalNetworksOutput, error)
	DescribeGlobalNetworksRequest(*networkmanager.DescribeGlobalNetworksInput) (*request.Request, *networkmanager.DescribeGlobalNetworksOutput)

	DescribeGlobalNetworksPages(*networkmanager.DescribeGlobalNetworksInput, func(*networkmanager.DescribeGlobalNetworksOutput, bool) bool) error
	DescribeGlobalNetworksPagesWithContext(aws.Context, *networkmanager.DescribeGlobalNetworksInput, func(*networkmanager.DescribeGlobalNetworksOutput, bool) bool, ...request.Option) error

	DisassociateConnectPeer(*networkmanager.DisassociateConnectPeerInput) (*networkmanager.DisassociateConnectPeerOutput, error)
	DisassociateConnectPeerWithContext(aws.Context, *networkmanager.DisassociateConnectPeerInput, ...request.Option) (*networkmanager.DisassociateConnectPeerOutput, error)
	DisassociateConnectPeerRequest(*networkmanager.DisassociateConnectPeerInput) (*request.Request, *networkmanager.DisassociateConnectPeerOutput)

	DisassociateCustomerGateway(*networkmanager.DisassociateCustomerGatewayInput) (*networkmanager.DisassociateCustomerGatewayOutput, error)
	DisassociateCustomerGatewayWithContext(aws.Context, *networkmanager.DisassociateCustomerGatewayInput, ...request.Option) (*networkmanager.DisassociateCustomerGatewayOutput, error)
	DisassociateCustomerGatewayRequest(*networkmanager.DisassociateCustomerGatewayInput) (*request.Request, *networkmanager.DisassociateCustomerGatewayOutput)

	DisassociateLink(*networkmanager.DisassociateLinkInput) (*networkmanager.DisassociateLinkOutput, error)
	DisassociateLinkWithContext(aws.Context, *networkmanager.DisassociateLinkInput, ...request.Option) (*networkmanager.DisassociateLinkOutput, error)
	DisassociateLinkRequest(*networkmanager.DisassociateLinkInput) (*request.Request, *networkmanager.DisassociateLinkOutput)

	DisassociateTransitGatewayConnectPeer(*networkmanager.DisassociateTransitGatewayConnectPeerInput) (*networkmanager.DisassociateTransitGatewayConnectPeerOutput, error)
	DisassociateTransitGatewayConnectPeerWithContext(aws.Context, *networkmanager.DisassociateTransitGatewayConnectPeerInput, ...request.Option) (*networkmanager.DisassociateTransitGatewayConnectPeerOutput, error)
	DisassociateTransitGatewayConnectPeerRequest(*networkmanager.DisassociateTransitGatewayConnectPeerInput) (*request.Request, *networkmanager.DisassociateTransitGatewayConnectPeerOutput)

	ExecuteCoreNetworkChangeSet(*networkmanager.ExecuteCoreNetworkChangeSetInput) (*networkmanager.ExecuteCoreNetworkChangeSetOutput, error)
	ExecuteCoreNetworkChangeSetWithContext(aws.Context, *networkmanager.ExecuteCoreNetworkChangeSetInput, ...request.Option) (*networkmanager.ExecuteCoreNetworkChangeSetOutput, error)
	ExecuteCoreNetworkChangeSetRequest(*networkmanager.ExecuteCoreNetworkChangeSetInput) (*request.Request, *networkmanager.ExecuteCoreNetworkChangeSetOutput)

	GetConnectAttachment(*networkmanager.GetConnectAttachmentInput) (*networkmanager.GetConnectAttachmentOutput, error)
	GetConnectAttachmentWithContext(aws.Context, *networkmanager.GetConnectAttachmentInput, ...request.Option) (*networkmanager.GetConnectAttachmentOutput, error)
	GetConnectAttachmentRequest(*networkmanager.GetConnectAttachmentInput) (*request.Request, *networkmanager.GetConnectAttachmentOutput)

	GetConnectPeer(*networkmanager.GetConnectPeerInput) (*networkmanager.GetConnectPeerOutput, error)
	GetConnectPeerWithContext(aws.Context, *networkmanager.GetConnectPeerInput, ...request.Option) (*networkmanager.GetConnectPeerOutput, error)
	GetConnectPeerRequest(*networkmanager.GetConnectPeerInput) (*request.Request, *networkmanager.GetConnectPeerOutput)

	GetConnectPeerAssociations(*networkmanager.GetConnectPeerAssociationsInput) (*networkmanager.GetConnectPeerAssociationsOutput, error)
	GetConnectPeerAssociationsWithContext(aws.Context, *networkmanager.GetConnectPeerAssociationsInput, ...request.Option) (*networkmanager.GetConnectPeerAssociationsOutput, error)
	GetConnectPeerAssociationsRequest(*networkmanager.GetConnectPeerAssociationsInput) (*request.Request, *networkmanager.GetConnectPeerAssociationsOutput)

	GetConnectPeerAssociationsPages(*networkmanager.GetConnectPeerAssociationsInput, func(*networkmanager.GetConnectPeerAssociationsOutput, bool) bool) error
	GetConnectPeerAssociationsPagesWithContext(aws.Context, *networkmanager.GetConnectPeerAssociationsInput, func(*networkmanager.GetConnectPeerAssociationsOutput, bool) bool, ...request.Option) error

	GetConnections(*networkmanager.GetConnectionsInput) (*networkmanager.GetConnectionsOutput, error)
	GetConnectionsWithContext(aws.Context, *networkmanager.GetConnectionsInput, ...request.Option) (*networkmanager.GetConnectionsOutput, error)
	GetConnectionsRequest(*networkmanager.GetConnectionsInput) (*request.Request, *networkmanager.GetConnectionsOutput)

	GetConnectionsPages(*networkmanager.GetConnectionsInput, func(*networkmanager.GetConnectionsOutput, bool) bool) error
	GetConnectionsPagesWithContext(aws.Context, *networkmanager.GetConnectionsInput, func(*networkmanager.GetConnectionsOutput, bool) bool, ...request.Option) error

	GetCoreNetwork(*networkmanager.GetCoreNetworkInput) (*networkmanager.GetCoreNetworkOutput, error)
	GetCoreNetworkWithContext(aws.Context, *networkmanager.GetCoreNetworkInput, ...request.Option) (*networkmanager.GetCoreNetworkOutput, error)
	GetCoreNetworkRequest(*networkmanager.GetCoreNetworkInput) (*request.Request, *networkmanager.GetCoreNetworkOutput)

	GetCoreNetworkChangeSet(*networkmanager.GetCoreNetworkChangeSetInput) (*networkmanager.GetCoreNetworkChangeSetOutput, error)
	GetCoreNetworkChangeSetWithContext(aws.Context, *networkmanager.GetCoreNetworkChangeSetInput, ...request.Option) (*networkmanager.GetCoreNetworkChangeSetOutput, error)
	GetCoreNetworkChangeSetRequest(*networkmanager.GetCoreNetworkChangeSetInput) (*request.Request, *networkmanager.GetCoreNetworkChangeSetOutput)

	GetCoreNetworkChangeSetPages(*networkmanager.GetCoreNetworkChangeSetInput, func(*networkmanager.GetCoreNetworkChangeSetOutput, bool) bool) error
	GetCoreNetworkChangeSetPagesWithContext(aws.Context, *networkmanager.GetCoreNetworkChangeSetInput, func(*networkmanager.GetCoreNetworkChangeSetOutput, bool) bool, ...request.Option) error

	GetCoreNetworkPolicy(*networkmanager.GetCoreNetworkPolicyInput) (*networkmanager.GetCoreNetworkPolicyOutput, error)
	GetCoreNetworkPolicyWithContext(aws.Context, *networkmanager.GetCoreNetworkPolicyInput, ...request.Option) (*networkmanager.GetCoreNetworkPolicyOutput, error)
	GetCoreNetworkPolicyRequest(*networkmanager.GetCoreNetworkPolicyInput) (*request.Request, *networkmanager.GetCoreNetworkPolicyOutput)

	GetCustomerGatewayAssociations(*networkmanager.GetCustomerGatewayAssociationsInput) (*networkmanager.GetCustomerGatewayAssociationsOutput, error)
	GetCustomerGatewayAssociationsWithContext(aws.Context, *networkmanager.GetCustomerGatewayAssociationsInput, ...request.Option) (*networkmanager.GetCustomerGatewayAssociationsOutput, error)
	GetCustomerGatewayAssociationsRequest(*networkmanager.GetCustomerGatewayAssociationsInput) (*request.Request, *networkmanager.GetCustomerGatewayAssociationsOutput)

	GetCustomerGatewayAssociationsPages(*networkmanager.GetCustomerGatewayAssociationsInput, func(*networkmanager.GetCustomerGatewayAssociationsOutput, bool) bool) error
	GetCustomerGatewayAssociationsPagesWithContext(aws.Context, *networkmanager.GetCustomerGatewayAssociationsInput, func(*networkmanager.GetCustomerGatewayAssociationsOutput, bool) bool, ...request.Option) error

	GetDevices(*networkmanager.GetDevicesInput) (*networkmanager.GetDevicesOutput, error)
	GetDevicesWithContext(aws.Context, *networkmanager.GetDevicesInput, ...request.Option) (*networkmanager.GetDevicesOutput, error)
	GetDevicesRequest(*networkmanager.GetDevicesInput) (*request.Request, *networkmanager.GetDevicesOutput)

	GetDevicesPages(*networkmanager.GetDevicesInput, func(*networkmanager.GetDevicesOutput, bool) bool) error
	GetDevicesPagesWithContext(aws.Context, *networkmanager.GetDevicesInput, func(*networkmanager.GetDevicesOutput, bool) bool, ...request.Option) error

	GetLinkAssociations(*networkmanager.GetLinkAssociationsInput) (*networkmanager.GetLinkAssociationsOutput, error)
	GetLinkAssociationsWithContext(aws.Context, *networkmanager.GetLinkAssociationsInput, ...request.Option) (*networkmanager.GetLinkAssociationsOutput, error)
	GetLinkAssociationsRequest(*networkmanager.GetLinkAssociationsInput) (*request.Request, *networkmanager.GetLinkAssociationsOutput)

	GetLinkAssociationsPages(*networkmanager.GetLinkAssociationsInput, func(*networkmanager.GetLinkAssociationsOutput, bool) bool) error
	GetLinkAssociationsPagesWithContext(aws.Context, *networkmanager.GetLinkAssociationsInput, func(*networkmanager.GetLinkAssociationsOutput, bool) bool, ...request.Option) error

	GetLinks(*networkmanager.GetLinksInput) (*networkmanager.GetLinksOutput, error)
	GetLinksWithContext(aws.Context, *networkmanager.GetLinksInput, ...request.Option) (*networkmanager.GetLinksOutput, error)
	GetLinksRequest(*networkmanager.GetLinksInput) (*request.Request, *networkmanager.GetLinksOutput)

	GetLinksPages(*networkmanager.GetLinksInput, func(*networkmanager.GetLinksOutput, bool) bool) error
	GetLinksPagesWithContext(aws.Context, *networkmanager.GetLinksInput, func(*networkmanager.GetLinksOutput, bool) bool, ...request.Option) error

	GetNetworkResourceCounts(*networkmanager.GetNetworkResourceCountsInput) (*networkmanager.GetNetworkResourceCountsOutput, error)
	GetNetworkResourceCountsWithContext(aws.Context, *networkmanager.GetNetworkResourceCountsInput, ...request.Option) (*networkmanager.GetNetworkResourceCountsOutput, error)
	GetNetworkResourceCountsRequest(*networkmanager.GetNetworkResourceCountsInput) (*request.Request, *networkmanager.GetNetworkResourceCountsOutput)

	GetNetworkResourceCountsPages(*networkmanager.GetNetworkResourceCountsInput, func(*networkmanager.GetNetworkResourceCountsOutput, bool) bool) error
	GetNetworkResourceCountsPagesWithContext(aws.Context, *networkmanager.GetNetworkResourceCountsInput, func(*networkmanager.GetNetworkResourceCountsOutput, bool) bool, ...request.Option) error

	GetNetworkResourceRelationships(*networkmanager.GetNetworkResourceRelationshipsInput) (*networkmanager.GetNetworkResourceRelationshipsOutput, error)
	GetNetworkResourceRelationshipsWithContext(aws.Context, *networkmanager.GetNetworkResourceRelationshipsInput, ...request.Option) (*networkmanager.GetNetworkResourceRelationshipsOutput, error)
	GetNetworkResourceRelationshipsRequest(*networkmanager.GetNetworkResourceRelationshipsInput) (*request.Request, *networkmanager.GetNetworkResourceRelationshipsOutput)

	GetNetworkResourceRelationshipsPages(*networkmanager.GetNetworkResourceRelationshipsInput, func(*networkmanager.GetNetworkResourceRelationshipsOutput, bool) bool) error
	GetNetworkResourceRelationshipsPagesWithContext(aws.Context, *networkmanager.GetNetworkResourceRelationshipsInput, func(*networkmanager.GetNetworkResourceRelationshipsOutput, bool) bool, ...request.Option) error

	GetNetworkResources(*networkmanager.GetNetworkResourcesInput) (*networkmanager.GetNetworkResourcesOutput, error)
	GetNetworkResourcesWithContext(aws.Context, *networkmanager.GetNetworkResourcesInput, ...request.Option) (*networkmanager.GetNetworkResourcesOutput, error)
	GetNetworkResourcesRequest(*networkmanager.GetNetworkResourcesInput) (*request.Request, *networkmanager.GetNetworkResourcesOutput)

	GetNetworkResourcesPages(*networkmanager.GetNetworkResourcesInput, func(*networkmanager.GetNetworkResourcesOutput, bool) bool) error
	GetNetworkResourcesPagesWithContext(aws.Context, *networkmanager.GetNetworkResourcesInput, func(*networkmanager.GetNetworkResourcesOutput, bool) bool, ...request.Option) error

	GetNetworkRoutes(*networkmanager.GetNetworkRoutesInput) (*networkmanager.GetNetworkRoutesOutput, error)
	GetNetworkRoutesWithContext(aws.Context, *networkmanager.GetNetworkRoutesInput, ...request.Option) (*networkmanager.GetNetworkRoutesOutput, error)
	GetNetworkRoutesRequest(*networkmanager.GetNetworkRoutesInput) (*request.Request, *networkmanager.GetNetworkRoutesOutput)

	GetNetworkTelemetry(*networkmanager.GetNetworkTelemetryInput) (*networkmanager.GetNetworkTelemetryOutput, error)
	GetNetworkTelemetryWithContext(aws.Context, *networkmanager.GetNetworkTelemetryInput, ...request.Option) (*networkmanager.GetNetworkTelemetryOutput, error)
	GetNetworkTelemetryRequest(*networkmanager.GetNetworkTelemetryInput) (*request.Request, *networkmanager.GetNetworkTelemetryOutput)

	GetNetworkTelemetryPages(*networkmanager.GetNetworkTelemetryInput, func(*networkmanager.GetNetworkTelemetryOutput, bool) bool) error
	GetNetworkTelemetryPagesWithContext(aws.Context, *networkmanager.GetNetworkTelemetryInput, func(*networkmanager.GetNetworkTelemetryOutput, bool) bool, ...request.Option) error

	GetResourcePolicy(*networkmanager.GetResourcePolicyInput) (*networkmanager.GetResourcePolicyOutput, error)
	GetResourcePolicyWithContext(aws.Context, *networkmanager.GetResourcePolicyInput, ...request.Option) (*networkmanager.GetResourcePolicyOutput, error)
	GetResourcePolicyRequest(*networkmanager.GetResourcePolicyInput) (*request.Request, *networkmanager.GetResourcePolicyOutput)

	GetRouteAnalysis(*networkmanager.GetRouteAnalysisInput) (*networkmanager.GetRouteAnalysisOutput, error)
	GetRouteAnalysisWithContext(aws.Context, *networkmanager.GetRouteAnalysisInput, ...request.Option) (*networkmanager.GetRouteAnalysisOutput, error)
	GetRouteAnalysisRequest(*networkmanager.GetRouteAnalysisInput) (*request.Request, *networkmanager.GetRouteAnalysisOutput)

	GetSiteToSiteVpnAttachment(*networkmanager.GetSiteToSiteVpnAttachmentInput) (*networkmanager.GetSiteToSiteVpnAttachmentOutput, error)
	GetSiteToSiteVpnAttachmentWithContext(aws.Context, *networkmanager.GetSiteToSiteVpnAttachmentInput, ...request.Option) (*networkmanager.GetSiteToSiteVpnAttachmentOutput, error)
	GetSiteToSiteVpnAttachmentRequest(*networkmanager.GetSiteToSiteVpnAttachmentInput) (*request.Request, *networkmanager.GetSiteToSiteVpnAttachmentOutput)

	GetSites(*networkmanager.GetSitesInput) (*networkmanager.GetSitesOutput, error)
	GetSitesWithContext(aws.Context, *networkmanager.GetSitesInput, ...request.Option) (*networkmanager.GetSitesOutput, error)
	GetSitesRequest(*networkmanager.GetSitesInput) (*request.Request, *networkmanager.GetSitesOutput)

	GetSitesPages(*networkmanager.GetSitesInput, func(*networkmanager.GetSitesOutput, bool) bool) error
	GetSitesPagesWithContext(aws.Context, *networkmanager.GetSitesInput, func(*networkmanager.GetSitesOutput, bool) bool, ...request.Option) error

	GetTransitGatewayConnectPeerAssociations(*networkmanager.GetTransitGatewayConnectPeerAssociationsInput) (*networkmanager.GetTransitGatewayConnectPeerAssociationsOutput, error)
	GetTransitGatewayConnectPeerAssociationsWithContext(aws.Context, *networkmanager.GetTransitGatewayConnectPeerAssociationsInput, ...request.Option) (*networkmanager.GetTransitGatewayConnectPeerAssociationsOutput, error)
	GetTransitGatewayConnectPeerAssociationsRequest(*networkmanager.GetTransitGatewayConnectPeerAssociationsInput) (*request.Request, *networkmanager.GetTransitGatewayConnectPeerAssociationsOutput)

	GetTransitGatewayConnectPeerAssociationsPages(*networkmanager.GetTransitGatewayConnectPeerAssociationsInput, func(*networkmanager.GetTransitGatewayConnectPeerAssociationsOutput, bool) bool) error
	GetTransitGatewayConnectPeerAssociationsPagesWithContext(aws.Context, *networkmanager.GetTransitGatewayConnectPeerAssociationsInput, func(*networkmanager.GetTransitGatewayConnectPeerAssociationsOutput, bool) bool, ...request.Option) error

	GetTransitGatewayRegistrations(*networkmanager.GetTransitGatewayRegistrationsInput) (*networkmanager.GetTransitGatewayRegistrationsOutput, error)
	GetTransitGatewayRegistrationsWithContext(aws.Context, *networkmanager.GetTransitGatewayRegistrationsInput, ...request.Option) (*networkmanager.GetTransitGatewayRegistrationsOutput, error)
	GetTransitGatewayRegistrationsRequest(*networkmanager.GetTransitGatewayRegistrationsInput) (*request.Request, *networkmanager.GetTransitGatewayRegistrationsOutput)

	GetTransitGatewayRegistrationsPages(*networkmanager.GetTransitGatewayRegistrationsInput, func(*networkmanager.GetTransitGatewayRegistrationsOutput, bool) bool) error
	GetTransitGatewayRegistrationsPagesWithContext(aws.Context, *networkmanager.GetTransitGatewayRegistrationsInput, func(*networkmanager.GetTransitGatewayRegistrationsOutput, bool) bool, ...request.Option) error

	GetVpcAttachment(*networkmanager.GetVpcAttachmentInput) (*networkmanager.GetVpcAttachmentOutput, error)
	GetVpcAttachmentWithContext(aws.Context, *networkmanager.GetVpcAttachmentInput, ...request.Option) (*networkmanager.GetVpcAttachmentOutput, error)
	GetVpcAttachmentRequest(*networkmanager.GetVpcAttachmentInput) (*request.Request, *networkmanager.GetVpcAttachmentOutput)

	ListAttachments(*networkmanager.ListAttachmentsInput) (*networkmanager.ListAttachmentsOutput, error)
	ListAttachmentsWithContext(aws.Context, *networkmanager.ListAttachmentsInput, ...request.Option) (*networkmanager.ListAttachmentsOutput, error)
	ListAttachmentsRequest(*networkmanager.ListAttachmentsInput) (*request.Request, *networkmanager.ListAttachmentsOutput)

	ListAttachmentsPages(*networkmanager.ListAttachmentsInput, func(*networkmanager.ListAttachmentsOutput, bool) bool) error
	ListAttachmentsPagesWithContext(aws.Context, *networkmanager.ListAttachmentsInput, func(*networkmanager.ListAttachmentsOutput, bool) bool, ...request.Option) error

	ListConnectPeers(*networkmanager.ListConnectPeersInput) (*networkmanager.ListConnectPeersOutput, error)
	ListConnectPeersWithContext(aws.Context, *networkmanager.ListConnectPeersInput, ...request.Option) (*networkmanager.ListConnectPeersOutput, error)
	ListConnectPeersRequest(*networkmanager.ListConnectPeersInput) (*request.Request, *networkmanager.ListConnectPeersOutput)

	ListConnectPeersPages(*networkmanager.ListConnectPeersInput, func(*networkmanager.ListConnectPeersOutput, bool) bool) error
	ListConnectPeersPagesWithContext(aws.Context, *networkmanager.ListConnectPeersInput, func(*networkmanager.ListConnectPeersOutput, bool) bool, ...request.Option) error

	ListCoreNetworkPolicyVersions(*networkmanager.ListCoreNetworkPolicyVersionsInput) (*networkmanager.ListCoreNetworkPolicyVersionsOutput, error)
	ListCoreNetworkPolicyVersionsWithContext(aws.Context, *networkmanager.ListCoreNetworkPolicyVersionsInput, ...request.Option) (*networkmanager.ListCoreNetworkPolicyVersionsOutput, error)
	ListCoreNetworkPolicyVersionsRequest(*networkmanager.ListCoreNetworkPolicyVersionsInput) (*request.Request, *networkmanager.ListCoreNetworkPolicyVersionsOutput)

	ListCoreNetworkPolicyVersionsPages(*networkmanager.ListCoreNetworkPolicyVersionsInput, func(*networkmanager.ListCoreNetworkPolicyVersionsOutput, bool) bool) error
	ListCoreNetworkPolicyVersionsPagesWithContext(aws.Context, *networkmanager.ListCoreNetworkPolicyVersionsInput, func(*networkmanager.ListCoreNetworkPolicyVersionsOutput, bool) bool, ...request.Option) error

	ListCoreNetworks(*networkmanager.ListCoreNetworksInput) (*networkmanager.ListCoreNetworksOutput, error)
	ListCoreNetworksWithContext(aws.Context, *networkmanager.ListCoreNetworksInput, ...request.Option) (*networkmanager.ListCoreNetworksOutput, error)
	ListCoreNetworksRequest(*networkmanager.ListCoreNetworksInput) (*request.Request, *networkmanager.ListCoreNetworksOutput)

	ListCoreNetworksPages(*networkmanager.ListCoreNetworksInput, func(*networkmanager.ListCoreNetworksOutput, bool) bool) error
	ListCoreNetworksPagesWithContext(aws.Context, *networkmanager.ListCoreNetworksInput, func(*networkmanager.ListCoreNetworksOutput, bool) bool, ...request.Option) error

	ListOrganizationServiceAccessStatus(*networkmanager.ListOrganizationServiceAccessStatusInput) (*networkmanager.ListOrganizationServiceAccessStatusOutput, error)
	ListOrganizationServiceAccessStatusWithContext(aws.Context, *networkmanager.ListOrganizationServiceAccessStatusInput, ...request.Option) (*networkmanager.ListOrganizationServiceAccessStatusOutput, error)
	ListOrganizationServiceAccessStatusRequest(*networkmanager.ListOrganizationServiceAccessStatusInput) (*request.Request, *networkmanager.ListOrganizationServiceAccessStatusOutput)

	ListTagsForResource(*networkmanager.ListTagsForResourceInput) (*networkmanager.ListTagsForResourceOutput, error)
	ListTagsForResourceWithContext(aws.Context, *networkmanager.ListTagsForResourceInput, ...request.Option) (*networkmanager.ListTagsForResourceOutput, error)
	ListTagsForResourceRequest(*networkmanager.ListTagsForResourceInput) (*request.Request, *networkmanager.ListTagsForResourceOutput)

	PutCoreNetworkPolicy(*networkmanager.PutCoreNetworkPolicyInput) (*networkmanager.PutCoreNetworkPolicyOutput, error)
	PutCoreNetworkPolicyWithContext(aws.Context, *networkmanager.PutCoreNetworkPolicyInput, ...request.Option) (*networkmanager.PutCoreNetworkPolicyOutput, error)
	PutCoreNetworkPolicyRequest(*networkmanager.PutCoreNetworkPolicyInput) (*request.Request, *networkmanager.PutCoreNetworkPolicyOutput)

	PutResourcePolicy(*networkmanager.PutResourcePolicyInput) (*networkmanager.PutResourcePolicyOutput, error)
	PutResourcePolicyWithContext(aws.Context, *networkmanager.PutResourcePolicyInput, ...request.Option) (*networkmanager.PutResourcePolicyOutput, error)
	PutResourcePolicyRequest(*networkmanager.PutResourcePolicyInput) (*request.Request, *networkmanager.PutResourcePolicyOutput)

	RegisterTransitGateway(*networkmanager.RegisterTransitGatewayInput) (*networkmanager.RegisterTransitGatewayOutput, error)
	RegisterTransitGatewayWithContext(aws.Context, *networkmanager.RegisterTransitGatewayInput, ...request.Option) (*networkmanager.RegisterTransitGatewayOutput, error)
	RegisterTransitGatewayRequest(*networkmanager.RegisterTransitGatewayInput) (*request.Request, *networkmanager.RegisterTransitGatewayOutput)

	RejectAttachment(*networkmanager.RejectAttachmentInput) (*networkmanager.RejectAttachmentOutput, error)
	RejectAttachmentWithContext(aws.Context, *networkmanager.RejectAttachmentInput, ...request.Option) (*networkmanager.RejectAttachmentOutput, error)
	RejectAttachmentRequest(*networkmanager.RejectAttachmentInput) (*request.Request, *networkmanager.RejectAttachmentOutput)

	RestoreCoreNetworkPolicyVersion(*networkmanager.RestoreCoreNetworkPolicyVersionInput) (*networkmanager.RestoreCoreNetworkPolicyVersionOutput, error)
	RestoreCoreNetworkPolicyVersionWithContext(aws.Context, *networkmanager.RestoreCoreNetworkPolicyVersionInput, ...request.Option) (*networkmanager.RestoreCoreNetworkPolicyVersionOutput, error)
	RestoreCoreNetworkPolicyVersionRequest(*networkmanager.RestoreCoreNetworkPolicyVersionInput) (*request.Request, *networkmanager.RestoreCoreNetworkPolicyVersionOutput)

	StartOrganizationServiceAccessUpdate(*networkmanager.StartOrganizationServiceAccessUpdateInput) (*networkmanager.StartOrganizationServiceAccessUpdateOutput, error)
	StartOrganizationServiceAccessUpdateWithContext(aws.Context, *networkmanager.StartOrganizationServiceAccessUpdateInput, ...request.Option) (*networkmanager.StartOrganizationServiceAccessUpdateOutput, error)
	StartOrganizationServiceAccessUpdateRequest(*networkmanager.StartOrganizationServiceAccessUpdateInput) (*request.Request, *networkmanager.StartOrganizationServiceAccessUpdateOutput)

	StartRouteAnalysis(*networkmanager.StartRouteAnalysisInput) (*networkmanager.StartRouteAnalysisOutput, error)
	StartRouteAnalysisWithContext(aws.Context, *networkmanager.StartRouteAnalysisInput, ...request.Option) (*networkmanager.StartRouteAnalysisOutput, error)
	StartRouteAnalysisRequest(*networkmanager.StartRouteAnalysisInput) (*request.Request, *networkmanager.StartRouteAnalysisOutput)

	TagResource(*networkmanager.TagResourceInput) (*networkmanager.TagResourceOutput, error)
	TagResourceWithContext(aws.Context, *networkmanager.TagResourceInput, ...request.Option) (*networkmanager.TagResourceOutput, error)
	TagResourceRequest(*networkmanager.TagResourceInput) (*request.Request, *networkmanager.TagResourceOutput)

	UntagResource(*networkmanager.UntagResourceInput) (*networkmanager.UntagResourceOutput, error)
	UntagResourceWithContext(aws.Context, *networkmanager.UntagResourceInput, ...request.Option) (*networkmanager.UntagResourceOutput, error)
	UntagResourceRequest(*networkmanager.UntagResourceInput) (*request.Request, *networkmanager.UntagResourceOutput)

	UpdateConnection(*networkmanager.UpdateConnectionInput) (*networkmanager.UpdateConnectionOutput, error)
	UpdateConnectionWithContext(aws.Context, *networkmanager.UpdateConnectionInput, ...request.Option) (*networkmanager.UpdateConnectionOutput, error)
	UpdateConnectionRequest(*networkmanager.UpdateConnectionInput) (*request.Request, *networkmanager.UpdateConnectionOutput)

	UpdateCoreNetwork(*networkmanager.UpdateCoreNetworkInput) (*networkmanager.UpdateCoreNetworkOutput, error)
	UpdateCoreNetworkWithContext(aws.Context, *networkmanager.UpdateCoreNetworkInput, ...request.Option) (*networkmanager.UpdateCoreNetworkOutput, error)
	UpdateCoreNetworkRequest(*networkmanager.UpdateCoreNetworkInput) (*request.Request, *networkmanager.UpdateCoreNetworkOutput)

	UpdateDevice(*networkmanager.UpdateDeviceInput) (*networkmanager.UpdateDeviceOutput, error)
	UpdateDeviceWithContext(aws.Context, *networkmanager.UpdateDeviceInput, ...request.Option) (*networkmanager.UpdateDeviceOutput, error)
	UpdateDeviceRequest(*networkmanager.UpdateDeviceInput) (*request.Request, *networkmanager.UpdateDeviceOutput)

	UpdateGlobalNetwork(*networkmanager.UpdateGlobalNetworkInput) (*networkmanager.UpdateGlobalNetworkOutput, error)
	UpdateGlobalNetworkWithContext(aws.Context, *networkmanager.UpdateGlobalNetworkInput, ...request.Option) (*networkmanager.UpdateGlobalNetworkOutput, error)
	UpdateGlobalNetworkRequest(*networkmanager.UpdateGlobalNetworkInput) (*request.Request, *networkmanager.UpdateGlobalNetworkOutput)

	UpdateLink(*networkmanager.UpdateLinkInput) (*networkmanager.UpdateLinkOutput, error)
	UpdateLinkWithContext(aws.Context, *networkmanager.UpdateLinkInput, ...request.Option) (*networkmanager.UpdateLinkOutput, error)
	UpdateLinkRequest(*networkmanager.UpdateLinkInput) (*request.Request, *networkmanager.UpdateLinkOutput)

	UpdateNetworkResourceMetadata(*networkmanager.UpdateNetworkResourceMetadataInput) (*networkmanager.UpdateNetworkResourceMetadataOutput, error)
	UpdateNetworkResourceMetadataWithContext(aws.Context, *networkmanager.UpdateNetworkResourceMetadataInput, ...request.Option) (*networkmanager.UpdateNetworkResourceMetadataOutput, error)
	UpdateNetworkResourceMetadataRequest(*networkmanager.UpdateNetworkResourceMetadataInput) (*request.Request, *networkmanager.UpdateNetworkResourceMetadataOutput)

	UpdateSite(*networkmanager.UpdateSiteInput) (*networkmanager.UpdateSiteOutput, error)
	UpdateSiteWithContext(aws.Context, *networkmanager.UpdateSiteInput, ...request.Option) (*networkmanager.UpdateSiteOutput, error)
	UpdateSiteRequest(*networkmanager.UpdateSiteInput) (*request.Request, *networkmanager.UpdateSiteOutput)

	UpdateVpcAttachment(*networkmanager.UpdateVpcAttachmentInput) (*networkmanager.UpdateVpcAttachmentOutput, error)
	UpdateVpcAttachmentWithContext(aws.Context, *networkmanager.UpdateVpcAttachmentInput, ...request.Option) (*networkmanager.UpdateVpcAttachmentOutput, error)
	UpdateVpcAttachmentRequest(*networkmanager.UpdateVpcAttachmentInput) (*request.Request, *networkmanager.UpdateVpcAttachmentOutput)
}

var _ NetworkManagerAPI = (*networkmanager.NetworkManager)(nil)
