/*
 * Decompiled with CFR 0.152.
 */
package com.github.javaparser.ast.expr;

import com.github.javaparser.Range;
import com.github.javaparser.ast.expr.AnnotationExpr;
import com.github.javaparser.ast.expr.ArrayInitializerExpr;
import com.github.javaparser.ast.expr.Expression;
import com.github.javaparser.ast.nodeTypes.NodeWithArrays;
import com.github.javaparser.ast.nodeTypes.NodeWithType;
import com.github.javaparser.ast.type.Type;
import com.github.javaparser.ast.visitor.GenericVisitor;
import com.github.javaparser.ast.visitor.VoidVisitor;
import com.github.javaparser.utils.Utils;
import java.util.List;

public final class ArrayCreationExpr
extends Expression
implements NodeWithType<ArrayCreationExpr>,
NodeWithArrays<ArrayCreationExpr> {
    private Type type;
    private int arrayCount;
    private ArrayInitializerExpr initializer;
    private List<Expression> dimensions;
    private List<List<AnnotationExpr>> arraysAnnotations;

    public ArrayCreationExpr() {
    }

    public ArrayCreationExpr(Type type, int arrayCount, ArrayInitializerExpr initializer) {
        this.setType(type);
        this.setArrayCount(arrayCount);
        this.setInitializer(initializer);
        this.setDimensions(null);
    }

    public ArrayCreationExpr(Range range, Type type, int arrayCount, ArrayInitializerExpr initializer) {
        super(range);
        this.setType(type);
        this.setArrayCount(arrayCount);
        this.setInitializer(initializer);
        this.setDimensions(null);
    }

    public ArrayCreationExpr(Type type, List<Expression> dimensions, int arrayCount) {
        this.setType(type);
        this.setArrayCount(arrayCount);
        this.setDimensions(dimensions);
        this.setInitializer(null);
    }

    public ArrayCreationExpr(Range range, Type type, List<Expression> dimensions, int arrayCount) {
        super(range);
        this.setType(type);
        this.setArrayCount(arrayCount);
        this.setDimensions(dimensions);
        this.setInitializer(null);
    }

    @Override
    public <R, A> R accept(GenericVisitor<R, A> v, A arg) {
        return v.visit(this, arg);
    }

    @Override
    public <A> void accept(VoidVisitor<A> v, A arg) {
        v.visit(this, arg);
    }

    @Override
    public int getArrayCount() {
        return this.arrayCount;
    }

    public List<Expression> getDimensions() {
        this.dimensions = Utils.ensureNotNull(this.dimensions);
        return this.dimensions;
    }

    public ArrayInitializerExpr getInitializer() {
        return this.initializer;
    }

    @Override
    public Type getType() {
        return this.type;
    }

    @Override
    public ArrayCreationExpr setArrayCount(int arrayCount) {
        this.arrayCount = arrayCount;
        return this;
    }

    public void setDimensions(List<Expression> dimensions) {
        this.dimensions = dimensions;
        this.setAsParentNodeOf(this.dimensions);
    }

    public void setInitializer(ArrayInitializerExpr initializer) {
        this.initializer = initializer;
        this.setAsParentNodeOf(this.initializer);
    }

    @Override
    public ArrayCreationExpr setType(Type type) {
        this.type = type;
        this.setAsParentNodeOf(this.type);
        return this;
    }

    @Override
    public List<List<AnnotationExpr>> getArraysAnnotations() {
        this.arraysAnnotations = Utils.ensureNotNull(this.arraysAnnotations);
        return this.arraysAnnotations;
    }

    @Override
    public ArrayCreationExpr setArraysAnnotations(List<List<AnnotationExpr>> arraysAnnotations) {
        this.arraysAnnotations = arraysAnnotations;
        return this;
    }
}

