/*
 * Decompiled with CFR 0.152.
 */
package com.github.javaparser.ast.expr;

import com.github.javaparser.Range;
import com.github.javaparser.ast.Modifier;
import com.github.javaparser.ast.body.VariableDeclarator;
import com.github.javaparser.ast.expr.AnnotationExpr;
import com.github.javaparser.ast.expr.Expression;
import com.github.javaparser.ast.nodeTypes.NodeWithAnnotations;
import com.github.javaparser.ast.nodeTypes.NodeWithModifiers;
import com.github.javaparser.ast.nodeTypes.NodeWithType;
import com.github.javaparser.ast.type.Type;
import com.github.javaparser.ast.visitor.GenericVisitor;
import com.github.javaparser.ast.visitor.VoidVisitor;
import com.github.javaparser.utils.Utils;
import java.util.Arrays;
import java.util.EnumSet;
import java.util.List;
import java.util.stream.Collectors;

public final class VariableDeclarationExpr
extends Expression
implements NodeWithType<VariableDeclarationExpr>,
NodeWithModifiers<VariableDeclarationExpr>,
NodeWithAnnotations<VariableDeclarationExpr> {
    private EnumSet<Modifier> modifiers = EnumSet.noneOf(Modifier.class);
    private List<AnnotationExpr> annotations;
    private Type type;
    private List<VariableDeclarator> vars;

    public VariableDeclarationExpr() {
    }

    public VariableDeclarationExpr(Type type, String variableName) {
        this.setType(type);
        this.setVars(Arrays.asList(new VariableDeclarator(variableName)));
    }

    public VariableDeclarationExpr(Type type, VariableDeclarator var) {
        this.setType(type);
        this.setVars(Arrays.asList(var));
    }

    public VariableDeclarationExpr(Type type, String variableName, Modifier ... modifiers) {
        this.setType(type);
        this.setVars(Arrays.asList(new VariableDeclarator(variableName)));
        this.setModifiers(Arrays.stream(modifiers).collect(Collectors.toCollection(() -> EnumSet.noneOf(Modifier.class))));
    }

    public VariableDeclarationExpr(Type type, VariableDeclarator var, Modifier ... modifiers) {
        this.setType(type);
        this.setVars(Arrays.asList(var));
        this.setModifiers(Arrays.stream(modifiers).collect(Collectors.toCollection(() -> EnumSet.noneOf(Modifier.class))));
    }

    public VariableDeclarationExpr(Type type, List<VariableDeclarator> vars) {
        this.setType(type);
        this.setVars(vars);
    }

    public VariableDeclarationExpr(EnumSet<Modifier> modifiers, Type type, List<VariableDeclarator> vars) {
        this.setModifiers((EnumSet)modifiers);
        this.setType(type);
        this.setVars(vars);
    }

    public VariableDeclarationExpr(Range range, EnumSet<Modifier> modifiers, List<AnnotationExpr> annotations, Type type, List<VariableDeclarator> vars) {
        super(range);
        this.setModifiers((EnumSet)modifiers);
        this.setAnnotations((List)annotations);
        this.setType(type);
        this.setVars(vars);
    }

    public static VariableDeclarationExpr create(Type type, String name) {
        return new VariableDeclarationExpr(type, name);
    }

    @Override
    public <R, A> R accept(GenericVisitor<R, A> v, A arg) {
        return v.visit(this, arg);
    }

    @Override
    public <A> void accept(VoidVisitor<A> v, A arg) {
        v.visit(this, arg);
    }

    @Override
    public List<AnnotationExpr> getAnnotations() {
        this.annotations = Utils.ensureNotNull(this.annotations);
        return this.annotations;
    }

    @Override
    public EnumSet<Modifier> getModifiers() {
        return this.modifiers;
    }

    @Override
    public Type getType() {
        return this.type;
    }

    public List<VariableDeclarator> getVars() {
        this.vars = Utils.ensureNotNull(this.vars);
        return this.vars;
    }

    @Override
    public VariableDeclarationExpr setAnnotations(List<AnnotationExpr> annotations) {
        this.annotations = annotations;
        this.setAsParentNodeOf(this.annotations);
        return this;
    }

    @Override
    public VariableDeclarationExpr setModifiers(EnumSet<Modifier> modifiers) {
        this.modifiers = modifiers;
        return this;
    }

    @Override
    public VariableDeclarationExpr setType(Type type) {
        this.type = type;
        this.setAsParentNodeOf(this.type);
        return this;
    }

    public void setVars(List<VariableDeclarator> vars) {
        this.vars = vars;
        this.setAsParentNodeOf(this.vars);
    }
}

