/*
 * Decompiled with CFR 0.152.
 */
package org.cachebench.cachewrappers;

import java.util.List;
import java.util.Map;
import javax.transaction.TransactionManager;
import org.cachebench.CacheWrapper;
import org.horizon.Cache;
import org.horizon.manager.CacheManager;
import org.horizon.manager.DefaultCacheManager;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class HorizonWrapper
implements CacheWrapper {
    CacheManager cacheManager;
    Cache cache;
    TransactionManager tm;
    boolean started = false;
    String config;

    @Override
    public void init(Map parameters) throws Exception {
        this.config = (String)parameters.get("config");
        this.setUp();
    }

    @Override
    public void setUp() throws Exception {
        if (!this.started) {
            this.cacheManager = new DefaultCacheManager(this.config);
            this.cache = this.cacheManager.getCache();
            this.started = true;
        }
    }

    @Override
    public void tearDown() throws Exception {
        if (this.started) {
            this.cacheManager.stop();
            this.started = false;
        }
    }

    @Override
    public void put(List<String> path, Object key, Object value) throws Exception {
        this.cache.put(key, value);
    }

    @Override
    public Object get(List<String> path, Object key) throws Exception {
        return this.cache.get(key);
    }

    @Override
    public void empty() throws Exception {
        this.cache.clear();
    }

    @Override
    public int getNumMembers() {
        return this.cacheManager.getMembers() == null ? 0 : this.cacheManager.getMembers().size();
    }

    @Override
    public String getInfo() {
        return this.cache.getVersion();
    }

    @Override
    public Object getReplicatedData(List<String> path, String key) throws Exception {
        return this.get(null, key);
    }

    @Override
    public Object startTransaction() {
        if (this.tm == null) {
            return null;
        }
        try {
            this.tm.begin();
            return this.tm.getTransaction();
        }
        catch (Exception e) {
            throw new RuntimeException(e);
        }
    }

    @Override
    public void endTransaction(boolean successful) {
        if (this.tm == null) {
            return;
        }
        try {
            if (successful) {
                this.tm.commit();
            } else {
                this.tm.rollback();
            }
        }
        catch (Exception e) {
            throw new RuntimeException(e);
        }
    }
}

