/*
 * Decompiled with CFR 0.152.
 */
package org.cachebench.cachewrappers;

import com.whirlycott.cache.Cache;
import com.whirlycott.cache.CacheManager;
import java.util.List;
import java.util.Map;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.cachebench.CacheWrapper;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class WhirlyCacheWrapper
implements CacheWrapper {
    private Cache cache;
    private Log logger = LogFactory.getLog(WhirlyCacheWrapper.class);

    @Override
    public void init(Map parameters) throws Exception {
        this.setUp();
    }

    @Override
    public void setUp() throws Exception {
        this.cache = CacheManager.getInstance().getCache();
        this.logger.debug((Object)"Finish Initializing the cache");
    }

    @Override
    public void tearDown() throws Exception {
        this.empty();
    }

    @Override
    public void empty() throws Exception {
        this.cache.clear();
    }

    @Override
    public void put(List<String> path, Object key, Object value) throws Exception {
        this.cache.store(key, value);
    }

    @Override
    public Object get(List<String> path, Object key) throws Exception {
        return this.cache.retrieve(key);
    }

    @Override
    public int getNumMembers() {
        return -1;
    }

    @Override
    public String getInfo() {
        return this.cache.toString();
    }

    @Override
    public Object getReplicatedData(List<String> path, String key) throws Exception {
        return this.get(path, key);
    }

    @Override
    public Object startTransaction() {
        throw new UnsupportedOperationException("Does not support JTA!");
    }

    @Override
    public void endTransaction(boolean successful) {
        throw new UnsupportedOperationException("Does not support JTA!");
    }
}

