/*
 * Decompiled with CFR 0.152.
 */
package org.cachebench.reportgenerators;

import java.io.IOException;
import org.cachebench.reportgenerators.AbstractChartGen;
import org.cachebench.reportgenerators.PutGetChartGenerator;
import org.cachebench.reportgenerators.ThroughputChartGenerator;

public class ChartGenerator {
    private static void help() {
        System.out.println("Usage:");
        System.out.println("   ChartGenerator [-reportDir <directory containing CSV files>] [-o <outputFileNamePrefix>] [-singleChart <true | false> if true, generates a single chart for all config files.] [-chartType <putget | throughput> defaults to throughput if not specified.]");
    }

    public static void main(String[] args) throws IOException {
        String reportDirectory = null;
        boolean singleChart = true;
        String fnPrefix = null;
        String chartType = "throughput";
        long startTime = System.currentTimeMillis();
        System.out.println("Welcome to the ChartGenerator.");
        for (int i = 0; i < args.length; ++i) {
            if (args[i].equals("-reportDir")) {
                reportDirectory = args[++i];
                continue;
            }
            if (args[i].equals("-singleChart")) {
                singleChart = Boolean.valueOf(args[++i]);
                continue;
            }
            if (args[i].equals("-o")) {
                fnPrefix = args[++i];
                continue;
            }
            if (args[i].equals("-chartType")) {
                chartType = args[++i];
                continue;
            }
            ChartGenerator.help();
            return;
        }
        if (reportDirectory == null) {
            ChartGenerator.help();
            return;
        }
        if (!singleChart) {
            throw new RuntimeException("Multiple charts not yet implemented");
        }
        AbstractChartGen gen = chartType.equalsIgnoreCase("putget") ? new PutGetChartGenerator() : new ThroughputChartGenerator();
        gen.setReportDirectory(reportDirectory);
        gen.setFileNamePrefix(fnPrefix);
        gen.generateChart();
        System.out.println("Finished in " + (System.currentTimeMillis() - startTime) / 1000L + " seconds!");
    }
}

