/*
 * Decompiled with CFR 0.152.
 */
package org.cachebench.reportgenerators;

import java.awt.Color;
import java.awt.Paint;
import java.io.BufferedReader;
import java.io.File;
import java.io.FileReader;
import java.io.FilenameFilter;
import java.io.IOException;
import java.util.Map;
import java.util.StringTokenizer;
import java.util.TreeMap;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.apache.commons.math.stat.descriptive.DescriptiveStatistics;
import org.cachebench.reportgenerators.AbstractChartGen;
import org.jfree.chart.ChartFactory;
import org.jfree.chart.ChartUtilities;
import org.jfree.chart.JFreeChart;
import org.jfree.chart.plot.PlotOrientation;
import org.jfree.chart.title.Title;
import org.jfree.data.category.CategoryDataset;
import org.jfree.data.category.DefaultCategoryDataset;

public class ThroughputChartGenerator
extends AbstractChartGen {
    private DefaultCategoryDataset averageThroughput;
    private DefaultCategoryDataset totalThroughput;
    private String chartNameAverage = "chart-averageThroughput.png";
    private String chartNameTotal = "chart-totalThroughput.png";
    private Log log = LogFactory.getLog(ThroughputChartGenerator.class);

    public void generateChart() throws IOException {
        this.readData();
        String chartAvgFileName = this.filenamePrefix == null ? this.chartNameAverage : this.filenamePrefix + "-" + this.chartNameAverage;
        File chartFile = new File(chartAvgFileName);
        if (chartFile.exists()) {
            chartFile.renameTo(new File(chartAvgFileName + "." + System.currentTimeMillis()));
            chartFile = new File(chartAvgFileName);
        }
        ChartUtilities.saveChartAsPNG((File)chartFile, (JFreeChart)this.createChart((CategoryDataset)this.averageThroughput, "Report: Average throughput per cache instance", "Throughput per cache instance (reqs/sec)"), (int)1024, (int)768);
        String chartTotalFileName = this.filenamePrefix == null ? this.chartNameTotal : this.filenamePrefix + "-" + this.chartNameTotal;
        chartFile = new File(chartTotalFileName);
        if (chartFile.exists()) {
            chartFile.renameTo(new File(chartTotalFileName + "." + System.currentTimeMillis()));
            chartFile = new File(chartTotalFileName);
        }
        ChartUtilities.saveChartAsPNG((File)chartFile, (JFreeChart)this.createChart((CategoryDataset)this.totalThroughput, "Report: Total throughput for cluster", "Overall throughput (reqs/sec)"), (int)1024, (int)768);
        System.out.println("Charts saved as " + chartAvgFileName + " and " + chartTotalFileName);
    }

    private JFreeChart createChart(CategoryDataset data, String title, String yLabel) {
        JFreeChart chart = ChartFactory.createLineChart((String)title, (String)"Cluster size (number of cache instances)", (String)yLabel, (CategoryDataset)data, (PlotOrientation)PlotOrientation.VERTICAL, (boolean)true, (boolean)false, (boolean)false);
        chart.addSubtitle((Title)this.getSubtitle());
        chart.setBorderVisible(true);
        chart.setAntiAlias(true);
        chart.setTextAntiAlias(true);
        chart.setBackgroundPaint((Paint)new Color(97, 158, 161));
        return chart;
    }

    private void readData() throws IOException {
        File file = new File(this.reportDirectory);
        if (!file.exists() || !file.isDirectory()) {
            throw new IllegalArgumentException("Report directory " + this.reportDirectory + " does not exist or is not a directory!");
        }
        File[] files = file.listFiles(new FilenameFilter(){

            public boolean accept(File dir, String name) {
                return name.toUpperCase().endsWith(".CSV");
            }
        });
        this.averageThroughput = new DefaultCategoryDataset();
        this.totalThroughput = new DefaultCategoryDataset();
        for (File f : files) {
            this.readData(f);
        }
        this.sort(this.averageThroughput);
        this.sort(this.totalThroughput);
    }

    private void sort(DefaultCategoryDataset data) {
        Map<Comparable, Number> rowData;
        TreeMap raw = new TreeMap();
        for (int i = 0; i < data.getRowCount(); ++i) {
            Comparable row = data.getRowKey(i);
            rowData = new TreeMap();
            for (int j = 0; j < data.getColumnCount(); ++j) {
                Comparable column = data.getColumnKey(j);
                Number value = data.getValue(i, j);
                rowData.put(column, value);
            }
            raw.put(row, rowData);
        }
        data.clear();
        for (Comparable row : raw.keySet()) {
            rowData = (Map)raw.get(row);
            for (Comparable column : rowData.keySet()) {
                data.addValue((Number)rowData.get(column), row, column);
            }
        }
    }

    private void readData(File f) throws IOException {
        this.log.info((Object)("Parsing file " + f.getAbsoluteFile()));
        Integer clusterSize = 0;
        DescriptiveStatistics stats = DescriptiveStatistics.newInstance();
        StringTokenizer strtok = new StringTokenizer(f.getName(), "_");
        strtok.nextToken();
        String productNameAndConfiguration = strtok.nextToken() + "(" + strtok.nextToken();
        if (productNameAndConfiguration.toUpperCase().endsWith(".XML")) {
            productNameAndConfiguration = productNameAndConfiguration.substring(0, productNameAndConfiguration.length() - 4);
        }
        productNameAndConfiguration = productNameAndConfiguration + ")";
        String cS = strtok.nextToken();
        if (cS.toUpperCase().endsWith(".CSV")) {
            cS = cS.substring(0, cS.length() - 4);
        }
        clusterSize = Integer.parseInt(cS);
        String line = null;
        BufferedReader br = new BufferedReader(new FileReader(f));
        while ((line = br.readLine()) != null) {
            double throughput = this.getThroughput(line);
            if (throughput == -1.0) continue;
            stats.addValue(throughput);
        }
        this.averageThroughput.addValue(stats.getMean(), (Comparable)((Object)productNameAndConfiguration), (Comparable)clusterSize);
        this.totalThroughput.addValue(stats.getSum(), (Comparable)((Object)productNameAndConfiguration), (Comparable)clusterSize);
    }

    private double getThroughput(String line) {
        StringTokenizer strTokenizer = new StringTokenizer(line, ",");
        if (strTokenizer.countTokens() < 2) {
            return -1.0;
        }
        strTokenizer.nextToken();
        strTokenizer.nextToken();
        String candidate = strTokenizer.nextToken();
        try {
            return Double.parseDouble(candidate);
        }
        catch (NumberFormatException nfe) {
            return -1.0;
        }
    }
}

