/*
 * Decompiled with CFR 0.152.
 */
package org.cachebench.tests;

import java.util.Arrays;
import java.util.Date;
import java.util.List;
import java.util.Random;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.Executors;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.atomic.AtomicLong;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.cachebench.CacheWrapper;
import org.cachebench.config.Configuration;
import org.cachebench.config.TestCase;
import org.cachebench.config.TestConfig;
import org.cachebench.tests.AbstractCacheTest;
import org.cachebench.tests.SessionSimulatorTestResult;
import org.cachebench.tests.results.TestResult;

public class SessionSimulatorTest
extends AbstractCacheTest {
    private static final Log log = LogFactory.getLog(SessionSimulatorTest.class);
    public static final String SESSION_PREFIX = "SESSION_";
    private static int LOG_AFTER_OPERATION_COUNT = 5000;
    Configuration configuration;
    private TestConfig thisTestConfig;
    private String sessionId;
    private CacheWrapper cacheWrapper;
    private boolean reportNanos = false;
    private boolean registerReplicationDelay = false;
    private int numberOfRequests;
    private int numberOfAttributes;
    private int sizeOfAnAttribute;
    private int writePercentage;
    private ExecutorService ex;
    private static Random r = new Random();

    public void setConfiguration(Configuration configuration) {
        this.configuration = configuration;
    }

    public TestResult doTest(String testName, CacheWrapper cache, String testCaseName, int sampleSize, int numThreads) throws Exception {
        this.ex = Executors.newFixedThreadPool(this.configuration.getNumThreads());
        this.cacheWrapper = cache;
        TestCase testCase = this.configuration.getTestCase(testCaseName);
        this.thisTestConfig = testCase.getTest(testName);
        this.readParams();
        this.initSession();
        return this.stressSession(testName, testCaseName);
    }

    private SessionSimulatorTestResult stressSession(String testName, String testCaseName) throws Exception {
        long totalBytesRead = 0L;
        long totalBytesWritten = 0L;
        long reads = 0L;
        long writes = 0L;
        int readPercentage = 100 - this.writePercentage;
        Random r = new Random();
        AtomicLong durationNanos = new AtomicLong(0L);
        for (int i = 0; i < this.numberOfRequests; ++i) {
            this.logRunCount(i);
            int randomAction = r.nextInt(100);
            int randomAttribute = r.nextInt(this.numberOfAttributes - 1);
            String sessionEntry = this.getSessionEntry(randomAttribute);
            List<String> path = this.generatePath(this.sessionId, randomAttribute);
            if (randomAction < readPercentage) {
                this.ex.execute(new ReadTask(path, durationNanos, sessionEntry));
                ++reads;
                continue;
            }
            this.ex.execute(new WriteTask(path, durationNanos, sessionEntry));
            ++writes;
        }
        this.ex.shutdown();
        this.ex.awaitTermination(600L, TimeUnit.SECONDS);
        long duration = this.reportNanos ? durationNanos.get() : durationNanos.get() / 1000000L;
        SessionSimulatorTestResult result = new SessionSimulatorTestResult(reads, writes, duration, totalBytesRead, totalBytesWritten);
        result.setTestPassed(true);
        result.setTestName(testCaseName + this.getNodeIndex());
        result.setTestTime(new Date());
        result.setTestType(testName);
        log.trace((Object)("Returning result:" + result));
        return result;
    }

    private long verifyReplicationDelay(long replicationDelay) throws Exception {
        if (this.registerReplicationDelay) {
            log.info((Object)"Gathering replication delay");
            String key = "registerReplicationDelay";
            List<String> path = Arrays.asList(key);
            int clusterSize = this.configuration.getClusterConfig().getClusterSize();
            while (this.notAllAck(path, this.cacheWrapper)) {
                this.cacheWrapper.put(path, key + this.getNodeIndex(), this.getNodeIndex());
                for (int i = 0; i < clusterSize; ++i) {
                    Object replicatedValue = this.cacheWrapper.get(path, key + i);
                    if (log.isTraceEnabled()) {
                        log.trace((Object)("replication delay value from node " + i + " is " + replicatedValue));
                    }
                    if (replicatedValue == null) continue;
                    this.cacheWrapper.put(path, this.buildAckKey(Integer.parseInt(String.valueOf(replicatedValue)), this.getNodeIndex()), "recieved");
                }
                Thread.sleep(1000L);
            }
            replicationDelay = System.currentTimeMillis() - replicationDelay;
            log.info((Object)("Replication delay is " + replicationDelay + " millis."));
        }
        return replicationDelay;
    }

    private String buildAckKey(int sender, int receiver) {
        return sender + "->" + receiver;
    }

    private boolean notAllAck(List path, CacheWrapper cacheWrapper) throws Exception {
        for (int i = 0; i < this.configuration.getClusterConfig().getClusterSize(); ++i) {
            for (int j = 0; j < this.configuration.getClusterConfig().getClusterSize(); ++j) {
                if (cacheWrapper.get(path, this.buildAckKey(i, j)) != null) continue;
                if (log.isTraceEnabled()) {
                    log.trace((Object)("Missing replication message: " + this.buildAckKey(i, j)));
                }
                return true;
            }
        }
        return false;
    }

    private void logRunCount(int i) {
        if ((i + 1) % LOG_AFTER_OPERATION_COUNT == 0 || i == 0) {
            log.info((Object)("SessionSimulatorTest performed " + (i == 0 ? 0 : i + 1) + " operations"));
        }
    }

    private void initSession() throws Exception {
        for (int i = 0; i < this.numberOfAttributes; ++i) {
            try {
                this.cacheWrapper.put(this.generatePath(this.sessionId, i), this.getSessionEntry(i), new byte[this.sizeOfAnAttribute]);
                continue;
            }
            catch (Throwable e) {
                log.warn((Object)"Error while initializing the session: ", e);
            }
        }
    }

    private String getSessionEntry(int i) {
        return this.sessionId + i;
    }

    private void readParams() {
        this.sessionId = SESSION_PREFIX + this.getNodeIndex();
        log.debug((Object)("Session id is: " + this.sessionId));
        this.numberOfRequests = this.thisTestConfig.getIntValue("numberOfRequest");
        this.numberOfAttributes = this.thisTestConfig.getIntValue("numberOfAttributes");
        this.writePercentage = this.thisTestConfig.getIntValue("writePercentage");
        this.sizeOfAnAttribute = this.thisTestConfig.getIntValue("sizeOfAnAttribute");
        if (this.thisTestConfig.existsParam("reportNanos")) {
            this.reportNanos = this.thisTestConfig.getBooleanValue("reportNanos");
        }
        if (this.thisTestConfig.existsParam("registerReplicationDelay")) {
            this.registerReplicationDelay = this.thisTestConfig.getBooleanValue("registerReplicationDelay");
        }
        log.debug((Object)("recieved follosing params[ numberOfRequests=" + this.numberOfRequests + ", numberOfAttributes=" + this.numberOfAttributes + ", writePercentage=" + this.writePercentage + ", sizeOfAnAttribute=" + this.sizeOfAnAttribute + " ]"));
    }

    public int getNodeIndex() {
        return this.configuration.isLocalOnly() ? 0 : this.configuration.getClusterConfig().getCurrentNodeIndex();
    }

    private static String generateRandomString(int size) {
        StringBuilder sb = new StringBuilder();
        for (int i = 0; i < size / 2; ++i) {
            sb.append((char)(64 + r.nextInt(26)));
        }
        return sb.toString();
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    private class ReadTask
    extends Task {
        protected ReadTask(List<String> path, AtomicLong durationNanos, Object sessionEntry) {
            super(path, durationNanos, sessionEntry);
        }

        @Override
        public void run() {
            try {
                long start = System.nanoTime();
                SessionSimulatorTest.this.cacheWrapper.get(this.path, this.sessionEntry);
                this.durationNanos.getAndAdd(System.nanoTime() - start);
            }
            catch (Throwable e) {
                log.warn((Object)("Error appeared whilst reading from cache:" + e.getMessage()), e);
            }
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    private class WriteTask
    extends Task {
        protected WriteTask(List<String> path, AtomicLong durationNanos, Object sessionEntry) {
            super(path, durationNanos, sessionEntry);
        }

        @Override
        public void run() {
            try {
                String payload = SessionSimulatorTest.generateRandomString(SessionSimulatorTest.this.sizeOfAnAttribute);
                long start = System.nanoTime();
                SessionSimulatorTest.this.cacheWrapper.put(this.path, this.sessionEntry, payload);
                this.durationNanos.getAndAdd(System.nanoTime() - start);
            }
            catch (Throwable e) {
                log.warn((Object)("Error appeared whilst writing to cache:" + e.getMessage()), e);
            }
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    private static abstract class Task
    implements Runnable {
        List<String> path;
        AtomicLong durationNanos;
        Object sessionEntry;

        protected Task(List<String> path, AtomicLong durationNanos, Object sessionEntry) {
            this.path = path;
            this.durationNanos = durationNanos;
            this.sessionEntry = sessionEntry;
        }
    }
}

