# Changelog

All notable changes to this project will be documented in this file.

The format is based on [Keep a Changelog](https://keepachangelog.com/en/1.0.0/)
and this project adheres to [Semantic Versioning](https://semver.org/spec/v2.0.0.html).

## [v0.10.0] - 2022-06-22

The v0.10.0 release of the Hubble CLI coincides with Cilium v1.12.
It adds a new `--first` option to query for earlier flows and events
(#716, requires Cilium v1.12 and newer), further improves the default `compact`
output by displaying security identities and refining policy verdict event output
(#717, #734, #745), and deprecates the `-o json` option in favor of `-o jsonpb`
(#738).

This release also contains many quality of life improvements, such as more
flexible time range filter parsing (#707), extended shell completion for
various filter flags (#727, #744), support for named identity filters (#732),
improvements to the command-line usage documentation (#718, #730, #731, #733),
and an updated version of the Hubble logo (#726).

**Major Changes:**
* cli: Deprecate `-o json`, recommend `-o jsonpb` instead (#738, @gandro)
* cmd/observe: Add --first to support querying for earlier flows and events (#719, @chancez)
* printer: Display security identity in compact output (#717, @gandro)

**Minor Changes:**
* Add support for less granular time formats (#707, @rolinh)
* cmd/observe: add flag completion for `--protocol` (#727, @rolinh)
* cmd/observe: document subtypes and add completion for subtypes (#744, @rolinh)
* cmd/observe: improve policy verdict output in compact mode (#745, @rolinh)

**Bugfixes:**
* cmd/config: ensure that the configuration directory exist (#684, @rolinh)
* cmd/observe: match only Hubble-specific part of error in Test_getFlowsRequestWithInvalidRawFilters (#655, @tklauser)

**CI Changes:**
* .github: let dependabot ignore Cilium dependency (#675, @tklauser)

**Misc Changes:**
* build(deps): bump actions/checkout from 2.4.0 to 3 (#693, @dependabot[bot])
* build(deps): bump actions/checkout from 3.0.0 to 3.0.1 (#705, @dependabot[bot])
* build(deps): bump actions/checkout from 3.0.1 to 3.0.2 (#709, @dependabot[bot])
* build(deps): bump actions/download-artifact from 2.0.10 to 2.1.0 (#668, @dependabot[bot])
* build(deps): bump actions/download-artifact from 2.1.0 to 3 (#688, @dependabot[bot])
* build(deps): bump actions/setup-go from 2.1.4 to 2.1.5 (#665, @dependabot[bot])
* build(deps): bump actions/setup-go from 2.1.5 to 2.2.0 (#680, @dependabot[bot])
* build(deps): bump actions/setup-go from 2.2.0 to 3 (#697, @dependabot[bot])
* build(deps): bump actions/setup-go from 3.1.0 to 3.2.0 (#746, @dependabot[bot])
* build(deps): bump actions/upload-artifact from 2.2.4 to 2.3.0 (#662, @dependabot[bot])
* build(deps): bump actions/upload-artifact from 2.3.0 to 2.3.1 (#663, @dependabot[bot])
* build(deps): bump actions/upload-artifact from 2.3.1 to 3 (#701, @dependabot[bot])
* build(deps): bump actions/upload-artifact from 3.0.0 to 3.1.0 (#724, @dependabot[bot])
* build(deps): bump docker/build-push-action from 2.10.0 to 3 (#728, @dependabot[bot])
* build(deps): bump docker/build-push-action from 2.7.0 to 2.8.0 (#673, @dependabot[bot])
* build(deps): bump docker/build-push-action from 2.8.0 to 2.9.0 (#679, @dependabot[bot])
* build(deps): bump docker/build-push-action from 2.9.0 to 2.10.0 (#699, @dependabot[bot])
* build(deps): bump docker/login-action from 1.10.0 to 1.12.0 (#669, @dependabot[bot])
* build(deps): bump docker/login-action from 1.12.0 to 1.13.0 (#683, @dependabot[bot])
* build(deps): bump docker/login-action from 1.13.0 to 1.14.1 (#704, @dependabot[bot])
* build(deps): bump docker/login-action from 1.14.1 to 2 (#742, @dependabot[bot])
* build(deps): bump docker/setup-buildx-action from 1.6.0 to 2 (#714, @dependabot[bot])
* build(deps): bump github.com/cilium/cilium from 1.11.0 to 1.11.1 (#674, @dependabot[bot])
* build(deps): bump github.com/google/go-cmp from 0.5.6 to 0.5.7 (#676, @dependabot[bot])
* build(deps): bump github.com/google/go-cmp from 0.5.7 to 0.5.8 (#712, @dependabot[bot])
* build(deps): bump github.com/spf13/cast from 1.4.1 to 1.5.0 (#725, @dependabot[bot])
* build(deps): bump github.com/spf13/cobra from 1.2.1 to 1.3.0 (#664, @dependabot[bot])
* build(deps): bump github.com/spf13/cobra from 1.3.0 to 1.4.0 (#694, @dependabot[bot])
* build(deps): bump github.com/spf13/viper from 1.10.0 to 1.10.1 (#667, @dependabot[bot])
* build(deps): bump github.com/spf13/viper from 1.10.1 to 1.11.0 (#706, @dependabot[bot])
* build(deps): bump github.com/spf13/viper from 1.11.0 to 1.12.0 (#729, @dependabot[bot])
* build(deps): bump github.com/stretchr/testify from 1.7.0 to 1.7.1 (#698, @dependabot[bot])
* build(deps): bump github.com/stretchr/testify from 1.7.1 to 1.7.2 (#743, @dependabot[bot])
* build(deps): bump github/codeql-action from 1 to 2 (#711, @dependabot[bot])
* build(deps): bump github/codeql-action from 96bc9c36c68e097cd033777efed25c248ffcf09a to 2.1.12 (#735, @dependabot[bot])
* build(deps): bump golangci/golangci-lint-action from 2 to 3.1.0 (#685, @dependabot[bot])
* build(deps): bump golangci/golangci-lint-action from 3.1.0 to 3.2.0 (#720, @dependabot[bot])
* build(deps): bump google.golang.org/grpc from 1.42.0 to 1.43.0 (#666, @dependabot[bot])
* build(deps): bump google.golang.org/grpc from 1.43.0 to 1.44.0 (#678, @dependabot[bot])
* build(deps): bump google.golang.org/grpc from 1.44.0 to 1.45.0 (#702, @dependabot[bot])
* build(deps): bump google.golang.org/grpc from 1.45.0 to 1.46.0 (#710, @dependabot[bot])
* build(deps): bump google.golang.org/grpc from 1.46.0 to 1.46.2 (#721, @dependabot[bot])
* build(deps): bump google.golang.org/grpc from 1.46.2 to 1.47.0 (#736, @dependabot[bot])
* build(deps): bump google.golang.org/protobuf from 1.27.1 to 1.28.0 (#700, @dependabot[bot])
* bump Go to v1.18.1, update golangci-lint to v1.45.2 (#708, @rolinh)
* ci: bump golangci-lint to v1.45.0 (#696, @rolinh)
* ci: use hashes for all GitHub Action modules (#722, @rolinh)
* compact: Use "ID" for security identity prefix (#734, @michi-covalent)
* Dockerfile: fix golang image name to v1.18.2 (#723, @kaworu)
* docs: Document pod/service filter prefix behavior (#733, @slayer321)
* docs: update logos and add dark logo (#726, @raphink)
* docs: update the cli doc with cidr range source/destination ip filter (#731, @slayer321)
* go.mod, vendor: update cilium to 1.11.0 (#658, @tklauser)
* improve cli help text for service filtering (#730, @ILLIDOM)
* named reserved identites support for `--{,from-,to-}identity` (#732, @kaworu)
* Prepare for v0.10 development cycle (#652, @gandro)
* Refactor usage template to determine --help flags using a registration pattern (#718, @chancez)
* release and changelog misc improvements (#659, @kaworu)
* Update Cobra to v1.5.0 (#747, @rolinh)
* Update Go to 1.17.4 and alpine to 3.15 (#653, @tklauser)
* Update Go to 1.17.5 (#660, @tklauser)
* Update Go to 1.17.6 (#670, @tklauser)
* Update Go to 1.17.7 (#681, @tklauser)
* Update Go to 1.17.8 (#689, @tklauser)
* Update Go to 1.18.2 (#715, @tklauser)
* Update Go to 1.18.3, alpine to 3.16, golangci-lint to 1.46.2 (#737, @tklauser)
* Update Go to v1.18 (#695, @rolinh)
* vendor: Bump Cilium to v1.12 branch (#748, @gandro)
* vendor: update yaml.v3 to v3.0.1 (#741, @kaworu)

## [v0.9.0] - 2021-11-30

Hubble v0.9.0 coincides with Cilium v1.11. It brings many improvements to the
CLI: Colored output (#551), improved readability and alternative output formats
in `hubble status` (#629, #614), and the ability to specify custom filters via
the newly introduced `--allowlist` and `--denylist` flags (#643). Other changes
include automatic stop conditions for `hubble record` (#607), omit displaying
old flows in follow mode by default (#573) and client binary support for
Windows ARM64 (#618).

**Minor Changes:**
* build release binaries for Windows ARM64 (#618, @rolinh)
* cmd/observe: add color support (#551, @rolinh)
* cmd/observe: do not set `--last` to 20 by default in follow mode (#573, @rolinh)
* cmd/record: Add stop condition flags (#607, @gandro)
* cmd/status: add support for multiple output formats (#614, @rolinh)
* observe: Add --allowlist / --denylist flags (#643, @michi-covalent)
* printer: group digits by 3 for flow counters and make uptime human-readable (#629, @rolinh)
* Update cobra to v1.2.1 and use built-in completion command (#582, @rolinh)

**Bugfixes:**
* printer: Add missing verdicts (#626, @pchaigno)
* printer: fix dict outout newline (#615, @rolinh)

**CI Changes:**
* .github: Cancel outdated PR and push workflows (#555, @pchaigno)
* Add CODEOWNERS (#576, @gandro)
* ci: bump golangci-lint to v1.42.0 (#611, @tklauser)
* CODEOWNERS: assign GH actions to github-sec team (#577, @tklauser)

**Misc Changes:**
* .github/workflows: move Go module vendoring check to build checks (#563, @tklauser)
* .github: Rename maintainer's little helper's config file (#569, @pchaigno)
* build(deps): bump actions/checkout from 2 to 2.3.5 (#640, @dependabot[bot])
* build(deps): bump actions/checkout from 2.3.5 to 2.4.0 (#648, @dependabot[bot])
* build(deps): bump actions/setup-go from 2.1.3 to 2.1.4 (#616, @dependabot[bot])
* build(deps): bump github.com/fatih/color from 1.10.0 to 1.12.0 (#558, @dependabot[bot])
* build(deps): bump github.com/fatih/color from 1.12.0 to 1.13.0 (#633, @dependabot[bot])
* build(deps): bump github.com/google/go-cmp from 0.5.5 to 0.5.6 (#561, @dependabot[bot])
* build(deps): bump github.com/spf13/cast from 1.3.1 to 1.4.0 (#600, @dependabot[bot])
* build(deps): bump github.com/spf13/cast from 1.4.0 to 1.4.1 (#613, @dependabot[bot])
* build(deps): bump github.com/spf13/viper from 1.8.0 to 1.8.1 (#579, @dependabot[bot])
* build(deps): bump github.com/spf13/viper from 1.8.1 to 1.9.0 (#628, @dependabot[bot])
* build(deps): bump google.golang.org/grpc from 1.38.0 to 1.39.0 (#584, @dependabot[bot])
* build(deps): bump google.golang.org/grpc from 1.39.0 to 1.39.1 (#608, @dependabot[bot])
* build(deps): bump google.golang.org/grpc from 1.39.1 to 1.40.0 (#610, @dependabot[bot])
* build(deps): bump google.golang.org/grpc from 1.40.0 to 1.41.0 (#634, @dependabot[bot])
* build(deps): bump google.golang.org/grpc from 1.41.0 to 1.42.0 (#649, @dependabot[bot])
* build(deps): bump google.golang.org/protobuf from 1.26.0 to 1.27.1 (#583, @dependabot[bot])
* build(deps): bump skx/github-action-publish-binaries from c881a3f8ffb80b684f367660178d38ceabc065c2 to 2.0 (#632, @dependabot[bot])
* ci: bump Go to 1.17 for golangci-lint (#625, @kaworu)
* ci: enable checks for missing Go documentation (#581, @rolinh)
* ci: fix the go vendoring check (#575, @kaworu)
* cmd/observe: move flows specific code to flows*.go files (#578, @tklauser)
* cmd/observe: remove depreacted formatting flags (json, compact, dict) (#603, @rolinh)
* cmd/observe: rename flow-related functions, types and import aliases (#574, @tklauser)
* CODEOWNERS: assign Go module vendoring to @cilium/vendor (#580, @tklauser)
* docker: add note about bogus busybox's nslookup implementation (#587, @rolinh)
* Fix broken link (#593, @sharjeelaziz)
* git commands in the Makefile return the empty string if they fail. (#589, @zhiyanfoo)
* github: Add "Image Release Build" workflow (#627, @gandro)
* Log a debug message when reading from stdin (#598, @michi-covalent)
* Makefile: Introduce GO_BUILD variable (#560, @gandro)
* pkg/printer: disable color output in tests (#562, @tklauser)
* Prepare for 0.9 development cycle (#545, @gandro)
* readme: clarify that only the latest version is maintained/supported (#568, @rolinh)
* RELEASE.md: document Homebrew formular update as optional step (#624, @tklauser)
* RELEASE.md: fix brew command formatting (#630, @tklauser)
* release: pin skx/github-action-publish-binaries to a specific sha (#546, @rolinh)
* Small test cleanups (#571, @tklauser)
* Update doc and stable.txt for v0.8.2 release (#623, @rolinh)
* Update Go to 1.16.4 (#548, @tklauser)
* Update Go to 1.16.5 (#564, @tklauser)
* Update Go to 1.16.7 (#604, @tklauser)
* Update Go to 1.17 (#612, @tklauser)
* Update Go to 1.17.2 (#635, @tklauser)
* update Go to v1.16.6, alpine to 3.14 (#585, @rolinh)
* update Go to v1.17.1 (#620, @rolinh)
* Update Go to v1.17.3, golangci-lint to v1.43.0 (#646, @rolinh)
* Update readme, changelog and stable.txt for v0.8.1 release (#595, @rolinh)
* Use golangci-lint for static checks (#559, @rolinh)
* vendor: bump github.com/cilium/cilium to latest master (#556, @tklauser)
* vendor: Bump github.com/cilium/cilium to v1.11.0-rc3 (#650, @gandro)
* vendor: bump grpc to v1.37.1; honnef tools to v0.1.4 (#552, @rolinh)
* vendor: bump viper to v1.8.0 and grpc to v1.38.0 (#572, @rolinh)
* version: Drop the "v" prefix (#638, @michi-covalent)

## [v0.8.2] - 2021-09-10

This patch release fixes a bug in the dict output where a newline was missing.
It also removes long-deprecated `--json`, `--compact` and `--dict` flags (use
the `--output` flag instead) that actually turned out to be broken at this
point. A very visible addition is color support, a change that was backported
from the `master` branch upon popular request.
In addition, the Go version, which is used to create release binaries, is
updated to the latest v1.16.8 and the Cilium dependency is updated to v1.10.4.

**Minor Changes:**
* Backport color output to v0.8 branch (#609, @michi-covalent)

**Bugfixes:**
* v0.8: printer: fix dict outout newline (#617, @rolinh)

**Misc Changes:**
* [v0.8] go.mod, vendor: bump cilium to v1.10.4 (#619, @tklauser)
* v0.8: cmd/observe: remove depreacted formatting flags (json, compact, dict) (#606, @rolinh)
* v0.8: Update Go to 1.16.7 (#605, @tklauser)
* v0.8: update Go to v1.16.8, Alpine base image to 3.14.2 (#621, @rolinh)

## [v0.8.1] - 2021-07-19

This patch release updates gRPC and Cilium dependencies to v1.37.1 and v1.10.3
respectively. The Go version, which is used to create release binaries, is also
updated to the latest v1.16.6. A minor, mostly cosmetic, bug is also fixed
which allows building Hubble without any warning being displayed when the `.git`
directory is not present.

**Misc Changes:**

* v0.8: bump cilium to v1.10.2, Go to v1.16.6 (#586, @rolinh)
* v0.8: release: pin skx/github-action-publish-binaries to a specific sha (#547, @rolinh)
* v0.8: update cilium to v1.10.3, backport git version fix (#591, @rolinh)
* v0.8: Update Go to 1.16.4 (#549, @tklauser)
* v0.8: Update Go to 1.16.5 (#565, @tklauser)
* v0.8: vendor: bump github.com/cilium/cilium to v1.10.0 (#557, @tklauser)
* v0.8: vendor: bump grpc to v1.37.1; honnef tools to v0.1.4 (#553, @rolinh)

## [v0.8.0] - 2021-05-03

This release coincides with Cilium 1.10 and has support for new API additions
added in Cilium. Some of the new API features include support for agent and
debug events (#537), as well as prelimary support for the experimental Hubble
Recorder API (#530). Both of these features are currenlty only available via
the local unix domain socket. Other API features include filtering by TCP flags
(#461), IP version (#505) and node name (#412).

Hubble CLI 0.8 also comes with improvements to the CLI utility, such as reading
flows and filtering flows from stdin (#524), more flexible timestamp format
printing (#509), support for Apple silicon (#488), as well as miscellaneous
flag improvements and additions (#411, #420, #421, #443). It also contains a
new `hubble list` subcommand which, when targeting Hubble Relay, lists all
Hubble enabled nodes (#427).

*Breaking Changes*

In accordance with semver 0.x releases, this release contains a few
breaking changes to the Hubble command-line interface:

* The new default Hubble API endpoint (specified with `--server`) is now
  `localhost:4245` to ease usage with Hubble Relay. To connect to the local
  unix domain socket, use `--server unix:///var/run/cilium/hubble.sock` or set
  the `HUBBLE_SERVER` environment variable (default within a Cilium container)
  (#535)
* The new default output format is now always `compact` regardless of being in
  follow-mode or not. To obtain the old table output in the `hubble observe`
  command, use `--output=table` (#536)
* The source of reply packets is now printed on the left side in the compact
  output format. Such flows are indicated with a `<-` arrow instead of `->`.
  Flows with an unknown direction now use the `<>` arrow in the compact output
  (#533).
* The hidden `hubble peers watch` command has been renamed to `hubble watch
  peers` (#542)

**Major Changes:**
* Add basic support for agent events (#442, @tklauser)
* Add subcommands for agent and debug events (#537, @tklauser)
* cmd/observe: support for filtering events based on tcp-flags (#461, @nyrahul)
* cmd: add node list subcommand to list hubble nodes with status (#427, @rolinh)

**Minor Changes:**
* change default address to localhost:4245 (#535, @rolinh)
* cmd/config: add shell completion support for keys for get|set|reset (#420, @rolinh)
* cmd/observe: add a new flag to allow specifying different time formats for timestamps (#509, @rolinh)
* cmd/observe: add all flags (#411, @rolinh)
* cmd/observe: Add node name filter (#412, @twpayne)
* cmd/observe: add shell completion support for various flags (#421, @rolinh)
* cmd/observe: add support for IP version filters (#505, @rolinh)
* cmd/observe: mark deprecated output flags as deprecated (#506, @rolinh)
* cmd/observer: add support for agent event sub-type filters (#465, @tklauser)
* cmd: Add record subcommand (#530, @gandro)
* cmd: improve command usage message by grouping related flags (#443, @rolinh)
* compact: Always print original source on the left (#533, @michi-covalent)
* make: build release binaries for darwin/arm64 (aka Apple silicon) (#488, @rolinh)
* printer: Add support for debug events (#473, @gandro)
* RFC: cmd/observe: set default output format to "compact" (#536, @rolinh)
* Support reading flows from stdin (#524, @michi-covalent)

**Bugfixes:**
* cmd: fix environment variable names for options with dashes (#407, @rolinh)

**Misc Changes:**
* Agent event follow-up fixes for #442 (#454, @tklauser)
* all: avoid using the deprecated io/ioutil package (#489, @rolinh)
* Automate release creation and artifacts publishing (#490, @rolinh)
* build(deps): bump actions/setup-go from v1 to v2.1.3 (#476, @dependabot[bot])
* build(deps): bump github.com/sirupsen/logrus from 1.7.0 to 1.8.1 (#525, @dependabot[bot])
* build(deps): bump github.com/spf13/cobra from 1.1.2 to 1.1.3 (#486, @dependabot[bot])
* build(deps): bump google.golang.org/grpc from 1.36.0 to 1.36.1 (#522, @dependabot[bot])
* build(deps): bump google.golang.org/protobuf from 1.25.0 to 1.26.0 (#518, @dependabot[bot])
* build: ensure that binaries are always statically built (#397, @rolinh)
* Bump alpine base image to 3.13 (#472, @tklauser)
* Bump github.com/cilium/cilium to pull in reworked agent/debug event API (#532, @tklauser)
* ci: Add CodeQL analysis (#475, @twpayne)
* ci: Add dependabot configuration (#474, @twpayne)
* ci: do not upload artifacts (#485, @rolinh)
* ci: fix dependabot kind/enhancement label (#477, @kaworu)
* cmd/node: fix completion of output flag (#466, @rolinh)
* cmd/node: Refactor & Test output methods (#496, @simar7)
* cmd/observe: don't list agent/debug events and recorder captures in event type filter (#534, @tklauser)
* cmd/observe: print filters in debug mode (#502, @rolinh)
* cmd/observe: Print the entire request in debug mode (#515, @michi-covalent)
* cmd/observe: use signal.NotifyContext to cancel context on SIGINT (#539, @rolinh)
* cmd/peer: Refactor and test processing of response (#499, @simar7)
* cmd: change "node list" command for "list node" (#541, @rolinh)
* cmd: change 'peers watch' command to 'watch peers' (#542, @rolinh)
* cmd: use config key constants instead of hardcoded strings (#471, @rolinh)
* completion: remove the copyright header (#444, @kaworu)
* doc: #hubble-devel on Slack is now #sig-hubble (#495, @rolinh)
* doc: fix broken links (#406, @rolinh)
* Dockerfile: use alpine 3.12 (#540, @aanm)
* docs: Point to stable documentation (#414, @joestringer)
* Ensure build with Cilium master (#463, @gandro)
* Fix brokenlink on README.md (#500, @kaitoii11)
* make: set missing IMAGE_TAG variable (#432, @rolinh)
* Makefile: Add support for DOCKER_FLAGS environment variable (#456, @jrajahalme)
* Move version into VERSION file (#434, @glibsm)
* readme: bump versions in releases table (#400, @rolinh)
* readme: update releases table, mark Hubble Relay as stable (#404, @rolinh)
* release: fix `release` binary usage instruction (#396, @rolinh)
* Revert "ci: fix dependabot kind/enhancement label" (#493, @kaworu)
* set version to 0.8.0-dev (#393, @rolinh)
* stable.txt: Bump to v0.7.0 (#405, @gandro)
* Switch protobuf module to google.golang.org/protobuf (#452, @tklauser)
* update CHANGELOG for releases v0.6.1 and v0.7.0 (#398, @rolinh)
* Update Go to 1.15.4 (#416, @rolinh)
* Update Go to 1.15.5 (#423, @tklauser)
* Update Go to 1.15.6 (#446, @tklauser)
* Update Go to 1.15.7 (#467, @tklauser)
* Update Go to 1.15.8 (#478, @tklauser)
* Update Go to 1.16.1 (#507, @tklauser)
* Update Go to 1.16.2 (#510, @rolinh)
* Update Go to 1.16.3 (#526, @tklauser)
* update Go to v1.16.0 (#487, @rolinh)
* update readme and stable.txt for v0.7.1 (#410, @rolinh)
* update release instructions (#399, @rolinh)
* Update RELEASE.md with `-dev` change (#520, @rolinh)
* vendor: bump Cilium and grpc (#538, @rolinh)
* vendor: bump github.com/cilium/cilium (#482, @rolinh)
* vendor: bump github.com/cilium/cilium (#528, @rolinh)
* vendor: bump github.com/google/go-cmp from 0.5.4 to 0.5.5 (#504, @rolinh)
* vendor: bump google.golang.org to v1.33.2 (#437, @tklauser)
* vendor: bump google.golang.org/grpc to v1.34.0 (#457, @tklauser)
* vendor: bump google.golang.org/grpc to v1.35.0 (#464, @tklauser)
* vendor: bump google.golang.org/grpc to v1.36.0 (#498, @rolinh)
* vendor: Bump gopkg.in/yaml.v2 to v2.4.0 (#441, @twpayne)
* vendor: bump honnef.co/go/tools from v0.1.1 to v0.1.2 (#494, @rolinh)
* vendor: bump honnef.co/go/tools from v0.1.2 to v0.1.3 (#513, @rolinh)
* vendor: bump honnef.co/go/tools to v0.1.1 (#484, @rolinh)

## [0.7.1] - 2020-10-22

**Bugfixes:**
* cmd: fix environment variable names for options with dashes (#408, @Rolinh)

**Misc Changes:**
* build: ensure that binaries are always statically built (#402, @Rolinh)

## [0.7.0] - 2020-10-19

**Minor Changes:**
* Add config subcommand (#380, @Rolinh)
* Add reflect command (#378, @michi-covalent)
* cmd/observe: Add HTTP method and path filters (#371, @twpayne)
* cmd/peer: print tls.ServerName when available (#374, @Rolinh)
* cmd/status: Add flows per second to `hubble status` (#330, @gandro)
* cmd/status: print node availability information when available (#328, @Rolinh)
* cmd/status: report current/max flows on the same line (#346, @Rolinh)
* cmd: add support for fish and powershell completion (#316, @Rolinh)
* cmd: add support for TLS and mTLS (#372, @Rolinh)
* cmd: honor user configuration directory for the configuration file (#375, @Rolinh)
* cmd: remove globals, optimize grpc client conn creation, remove pprof (#369, @Rolinh)
* Dockerfile: Remove ENTRYPOINT (#355, @michi-covalent)
* printer: ommit node name from output (#358, @mdnix)
* Update Go to v1.15, drop support for darwin/386, add support for linux/[arm,arm64] (#343, @Rolinh)

**Bugfixes:**
* cmd/status: do not report flows ratio when max flows is zero (#345, @Rolinh)
* make: fix git hash variable assignments for old make versions (#290, @Rolinh)

**Misc Changes:**
* .gitattributes: hide go.sum and vendor/modules.txt in pull requests (#317, @Rolinh)
* actions: add go-mod check (#382, @Rolinh)
* Add staticcheck to `make check` (#344, @tklauser)
* Clarify wording in README (#341, @christarazi)
* cmd/config: only write provided key/value when using set subcommand (#385, @Rolinh)
* cmd: fix help message for the `-config` flag (#377, @Rolinh)
* cmd: update observe and status command description/formatting (#390, @Rolinh)
* defaults: avoid stutter in exported names (#383, @tklauser)
* docs: Add link to Cilium Development Guide (#376, @twpayne)
* Fixes SC2038 in check-fmt.sh (#360, @nebril)
* make: fix release build directory ownership (#321, @kAworu)
* make: vendor in ineffassign, staticcheck, and golint (#357, @kAworu)
* observe: Document default flow count output (#318, @joestringer)
* printer: avoid duplicate import (#342, @tklauser)
* printer: use fmt.Fprintln instead of fmt.Fprintf (#347, @tklauser)
* README: fix broken link to metrics documentation (#327, @Rolinh)
* Readme: remove old beta warning and make a components table (#322, @glibsm)
* README: Update links (#351, @pchaigno)
* Remove version from release artifact file names (#293, @michi-covalent)
* tutorials: Fix README.md (#340, @jrajahalme)
* Update Cilium dep and fix unit tests that subsequently broke (#335, @Rolinh)
* Update Go to 1.15.3 (#386, @tklauser)
* update Go version to v1.14.7 (#336, @Rolinh)
* update Go version to v1.15.2 (#365, @Rolinh)
* v0.7: vendor: bump cilium to v1.9.0-rc2 to track cilium v1.9 branch (#394, @Rolinh)
* vendor: bump cilium to master right before branching v1.9 (#392, @Rolinh)
* vendor: bump cobra to v1.1.1 (#391, @twpayne)
* vendor: bump dependencies (#389, @Rolinh)
* vendor: go mod tidy && go mod vendor && go mod verify (#381, @Rolinh)
* vendor: update cilium@latest, viper@v1.7.1 (#373, @Rolinh)

**Other Changes:**
* Add little helper actions (#326, @glibsm)
* Add RELEASE.md with release checklist (#281, @glibsm)
* Add stable.txt (#299, @michi-covalent)
* add v0.6.0 release notes to changelog and bump version to 0.7.0-dev (#275, @Rolinh)
* Build release artifacts inside a container (#295, @michi-covalent)
* docs: Re-add images linked in README (#309, @gandro)
* Fix v0.6 branch link in README (#306, @gandro)
* Generate release binaries (#285, @Rolinh)
* Prepare for Cilium 1.8 (#305, @gandro)
* printer: Add jsonpb output (#302, @michi-covalent)
* Remove contrib/scripts/release.sh (#297, @michi-covalent)
* Require Cilium 1.7.x (#283, @tgraf)
* Update Go to v1.14.6 (#320, @Rolinh)
* update Go version to v1.14.4 and alpine base image to v3.12 (#278, @Rolinh)
* update Go version to v1.14.5 (#319, @Rolinh)
* vendor: cilium@master (#313, @glibsm)

## [0.6.1] - 2020-06-12

**Bugfixes:**
* make: fix git hash variable assignments for old make versions (#291, @michi-covalent)

**Misc Changes:**
* update Go version to v1.14.4 and alpine base image to v3.12 (#280, @Rolinh)

**Other Changes:**
* Backport https://github.com/cilium/hubble/pull/285 (#286, @michi-covalent)
* Prepare v0.6.1 release (#289, @michi-covalent)
* Require Cilium 1.7.x (#287, @michi-covalent)

## [0.6.0] - 2020-05-29

**Bugfixes:**
* api: fix potential panic in endpoint's EqualsByID (#199, @Rolinh)

**Misc Changes:**
* cmd: add hidden 'peer' command (#248, @Rolinh)
* update Go version to v1.14.2 (#226, @Rolinh)
* update Go version to v1.14.3 (#258, @Rolinh)

**Other Changes:**
* actions: Trigger on release branches (#233, @michi-covalent)
* Add changelog (#203, @glibsm)
* add peer gRPC service (#212, @Rolinh)
* Add support for policy verdict events (#200, @gandro)
* adjust dockerfile and makefile for "serve" command removal (#263, @Rolinh)
* Adjust to moved PolicyMatchType location (#222, @tgraf)
* api: Small fixes to the protoc invocations in Makefile (#206, @gandro)
* Bring back HUBBLE_DEFAULT_SOCKET_PATH env var (#239, @gandro)
* cmd/observe: use flags.DurationVar instead of StringVar for timeout flag (#210, @Rolinh)
* cmd/serve: refactor, introduce Server struct and options (#208, @Rolinh)
* cmd: Export RootCmd (#237, @glibsm)
* cmd: Finish config move (#254, @glibsm)
* cmd: Make all sub-commands more prominent (#255, @glibsm)
* cmd: Make pprof optional (#269, @gandro)
* cmd: Move completion and profile code from root (#246, @glibsm)
* defaults: Introduce new defaults for embedded Hubble (#224, @gandro)
* doc: Add a Quickstart section to the documentation (#243, @michi-covalent)
* doc: Update DNS visibility policy (#259, @michi-covalent)
* docker: ensure the hubble binary is statically built (#272, @Rolinh)
* fix: add skipped quote in hubble-all-minikube.yaml (#225, @geakstr)
* helm: Update hubble cli options (#245, @michi-covalent)
* l7: Add "Error" verdict (#211, @michi-covalent)
* make: optimize binary size by omitting symbol table and debug info (#268, @Rolinh)
* observe: Disable port-translation by default (#236, @michi-covalent)
* observe: Remove --port-translation (#271, @michi-covalent)
* observe: Show all the event types by default (#241, @michi-covalent)
* OnBuildFilter (#209, @tgraf)
* printer: Add support for NodeStatusEvent (#260, @gandro)
* printer: Fall back on ethernet MAC addresses (#261, @gandro)
* printer: Use policy verdict match type formatter from Cilium (#205, @gandro)
* Rebase vendored github.com/cilium (#232, @tgraf)
* Remove all server-side code (#220, @tgraf)
* Remove logger package (#221, @tgraf)
* server: Introduce per-request context (#216, @gandro)
* server: Match time range before filters (#213, @tgraf)
* Set version to 0.6.0-dev (#202, @glibsm)
* vendor: Bump github.com/cilium/cilium (#223, @gandro)
* vendor: pick up latest cilium (#247, @Rolinh)
* vendor: update cilium and sync replace directives (#207, @Rolinh)

## [0.5.0] - 2020-03-23
