-- autogenerated from https://www.unicode.org/Public/14.0.0/ucd/UnicodeData.txt
-- |
-- Module      : Unicode.Internal.Char.UnicodeData.GeneralCategory
-- Copyright   : (c) 2020 Composewell Technologies and Contributors
-- License     : Apache-2.0
-- Maintainer  : streamly@composewell.com
-- Stability   : experimental

module Unicode.Internal.Char.UnicodeData.GeneralCategory
(generalCategory)
where

import Data.Char (ord)
import Unicode.Internal.Bits (lookupIntN)

{-# INLINE generalCategory #-}
generalCategory :: Char -> Int
generalCategory c = let n = ord c in if n >= 1114110 then 29 else lookupIntN bitmap# n
  where
    bitmap# = "\EM\EM\EM\EM\EM\EM\EM\EM\EM\EM\EM\EM\EM\EM\EM\EM\EM\EM\EM\EM\EM\EM\EM\EM\EM\EM\EM\EM\EM\EM\EM\EM\SYN\DC1\DC1\DC1\DC3\DC1\DC1\DC1\r\SO\DC1\DC2\DC1\f\DC1\DC1\b\b\b\b\b\b\b\b\b\b\DC1\DC1\DC2\DC2\DC2\DC1\DC1\NUL\NUL\NUL\NUL\NUL\NUL\NUL\NUL\NUL\NUL\NUL\NUL\NUL\NUL\NUL\NUL\NUL\NUL\NUL\NUL\NUL\NUL\NUL\NUL\NUL\NUL\r\DC1\SO\DC4\v\DC4\SOH\SOH\SOH\SOH\SOH\SOH\SOH\SOH\SOH\SOH\SOH\SOH\SOH\SOH\SOH\SOH\SOH\SOH\SOH\SOH\SOH\SOH\SOH\SOH\SOH\SOH\r\DC2\SO\DC2\EM\EM\EM\EM\EM\EM\EM\EM\EM\EM\EM\EM\EM\EM\EM\EM\EM\EM\EM\EM\EM\EM\EM\EM\EM\EM\EM\EM\EM\EM\EM\EM\EM\SYN\DC1\DC3\DC3\DC3\DC3\NAK\DC1\DC4\NAK\EOT\SI\DC2\SUB\NAK\DC4\NAK\DC2\n\n\DC4\SOH\DC1\DC1\DC4\n\EOT\DLE\n\n\n\DC1\NUL\NUL\NUL\NUL\NUL\NUL\NUL\NUL\NUL\NUL\NUL\NUL\NUL\NUL\NUL\NUL\NUL\NUL\NUL\NUL\NUL\NUL\NUL\DC2\NUL\NUL\NUL\NUL\NUL\NUL\NUL\SOH\SOH\SOH\SOH\SOH\SOH\SOH\SOH\SOH\SOH\SOH\SOH\SOH\SOH\SOH\SOH\SOH\SOH\SOH\SOH\SOH\SOH\SOH\SOH\DC2\SOH\SOH\SOH\SOH\SOH\SOH\SOH\SOH\NUL\SOH\NUL\SOH\NUL\SOH\NUL\SOH\NUL\SOH\NUL\SOH\NUL\SOH\NUL\SOH\NUL\SOH\NUL\SOH\NUL\SOH\NUL\SOH\NUL\SOH\NUL\SOH\NUL\SOH\NUL\SOH\NUL\SOH\NUL\SOH\NUL\SOH\NUL\SOH\NUL\SOH\NUL\SOH\NUL\SOH\NUL\SOH\NUL\SOH\NUL\SOH\NUL\SOH\NUL\SOH\SOH\NUL\SOH\NUL\SOH\NUL\SOH\NUL\SOH\NUL\SOH\NUL\SOH\NUL\SOH\NUL\SOH\SOH\NUL\SOH\NUL\SOH\NUL\SOH\NUL\SOH\NUL\SOH\NUL\SOH\NUL\SOH\NUL\SOH\NUL\SOH\NUL\SOH\NUL\SOH\NUL\SOH\NUL\SOH\NUL\SOH\NUL\SOH\NUL\SOH\NUL\SOH\NUL\SOH\NUL\SOH\NUL\SOH\NUL\SOH\NUL\SOH\NUL\SOH\NUL\NUL\SOH\NUL\SOH\NUL\SOH\SOH\SOH\NUL\NUL\SOH\NUL\SOH\NUL\NUL\SOH\NUL\NUL\NUL\SOH\SOH\NUL\NUL\NUL\NUL\SOH\NUL\NUL\SOH\NUL\NUL\NUL\SOH\SOH\SOH\NUL\NUL\SOH\NUL\NUL\SOH\NUL\SOH\NUL\SOH\NUL\NUL\SOH\NUL\SOH\SOH\NUL\SOH\NUL\NUL\SOH\NUL\NUL\NUL\SOH\NUL\SOH\NUL\NUL\SOH\SOH\EOT\NUL\SOH\SOH\SOH\EOT\EOT\EOT\EOT\NUL\STX\SOH\NUL\STX\SOH\NUL\STX\SOH\NUL\SOH\NUL\SOH\NUL\SOH\NUL\SOH\NUL\SOH\NUL\SOH\NUL\SOH\NUL\SOH\SOH\NUL\SOH\NUL\SOH\NUL\SOH\NUL\SOH\NUL\SOH\NUL\SOH\NUL\SOH\NUL\SOH\NUL\SOH\SOH\NUL\STX\SOH\NUL\SOH\NUL\NUL\NUL\SOH\NUL\SOH\NUL\SOH\NUL\SOH\NUL\SOH\NUL\SOH\NUL\SOH\NUL\SOH\NUL\SOH\NUL\SOH\NUL\SOH\NUL\SOH\NUL\SOH\NUL\SOH\NUL\SOH\NUL\SOH\NUL\SOH\NUL\SOH\NUL\SOH\NUL\SOH\NUL\SOH\NUL\SOH\NUL\SOH\NUL\SOH\NUL\SOH\NUL\SOH\NUL\SOH\NUL\SOH\NUL\SOH\NUL\SOH\SOH\SOH\SOH\SOH\SOH\SOH\NUL\NUL\SOH\NUL\NUL\SOH\SOH\NUL\SOH\NUL\NUL\NUL\NUL\SOH\NUL\SOH\NUL\SOH\NUL\SOH\NUL\SOH\SOH\SOH\SOH\SOH\SOH\SOH\SOH\SOH\SOH\SOH\SOH\SOH\SOH\SOH\SOH\SOH\SOH\SOH\SOH\SOH\SOH\SOH\SOH\SOH\SOH\SOH\SOH\SOH\SOH\SOH\SOH\SOH\SOH\SOH\SOH\SOH\SOH\SOH\SOH\SOH\SOH\SOH\SOH\SOH\SOH\SOH\SOH\SOH\SOH\SOH\SOH\SOH\SOH\SOH\SOH\SOH\SOH\SOH\SOH\SOH\SOH\SOH\SOH\SOH\SOH\SOH\SOH\SOH\EOT\SOH\SOH\SOH\SOH\SOH\SOH\SOH\SOH\SOH\SOH\SOH\SOH\SOH\SOH\SOH\SOH\SOH\SOH\SOH\SOH\SOH\SOH\SOH\SOH\SOH\SOH\SOH\ETX\ETX\ETX\ETX\ETX\ETX\ETX\ETX\ETX\ETX\ETX\ETX\ETX\ETX\ETX\ETX\ETX\ETX\DC4\DC4\DC4\DC4\ETX\ETX\ETX\ETX\ETX\ETX\ETX\ETX\ETX\ETX\ETX\ETX\DC4\DC4\DC4\DC4\DC4\DC4\DC4\DC4\DC4\DC4\DC4\DC4\DC4\DC4\ETX\ETX\ETX\ETX\ETX\DC4\DC4\DC4\DC4\DC4\DC4\DC4\ETX\DC4\ETX\DC4\DC4\DC4\DC4\DC4\DC4\DC4\DC4\DC4\DC4\DC4\DC4\DC4\DC4\DC4\DC4\DC4\ENQ\ENQ\ENQ\ENQ\ENQ\ENQ\ENQ\ENQ\ENQ\ENQ\ENQ\ENQ\ENQ\ENQ\ENQ\ENQ\ENQ\ENQ\ENQ\ENQ\ENQ\ENQ\ENQ\ENQ\ENQ\ENQ\ENQ\ENQ\ENQ\ENQ\ENQ\ENQ\ENQ\ENQ\ENQ\ENQ\ENQ\ENQ\ENQ\ENQ\ENQ\ENQ\ENQ\ENQ\ENQ\ENQ\ENQ\ENQ\ENQ\ENQ\ENQ\ENQ\ENQ\ENQ\ENQ\ENQ\ENQ\ENQ\ENQ\ENQ\ENQ\ENQ\ENQ\ENQ\ENQ\ENQ\ENQ\ENQ\ENQ\ENQ\ENQ\ENQ\ENQ\ENQ\ENQ\ENQ\ENQ\ENQ\ENQ\ENQ\ENQ\ENQ\ENQ\ENQ\ENQ\ENQ\ENQ\ENQ\ENQ\ENQ\ENQ\ENQ\ENQ\ENQ\ENQ\ENQ\ENQ\ENQ\ENQ\ENQ\ENQ\ENQ\ENQ\ENQ\ENQ\ENQ\ENQ\ENQ\ENQ\ENQ\ENQ\ENQ\NUL\SOH\NUL\SOH\ETX\DC4\NUL\SOH\GS\GS\ETX\SOH\SOH\SOH\DC1\NUL\GS\GS\GS\GS\DC4\DC4\NUL\DC1\NUL\NUL\NUL\GS\NUL\GS\NUL\NUL\SOH\NUL\NUL\NUL\NUL\NUL\NUL\NUL\NUL\NUL\NUL\NUL\NUL\NUL\NUL\NUL\NUL\NUL\GS\NUL\NUL\NUL\NUL\NUL\NUL\NUL\NUL\NUL\SOH\SOH\SOH\SOH\SOH\SOH\SOH\SOH\SOH\SOH\SOH\SOH\SOH\SOH\SOH\SOH\SOH\SOH\SOH\SOH\SOH\SOH\SOH\SOH\SOH\SOH\SOH\SOH\SOH\SOH\SOH\SOH\SOH\SOH\SOH\NUL\SOH\SOH\NUL\NUL\NUL\SOH\SOH\SOH\NUL\SOH\NUL\SOH\NUL\SOH\NUL\SOH\NUL\SOH\NUL\SOH\NUL\SOH\NUL\SOH\NUL\SOH\NUL\SOH\NUL\SOH\NUL\SOH\SOH\SOH\SOH\SOH\NUL\SOH\DC2\NUL\SOH\NUL\NUL\SOH\SOH\NUL\NUL\NUL\NUL\NUL\NUL\NUL\NUL\NUL\NUL\NUL\NUL\NUL\NUL\NUL\NUL\NUL\NUL\NUL\NUL\NUL\NUL\NUL\NUL\NUL\NUL\NUL\NUL\NUL\NUL\NUL\NUL\NUL\NUL\NUL\NUL\NUL\NUL\NUL\NUL\NUL\NUL\NUL\NUL\NUL\NUL\NUL\NUL\NUL\NUL\NUL\SOH\SOH\SOH\SOH\SOH\SOH\SOH\SOH\SOH\SOH\SOH\SOH\SOH\SOH\SOH\SOH\SOH\SOH\SOH\SOH\SOH\SOH\SOH\SOH\SOH\SOH\SOH\SOH\SOH\SOH\SOH\SOH\SOH\SOH\SOH\SOH\SOH\SOH\SOH\SOH\SOH\SOH\SOH\SOH\SOH\SOH\SOH\SOH\NUL\SOH\NUL\SOH\NUL\SOH\NUL\SOH\NUL\SOH\NUL\SOH\NUL\SOH\NUL\SOH\NUL\SOH\NUL\SOH\NUL\SOH\NUL\SOH\NUL\SOH\NUL\SOH\NUL\SOH\NUL\SOH\NUL\SOH\NAK\ENQ\ENQ\ENQ\ENQ\ENQ\a\a\NUL\SOH\NUL\SOH\NUL\SOH\NUL\SOH\NUL\SOH\NUL\SOH\NUL\SOH\NUL\SOH\NUL\SOH\NUL\SOH\NUL\SOH\NUL\SOH\NUL\SOH\NUL\SOH\NUL\SOH\NUL\SOH\NUL\SOH\NUL\SOH\NUL\SOH\NUL\SOH\NUL\SOH\NUL\SOH\NUL\SOH\NUL\SOH\NUL\SOH\NUL\SOH\NUL\SOH\NUL\NUL\SOH\NUL\SOH\NUL\SOH\NUL\SOH\NUL\SOH\NUL\SOH\NUL\SOH\SOH\NUL\SOH\NUL\SOH\NUL\SOH\NUL\SOH\NUL\SOH\NUL\SOH\NUL\SOH\NUL\SOH\NUL\SOH\NUL\SOH\NUL\SOH\NUL\SOH\NUL\SOH\NUL\SOH\NUL\SOH\NUL\SOH\NUL\SOH\NUL\SOH\NUL\SOH\NUL\SOH\NUL\SOH\NUL\SOH\NUL\SOH\NUL\SOH\NUL\SOH\NUL\SOH\NUL\SOH\NUL\SOH\NUL\SOH\NUL\SOH\NUL\SOH\NUL\SOH\NUL\SOH\NUL\SOH\NUL\SOH\NUL\SOH\NUL\SOH\NUL\SOH\NUL\SOH\NUL\SOH\NUL\SOH\NUL\SOH\NUL\SOH\NUL\SOH\NUL\SOH\NUL\SOH\NUL\SOH\NUL\SOH\GS\NUL\NUL\NUL\NUL\NUL\NUL\NUL\NUL\NUL\NUL\NUL\NUL\NUL\NUL\NUL\NUL\NUL\NUL\NUL\NUL\NUL\NUL\NUL\NUL\NUL\NUL\NUL\NUL\NUL\NUL\NUL\NUL\NUL\NUL\NUL\NUL\NUL\NUL\GS\GS\ETX\DC1\DC1\DC1\DC1\DC1\DC1\SOH\SOH\SOH\SOH\SOH\SOH\SOH\SOH\SOH\SOH\SOH\SOH\SOH\SOH\SOH\SOH\SOH\SOH\SOH\SOH\SOH\SOH\SOH\SOH\SOH\SOH\SOH\SOH\SOH\SOH\SOH\SOH\SOH\SOH\SOH\SOH\SOH\SOH\SOH\SOH\SOH\DC1\f\GS\GS\NAK\NAK\DC3\GS\ENQ\ENQ\ENQ\ENQ\ENQ\ENQ\ENQ\ENQ\ENQ\ENQ\ENQ\ENQ\ENQ\ENQ\ENQ\ENQ\ENQ\ENQ\ENQ\ENQ\ENQ\ENQ\ENQ\ENQ\ENQ\ENQ\ENQ\ENQ\ENQ\ENQ\ENQ\ENQ\ENQ\ENQ\ENQ\ENQ\ENQ\ENQ\ENQ\ENQ\ENQ\ENQ\ENQ\ENQ\ENQ\f\ENQ\DC1\ENQ\ENQ\DC1\ENQ\ENQ\DC1\ENQ\GS\GS\GS\GS\GS\GS\GS\GS\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\GS\GS\GS\GS\EOT\EOT\EOT\EOT\DC1\DC1\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\SUB\SUB\SUB\SUB\SUB\SUB\DC2\DC2\DC2\DC1\DC1\DC3\DC1\DC1\NAK\NAK\ENQ\ENQ\ENQ\ENQ\ENQ\ENQ\ENQ\ENQ\ENQ\ENQ\ENQ\DC1\SUB\DC1\DC1\DC1\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\ETX\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\ENQ\ENQ\ENQ\ENQ\ENQ\ENQ\ENQ\ENQ\ENQ\ENQ\ENQ\ENQ\ENQ\ENQ\ENQ\ENQ\ENQ\ENQ\ENQ\ENQ\ENQ\b\b\b\b\b\b\b\b\b\b\DC1\DC1\DC1\DC1\EOT\EOT\ENQ\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\DC1\EOT\ENQ\ENQ\ENQ\ENQ\ENQ\ENQ\ENQ\SUB\NAK\ENQ\ENQ\ENQ\ENQ\ENQ\ENQ\ETX\ETX\ENQ\ENQ\NAK\ENQ\ENQ\ENQ\ENQ\EOT\EOT\b\b\b\b\b\b\b\b\b\b\EOT\EOT\EOT\NAK\NAK\EOT\DC1\DC1\DC1\DC1\DC1\DC1\DC1\DC1\DC1\DC1\DC1\DC1\DC1\DC1\GS\SUB\EOT\ENQ\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\ENQ\ENQ\ENQ\ENQ\ENQ\ENQ\ENQ\ENQ\ENQ\ENQ\ENQ\ENQ\ENQ\ENQ\ENQ\ENQ\ENQ\ENQ\ENQ\ENQ\ENQ\ENQ\ENQ\ENQ\ENQ\ENQ\ENQ\GS\GS\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\ENQ\ENQ\ENQ\ENQ\ENQ\ENQ\ENQ\ENQ\ENQ\ENQ\ENQ\EOT\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\b\b\b\b\b\b\b\b\b\b\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\ENQ\ENQ\ENQ\ENQ\ENQ\ENQ\ENQ\ENQ\ENQ\ETX\ETX\NAK\DC1\DC1\DC1\ETX\GS\GS\ENQ\DC3\DC3\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\ENQ\ENQ\ENQ\ENQ\ETX\ENQ\ENQ\ENQ\ENQ\ENQ\ENQ\ENQ\ENQ\ENQ\ETX\ENQ\ENQ\ENQ\ETX\ENQ\ENQ\ENQ\ENQ\ENQ\GS\GS\DC1\DC1\DC1\DC1\DC1\DC1\DC1\DC1\DC1\DC1\DC1\DC1\DC1\DC1\DC1\GS\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\ENQ\ENQ\ENQ\GS\GS\DC1\GS\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\GS\GS\GS\GS\GS\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\DC4\EOT\EOT\EOT\EOT\EOT\EOT\GS\SUB\SUB\GS\GS\GS\GS\GS\GS\ENQ\ENQ\ENQ\ENQ\ENQ\ENQ\ENQ\ENQ\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\ETX\ENQ\ENQ\ENQ\ENQ\ENQ\ENQ\ENQ\ENQ\ENQ\ENQ\ENQ\ENQ\ENQ\ENQ\ENQ\ENQ\ENQ\ENQ\ENQ\ENQ\ENQ\ENQ\ENQ\ENQ\SUB\ENQ\ENQ\ENQ\ENQ\ENQ\ENQ\ENQ\ENQ\ENQ\ENQ\ENQ\ENQ\ENQ\ENQ\ENQ\ENQ\ENQ\ENQ\ENQ\ENQ\ENQ\ENQ\ENQ\ENQ\ENQ\ENQ\ENQ\ENQ\ENQ\ENQ\ENQ\ENQ\ACK\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\ENQ\ACK\ENQ\EOT\ACK\ACK\ACK\ENQ\ENQ\ENQ\ENQ\ENQ\ENQ\ENQ\ENQ\ACK\ACK\ACK\ACK\ENQ\ACK\ACK\EOT\ENQ\ENQ\ENQ\ENQ\ENQ\ENQ\ENQ\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\ENQ\ENQ\DC1\DC1\b\b\b\b\b\b\b\b\b\b\DC1\ETX\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\ENQ\ACK\ACK\GS\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\GS\GS\EOT\EOT\GS\GS\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\GS\EOT\EOT\EOT\EOT\EOT\EOT\EOT\GS\EOT\GS\GS\GS\EOT\EOT\EOT\EOT\GS\GS\ENQ\EOT\ACK\ACK\ACK\ENQ\ENQ\ENQ\ENQ\GS\GS\ACK\ACK\GS\GS\ACK\ACK\ENQ\EOT\GS\GS\GS\GS\GS\GS\GS\GS\ACK\GS\GS\GS\GS\EOT\EOT\GS\EOT\EOT\EOT\ENQ\ENQ\GS\GS\b\b\b\b\b\b\b\b\b\b\EOT\EOT\DC3\DC3\n\n\n\n\n\n\NAK\DC3\EOT\DC1\ENQ\GS\GS\ENQ\ENQ\ACK\GS\EOT\EOT\EOT\EOT\EOT\EOT\GS\GS\GS\GS\EOT\EOT\GS\GS\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\GS\EOT\EOT\EOT\EOT\EOT\EOT\EOT\GS\EOT\EOT\GS\EOT\EOT\GS\EOT\EOT\GS\GS\ENQ\GS\ACK\ACK\ACK\ENQ\ENQ\GS\GS\GS\GS\ENQ\ENQ\GS\GS\ENQ\ENQ\ENQ\GS\GS\GS\ENQ\GS\GS\GS\GS\GS\GS\GS\EOT\EOT\EOT\EOT\GS\EOT\GS\GS\GS\GS\GS\GS\GS\b\b\b\b\b\b\b\b\b\b\ENQ\ENQ\EOT\EOT\EOT\ENQ\DC1\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\ENQ\ENQ\ACK\GS\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\GS\EOT\EOT\EOT\GS\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\GS\EOT\EOT\EOT\EOT\EOT\EOT\EOT\GS\EOT\EOT\GS\EOT\EOT\EOT\EOT\EOT\GS\GS\ENQ\EOT\ACK\ACK\ACK\ENQ\ENQ\ENQ\ENQ\ENQ\GS\ENQ\ENQ\ACK\GS\ACK\ACK\ENQ\GS\GS\EOT\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\EOT\EOT\ENQ\ENQ\GS\GS\b\b\b\b\b\b\b\b\b\b\DC1\DC3\GS\GS\GS\GS\GS\GS\GS\EOT\ENQ\ENQ\ENQ\ENQ\ENQ\ENQ\GS\ENQ\ACK\ACK\GS\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\GS\GS\EOT\EOT\GS\GS\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\GS\EOT\EOT\EOT\EOT\EOT\EOT\EOT\GS\EOT\EOT\GS\EOT\EOT\EOT\EOT\EOT\GS\GS\ENQ\EOT\ACK\ENQ\ACK\ENQ\ENQ\ENQ\ENQ\GS\GS\ACK\ACK\GS\GS\ACK\ACK\ENQ\GS\GS\GS\GS\GS\GS\GS\ENQ\ENQ\ACK\GS\GS\GS\GS\EOT\EOT\GS\EOT\EOT\EOT\ENQ\ENQ\GS\GS\b\b\b\b\b\b\b\b\b\b\NAK\EOT\n\n\n\n\n\n\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\ENQ\EOT\GS\EOT\EOT\EOT\EOT\EOT\EOT\GS\GS\GS\EOT\EOT\EOT\GS\EOT\EOT\EOT\EOT\GS\GS\GS\EOT\EOT\GS\EOT\GS\EOT\EOT\GS\GS\GS\EOT\EOT\GS\GS\GS\EOT\EOT\EOT\GS\GS\GS\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\GS\GS\GS\GS\ACK\ACK\ENQ\ACK\ACK\GS\GS\GS\ACK\ACK\ACK\GS\ACK\ACK\ACK\ENQ\GS\GS\EOT\GS\GS\GS\GS\GS\GS\ACK\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\b\b\b\b\b\b\b\b\b\b\n\n\n\NAK\NAK\NAK\NAK\NAK\NAK\DC3\NAK\GS\GS\GS\GS\GS\ENQ\ACK\ACK\ACK\ENQ\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\GS\EOT\EOT\EOT\GS\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\GS\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\GS\GS\ENQ\EOT\ENQ\ENQ\ENQ\ACK\ACK\ACK\ACK\GS\ENQ\ENQ\ENQ\GS\ENQ\ENQ\ENQ\ENQ\GS\GS\GS\GS\GS\GS\GS\ENQ\ENQ\GS\EOT\EOT\EOT\GS\GS\EOT\GS\GS\EOT\EOT\ENQ\ENQ\GS\GS\b\b\b\b\b\b\b\b\b\b\GS\GS\GS\GS\GS\GS\GS\DC1\n\n\n\n\n\n\n\NAK\EOT\ENQ\ACK\ACK\DC1\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\GS\EOT\EOT\EOT\GS\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\GS\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\GS\EOT\EOT\EOT\EOT\EOT\GS\GS\ENQ\EOT\ACK\ENQ\ACK\ACK\ACK\ACK\ACK\GS\ENQ\ACK\ACK\GS\ACK\ACK\ENQ\ENQ\GS\GS\GS\GS\GS\GS\GS\ACK\ACK\GS\GS\GS\GS\GS\GS\EOT\EOT\GS\EOT\EOT\ENQ\ENQ\GS\GS\b\b\b\b\b\b\b\b\b\b\GS\EOT\EOT\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\ENQ\ENQ\ACK\ACK\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\GS\EOT\EOT\EOT\GS\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\ENQ\ENQ\EOT\ACK\ACK\ACK\ENQ\ENQ\ENQ\ENQ\GS\ACK\ACK\ACK\GS\ACK\ACK\ACK\ENQ\EOT\NAK\GS\GS\GS\GS\EOT\EOT\EOT\ACK\n\n\n\n\n\n\n\EOT\EOT\EOT\ENQ\ENQ\GS\GS\b\b\b\b\b\b\b\b\b\b\n\n\n\n\n\n\n\n\n\NAK\EOT\EOT\EOT\EOT\EOT\EOT\GS\ENQ\ACK\ACK\GS\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\GS\GS\GS\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\GS\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\GS\EOT\GS\GS\EOT\EOT\EOT\EOT\EOT\EOT\EOT\GS\GS\GS\ENQ\GS\GS\GS\GS\ACK\ACK\ACK\ENQ\ENQ\ENQ\GS\ENQ\GS\ACK\ACK\ACK\ACK\ACK\ACK\ACK\ACK\GS\GS\GS\GS\GS\GS\b\b\b\b\b\b\b\b\b\b\GS\GS\ACK\ACK\DC1\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\ENQ\EOT\EOT\ENQ\ENQ\ENQ\ENQ\ENQ\ENQ\ENQ\GS\GS\GS\GS\DC3\EOT\EOT\EOT\EOT\EOT\EOT\ETX\ENQ\ENQ\ENQ\ENQ\ENQ\ENQ\ENQ\ENQ\DC1\b\b\b\b\b\b\b\b\b\b\DC1\DC1\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\EOT\EOT\GS\EOT\GS\EOT\EOT\EOT\EOT\EOT\GS\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\GS\EOT\GS\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\ENQ\EOT\EOT\ENQ\ENQ\ENQ\ENQ\ENQ\ENQ\ENQ\ENQ\ENQ\EOT\GS\GS\EOT\EOT\EOT\EOT\EOT\GS\ETX\GS\ENQ\ENQ\ENQ\ENQ\ENQ\ENQ\GS\GS\b\b\b\b\b\b\b\b\b\b\GS\GS\EOT\EOT\EOT\EOT\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\EOT\NAK\NAK\NAK\DC1\DC1\DC1\DC1\DC1\DC1\DC1\DC1\DC1\DC1\DC1\DC1\DC1\DC1\DC1\NAK\DC1\NAK\NAK\NAK\ENQ\ENQ\NAK\NAK\NAK\NAK\NAK\NAK\b\b\b\b\b\b\b\b\b\b\n\n\n\n\n\n\n\n\n\n\NAK\ENQ\NAK\ENQ\NAK\ENQ\r\SO\r\SO\ACK\ACK\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\GS\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\GS\GS\GS\GS\ENQ\ENQ\ENQ\ENQ\ENQ\ENQ\ENQ\ENQ\ENQ\ENQ\ENQ\ENQ\ENQ\ENQ\ACK\ENQ\ENQ\ENQ\ENQ\ENQ\DC1\ENQ\ENQ\EOT\EOT\EOT\EOT\EOT\ENQ\ENQ\ENQ\ENQ\ENQ\ENQ\ENQ\ENQ\ENQ\ENQ\ENQ\GS\ENQ\ENQ\ENQ\ENQ\ENQ\ENQ\ENQ\ENQ\ENQ\ENQ\ENQ\ENQ\ENQ\ENQ\ENQ\ENQ\ENQ\ENQ\ENQ\ENQ\ENQ\ENQ\ENQ\ENQ\ENQ\ENQ\ENQ\ENQ\ENQ\ENQ\ENQ\ENQ\ENQ\ENQ\ENQ\ENQ\GS\NAK\NAK\NAK\NAK\NAK\NAK\NAK\NAK\ENQ\NAK\NAK\NAK\NAK\NAK\NAK\GS\NAK\NAK\DC1\DC1\DC1\DC1\DC1\NAK\NAK\NAK\NAK\DC1\DC1\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\ACK\ACK\ENQ\ENQ\ENQ\ENQ\ACK\ENQ\ENQ\ENQ\ENQ\ENQ\ENQ\ACK\ENQ\ENQ\ACK\ACK\ENQ\ENQ\EOT\b\b\b\b\b\b\b\b\b\b\DC1\DC1\DC1\DC1\DC1\DC1\EOT\EOT\EOT\EOT\EOT\EOT\ACK\ACK\ENQ\ENQ\EOT\EOT\EOT\EOT\ENQ\ENQ\ENQ\EOT\ACK\ACK\ACK\EOT\EOT\ACK\ACK\ACK\ACK\ACK\ACK\ACK\EOT\EOT\EOT\ENQ\ENQ\ENQ\ENQ\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\ENQ\ACK\ACK\ENQ\ENQ\ACK\ACK\ACK\ACK\ACK\ACK\ENQ\EOT\ACK\b\b\b\b\b\b\b\b\b\b\ACK\ACK\ACK\ENQ\NAK\NAK\NUL\NUL\NUL\NUL\NUL\NUL\NUL\NUL\NUL\NUL\NUL\NUL\NUL\NUL\NUL\NUL\NUL\NUL\NUL\NUL\NUL\NUL\NUL\NUL\NUL\NUL\NUL\NUL\NUL\NUL\NUL\NUL\NUL\NUL\NUL\NUL\NUL\NUL\GS\NUL\GS\GS\GS\GS\GS\NUL\GS\GS\SOH\SOH\SOH\SOH\SOH\SOH\SOH\SOH\SOH\SOH\SOH\SOH\SOH\SOH\SOH\SOH\SOH\SOH\SOH\SOH\SOH\SOH\SOH\SOH\SOH\SOH\SOH\SOH\SOH\SOH\SOH\SOH\SOH\SOH\SOH\SOH\SOH\SOH\SOH\SOH\SOH\SOH\SOH\DC1\ETX\SOH\SOH\SOH\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\GS\EOT\EOT\EOT\EOT\GS\GS\EOT\EOT\EOT\EOT\EOT\EOT\EOT\GS\EOT\GS\EOT\EOT\EOT\EOT\GS\GS\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\GS\EOT\EOT\EOT\EOT\GS\GS\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\GS\EOT\EOT\EOT\EOT\GS\GS\EOT\EOT\EOT\EOT\EOT\EOT\EOT\GS\EOT\GS\EOT\EOT\EOT\EOT\GS\GS\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\GS\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\GS\EOT\EOT\EOT\EOT\GS\GS\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\GS\GS\ENQ\ENQ\ENQ\DC1\DC1\DC1\DC1\DC1\DC1\DC1\DC1\DC1\n\n\n\n\n\n\n\n\n\n\n\n\n\n\n\n\n\n\n\n\GS\GS\GS\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\NAK\NAK\NAK\NAK\NAK\NAK\NAK\NAK\NAK\NAK\GS\GS\GS\GS\GS\GS\NUL\NUL\NUL\NUL\NUL\NUL\NUL\NUL\NUL\NUL\NUL\NUL\NUL\NUL\NUL\NUL\NUL\NUL\NUL\NUL\NUL\NUL\NUL\NUL\NUL\NUL\NUL\NUL\NUL\NUL\NUL\NUL\NUL\NUL\NUL\NUL\NUL\NUL\NUL\NUL\NUL\NUL\NUL\NUL\NUL\NUL\NUL\NUL\NUL\NUL\NUL\NUL\NUL\NUL\NUL\NUL\NUL\NUL\NUL\NUL\NUL\NUL\NUL\NUL\NUL\NUL\NUL\NUL\NUL\NUL\NUL\NUL\NUL\NUL\NUL\NUL\NUL\NUL\NUL\NUL\NUL\NUL\NUL\NUL\NUL\NUL\GS\GS\SOH\SOH\SOH\SOH\SOH\SOH\GS\GS\f\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\NAK\DC1\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\SYN\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\r\SO\GS\GS\GS\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\DC1\DC1\DC1\t\t\t\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\GS\GS\GS\GS\GS\GS\GS\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\ENQ\ENQ\ENQ\ACK\GS\GS\GS\GS\GS\GS\GS\GS\GS\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\ENQ\ENQ\ACK\DC1\DC1\GS\GS\GS\GS\GS\GS\GS\GS\GS\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\ENQ\ENQ\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\GS\EOT\EOT\EOT\GS\ENQ\ENQ\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\ENQ\ENQ\ACK\ENQ\ENQ\ENQ\ENQ\ENQ\ENQ\ENQ\ACK\ACK\ACK\ACK\ACK\ACK\ACK\ACK\ENQ\ACK\ACK\ENQ\ENQ\ENQ\ENQ\ENQ\ENQ\ENQ\ENQ\ENQ\ENQ\ENQ\DC1\DC1\DC1\ETX\DC1\DC1\DC1\DC3\EOT\ENQ\GS\GS\b\b\b\b\b\b\b\b\b\b\GS\GS\GS\GS\GS\GS\n\n\n\n\n\n\n\n\n\n\GS\GS\GS\GS\GS\GS\DC1\DC1\DC1\DC1\DC1\DC1\f\DC1\DC1\DC1\DC1\ENQ\ENQ\ENQ\SUB\ENQ\b\b\b\b\b\b\b\b\b\b\GS\GS\GS\GS\GS\GS\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\ETX\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\GS\GS\GS\GS\GS\GS\GS\EOT\EOT\EOT\EOT\EOT\ENQ\ENQ\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\ENQ\EOT\GS\GS\GS\GS\GS\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\GS\ENQ\ENQ\ENQ\ACK\ACK\ACK\ACK\ENQ\ENQ\ACK\ACK\ACK\GS\GS\GS\GS\ACK\ACK\ENQ\ACK\ACK\ACK\ACK\ACK\ACK\ENQ\ENQ\ENQ\GS\GS\GS\GS\NAK\GS\GS\GS\DC1\DC1\b\b\b\b\b\b\b\b\b\b\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\GS\GS\EOT\EOT\EOT\EOT\EOT\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\GS\GS\GS\GS\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\GS\GS\GS\GS\GS\GS\b\b\b\b\b\b\b\b\b\b\n\GS\GS\GS\NAK\NAK\NAK\NAK\NAK\NAK\NAK\NAK\NAK\NAK\NAK\NAK\NAK\NAK\NAK\NAK\NAK\NAK\NAK\NAK\NAK\NAK\NAK\NAK\NAK\NAK\NAK\NAK\NAK\NAK\NAK\NAK\NAK\NAK\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\ENQ\ENQ\ACK\ACK\ENQ\GS\GS\DC1\DC1\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\ACK\ENQ\ACK\ENQ\ENQ\ENQ\ENQ\ENQ\ENQ\ENQ\GS\ENQ\ACK\ENQ\ACK\ACK\ENQ\ENQ\ENQ\ENQ\ENQ\ENQ\ENQ\ENQ\ACK\ACK\ACK\ACK\ACK\ACK\ENQ\ENQ\ENQ\ENQ\ENQ\ENQ\ENQ\ENQ\ENQ\ENQ\GS\GS\ENQ\b\b\b\b\b\b\b\b\b\b\GS\GS\GS\GS\GS\GS\b\b\b\b\b\b\b\b\b\b\GS\GS\GS\GS\GS\GS\DC1\DC1\DC1\DC1\DC1\DC1\DC1\ETX\DC1\DC1\DC1\DC1\DC1\DC1\GS\GS\ENQ\ENQ\ENQ\ENQ\ENQ\ENQ\ENQ\ENQ\ENQ\ENQ\ENQ\ENQ\ENQ\ENQ\a\ENQ\ENQ\ENQ\ENQ\ENQ\ENQ\ENQ\ENQ\ENQ\ENQ\ENQ\ENQ\ENQ\ENQ\ENQ\ENQ\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\ENQ\ENQ\ENQ\ENQ\ACK\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\ENQ\ACK\ENQ\ENQ\ENQ\ENQ\ENQ\ACK\ENQ\ACK\ACK\ACK\ACK\ACK\ENQ\ACK\ACK\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\GS\GS\GS\b\b\b\b\b\b\b\b\b\b\DC1\DC1\DC1\DC1\DC1\DC1\DC1\NAK\NAK\NAK\NAK\NAK\NAK\NAK\NAK\NAK\NAK\ENQ\ENQ\ENQ\ENQ\ENQ\ENQ\ENQ\ENQ\ENQ\NAK\NAK\NAK\NAK\NAK\NAK\NAK\NAK\NAK\DC1\DC1\GS\ENQ\ENQ\ACK\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\ACK\ENQ\ENQ\ENQ\ENQ\ACK\ACK\ENQ\ENQ\ACK\ENQ\ENQ\ENQ\EOT\EOT\b\b\b\b\b\b\b\b\b\b\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\ENQ\ACK\ENQ\ENQ\ACK\ACK\ACK\ENQ\ACK\ENQ\ENQ\ENQ\ACK\ACK\GS\GS\GS\GS\GS\GS\GS\GS\DC1\DC1\DC1\DC1\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\ACK\ACK\ACK\ACK\ACK\ACK\ACK\ACK\ENQ\ENQ\ENQ\ENQ\ENQ\ENQ\ENQ\ENQ\ACK\ACK\ENQ\ENQ\GS\GS\GS\DC1\DC1\DC1\DC1\DC1\b\b\b\b\b\b\b\b\b\b\GS\GS\GS\EOT\EOT\EOT\b\b\b\b\b\b\b\b\b\b\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\ETX\ETX\ETX\ETX\ETX\ETX\DC1\DC1\SOH\SOH\SOH\SOH\SOH\SOH\SOH\SOH\SOH\GS\GS\GS\GS\GS\GS\GS\NUL\NUL\NUL\NUL\NUL\NUL\NUL\NUL\NUL\NUL\NUL\NUL\NUL\NUL\NUL\NUL\NUL\NUL\NUL\NUL\NUL\NUL\NUL\NUL\NUL\NUL\NUL\NUL\NUL\NUL\NUL\NUL\NUL\NUL\NUL\NUL\NUL\NUL\NUL\NUL\NUL\NUL\NUL\GS\GS\NUL\NUL\NUL\DC1\DC1\DC1\DC1\DC1\DC1\DC1\DC1\GS\GS\GS\GS\GS\GS\GS\GS\ENQ\ENQ\ENQ\DC1\ENQ\ENQ\ENQ\ENQ\ENQ\ENQ\ENQ\ENQ\ENQ\ENQ\ENQ\ENQ\ENQ\ACK\ENQ\ENQ\ENQ\ENQ\ENQ\ENQ\ENQ\EOT\EOT\EOT\EOT\ENQ\EOT\EOT\EOT\EOT\EOT\EOT\ENQ\EOT\EOT\ACK\ENQ\ENQ\EOT\GS\GS\GS\GS\GS\SOH\SOH\SOH\SOH\SOH\SOH\SOH\SOH\SOH\SOH\SOH\SOH\SOH\SOH\SOH\SOH\SOH\SOH\SOH\SOH\SOH\SOH\SOH\SOH\SOH\SOH\SOH\SOH\SOH\SOH\SOH\SOH\SOH\SOH\SOH\SOH\SOH\SOH\SOH\SOH\SOH\SOH\SOH\SOH\ETX\ETX\ETX\ETX\ETX\ETX\ETX\ETX\ETX\ETX\ETX\ETX\ETX\ETX\ETX\ETX\ETX\ETX\ETX\ETX\ETX\ETX\ETX\ETX\ETX\ETX\ETX\ETX\ETX\ETX\ETX\ETX\ETX\ETX\ETX\ETX\ETX\ETX\ETX\ETX\ETX\ETX\ETX\ETX\ETX\ETX\ETX\ETX\ETX\ETX\ETX\ETX\ETX\ETX\ETX\ETX\ETX\ETX\ETX\ETX\ETX\ETX\ETX\SOH\SOH\SOH\SOH\SOH\SOH\SOH\SOH\SOH\SOH\SOH\SOH\SOH\ETX\SOH\SOH\SOH\SOH\SOH\SOH\SOH\SOH\SOH\SOH\SOH\SOH\SOH\SOH\SOH\SOH\SOH\SOH\SOH\SOH\SOH\SOH\SOH\SOH\SOH\SOH\SOH\SOH\SOH\SOH\SOH\SOH\SOH\SOH\ETX\ETX\ETX\ETX\ETX\ETX\ETX\ETX\ETX\ETX\ETX\ETX\ETX\ETX\ETX\ETX\ETX\ETX\ETX\ETX\ETX\ETX\ETX\ETX\ETX\ETX\ETX\ETX\ETX\ETX\ETX\ETX\ETX\ETX\ETX\ETX\ETX\ENQ\ENQ\ENQ\ENQ\ENQ\ENQ\ENQ\ENQ\ENQ\ENQ\ENQ\ENQ\ENQ\ENQ\ENQ\ENQ\ENQ\ENQ\ENQ\ENQ\ENQ\ENQ\ENQ\ENQ\ENQ\ENQ\ENQ\ENQ\ENQ\ENQ\ENQ\ENQ\ENQ\ENQ\ENQ\ENQ\ENQ\ENQ\ENQ\ENQ\ENQ\ENQ\ENQ\ENQ\ENQ\ENQ\ENQ\ENQ\ENQ\ENQ\ENQ\ENQ\ENQ\ENQ\ENQ\ENQ\ENQ\ENQ\ENQ\ENQ\ENQ\ENQ\ENQ\ENQ\NUL\SOH\NUL\SOH\NUL\SOH\NUL\SOH\NUL\SOH\NUL\SOH\NUL\SOH\NUL\SOH\NUL\SOH\NUL\SOH\NUL\SOH\NUL\SOH\NUL\SOH\NUL\SOH\NUL\SOH\NUL\SOH\NUL\SOH\NUL\SOH\NUL\SOH\NUL\SOH\NUL\SOH\NUL\SOH\NUL\SOH\NUL\SOH\NUL\SOH\NUL\SOH\NUL\SOH\NUL\SOH\NUL\SOH\NUL\SOH\NUL\SOH\NUL\SOH\NUL\SOH\NUL\SOH\NUL\SOH\NUL\SOH\NUL\SOH\NUL\SOH\NUL\SOH\NUL\SOH\NUL\SOH\NUL\SOH\NUL\SOH\NUL\SOH\NUL\SOH\NUL\SOH\NUL\SOH\NUL\SOH\NUL\SOH\NUL\SOH\NUL\SOH\NUL\SOH\NUL\SOH\NUL\SOH\NUL\SOH\NUL\SOH\NUL\SOH\NUL\SOH\NUL\SOH\NUL\SOH\NUL\SOH\NUL\SOH\NUL\SOH\NUL\SOH\NUL\SOH\NUL\SOH\NUL\SOH\NUL\SOH\NUL\SOH\NUL\SOH\NUL\SOH\NUL\SOH\NUL\SOH\NUL\SOH\NUL\SOH\SOH\SOH\SOH\SOH\SOH\SOH\SOH\SOH\NUL\SOH\NUL\SOH\NUL\SOH\NUL\SOH\NUL\SOH\NUL\SOH\NUL\SOH\NUL\SOH\NUL\SOH\NUL\SOH\NUL\SOH\NUL\SOH\NUL\SOH\NUL\SOH\NUL\SOH\NUL\SOH\NUL\SOH\NUL\SOH\NUL\SOH\NUL\SOH\NUL\SOH\NUL\SOH\NUL\SOH\NUL\SOH\NUL\SOH\NUL\SOH\NUL\SOH\NUL\SOH\NUL\SOH\NUL\SOH\NUL\SOH\NUL\SOH\NUL\SOH\NUL\SOH\NUL\SOH\NUL\SOH\NUL\SOH\NUL\SOH\NUL\SOH\NUL\SOH\NUL\SOH\NUL\SOH\NUL\SOH\NUL\SOH\NUL\SOH\NUL\SOH\NUL\SOH\NUL\SOH\NUL\SOH\SOH\SOH\SOH\SOH\SOH\SOH\SOH\SOH\NUL\NUL\NUL\NUL\NUL\NUL\NUL\NUL\SOH\SOH\SOH\SOH\SOH\SOH\GS\GS\NUL\NUL\NUL\NUL\NUL\NUL\GS\GS\SOH\SOH\SOH\SOH\SOH\SOH\SOH\SOH\NUL\NUL\NUL\NUL\NUL\NUL\NUL\NUL\SOH\SOH\SOH\SOH\SOH\SOH\SOH\SOH\NUL\NUL\NUL\NUL\NUL\NUL\NUL\NUL\SOH\SOH\SOH\SOH\SOH\SOH\GS\GS\NUL\NUL\NUL\NUL\NUL\NUL\GS\GS\SOH\SOH\SOH\SOH\SOH\SOH\SOH\SOH\GS\NUL\GS\NUL\GS\NUL\GS\NUL\SOH\SOH\SOH\SOH\SOH\SOH\SOH\SOH\NUL\NUL\NUL\NUL\NUL\NUL\NUL\NUL\SOH\SOH\SOH\SOH\SOH\SOH\SOH\SOH\SOH\SOH\SOH\SOH\SOH\SOH\GS\GS\SOH\SOH\SOH\SOH\SOH\SOH\SOH\SOH\STX\STX\STX\STX\STX\STX\STX\STX\SOH\SOH\SOH\SOH\SOH\SOH\SOH\SOH\STX\STX\STX\STX\STX\STX\STX\STX\SOH\SOH\SOH\SOH\SOH\SOH\SOH\SOH\STX\STX\STX\STX\STX\STX\STX\STX\SOH\SOH\SOH\SOH\SOH\GS\SOH\SOH\NUL\NUL\NUL\NUL\STX\DC4\SOH\DC4\DC4\DC4\SOH\SOH\SOH\GS\SOH\SOH\NUL\NUL\NUL\NUL\STX\DC4\DC4\DC4\SOH\SOH\SOH\SOH\GS\GS\SOH\SOH\NUL\NUL\NUL\NUL\GS\DC4\DC4\DC4\SOH\SOH\SOH\SOH\SOH\SOH\SOH\SOH\NUL\NUL\NUL\NUL\NUL\DC4\DC4\DC4\GS\GS\SOH\SOH\SOH\GS\SOH\SOH\NUL\NUL\NUL\NUL\STX\DC4\DC4\GS\SYN\SYN\SYN\SYN\SYN\SYN\SYN\SYN\SYN\SYN\SYN\SUB\SUB\SUB\SUB\SUB\f\f\f\f\f\f\DC1\DC1\SI\DLE\r\SI\SI\DLE\r\SI\DC1\DC1\DC1\DC1\DC1\DC1\DC1\DC1\ETB\CAN\SUB\SUB\SUB\SUB\SUB\SYN\DC1\DC1\DC1\DC1\DC1\DC1\DC1\DC1\DC1\SI\DLE\DC1\DC1\DC1\DC1\v\v\DC1\DC1\DC1\DC2\r\SO\DC1\DC1\DC1\DC1\DC1\DC1\DC1\DC1\DC1\DC1\DC1\DC2\DC1\v\DC1\DC1\DC1\DC1\DC1\DC1\DC1\DC1\DC1\DC1\SYN\SUB\SUB\SUB\SUB\SUB\GS\SUB\SUB\SUB\SUB\SUB\SUB\SUB\SUB\SUB\SUB\n\ETX\GS\GS\n\n\n\n\n\n\DC2\DC2\DC2\r\SO\ETX\n\n\n\n\n\n\n\n\n\n\DC2\DC2\DC2\r\SO\GS\ETX\ETX\ETX\ETX\ETX\ETX\ETX\ETX\ETX\ETX\ETX\ETX\ETX\GS\GS\GS\DC3\DC3\DC3\DC3\DC3\DC3\DC3\DC3\DC3\DC3\DC3\DC3\DC3\DC3\DC3\DC3\DC3\DC3\DC3\DC3\DC3\DC3\DC3\DC3\DC3\DC3\DC3\DC3\DC3\DC3\DC3\DC3\DC3\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\ENQ\ENQ\ENQ\ENQ\ENQ\ENQ\ENQ\ENQ\ENQ\ENQ\ENQ\ENQ\ENQ\a\a\a\a\ENQ\a\a\a\ENQ\ENQ\ENQ\ENQ\ENQ\ENQ\ENQ\ENQ\ENQ\ENQ\ENQ\ENQ\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\NAK\NAK\NUL\NAK\NAK\NAK\NAK\NUL\NAK\NAK\SOH\NUL\NUL\NUL\SOH\SOH\NUL\NUL\NUL\SOH\NAK\NUL\NAK\NAK\DC2\NUL\NUL\NUL\NUL\NUL\NAK\NAK\NAK\NAK\NAK\NAK\NUL\NAK\NUL\NAK\NUL\NAK\NUL\NUL\NUL\NUL\NAK\SOH\NUL\NUL\NUL\NUL\SOH\EOT\EOT\EOT\EOT\SOH\NAK\NAK\SOH\SOH\NUL\NUL\DC2\DC2\DC2\DC2\DC2\NUL\SOH\SOH\SOH\SOH\NAK\DC2\NAK\NAK\SOH\NAK\n\n\n\n\n\n\n\n\n\n\n\n\n\n\n\n\t\t\t\t\t\t\t\t\t\t\t\t\t\t\t\t\t\t\t\t\t\t\t\t\t\t\t\t\t\t\t\t\t\t\t\NUL\SOH\t\t\t\t\n\NAK\NAK\GS\GS\GS\GS\DC2\DC2\DC2\DC2\DC2\NAK\NAK\NAK\NAK\NAK\DC2\DC2\NAK\NAK\NAK\NAK\DC2\NAK\NAK\DC2\NAK\NAK\DC2\NAK\NAK\NAK\NAK\NAK\NAK\NAK\DC2\NAK\NAK\NAK\NAK\NAK\NAK\NAK\NAK\NAK\NAK\NAK\NAK\NAK\NAK\NAK\NAK\NAK\NAK\NAK\NAK\NAK\NAK\NAK\NAK\NAK\NAK\NAK\NAK\NAK\NAK\NAK\DC2\DC2\NAK\NAK\DC2\NAK\DC2\NAK\NAK\NAK\NAK\NAK\NAK\NAK\NAK\NAK\NAK\NAK\NAK\NAK\NAK\NAK\NAK\NAK\NAK\NAK\NAK\NAK\NAK\NAK\NAK\NAK\NAK\NAK\NAK\NAK\NAK\NAK\DC2\DC2\DC2\DC2\DC2\DC2\DC2\DC2\DC2\DC2\DC2\DC2\DC2\DC2\DC2\DC2\DC2\DC2\DC2\DC2\DC2\DC2\DC2\DC2\DC2\DC2\DC2\DC2\DC2\DC2\DC2\DC2\DC2\DC2\DC2\DC2\DC2\DC2\DC2\DC2\DC2\DC2\DC2\DC2\DC2\DC2\DC2\DC2\DC2\DC2\DC2\DC2\DC2\DC2\DC2\DC2\DC2\DC2\DC2\DC2\DC2\DC2\DC2\DC2\DC2\DC2\DC2\DC2\DC2\DC2\DC2\DC2\DC2\DC2\DC2\DC2\DC2\DC2\DC2\DC2\DC2\DC2\DC2\DC2\DC2\DC2\DC2\DC2\DC2\DC2\DC2\DC2\DC2\DC2\DC2\DC2\DC2\DC2\DC2\DC2\DC2\DC2\DC2\DC2\DC2\DC2\DC2\DC2\DC2\DC2\DC2\DC2\DC2\DC2\DC2\DC2\DC2\DC2\DC2\DC2\DC2\DC2\DC2\DC2\DC2\DC2\DC2\DC2\DC2\DC2\DC2\DC2\DC2\DC2\DC2\DC2\DC2\DC2\DC2\DC2\DC2\DC2\DC2\DC2\DC2\DC2\DC2\DC2\DC2\DC2\DC2\DC2\DC2\DC2\DC2\DC2\DC2\DC2\DC2\DC2\DC2\DC2\DC2\DC2\DC2\DC2\DC2\DC2\DC2\DC2\DC2\DC2\DC2\DC2\DC2\DC2\DC2\DC2\DC2\DC2\DC2\DC2\DC2\DC2\DC2\DC2\DC2\DC2\DC2\DC2\DC2\DC2\DC2\DC2\DC2\DC2\DC2\DC2\DC2\DC2\DC2\DC2\DC2\DC2\DC2\DC2\DC2\DC2\DC2\DC2\DC2\DC2\DC2\DC2\DC2\DC2\DC2\DC2\DC2\DC2\DC2\DC2\DC2\DC2\DC2\DC2\DC2\DC2\DC2\DC2\DC2\DC2\DC2\DC2\DC2\DC2\DC2\DC2\DC2\DC2\DC2\DC2\DC2\DC2\DC2\DC2\DC2\DC2\DC2\DC2\DC2\DC2\DC2\DC2\DC2\DC2\DC2\DC2\DC2\DC2\DC2\DC2\DC2\DC2\DC2\DC2\DC2\DC2\NAK\NAK\NAK\NAK\NAK\NAK\NAK\NAK\r\SO\r\SO\NAK\NAK\NAK\NAK\NAK\NAK\NAK\NAK\NAK\NAK\NAK\NAK\NAK\NAK\NAK\NAK\NAK\NAK\NAK\NAK\DC2\DC2\NAK\NAK\NAK\NAK\NAK\NAK\NAK\r\SO\NAK\NAK\NAK\NAK\NAK\NAK\NAK\NAK\NAK\NAK\NAK\NAK\NAK\NAK\NAK\NAK\NAK\NAK\NAK\NAK\NAK\NAK\NAK\NAK\NAK\NAK\NAK\NAK\NAK\NAK\NAK\NAK\NAK\NAK\NAK\NAK\NAK\NAK\NAK\NAK\NAK\NAK\NAK\NAK\NAK\NAK\NAK\NAK\NAK\NAK\NAK\NAK\NAK\NAK\NAK\NAK\NAK\NAK\NAK\NAK\NAK\NAK\NAK\NAK\NAK\NAK\NAK\NAK\NAK\NAK\NAK\NAK\NAK\NAK\NAK\NAK\NAK\NAK\NAK\NAK\NAK\DC2\NAK\NAK\NAK\NAK\NAK\NAK\NAK\NAK\NAK\NAK\NAK\NAK\NAK\NAK\NAK\NAK\NAK\NAK\NAK\NAK\NAK\NAK\NAK\NAK\NAK\NAK\NAK\NAK\NAK\NAK\DC2\DC2\DC2\DC2\DC2\DC2\DC2\DC2\DC2\DC2\DC2\DC2\DC2\DC2\DC2\DC2\DC2\DC2\DC2\DC2\DC2\DC2\DC2\DC2\DC2\NAK\NAK\NAK\NAK\NAK\NAK\NAK\NAK\NAK\NAK\NAK\NAK\NAK\NAK\NAK\NAK\NAK\NAK\NAK\NAK\NAK\NAK\NAK\NAK\NAK\NAK\NAK\NAK\NAK\NAK\NAK\NAK\NAK\NAK\NAK\NAK\NAK\NAK\NAK\NAK\DC2\DC2\DC2\DC2\DC2\DC2\NAK\NAK\NAK\NAK\NAK\NAK\NAK\NAK\NAK\NAK\NAK\NAK\NAK\NAK\NAK\NAK\NAK\NAK\NAK\NAK\NAK\NAK\NAK\NAK\NAK\NAK\NAK\NAK\NAK\NAK\NAK\NAK\NAK\NAK\NAK\NAK\NAK\NAK\NAK\NAK\NAK\NAK\NAK\NAK\NAK\NAK\NAK\NAK\NAK\NAK\NAK\NAK\NAK\NAK\NAK\NAK\NAK\NAK\NAK\NAK\NAK\NAK\NAK\NAK\NAK\NAK\NAK\NAK\NAK\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\NAK\NAK\NAK\NAK\NAK\NAK\NAK\NAK\NAK\NAK\NAK\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\n\n\n\n\n\n\n\n\n\n\n\n\n\n\n\n\n\n\n\n\n\n\n\n\n\n\n\n\n\n\n\n\n\n\n\n\n\n\n\n\n\n\n\n\n\n\n\n\n\n\n\n\n\n\n\n\n\n\n\n\NAK\NAK\NAK\NAK\NAK\NAK\NAK\NAK\NAK\NAK\NAK\NAK\NAK\NAK\NAK\NAK\NAK\NAK\NAK\NAK\NAK\NAK\NAK\NAK\NAK\NAK\NAK\NAK\NAK\NAK\NAK\NAK\NAK\NAK\NAK\NAK\NAK\NAK\NAK\NAK\NAK\NAK\NAK\NAK\NAK\NAK\NAK\NAK\NAK\NAK\NAK\NAK\NAK\NAK\NAK\NAK\NAK\NAK\NAK\NAK\NAK\NAK\NAK\NAK\NAK\NAK\NAK\NAK\NAK\NAK\NAK\NAK\NAK\NAK\NAK\NAK\NAK\NAK\n\n\n\n\n\n\n\n\n\n\n\n\n\n\n\n\n\n\n\n\n\n\NAK\NAK\NAK\NAK\NAK\NAK\NAK\NAK\NAK\NAK\NAK\NAK\NAK\NAK\NAK\NAK\NAK\NAK\NAK\NAK\NAK\NAK\NAK\NAK\NAK\NAK\NAK\NAK\NAK\NAK\NAK\NAK\NAK\NAK\NAK\NAK\NAK\NAK\NAK\NAK\NAK\NAK\NAK\NAK\NAK\NAK\NAK\NAK\NAK\NAK\NAK\NAK\NAK\NAK\NAK\NAK\NAK\NAK\NAK\NAK\NAK\NAK\NAK\NAK\NAK\NAK\NAK\NAK\NAK\NAK\NAK\NAK\NAK\NAK\NAK\NAK\NAK\NAK\NAK\NAK\NAK\NAK\NAK\NAK\NAK\NAK\NAK\NAK\NAK\NAK\NAK\NAK\NAK\NAK\NAK\NAK\NAK\NAK\NAK\NAK\NAK\NAK\NAK\NAK\NAK\NAK\NAK\NAK\NAK\NAK\NAK\NAK\NAK\NAK\NAK\NAK\NAK\NAK\NAK\NAK\NAK\NAK\NAK\NAK\NAK\NAK\NAK\NAK\NAK\NAK\NAK\NAK\NAK\NAK\NAK\NAK\NAK\NAK\NAK\NAK\NAK\NAK\NAK\NAK\NAK\NAK\NAK\NAK\NAK\NAK\NAK\NAK\NAK\NAK\NAK\NAK\NAK\NAK\NAK\NAK\NAK\NAK\NAK\NAK\NAK\NAK\NAK\NAK\NAK\NAK\NAK\NAK\NAK\NAK\NAK\NAK\NAK\NAK\NAK\NAK\NAK\NAK\NAK\DC2\NAK\NAK\NAK\NAK\NAK\NAK\NAK\NAK\NAK\DC2\NAK\NAK\NAK\NAK\NAK\NAK\NAK\NAK\NAK\NAK\NAK\NAK\NAK\NAK\NAK\NAK\NAK\NAK\NAK\NAK\NAK\NAK\NAK\NAK\NAK\NAK\NAK\NAK\NAK\NAK\NAK\NAK\NAK\NAK\NAK\NAK\NAK\NAK\NAK\NAK\NAK\NAK\NAK\NAK\NAK\NAK\NAK\NAK\NAK\NAK\NAK\NAK\NAK\NAK\DC2\DC2\DC2\DC2\DC2\DC2\DC2\DC2\NAK\NAK\NAK\NAK\NAK\NAK\NAK\NAK\NAK\NAK\NAK\NAK\NAK\NAK\NAK\NAK\NAK\NAK\NAK\NAK\NAK\NAK\NAK\NAK\NAK\NAK\NAK\NAK\NAK\NAK\NAK\NAK\NAK\NAK\NAK\NAK\NAK\NAK\NAK\NAK\NAK\NAK\NAK\NAK\NAK\NAK\NAK\NAK\NAK\NAK\NAK\NAK\NAK\NAK\NAK\NAK\NAK\NAK\NAK\NAK\NAK\NAK\NAK\NAK\NAK\NAK\NAK\NAK\NAK\NAK\NAK\NAK\NAK\NAK\NAK\NAK\NAK\NAK\NAK\NAK\NAK\NAK\NAK\NAK\NAK\NAK\NAK\NAK\NAK\NAK\NAK\NAK\NAK\NAK\NAK\NAK\NAK\NAK\NAK\NAK\NAK\NAK\NAK\NAK\NAK\NAK\NAK\NAK\NAK\NAK\NAK\DC2\NAK\NAK\NAK\NAK\NAK\NAK\NAK\NAK\NAK\NAK\NAK\NAK\NAK\NAK\NAK\NAK\NAK\NAK\NAK\NAK\NAK\NAK\NAK\NAK\NAK\NAK\NAK\NAK\NAK\NAK\NAK\NAK\NAK\NAK\NAK\NAK\NAK\NAK\NAK\NAK\NAK\NAK\NAK\NAK\NAK\NAK\NAK\NAK\NAK\NAK\NAK\NAK\NAK\NAK\NAK\NAK\NAK\NAK\NAK\NAK\NAK\NAK\NAK\NAK\NAK\NAK\NAK\NAK\NAK\NAK\NAK\NAK\NAK\NAK\NAK\NAK\NAK\NAK\NAK\NAK\NAK\NAK\NAK\NAK\NAK\NAK\NAK\NAK\NAK\NAK\NAK\NAK\NAK\NAK\NAK\NAK\NAK\NAK\NAK\NAK\NAK\NAK\NAK\NAK\NAK\NAK\NAK\NAK\NAK\NAK\NAK\NAK\NAK\NAK\NAK\NAK\NAK\NAK\NAK\NAK\NAK\NAK\NAK\NAK\NAK\NAK\NAK\NAK\NAK\NAK\NAK\NAK\NAK\NAK\NAK\NAK\NAK\NAK\NAK\NAK\NAK\NAK\NAK\NAK\NAK\NAK\NAK\NAK\NAK\NAK\NAK\NAK\NAK\NAK\NAK\NAK\NAK\NAK\NAK\NAK\NAK\NAK\NAK\NAK\NAK\NAK\NAK\NAK\NAK\NAK\NAK\NAK\NAK\NAK\NAK\NAK\NAK\NAK\NAK\NAK\NAK\NAK\NAK\NAK\NAK\NAK\NAK\NAK\NAK\NAK\NAK\NAK\NAK\NAK\NAK\NAK\NAK\NAK\NAK\NAK\NAK\NAK\NAK\NAK\NAK\NAK\NAK\NAK\NAK\NAK\NAK\NAK\NAK\NAK\NAK\NAK\NAK\NAK\NAK\NAK\NAK\NAK\NAK\NAK\NAK\NAK\NAK\NAK\NAK\NAK\NAK\NAK\NAK\NAK\NAK\NAK\NAK\NAK\NAK\NAK\NAK\NAK\NAK\NAK\NAK\NAK\NAK\NAK\r\SO\r\SO\r\SO\r\SO\r\SO\r\SO\r\SO\n\n\n\n\n\n\n\n\n\n\n\n\n\n\n\n\n\n\n\n\n\n\n\n\n\n\n\n\n\n\NAK\NAK\NAK\NAK\NAK\NAK\NAK\NAK\NAK\NAK\NAK\NAK\NAK\NAK\NAK\NAK\NAK\NAK\NAK\NAK\NAK\NAK\NAK\NAK\NAK\NAK\NAK\NAK\NAK\NAK\NAK\NAK\NAK\NAK\NAK\NAK\NAK\NAK\NAK\NAK\NAK\NAK\NAK\NAK\DC2\DC2\DC2\DC2\DC2\r\SO\DC2\DC2\DC2\DC2\DC2\DC2\DC2\DC2\DC2\DC2\DC2\DC2\DC2\DC2\DC2\DC2\DC2\DC2\DC2\DC2\DC2\DC2\DC2\DC2\DC2\DC2\DC2\DC2\DC2\DC2\DC2\r\SO\r\SO\r\SO\r\SO\r\SO\DC2\DC2\DC2\DC2\DC2\DC2\DC2\DC2\DC2\DC2\DC2\DC2\DC2\DC2\DC2\DC2\NAK\NAK\NAK\NAK\NAK\NAK\NAK\NAK\NAK\NAK\NAK\NAK\NAK\NAK\NAK\NAK\NAK\NAK\NAK\NAK\NAK\NAK\NAK\NAK\NAK\NAK\NAK\NAK\NAK\NAK\NAK\NAK\NAK\NAK\NAK\NAK\NAK\NAK\NAK\NAK\NAK\NAK\NAK\NAK\NAK\NAK\NAK\NAK\NAK\NAK\NAK\NAK\NAK\NAK\NAK\NAK\NAK\NAK\NAK\NAK\NAK\NAK\NAK\NAK\NAK\NAK\NAK\NAK\NAK\NAK\NAK\NAK\NAK\NAK\NAK\NAK\NAK\NAK\NAK\NAK\NAK\NAK\NAK\NAK\NAK\NAK\NAK\NAK\NAK\NAK\NAK\NAK\NAK\NAK\NAK\NAK\NAK\NAK\NAK\NAK\NAK\NAK\NAK\NAK\NAK\NAK\NAK\NAK\NAK\NAK\NAK\NAK\NAK\NAK\NAK\NAK\NAK\NAK\NAK\NAK\NAK\NAK\NAK\NAK\NAK\NAK\NAK\NAK\NAK\NAK\NAK\NAK\NAK\NAK\NAK\NAK\NAK\NAK\NAK\NAK\NAK\NAK\NAK\NAK\NAK\NAK\NAK\NAK\NAK\NAK\NAK\NAK\NAK\NAK\NAK\NAK\NAK\NAK\NAK\NAK\NAK\NAK\NAK\NAK\NAK\NAK\NAK\NAK\NAK\NAK\NAK\NAK\NAK\NAK\NAK\NAK\NAK\NAK\NAK\NAK\NAK\NAK\NAK\NAK\NAK\NAK\NAK\NAK\NAK\NAK\NAK\NAK\NAK\NAK\NAK\NAK\NAK\NAK\NAK\NAK\NAK\NAK\NAK\NAK\NAK\NAK\NAK\NAK\NAK\NAK\NAK\NAK\NAK\NAK\NAK\NAK\NAK\NAK\NAK\NAK\NAK\NAK\NAK\NAK\NAK\NAK\NAK\NAK\NAK\NAK\NAK\NAK\NAK\NAK\NAK\NAK\NAK\NAK\NAK\NAK\NAK\NAK\NAK\NAK\NAK\NAK\NAK\NAK\NAK\NAK\NAK\NAK\NAK\NAK\NAK\NAK\DC2\DC2\DC2\DC2\DC2\DC2\DC2\DC2\DC2\DC2\DC2\DC2\DC2\DC2\DC2\DC2\DC2\DC2\DC2\DC2\DC2\DC2\DC2\DC2\DC2\DC2\DC2\DC2\DC2\DC2\DC2\DC2\DC2\DC2\DC2\DC2\DC2\DC2\DC2\DC2\DC2\DC2\DC2\DC2\DC2\DC2\DC2\DC2\DC2\DC2\DC2\DC2\DC2\DC2\DC2\DC2\DC2\DC2\DC2\DC2\DC2\DC2\DC2\DC2\DC2\DC2\DC2\DC2\DC2\DC2\DC2\DC2\DC2\DC2\DC2\DC2\DC2\DC2\DC2\DC2\DC2\DC2\DC2\DC2\DC2\DC2\DC2\DC2\DC2\DC2\DC2\DC2\DC2\DC2\DC2\DC2\DC2\DC2\DC2\DC2\DC2\DC2\DC2\DC2\DC2\DC2\DC2\DC2\DC2\DC2\DC2\DC2\DC2\DC2\DC2\DC2\DC2\DC2\DC2\DC2\DC2\DC2\DC2\DC2\DC2\DC2\DC2\DC2\DC2\DC2\DC2\r\SO\r\SO\r\SO\r\SO\r\SO\r\SO\r\SO\r\SO\r\SO\r\SO\r\SO\DC2\DC2\DC2\DC2\DC2\DC2\DC2\DC2\DC2\DC2\DC2\DC2\DC2\DC2\DC2\DC2\DC2\DC2\DC2\DC2\DC2\DC2\DC2\DC2\DC2\DC2\DC2\DC2\DC2\DC2\DC2\DC2\DC2\DC2\DC2\DC2\DC2\DC2\DC2\DC2\DC2\DC2\DC2\DC2\DC2\DC2\DC2\DC2\DC2\DC2\DC2\DC2\DC2\DC2\DC2\DC2\DC2\DC2\DC2\DC2\DC2\DC2\DC2\r\SO\r\SO\DC2\DC2\DC2\DC2\DC2\DC2\DC2\DC2\DC2\DC2\DC2\DC2\DC2\DC2\DC2\DC2\DC2\DC2\DC2\DC2\DC2\DC2\DC2\DC2\DC2\DC2\DC2\DC2\DC2\DC2\DC2\DC2\r\SO\DC2\DC2\DC2\DC2\DC2\DC2\DC2\DC2\DC2\DC2\DC2\DC2\DC2\DC2\DC2\DC2\DC2\DC2\DC2\DC2\DC2\DC2\DC2\DC2\DC2\DC2\DC2\DC2\DC2\DC2\DC2\DC2\DC2\DC2\DC2\DC2\DC2\DC2\DC2\DC2\DC2\DC2\DC2\DC2\DC2\DC2\DC2\DC2\DC2\DC2\DC2\DC2\DC2\DC2\DC2\DC2\DC2\DC2\DC2\DC2\DC2\DC2\DC2\DC2\DC2\DC2\DC2\DC2\DC2\DC2\DC2\DC2\DC2\DC2\DC2\DC2\DC2\DC2\DC2\DC2\DC2\DC2\DC2\DC2\DC2\DC2\DC2\DC2\DC2\DC2\DC2\DC2\DC2\DC2\DC2\DC2\DC2\DC2\DC2\DC2\DC2\DC2\DC2\DC2\DC2\DC2\DC2\DC2\DC2\DC2\DC2\DC2\DC2\DC2\DC2\DC2\DC2\DC2\DC2\DC2\DC2\DC2\DC2\DC2\DC2\DC2\DC2\DC2\DC2\DC2\DC2\DC2\DC2\DC2\DC2\DC2\DC2\DC2\DC2\DC2\DC2\DC2\DC2\DC2\DC2\DC2\DC2\DC2\DC2\DC2\DC2\DC2\DC2\DC2\DC2\DC2\DC2\DC2\DC2\DC2\DC2\DC2\DC2\DC2\DC2\DC2\DC2\DC2\DC2\DC2\DC2\DC2\DC2\DC2\DC2\DC2\DC2\DC2\DC2\DC2\DC2\DC2\DC2\DC2\DC2\DC2\DC2\DC2\DC2\DC2\DC2\DC2\DC2\DC2\DC2\DC2\DC2\DC2\DC2\DC2\DC2\DC2\DC2\DC2\DC2\DC2\DC2\DC2\DC2\DC2\DC2\DC2\DC2\DC2\DC2\DC2\DC2\DC2\DC2\DC2\DC2\DC2\DC2\DC2\DC2\DC2\DC2\DC2\DC2\DC2\DC2\DC2\DC2\DC2\DC2\DC2\DC2\DC2\DC2\DC2\DC2\DC2\DC2\DC2\DC2\DC2\DC2\DC2\DC2\DC2\DC2\DC2\DC2\DC2\DC2\DC2\DC2\DC2\NAK\NAK\NAK\NAK\NAK\NAK\NAK\NAK\NAK\NAK\NAK\NAK\NAK\NAK\NAK\NAK\NAK\NAK\NAK\NAK\NAK\NAK\NAK\NAK\NAK\NAK\NAK\NAK\NAK\NAK\NAK\NAK\NAK\NAK\NAK\NAK\NAK\NAK\NAK\NAK\NAK\NAK\NAK\NAK\NAK\NAK\NAK\NAK\DC2\DC2\DC2\DC2\DC2\DC2\DC2\DC2\DC2\DC2\DC2\DC2\DC2\DC2\DC2\DC2\DC2\DC2\DC2\DC2\DC2\NAK\NAK\DC2\DC2\DC2\DC2\DC2\DC2\NAK\NAK\NAK\NAK\NAK\NAK\NAK\NAK\NAK\NAK\NAK\NAK\NAK\NAK\NAK\NAK\NAK\NAK\NAK\NAK\NAK\NAK\NAK\NAK\NAK\NAK\NAK\NAK\NAK\NAK\NAK\NAK\NAK\NAK\NAK\NAK\NAK\NAK\NAK\GS\GS\NAK\NAK\NAK\NAK\NAK\NAK\NAK\NAK\NAK\NAK\NAK\NAK\NAK\NAK\NAK\NAK\NAK\NAK\NAK\NAK\NAK\NAK\NAK\NAK\NAK\NAK\NAK\NAK\NAK\NAK\NAK\NAK\GS\NAK\NAK\NAK\NAK\NAK\NAK\NAK\NAK\NAK\NAK\NAK\NAK\NAK\NAK\NAK\NAK\NAK\NAK\NAK\NAK\NAK\NAK\NAK\NAK\NAK\NAK\NAK\NAK\NAK\NAK\NAK\NAK\NAK\NAK\NAK\NAK\NAK\NAK\NAK\NAK\NAK\NAK\NAK\NAK\NAK\NAK\NAK\NAK\NAK\NAK\NAK\NAK\NAK\NAK\NAK\NAK\NAK\NAK\NAK\NAK\NAK\NAK\NAK\NAK\NAK\NAK\NAK\NAK\NAK\NAK\NAK\NAK\NAK\NAK\NAK\NAK\NAK\NAK\NAK\NAK\NAK\NAK\NAK\NAK\NAK\NAK\NAK\NAK\NAK\NAK\NAK\NAK\NAK\NAK\NAK\NAK\NAK\NAK\NAK\NAK\NAK\NAK\NAK\NAK\NAK\NUL\NUL\NUL\NUL\NUL\NUL\NUL\NUL\NUL\NUL\NUL\NUL\NUL\NUL\NUL\NUL\NUL\NUL\NUL\NUL\NUL\NUL\NUL\NUL\NUL\NUL\NUL\NUL\NUL\NUL\NUL\NUL\NUL\NUL\NUL\NUL\NUL\NUL\NUL\NUL\NUL\NUL\NUL\NUL\NUL\NUL\NUL\NUL\SOH\SOH\SOH\SOH\SOH\SOH\SOH\SOH\SOH\SOH\SOH\SOH\SOH\SOH\SOH\SOH\SOH\SOH\SOH\SOH\SOH\SOH\SOH\SOH\SOH\SOH\SOH\SOH\SOH\SOH\SOH\SOH\SOH\SOH\SOH\SOH\SOH\SOH\SOH\SOH\SOH\SOH\SOH\SOH\SOH\SOH\SOH\SOH\NUL\SOH\NUL\NUL\NUL\SOH\SOH\NUL\SOH\NUL\SOH\NUL\SOH\NUL\NUL\NUL\NUL\SOH\NUL\SOH\SOH\NUL\SOH\SOH\SOH\SOH\SOH\SOH\ETX\ETX\NUL\NUL\NUL\SOH\NUL\SOH\NUL\SOH\NUL\SOH\NUL\SOH\NUL\SOH\NUL\SOH\NUL\SOH\NUL\SOH\NUL\SOH\NUL\SOH\NUL\SOH\NUL\SOH\NUL\SOH\NUL\SOH\NUL\SOH\NUL\SOH\NUL\SOH\NUL\SOH\NUL\SOH\NUL\SOH\NUL\SOH\NUL\SOH\NUL\SOH\NUL\SOH\NUL\SOH\NUL\SOH\NUL\SOH\NUL\SOH\NUL\SOH\NUL\SOH\NUL\SOH\NUL\SOH\NUL\SOH\NUL\SOH\NUL\SOH\NUL\SOH\NUL\SOH\NUL\SOH\NUL\SOH\NUL\SOH\NUL\SOH\NUL\SOH\NUL\SOH\NUL\SOH\NUL\SOH\NUL\SOH\NUL\SOH\NUL\SOH\NUL\SOH\SOH\NAK\NAK\NAK\NAK\NAK\NAK\NUL\SOH\NUL\SOH\ENQ\ENQ\ENQ\NUL\SOH\GS\GS\GS\GS\GS\DC1\DC1\DC1\DC1\n\DC1\DC1\SOH\SOH\SOH\SOH\SOH\SOH\SOH\SOH\SOH\SOH\SOH\SOH\SOH\SOH\SOH\SOH\SOH\SOH\SOH\SOH\SOH\SOH\SOH\SOH\SOH\SOH\SOH\SOH\SOH\SOH\SOH\SOH\SOH\SOH\SOH\SOH\SOH\SOH\GS\SOH\GS\GS\GS\GS\GS\SOH\GS\GS\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\GS\GS\GS\GS\GS\GS\GS\ETX\DC1\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\ENQ\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\GS\GS\GS\GS\GS\GS\GS\GS\GS\EOT\EOT\EOT\EOT\EOT\EOT\EOT\GS\EOT\EOT\EOT\EOT\EOT\EOT\EOT\GS\EOT\EOT\EOT\EOT\EOT\EOT\EOT\GS\EOT\EOT\EOT\EOT\EOT\EOT\EOT\GS\EOT\EOT\EOT\EOT\EOT\EOT\EOT\GS\EOT\EOT\EOT\EOT\EOT\EOT\EOT\GS\EOT\EOT\EOT\EOT\EOT\EOT\EOT\GS\EOT\EOT\EOT\EOT\EOT\EOT\EOT\GS\ENQ\ENQ\ENQ\ENQ\ENQ\ENQ\ENQ\ENQ\ENQ\ENQ\ENQ\ENQ\ENQ\ENQ\ENQ\ENQ\ENQ\ENQ\ENQ\ENQ\ENQ\ENQ\ENQ\ENQ\ENQ\ENQ\ENQ\ENQ\ENQ\ENQ\ENQ\ENQ\DC1\DC1\SI\DLE\SI\DLE\DC1\DC1\DC1\SI\DLE\DC1\SI\DLE\DC1\DC1\DC1\DC1\DC1\DC1\DC1\DC1\DC1\f\DC1\DC1\f\DC1\SI\DLE\DC1\DC1\SI\DLE\r\SO\r\SO\r\SO\r\SO\DC1\DC1\DC1\DC1\DC1\ETX\DC1\DC1\DC1\DC1\DC1\DC1\DC1\DC1\DC1\DC1\f\f\DC1\DC1\DC1\DC1\f\DC1\r\DC1\DC1\DC1\DC1\DC1\DC1\DC1\DC1\DC1\DC1\DC1\DC1\DC1\NAK\NAK\DC1\DC1\DC1\r\SO\r\SO\r\SO\r\SO\f\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\NAK\NAK\NAK\NAK\NAK\NAK\NAK\NAK\NAK\NAK\NAK\NAK\NAK\NAK\NAK\NAK\NAK\NAK\NAK\NAK\NAK\NAK\NAK\NAK\NAK\NAK\GS\NAK\NAK\NAK\NAK\NAK\NAK\NAK\NAK\NAK\NAK\NAK\NAK\NAK\NAK\NAK\NAK\NAK\NAK\NAK\NAK\NAK\NAK\NAK\NAK\NAK\NAK\NAK\NAK\NAK\NAK\NAK\NAK\NAK\NAK\NAK\NAK\NAK\NAK\NAK\NAK\NAK\NAK\NAK\NAK\NAK\NAK\NAK\NAK\NAK\NAK\NAK\NAK\NAK\NAK\NAK\NAK\NAK\NAK\NAK\NAK\NAK\NAK\NAK\NAK\NAK\NAK\NAK\NAK\NAK\NAK\NAK\NAK\NAK\NAK\NAK\NAK\NAK\NAK\NAK\NAK\NAK\NAK\NAK\NAK\NAK\NAK\NAK\NAK\NAK\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\NAK\NAK\NAK\NAK\NAK\NAK\NAK\NAK\NAK\NAK\NAK\NAK\NAK\NAK\NAK\NAK\NAK\NAK\NAK\NAK\NAK\NAK\NAK\NAK\NAK\NAK\NAK\NAK\NAK\NAK\NAK\NAK\NAK\NAK\NAK\NAK\NAK\NAK\NAK\NAK\NAK\NAK\NAK\NAK\NAK\NAK\NAK\NAK\NAK\NAK\NAK\NAK\NAK\NAK\NAK\NAK\NAK\NAK\NAK\NAK\NAK\NAK\NAK\NAK\NAK\NAK\NAK\NAK\NAK\NAK\NAK\NAK\NAK\NAK\NAK\NAK\NAK\NAK\NAK\NAK\NAK\NAK\NAK\NAK\NAK\NAK\NAK\NAK\NAK\NAK\NAK\NAK\NAK\NAK\NAK\NAK\NAK\NAK\NAK\NAK\NAK\NAK\NAK\NAK\NAK\NAK\NAK\NAK\NAK\NAK\NAK\NAK\NAK\NAK\NAK\NAK\NAK\NAK\NAK\NAK\NAK\NAK\NAK\NAK\NAK\NAK\NAK\NAK\NAK\NAK\NAK\NAK\NAK\NAK\NAK\NAK\NAK\NAK\NAK\NAK\NAK\NAK\NAK\NAK\NAK\NAK\NAK\NAK\NAK\NAK\NAK\NAK\NAK\NAK\NAK\NAK\NAK\NAK\NAK\NAK\NAK\NAK\NAK\NAK\NAK\NAK\NAK\NAK\NAK\NAK\NAK\NAK\NAK\NAK\NAK\NAK\NAK\NAK\NAK\NAK\NAK\NAK\NAK\NAK\NAK\NAK\NAK\NAK\NAK\NAK\NAK\NAK\NAK\NAK\NAK\NAK\NAK\NAK\NAK\NAK\NAK\NAK\NAK\NAK\NAK\NAK\NAK\NAK\NAK\NAK\NAK\NAK\NAK\NAK\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\NAK\NAK\NAK\NAK\NAK\NAK\NAK\NAK\NAK\NAK\NAK\NAK\GS\GS\GS\GS\SYN\DC1\DC1\DC1\NAK\ETX\EOT\t\r\SO\r\SO\r\SO\r\SO\r\SO\NAK\NAK\r\SO\r\SO\r\SO\r\SO\f\r\SO\SO\NAK\t\t\t\t\t\t\t\t\t\ENQ\ENQ\ENQ\ENQ\ACK\ACK\f\ETX\ETX\ETX\ETX\ETX\NAK\NAK\t\t\t\ETX\EOT\DC1\NAK\NAK\GS\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\GS\GS\ENQ\ENQ\DC4\DC4\ETX\ETX\EOT\f\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\DC1\ETX\ETX\ETX\EOT\GS\GS\GS\GS\GS\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\GS\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\GS\NAK\NAK\n\n\n\n\NAK\NAK\NAK\NAK\NAK\NAK\NAK\NAK\NAK\NAK\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\NAK\NAK\NAK\NAK\NAK\NAK\NAK\NAK\NAK\NAK\NAK\NAK\NAK\NAK\NAK\NAK\NAK\NAK\NAK\NAK\NAK\NAK\NAK\NAK\NAK\NAK\NAK\NAK\NAK\NAK\NAK\NAK\NAK\NAK\NAK\NAK\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\NAK\NAK\NAK\NAK\NAK\NAK\NAK\NAK\NAK\NAK\NAK\NAK\NAK\NAK\NAK\NAK\NAK\NAK\NAK\NAK\NAK\NAK\NAK\NAK\NAK\NAK\NAK\NAK\NAK\NAK\NAK\GS\n\n\n\n\n\n\n\n\n\n\NAK\NAK\NAK\NAK\NAK\NAK\NAK\NAK\NAK\NAK\NAK\NAK\NAK\NAK\NAK\NAK\NAK\NAK\NAK\NAK\NAK\NAK\NAK\NAK\NAK\NAK\NAK\NAK\NAK\NAK\n\n\n\n\n\n\n\n\NAK\n\n\n\n\n\n\n\n\n\n\n\n\n\n\n\NAK\NAK\NAK\NAK\NAK\NAK\NAK\NAK\NAK\NAK\NAK\NAK\NAK\NAK\NAK\NAK\NAK\NAK\NAK\NAK\NAK\NAK\NAK\NAK\NAK\NAK\NAK\NAK\NAK\NAK\NAK\NAK\n\n\n\n\n\n\n\n\n\n\NAK\NAK\NAK\NAK\NAK\NAK\NAK\NAK\NAK\NAK\NAK\NAK\NAK\NAK\NAK\NAK\NAK\NAK\NAK\NAK\NAK\NAK\NAK\NAK\NAK\NAK\NAK\NAK\NAK\NAK\NAK\NAK\NAK\NAK\NAK\NAK\NAK\NAK\NAK\n\n\n\n\n\n\n\n\n\n\n\n\n\n\n\NAK\NAK\NAK\NAK\NAK\NAK\NAK\NAK\NAK\NAK\NAK\NAK\NAK\NAK\NAK\NAK\NAK\NAK\NAK\NAK\NAK\NAK\NAK\NAK\NAK\NAK\NAK\NAK\NAK\NAK\NAK\NAK\NAK\NAK\NAK\NAK\NAK\NAK\NAK\NAK\NAK\NAK\NAK\NAK\NAK\NAK\NAK\NAK\NAK\NAK\NAK\NAK\NAK\NAK\NAK\NAK\NAK\NAK\NAK\NAK\NAK\NAK\NAK\NAK\NAK\NAK\NAK\NAK\NAK\NAK\NAK\NAK\NAK\NAK\NAK\NAK\NAK\NAK\NAK\NAK\NAK\NAK\NAK\NAK\NAK\NAK\NAK\NAK\NAK\NAK\NAK\NAK\NAK\NAK\NAK\NAK\NAK\NAK\NAK\NAK\NAK\NAK\NAK\NAK\NAK\NAK\NAK\NAK\NAK\NAK\NAK\NAK\NAK\NAK\NAK\NAK\NAK\NAK\NAK\NAK\NAK\NAK\NAK\NAK\NAK\NAK\NAK\NAK\NAK\NAK\NAK\NAK\NAK\NAK\NAK\NAK\NAK\NAK\NAK\NAK\NAK\NAK\NAK\NAK\NAK\NAK\NAK\NAK\NAK\NAK\NAK\NAK\NAK\NAK\NAK\NAK\NAK\NAK\NAK\NAK\NAK\NAK\NAK\NAK\NAK\NAK\NAK\NAK\NAK\NAK\NAK\NAK\NAK\NAK\NAK\NAK\NAK\NAK\NAK\NAK\NAK\NAK\NAK\NAK\NAK\NAK\NAK\NAK\NAK\NAK\NAK\NAK\NAK\NAK\NAK\NAK\NAK\NAK\NAK\NAK\NAK\NAK\NAK\NAK\NAK\NAK\NAK\NAK\NAK\NAK\NAK\NAK\NAK\NAK\NAK\NAK\NAK\NAK\NAK\NAK\NAK\NAK\NAK\NAK\NAK\NAK\NAK\NAK\NAK\NAK\NAK\NAK\NAK\NAK\NAK\NAK\NAK\NAK\NAK\NAK\NAK\NAK\NAK\NAK\NAK\NAK\NAK\NAK\NAK\NAK\NAK\NAK\NAK\NAK\NAK\NAK\NAK\NAK\NAK\NAK\NAK\NAK\NAK\NAK\NAK\NAK\NAK\NAK\NAK\NAK\NAK\NAK\NAK\NAK\NAK\NAK\NAK\NAK\NAK\NAK\NAK\NAK\NAK\NAK\NAK\NAK\NAK\NAK\NAK\NAK\NAK\NAK\NAK\NAK\NAK\NAK\NAK\NAK\NAK\NAK\NAK\NAK\NAK\NAK\NAK\NAK\NAK\NAK\NAK\NAK\NAK\NAK\NAK\NAK\NAK\NAK\NAK\NAK\NAK\NAK\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\NAK\NAK\NAK\NAK\NAK\NAK\NAK\NAK\NAK\NAK\NAK\NAK\NAK\NAK\NAK\NAK\NAK\NAK\NAK\NAK\NAK\NAK\NAK\NAK\NAK\NAK\NAK\NAK\NAK\NAK\NAK\NAK\NAK\NAK\NAK\NAK\NAK\NAK\NAK\NAK\NAK\NAK\NAK\NAK\NAK\NAK\NAK\NAK\NAK\NAK\NAK\NAK\NAK\NAK\NAK\NAK\NAK\NAK\NAK\NAK\NAK\NAK\NAK\NAK\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\ETX\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\GS\GS\GS\NAK\NAK\NAK\NAK\NAK\NAK\NAK\NAK\NAK\NAK\NAK\NAK\NAK\NAK\NAK\NAK\NAK\NAK\NAK\NAK\NAK\NAK\NAK\NAK\NAK\NAK\NAK\NAK\NAK\NAK\NAK\NAK\NAK\NAK\NAK\NAK\NAK\NAK\NAK\NAK\NAK\NAK\NAK\NAK\NAK\NAK\NAK\NAK\NAK\NAK\NAK\NAK\NAK\NAK\NAK\GS\GS\GS\GS\GS\GS\GS\GS\GS\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\ETX\ETX\ETX\ETX\ETX\ETX\DC1\DC1\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\ETX\DC1\DC1\DC1\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\b\b\b\b\b\b\b\b\b\b\EOT\EOT\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\NUL\SOH\NUL\SOH\NUL\SOH\NUL\SOH\NUL\SOH\NUL\SOH\NUL\SOH\NUL\SOH\NUL\SOH\NUL\SOH\NUL\SOH\NUL\SOH\NUL\SOH\NUL\SOH\NUL\SOH\NUL\SOH\NUL\SOH\NUL\SOH\NUL\SOH\NUL\SOH\NUL\SOH\NUL\SOH\NUL\SOH\EOT\ENQ\a\a\a\DC1\ENQ\ENQ\ENQ\ENQ\ENQ\ENQ\ENQ\ENQ\ENQ\ENQ\DC1\ETX\NUL\SOH\NUL\SOH\NUL\SOH\NUL\SOH\NUL\SOH\NUL\SOH\NUL\SOH\NUL\SOH\NUL\SOH\NUL\SOH\NUL\SOH\NUL\SOH\NUL\SOH\NUL\SOH\ETX\ETX\ENQ\ENQ\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\t\t\t\t\t\t\t\t\t\t\ENQ\ENQ\DC1\DC1\DC1\DC1\DC1\DC1\GS\GS\GS\GS\GS\GS\GS\GS\DC4\DC4\DC4\DC4\DC4\DC4\DC4\DC4\DC4\DC4\DC4\DC4\DC4\DC4\DC4\DC4\DC4\DC4\DC4\DC4\DC4\DC4\DC4\ETX\ETX\ETX\ETX\ETX\ETX\ETX\ETX\ETX\DC4\DC4\NUL\SOH\NUL\SOH\NUL\SOH\NUL\SOH\NUL\SOH\NUL\SOH\NUL\SOH\SOH\SOH\NUL\SOH\NUL\SOH\NUL\SOH\NUL\SOH\NUL\SOH\NUL\SOH\NUL\SOH\NUL\SOH\NUL\SOH\NUL\SOH\NUL\SOH\NUL\SOH\NUL\SOH\NUL\SOH\NUL\SOH\NUL\SOH\NUL\SOH\NUL\SOH\NUL\SOH\NUL\SOH\NUL\SOH\NUL\SOH\NUL\SOH\NUL\SOH\NUL\SOH\NUL\SOH\NUL\SOH\NUL\SOH\NUL\SOH\NUL\SOH\NUL\SOH\ETX\SOH\SOH\SOH\SOH\SOH\SOH\SOH\SOH\NUL\SOH\NUL\SOH\NUL\NUL\SOH\NUL\SOH\NUL\SOH\NUL\SOH\NUL\SOH\ETX\DC4\DC4\NUL\SOH\NUL\SOH\EOT\NUL\SOH\NUL\SOH\SOH\SOH\NUL\SOH\NUL\SOH\NUL\SOH\NUL\SOH\NUL\SOH\NUL\SOH\NUL\SOH\NUL\SOH\NUL\SOH\NUL\SOH\NUL\NUL\NUL\NUL\NUL\SOH\NUL\NUL\NUL\NUL\NUL\SOH\NUL\SOH\NUL\SOH\NUL\SOH\NUL\SOH\NUL\SOH\NUL\SOH\NUL\SOH\NUL\NUL\NUL\NUL\SOH\NUL\SOH\GS\GS\GS\GS\GS\NUL\SOH\GS\SOH\GS\SOH\NUL\SOH\NUL\SOH\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\ETX\ETX\ETX\NUL\SOH\EOT\ETX\ETX\SOH\EOT\EOT\EOT\EOT\EOT\EOT\EOT\ENQ\EOT\EOT\EOT\ENQ\EOT\EOT\EOT\EOT\ENQ\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\ACK\ACK\ENQ\ENQ\ACK\NAK\NAK\NAK\NAK\ENQ\GS\GS\GS\n\n\n\n\n\n\NAK\NAK\DC3\NAK\GS\GS\GS\GS\GS\GS\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\DC1\DC1\DC1\DC1\GS\GS\GS\GS\GS\GS\GS\GS\ACK\ACK\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\ACK\ACK\ACK\ACK\ACK\ACK\ACK\ACK\ACK\ACK\ACK\ACK\ACK\ACK\ACK\ACK\ENQ\ENQ\GS\GS\GS\GS\GS\GS\GS\GS\DC1\DC1\b\b\b\b\b\b\b\b\b\b\GS\GS\GS\GS\GS\GS\ENQ\ENQ\ENQ\ENQ\ENQ\ENQ\ENQ\ENQ\ENQ\ENQ\ENQ\ENQ\ENQ\ENQ\ENQ\ENQ\ENQ\ENQ\EOT\EOT\EOT\EOT\EOT\EOT\DC1\DC1\DC1\EOT\DC1\EOT\EOT\ENQ\b\b\b\b\b\b\b\b\b\b\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\ENQ\ENQ\ENQ\ENQ\ENQ\ENQ\ENQ\ENQ\DC1\DC1\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\ENQ\ENQ\ENQ\ENQ\ENQ\ENQ\ENQ\ENQ\ENQ\ENQ\ENQ\ACK\ACK\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\DC1\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\GS\GS\GS\ENQ\ENQ\ENQ\ACK\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\ENQ\ACK\ACK\ENQ\ENQ\ENQ\ENQ\ACK\ACK\ENQ\ENQ\ACK\ACK\ACK\DC1\DC1\DC1\DC1\DC1\DC1\DC1\DC1\DC1\DC1\DC1\DC1\DC1\GS\ETX\b\b\b\b\b\b\b\b\b\b\GS\GS\GS\GS\DC1\DC1\EOT\EOT\EOT\EOT\EOT\ENQ\ETX\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\b\b\b\b\b\b\b\b\b\b\EOT\EOT\EOT\EOT\EOT\GS\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\ENQ\ENQ\ENQ\ENQ\ENQ\ENQ\ACK\ACK\ENQ\ENQ\ACK\ACK\ENQ\ENQ\GS\GS\GS\GS\GS\GS\GS\GS\GS\EOT\EOT\EOT\ENQ\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\ENQ\ACK\GS\GS\b\b\b\b\b\b\b\b\b\b\GS\GS\DC1\DC1\DC1\DC1\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\ETX\EOT\EOT\EOT\EOT\EOT\EOT\NAK\NAK\NAK\EOT\ACK\ENQ\ACK\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\ENQ\EOT\ENQ\ENQ\ENQ\EOT\EOT\ENQ\ENQ\EOT\EOT\EOT\EOT\EOT\ENQ\ENQ\EOT\ENQ\EOT\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\EOT\EOT\ETX\DC1\DC1\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\ACK\ENQ\ENQ\ACK\ACK\DC1\DC1\EOT\ETX\ETX\ACK\ENQ\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\EOT\EOT\EOT\EOT\EOT\EOT\GS\GS\EOT\EOT\EOT\EOT\EOT\EOT\GS\GS\EOT\EOT\EOT\EOT\EOT\EOT\GS\GS\GS\GS\GS\GS\GS\GS\GS\EOT\EOT\EOT\EOT\EOT\EOT\EOT\GS\EOT\EOT\EOT\EOT\EOT\EOT\EOT\GS\SOH\SOH\SOH\SOH\SOH\SOH\SOH\SOH\SOH\SOH\SOH\SOH\SOH\SOH\SOH\SOH\SOH\SOH\SOH\SOH\SOH\SOH\SOH\SOH\SOH\SOH\SOH\SOH\SOH\SOH\SOH\SOH\SOH\SOH\SOH\SOH\SOH\SOH\SOH\SOH\SOH\SOH\SOH\DC4\ETX\ETX\ETX\ETX\SOH\SOH\SOH\SOH\SOH\SOH\SOH\SOH\SOH\ETX\DC4\DC4\GS\GS\GS\GS\SOH\SOH\SOH\SOH\SOH\SOH\SOH\SOH\SOH\SOH\SOH\SOH\SOH\SOH\SOH\SOH\SOH\SOH\SOH\SOH\SOH\SOH\SOH\SOH\SOH\SOH\SOH\SOH\SOH\SOH\SOH\SOH\SOH\SOH\SOH\SOH\SOH\SOH\SOH\SOH\SOH\SOH\SOH\SOH\SOH\SOH\SOH\SOH\SOH\SOH\SOH\SOH\SOH\SOH\SOH\SOH\SOH\SOH\SOH\SOH\SOH\SOH\SOH\SOH\SOH\SOH\SOH\SOH\SOH\SOH\SOH\SOH\SOH\SOH\SOH\SOH\SOH\SOH\SOH\SOH\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\ACK\ACK\ENQ\ACK\ACK\ENQ\ACK\ACK\DC1\ACK\ENQ\GS\GS\b\b\b\b\b\b\b\b\b\b\GS\GS\GS\GS\GS\GS\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\GS\GS\GS\GS\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\GS\GS\GS\GS\ESC\ESC\ESC\ESC\ESC\ESC\ESC\ESC\ESC\ESC\ESC\ESC\ESC\ESC\ESC\ESC\ESC\ESC\ESC\ESC\ESC\ESC\ESC\ESC\ESC\ESC\ESC\ESC\ESC\ESC\ESC\ESC\ESC\ESC\ESC\ESC\ESC\ESC\ESC\ESC\ESC\ESC\ESC\ESC\ESC\ESC\ESC\ESC\ESC\ESC\ESC\ESC\ESC\ESC\ESC\ESC\ESC\ESC\ESC\ESC\ESC\ESC\ESC\ESC\ESC\ESC\ESC\ESC\ESC\ESC\ESC\ESC\ESC\ESC\ESC\ESC\ESC\ESC\ESC\ESC\ESC\ESC\ESC\ESC\ESC\ESC\ESC\ESC\ESC\ESC\ESC\ESC\ESC\ESC\ESC\ESC\ESC\ESC\ESC\ESC\ESC\ESC\ESC\ESC\ESC\ESC\ESC\ESC\ESC\ESC\ESC\ESC\ESC\ESC\ESC\ESC\ESC\ESC\ESC\ESC\ESC\ESC\ESC\ESC\ESC\ESC\ESC\ESC\ESC\ESC\ESC\ESC\ESC\ESC\ESC\ESC\ESC\ESC\ESC\ESC\ESC\ESC\ESC\ESC\ESC\ESC\ESC\ESC\ESC\ESC\ESC\ESC\ESC\ESC\ESC\ESC\ESC\ESC\ESC\ESC\ESC\ESC\ESC\ESC\ESC\ESC\ESC\ESC\ESC\ESC\ESC\ESC\ESC\ESC\ESC\ESC\ESC\ESC\ESC\ESC\ESC\ESC\ESC\ESC\ESC\ESC\ESC\ESC\ESC\ESC\ESC\ESC\ESC\ESC\ESC\ESC\ESC\ESC\ESC\ESC\ESC\ESC\ESC\ESC\ESC\ESC\ESC\ESC\ESC\ESC\ESC\ESC\ESC\ESC\ESC\ESC\ESC\ESC\ESC\ESC\ESC\ESC\ESC\ESC\ESC\ESC\ESC\ESC\ESC\ESC\ESC\ESC\ESC\ESC\ESC\ESC\ESC\ESC\ESC\ESC\ESC\ESC\ESC\ESC\ESC\ESC\ESC\ESC\ESC\ESC\ESC\ESC\ESC\ESC\ESC\ESC\ESC\ESC\ESC\ESC\ESC\ESC\ESC\ESC\ESC\ESC\ESC\ESC\ESC\ESC\ESC\ESC\ESC\ESC\ESC\ESC\ESC\ESC\ESC\ESC\ESC\ESC\ESC\ESC\ESC\ESC\ESC\ESC\ESC\ESC\ESC\ESC\ESC\ESC\ESC\ESC\ESC\ESC\ESC\ESC\ESC\ESC\ESC\ESC\ESC\ESC\ESC\ESC\ESC\ESC\ESC\ESC\ESC\ESC\ESC\ESC\ESC\ESC\ESC\ESC\ESC\ESC\ESC\ESC\ESC\ESC\ESC\ESC\ESC\ESC\ESC\ESC\ESC\ESC\ESC\ESC\ESC\ESC\ESC\ESC\ESC\ESC\ESC\ESC\ESC\ESC\ESC\ESC\ESC\ESC\ESC\ESC\ESC\ESC\ESC\ESC\ESC\ESC\ESC\ESC\ESC\ESC\ESC\ESC\ESC\ESC\ESC\ESC\ESC\ESC\ESC\ESC\ESC\ESC\ESC\ESC\ESC\ESC\ESC\ESC\ESC\ESC\ESC\ESC\ESC\ESC\ESC\ESC\ESC\ESC\ESC\ESC\ESC\ESC\ESC\ESC\ESC\ESC\ESC\ESC\ESC\ESC\ESC\ESC\ESC\ESC\ESC\ESC\ESC\ESC\ESC\ESC\ESC\ESC\ESC\ESC\ESC\ESC\ESC\ESC\ESC\ESC\ESC\ESC\ESC\ESC\ESC\ESC\ESC\ESC\ESC\ESC\ESC\ESC\ESC\ESC\ESC\ESC\ESC\ESC\ESC\ESC\ESC\ESC\ESC\ESC\ESC\ESC\ESC\ESC\ESC\ESC\ESC\ESC\ESC\ESC\ESC\ESC\ESC\ESC\ESC\ESC\ESC\ESC\ESC\ESC\ESC\ESC\ESC\ESC\ESC\ESC\ESC\ESC\ESC\ESC\ESC\ESC\ESC\ESC\ESC\ESC\ESC\ESC\ESC\ESC\ESC\ESC\ESC\ESC\ESC\ESC\ESC\ESC\ESC\ESC\ESC\ESC\ESC\ESC\ESC\ESC\ESC\ESC\ESC\ESC\ESC\ESC\ESC\ESC\ESC\ESC\ESC\ESC\ESC\ESC\ESC\ESC\ESC\ESC\ESC\ESC\ESC\ESC\ESC\ESC\ESC\ESC\ESC\ESC\ESC\ESC\ESC\ESC\ESC\ESC\ESC\ESC\ESC\ESC\ESC\ESC\ESC\ESC\ESC\ESC\ESC\ESC\ESC\ESC\ESC\ESC\ESC\ESC\ESC\ESC\ESC\ESC\ESC\ESC\ESC\ESC\ESC\ESC\ESC\ESC\ESC\ESC\ESC\ESC\ESC\ESC\ESC\ESC\ESC\ESC\ESC\ESC\ESC\ESC\ESC\ESC\ESC\ESC\ESC\ESC\ESC\ESC\ESC\ESC\ESC\ESC\ESC\ESC\ESC\ESC\ESC\ESC\ESC\ESC\ESC\ESC\ESC\ESC\ESC\ESC\ESC\ESC\ESC\ESC\ESC\ESC\ESC\ESC\ESC\ESC\ESC\ESC\ESC\ESC\ESC\ESC\ESC\ESC\ESC\ESC\ESC\ESC\ESC\ESC\ESC\ESC\ESC\ESC\ESC\ESC\ESC\ESC\ESC\ESC\ESC\ESC\ESC\ESC\ESC\ESC\ESC\ESC\ESC\ESC\ESC\ESC\ESC\ESC\ESC\ESC\ESC\ESC\ESC\ESC\ESC\ESC\ESC\ESC\ESC\ESC\ESC\ESC\ESC\ESC\ESC\ESC\ESC\ESC\ESC\ESC\ESC\ESC\ESC\ESC\ESC\ESC\ESC\ESC\ESC\ESC\ESC\ESC\ESC\ESC\ESC\ESC\ESC\ESC\ESC\ESC\ESC\ESC\ESC\ESC\ESC\ESC\ESC\ESC\ESC\ESC\ESC\ESC\ESC\ESC\ESC\ESC\ESC\ESC\ESC\ESC\ESC\ESC\ESC\ESC\ESC\ESC\ESC\ESC\ESC\ESC\ESC\ESC\ESC\ESC\ESC\ESC\ESC\ESC\ESC\ESC\ESC\ESC\ESC\ESC\ESC\ESC\ESC\ESC\ESC\ESC\ESC\ESC\ESC\ESC\ESC\ESC\ESC\ESC\ESC\ESC\ESC\ESC\ESC\ESC\ESC\ESC\ESC\ESC\ESC\ESC\ESC\ESC\ESC\ESC\ESC\ESC\ESC\ESC\ESC\ESC\ESC\ESC\ESC\ESC\ESC\ESC\ESC\ESC\ESC\ESC\ESC\ESC\ESC\ESC\ESC\ESC\ESC\ESC\ESC\ESC\ESC\ESC\ESC\ESC\ESC\ESC\ESC\ESC\ESC\ESC\ESC\ESC\ESC\ESC\ESC\ESC\ESC\ESC\ESC\ESC\ESC\ESC\ESC\ESC\ESC\ESC\ESC\ESC\ESC\ESC\ESC\ESC\ESC\ESC\ESC\ESC\ESC\ESC\ESC\ESC\ESC\ESC\ESC\ESC\ESC\ESC\ESC\ESC\ESC\ESC\ESC\ESC\ESC\ESC\ESC\ESC\ESC\ESC\ESC\ESC\ESC\ESC\ESC\ESC\ESC\ESC\ESC\ESC\ESC\ESC\ESC\ESC\ESC\ESC\ESC\ESC\ESC\ESC\ESC\ESC\ESC\ESC\ESC\ESC\ESC\ESC\ESC\ESC\ESC\ESC\ESC\ESC\ESC\ESC\ESC\ESC\ESC\ESC\ESC\ESC\ESC\ESC\ESC\ESC\ESC\ESC\ESC\ESC\ESC\ESC\ESC\ESC\ESC\ESC\ESC\ESC\ESC\ESC\ESC\ESC\ESC\ESC\ESC\ESC\ESC\ESC\ESC\ESC\ESC\ESC\ESC\ESC\ESC\ESC\ESC\ESC\ESC\ESC\ESC\ESC\ESC\ESC\ESC\ESC\ESC\ESC\ESC\ESC\ESC\ESC\ESC\ESC\ESC\ESC\ESC\ESC\ESC\ESC\ESC\ESC\ESC\ESC\ESC\ESC\ESC\ESC\ESC\ESC\ESC\ESC\ESC\ESC\ESC\ESC\ESC\ESC\ESC\ESC\ESC\ESC\ESC\ESC\ESC\ESC\ESC\ESC\ESC\ESC\ESC\ESC\ESC\ESC\ESC\ESC\ESC\ESC\ESC\ESC\ESC\ESC\ESC\ESC\ESC\ESC\ESC\ESC\ESC\ESC\ESC\ESC\ESC\ESC\ESC\ESC\ESC\ESC\ESC\ESC\ESC\ESC\ESC\ESC\ESC\ESC\ESC\ESC\ESC\ESC\ESC\ESC\ESC\ESC\ESC\ESC\ESC\ESC\ESC\ESC\ESC\ESC\ESC\ESC\ESC\ESC\ESC\ESC\ESC\ESC\ESC\ESC\ESC\ESC\ESC\ESC\ESC\ESC\ESC\ESC\ESC\ESC\ESC\ESC\ESC\ESC\ESC\ESC\ESC\ESC\ESC\ESC\ESC\ESC\ESC\ESC\ESC\ESC\ESC\ESC\ESC\ESC\ESC\ESC\ESC\ESC\ESC\ESC\ESC\ESC\ESC\ESC\ESC\ESC\ESC\ESC\ESC\ESC\ESC\ESC\ESC\ESC\ESC\ESC\ESC\ESC\ESC\ESC\ESC\ESC\ESC\ESC\ESC\ESC\ESC\ESC\ESC\ESC\ESC\ESC\ESC\ESC\ESC\ESC\ESC\ESC\ESC\ESC\ESC\ESC\ESC\ESC\ESC\ESC\ESC\ESC\ESC\ESC\ESC\ESC\ESC\ESC\ESC\ESC\ESC\ESC\ESC\ESC\ESC\ESC\ESC\ESC\ESC\ESC\ESC\ESC\ESC\ESC\ESC\ESC\ESC\ESC\ESC\ESC\ESC\ESC\ESC\ESC\ESC\ESC\ESC\ESC\ESC\ESC\ESC\ESC\ESC\ESC\ESC\ESC\ESC\ESC\ESC\ESC\ESC\ESC\ESC\ESC\ESC\ESC\ESC\ESC\ESC\ESC\ESC\ESC\ESC\ESC\ESC\ESC\ESC\ESC\ESC\ESC\ESC\ESC\ESC\ESC\ESC\ESC\ESC\ESC\ESC\ESC\ESC\ESC\ESC\ESC\ESC\ESC\ESC\ESC\ESC\ESC\ESC\ESC\ESC\ESC\ESC\ESC\ESC\ESC\ESC\ESC\ESC\ESC\ESC\ESC\ESC\ESC\ESC\ESC\ESC\ESC\ESC\ESC\ESC\ESC\ESC\ESC\ESC\ESC\ESC\ESC\ESC\ESC\ESC\ESC\ESC\ESC\ESC\ESC\ESC\ESC\ESC\ESC\ESC\ESC\ESC\ESC\ESC\ESC\ESC\ESC\ESC\ESC\ESC\ESC\ESC\ESC\ESC\ESC\ESC\ESC\ESC\ESC\ESC\ESC\ESC\ESC\ESC\ESC\ESC\ESC\ESC\ESC\ESC\ESC\ESC\ESC\ESC\ESC\ESC\ESC\ESC\ESC\ESC\ESC\ESC\ESC\ESC\ESC\ESC\ESC\ESC\ESC\ESC\ESC\ESC\ESC\ESC\ESC\ESC\ESC\ESC\ESC\ESC\ESC\ESC\ESC\ESC\ESC\ESC\ESC\ESC\ESC\ESC\ESC\ESC\ESC\ESC\ESC\ESC\ESC\ESC\ESC\ESC\ESC\ESC\ESC\ESC\ESC\ESC\ESC\ESC\ESC\ESC\ESC\ESC\ESC\ESC\ESC\ESC\ESC\ESC\ESC\ESC\ESC\ESC\ESC\ESC\ESC\ESC\ESC\ESC\ESC\ESC\ESC\ESC\ESC\ESC\ESC\ESC\ESC\ESC\ESC\ESC\ESC\ESC\ESC\ESC\ESC\ESC\ESC\ESC\ESC\ESC\ESC\ESC\ESC\ESC\ESC\ESC\ESC\ESC\ESC\ESC\ESC\ESC\ESC\ESC\ESC\ESC\ESC\ESC\ESC\ESC\ESC\ESC\ESC\ESC\ESC\ESC\ESC\ESC\ESC\ESC\ESC\ESC\ESC\ESC\ESC\ESC\ESC\ESC\ESC\ESC\ESC\ESC\ESC\ESC\ESC\ESC\ESC\ESC\ESC\ESC\ESC\ESC\ESC\ESC\ESC\ESC\ESC\ESC\ESC\ESC\ESC\ESC\ESC\ESC\ESC\ESC\ESC\ESC\ESC\ESC\ESC\ESC\ESC\ESC\ESC\ESC\ESC\ESC\ESC\ESC\ESC\ESC\ESC\ESC\ESC\ESC\ESC\ESC\ESC\ESC\ESC\ESC\ESC\ESC\ESC\ESC\ESC\ESC\ESC\ESC\ESC\ESC\ESC\ESC\ESC\ESC\ESC\ESC\ESC\ESC\ESC\ESC\ESC\ESC\ESC\ESC\ESC\ESC\ESC\ESC\ESC\ESC\ESC\ESC\ESC\ESC\ESC\ESC\ESC\ESC\ESC\ESC\ESC\ESC\ESC\ESC\ESC\ESC\ESC\ESC\ESC\ESC\ESC\ESC\ESC\ESC\ESC\ESC\ESC\ESC\ESC\ESC\ESC\ESC\ESC\ESC\ESC\ESC\ESC\ESC\ESC\ESC\ESC\ESC\ESC\ESC\ESC\ESC\ESC\ESC\ESC\ESC\ESC\ESC\ESC\ESC\ESC\ESC\ESC\ESC\ESC\ESC\ESC\ESC\ESC\ESC\ESC\ESC\ESC\ESC\ESC\ESC\ESC\ESC\ESC\ESC\ESC\ESC\ESC\ESC\ESC\ESC\ESC\ESC\ESC\ESC\ESC\ESC\ESC\ESC\ESC\ESC\ESC\ESC\ESC\ESC\ESC\ESC\ESC\ESC\ESC\ESC\ESC\ESC\ESC\ESC\ESC\ESC\ESC\ESC\ESC\ESC\ESC\ESC\ESC\ESC\ESC\ESC\ESC\ESC\ESC\ESC\ESC\ESC\ESC\ESC\ESC\ESC\ESC\ESC\ESC\ESC\ESC\ESC\ESC\ESC\ESC\ESC\ESC\ESC\ESC\ESC\ESC\ESC\ESC\ESC\ESC\ESC\ESC\ESC\ESC\ESC\ESC\ESC\ESC\ESC\ESC\ESC\ESC\ESC\ESC\ESC\ESC\ESC\ESC\ESC\ESC\ESC\ESC\ESC\ESC\ESC\ESC\ESC\ESC\ESC\ESC\ESC\ESC\ESC\ESC\ESC\ESC\ESC\ESC\ESC\ESC\ESC\ESC\ESC\ESC\ESC\ESC\ESC\ESC\ESC\ESC\ESC\ESC\ESC\ESC\ESC\ESC\ESC\ESC\ESC\ESC\ESC\ESC\ESC\ESC\ESC\ESC\ESC\ESC\ESC\ESC\ESC\ESC\ESC\ESC\ESC\ESC\ESC\ESC\ESC\ESC\ESC\ESC\ESC\ESC\ESC\ESC\ESC\ESC\ESC\ESC\ESC\ESC\ESC\ESC\ESC\ESC\ESC\ESC\ESC\ESC\ESC\ESC\ESC\ESC\ESC\ESC\ESC\ESC\ESC\ESC\ESC\ESC\ESC\ESC\ESC\ESC\ESC\ESC\ESC\ESC\ESC\ESC\ESC\ESC\ESC\ESC\ESC\ESC\ESC\ESC\ESC\ESC\ESC\ESC\ESC\ESC\ESC\ESC\ESC\ESC\ESC\ESC\ESC\ESC\ESC\ESC\ESC\ESC\ESC\ESC\ESC\ESC\ESC\ESC\ESC\ESC\ESC\ESC\ESC\ESC\ESC\ESC\ESC\ESC\ESC\ESC\ESC\ESC\ESC\ESC\ESC\ESC\ESC\ESC\ESC\ESC\ESC\ESC\ESC\ESC\ESC\ESC\ESC\ESC\ESC\ESC\ESC\ESC\ESC\ESC\ESC\ESC\ESC\ESC\ESC\ESC\ESC\ESC\ESC\ESC\ESC\ESC\ESC\ESC\ESC\ESC\ESC\ESC\ESC\ESC\ESC\ESC\ESC\ESC\ESC\ESC\ESC\ESC\ESC\ESC\ESC\ESC\ESC\ESC\ESC\ESC\ESC\ESC\ESC\ESC\ESC\ESC\ESC\ESC\ESC\ESC\ESC\ESC\ESC\ESC\ESC\ESC\ESC\ESC\ESC\ESC\ESC\ESC\ESC\ESC\ESC\ESC\ESC\ESC\ESC\ESC\ESC\ESC\ESC\ESC\ESC\ESC\ESC\ESC\ESC\ESC\ESC\ESC\ESC\ESC\ESC\ESC\ESC\ESC\ESC\ESC\ESC\ESC\ESC\ESC\ESC\ESC\ESC\ESC\ESC\ESC\ESC\ESC\ESC\ESC\ESC\ESC\ESC\ESC\ESC\ESC\ESC\ESC\ESC\ESC\ESC\ESC\ESC\ESC\ESC\ESC\ESC\ESC\ESC\ESC\ESC\ESC\ESC\ESC\ESC\ESC\ESC\ESC\ESC\ESC\ESC\ESC\ESC\ESC\ESC\ESC\ESC\ESC\ESC\ESC\ESC\ESC\ESC\ESC\ESC\ESC\ESC\ESC\ESC\ESC\ESC\ESC\ESC\ESC\ESC\ESC\ESC\ESC\ESC\ESC\ESC\ESC\ESC\ESC\ESC\ESC\ESC\ESC\ESC\ESC\ESC\ESC\ESC\ESC\ESC\ESC\ESC\ESC\ESC\ESC\ESC\ESC\ESC\ESC\ESC\ESC\ESC\ESC\ESC\ESC\ESC\ESC\ESC\ESC\ESC\ESC\ESC\ESC\ESC\ESC\FS\FS\FS\FS\FS\FS\FS\FS\FS\FS\FS\FS\FS\FS\FS\FS\FS\FS\FS\FS\FS\FS\FS\FS\FS\FS\FS\FS\FS\FS\FS\FS\FS\FS\FS\FS\FS\FS\FS\FS\FS\FS\FS\FS\FS\FS\FS\FS\FS\FS\FS\FS\FS\FS\FS\FS\FS\FS\FS\FS\FS\FS\FS\FS\FS\FS\FS\FS\FS\FS\FS\FS\FS\FS\FS\FS\FS\FS\FS\FS\FS\FS\FS\FS\FS\FS\FS\FS\FS\FS\FS\FS\FS\FS\FS\FS\FS\FS\FS\FS\FS\FS\FS\FS\FS\FS\FS\FS\FS\FS\FS\FS\FS\FS\FS\FS\FS\FS\FS\FS\FS\FS\FS\FS\FS\FS\FS\FS\FS\FS\FS\FS\FS\FS\FS\FS\FS\FS\FS\FS\FS\FS\FS\FS\FS\FS\FS\FS\FS\FS\FS\FS\FS\FS\FS\FS\FS\FS\FS\FS\FS\FS\FS\FS\FS\FS\FS\FS\FS\FS\FS\FS\FS\FS\FS\FS\FS\FS\FS\FS\FS\FS\FS\FS\FS\FS\FS\FS\FS\FS\FS\FS\FS\FS\FS\FS\FS\FS\FS\FS\FS\FS\FS\FS\FS\FS\FS\FS\FS\FS\FS\FS\FS\FS\FS\FS\FS\FS\FS\FS\FS\FS\FS\FS\FS\FS\FS\FS\FS\FS\FS\FS\FS\FS\FS\FS\FS\FS\FS\FS\FS\FS\FS\FS\FS\FS\FS\FS\FS\FS\FS\FS\FS\FS\FS\FS\FS\FS\FS\FS\FS\FS\FS\FS\FS\FS\FS\FS\FS\FS\FS\FS\FS\FS\FS\FS\FS\FS\FS\FS\FS\FS\FS\FS\FS\FS\FS\FS\FS\FS\FS\FS\FS\FS\FS\FS\FS\FS\FS\FS\FS\FS\FS\FS\FS\FS\FS\FS\FS\FS\FS\FS\FS\FS\FS\FS\FS\FS\FS\FS\FS\FS\FS\FS\FS\FS\FS\FS\FS\FS\FS\FS\FS\FS\FS\FS\FS\FS\FS\FS\FS\FS\FS\FS\FS\FS\FS\FS\FS\FS\FS\FS\FS\FS\FS\FS\FS\FS\FS\FS\FS\FS\FS\FS\FS\FS\FS\FS\FS\FS\FS\FS\FS\FS\FS\FS\FS\FS\FS\FS\FS\FS\FS\FS\FS\FS\FS\FS\FS\FS\FS\FS\FS\FS\FS\FS\FS\FS\FS\FS\FS\FS\FS\FS\FS\FS\FS\FS\FS\FS\FS\FS\FS\FS\FS\FS\FS\FS\FS\FS\FS\FS\FS\FS\FS\FS\FS\FS\FS\FS\FS\FS\FS\FS\FS\FS\FS\FS\FS\FS\FS\FS\FS\FS\FS\FS\FS\FS\FS\FS\FS\FS\FS\FS\FS\FS\FS\FS\FS\FS\FS\FS\FS\FS\FS\FS\FS\FS\FS\FS\FS\FS\FS\FS\FS\FS\FS\FS\FS\FS\FS\FS\FS\FS\FS\FS\FS\FS\FS\FS\FS\FS\FS\FS\FS\FS\FS\FS\FS\FS\FS\FS\FS\FS\FS\FS\FS\FS\FS\FS\FS\FS\FS\FS\FS\FS\FS\FS\FS\FS\FS\FS\FS\FS\FS\FS\FS\FS\FS\FS\FS\FS\FS\FS\FS\FS\FS\FS\FS\FS\FS\FS\FS\FS\FS\FS\FS\FS\FS\FS\FS\FS\FS\FS\FS\FS\FS\FS\FS\FS\FS\FS\FS\FS\FS\FS\FS\FS\FS\FS\FS\FS\FS\FS\FS\FS\FS\FS\FS\FS\FS\FS\FS\FS\FS\FS\FS\FS\FS\FS\FS\FS\FS\FS\FS\FS\FS\FS\FS\FS\FS\FS\FS\FS\FS\FS\FS\FS\FS\FS\FS\FS\FS\FS\FS\FS\FS\FS\FS\FS\FS\FS\FS\FS\FS\FS\FS\FS\FS\FS\FS\FS\FS\FS\FS\FS\FS\FS\FS\FS\FS\FS\FS\FS\FS\FS\FS\FS\FS\FS\FS\FS\FS\FS\FS\FS\FS\FS\FS\FS\FS\FS\FS\FS\FS\FS\FS\FS\FS\FS\FS\FS\FS\FS\FS\FS\FS\FS\FS\FS\FS\FS\FS\FS\FS\FS\FS\FS\FS\FS\FS\FS\FS\FS\FS\FS\FS\FS\FS\FS\FS\FS\FS\FS\FS\FS\FS\FS\FS\FS\FS\FS\FS\FS\FS\FS\FS\FS\FS\FS\FS\FS\FS\FS\FS\FS\FS\FS\FS\FS\FS\FS\FS\FS\FS\FS\FS\FS\FS\FS\FS\FS\FS\FS\FS\FS\FS\FS\FS\FS\FS\FS\FS\FS\FS\FS\FS\FS\FS\FS\FS\FS\FS\FS\FS\FS\FS\FS\FS\FS\FS\FS\FS\FS\FS\FS\FS\FS\FS\FS\FS\FS\FS\FS\FS\FS\FS\FS\FS\FS\FS\FS\FS\FS\FS\FS\FS\FS\FS\FS\FS\FS\FS\FS\FS\FS\FS\FS\FS\FS\FS\FS\FS\FS\FS\FS\FS\FS\FS\FS\FS\FS\FS\FS\FS\FS\FS\FS\FS\FS\FS\FS\FS\FS\FS\FS\FS\FS\FS\FS\FS\FS\FS\FS\FS\FS\FS\FS\FS\FS\FS\FS\FS\FS\FS\FS\FS\FS\FS\FS\FS\FS\FS\FS\FS\FS\FS\FS\FS\FS\FS\FS\FS\FS\FS\FS\FS\FS\FS\FS\FS\FS\FS\FS\FS\FS\FS\FS\FS\FS\FS\FS\FS\FS\FS\FS\FS\FS\FS\FS\FS\FS\FS\FS\FS\FS\FS\FS\FS\FS\FS\FS\FS\FS\FS\FS\FS\FS\FS\FS\FS\FS\FS\FS\FS\FS\FS\FS\FS\FS\FS\FS\FS\FS\FS\FS\FS\FS\FS\FS\FS\FS\FS\FS\FS\FS\FS\FS\FS\FS\FS\FS\FS\FS\FS\FS\FS\FS\FS\FS\FS\FS\FS\FS\FS\FS\FS\FS\FS\FS\FS\FS\FS\FS\FS\FS\FS\FS\FS\FS\FS\FS\FS\FS\FS\FS\FS\FS\FS\FS\FS\FS\FS\FS\FS\FS\FS\FS\FS\FS\FS\FS\FS\FS\FS\FS\FS\FS\FS\FS\FS\FS\FS\FS\FS\FS\FS\FS\FS\FS\FS\FS\FS\FS\FS\FS\FS\FS\FS\FS\FS\FS\FS\FS\FS\FS\FS\FS\FS\FS\FS\FS\FS\FS\FS\FS\FS\FS\FS\FS\FS\FS\FS\FS\FS\FS\FS\FS\FS\FS\FS\FS\FS\FS\FS\FS\FS\FS\FS\FS\FS\FS\FS\FS\FS\FS\FS\FS\FS\FS\FS\FS\FS\FS\FS\FS\FS\FS\FS\FS\FS\FS\FS\FS\FS\FS\FS\FS\FS\FS\FS\FS\FS\FS\FS\FS\FS\FS\FS\FS\FS\FS\FS\FS\FS\FS\FS\FS\FS\FS\FS\FS\FS\FS\FS\FS\FS\FS\FS\FS\FS\FS\FS\FS\FS\FS\FS\FS\FS\FS\FS\FS\FS\FS\FS\FS\FS\FS\FS\FS\FS\FS\FS\FS\FS\FS\FS\FS\FS\FS\FS\FS\FS\FS\FS\FS\FS\FS\FS\FS\FS\FS\FS\FS\FS\FS\FS\FS\FS\FS\FS\FS\FS\FS\FS\FS\FS\FS\FS\FS\FS\FS\FS\FS\FS\FS\FS\FS\FS\FS\FS\FS\FS\FS\FS\FS\FS\FS\FS\FS\FS\FS\FS\FS\FS\FS\FS\FS\FS\FS\FS\FS\FS\FS\FS\FS\FS\FS\FS\FS\FS\FS\FS\FS\FS\FS\FS\FS\FS\FS\FS\FS\FS\FS\FS\FS\FS\FS\FS\FS\FS\FS\FS\FS\FS\FS\FS\FS\FS\FS\FS\FS\FS\FS\FS\FS\FS\FS\FS\FS\FS\FS\FS\FS\FS\FS\FS\FS\FS\FS\FS\FS\FS\FS\FS\FS\FS\FS\FS\FS\FS\FS\FS\FS\FS\FS\FS\FS\FS\FS\FS\FS\FS\FS\FS\FS\FS\FS\FS\FS\FS\FS\FS\FS\FS\FS\FS\FS\FS\FS\FS\FS\FS\FS\FS\FS\FS\FS\FS\FS\FS\FS\FS\FS\FS\FS\FS\FS\FS\FS\FS\FS\FS\FS\FS\FS\FS\FS\FS\FS\FS\FS\FS\FS\FS\FS\FS\FS\FS\FS\FS\FS\FS\FS\FS\FS\FS\FS\FS\FS\FS\FS\FS\FS\FS\FS\FS\FS\FS\FS\FS\FS\FS\FS\FS\FS\FS\FS\FS\FS\FS\FS\FS\FS\FS\FS\FS\FS\FS\FS\FS\FS\FS\FS\FS\FS\FS\FS\FS\FS\FS\FS\FS\FS\FS\FS\FS\FS\FS\FS\FS\FS\FS\FS\FS\FS\FS\FS\FS\FS\FS\FS\FS\FS\FS\FS\FS\FS\FS\FS\FS\FS\FS\FS\FS\FS\FS\FS\FS\FS\FS\FS\FS\FS\FS\FS\FS\FS\FS\FS\FS\FS\FS\FS\FS\FS\FS\FS\FS\FS\FS\FS\FS\FS\FS\FS\FS\FS\FS\FS\FS\FS\FS\FS\FS\FS\FS\FS\FS\FS\FS\FS\FS\FS\FS\FS\FS\FS\FS\FS\FS\FS\FS\FS\FS\FS\FS\FS\FS\FS\FS\FS\FS\FS\FS\FS\FS\FS\FS\FS\FS\FS\FS\FS\FS\FS\FS\FS\FS\FS\FS\FS\FS\FS\FS\FS\FS\FS\FS\FS\FS\FS\FS\FS\FS\FS\FS\FS\FS\FS\FS\FS\FS\FS\FS\FS\FS\FS\FS\FS\FS\FS\FS\FS\FS\FS\FS\FS\FS\FS\FS\FS\FS\FS\FS\FS\FS\FS\FS\FS\FS\FS\FS\FS\FS\FS\FS\FS\FS\FS\FS\FS\FS\FS\FS\FS\FS\FS\FS\FS\FS\FS\FS\FS\FS\FS\FS\FS\FS\FS\FS\FS\FS\FS\FS\FS\FS\FS\FS\FS\FS\FS\FS\FS\FS\FS\FS\FS\FS\FS\FS\FS\FS\FS\FS\FS\FS\FS\FS\FS\FS\FS\FS\FS\FS\FS\FS\FS\FS\FS\FS\FS\FS\FS\FS\FS\FS\FS\FS\FS\FS\FS\FS\FS\FS\FS\FS\FS\FS\FS\FS\FS\FS\FS\FS\FS\FS\FS\FS\FS\FS\FS\FS\FS\FS\FS\FS\FS\FS\FS\FS\FS\FS\FS\FS\FS\FS\FS\FS\FS\FS\FS\FS\FS\FS\FS\FS\FS\FS\FS\FS\FS\FS\FS\FS\FS\FS\FS\FS\FS\FS\FS\FS\FS\FS\FS\FS\FS\FS\FS\FS\FS\FS\FS\FS\FS\FS\FS\FS\FS\FS\FS\FS\FS\FS\FS\FS\FS\FS\FS\FS\FS\FS\FS\FS\FS\FS\FS\FS\FS\FS\FS\FS\FS\FS\FS\FS\FS\FS\FS\FS\FS\FS\FS\FS\FS\FS\FS\FS\FS\FS\FS\FS\FS\FS\FS\FS\FS\FS\FS\FS\FS\FS\FS\FS\FS\FS\FS\FS\FS\FS\FS\FS\FS\FS\FS\FS\FS\FS\FS\FS\FS\FS\FS\FS\FS\FS\FS\FS\FS\FS\FS\FS\FS\FS\FS\FS\FS\FS\FS\FS\FS\FS\FS\FS\FS\FS\FS\FS\FS\FS\FS\FS\FS\FS\FS\FS\FS\FS\FS\FS\FS\FS\FS\FS\FS\FS\FS\FS\FS\FS\FS\FS\FS\FS\FS\FS\FS\FS\FS\FS\FS\FS\FS\FS\FS\FS\FS\FS\FS\FS\FS\FS\FS\FS\FS\FS\FS\FS\FS\FS\FS\FS\FS\FS\FS\FS\FS\FS\FS\FS\FS\FS\FS\FS\FS\FS\FS\FS\FS\FS\FS\FS\FS\FS\FS\FS\FS\FS\FS\FS\FS\FS\FS\FS\FS\FS\FS\FS\FS\FS\FS\FS\FS\FS\FS\FS\FS\FS\FS\FS\FS\FS\FS\FS\FS\FS\FS\FS\FS\FS\FS\FS\FS\FS\FS\FS\FS\FS\FS\FS\FS\FS\FS\FS\FS\FS\FS\FS\FS\FS\FS\FS\FS\FS\FS\FS\FS\FS\FS\FS\FS\FS\FS\FS\FS\FS\FS\FS\FS\FS\FS\FS\FS\FS\FS\FS\FS\FS\FS\FS\FS\FS\FS\FS\FS\FS\FS\FS\FS\FS\FS\FS\FS\FS\FS\FS\FS\FS\FS\FS\FS\FS\FS\FS\FS\FS\FS\FS\FS\FS\FS\FS\FS\FS\FS\FS\FS\FS\FS\FS\FS\FS\FS\FS\FS\FS\FS\FS\FS\FS\FS\FS\FS\FS\FS\FS\FS\FS\FS\FS\FS\FS\FS\FS\FS\FS\FS\FS\FS\FS\FS\FS\FS\FS\FS\FS\FS\FS\FS\FS\FS\FS\FS\FS\FS\FS\FS\FS\FS\FS\FS\FS\FS\FS\FS\FS\FS\FS\FS\FS\FS\FS\FS\FS\FS\FS\FS\FS\FS\FS\FS\FS\FS\FS\FS\FS\FS\FS\FS\FS\FS\FS\FS\FS\FS\FS\FS\FS\FS\FS\FS\FS\FS\FS\FS\FS\FS\FS\FS\FS\FS\FS\FS\FS\FS\FS\FS\FS\FS\FS\FS\FS\FS\FS\FS\FS\FS\FS\FS\FS\FS\FS\FS\FS\FS\FS\FS\FS\FS\FS\FS\FS\FS\FS\FS\FS\FS\FS\FS\FS\FS\FS\FS\FS\FS\FS\FS\FS\FS\FS\FS\FS\FS\FS\FS\FS\FS\FS\FS\FS\FS\FS\FS\FS\FS\FS\FS\FS\FS\FS\FS\FS\FS\FS\FS\FS\FS\FS\FS\FS\FS\FS\FS\FS\FS\FS\FS\FS\FS\FS\FS\FS\FS\FS\FS\FS\FS\FS\FS\FS\FS\FS\FS\FS\FS\FS\FS\FS\FS\FS\FS\FS\FS\FS\FS\FS\FS\FS\FS\FS\FS\FS\FS\FS\FS\FS\FS\FS\FS\FS\FS\FS\FS\FS\FS\FS\FS\FS\FS\FS\FS\FS\FS\FS\FS\FS\FS\FS\FS\FS\FS\FS\FS\FS\FS\FS\FS\FS\FS\FS\FS\FS\FS\FS\FS\FS\FS\FS\FS\FS\FS\FS\FS\FS\FS\FS\FS\FS\FS\FS\FS\FS\FS\FS\FS\FS\FS\FS\FS\FS\FS\FS\FS\FS\FS\FS\FS\FS\FS\FS\FS\FS\FS\FS\FS\FS\FS\FS\FS\FS\FS\FS\FS\FS\FS\FS\FS\FS\FS\FS\FS\FS\FS\FS\FS\FS\FS\FS\FS\FS\FS\FS\FS\FS\FS\FS\FS\FS\FS\FS\FS\FS\FS\FS\FS\FS\FS\FS\FS\FS\FS\FS\FS\FS\FS\FS\FS\FS\FS\FS\FS\FS\FS\FS\FS\FS\FS\FS\FS\FS\FS\FS\FS\FS\FS\FS\FS\FS\FS\FS\FS\FS\FS\FS\FS\FS\FS\FS\FS\FS\FS\FS\FS\FS\FS\FS\FS\FS\FS\FS\FS\FS\FS\FS\FS\FS\FS\FS\FS\FS\FS\FS\FS\FS\FS\FS\FS\FS\FS\FS\FS\FS\FS\FS\FS\FS\FS\FS\FS\FS\FS\FS\FS\FS\FS\FS\FS\FS\FS\FS\FS\FS\FS\FS\FS\FS\FS\FS\FS\FS\FS\FS\FS\FS\FS\FS\FS\FS\FS\FS\FS\FS\FS\FS\FS\FS\FS\FS\FS\FS\FS\FS\FS\FS\FS\FS\FS\FS\FS\FS\FS\FS\FS\FS\FS\FS\FS\FS\FS\FS\FS\FS\FS\FS\FS\FS\FS\FS\FS\FS\FS\FS\FS\FS\FS\FS\FS\FS\FS\FS\FS\FS\FS\FS\FS\FS\FS\FS\FS\FS\FS\FS\FS\FS\FS\FS\FS\FS\FS\FS\FS\FS\FS\FS\FS\FS\FS\FS\FS\FS\FS\FS\FS\FS\FS\FS\FS\FS\FS\FS\FS\FS\FS\FS\FS\FS\FS\FS\FS\FS\FS\FS\FS\FS\FS\FS\FS\FS\FS\FS\FS\FS\FS\FS\FS\FS\FS\FS\FS\FS\FS\FS\FS\FS\FS\FS\FS\FS\FS\FS\FS\FS\FS\FS\FS\FS\FS\FS\FS\FS\FS\FS\FS\FS\FS\FS\FS\FS\FS\FS\FS\FS\FS\FS\FS\FS\FS\FS\FS\FS\FS\FS\FS\FS\FS\FS\FS\FS\FS\FS\FS\FS\FS\FS\FS\FS\FS\FS\FS\FS\FS\FS\FS\FS\FS\FS\FS\FS\FS\FS\FS\FS\FS\FS\FS\FS\FS\FS\FS\FS\FS\FS\FS\FS\FS\FS\FS\FS\FS\FS\FS\FS\FS\FS\FS\FS\FS\FS\FS\FS\FS\FS\FS\FS\FS\FS\FS\FS\FS\FS\FS\FS\FS\FS\FS\FS\FS\FS\FS\FS\FS\FS\FS\FS\FS\FS\FS\FS\FS\FS\FS\FS\FS\FS\FS\FS\FS\FS\FS\FS\FS\FS\FS\FS\FS\FS\FS\FS\FS\FS\FS\FS\FS\FS\FS\FS\FS\FS\FS\FS\FS\FS\FS\FS\FS\FS\FS\FS\FS\FS\FS\FS\FS\FS\FS\FS\FS\FS\FS\FS\FS\FS\FS\FS\FS\FS\FS\FS\FS\FS\FS\FS\FS\FS\FS\FS\FS\FS\FS\FS\FS\FS\FS\FS\FS\FS\FS\FS\FS\FS\FS\FS\FS\FS\FS\FS\FS\FS\FS\FS\FS\FS\FS\FS\FS\FS\FS\FS\FS\FS\FS\FS\FS\FS\FS\FS\FS\FS\FS\FS\FS\FS\FS\FS\FS\FS\FS\FS\FS\FS\FS\FS\FS\FS\FS\FS\FS\FS\FS\FS\FS\FS\FS\FS\FS\FS\FS\FS\FS\FS\FS\FS\FS\FS\FS\FS\FS\FS\FS\FS\FS\FS\FS\FS\FS\FS\FS\FS\FS\FS\FS\FS\FS\FS\FS\FS\FS\FS\FS\FS\FS\FS\FS\FS\FS\FS\FS\FS\FS\FS\FS\FS\FS\FS\FS\FS\FS\FS\FS\FS\FS\FS\FS\FS\FS\FS\FS\FS\FS\FS\FS\FS\FS\FS\FS\FS\FS\FS\FS\FS\FS\FS\FS\FS\FS\FS\FS\FS\FS\FS\FS\FS\FS\FS\FS\FS\FS\FS\FS\FS\FS\FS\FS\FS\FS\FS\FS\FS\FS\FS\FS\FS\FS\FS\FS\FS\FS\FS\FS\FS\FS\FS\FS\FS\FS\FS\FS\FS\FS\FS\FS\FS\FS\FS\FS\FS\FS\FS\FS\FS\FS\FS\FS\FS\FS\FS\FS\FS\FS\FS\FS\FS\FS\FS\FS\FS\FS\FS\FS\FS\FS\FS\FS\FS\FS\FS\FS\FS\FS\FS\FS\FS\FS\FS\FS\FS\FS\FS\FS\FS\FS\FS\FS\FS\FS\FS\FS\FS\FS\FS\FS\FS\FS\FS\FS\FS\FS\FS\FS\FS\FS\FS\FS\FS\FS\FS\FS\FS\FS\FS\FS\FS\FS\FS\FS\FS\FS\FS\FS\FS\FS\FS\FS\FS\FS\FS\FS\FS\FS\FS\FS\FS\FS\FS\FS\FS\FS\FS\FS\FS\FS\FS\FS\FS\FS\FS\FS\FS\FS\FS\FS\FS\FS\FS\FS\FS\FS\FS\FS\FS\FS\FS\FS\FS\FS\FS\FS\FS\FS\FS\FS\FS\FS\FS\FS\FS\FS\FS\FS\FS\FS\FS\FS\FS\FS\FS\FS\FS\FS\FS\FS\FS\FS\FS\FS\FS\FS\FS\FS\FS\FS\FS\FS\FS\FS\FS\FS\FS\FS\FS\FS\FS\FS\FS\FS\FS\FS\FS\FS\FS\FS\FS\FS\FS\FS\FS\FS\FS\FS\FS\FS\FS\FS\FS\FS\FS\FS\FS\FS\FS\FS\FS\FS\FS\FS\FS\FS\FS\FS\FS\FS\FS\FS\FS\FS\FS\FS\FS\FS\FS\FS\FS\FS\FS\FS\FS\FS\FS\FS\FS\FS\FS\FS\FS\FS\FS\FS\FS\FS\FS\FS\FS\FS\FS\FS\FS\FS\FS\FS\FS\FS\FS\FS\FS\FS\FS\FS\FS\FS\FS\FS\FS\FS\FS\FS\FS\FS\FS\FS\FS\FS\FS\FS\FS\FS\FS\FS\FS\FS\FS\FS\FS\FS\FS\FS\FS\FS\FS\FS\FS\FS\FS\FS\FS\FS\FS\FS\FS\FS\FS\FS\FS\FS\FS\FS\FS\FS\FS\FS\FS\FS\FS\FS\FS\FS\FS\FS\FS\FS\FS\FS\FS\FS\FS\FS\FS\FS\FS\FS\FS\FS\FS\FS\FS\FS\FS\FS\FS\FS\FS\FS\FS\FS\FS\FS\FS\FS\FS\FS\FS\FS\FS\FS\FS\FS\FS\FS\FS\FS\FS\FS\FS\FS\FS\FS\FS\FS\FS\FS\FS\FS\FS\FS\FS\FS\FS\FS\FS\FS\FS\FS\FS\FS\FS\FS\FS\FS\FS\FS\FS\FS\FS\FS\FS\FS\FS\FS\FS\FS\FS\FS\FS\FS\FS\FS\FS\FS\FS\FS\FS\FS\FS\FS\FS\FS\FS\FS\FS\FS\FS\FS\FS\FS\FS\FS\FS\FS\FS\FS\FS\FS\FS\FS\FS\FS\FS\FS\FS\FS\FS\FS\FS\FS\FS\FS\FS\FS\FS\FS\FS\FS\FS\FS\FS\FS\FS\FS\FS\FS\FS\FS\FS\FS\FS\FS\FS\FS\FS\FS\FS\FS\FS\FS\FS\FS\FS\FS\FS\FS\FS\FS\FS\FS\FS\FS\FS\FS\FS\FS\FS\FS\FS\FS\FS\FS\FS\FS\FS\FS\FS\FS\FS\FS\FS\FS\FS\FS\FS\FS\FS\FS\FS\FS\FS\FS\FS\FS\FS\FS\FS\FS\FS\FS\FS\FS\FS\FS\FS\FS\FS\FS\FS\FS\FS\FS\FS\FS\FS\FS\FS\FS\FS\FS\FS\FS\FS\FS\FS\FS\FS\FS\FS\FS\FS\FS\FS\FS\FS\FS\FS\FS\FS\FS\FS\FS\FS\FS\FS\FS\FS\FS\FS\FS\FS\FS\FS\FS\FS\FS\FS\FS\FS\FS\FS\FS\FS\FS\FS\FS\FS\FS\FS\FS\FS\FS\FS\FS\FS\FS\FS\FS\FS\FS\FS\FS\FS\FS\FS\FS\FS\FS\FS\FS\FS\FS\FS\FS\FS\FS\FS\FS\FS\FS\FS\FS\FS\FS\FS\FS\FS\FS\FS\FS\FS\FS\FS\FS\FS\FS\FS\FS\FS\FS\FS\FS\FS\FS\FS\FS\FS\FS\FS\FS\FS\FS\FS\FS\FS\FS\FS\FS\FS\FS\FS\FS\FS\FS\FS\FS\FS\FS\FS\FS\FS\FS\FS\FS\FS\FS\FS\FS\FS\FS\FS\FS\FS\FS\FS\FS\FS\FS\FS\FS\FS\FS\FS\FS\FS\FS\FS\FS\FS\FS\FS\FS\FS\FS\FS\FS\FS\FS\FS\FS\FS\FS\FS\FS\FS\FS\FS\FS\FS\FS\FS\FS\FS\FS\FS\FS\FS\FS\FS\FS\FS\FS\FS\FS\FS\FS\FS\FS\FS\FS\FS\FS\FS\FS\FS\FS\FS\FS\FS\FS\FS\FS\FS\FS\FS\FS\FS\FS\FS\FS\FS\FS\FS\FS\FS\FS\FS\FS\FS\FS\FS\FS\FS\FS\FS\FS\FS\FS\FS\FS\FS\FS\FS\FS\FS\FS\FS\FS\FS\FS\FS\FS\FS\FS\FS\FS\FS\FS\FS\FS\FS\FS\FS\FS\FS\FS\FS\FS\FS\FS\FS\FS\FS\FS\FS\FS\FS\FS\FS\FS\FS\FS\FS\FS\FS\FS\FS\FS\FS\FS\FS\FS\FS\FS\FS\FS\FS\FS\FS\FS\FS\FS\FS\FS\FS\FS\FS\FS\FS\FS\FS\FS\FS\FS\FS\FS\FS\FS\FS\FS\FS\FS\FS\FS\FS\FS\FS\FS\FS\FS\FS\FS\FS\FS\FS\FS\FS\FS\FS\FS\FS\FS\FS\FS\FS\FS\FS\FS\FS\FS\FS\FS\FS\FS\FS\FS\FS\FS\FS\FS\FS\FS\FS\FS\FS\FS\FS\FS\FS\FS\FS\FS\FS\FS\FS\FS\FS\FS\FS\FS\FS\FS\FS\FS\FS\FS\FS\FS\FS\FS\FS\FS\FS\FS\FS\FS\FS\FS\FS\FS\FS\FS\FS\FS\FS\FS\FS\FS\FS\FS\FS\FS\FS\FS\FS\FS\FS\FS\FS\FS\FS\FS\FS\FS\FS\FS\FS\FS\FS\FS\FS\FS\FS\FS\FS\FS\FS\FS\FS\FS\FS\FS\FS\FS\FS\FS\FS\FS\FS\FS\FS\FS\FS\FS\FS\FS\FS\FS\FS\FS\FS\FS\FS\FS\FS\FS\FS\FS\FS\FS\FS\FS\FS\FS\FS\FS\FS\FS\FS\FS\FS\FS\FS\FS\FS\FS\FS\FS\FS\FS\FS\FS\FS\FS\FS\FS\FS\FS\FS\FS\FS\FS\FS\FS\FS\FS\FS\FS\FS\FS\FS\FS\FS\FS\FS\FS\FS\FS\FS\FS\FS\FS\FS\FS\FS\FS\FS\FS\FS\FS\FS\FS\FS\FS\FS\FS\FS\FS\FS\FS\FS\FS\FS\FS\FS\FS\FS\FS\FS\FS\FS\FS\FS\FS\FS\FS\FS\FS\FS\FS\FS\FS\FS\FS\FS\FS\FS\FS\FS\FS\FS\FS\FS\FS\FS\FS\FS\FS\FS\FS\FS\FS\FS\FS\FS\FS\FS\FS\FS\FS\FS\FS\FS\FS\FS\FS\FS\FS\FS\FS\FS\FS\FS\FS\FS\FS\FS\FS\FS\FS\FS\FS\FS\FS\FS\FS\FS\FS\FS\FS\FS\FS\FS\FS\FS\FS\FS\FS\FS\FS\FS\FS\FS\FS\FS\FS\FS\FS\FS\FS\FS\FS\FS\FS\FS\FS\FS\FS\FS\FS\FS\FS\FS\FS\FS\FS\FS\FS\FS\FS\FS\FS\FS\FS\FS\FS\FS\FS\FS\FS\FS\FS\FS\FS\FS\FS\FS\FS\FS\FS\FS\FS\FS\FS\FS\FS\FS\FS\FS\FS\FS\FS\FS\FS\FS\FS\FS\FS\FS\FS\FS\FS\FS\FS\FS\FS\FS\FS\FS\FS\FS\FS\FS\FS\FS\FS\FS\FS\FS\FS\FS\FS\FS\FS\FS\FS\FS\FS\FS\FS\FS\FS\FS\FS\FS\FS\FS\FS\FS\FS\FS\FS\FS\FS\FS\FS\FS\FS\FS\FS\FS\FS\FS\FS\FS\FS\FS\FS\FS\FS\FS\FS\FS\FS\FS\FS\FS\FS\FS\FS\FS\FS\FS\FS\FS\FS\FS\FS\FS\FS\FS\FS\FS\FS\FS\FS\FS\FS\FS\FS\FS\FS\FS\FS\FS\FS\FS\FS\FS\FS\FS\FS\FS\FS\FS\FS\FS\FS\FS\FS\FS\FS\FS\FS\FS\FS\FS\FS\FS\FS\FS\FS\FS\FS\FS\FS\FS\FS\FS\FS\FS\FS\FS\FS\FS\FS\FS\FS\FS\FS\FS\FS\FS\FS\FS\FS\FS\FS\FS\FS\FS\FS\FS\FS\FS\FS\FS\FS\FS\FS\FS\FS\FS\FS\FS\FS\FS\FS\FS\FS\FS\FS\FS\FS\FS\FS\FS\FS\FS\FS\FS\FS\FS\FS\FS\FS\FS\FS\FS\FS\FS\FS\FS\FS\FS\FS\FS\FS\FS\FS\FS\FS\FS\FS\FS\FS\FS\FS\FS\FS\FS\FS\FS\FS\FS\FS\FS\FS\FS\FS\FS\FS\FS\FS\FS\FS\FS\FS\FS\FS\FS\FS\FS\FS\FS\FS\FS\FS\FS\FS\FS\FS\FS\FS\FS\FS\FS\FS\FS\FS\FS\FS\FS\FS\FS\FS\FS\FS\FS\FS\FS\FS\FS\FS\FS\FS\FS\FS\FS\FS\FS\FS\FS\FS\FS\FS\FS\FS\FS\FS\FS\FS\FS\FS\FS\FS\FS\FS\FS\FS\FS\FS\FS\FS\FS\FS\FS\FS\FS\FS\FS\FS\FS\FS\FS\FS\FS\FS\FS\FS\FS\FS\FS\FS\FS\FS\FS\FS\FS\FS\FS\FS\FS\FS\FS\FS\FS\FS\FS\FS\FS\FS\FS\FS\FS\FS\FS\FS\FS\FS\FS\FS\FS\FS\FS\FS\FS\FS\FS\FS\FS\FS\FS\FS\FS\FS\FS\FS\FS\FS\FS\FS\FS\FS\FS\FS\FS\FS\FS\FS\FS\FS\FS\FS\FS\FS\FS\FS\FS\FS\FS\FS\FS\FS\FS\FS\FS\FS\FS\FS\FS\FS\FS\FS\FS\FS\FS\FS\FS\FS\FS\FS\FS\FS\FS\FS\FS\FS\FS\FS\FS\FS\FS\FS\FS\FS\FS\FS\FS\FS\FS\FS\FS\FS\FS\FS\FS\FS\FS\FS\FS\FS\FS\FS\FS\FS\FS\FS\FS\FS\FS\FS\FS\FS\FS\FS\FS\FS\FS\FS\FS\FS\FS\FS\FS\FS\FS\FS\FS\FS\FS\FS\FS\FS\FS\FS\FS\FS\FS\FS\FS\FS\FS\FS\FS\FS\FS\FS\FS\FS\FS\FS\FS\FS\FS\FS\FS\FS\FS\FS\FS\FS\FS\FS\FS\FS\FS\FS\FS\FS\FS\FS\FS\FS\FS\FS\FS\FS\FS\FS\FS\FS\FS\FS\FS\FS\FS\FS\FS\FS\FS\FS\FS\FS\FS\FS\FS\FS\FS\FS\FS\FS\FS\FS\FS\FS\FS\FS\FS\FS\FS\FS\FS\FS\FS\FS\FS\FS\FS\FS\FS\FS\FS\FS\FS\FS\FS\FS\FS\FS\FS\FS\FS\FS\FS\FS\FS\FS\FS\FS\FS\FS\FS\FS\FS\FS\FS\FS\FS\FS\FS\FS\FS\FS\FS\FS\FS\FS\FS\FS\FS\FS\FS\FS\FS\FS\FS\FS\FS\FS\FS\FS\FS\FS\FS\FS\FS\FS\FS\FS\FS\FS\FS\FS\FS\FS\FS\FS\FS\FS\FS\FS\FS\FS\FS\FS\FS\FS\FS\FS\FS\FS\FS\FS\FS\FS\FS\FS\FS\FS\FS\FS\FS\FS\FS\FS\FS\FS\FS\FS\FS\FS\FS\FS\FS\FS\FS\FS\FS\FS\FS\FS\FS\FS\FS\FS\FS\FS\FS\FS\FS\FS\FS\FS\FS\FS\FS\FS\FS\FS\FS\FS\FS\FS\FS\FS\FS\FS\FS\FS\FS\FS\FS\FS\FS\FS\FS\FS\FS\FS\FS\FS\FS\FS\FS\FS\FS\FS\FS\FS\FS\FS\FS\FS\FS\FS\FS\FS\FS\FS\FS\FS\FS\FS\FS\FS\FS\FS\FS\FS\FS\FS\FS\FS\FS\FS\FS\FS\FS\FS\FS\FS\FS\FS\FS\FS\FS\FS\FS\FS\FS\FS\FS\FS\FS\FS\FS\FS\FS\FS\FS\FS\FS\FS\FS\FS\FS\FS\FS\FS\FS\FS\FS\FS\FS\FS\FS\FS\FS\FS\FS\FS\FS\FS\FS\FS\FS\FS\FS\FS\FS\FS\FS\FS\FS\FS\FS\FS\FS\FS\FS\FS\FS\FS\FS\FS\FS\FS\FS\FS\FS\FS\FS\FS\FS\FS\FS\FS\FS\FS\FS\FS\FS\FS\FS\FS\FS\FS\FS\FS\FS\FS\FS\FS\FS\FS\FS\FS\FS\FS\FS\FS\FS\FS\FS\FS\FS\FS\FS\FS\FS\FS\FS\FS\FS\FS\FS\FS\FS\FS\FS\FS\FS\FS\FS\FS\FS\FS\FS\FS\FS\FS\FS\FS\FS\FS\FS\FS\FS\FS\FS\FS\FS\FS\FS\FS\FS\FS\FS\FS\FS\FS\FS\FS\FS\FS\FS\FS\FS\FS\FS\FS\FS\FS\FS\FS\FS\FS\FS\FS\FS\FS\FS\FS\FS\FS\FS\FS\FS\FS\FS\FS\FS\FS\FS\FS\FS\FS\FS\FS\FS\FS\FS\FS\FS\FS\FS\FS\FS\FS\FS\FS\FS\FS\FS\FS\FS\FS\FS\FS\FS\FS\FS\FS\FS\FS\FS\FS\FS\FS\FS\FS\FS\FS\FS\FS\FS\FS\FS\FS\FS\FS\FS\FS\FS\FS\FS\FS\FS\FS\FS\FS\FS\FS\FS\FS\FS\FS\FS\FS\FS\FS\FS\FS\FS\FS\FS\FS\FS\FS\FS\FS\FS\FS\FS\FS\FS\FS\FS\FS\FS\FS\FS\FS\FS\FS\FS\FS\FS\FS\FS\FS\FS\FS\FS\FS\FS\FS\FS\FS\FS\FS\FS\FS\FS\FS\FS\FS\FS\FS\FS\FS\FS\FS\FS\FS\FS\FS\FS\FS\FS\FS\FS\FS\FS\FS\FS\FS\FS\FS\FS\FS\FS\FS\FS\FS\FS\FS\FS\FS\FS\FS\FS\FS\FS\FS\FS\FS\FS\FS\FS\FS\FS\FS\FS\FS\FS\FS\FS\FS\FS\FS\FS\FS\FS\FS\FS\FS\FS\FS\FS\FS\FS\FS\FS\FS\FS\FS\FS\FS\FS\FS\FS\FS\FS\FS\FS\FS\FS\FS\FS\FS\FS\FS\FS\FS\FS\FS\FS\FS\FS\FS\FS\FS\FS\FS\FS\FS\FS\FS\FS\FS\FS\FS\FS\FS\FS\FS\FS\FS\FS\FS\FS\FS\FS\FS\FS\FS\FS\FS\FS\FS\FS\FS\FS\FS\FS\FS\FS\FS\FS\FS\FS\FS\FS\FS\FS\FS\FS\FS\FS\FS\FS\FS\FS\FS\FS\FS\FS\FS\FS\FS\FS\FS\FS\FS\FS\FS\FS\FS\FS\FS\FS\FS\FS\FS\FS\FS\FS\FS\FS\FS\FS\FS\FS\FS\FS\FS\FS\FS\FS\FS\FS\FS\FS\FS\FS\FS\FS\FS\FS\FS\FS\FS\FS\FS\FS\FS\FS\FS\FS\FS\FS\FS\FS\FS\FS\FS\FS\FS\FS\FS\FS\FS\FS\FS\FS\FS\FS\FS\FS\FS\FS\FS\FS\FS\FS\FS\FS\FS\FS\FS\FS\FS\FS\FS\FS\FS\FS\FS\FS\FS\FS\FS\FS\FS\FS\FS\FS\FS\FS\FS\FS\FS\FS\FS\FS\FS\FS\FS\FS\FS\FS\FS\FS\FS\FS\FS\FS\FS\FS\FS\FS\FS\FS\FS\FS\FS\FS\FS\FS\FS\FS\FS\FS\FS\FS\FS\FS\FS\FS\FS\FS\FS\FS\FS\FS\FS\FS\FS\FS\FS\FS\FS\FS\FS\FS\FS\FS\FS\FS\FS\FS\FS\FS\FS\FS\FS\FS\FS\FS\FS\FS\FS\FS\FS\FS\FS\FS\FS\FS\FS\FS\FS\FS\FS\FS\FS\FS\FS\FS\FS\FS\FS\FS\FS\FS\FS\FS\FS\FS\FS\FS\FS\FS\FS\FS\FS\FS\FS\FS\FS\FS\FS\FS\FS\FS\FS\FS\FS\FS\FS\FS\FS\FS\FS\FS\FS\FS\FS\FS\FS\FS\FS\FS\FS\FS\FS\FS\FS\FS\FS\FS\FS\FS\FS\FS\FS\FS\FS\FS\FS\FS\FS\FS\FS\FS\FS\FS\FS\FS\FS\FS\FS\FS\FS\FS\FS\FS\FS\FS\FS\FS\FS\FS\FS\FS\FS\FS\FS\FS\FS\FS\FS\FS\FS\FS\FS\FS\FS\FS\FS\FS\FS\FS\FS\FS\FS\FS\FS\FS\FS\FS\FS\FS\FS\FS\FS\FS\FS\FS\FS\FS\FS\FS\FS\FS\FS\FS\FS\FS\FS\FS\FS\FS\FS\FS\FS\FS\FS\FS\FS\FS\FS\FS\FS\FS\FS\FS\FS\FS\FS\FS\FS\FS\FS\FS\FS\FS\FS\FS\FS\FS\FS\FS\FS\FS\FS\FS\FS\FS\FS\FS\FS\FS\FS\FS\FS\FS\FS\FS\FS\FS\FS\FS\FS\FS\FS\FS\FS\FS\FS\FS\FS\FS\FS\FS\FS\FS\FS\FS\FS\FS\FS\FS\FS\FS\FS\FS\FS\FS\FS\FS\FS\FS\FS\FS\FS\FS\FS\FS\FS\FS\FS\FS\FS\FS\FS\FS\FS\FS\FS\FS\FS\FS\FS\FS\FS\FS\FS\FS\FS\FS\FS\FS\FS\FS\FS\FS\FS\FS\FS\FS\FS\FS\FS\FS\FS\FS\FS\FS\FS\FS\FS\FS\FS\FS\FS\FS\FS\FS\FS\FS\FS\FS\FS\FS\FS\FS\FS\FS\FS\FS\FS\FS\FS\FS\FS\FS\FS\FS\FS\FS\FS\FS\FS\FS\FS\FS\FS\FS\FS\FS\FS\FS\FS\FS\FS\FS\FS\FS\FS\FS\FS\FS\FS\FS\FS\FS\FS\FS\FS\FS\FS\FS\FS\FS\FS\FS\FS\FS\FS\FS\FS\FS\FS\FS\FS\FS\FS\FS\FS\FS\FS\FS\FS\FS\FS\FS\FS\FS\FS\FS\FS\FS\FS\FS\FS\FS\FS\FS\FS\FS\FS\FS\FS\FS\FS\FS\FS\FS\FS\FS\FS\FS\FS\FS\FS\FS\FS\FS\FS\FS\FS\FS\FS\FS\FS\FS\FS\FS\FS\FS\FS\FS\FS\FS\FS\FS\FS\FS\FS\FS\FS\FS\FS\FS\FS\FS\FS\FS\FS\FS\FS\FS\FS\FS\FS\FS\FS\FS\FS\FS\FS\FS\FS\FS\FS\FS\FS\FS\FS\FS\FS\FS\FS\FS\FS\FS\FS\FS\FS\FS\FS\FS\FS\FS\FS\FS\FS\FS\FS\FS\FS\FS\FS\FS\FS\FS\FS\FS\FS\FS\FS\FS\FS\FS\FS\FS\FS\FS\FS\FS\FS\FS\FS\FS\FS\FS\FS\FS\FS\FS\FS\FS\FS\FS\FS\FS\FS\FS\FS\FS\FS\FS\FS\FS\FS\FS\FS\FS\FS\FS\FS\FS\FS\FS\FS\FS\FS\FS\FS\FS\FS\FS\FS\FS\FS\FS\FS\FS\FS\FS\FS\FS\FS\FS\FS\FS\FS\FS\FS\FS\FS\FS\FS\FS\FS\FS\FS\FS\FS\FS\FS\FS\FS\FS\FS\FS\FS\FS\FS\FS\FS\FS\FS\FS\FS\FS\FS\FS\FS\FS\FS\FS\FS\FS\FS\FS\FS\FS\FS\FS\FS\FS\FS\FS\FS\FS\FS\FS\FS\FS\FS\FS\FS\FS\FS\FS\FS\FS\FS\FS\FS\FS\FS\FS\FS\FS\FS\FS\FS\FS\FS\FS\FS\FS\FS\FS\FS\FS\FS\FS\FS\FS\FS\FS\FS\FS\FS\FS\FS\FS\FS\FS\FS\FS\FS\FS\FS\FS\FS\FS\FS\FS\FS\FS\FS\FS\FS\FS\FS\FS\FS\FS\FS\FS\FS\FS\FS\FS\FS\FS\FS\FS\FS\FS\FS\FS\FS\FS\FS\FS\FS\FS\FS\FS\FS\FS\FS\FS\FS\FS\FS\FS\FS\FS\FS\FS\FS\FS\FS\FS\FS\FS\FS\FS\FS\FS\FS\FS\FS\FS\FS\FS\FS\FS\FS\FS\FS\FS\FS\FS\FS\FS\FS\FS\FS\FS\FS\FS\FS\FS\FS\FS\FS\FS\FS\FS\FS\FS\FS\FS\FS\FS\FS\FS\FS\FS\FS\FS\FS\FS\FS\FS\FS\FS\FS\FS\FS\FS\FS\FS\FS\FS\FS\FS\FS\FS\FS\FS\FS\FS\FS\FS\FS\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\GS\GS\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\SOH\SOH\SOH\SOH\SOH\SOH\SOH\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\SOH\SOH\SOH\SOH\SOH\GS\GS\GS\GS\GS\EOT\ENQ\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\DC2\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\GS\EOT\EOT\EOT\EOT\EOT\GS\EOT\GS\EOT\EOT\GS\EOT\EOT\GS\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\DC4\DC4\DC4\DC4\DC4\DC4\DC4\DC4\DC4\DC4\DC4\DC4\DC4\DC4\DC4\DC4\DC4\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\SO\r\NAK\NAK\NAK\NAK\NAK\NAK\NAK\NAK\NAK\NAK\NAK\NAK\NAK\NAK\NAK\NAK\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\GS\GS\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\GS\GS\GS\GS\GS\GS\GS\NAK\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\DC3\NAK\NAK\NAK\ENQ\ENQ\ENQ\ENQ\ENQ\ENQ\ENQ\ENQ\ENQ\ENQ\ENQ\ENQ\ENQ\ENQ\ENQ\ENQ\DC1\DC1\DC1\DC1\DC1\DC1\DC1\r\SO\DC1\GS\GS\GS\GS\GS\GS\ENQ\ENQ\ENQ\ENQ\ENQ\ENQ\ENQ\ENQ\ENQ\ENQ\ENQ\ENQ\ENQ\ENQ\ENQ\ENQ\DC1\f\f\v\v\r\SO\r\SO\r\SO\r\SO\r\SO\r\SO\r\SO\r\SO\DC1\DC1\r\SO\DC1\DC1\DC1\DC1\v\v\v\DC1\DC1\DC1\GS\DC1\DC1\DC1\DC1\f\r\SO\r\SO\r\SO\DC1\DC1\DC1\DC2\f\DC2\DC2\DC2\GS\DC1\DC3\DC1\DC1\GS\GS\GS\GS\EOT\EOT\EOT\EOT\EOT\GS\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\GS\GS\SUB\GS\DC1\DC1\DC1\DC3\DC1\DC1\DC1\r\SO\DC1\DC2\DC1\f\DC1\DC1\b\b\b\b\b\b\b\b\b\b\DC1\DC1\DC2\DC2\DC2\DC1\DC1\NUL\NUL\NUL\NUL\NUL\NUL\NUL\NUL\NUL\NUL\NUL\NUL\NUL\NUL\NUL\NUL\NUL\NUL\NUL\NUL\NUL\NUL\NUL\NUL\NUL\NUL\r\DC1\SO\DC4\v\DC4\SOH\SOH\SOH\SOH\SOH\SOH\SOH\SOH\SOH\SOH\SOH\SOH\SOH\SOH\SOH\SOH\SOH\SOH\SOH\SOH\SOH\SOH\SOH\SOH\SOH\SOH\r\DC2\SO\DC2\r\SO\DC1\r\SO\DC1\DC1\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\ETX\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\ETX\ETX\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\GS\GS\GS\EOT\EOT\EOT\EOT\EOT\EOT\GS\GS\EOT\EOT\EOT\EOT\EOT\EOT\GS\GS\EOT\EOT\EOT\EOT\EOT\EOT\GS\GS\EOT\EOT\EOT\GS\GS\GS\DC3\DC3\DC2\DC4\NAK\DC3\DC3\GS\NAK\DC2\DC2\DC2\DC2\NAK\NAK\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\SUB\SUB\SUB\NAK\NAK\GS\GS\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\GS\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\GS\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\GS\EOT\EOT\GS\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\GS\GS\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\GS\GS\GS\GS\GS\DC1\DC1\DC1\GS\GS\GS\GS\n\n\n\n\n\n\n\n\n\n\n\n\n\n\n\n\n\n\n\n\n\n\n\n\n\n\n\n\n\n\n\n\n\n\n\n\n\n\n\n\n\n\n\n\n\GS\GS\GS\NAK\NAK\NAK\NAK\NAK\NAK\NAK\NAK\NAK\t\t\t\t\t\t\t\t\t\t\t\t\t\t\t\t\t\t\t\t\t\t\t\t\t\t\t\t\t\t\t\t\t\t\t\t\t\t\t\t\t\t\t\t\t\t\t\t\t\t\t\t\t\n\n\n\n\NAK\NAK\NAK\NAK\NAK\NAK\NAK\NAK\NAK\NAK\NAK\NAK\NAK\NAK\NAK\NAK\NAK\n\n\NAK\NAK\NAK\GS\NAK\NAK\NAK\NAK\NAK\NAK\NAK\NAK\NAK\NAK\NAK\NAK\NAK\GS\GS\GS\NAK\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\NAK\NAK\NAK\NAK\NAK\NAK\NAK\NAK\NAK\NAK\NAK\NAK\NAK\NAK\NAK\NAK\NAK\NAK\NAK\NAK\NAK\NAK\NAK\NAK\NAK\NAK\NAK\NAK\NAK\NAK\NAK\NAK\NAK\NAK\NAK\NAK\NAK\NAK\NAK\NAK\NAK\NAK\NAK\NAK\NAK\ENQ\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\GS\GS\GS\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\ENQ\n\n\n\n\n\n\n\n\n\n\n\n\n\n\n\n\n\n\n\n\n\n\n\n\n\n\n\GS\GS\GS\GS\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\n\n\n\n\GS\GS\GS\GS\GS\GS\GS\GS\GS\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\t\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\t\GS\GS\GS\GS\GS\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\ENQ\ENQ\ENQ\ENQ\ENQ\GS\GS\GS\GS\GS\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\GS\DC1\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\GS\GS\GS\GS\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\DC1\t\t\t\t\t\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\NUL\NUL\NUL\NUL\NUL\NUL\NUL\NUL\NUL\NUL\NUL\NUL\NUL\NUL\NUL\NUL\NUL\NUL\NUL\NUL\NUL\NUL\NUL\NUL\NUL\NUL\NUL\NUL\NUL\NUL\NUL\NUL\NUL\NUL\NUL\NUL\NUL\NUL\NUL\NUL\SOH\SOH\SOH\SOH\SOH\SOH\SOH\SOH\SOH\SOH\SOH\SOH\SOH\SOH\SOH\SOH\SOH\SOH\SOH\SOH\SOH\SOH\SOH\SOH\SOH\SOH\SOH\SOH\SOH\SOH\SOH\SOH\SOH\SOH\SOH\SOH\SOH\SOH\SOH\SOH\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\GS\GS\b\b\b\b\b\b\b\b\b\b\GS\GS\GS\GS\GS\GS\NUL\NUL\NUL\NUL\NUL\NUL\NUL\NUL\NUL\NUL\NUL\NUL\NUL\NUL\NUL\NUL\NUL\NUL\NUL\NUL\NUL\NUL\NUL\NUL\NUL\NUL\NUL\NUL\NUL\NUL\NUL\NUL\NUL\NUL\NUL\NUL\GS\GS\GS\GS\SOH\SOH\SOH\SOH\SOH\SOH\SOH\SOH\SOH\SOH\SOH\SOH\SOH\SOH\SOH\SOH\SOH\SOH\SOH\SOH\SOH\SOH\SOH\SOH\SOH\SOH\SOH\SOH\SOH\SOH\SOH\SOH\SOH\SOH\SOH\SOH\GS\GS\GS\GS\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\GS\GS\GS\GS\GS\GS\GS\GS\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\DC1\NUL\NUL\NUL\NUL\NUL\NUL\NUL\NUL\NUL\NUL\NUL\GS\NUL\NUL\NUL\NUL\NUL\NUL\NUL\NUL\NUL\NUL\NUL\NUL\NUL\NUL\NUL\GS\NUL\NUL\NUL\NUL\NUL\NUL\NUL\GS\NUL\NUL\GS\SOH\SOH\SOH\SOH\SOH\SOH\SOH\SOH\SOH\SOH\SOH\GS\SOH\SOH\SOH\SOH\SOH\SOH\SOH\SOH\SOH\SOH\SOH\SOH\SOH\SOH\SOH\GS\SOH\SOH\SOH\SOH\SOH\SOH\SOH\GS\SOH\SOH\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\GS\GS\GS\GS\GS\GS\GS\GS\GS\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\ETX\ETX\ETX\ETX\ETX\ETX\GS\ETX\ETX\ETX\ETX\ETX\ETX\ETX\ETX\ETX\ETX\ETX\ETX\ETX\ETX\ETX\ETX\ETX\ETX\ETX\ETX\ETX\ETX\ETX\ETX\ETX\ETX\ETX\ETX\ETX\ETX\ETX\ETX\ETX\ETX\ETX\ETX\ETX\ETX\ETX\ETX\ETX\ETX\GS\ETX\ETX\ETX\ETX\ETX\ETX\ETX\ETX\ETX\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\EOT\EOT\EOT\EOT\EOT\EOT\GS\GS\EOT\GS\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\GS\EOT\EOT\GS\GS\GS\EOT\GS\GS\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\GS\DC1\n\n\n\n\n\n\n\n\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\NAK\NAK\n\n\n\n\n\n\n\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\GS\GS\GS\GS\GS\GS\GS\GS\n\n\n\n\n\n\n\n\n\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\GS\EOT\EOT\GS\GS\GS\GS\GS\n\n\n\n\n\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\n\n\n\n\n\n\GS\GS\GS\DC1\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\GS\GS\GS\GS\GS\DC1\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\GS\GS\GS\GS\n\n\EOT\EOT\n\n\n\n\n\n\n\n\n\n\n\n\n\n\n\n\GS\GS\n\n\n\n\n\n\n\n\n\n\n\n\n\n\n\n\n\n\n\n\n\n\n\n\n\n\n\n\n\n\n\n\n\n\n\n\n\n\n\n\n\n\n\n\n\n\EOT\ENQ\ENQ\ENQ\GS\ENQ\ENQ\GS\GS\GS\GS\GS\ENQ\ENQ\ENQ\ENQ\EOT\EOT\EOT\EOT\GS\EOT\EOT\EOT\GS\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\GS\GS\ENQ\ENQ\ENQ\GS\GS\GS\GS\ENQ\n\n\n\n\n\n\n\n\n\GS\GS\GS\GS\GS\GS\GS\DC1\DC1\DC1\DC1\DC1\DC1\DC1\DC1\DC1\GS\GS\GS\GS\GS\GS\GS\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\n\n\DC1\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\n\n\n\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\NAK\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\ENQ\ENQ\GS\GS\GS\GS\n\n\n\n\n\DC1\DC1\DC1\DC1\DC1\DC1\DC1\GS\GS\GS\GS\GS\GS\GS\GS\GS\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\GS\GS\GS\DC1\DC1\DC1\DC1\DC1\DC1\DC1\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\GS\GS\n\n\n\n\n\n\n\n\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\GS\GS\GS\GS\GS\n\n\n\n\n\n\n\n\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\GS\GS\GS\GS\GS\GS\GS\DC1\DC1\DC1\DC1\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\n\n\n\n\n\n\n\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\NUL\NUL\NUL\NUL\NUL\NUL\NUL\NUL\NUL\NUL\NUL\NUL\NUL\NUL\NUL\NUL\NUL\NUL\NUL\NUL\NUL\NUL\NUL\NUL\NUL\NUL\NUL\NUL\NUL\NUL\NUL\NUL\NUL\NUL\NUL\NUL\NUL\NUL\NUL\NUL\NUL\NUL\NUL\NUL\NUL\NUL\NUL\NUL\NUL\NUL\NUL\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\SOH\SOH\SOH\SOH\SOH\SOH\SOH\SOH\SOH\SOH\SOH\SOH\SOH\SOH\SOH\SOH\SOH\SOH\SOH\SOH\SOH\SOH\SOH\SOH\SOH\SOH\SOH\SOH\SOH\SOH\SOH\SOH\SOH\SOH\SOH\SOH\SOH\SOH\SOH\SOH\SOH\SOH\SOH\SOH\SOH\SOH\SOH\SOH\SOH\SOH\SOH\GS\GS\GS\GS\GS\GS\GS\n\n\n\n\n\n\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\ENQ\ENQ\ENQ\ENQ\GS\GS\GS\GS\GS\GS\GS\GS\b\b\b\b\b\b\b\b\b\b\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\n\n\n\n\n\n\n\n\n\n\n\n\n\n\n\n\n\n\n\n\n\n\n\n\n\n\n\n\n\n\n\GS\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\GS\ENQ\ENQ\f\GS\GS\EOT\EOT\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\n\n\n\n\n\n\n\n\n\n\EOT\GS\GS\GS\GS\GS\GS\GS\GS\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\ENQ\ENQ\ENQ\ENQ\ENQ\ENQ\ENQ\ENQ\ENQ\ENQ\ENQ\n\n\n\n\DC1\DC1\DC1\DC1\DC1\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\ENQ\ENQ\ENQ\ENQ\DC1\DC1\DC1\DC1\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\n\n\n\n\n\n\n\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\GS\GS\GS\GS\GS\GS\GS\GS\GS\ACK\ENQ\ACK\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\ENQ\ENQ\ENQ\ENQ\ENQ\ENQ\ENQ\ENQ\ENQ\ENQ\ENQ\ENQ\ENQ\ENQ\ENQ\DC1\DC1\DC1\DC1\DC1\DC1\DC1\GS\GS\GS\GS\n\n\n\n\n\n\n\n\n\n\n\n\n\n\n\n\n\n\n\n\b\b\b\b\b\b\b\b\b\b\ENQ\EOT\EOT\ENQ\ENQ\EOT\GS\GS\GS\GS\GS\GS\GS\GS\GS\ENQ\ENQ\ENQ\ACK\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\ACK\ACK\ACK\ENQ\ENQ\ENQ\ENQ\ACK\ACK\ENQ\ENQ\DC1\DC1\SUB\DC1\DC1\DC1\DC1\ENQ\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\SUB\GS\GS\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\GS\GS\GS\GS\GS\GS\GS\b\b\b\b\b\b\b\b\b\b\GS\GS\GS\GS\GS\GS\ENQ\ENQ\ENQ\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\ENQ\ENQ\ENQ\ENQ\ENQ\ACK\ENQ\ENQ\ENQ\ENQ\ENQ\ENQ\ENQ\ENQ\GS\b\b\b\b\b\b\b\b\b\b\DC1\DC1\DC1\DC1\EOT\ACK\ACK\EOT\GS\GS\GS\GS\GS\GS\GS\GS\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\ENQ\DC1\DC1\EOT\GS\GS\GS\GS\GS\GS\GS\GS\GS\ENQ\ENQ\ACK\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\ACK\ACK\ACK\ENQ\ENQ\ENQ\ENQ\ENQ\ENQ\ENQ\ENQ\ENQ\ACK\ACK\EOT\EOT\EOT\EOT\DC1\DC1\DC1\DC1\ENQ\ENQ\ENQ\ENQ\DC1\ACK\ENQ\b\b\b\b\b\b\b\b\b\b\EOT\DC1\EOT\DC1\DC1\DC1\GS\n\n\n\n\n\n\n\n\n\n\n\n\n\n\n\n\n\n\n\n\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\GS\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\ACK\ACK\ACK\ENQ\ENQ\ENQ\ACK\ACK\ENQ\ACK\ENQ\ENQ\DC1\DC1\DC1\DC1\DC1\DC1\ENQ\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\EOT\EOT\EOT\EOT\EOT\EOT\EOT\GS\EOT\GS\EOT\EOT\EOT\EOT\GS\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\GS\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\DC1\GS\GS\GS\GS\GS\GS\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\ENQ\ACK\ACK\ACK\ENQ\ENQ\ENQ\ENQ\ENQ\ENQ\ENQ\ENQ\GS\GS\GS\GS\GS\b\b\b\b\b\b\b\b\b\b\GS\GS\GS\GS\GS\GS\ENQ\ENQ\ACK\ACK\GS\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\GS\GS\EOT\EOT\GS\GS\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\GS\EOT\EOT\EOT\EOT\EOT\EOT\EOT\GS\EOT\EOT\GS\EOT\EOT\EOT\EOT\EOT\GS\ENQ\ENQ\EOT\ACK\ACK\ENQ\ACK\ACK\ACK\ACK\GS\GS\ACK\ACK\GS\GS\ACK\ACK\ACK\GS\GS\EOT\GS\GS\GS\GS\GS\GS\ACK\GS\GS\GS\GS\GS\EOT\EOT\EOT\EOT\EOT\ACK\ACK\GS\GS\ENQ\ENQ\ENQ\ENQ\ENQ\ENQ\ENQ\GS\GS\GS\ENQ\ENQ\ENQ\ENQ\ENQ\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\ACK\ACK\ACK\ENQ\ENQ\ENQ\ENQ\ENQ\ENQ\ENQ\ENQ\ACK\ACK\ENQ\ENQ\ENQ\ACK\ENQ\EOT\EOT\EOT\EOT\DC1\DC1\DC1\DC1\DC1\b\b\b\b\b\b\b\b\b\b\DC1\DC1\GS\DC1\ENQ\EOT\EOT\EOT\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\ACK\ACK\ACK\ENQ\ENQ\ENQ\ENQ\ENQ\ENQ\ACK\ENQ\ACK\ACK\ACK\ACK\ENQ\ENQ\ACK\ENQ\ENQ\EOT\EOT\DC1\EOT\GS\GS\GS\GS\GS\GS\GS\GS\b\b\b\b\b\b\b\b\b\b\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\ACK\ACK\ACK\ENQ\ENQ\ENQ\ENQ\GS\GS\ACK\ACK\ACK\ACK\ENQ\ENQ\ACK\ENQ\ENQ\DC1\DC1\DC1\DC1\DC1\DC1\DC1\DC1\DC1\DC1\DC1\DC1\DC1\DC1\DC1\DC1\DC1\DC1\DC1\DC1\DC1\DC1\DC1\EOT\EOT\EOT\EOT\ENQ\ENQ\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\ACK\ACK\ACK\ENQ\ENQ\ENQ\ENQ\ENQ\ENQ\ENQ\ENQ\ACK\ACK\ENQ\ACK\ENQ\ENQ\DC1\DC1\DC1\EOT\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\b\b\b\b\b\b\b\b\b\b\GS\GS\GS\GS\GS\GS\DC1\DC1\DC1\DC1\DC1\DC1\DC1\DC1\DC1\DC1\DC1\DC1\DC1\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\ENQ\ACK\ENQ\ACK\ACK\ENQ\ENQ\ENQ\ENQ\ENQ\ENQ\ACK\ENQ\EOT\DC1\GS\GS\GS\GS\GS\GS\b\b\b\b\b\b\b\b\b\b\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\GS\GS\ENQ\ENQ\ENQ\ACK\ACK\ENQ\ENQ\ENQ\ENQ\ACK\ENQ\ENQ\ENQ\ENQ\ENQ\GS\GS\GS\GS\b\b\b\b\b\b\b\b\b\b\n\n\DC1\DC1\DC1\NAK\EOT\EOT\EOT\EOT\EOT\EOT\EOT\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\ACK\ACK\ACK\ENQ\ENQ\ENQ\ENQ\ENQ\ENQ\ENQ\ENQ\ENQ\ACK\ENQ\ENQ\DC1\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\NUL\NUL\NUL\NUL\NUL\NUL\NUL\NUL\NUL\NUL\NUL\NUL\NUL\NUL\NUL\NUL\NUL\NUL\NUL\NUL\NUL\NUL\NUL\NUL\NUL\NUL\NUL\NUL\NUL\NUL\NUL\NUL\SOH\SOH\SOH\SOH\SOH\SOH\SOH\SOH\SOH\SOH\SOH\SOH\SOH\SOH\SOH\SOH\SOH\SOH\SOH\SOH\SOH\SOH\SOH\SOH\SOH\SOH\SOH\SOH\SOH\SOH\SOH\SOH\b\b\b\b\b\b\b\b\b\b\n\n\n\n\n\n\n\n\n\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\GS\GS\EOT\GS\GS\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\GS\EOT\EOT\GS\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\ACK\ACK\ACK\ACK\ACK\ACK\GS\ACK\ACK\GS\GS\ENQ\ENQ\ACK\ENQ\EOT\ACK\EOT\ACK\ENQ\DC1\DC1\DC1\GS\GS\GS\GS\GS\GS\GS\GS\GS\b\b\b\b\b\b\b\b\b\b\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\GS\GS\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\ACK\ACK\ACK\ENQ\ENQ\ENQ\ENQ\GS\GS\ENQ\ENQ\ACK\ACK\ACK\ACK\ENQ\EOT\DC1\EOT\ACK\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\EOT\ENQ\ENQ\ENQ\ENQ\ENQ\ENQ\ENQ\ENQ\ENQ\ENQ\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\ENQ\ENQ\ENQ\ENQ\ENQ\ENQ\ACK\EOT\ENQ\ENQ\ENQ\ENQ\DC1\DC1\DC1\DC1\DC1\DC1\DC1\DC1\ENQ\GS\GS\GS\GS\GS\GS\GS\GS\EOT\ENQ\ENQ\ENQ\ENQ\ENQ\ENQ\ACK\ACK\ENQ\ENQ\ENQ\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\ENQ\ENQ\ENQ\ENQ\ENQ\ENQ\ENQ\ENQ\ENQ\ENQ\ENQ\ENQ\ENQ\ACK\ENQ\ENQ\DC1\DC1\DC1\EOT\DC1\DC1\DC1\DC1\DC1\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\GS\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\ACK\ENQ\ENQ\ENQ\ENQ\ENQ\ENQ\ENQ\GS\ENQ\ENQ\ENQ\ENQ\ENQ\ENQ\ACK\ENQ\EOT\DC1\DC1\DC1\DC1\DC1\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\b\b\b\b\b\b\b\b\b\b\n\n\n\n\n\n\n\n\n\n\n\n\n\n\n\n\n\n\n\GS\GS\GS\DC1\DC1\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\GS\GS\ENQ\ENQ\ENQ\ENQ\ENQ\ENQ\ENQ\ENQ\ENQ\ENQ\ENQ\ENQ\ENQ\ENQ\ENQ\ENQ\ENQ\ENQ\ENQ\ENQ\ENQ\ENQ\GS\ACK\ENQ\ENQ\ENQ\ENQ\ENQ\ENQ\ENQ\ACK\ENQ\ENQ\ACK\ENQ\ENQ\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\EOT\EOT\EOT\EOT\EOT\EOT\EOT\GS\EOT\EOT\GS\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\ENQ\ENQ\ENQ\ENQ\ENQ\ENQ\GS\GS\GS\ENQ\GS\ENQ\ENQ\GS\ENQ\ENQ\ENQ\ENQ\ENQ\ENQ\ENQ\EOT\ENQ\GS\GS\GS\GS\GS\GS\GS\GS\b\b\b\b\b\b\b\b\b\b\GS\GS\GS\GS\GS\GS\EOT\EOT\EOT\EOT\EOT\EOT\GS\EOT\EOT\GS\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\ACK\ACK\ACK\ACK\ACK\GS\ENQ\ENQ\GS\ACK\ACK\ENQ\ACK\ENQ\EOT\GS\GS\GS\GS\GS\GS\GS\b\b\b\b\b\b\b\b\b\b\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\ENQ\ENQ\ACK\ACK\DC1\DC1\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\EOT\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\n\n\n\n\n\n\n\n\n\n\n\n\n\n\n\n\n\n\n\n\n\NAK\NAK\NAK\NAK\NAK\NAK\NAK\NAK\DC3\DC3\DC3\DC3\NAK\NAK\NAK\NAK\NAK\NAK\NAK\NAK\NAK\NAK\NAK\NAK\NAK\NAK\NAK\NAK\NAK\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\DC1\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\t\t\t\t\t\t\t\t\t\t\t\t\t\t\t\t\t\t\t\t\t\t\t\t\t\t\t\t\t\t\t\t\t\t\t\t\t\t\t\t\t\t\t\t\t\t\t\t\t\t\t\t\t\t\t\t\t\t\t\t\t\t\t\t\t\t\t\t\t\t\t\t\t\t\t\t\t\t\t\t\t\t\t\t\t\t\t\t\t\t\t\t\t\t\t\t\t\t\t\t\t\t\t\t\t\t\t\t\t\t\t\GS\DC1\DC1\DC1\DC1\DC1\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\DC1\DC1\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\GS\SUB\SUB\SUB\SUB\SUB\SUB\SUB\SUB\SUB\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\GS\GS\GS\GS\GS\GS\GS\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\GS\b\b\b\b\b\b\b\b\b\b\GS\GS\GS\GS\DC1\DC1\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\GS\b\b\b\b\b\b\b\b\b\b\GS\GS\GS\GS\GS\GS\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\GS\GS\ENQ\ENQ\ENQ\ENQ\ENQ\DC1\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\ENQ\ENQ\ENQ\ENQ\ENQ\ENQ\ENQ\DC1\DC1\DC1\DC1\DC1\NAK\NAK\NAK\NAK\ETX\ETX\ETX\ETX\DC1\NAK\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\b\b\b\b\b\b\b\b\b\b\GS\n\n\n\n\n\n\n\GS\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\GS\GS\GS\GS\GS\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\NUL\NUL\NUL\NUL\NUL\NUL\NUL\NUL\NUL\NUL\NUL\NUL\NUL\NUL\NUL\NUL\NUL\NUL\NUL\NUL\NUL\NUL\NUL\NUL\NUL\NUL\NUL\NUL\NUL\NUL\NUL\NUL\SOH\SOH\SOH\SOH\SOH\SOH\SOH\SOH\SOH\SOH\SOH\SOH\SOH\SOH\SOH\SOH\SOH\SOH\SOH\SOH\SOH\SOH\SOH\SOH\SOH\SOH\SOH\SOH\SOH\SOH\SOH\SOH\n\n\n\n\n\n\n\n\n\n\n\n\n\n\n\n\n\n\n\n\n\n\n\DC1\DC1\DC1\DC1\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\GS\GS\GS\GS\ENQ\EOT\ACK\ACK\ACK\ACK\ACK\ACK\ACK\ACK\ACK\ACK\ACK\ACK\ACK\ACK\ACK\ACK\ACK\ACK\ACK\ACK\ACK\ACK\ACK\ACK\ACK\ACK\ACK\ACK\ACK\ACK\ACK\ACK\ACK\ACK\ACK\ACK\ACK\ACK\ACK\ACK\ACK\ACK\ACK\ACK\ACK\ACK\ACK\ACK\ACK\ACK\ACK\ACK\ACK\ACK\ACK\GS\GS\GS\GS\GS\GS\GS\ENQ\ENQ\ENQ\ENQ\ETX\ETX\ETX\ETX\ETX\ETX\ETX\ETX\ETX\ETX\ETX\ETX\ETX\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\ETX\ETX\DC1\ETX\ENQ\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\ACK\ACK\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\GS\GS\GS\GS\GS\GS\GS\GS\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\ETX\ETX\ETX\ETX\GS\ETX\ETX\ETX\ETX\ETX\ETX\ETX\GS\ETX\ETX\GS\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\EOT\EOT\EOT\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\EOT\EOT\EOT\EOT\GS\GS\GS\GS\GS\GS\GS\GS\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\GS\GS\GS\GS\GS\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\GS\GS\GS\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\GS\GS\GS\GS\GS\GS\GS\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\GS\GS\NAK\ENQ\ENQ\DC1\SUB\SUB\SUB\SUB\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\ENQ\ENQ\ENQ\ENQ\ENQ\ENQ\ENQ\ENQ\ENQ\ENQ\ENQ\ENQ\ENQ\ENQ\ENQ\ENQ\ENQ\ENQ\ENQ\ENQ\ENQ\ENQ\ENQ\ENQ\ENQ\ENQ\ENQ\ENQ\ENQ\ENQ\ENQ\ENQ\ENQ\ENQ\ENQ\ENQ\ENQ\ENQ\ENQ\ENQ\ENQ\ENQ\ENQ\ENQ\ENQ\ENQ\GS\GS\ENQ\ENQ\ENQ\ENQ\ENQ\ENQ\ENQ\ENQ\ENQ\ENQ\ENQ\ENQ\ENQ\ENQ\ENQ\ENQ\ENQ\ENQ\ENQ\ENQ\ENQ\ENQ\ENQ\GS\GS\GS\GS\GS\GS\GS\GS\GS\NAK\NAK\NAK\NAK\NAK\NAK\NAK\NAK\NAK\NAK\NAK\NAK\NAK\NAK\NAK\NAK\NAK\NAK\NAK\NAK\NAK\NAK\NAK\NAK\NAK\NAK\NAK\NAK\NAK\NAK\NAK\NAK\NAK\NAK\NAK\NAK\NAK\NAK\NAK\NAK\NAK\NAK\NAK\NAK\NAK\NAK\NAK\NAK\NAK\NAK\NAK\NAK\NAK\NAK\NAK\NAK\NAK\NAK\NAK\NAK\NAK\NAK\NAK\NAK\NAK\NAK\NAK\NAK\NAK\NAK\NAK\NAK\NAK\NAK\NAK\NAK\NAK\NAK\NAK\NAK\NAK\NAK\NAK\NAK\NAK\NAK\NAK\NAK\NAK\NAK\NAK\NAK\NAK\NAK\NAK\NAK\NAK\NAK\NAK\NAK\NAK\NAK\NAK\NAK\NAK\NAK\NAK\NAK\NAK\NAK\NAK\NAK\NAK\NAK\NAK\NAK\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\NAK\NAK\NAK\NAK\NAK\NAK\NAK\NAK\NAK\NAK\NAK\NAK\NAK\NAK\NAK\NAK\NAK\NAK\NAK\NAK\NAK\NAK\NAK\NAK\NAK\NAK\NAK\NAK\NAK\NAK\NAK\NAK\NAK\NAK\NAK\NAK\NAK\NAK\NAK\NAK\NAK\NAK\NAK\NAK\NAK\NAK\NAK\NAK\NAK\NAK\NAK\NAK\NAK\NAK\NAK\NAK\NAK\NAK\NAK\NAK\NAK\NAK\NAK\NAK\NAK\NAK\NAK\NAK\NAK\NAK\NAK\NAK\NAK\NAK\NAK\NAK\NAK\NAK\NAK\NAK\NAK\NAK\NAK\NAK\NAK\NAK\NAK\NAK\NAK\NAK\NAK\NAK\NAK\NAK\NAK\NAK\NAK\NAK\NAK\NAK\NAK\NAK\NAK\NAK\NAK\NAK\NAK\NAK\NAK\NAK\NAK\NAK\NAK\NAK\NAK\NAK\NAK\NAK\NAK\NAK\NAK\NAK\NAK\NAK\NAK\NAK\NAK\NAK\NAK\NAK\NAK\NAK\NAK\NAK\NAK\NAK\NAK\NAK\NAK\NAK\NAK\NAK\NAK\NAK\NAK\NAK\NAK\NAK\NAK\NAK\NAK\NAK\NAK\NAK\NAK\NAK\NAK\NAK\NAK\NAK\NAK\NAK\NAK\NAK\NAK\NAK\NAK\NAK\NAK\NAK\NAK\NAK\NAK\NAK\NAK\NAK\NAK\NAK\NAK\NAK\NAK\NAK\NAK\NAK\NAK\NAK\NAK\NAK\NAK\NAK\NAK\NAK\NAK\NAK\NAK\NAK\NAK\NAK\NAK\NAK\NAK\NAK\NAK\NAK\NAK\NAK\NAK\NAK\NAK\NAK\NAK\NAK\NAK\NAK\NAK\NAK\NAK\NAK\NAK\NAK\NAK\NAK\NAK\NAK\NAK\NAK\NAK\NAK\NAK\NAK\NAK\NAK\NAK\NAK\NAK\NAK\NAK\NAK\NAK\NAK\NAK\NAK\NAK\NAK\NAK\NAK\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\NAK\NAK\NAK\NAK\NAK\NAK\NAK\NAK\NAK\NAK\NAK\NAK\NAK\NAK\NAK\NAK\NAK\NAK\NAK\NAK\NAK\NAK\NAK\NAK\NAK\NAK\NAK\NAK\NAK\NAK\NAK\NAK\NAK\NAK\NAK\NAK\NAK\NAK\NAK\GS\GS\NAK\NAK\NAK\NAK\NAK\NAK\NAK\NAK\NAK\NAK\NAK\NAK\NAK\NAK\NAK\NAK\NAK\NAK\NAK\NAK\NAK\NAK\NAK\NAK\NAK\NAK\NAK\NAK\NAK\NAK\NAK\NAK\NAK\NAK\NAK\NAK\NAK\NAK\NAK\NAK\NAK\NAK\NAK\NAK\NAK\NAK\NAK\NAK\NAK\NAK\NAK\NAK\NAK\NAK\NAK\NAK\NAK\NAK\NAK\NAK\ACK\ACK\ENQ\ENQ\ENQ\NAK\NAK\NAK\ACK\ACK\ACK\ACK\ACK\ACK\SUB\SUB\SUB\SUB\SUB\SUB\SUB\SUB\ENQ\ENQ\ENQ\ENQ\ENQ\ENQ\ENQ\ENQ\NAK\NAK\ENQ\ENQ\ENQ\ENQ\ENQ\ENQ\ENQ\NAK\NAK\NAK\NAK\NAK\NAK\NAK\NAK\NAK\NAK\NAK\NAK\NAK\NAK\NAK\NAK\NAK\NAK\NAK\NAK\NAK\NAK\NAK\NAK\NAK\NAK\NAK\NAK\NAK\NAK\ENQ\ENQ\ENQ\ENQ\NAK\NAK\NAK\NAK\NAK\NAK\NAK\NAK\NAK\NAK\NAK\NAK\NAK\NAK\NAK\NAK\NAK\NAK\NAK\NAK\NAK\NAK\NAK\NAK\NAK\NAK\NAK\NAK\NAK\NAK\NAK\NAK\NAK\NAK\NAK\NAK\NAK\NAK\NAK\NAK\NAK\NAK\NAK\NAK\NAK\NAK\NAK\NAK\NAK\NAK\NAK\NAK\NAK\NAK\NAK\NAK\NAK\NAK\NAK\NAK\NAK\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\NAK\NAK\NAK\NAK\NAK\NAK\NAK\NAK\NAK\NAK\NAK\NAK\NAK\NAK\NAK\NAK\NAK\NAK\NAK\NAK\NAK\NAK\NAK\NAK\NAK\NAK\NAK\NAK\NAK\NAK\NAK\NAK\NAK\NAK\NAK\NAK\NAK\NAK\NAK\NAK\NAK\NAK\NAK\NAK\NAK\NAK\NAK\NAK\NAK\NAK\NAK\NAK\NAK\NAK\NAK\NAK\NAK\NAK\NAK\NAK\NAK\NAK\NAK\NAK\NAK\NAK\ENQ\ENQ\ENQ\NAK\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\n\n\n\n\n\n\n\n\n\n\n\n\n\n\n\n\n\n\n\n\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\NAK\NAK\NAK\NAK\NAK\NAK\NAK\NAK\NAK\NAK\NAK\NAK\NAK\NAK\NAK\NAK\NAK\NAK\NAK\NAK\NAK\NAK\NAK\NAK\NAK\NAK\NAK\NAK\NAK\NAK\NAK\NAK\NAK\NAK\NAK\NAK\NAK\NAK\NAK\NAK\NAK\NAK\NAK\NAK\NAK\NAK\NAK\NAK\NAK\NAK\NAK\NAK\NAK\NAK\NAK\NAK\NAK\NAK\NAK\NAK\NAK\NAK\NAK\NAK\NAK\NAK\NAK\NAK\NAK\NAK\NAK\NAK\NAK\NAK\NAK\NAK\NAK\NAK\NAK\NAK\NAK\NAK\NAK\NAK\NAK\NAK\NAK\GS\GS\GS\GS\GS\GS\GS\GS\GS\n\n\n\n\n\n\n\n\n\n\n\n\n\n\n\n\n\n\n\n\n\n\n\n\n\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\NUL\NUL\NUL\NUL\NUL\NUL\NUL\NUL\NUL\NUL\NUL\NUL\NUL\NUL\NUL\NUL\NUL\NUL\NUL\NUL\NUL\NUL\NUL\NUL\NUL\NUL\SOH\SOH\SOH\SOH\SOH\SOH\SOH\SOH\SOH\SOH\SOH\SOH\SOH\SOH\SOH\SOH\SOH\SOH\SOH\SOH\SOH\SOH\SOH\SOH\SOH\SOH\NUL\NUL\NUL\NUL\NUL\NUL\NUL\NUL\NUL\NUL\NUL\NUL\NUL\NUL\NUL\NUL\NUL\NUL\NUL\NUL\NUL\NUL\NUL\NUL\NUL\NUL\SOH\SOH\SOH\SOH\SOH\SOH\SOH\GS\SOH\SOH\SOH\SOH\SOH\SOH\SOH\SOH\SOH\SOH\SOH\SOH\SOH\SOH\SOH\SOH\SOH\SOH\NUL\NUL\NUL\NUL\NUL\NUL\NUL\NUL\NUL\NUL\NUL\NUL\NUL\NUL\NUL\NUL\NUL\NUL\NUL\NUL\NUL\NUL\NUL\NUL\NUL\NUL\SOH\SOH\SOH\SOH\SOH\SOH\SOH\SOH\SOH\SOH\SOH\SOH\SOH\SOH\SOH\SOH\SOH\SOH\SOH\SOH\SOH\SOH\SOH\SOH\SOH\SOH\NUL\GS\NUL\NUL\GS\GS\NUL\GS\GS\NUL\NUL\GS\GS\NUL\NUL\NUL\NUL\GS\NUL\NUL\NUL\NUL\NUL\NUL\NUL\NUL\SOH\SOH\SOH\SOH\GS\SOH\GS\SOH\SOH\SOH\SOH\SOH\SOH\SOH\GS\SOH\SOH\SOH\SOH\SOH\SOH\SOH\SOH\SOH\SOH\SOH\NUL\NUL\NUL\NUL\NUL\NUL\NUL\NUL\NUL\NUL\NUL\NUL\NUL\NUL\NUL\NUL\NUL\NUL\NUL\NUL\NUL\NUL\NUL\NUL\NUL\NUL\SOH\SOH\SOH\SOH\SOH\SOH\SOH\SOH\SOH\SOH\SOH\SOH\SOH\SOH\SOH\SOH\SOH\SOH\SOH\SOH\SOH\SOH\SOH\SOH\SOH\SOH\NUL\NUL\GS\NUL\NUL\NUL\NUL\GS\GS\NUL\NUL\NUL\NUL\NUL\NUL\NUL\NUL\GS\NUL\NUL\NUL\NUL\NUL\NUL\NUL\GS\SOH\SOH\SOH\SOH\SOH\SOH\SOH\SOH\SOH\SOH\SOH\SOH\SOH\SOH\SOH\SOH\SOH\SOH\SOH\SOH\SOH\SOH\SOH\SOH\SOH\SOH\NUL\NUL\GS\NUL\NUL\NUL\NUL\GS\NUL\NUL\NUL\NUL\NUL\GS\NUL\GS\GS\GS\NUL\NUL\NUL\NUL\NUL\NUL\NUL\GS\SOH\SOH\SOH\SOH\SOH\SOH\SOH\SOH\SOH\SOH\SOH\SOH\SOH\SOH\SOH\SOH\SOH\SOH\SOH\SOH\SOH\SOH\SOH\SOH\SOH\SOH\NUL\NUL\NUL\NUL\NUL\NUL\NUL\NUL\NUL\NUL\NUL\NUL\NUL\NUL\NUL\NUL\NUL\NUL\NUL\NUL\NUL\NUL\NUL\NUL\NUL\NUL\SOH\SOH\SOH\SOH\SOH\SOH\SOH\SOH\SOH\SOH\SOH\SOH\SOH\SOH\SOH\SOH\SOH\SOH\SOH\SOH\SOH\SOH\SOH\SOH\SOH\SOH\NUL\NUL\NUL\NUL\NUL\NUL\NUL\NUL\NUL\NUL\NUL\NUL\NUL\NUL\NUL\NUL\NUL\NUL\NUL\NUL\NUL\NUL\NUL\NUL\NUL\NUL\SOH\SOH\SOH\SOH\SOH\SOH\SOH\SOH\SOH\SOH\SOH\SOH\SOH\SOH\SOH\SOH\SOH\SOH\SOH\SOH\SOH\SOH\SOH\SOH\SOH\SOH\NUL\NUL\NUL\NUL\NUL\NUL\NUL\NUL\NUL\NUL\NUL\NUL\NUL\NUL\NUL\NUL\NUL\NUL\NUL\NUL\NUL\NUL\NUL\NUL\NUL\NUL\SOH\SOH\SOH\SOH\SOH\SOH\SOH\SOH\SOH\SOH\SOH\SOH\SOH\SOH\SOH\SOH\SOH\SOH\SOH\SOH\SOH\SOH\SOH\SOH\SOH\SOH\NUL\NUL\NUL\NUL\NUL\NUL\NUL\NUL\NUL\NUL\NUL\NUL\NUL\NUL\NUL\NUL\NUL\NUL\NUL\NUL\NUL\NUL\NUL\NUL\NUL\NUL\SOH\SOH\SOH\SOH\SOH\SOH\SOH\SOH\SOH\SOH\SOH\SOH\SOH\SOH\SOH\SOH\SOH\SOH\SOH\SOH\SOH\SOH\SOH\SOH\SOH\SOH\NUL\NUL\NUL\NUL\NUL\NUL\NUL\NUL\NUL\NUL\NUL\NUL\NUL\NUL\NUL\NUL\NUL\NUL\NUL\NUL\NUL\NUL\NUL\NUL\NUL\NUL\SOH\SOH\SOH\SOH\SOH\SOH\SOH\SOH\SOH\SOH\SOH\SOH\SOH\SOH\SOH\SOH\SOH\SOH\SOH\SOH\SOH\SOH\SOH\SOH\SOH\SOH\NUL\NUL\NUL\NUL\NUL\NUL\NUL\NUL\NUL\NUL\NUL\NUL\NUL\NUL\NUL\NUL\NUL\NUL\NUL\NUL\NUL\NUL\NUL\NUL\NUL\NUL\SOH\SOH\SOH\SOH\SOH\SOH\SOH\SOH\SOH\SOH\SOH\SOH\SOH\SOH\SOH\SOH\SOH\SOH\SOH\SOH\SOH\SOH\SOH\SOH\SOH\SOH\SOH\SOH\GS\GS\NUL\NUL\NUL\NUL\NUL\NUL\NUL\NUL\NUL\NUL\NUL\NUL\NUL\NUL\NUL\NUL\NUL\NUL\NUL\NUL\NUL\NUL\NUL\NUL\NUL\DC2\SOH\SOH\SOH\SOH\SOH\SOH\SOH\SOH\SOH\SOH\SOH\SOH\SOH\SOH\SOH\SOH\SOH\SOH\SOH\SOH\SOH\SOH\SOH\SOH\SOH\DC2\SOH\SOH\SOH\SOH\SOH\SOH\NUL\NUL\NUL\NUL\NUL\NUL\NUL\NUL\NUL\NUL\NUL\NUL\NUL\NUL\NUL\NUL\NUL\NUL\NUL\NUL\NUL\NUL\NUL\NUL\NUL\DC2\SOH\SOH\SOH\SOH\SOH\SOH\SOH\SOH\SOH\SOH\SOH\SOH\SOH\SOH\SOH\SOH\SOH\SOH\SOH\SOH\SOH\SOH\SOH\SOH\SOH\DC2\SOH\SOH\SOH\SOH\SOH\SOH\NUL\NUL\NUL\NUL\NUL\NUL\NUL\NUL\NUL\NUL\NUL\NUL\NUL\NUL\NUL\NUL\NUL\NUL\NUL\NUL\NUL\NUL\NUL\NUL\NUL\DC2\SOH\SOH\SOH\SOH\SOH\SOH\SOH\SOH\SOH\SOH\SOH\SOH\SOH\SOH\SOH\SOH\SOH\SOH\SOH\SOH\SOH\SOH\SOH\SOH\SOH\DC2\SOH\SOH\SOH\SOH\SOH\SOH\NUL\NUL\NUL\NUL\NUL\NUL\NUL\NUL\NUL\NUL\NUL\NUL\NUL\NUL\NUL\NUL\NUL\NUL\NUL\NUL\NUL\NUL\NUL\NUL\NUL\DC2\SOH\SOH\SOH\SOH\SOH\SOH\SOH\SOH\SOH\SOH\SOH\SOH\SOH\SOH\SOH\SOH\SOH\SOH\SOH\SOH\SOH\SOH\SOH\SOH\SOH\DC2\SOH\SOH\SOH\SOH\SOH\SOH\NUL\NUL\NUL\NUL\NUL\NUL\NUL\NUL\NUL\NUL\NUL\NUL\NUL\NUL\NUL\NUL\NUL\NUL\NUL\NUL\NUL\NUL\NUL\NUL\NUL\DC2\SOH\SOH\SOH\SOH\SOH\SOH\SOH\SOH\SOH\SOH\SOH\SOH\SOH\SOH\SOH\SOH\SOH\SOH\SOH\SOH\SOH\SOH\SOH\SOH\SOH\DC2\SOH\SOH\SOH\SOH\SOH\SOH\NUL\SOH\GS\GS\b\b\b\b\b\b\b\b\b\b\b\b\b\b\b\b\b\b\b\b\b\b\b\b\b\b\b\b\b\b\b\b\b\b\b\b\b\b\b\b\b\b\b\b\b\b\b\b\b\b\NAK\NAK\NAK\NAK\NAK\NAK\NAK\NAK\NAK\NAK\NAK\NAK\NAK\NAK\NAK\NAK\NAK\NAK\NAK\NAK\NAK\NAK\NAK\NAK\NAK\NAK\NAK\NAK\NAK\NAK\NAK\NAK\NAK\NAK\NAK\NAK\NAK\NAK\NAK\NAK\NAK\NAK\NAK\NAK\NAK\NAK\NAK\NAK\NAK\NAK\NAK\NAK\NAK\NAK\NAK\NAK\NAK\NAK\NAK\NAK\NAK\NAK\NAK\NAK\NAK\NAK\NAK\NAK\NAK\NAK\NAK\NAK\NAK\NAK\NAK\NAK\NAK\NAK\NAK\NAK\NAK\NAK\NAK\NAK\NAK\NAK\NAK\NAK\NAK\NAK\NAK\NAK\NAK\NAK\NAK\NAK\NAK\NAK\NAK\NAK\NAK\NAK\NAK\NAK\NAK\NAK\NAK\NAK\NAK\NAK\NAK\NAK\NAK\NAK\NAK\NAK\NAK\NAK\NAK\NAK\NAK\NAK\NAK\NAK\NAK\NAK\NAK\NAK\NAK\NAK\NAK\NAK\NAK\NAK\NAK\NAK\NAK\NAK\NAK\NAK\NAK\NAK\NAK\NAK\NAK\NAK\NAK\NAK\NAK\NAK\NAK\NAK\NAK\NAK\NAK\NAK\NAK\NAK\NAK\NAK\NAK\NAK\NAK\NAK\NAK\NAK\NAK\NAK\NAK\NAK\NAK\NAK\NAK\NAK\NAK\NAK\NAK\NAK\NAK\NAK\NAK\NAK\NAK\NAK\NAK\NAK\NAK\NAK\NAK\NAK\NAK\NAK\NAK\NAK\NAK\NAK\NAK\NAK\NAK\NAK\NAK\NAK\NAK\NAK\NAK\NAK\NAK\NAK\NAK\NAK\NAK\NAK\NAK\NAK\NAK\NAK\NAK\NAK\NAK\NAK\NAK\NAK\NAK\NAK\NAK\NAK\NAK\NAK\NAK\NAK\NAK\NAK\NAK\NAK\NAK\NAK\NAK\NAK\NAK\NAK\NAK\NAK\NAK\NAK\NAK\NAK\NAK\NAK\NAK\NAK\NAK\NAK\NAK\NAK\NAK\NAK\NAK\NAK\NAK\NAK\NAK\NAK\NAK\NAK\NAK\NAK\NAK\NAK\NAK\NAK\NAK\NAK\NAK\NAK\NAK\NAK\NAK\NAK\NAK\NAK\NAK\NAK\NAK\NAK\NAK\NAK\NAK\NAK\NAK\NAK\NAK\NAK\NAK\NAK\NAK\NAK\NAK\NAK\NAK\NAK\NAK\NAK\NAK\NAK\NAK\NAK\NAK\NAK\NAK\NAK\NAK\NAK\NAK\NAK\NAK\NAK\NAK\NAK\NAK\NAK\NAK\NAK\NAK\NAK\NAK\NAK\NAK\NAK\NAK\NAK\NAK\NAK\NAK\NAK\NAK\NAK\NAK\NAK\NAK\NAK\NAK\NAK\NAK\NAK\NAK\NAK\NAK\NAK\NAK\NAK\NAK\NAK\NAK\NAK\NAK\NAK\NAK\NAK\NAK\NAK\NAK\NAK\NAK\NAK\NAK\NAK\NAK\NAK\NAK\NAK\NAK\NAK\NAK\NAK\NAK\NAK\NAK\NAK\NAK\NAK\NAK\NAK\NAK\NAK\NAK\NAK\NAK\NAK\NAK\NAK\NAK\NAK\NAK\NAK\NAK\NAK\NAK\NAK\NAK\NAK\NAK\NAK\NAK\NAK\NAK\NAK\NAK\NAK\NAK\NAK\NAK\NAK\NAK\NAK\NAK\NAK\NAK\NAK\NAK\NAK\NAK\NAK\NAK\NAK\NAK\NAK\NAK\NAK\NAK\NAK\NAK\NAK\NAK\NAK\NAK\NAK\NAK\NAK\NAK\NAK\NAK\NAK\NAK\NAK\NAK\NAK\NAK\NAK\NAK\NAK\NAK\NAK\NAK\NAK\NAK\NAK\NAK\NAK\NAK\NAK\NAK\NAK\NAK\NAK\NAK\NAK\NAK\NAK\NAK\NAK\NAK\NAK\NAK\NAK\NAK\NAK\NAK\NAK\NAK\NAK\NAK\NAK\NAK\NAK\NAK\NAK\NAK\NAK\NAK\NAK\NAK\NAK\NAK\NAK\NAK\NAK\NAK\NAK\NAK\NAK\NAK\NAK\NAK\NAK\NAK\NAK\NAK\NAK\NAK\NAK\NAK\NAK\ENQ\ENQ\ENQ\ENQ\ENQ\ENQ\ENQ\ENQ\ENQ\ENQ\ENQ\ENQ\ENQ\ENQ\ENQ\ENQ\ENQ\ENQ\ENQ\ENQ\ENQ\ENQ\ENQ\ENQ\ENQ\ENQ\ENQ\ENQ\ENQ\ENQ\ENQ\ENQ\ENQ\ENQ\ENQ\ENQ\ENQ\ENQ\ENQ\ENQ\ENQ\ENQ\ENQ\ENQ\ENQ\ENQ\ENQ\ENQ\ENQ\ENQ\ENQ\ENQ\ENQ\ENQ\ENQ\NAK\NAK\NAK\NAK\ENQ\ENQ\ENQ\ENQ\ENQ\ENQ\ENQ\ENQ\ENQ\ENQ\ENQ\ENQ\ENQ\ENQ\ENQ\ENQ\ENQ\ENQ\ENQ\ENQ\ENQ\ENQ\ENQ\ENQ\ENQ\ENQ\ENQ\ENQ\ENQ\ENQ\ENQ\ENQ\ENQ\ENQ\ENQ\ENQ\ENQ\ENQ\ENQ\ENQ\ENQ\ENQ\ENQ\ENQ\ENQ\ENQ\ENQ\ENQ\ENQ\ENQ\NAK\NAK\NAK\NAK\NAK\NAK\NAK\NAK\ENQ\NAK\NAK\NAK\NAK\NAK\NAK\NAK\NAK\NAK\NAK\NAK\NAK\NAK\NAK\ENQ\NAK\NAK\DC1\DC1\DC1\DC1\DC1\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\ENQ\ENQ\ENQ\ENQ\ENQ\GS\ENQ\ENQ\ENQ\ENQ\ENQ\ENQ\ENQ\ENQ\ENQ\ENQ\ENQ\ENQ\ENQ\ENQ\ENQ\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\SOH\SOH\SOH\SOH\SOH\SOH\SOH\SOH\SOH\SOH\EOT\SOH\SOH\SOH\SOH\SOH\SOH\SOH\SOH\SOH\SOH\SOH\SOH\SOH\SOH\SOH\SOH\SOH\SOH\SOH\SOH\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\ENQ\ENQ\ENQ\ENQ\ENQ\ENQ\ENQ\GS\ENQ\ENQ\ENQ\ENQ\ENQ\ENQ\ENQ\ENQ\ENQ\ENQ\ENQ\ENQ\ENQ\ENQ\ENQ\ENQ\ENQ\GS\GS\ENQ\ENQ\ENQ\ENQ\ENQ\ENQ\ENQ\GS\ENQ\ENQ\GS\ENQ\ENQ\ENQ\ENQ\ENQ\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\GS\GS\GS\ENQ\ENQ\ENQ\ENQ\ENQ\ENQ\ENQ\ETX\ETX\ETX\ETX\ETX\ETX\ETX\GS\GS\b\b\b\b\b\b\b\b\b\b\GS\GS\GS\GS\EOT\NAK\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\ENQ\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\ENQ\ENQ\ENQ\ENQ\b\b\b\b\b\b\b\b\b\b\GS\GS\GS\GS\GS\DC3\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\EOT\EOT\EOT\EOT\EOT\EOT\EOT\GS\EOT\EOT\EOT\EOT\GS\EOT\EOT\GS\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\GS\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\GS\GS\n\n\n\n\n\n\n\n\n\ENQ\ENQ\ENQ\ENQ\ENQ\ENQ\ENQ\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\NUL\NUL\NUL\NUL\NUL\NUL\NUL\NUL\NUL\NUL\NUL\NUL\NUL\NUL\NUL\NUL\NUL\NUL\NUL\NUL\NUL\NUL\NUL\NUL\NUL\NUL\NUL\NUL\NUL\NUL\NUL\NUL\NUL\NUL\SOH\SOH\SOH\SOH\SOH\SOH\SOH\SOH\SOH\SOH\SOH\SOH\SOH\SOH\SOH\SOH\SOH\SOH\SOH\SOH\SOH\SOH\SOH\SOH\SOH\SOH\SOH\SOH\SOH\SOH\SOH\SOH\SOH\SOH\ENQ\ENQ\ENQ\ENQ\ENQ\ENQ\ENQ\ETX\GS\GS\GS\GS\b\b\b\b\b\b\b\b\b\b\GS\GS\GS\GS\DC1\DC1\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\n\n\n\n\n\n\n\n\n\n\n\n\n\n\n\n\n\n\n\n\n\n\n\n\n\n\n\n\n\n\n\n\n\n\n\n\n\n\n\n\n\n\n\n\n\n\n\n\n\n\n\n\n\n\n\n\n\n\n\NAK\n\n\n\DC3\n\n\n\n\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\n\n\n\n\n\n\n\n\n\n\n\n\n\n\n\n\n\n\n\n\n\n\n\n\n\n\n\n\n\n\n\n\n\n\n\n\n\n\n\n\n\n\n\n\n\NAK\n\n\n\n\n\n\n\n\n\n\n\n\n\n\n\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\EOT\EOT\EOT\EOT\GS\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\GS\EOT\EOT\GS\EOT\GS\GS\EOT\GS\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\GS\EOT\EOT\EOT\EOT\GS\EOT\GS\EOT\GS\GS\GS\GS\GS\GS\EOT\GS\GS\GS\GS\EOT\GS\EOT\GS\EOT\GS\EOT\EOT\EOT\GS\EOT\EOT\GS\EOT\GS\GS\EOT\GS\EOT\GS\EOT\GS\EOT\GS\EOT\GS\EOT\EOT\GS\EOT\GS\GS\EOT\EOT\EOT\EOT\GS\EOT\EOT\EOT\EOT\EOT\EOT\EOT\GS\EOT\EOT\EOT\EOT\GS\EOT\EOT\EOT\EOT\GS\EOT\GS\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\GS\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\GS\GS\GS\GS\GS\EOT\EOT\EOT\GS\EOT\EOT\EOT\EOT\EOT\GS\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\DC2\DC2\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\NAK\NAK\NAK\NAK\NAK\NAK\NAK\NAK\NAK\NAK\NAK\NAK\NAK\NAK\NAK\NAK\NAK\NAK\NAK\NAK\NAK\NAK\NAK\NAK\NAK\NAK\NAK\NAK\NAK\NAK\NAK\NAK\NAK\NAK\NAK\NAK\NAK\NAK\NAK\NAK\NAK\NAK\NAK\NAK\GS\GS\GS\GS\NAK\NAK\NAK\NAK\NAK\NAK\NAK\NAK\NAK\NAK\NAK\NAK\NAK\NAK\NAK\NAK\NAK\NAK\NAK\NAK\NAK\NAK\NAK\NAK\NAK\NAK\NAK\NAK\NAK\NAK\NAK\NAK\NAK\NAK\NAK\NAK\NAK\NAK\NAK\NAK\NAK\NAK\NAK\NAK\NAK\NAK\NAK\NAK\NAK\NAK\NAK\NAK\NAK\NAK\NAK\NAK\NAK\NAK\NAK\NAK\NAK\NAK\NAK\NAK\NAK\NAK\NAK\NAK\NAK\NAK\NAK\NAK\NAK\NAK\NAK\NAK\NAK\NAK\NAK\NAK\NAK\NAK\NAK\NAK\NAK\NAK\NAK\NAK\NAK\NAK\NAK\NAK\NAK\NAK\NAK\NAK\NAK\NAK\NAK\NAK\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\NAK\NAK\NAK\NAK\NAK\NAK\NAK\NAK\NAK\NAK\NAK\NAK\NAK\NAK\NAK\GS\GS\NAK\NAK\NAK\NAK\NAK\NAK\NAK\NAK\NAK\NAK\NAK\NAK\NAK\NAK\NAK\GS\NAK\NAK\NAK\NAK\NAK\NAK\NAK\NAK\NAK\NAK\NAK\NAK\NAK\NAK\NAK\GS\NAK\NAK\NAK\NAK\NAK\NAK\NAK\NAK\NAK\NAK\NAK\NAK\NAK\NAK\NAK\NAK\NAK\NAK\NAK\NAK\NAK\NAK\NAK\NAK\NAK\NAK\NAK\NAK\NAK\NAK\NAK\NAK\NAK\NAK\NAK\NAK\NAK\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\n\n\n\n\n\n\n\n\n\n\n\n\n\NAK\NAK\NAK\NAK\NAK\NAK\NAK\NAK\NAK\NAK\NAK\NAK\NAK\NAK\NAK\NAK\NAK\NAK\NAK\NAK\NAK\NAK\NAK\NAK\NAK\NAK\NAK\NAK\NAK\NAK\NAK\NAK\NAK\NAK\NAK\NAK\NAK\NAK\NAK\NAK\NAK\NAK\NAK\NAK\NAK\NAK\NAK\NAK\NAK\NAK\NAK\NAK\NAK\NAK\NAK\NAK\NAK\NAK\NAK\NAK\NAK\NAK\NAK\NAK\NAK\NAK\NAK\NAK\NAK\NAK\NAK\NAK\NAK\NAK\NAK\NAK\NAK\NAK\NAK\NAK\NAK\NAK\NAK\NAK\NAK\NAK\NAK\NAK\NAK\NAK\NAK\NAK\NAK\NAK\NAK\NAK\NAK\NAK\NAK\NAK\NAK\NAK\NAK\NAK\NAK\NAK\NAK\NAK\NAK\NAK\NAK\NAK\NAK\NAK\NAK\NAK\NAK\NAK\NAK\NAK\NAK\NAK\NAK\NAK\NAK\NAK\NAK\NAK\NAK\NAK\NAK\NAK\NAK\NAK\NAK\NAK\NAK\NAK\NAK\NAK\NAK\NAK\NAK\NAK\NAK\NAK\NAK\NAK\NAK\NAK\NAK\NAK\NAK\NAK\NAK\NAK\NAK\NAK\NAK\NAK\NAK\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\NAK\NAK\NAK\NAK\NAK\NAK\NAK\NAK\NAK\NAK\NAK\NAK\NAK\NAK\NAK\NAK\NAK\NAK\NAK\NAK\NAK\NAK\NAK\NAK\NAK\NAK\NAK\NAK\NAK\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\NAK\NAK\NAK\NAK\NAK\NAK\NAK\NAK\NAK\NAK\NAK\NAK\NAK\NAK\NAK\NAK\NAK\NAK\NAK\NAK\NAK\NAK\NAK\NAK\NAK\NAK\NAK\NAK\NAK\NAK\NAK\NAK\NAK\NAK\NAK\NAK\NAK\NAK\NAK\NAK\NAK\NAK\NAK\NAK\GS\GS\GS\GS\NAK\NAK\NAK\NAK\NAK\NAK\NAK\NAK\NAK\GS\GS\GS\GS\GS\GS\GS\NAK\NAK\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\NAK\NAK\NAK\NAK\NAK\NAK\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\NAK\NAK\NAK\NAK\NAK\NAK\NAK\NAK\NAK\NAK\NAK\NAK\NAK\NAK\NAK\NAK\NAK\NAK\NAK\NAK\NAK\NAK\NAK\NAK\NAK\NAK\NAK\NAK\NAK\NAK\NAK\NAK\NAK\NAK\NAK\NAK\NAK\NAK\NAK\NAK\NAK\NAK\NAK\NAK\NAK\NAK\NAK\NAK\NAK\NAK\NAK\NAK\NAK\NAK\NAK\NAK\NAK\NAK\NAK\NAK\NAK\NAK\NAK\NAK\NAK\NAK\NAK\NAK\NAK\NAK\NAK\NAK\NAK\NAK\NAK\NAK\NAK\NAK\NAK\NAK\NAK\NAK\NAK\NAK\NAK\NAK\NAK\NAK\NAK\NAK\NAK\NAK\NAK\NAK\NAK\NAK\NAK\NAK\NAK\NAK\NAK\NAK\NAK\NAK\NAK\NAK\NAK\NAK\NAK\NAK\NAK\NAK\NAK\NAK\NAK\NAK\NAK\NAK\NAK\NAK\NAK\NAK\NAK\NAK\NAK\NAK\NAK\NAK\NAK\NAK\NAK\NAK\NAK\NAK\NAK\NAK\NAK\NAK\NAK\NAK\NAK\NAK\NAK\NAK\NAK\NAK\NAK\NAK\NAK\NAK\NAK\NAK\NAK\NAK\NAK\NAK\NAK\NAK\NAK\NAK\NAK\NAK\NAK\NAK\NAK\NAK\NAK\NAK\NAK\NAK\NAK\NAK\NAK\NAK\NAK\NAK\NAK\NAK\NAK\NAK\NAK\NAK\NAK\NAK\NAK\NAK\NAK\NAK\NAK\NAK\NAK\NAK\NAK\NAK\NAK\NAK\NAK\NAK\NAK\NAK\NAK\NAK\NAK\NAK\NAK\NAK\NAK\NAK\NAK\NAK\NAK\NAK\NAK\NAK\NAK\NAK\NAK\NAK\NAK\NAK\NAK\NAK\NAK\NAK\NAK\NAK\NAK\NAK\NAK\NAK\NAK\NAK\NAK\NAK\NAK\NAK\NAK\NAK\NAK\NAK\NAK\NAK\NAK\NAK\NAK\NAK\NAK\NAK\NAK\NAK\NAK\DC4\DC4\DC4\DC4\DC4\NAK\NAK\NAK\NAK\NAK\NAK\NAK\NAK\NAK\NAK\NAK\NAK\NAK\NAK\NAK\NAK\NAK\NAK\NAK\NAK\NAK\NAK\NAK\NAK\NAK\NAK\NAK\NAK\NAK\NAK\NAK\NAK\NAK\NAK\NAK\NAK\NAK\NAK\NAK\NAK\NAK\NAK\NAK\NAK\NAK\NAK\NAK\NAK\NAK\NAK\NAK\NAK\NAK\NAK\NAK\NAK\NAK\NAK\NAK\NAK\NAK\NAK\NAK\NAK\NAK\NAK\NAK\NAK\NAK\NAK\NAK\NAK\NAK\NAK\NAK\NAK\NAK\NAK\NAK\NAK\NAK\NAK\NAK\NAK\NAK\NAK\NAK\NAK\NAK\NAK\NAK\NAK\NAK\NAK\NAK\NAK\NAK\NAK\NAK\NAK\NAK\NAK\NAK\NAK\NAK\NAK\NAK\NAK\NAK\NAK\NAK\NAK\NAK\NAK\NAK\NAK\NAK\NAK\NAK\NAK\NAK\NAK\NAK\NAK\NAK\NAK\NAK\NAK\NAK\NAK\NAK\NAK\NAK\NAK\NAK\NAK\NAK\NAK\NAK\NAK\NAK\NAK\NAK\NAK\NAK\NAK\NAK\NAK\NAK\NAK\NAK\NAK\NAK\NAK\NAK\NAK\NAK\NAK\NAK\NAK\NAK\NAK\NAK\NAK\NAK\NAK\NAK\NAK\NAK\NAK\NAK\NAK\NAK\NAK\NAK\NAK\NAK\NAK\NAK\NAK\NAK\NAK\NAK\NAK\NAK\NAK\NAK\NAK\NAK\NAK\NAK\NAK\NAK\NAK\NAK\NAK\NAK\NAK\NAK\NAK\NAK\NAK\NAK\NAK\NAK\NAK\NAK\NAK\NAK\NAK\NAK\NAK\NAK\NAK\NAK\NAK\NAK\NAK\NAK\NAK\NAK\NAK\NAK\NAK\NAK\NAK\NAK\NAK\NAK\NAK\NAK\NAK\NAK\NAK\NAK\NAK\NAK\NAK\NAK\NAK\NAK\NAK\NAK\NAK\NAK\NAK\NAK\NAK\NAK\NAK\NAK\NAK\NAK\NAK\NAK\NAK\NAK\NAK\NAK\NAK\NAK\NAK\NAK\NAK\NAK\NAK\NAK\NAK\NAK\NAK\NAK\NAK\NAK\NAK\NAK\NAK\NAK\NAK\NAK\NAK\NAK\NAK\NAK\NAK\NAK\NAK\NAK\NAK\NAK\NAK\NAK\NAK\NAK\NAK\NAK\NAK\NAK\NAK\NAK\NAK\NAK\NAK\NAK\NAK\NAK\NAK\NAK\NAK\NAK\NAK\NAK\NAK\NAK\NAK\NAK\NAK\NAK\NAK\NAK\NAK\NAK\NAK\NAK\NAK\NAK\NAK\NAK\NAK\NAK\NAK\NAK\NAK\NAK\NAK\NAK\NAK\NAK\NAK\NAK\NAK\NAK\NAK\NAK\NAK\NAK\NAK\NAK\NAK\NAK\NAK\NAK\NAK\NAK\NAK\NAK\NAK\NAK\NAK\NAK\NAK\NAK\NAK\NAK\NAK\NAK\NAK\NAK\NAK\NAK\NAK\NAK\NAK\NAK\NAK\NAK\NAK\NAK\NAK\NAK\NAK\NAK\NAK\NAK\NAK\NAK\NAK\NAK\NAK\NAK\NAK\NAK\NAK\NAK\NAK\NAK\NAK\NAK\NAK\NAK\NAK\NAK\NAK\NAK\NAK\NAK\NAK\NAK\NAK\NAK\NAK\NAK\NAK\NAK\NAK\NAK\NAK\NAK\NAK\NAK\NAK\NAK\NAK\NAK\NAK\NAK\NAK\NAK\NAK\NAK\NAK\NAK\NAK\NAK\NAK\NAK\NAK\NAK\NAK\NAK\NAK\NAK\NAK\NAK\NAK\NAK\NAK\NAK\NAK\NAK\NAK\NAK\NAK\NAK\NAK\NAK\NAK\NAK\NAK\NAK\NAK\NAK\NAK\NAK\NAK\NAK\NAK\NAK\NAK\NAK\NAK\NAK\NAK\NAK\NAK\NAK\NAK\NAK\NAK\NAK\NAK\NAK\NAK\NAK\NAK\NAK\NAK\NAK\NAK\NAK\NAK\NAK\NAK\NAK\NAK\NAK\NAK\NAK\NAK\NAK\NAK\NAK\NAK\NAK\NAK\NAK\NAK\NAK\NAK\NAK\NAK\NAK\NAK\NAK\NAK\NAK\NAK\NAK\NAK\NAK\NAK\NAK\NAK\NAK\NAK\NAK\NAK\NAK\NAK\NAK\NAK\NAK\NAK\NAK\NAK\NAK\NAK\NAK\NAK\NAK\NAK\NAK\NAK\NAK\NAK\NAK\NAK\NAK\NAK\NAK\NAK\NAK\NAK\NAK\NAK\NAK\NAK\NAK\NAK\NAK\NAK\NAK\NAK\NAK\NAK\NAK\NAK\NAK\NAK\NAK\NAK\NAK\NAK\NAK\NAK\NAK\NAK\NAK\NAK\NAK\NAK\NAK\NAK\NAK\NAK\NAK\NAK\NAK\NAK\NAK\NAK\NAK\NAK\NAK\NAK\NAK\NAK\NAK\NAK\NAK\NAK\NAK\NAK\NAK\NAK\NAK\NAK\NAK\NAK\NAK\NAK\NAK\NAK\NAK\NAK\NAK\NAK\NAK\NAK\NAK\NAK\NAK\NAK\NAK\NAK\NAK\NAK\NAK\NAK\NAK\NAK\NAK\NAK\NAK\NAK\NAK\NAK\NAK\NAK\NAK\NAK\NAK\NAK\NAK\NAK\NAK\NAK\NAK\NAK\NAK\NAK\NAK\NAK\NAK\NAK\NAK\NAK\NAK\NAK\NAK\NAK\NAK\NAK\NAK\NAK\NAK\NAK\NAK\NAK\NAK\NAK\NAK\NAK\NAK\NAK\NAK\NAK\NAK\NAK\NAK\NAK\NAK\NAK\NAK\NAK\NAK\NAK\NAK\NAK\NAK\NAK\NAK\NAK\NAK\NAK\NAK\NAK\NAK\NAK\NAK\NAK\NAK\NAK\NAK\NAK\NAK\NAK\NAK\NAK\NAK\NAK\NAK\NAK\NAK\NAK\NAK\NAK\NAK\NAK\NAK\NAK\NAK\NAK\NAK\NAK\NAK\NAK\NAK\NAK\GS\GS\GS\GS\GS\NAK\NAK\NAK\NAK\NAK\NAK\NAK\NAK\NAK\NAK\NAK\NAK\NAK\NAK\NAK\NAK\GS\GS\GS\NAK\NAK\NAK\NAK\NAK\NAK\NAK\NAK\NAK\NAK\NAK\NAK\NAK\GS\GS\GS\NAK\NAK\NAK\NAK\NAK\NAK\NAK\NAK\NAK\NAK\NAK\NAK\NAK\NAK\NAK\NAK\NAK\NAK\NAK\NAK\NAK\NAK\NAK\NAK\NAK\NAK\NAK\NAK\NAK\NAK\NAK\NAK\NAK\NAK\NAK\NAK\NAK\NAK\NAK\NAK\NAK\NAK\NAK\NAK\NAK\NAK\NAK\NAK\NAK\NAK\NAK\NAK\NAK\NAK\NAK\NAK\NAK\NAK\NAK\NAK\NAK\NAK\NAK\NAK\NAK\NAK\NAK\NAK\NAK\NAK\NAK\NAK\NAK\NAK\NAK\NAK\NAK\NAK\NAK\NAK\NAK\NAK\NAK\NAK\NAK\NAK\NAK\NAK\NAK\NAK\NAK\NAK\NAK\NAK\NAK\NAK\NAK\NAK\NAK\NAK\NAK\NAK\NAK\NAK\NAK\NAK\NAK\NAK\NAK\NAK\NAK\NAK\NAK\NAK\NAK\NAK\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\NAK\NAK\NAK\NAK\NAK\NAK\NAK\NAK\NAK\NAK\NAK\NAK\NAK\NAK\NAK\NAK\NAK\NAK\NAK\NAK\NAK\NAK\NAK\NAK\NAK\NAK\NAK\NAK\NAK\NAK\NAK\NAK\NAK\NAK\NAK\NAK\NAK\NAK\NAK\NAK\NAK\NAK\NAK\NAK\NAK\NAK\NAK\NAK\NAK\NAK\NAK\NAK\NAK\NAK\NAK\NAK\NAK\NAK\NAK\NAK\NAK\NAK\NAK\NAK\NAK\NAK\NAK\NAK\NAK\NAK\NAK\NAK\NAK\NAK\NAK\NAK\NAK\NAK\NAK\NAK\NAK\NAK\NAK\NAK\NAK\NAK\NAK\NAK\NAK\GS\GS\GS\GS\GS\GS\GS\NAK\NAK\NAK\NAK\NAK\NAK\NAK\NAK\NAK\NAK\NAK\NAK\GS\GS\GS\GS\NAK\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\NAK\NAK\NAK\NAK\NAK\NAK\NAK\NAK\NAK\NAK\NAK\NAK\GS\GS\GS\GS\NAK\NAK\NAK\NAK\NAK\NAK\NAK\NAK\NAK\NAK\NAK\NAK\NAK\NAK\NAK\NAK\NAK\NAK\NAK\NAK\NAK\NAK\NAK\NAK\NAK\NAK\NAK\NAK\NAK\NAK\NAK\NAK\NAK\NAK\NAK\NAK\NAK\NAK\NAK\NAK\NAK\NAK\NAK\NAK\NAK\NAK\NAK\NAK\NAK\NAK\NAK\NAK\NAK\NAK\NAK\NAK\GS\GS\GS\GS\GS\GS\GS\GS\NAK\NAK\NAK\NAK\NAK\NAK\NAK\NAK\NAK\NAK\GS\GS\GS\GS\GS\GS\NAK\NAK\NAK\NAK\NAK\NAK\NAK\NAK\NAK\NAK\NAK\NAK\NAK\NAK\NAK\NAK\NAK\NAK\NAK\NAK\NAK\NAK\NAK\NAK\NAK\NAK\NAK\NAK\NAK\NAK\NAK\NAK\NAK\NAK\NAK\NAK\NAK\NAK\NAK\NAK\GS\GS\GS\GS\GS\GS\GS\GS\NAK\NAK\NAK\NAK\NAK\NAK\NAK\NAK\NAK\NAK\NAK\NAK\NAK\NAK\NAK\NAK\NAK\NAK\NAK\NAK\NAK\NAK\NAK\NAK\NAK\NAK\NAK\NAK\NAK\NAK\GS\GS\NAK\NAK\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\NAK\NAK\NAK\NAK\NAK\NAK\NAK\NAK\NAK\NAK\NAK\NAK\NAK\NAK\NAK\NAK\NAK\NAK\NAK\NAK\NAK\NAK\NAK\NAK\NAK\NAK\NAK\NAK\NAK\NAK\NAK\NAK\NAK\NAK\NAK\NAK\NAK\NAK\NAK\NAK\NAK\NAK\NAK\NAK\NAK\NAK\NAK\NAK\NAK\NAK\NAK\NAK\NAK\NAK\NAK\NAK\NAK\NAK\NAK\NAK\NAK\NAK\NAK\NAK\NAK\NAK\NAK\NAK\NAK\NAK\NAK\NAK\NAK\NAK\NAK\NAK\NAK\NAK\NAK\NAK\NAK\NAK\NAK\NAK\NAK\NAK\NAK\NAK\NAK\NAK\NAK\NAK\NAK\NAK\NAK\NAK\NAK\NAK\NAK\NAK\NAK\NAK\NAK\NAK\NAK\NAK\NAK\NAK\NAK\NAK\NAK\NAK\NAK\NAK\NAK\NAK\NAK\NAK\NAK\NAK\NAK\NAK\NAK\NAK\NAK\NAK\NAK\NAK\NAK\NAK\NAK\NAK\NAK\NAK\NAK\NAK\NAK\NAK\NAK\NAK\NAK\NAK\NAK\NAK\NAK\NAK\NAK\NAK\NAK\NAK\NAK\NAK\NAK\NAK\NAK\NAK\NAK\NAK\NAK\NAK\NAK\NAK\NAK\NAK\NAK\NAK\NAK\NAK\NAK\NAK\NAK\NAK\NAK\NAK\NAK\NAK\NAK\NAK\NAK\NAK\NAK\NAK\NAK\NAK\NAK\NAK\NAK\NAK\NAK\NAK\NAK\NAK\NAK\NAK\NAK\NAK\NAK\NAK\NAK\NAK\NAK\NAK\NAK\NAK\NAK\NAK\NAK\NAK\NAK\NAK\NAK\NAK\NAK\NAK\NAK\NAK\NAK\NAK\NAK\NAK\NAK\NAK\NAK\NAK\NAK\NAK\NAK\NAK\NAK\NAK\NAK\NAK\NAK\NAK\NAK\NAK\NAK\NAK\NAK\NAK\NAK\NAK\NAK\NAK\NAK\NAK\NAK\NAK\NAK\NAK\NAK\NAK\NAK\NAK\NAK\NAK\NAK\NAK\NAK\NAK\NAK\NAK\NAK\NAK\NAK\NAK\NAK\NAK\NAK\NAK\NAK\NAK\NAK\NAK\NAK\NAK\NAK\NAK\NAK\NAK\NAK\NAK\NAK\NAK\NAK\NAK\NAK\NAK\NAK\NAK\NAK\NAK\NAK\NAK\NAK\NAK\NAK\NAK\NAK\NAK\NAK\NAK\NAK\NAK\NAK\NAK\NAK\NAK\NAK\NAK\NAK\NAK\NAK\NAK\NAK\NAK\NAK\NAK\NAK\NAK\NAK\NAK\NAK\NAK\NAK\NAK\NAK\NAK\NAK\NAK\NAK\NAK\NAK\NAK\NAK\NAK\NAK\NAK\NAK\NAK\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\NAK\NAK\NAK\NAK\NAK\NAK\NAK\NAK\NAK\NAK\NAK\NAK\NAK\NAK\GS\GS\NAK\NAK\NAK\NAK\NAK\GS\GS\GS\NAK\NAK\NAK\NAK\NAK\GS\GS\GS\NAK\NAK\NAK\NAK\NAK\NAK\NAK\GS\GS\GS\GS\GS\GS\GS\GS\GS\NAK\NAK\NAK\NAK\NAK\NAK\NAK\NAK\NAK\NAK\NAK\NAK\NAK\NAK\NAK\NAK\NAK\NAK\NAK\NAK\NAK\NAK\NAK\NAK\NAK\NAK\NAK\NAK\NAK\GS\GS\GS\NAK\NAK\NAK\NAK\NAK\NAK\NAK\NAK\NAK\NAK\NAK\GS\GS\GS\GS\GS\NAK\NAK\NAK\NAK\NAK\NAK\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\NAK\NAK\NAK\NAK\NAK\NAK\NAK\NAK\NAK\NAK\GS\GS\GS\GS\GS\GS\NAK\NAK\NAK\NAK\NAK\NAK\NAK\NAK\GS\GS\GS\GS\GS\GS\GS\GS\NAK\NAK\NAK\NAK\NAK\NAK\NAK\GS\GS\GS\GS\GS\GS\GS\GS\GS\NAK\NAK\NAK\NAK\NAK\NAK\NAK\NAK\NAK\NAK\NAK\NAK\NAK\NAK\NAK\NAK\NAK\NAK\NAK\NAK\NAK\NAK\NAK\NAK\NAK\NAK\NAK\NAK\NAK\NAK\NAK\NAK\NAK\NAK\NAK\NAK\NAK\NAK\NAK\NAK\NAK\NAK\NAK\NAK\NAK\NAK\NAK\NAK\NAK\NAK\NAK\NAK\NAK\NAK\NAK\NAK\NAK\NAK\NAK\NAK\NAK\NAK\NAK\NAK\NAK\NAK\NAK\NAK\NAK\NAK\NAK\NAK\NAK\NAK\NAK\NAK\NAK\NAK\NAK\NAK\NAK\NAK\NAK\NAK\NAK\NAK\NAK\NAK\NAK\NAK\NAK\NAK\NAK\NAK\NAK\NAK\NAK\NAK\NAK\NAK\NAK\NAK\NAK\NAK\NAK\NAK\NAK\NAK\NAK\NAK\NAK\NAK\NAK\NAK\NAK\NAK\NAK\NAK\NAK\NAK\NAK\NAK\NAK\NAK\NAK\NAK\NAK\NAK\NAK\NAK\NAK\NAK\NAK\NAK\NAK\NAK\NAK\NAK\NAK\NAK\NAK\NAK\NAK\NAK\NAK\NAK\NAK\GS\NAK\NAK\NAK\NAK\NAK\NAK\NAK\NAK\NAK\NAK\NAK\NAK\NAK\NAK\NAK\NAK\NAK\NAK\NAK\NAK\NAK\NAK\NAK\NAK\NAK\NAK\NAK\NAK\NAK\NAK\NAK\NAK\NAK\NAK\NAK\NAK\NAK\NAK\NAK\NAK\NAK\NAK\NAK\NAK\NAK\NAK\NAK\NAK\NAK\NAK\NAK\NAK\NAK\NAK\NAK\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\b\b\b\b\b\b\b\b\b\b\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\GS\GS\GS\GS\GS\GS\GS\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\GS\GS\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\EOT\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS\GS