/*  job_distributeexternal.h
 *
 *  Copyright (C) 2010-2012 Andreas von Manteuffel
 *  Copyright (C) 2010-2012 Cedric Studerus
 *
 *  This file is part of the package Reduze 2.
 *  It is distributed under the GNU General Public License version 3
 *  (see the file GPL-3.0.txt or http://www.gnu.org/licenses/gpl-3.0.txt).
 */

#ifndef JOB_DISTRIBUTEEXTERNAL_H_
#define JOB_DISTRIBUTEEXTERNAL_H_

#include "job.h"
#include "reduzer.h"
#include "sector.h"

namespace Reduze {


/// Job template
class DistributeExternal: public Reduze::Job {
public:
	static YAMLSpec yaml_spec() {
		YAMLSpec s;
		s.set_keyword("distribute_external");
		s.set_short_description("Distribute external identities.");
		s.set_long_description("Job to clean up reductions/external_* files."
				" The job will distribute the identities to the appropriate"
				" reductions/reduction_* files and substitute them in "
				" relevant super sectors. This may involve several iterations,"
				" each involving several reduction runs. Please note that"
				" reduction files for crossed sectors will be deleted rather"
				" than updated if necessary. New identities for crossed"
				" sectors will be collected in reductions/reduction_shared."
				" Note: abort and resume is not supported for this job.");
		s.add_option("sector_selection", true, "sector_selection", ""
				"A selection of sectors for which external* files should"
				" be searched for and for which reduction* files should"
				" be updated. Usually it is best to use select_all:true here.");
		s.add_option("equation_files", false, "list of strings", ""
				"Names of files containing equations to be distributed."
				" This is just an optional input source in addition to"
				" external* files.");
		s.add_option("reduzer_options", false, "reduzer_options", ""//
					"Options for the reduction algorithm.");
		s.add_options(Job::yaml_spec());
		return s;
	}
	virtual YAMLSpec yaml_spec_link() const {
		return yaml_spec();
	}
	DistributeExternal() {
		add_auto_options();
	}
	virtual ~DistributeExternal() {
	}
	virtual void run_serial();
	virtual bool find_dependencies(const std::set<std::string>&,//
			std::list<std::string>&, std::list<std::string>&, std::list<Job*>&);
	virtual std::string get_description() const;

protected:
	virtual void add_auto_options() {
		add_auto_io("sector_selection", sector_selection_);
		add_auto_io("equation_files", equation_files_);
		add_auto_io("reduzer_options", reduzer_options_);
	}
	virtual void init();

public:
	SectorSelection sector_selection_;
	std::list<std::string> equation_files_;
	ReduzerOptions reduzer_options_;
};

}

#endif /* JOB_DISTRIBUTEEXTERNAL_H_ */
