/*  job_printsectorinfo.h
 *
 *  Copyright (C) 2010-2012 Andreas von Manteuffel
 *  Copyright (C) 2010-2012 Cedric Studerus
 *
 *  This file is part of the package Reduze 2.
 *  It is distributed under the GNU General Public License version 3
 *  (see the file GPL-3.0.txt or http://www.gnu.org/licenses/gpl-3.0.txt).
 */

#ifndef JOB_PRINTSECTORINFO_H_
#define JOB_PRINTSECTORINFO_H_

#include "job.h"
#include "sector.h"
//#include "ginac/ginac.h"

namespace Reduze {

/// Job to print general information about a sector
class PrintSectorInfo: public Job {
public:
	static YAMLSpec yaml_spec() {
		YAMLSpec s;
		s.set_keyword("print_sector_info");
		s.set_short_description(
				"Prints diagrams and other information for sectors.");
		s.set_long_description(""//
					"Job to print information about sectors such as their"
					" subsectors and graphs.");
		s.add_option("sector_selection", false, "sector_selection", ""//
					"A selection of sectors for which information should"
					" be printed.");
		s.add_option("integral_file", false, "string", ""//
					"Input file name for list of integrals to specify the sectors "
				    " for which information should be printed. This is an"
					" alternative to the option \"sector_selection\".");
		s.add_option("config_info_mma_file", false, "string", ""//
					"Output file name for export of general configuration data"
					" in a Mathematica readable format. In particular, this is"
					" useful as an interface to programs like SecDec and Fiesta.");
		s.add_option("sector_mappings_mma_file", false, "string", ""//
					"Output file name for export of sector mappings"
					" in a Mathematica readable format.");
		s.add_option("generate_finred_config", false, "boolean", ""//
					"Whether to export configuration to finred format.");
		s.add_option("sector_tree_dot_file", false, "string", ""//
					"Output file name for the sector tree dot-file."
					" This file can be converted to a graphic with the \"dot\" command."
					" If left empty, no sector tree is generated.");
		s.add_option("feynman_diagram_dot_file", false, "string", ""//
					"Output file name for the Feynman diagram dot-file."
					" This file can be converted to a graphic with the \"dot\" command."
					" Leave option empty to disable generation of Feynman diagrams.");
		s.add_option("feynman_diagram_mma_file", false, "string", ""//
					"Output file name for the Feynman diagram Mathematica file."
					" To process this output in Mathematica, please have a"
					" look at the Mathematica functions in the file \"reduze-mma.m\""
				    " distributed with Reduze in the directory \"tools\"."
					" Leave option empty to disable generation of Feynman diagrams.");
		s.add_option("minimize_graphs_by_twists", false, "boolean", ""//
					"This option only takes effect if the"
					" \"feynman_diagram_dot_file\" is not empty."
					" See the online help of the job \"setup_sector_mappings\""
					" for its documentation.");
		s.add_option("construct_minimal_graphs", false, "boolean", ""//
					"This option only takes effect if one of the"
					" \"feynman_diagram_*_file\" options is not empty."
					" See the online help of the job \"setup_sector_mappings\""
					" for its documentation.");
		s.add_options(Job::yaml_spec());
		return s;
	}
	virtual YAMLSpec yaml_spec_link() const {
		return yaml_spec();
	}
	PrintSectorInfo() :
		generate_finred_config_(false), minimize_graphs_by_twists_(true),
		construct_minimal_graphs_(false) {
		add_auto_options();
	}
	virtual ~PrintSectorInfo() {
	}
	virtual void run_serial();
	virtual bool find_dependencies(const std::set<std::string>&,//
			std::list<std::string>&, std::list<std::string>&, std::list<Job*>&);
	virtual std::string get_description() const;

protected:
	virtual void add_auto_options() {
		add_auto_io("integral_file", integral_file_);
		add_auto_io("config_info_mma_file", config_info_mma_file_);
		add_auto_io("sector_mappings_mma_file", sector_mappings_mma_file_);
		add_auto_io("generate_finred_config", generate_finred_config_);
		add_auto_io("sector_tree_dot_file", sector_tree_dot_file_);
		add_auto_io("feynman_diagram_dot_file", feynman_diagram_dot_file_);
		add_auto_io("feynman_diagram_mma_file", feynman_diagram_mma_file_);
		add_auto_io("minimize_graphs_by_twists", minimize_graphs_by_twists_);
		add_auto_io("construct_minimal_graphs", construct_minimal_graphs_);
	}
	virtual void print_manual_options(YAML::Emitter& os) const;
	virtual void read_manual_options(const YAML::Node&);
	virtual void init();

private:
	SectorSelection sector_selection_;
	std::string integral_file_, config_info_mma_file_, sector_mappings_mma_file_;
	std::string finred_template_file_prefix_, sector_tree_dot_file_;
	std::string feynman_diagram_dot_file_, feynman_diagram_mma_file_;
	bool generate_finred_config_;
	bool minimize_graphs_by_twists_;
	bool construct_minimal_graphs_;
};

}

#endif /* JOB_PRINTSECTORINFO_H_ */
