/*  job_setupcrossings.h
 *
 *  Copyright (C) 2010-2012 Andreas von Manteuffel
 *  Copyright (C) 2010-2012 Cedric Studerus
 *
 *  This file is part of the package Reduze 2.
 *  It is distributed under the GNU General Public License version 3
 *  (see the file GPL-3.0.txt or http://www.gnu.org/licenses/gpl-3.0.txt).
 */

#ifndef JOB_SETUP_CROSSINGS_H_
#define JOB_SETUP_CROSSINGS_H_

#include "job.h"

namespace Reduze {

/// Job to setup the crossings of the kinematics
class SetupCrossings: public Job {
public:
	static YAMLSpec yaml_spec() {
		YAMLSpec s;
		s.set_keyword("setup_crossings");
		s.set_short_description("Setup crossings of the kinematics");
		s.set_long_description("" //
						"This job determines the crosssings of external legs"
						" of the kinematics and writes them to the file"
						" \"crossings.yaml\". The valid crossings are those"
						" which exchange external momenta of external legs"
						" with the same mass and for which (together with"
						" the inverse) exist a unique corresponding transformation"
						" of the kinematic invariants. The generated crossing"
						" don't contain the identity crossing and are sorted"
						" according to a specific ordering. This ordering can"
						" be changed by hand. Still, modifications in the crossings"
						" file might invalidate the results in the sector mappings"
						" files.");
		s.add_options(Job::yaml_spec());
		return s;
	}
	virtual YAMLSpec yaml_spec_link() const {
		return yaml_spec();
	}
	SetupCrossings() {
		add_auto_options();
	}
	virtual ~SetupCrossings() {
	}
	virtual void run_serial();
	virtual bool find_dependencies(const std::set<std::string>&, //
			std::list<std::string>&, std::list<std::string>&, std::list<Job*>&);
	virtual std::string get_description() const;

protected:
	virtual void add_auto_options() {
	}
	virtual void init() {
	}

private:

};

}

#endif /* JOB_SETUP_CROSSINGS_H_ */
