/*
 * ssdp.c
 *
 * Copyright (C) 2009-11 - ipoque GmbH
 * Copyright (C) 2011-22 - ntop.org
 *
 * This file is part of nDPI, an open source deep packet inspection
 * library based on the OpenDPI and PACE technology by ipoque GmbH
 *
 * nDPI is free software: you can redistribute it and/or modify
 * it under the terms of the GNU Lesser General Public License as published by
 * the Free Software Foundation, either version 3 of the License, or
 * (at your option) any later version.
 *
 * nDPI is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU Lesser General Public License for more details.
 *
 * You should have received a copy of the GNU Lesser General Public License
 * along with nDPI.  If not, see <http://www.gnu.org/licenses/>.
 *
 */

#include "ndpi_protocol_ids.h"

#define NDPI_CURRENT_PROTO NDPI_PROTOCOL_SSDP

#include "ndpi_api.h"


static void ssdp_parse_lines(struct ndpi_detection_module_struct
					 *ndpi_struct, struct ndpi_flow_struct *flow)
{
  struct ndpi_packet_struct *packet = &ndpi_struct->packet;

  ndpi_parse_packet_line_info(ndpi_struct, flow);

  /* Save user-agent for device discovery if available */
  if(packet->user_agent_line.ptr != NULL && packet->user_agent_line.len > 0) {
    if (ndpi_user_agent_set(flow, packet->user_agent_line.ptr, packet->user_agent_line.len) == NULL)
    {
      NDPI_LOG_DBG2(ndpi_struct, "Could not set SSDP user agent\n");
    }
  }

  /* Save host which provides a service if available */
  if (packet->host_line.ptr != NULL && packet->host_line.len > 0) {
    if (ndpi_hostname_sni_set(flow, packet->host_line.ptr, packet->host_line.len) == NULL)
    {
      NDPI_LOG_DBG2(ndpi_struct, "Could not set SSDP host\n");
    }
  }
}

static void ndpi_int_ssdp_add_connection(struct ndpi_detection_module_struct
					 *ndpi_struct, struct ndpi_flow_struct *flow)
{
  ssdp_parse_lines(ndpi_struct, flow);
  ndpi_set_detected_protocol(ndpi_struct, flow, NDPI_PROTOCOL_SSDP, NDPI_PROTOCOL_UNKNOWN, NDPI_CONFIDENCE_DPI);
}

/* this detection also works asymmetrically */
static void ndpi_search_ssdp(struct ndpi_detection_module_struct *ndpi_struct, struct ndpi_flow_struct *flow)
{
  struct ndpi_packet_struct *packet = &ndpi_struct->packet;
	
  NDPI_LOG_DBG(ndpi_struct, "search ssdp\n");
  if (packet->udp != NULL) {

    if (packet->payload_packet_len >= 19) {
      if ((memcmp(packet->payload, "M-SEARCH * HTTP/1.1", 19) == 0)
	  || memcmp(packet->payload, "NOTIFY * HTTP/1.1", 17) == 0) {


	NDPI_LOG_INFO(ndpi_struct, "found ssdp\n");
	ndpi_int_ssdp_add_connection(ndpi_struct, flow);
	return;
      }

#define SSDP_HTTP "HTTP/1.1 200 OK\r\n"
      if(memcmp(packet->payload, SSDP_HTTP, strlen(SSDP_HTTP)) == 0) {
	NDPI_LOG_INFO(ndpi_struct, "found ssdp\n");
	ndpi_int_ssdp_add_connection(ndpi_struct, flow);
	return;
      }
    }
  }

  NDPI_EXCLUDE_PROTO(ndpi_struct, flow);
}


void init_ssdp_dissector(struct ndpi_detection_module_struct *ndpi_struct, u_int32_t *id)
{
  ndpi_set_bitmask_protocol_detection("SSDP", ndpi_struct, *id,
				      NDPI_PROTOCOL_SSDP,
				      ndpi_search_ssdp,
				      NDPI_SELECTION_BITMASK_PROTOCOL_V4_V6_UDP_WITH_PAYLOAD,
				      SAVE_DETECTION_BITMASK_AS_UNKNOWN,
				      ADD_TO_DETECTION_BITMASK);

  *id += 1;
}

