/*
 *  Copyright (C) 2005-2007 Renier Roth
 *  www.renier.de
 *
 *  This program is free software; you can redistribute it and/or
 *  modify it under the terms of the GNU General Public License
 *  as published by the Free Software Foundation; either version 2
 *  of the License, or any later version.
 *
 *  This program is distributed in the hope that it will be useful,
 *  but WITHOUT ANY WARRANTY; without even the implied warranty of
 *  MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 *  GNU General Public License for more details.
 *
 *  You should have received a copy of the GNU General Public License
 *  along with this program; if not, write to the Free Software
 *  Foundation, Inc., 59 Temple Place - Suite 330, Boston, MA  02111-1307, USA.
 */
package de.renier.vdr.channel.editor.actions;

import java.awt.event.ActionEvent;

import javax.swing.AbstractAction;
import javax.swing.ImageIcon;
import javax.swing.JOptionPane;

import de.renier.vdr.channel.editor.ChannelEditor;
import de.renier.vdr.channel.editor.Messages;

/**
 * AboutAction
 * 
 * @author <a href="mailto:editor@renier.de">Renier Roth</a>
 */
public class AboutAction extends AbstractAction {

  private static final long serialVersionUID = 7856431110839120458L;

  public AboutAction() {
    super(Messages.getString("AboutAction.0"), new ImageIcon(OpenAction.class.getResource("/org/javalobby/icons/20x20/About.gif"))); //$NON-NLS-1$ //$NON-NLS-2$
  }

  /*
   * (non-Javadoc)
   * 
   * @see java.awt.event.ActionListener#actionPerformed(java.awt.event.ActionEvent)
   */
  public void actionPerformed(ActionEvent e) {
    String text = Messages.getString("AboutAction.2") //$NON-NLS-1$
        + Messages.getString("AboutAction.3") //$NON-NLS-1$
        + Messages.getString("AboutAction.4") //$NON-NLS-1$
        + Messages.getString("AboutAction.5") //$NON-NLS-1$
        + Messages.getString("AboutAction.6") //$NON-NLS-1$
        + Messages.getString("AboutAction.7") //$NON-NLS-1$
        + Messages.getString("AboutAction.8") //$NON-NLS-1$
        + "<p>Mail: <a href=mailto:editor@renier.de>editor@renier.de</a></p>" //$NON-NLS-1$
        + "<p>Web: <a href=http://www.renier.de>www.renier.de</a></p>" //$NON-NLS-1$
        + Messages.getString("AboutAction.11") //$NON-NLS-1$
        + Messages.getString("AboutAction.12"); //$NON-NLS-1$
    JOptionPane.showMessageDialog(ChannelEditor.application, text, Messages.getString("AboutAction.13"), JOptionPane.PLAIN_MESSAGE); //$NON-NLS-1$
  }

}
