/*
 *  Copyright (C) 2005-2007 Renier Roth
 *  www.renier.de
 *
 *  This program is free software; you can redistribute it and/or
 *  modify it under the terms of the GNU General Public License
 *  as published by the Free Software Foundation; either version 2
 *  of the License, or any later version.
 *
 *  This program is distributed in the hope that it will be useful,
 *  but WITHOUT ANY WARRANTY; without even the implied warranty of
 *  MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 *  GNU General Public License for more details.
 *
 *  You should have received a copy of the GNU General Public License
 *  along with this program; if not, write to the Free Software
 *  Foundation, Inc., 59 Temple Place - Suite 330, Boston, MA  02111-1307, USA.
 */
package de.renier.vdr.channel.editor.actions;

import java.awt.event.ActionEvent;

import javax.swing.AbstractAction;
import javax.swing.ImageIcon;
import javax.swing.tree.DefaultMutableTreeNode;
import javax.swing.tree.TreePath;

import de.renier.vdr.channel.editor.ChannelEditor;
import de.renier.vdr.channel.editor.Messages;

/**
 * DeleteChannelAction
 * 
 * @author <a href="mailto:editor@renier.de">Renier Roth</a>
 */
public class DeleteChannelAction extends AbstractAction {

  private static final long serialVersionUID = 6747582260891504538L;

  public DeleteChannelAction() {
    super(Messages.getString("DeleteChannelAction.0"), new ImageIcon(OpenAction.class.getResource("/org/javalobby/icons/20x20/Delete.gif"))); //$NON-NLS-1$ //$NON-NLS-2$
    this.setEnabled(false);
  }

  /*
   * (non-Javadoc)
   * 
   * @see java.awt.event.ActionListener#actionPerformed(java.awt.event.ActionEvent)
   */
  public void actionPerformed(ActionEvent e) {
    TreePath[] treepaths = ChannelEditor.application.getChannelListingPanel().getSelectionPaths();
    if (treepaths != null) {
      for (int i = 0; i < treepaths.length; i++) {
        TreePath path = treepaths[i];
        DefaultMutableTreeNode node = (DefaultMutableTreeNode) path.getLastPathComponent();
        if (!node.isRoot()) {
          DefaultMutableTreeNode parentNode = (DefaultMutableTreeNode) node.getParent();
          node.removeFromParent();
          ChannelEditor.application.getChannelDeletedPanel().addElement(node);
          ChannelEditor.application.getChannelListingPanel().treeNodeStructureChanged(parentNode);
        }
      }
      // mark modified
      ChannelEditor.application.setModified(true);
    }
  }

}
