/*
 *  Copyright (C) 2005-2007 Renier Roth
 *  www.renier.de
 *
 *  This program is free software; you can redistribute it and/or
 *  modify it under the terms of the GNU General Public License
 *  as published by the Free Software Foundation; either version 2
 *  of the License, or any later version.
 *
 *  This program is distributed in the hope that it will be useful,
 *  but WITHOUT ANY WARRANTY; without even the implied warranty of
 *  MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 *  GNU General Public License for more details.
 *
 *  You should have received a copy of the GNU General Public License
 *  along with this program; if not, write to the Free Software
 *  Foundation, Inc., 59 Temple Place - Suite 330, Boston, MA  02111-1307, USA.
 */
package de.renier.vdr.channel.editor.actions;

import java.awt.event.ActionEvent;

import javax.swing.AbstractAction;
import javax.swing.ImageIcon;
import javax.swing.JOptionPane;

import de.renier.vdr.channel.editor.ChannelEditor;
import de.renier.vdr.channel.editor.ChannelSearchInputDialog;
import de.renier.vdr.channel.editor.Messages;
import de.renier.vdr.channel.editor.SearchFilter;

/**
 * SearchAction
 * 
 * @author <a href="mailto:editor@renier.de">Renier Roth</a>
 */
public class SearchAction extends AbstractAction {

  private static final long serialVersionUID = 4641553196118160415L;
  private String lastSearchText = null;

  public SearchAction() {
    super(Messages.getString("SearchAction.0"), new ImageIcon(OpenAction.class.getResource("/org/javalobby/icons/20x20/Binocular.gif"))); //$NON-NLS-1$ //$NON-NLS-2$
  }

  /*
   * (non-Javadoc)
   * 
   * @see java.awt.event.ActionListener#actionPerformed(java.awt.event.ActionEvent)
   */
  public void actionPerformed(ActionEvent e) {
    ChannelSearchInputDialog searchDialog = new ChannelSearchInputDialog(ChannelEditor.application);
    int result = searchDialog.showSearchDialog(this.lastSearchText);
    if (result == ChannelSearchInputDialog.RESULT_SEARCH) {
      // get search filter
      SearchFilter filter = searchDialog.getSearchFilter();
      this.lastSearchText = filter.getSearchText();
      if (!ChannelEditor.application.getChannelListingPanel().selectAllNodesFiltered(filter)) {
        JOptionPane.showMessageDialog(ChannelEditor.application, Messages.getString("SearchAction.2") //$NON-NLS-1$
            + this.lastSearchText, Messages.getString("SearchAction.3"), JOptionPane.INFORMATION_MESSAGE); //$NON-NLS-1$
      }
    }
  }

}
