/*
 *  Copyright (C) 2005-2007 Renier Roth
 *  www.renier.de
 *
 *  This program is free software; you can redistribute it and/or
 *  modify it under the terms of the GNU General Public License
 *  as published by the Free Software Foundation; either version 2
 *  of the License, or any later version.
 *
 *  This program is distributed in the hope that it will be useful,
 *  but WITHOUT ANY WARRANTY; without even the implied warranty of
 *  MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 *  GNU General Public License for more details.
 *
 *  You should have received a copy of the GNU General Public License
 *  along with this program; if not, write to the Free Software
 *  Foundation, Inc., 59 Temple Place - Suite 330, Boston, MA  02111-1307, USA.
 */
package de.renier.vdr.channel.editor.actions;

import java.awt.event.ActionEvent;
import java.io.File;
import java.util.Enumeration;

import javax.swing.AbstractAction;
import javax.swing.ImageIcon;
import javax.swing.JOptionPane;
import javax.swing.tree.DefaultMutableTreeNode;

import de.renier.vdr.channel.ChannelElement;
import de.renier.vdr.channel.editor.ChannelEditor;
import de.renier.vdr.channel.editor.Messages;

/**
 * StatisticAction
 * 
 * @author <a href="mailto:editor@renier.de">Renier Roth</a>
 */
public class StatisticAction extends AbstractAction {

  private static final long serialVersionUID = 3622986105654998770L;

  public StatisticAction() {
    super(Messages.getString("StatisticAction.0"), new ImageIcon(OpenAction.class.getResource("/org/javalobby/icons/20x20/Calculator.gif"))); //$NON-NLS-1$ //$NON-NLS-2$
  }

  /*
   * (non-Javadoc)
   * 
   * @see java.awt.event.ActionListener#actionPerformed(java.awt.event.ActionEvent)
   */
  public void actionPerformed(ActionEvent e) {
    // get root node
    DefaultMutableTreeNode rootNode = ChannelEditor.application.getChannelListingPanel().getRootNode();
    // read some infos
    File loadedFile = ChannelEditor.application.getChannelFile();
    String loadedFilename = ""; //$NON-NLS-1$
    String loadedFilepath = ""; //$NON-NLS-1$
    long loadedFilesize = 0;
    if (loadedFile != null) {
      loadedFilename = loadedFile.getName();
      loadedFilepath = loadedFile.getParent();
      loadedFilesize = loadedFile.length();
    }
    int countCategories = 0;
    int countChannels = 0;
    int countTV = 0;
    int countRadio = 0;
    int countService = 0;
    long newFilesize = 0;

    // loop through nodes
    Enumeration enumer = rootNode.preorderEnumeration();
    while (enumer.hasMoreElements()) {
      DefaultMutableTreeNode mutNode = (DefaultMutableTreeNode) enumer.nextElement();
      ChannelElement channelElement = (ChannelElement) mutNode.getUserObject();
      if (channelElement.isCategory()) {
        countCategories++;
      } else {
        if (!mutNode.isRoot()) {
          countChannels++;
        }
        if (channelElement.isTelevision()) {
          countTV++;
        } else if (channelElement.isRadio()) {
          countRadio++;
        } else if (channelElement.isService()) {
          countService++;
        }
      }
      // get filesize
      newFilesize += channelElement.outputString().length();
    }

    String text = Messages.getString("StatisticAction.4") + Messages.getString("StatisticAction.5") + Messages.getString("StatisticAction.6") //$NON-NLS-1$ //$NON-NLS-2$ //$NON-NLS-3$
        + Messages.getString("StatisticAction.7") + Messages.getString("StatisticAction.8") + loadedFilename //$NON-NLS-1$ //$NON-NLS-2$
        + Messages.getString("StatisticAction.9") + Messages.getString("StatisticAction.10") + loadedFilepath //$NON-NLS-1$ //$NON-NLS-2$
        + Messages.getString("StatisticAction.11") + Messages.getString("StatisticAction.12") //$NON-NLS-1$ //$NON-NLS-2$
        + loadedFilesize + Messages.getString("StatisticAction.13") + Messages.getString("StatisticAction.14") + Messages.getString("StatisticAction.15") + Messages.getString("StatisticAction.16") //$NON-NLS-1$ //$NON-NLS-2$ //$NON-NLS-3$ //$NON-NLS-4$
        + Messages.getString("StatisticAction.17") + countChannels //$NON-NLS-1$
        + Messages.getString("StatisticAction.18") + Messages.getString("StatisticAction.19") //$NON-NLS-1$ //$NON-NLS-2$
        + countCategories + Messages.getString("StatisticAction.20") + Messages.getString("StatisticAction.21") //$NON-NLS-1$ //$NON-NLS-2$
        + countTV + Messages.getString("StatisticAction.22") + Messages.getString("StatisticAction.23") //$NON-NLS-1$ //$NON-NLS-2$
        + countRadio + Messages.getString("StatisticAction.24") + Messages.getString("StatisticAction.25") //$NON-NLS-1$ //$NON-NLS-2$
        + countService + Messages.getString("StatisticAction.26") //$NON-NLS-1$
        + Messages.getString("StatisticAction.27") + newFilesize //$NON-NLS-1$
        + Messages.getString("StatisticAction.28") + Messages.getString("StatisticAction.29") + Messages.getString("StatisticAction.30"); //$NON-NLS-1$ //$NON-NLS-2$ //$NON-NLS-3$
    JOptionPane.showMessageDialog(ChannelEditor.application, text, Messages.getString("StatisticAction.31"), JOptionPane.PLAIN_MESSAGE); //$NON-NLS-1$
  }

}
