#ifndef _CPINT_H
# define _CPINT_H

/************************************************************/
/*                                                          */
/*                     DEFINES                              */
/*                     -------                              */
/*                                                          */
/************************************************************/

#ifndef CPINT_MAJOR
# define CPINT_MAJOR 0		/* dynamic major by default     */
#endif

#ifndef CPINT_NR_DEVS
# define CPINT_NR_DEVS 256	/* cpint0 through cpint255      */
#endif

/*=============== End of Defines ===========================*/

/************************************************************/
/*                                                          */
/*              TYPE DEFINITIONS                            */
/*              ----------------                            */
/*                                                          */
/************************************************************/

typedef struct CPInt_Dev {
	void *devExt;		/* Device type extension     */
	uid_t devOwner;		/* Current owner of device   */
	int devLock;		/* Lock word for device      */
	wait_queue_head_t devWait;	/* Wait queue for device     */
} CPInt_Dev;

#define count_t unsigned long

/*================== End of Type Definitions ===============*/

/************************************************************/
/*                                                          */
/*             FUNCTION PROTOTYPES                          */
/*             -------------------                          */
/*                                                          */
/************************************************************/

int cpcmd_open(struct inode *, struct file *);
int cpcmd_release(struct inode *, struct file *);
ssize_t cpcmd_read(struct file *, char *, size_t, loff_t *);
ssize_t cpcmd_write(struct file *, const char *, size_t, loff_t *);
int cpcmd_ioctl(struct inode *, struct file *, unsigned int, unsigned long);
int applmon_open(struct inode *, struct file *);
int applmon_release(struct inode *, struct file *);
ssize_t applmon_write(struct file *, const char *, size_t, loff_t *);
int account_open(struct inode *, struct file *);
int account_release(struct inode *, struct file *);
ssize_t account_write(struct file *, const char *, size_t, loff_t *);
int applmon_ioctl(struct inode *, struct file *, unsigned int, unsigned long);
int idcmd_open(struct inode *, struct file *);
int idcmd_release(struct inode *, struct file *);
int idcmd_ioctl(struct inode *, struct file *, unsigned int, unsigned long);

/*================== End of Prototypes =====================*/

/************************************************************/
/*                                                          */
/*           GLOBAL VARIABLE DECLARATIONS                   */
/*           ----------------------------                   */
/*                                                          */
/************************************************************/

extern int cpint_nr_devs;

extern CPInt_Dev *cpint_devices;

/*================== End of Global Variables ===============*/

#endif
