/************************************************************/
/*                                                          */
/* Module ID  - mongen.                                     */
/*                                                          */
/* Function   - Generate CP APPLMON data.                   */
/*                                                          */
/* Called By  - N/A.                                        */
/*                                                          */
/* Calling To - N/A.                                        */
/*                                                          */
/* Parameters - None.                                       */
/*                                                          */
/* Notes      - (1) Uses /dev/applmonx to communicate.      */
/*                                                          */
/*              (2) ....................................... */
/*                                                          */
/*                                                          */
/* Name       - Neale Ferguson.                             */
/*                                                          */
/* Date       - January, 2000.                              */
/*                                                          */
/*                                                          */
/* Associated    - (1) Refer To ........................... */
/* Documentation                                            */
/*                 (2) Refer To ........................... */
/*                                                          */
/************************************************************/

/************************************************************/
/*                                                          */
/*                     DEFINES                              */
/*                     -------                              */
/*                                                          */
/************************************************************/

#define MONDEV "/dev/cpmon"

#ifdef __s390x__
# define APPLMON_START_REC 0x80
# define APPLMON_STOP_REC  0x81
# define APPLMON_GEN_EVENT 0x82
# define APPLMON_START_CON 0x83
# define APPLMON_PUT_SAMP  0x84
#else
# define APPLMON_START_REC 0x00
# define APPLMON_STOP_REC  0x01
# define APPLMON_GEN_EVENT 0x02
# define APPLMON_START_CON 0x03
# define APPLMON_PUT_SAMP  0x04
#endif

/*=============== End of Defines ===========================*/

/************************************************************/
/*                                                          */
/*              INCLUDE STATEMENTS                          */
/*              ------------------                          */
/*                                                          */
/************************************************************/

#include <stdio.h>
#include <unistd.h>
#include <errno.h>
#include <fcntl.h>
#include <string.h>
#include <linux/ioctl.h>

/*================== End of Include Statements =============*/

/************************************************************/
/*                                                          */
/*              TYPE DEFINITIONS                            */
/*              ----------------                            */
/*                                                          */
/************************************************************/

/* Use 'l' as magic number */
#define APPLMON_IOC_MAGIC  'l'

#define APPLMON_IOCRESET    _IO(APPLMON_IOC_MAGIC, 0)
#define MONSETPROD          _IOW(APPLMON_IOC_MAGIC, 1, char *)

/*================== End of Type Definitions ===============*/

/************************************************************/
/*                                                          */
/*             FUNCTION PROTOTYPES                          */
/*             -------------------                          */
/*                                                          */
/************************************************************/

/*================== End of Prototypes =====================*/

/************************************************************/
/*                                                          */
/*           GLOBAL VARIABLE DECLARATIONS                   */
/*           ----------------------------                   */
/*                                                          */
/************************************************************/

/*============== End of Variable Declarations ==============*/

/************************************************************/
/*                                                          */
/* Name       - main.                                       */
/*                                                          */
/* Function   - Open the CP monitor device.                 */
/*                                                          */
/* Parameters - inode -                                     */
/*              filp  -                                     */
/*                                                          */
/************************************************************/

int
main(int argc, char **argv)
{
	int fd, rc, l_monitor, i_arg, exitRc = 0;
	struct {
		char fcn;
		char data[512];
	} mon;
	char *product_id = "MONGENPRODUC0000";

	if (argc < 2) {
		exitRc = -1;
		fprintf(stderr, "Correct form: mongen <mondata>\n");
	} else {
		mon.data[0] = 0;
		for (i_arg = 1;
		     strlen(mon.data) < sizeof (mon.data) && i_arg < argc;
		     i_arg++) {
			l_monitor = sizeof (mon.data) - strlen(mon.data) - 2;
			strncat(mon.data, argv[i_arg], l_monitor);
			l_monitor += 2;
			strncat(mon.data, " ", l_monitor);
		}
		mon.fcn = APPLMON_GEN_EVENT;
		fd = open(MONDEV, O_RDWR);
		if (fd >= 0) {
			rc = ioctl(fd, MONSETPROD, &product_id);
			rc = write(fd, (char *) &mon, l_monitor);
			if (rc < 0) {
				exitRc = errno;
				fprintf(stderr, "Write: %s\n", strerror(errno));
			}
		} else {
			exitRc = errno;
			fprintf(stderr, "Open: %s\n", strerror(errno));
		}
		if (close(fd) < 0)
			fprintf(stderr, "Close: %s\n", strerror(errno));
	}
	exit(exitRc);
}

/*===================== End of Function ====================*/
