/*
 * Decompiled with CFR 0.152.
 */
package com.jetbrains.python.codeInsight;

import com.intellij.extapi.psi.ASTWrapperPsiElement;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiReference;
import com.intellij.util.Function;
import com.jetbrains.python.codeInsight.PyCustomMember;
import com.jetbrains.python.codeInsight.PyCustomMemberProvider;
import com.jetbrains.python.codeInsight.PyCustomMemberTypeInfo;
import com.jetbrains.python.psi.PyClass;
import com.jetbrains.python.psi.PyPsiFacade;
import com.jetbrains.python.psi.PyTypedElement;
import com.jetbrains.python.psi.types.PyClassType;
import com.jetbrains.python.psi.types.PyType;
import com.jetbrains.python.psi.types.TypeEvalContext;
import java.util.Objects;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

final class PyCustomMemberProviderImpl
extends PyCustomMemberProvider {
    PyCustomMemberProviderImpl() {
    }

    @Override
    public PyTypedElement createPyCustomMemberTarget(PyCustomMember member, PyClass clazz, PsiElement context, PsiElement resolveTarget, Function<? super PsiElement, ? extends PyType> typeCallback, PyCustomMemberTypeInfo<?> customTypeInfo, boolean resolveToInstance) {
        return new MyInstanceElement(member, clazz, context, resolveTarget, typeCallback, customTypeInfo, resolveToInstance);
    }

    @Override
    public boolean isReferenceToMe(PsiReference reference, PyCustomMember member) {
        PsiElement element = reference.resolve();
        if (!(element instanceof MyInstanceElement)) {
            return false;
        }
        return ((MyInstanceElement)element).getThis().equals((Object)member);
    }

    private static class MyInstanceElement
    extends ASTWrapperPsiElement
    implements PyTypedElement {
        private final PyCustomMember myMember;
        private final PyClass myClass;
        private final PsiElement myContext;
        private final Function<? super PsiElement, ? extends PyType> myTypeCallback;
        private final PyCustomMemberTypeInfo<?> myCustomTypeInfo;
        private final boolean myResolveToInstance;

        MyInstanceElement(PyCustomMember member, PyClass clazz, PsiElement context, PsiElement resolveTarget, Function<? super PsiElement, ? extends PyType> typeCallback, PyCustomMemberTypeInfo<?> customTypeInfo, boolean resolveToInstance) {
            super(resolveTarget != null ? resolveTarget.getNode() : clazz.getNode());
            this.myMember = member;
            this.myClass = clazz;
            this.myContext = context;
            this.myTypeCallback = typeCallback;
            this.myCustomTypeInfo = customTypeInfo;
            this.myResolveToInstance = resolveToInstance;
        }

        private PyCustomMember getThis() {
            return this.myMember;
        }

        public boolean equals(Object o) {
            if (this == o) {
                return true;
            }
            if (o == null || this.getClass() != o.getClass()) {
                return false;
            }
            MyInstanceElement element = (MyInstanceElement)o;
            return Objects.equals((Object)this.getThis(), (Object)element.getThis()) && Objects.equals(this.myClass, element.myClass) && Objects.equals(this.myContext, element.myContext) && Objects.equals(this.getNode(), element.getNode());
        }

        public String toString() {
            return "MyInstanceElement{myClass=" + this.myClass + "member=" + this.getThis() + "node=" + this.getNode() + ", myContext=" + this.myContext + "}";
        }

        public int hashCode() {
            return Objects.hash(new Object[]{this.myClass, this.myContext, this.getNode(), this.getThis()});
        }

        @Override
        @Nullable
        public PyType getType(@NotNull TypeEvalContext context, @NotNull TypeEvalContext.Key key) {
            if (context == null) {
                MyInstanceElement.$$$reportNull$$$0(0);
            }
            if (key == null) {
                MyInstanceElement.$$$reportNull$$$0(1);
            }
            if (this.myTypeCallback != null) {
                return (PyType)this.myTypeCallback.fun((Object)this.myContext);
            }
            if (this.myClass != null) {
                PyClassType type2 = PyPsiFacade.getInstance(this.getProject()).createClassType(this.myClass, !this.myResolveToInstance);
                if (this.myCustomTypeInfo != null) {
                    this.myCustomTypeInfo.fill(type2);
                }
                return type2;
            }
            return null;
        }

        private static /* synthetic */ void $$$reportNull$$$0(int n) {
            Object[] objectArray;
            Object[] objectArray2 = new Object[3];
            switch (n) {
                default: {
                    objectArray = objectArray2;
                    objectArray2[0] = "context";
                    break;
                }
                case 1: {
                    objectArray = objectArray2;
                    objectArray2[0] = "key";
                    break;
                }
            }
            objectArray[1] = "com/jetbrains/python/codeInsight/PyCustomMemberProviderImpl$MyInstanceElement";
            objectArray[2] = "getType";
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", objectArray));
        }
    }
}

