/*
 * Decompiled with CFR 0.152.
 */
package com.jetbrains.python.inspections.quickfix;

import com.google.common.collect.Lists;
import com.intellij.codeInspection.LocalQuickFix;
import com.intellij.codeInspection.ProblemDescriptor;
import com.intellij.execution.ExecutionException;
import com.intellij.execution.configurations.GeneralCommandLine;
import com.intellij.execution.process.ProcessOutput;
import com.intellij.openapi.diagnostic.Logger;
import com.intellij.openapi.module.Module;
import com.intellij.openapi.module.ModuleUtilCore;
import com.intellij.openapi.progress.ProgressIndicator;
import com.intellij.openapi.progress.ProgressManager;
import com.intellij.openapi.progress.Task;
import com.intellij.openapi.progress.impl.BackgroundableProcessIndicator;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.projectRoots.Sdk;
import com.intellij.openapi.util.text.StringUtil;
import com.intellij.openapi.vfs.LocalFileSystem;
import com.intellij.openapi.vfs.VirtualFile;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiFile;
import com.intellij.psi.util.QualifiedName;
import com.jetbrains.python.PyBundle;
import com.jetbrains.python.PythonHelper;
import com.jetbrains.python.psi.PyFromImportStatement;
import com.jetbrains.python.psi.PyImportStatementBase;
import com.jetbrains.python.sdk.InvalidSdkException;
import com.jetbrains.python.sdk.PySdkUtil;
import com.jetbrains.python.sdk.PythonSdkUtil;
import com.jetbrains.python.sdk.skeletons.PySkeletonGenerator;
import com.jetbrains.python.sdk.skeletons.PySkeletonRefresher;
import java.io.File;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public final class GenerateBinaryStubsFix
implements LocalQuickFix {
    private static final Logger LOG = Logger.getInstance(GenerateBinaryStubsFix.class);
    private final String myQualifiedName;
    private final Sdk mySdk;

    @NotNull
    public static Collection<LocalQuickFix> generateFixes(@NotNull PyImportStatementBase importStatementBase) {
        QualifiedName qName;
        if (importStatementBase == null) {
            GenerateBinaryStubsFix.$$$reportNull$$$0(0);
        }
        List names = importStatementBase.getFullyQualifiedObjectNames();
        ArrayList<LocalQuickFix> result2 = new ArrayList<LocalQuickFix>(names.size());
        if (importStatementBase instanceof PyFromImportStatement && names.isEmpty() && (qName = ((PyFromImportStatement)importStatementBase).getImportSourceQName()) != null) {
            result2.add(new GenerateBinaryStubsFix(importStatementBase, qName.toString()));
        }
        for (String qualifiedName : names) {
            result2.add(new GenerateBinaryStubsFix(importStatementBase, qualifiedName));
        }
        ArrayList<LocalQuickFix> arrayList = result2;
        if (arrayList == null) {
            GenerateBinaryStubsFix.$$$reportNull$$$0(1);
        }
        return arrayList;
    }

    private GenerateBinaryStubsFix(@NotNull PyImportStatementBase importStatementBase, @NotNull String qualifiedName) {
        if (importStatementBase == null) {
            GenerateBinaryStubsFix.$$$reportNull$$$0(2);
        }
        if (qualifiedName == null) {
            GenerateBinaryStubsFix.$$$reportNull$$$0(3);
        }
        this.myQualifiedName = qualifiedName;
        this.mySdk = GenerateBinaryStubsFix.getPythonSdk((PsiElement)importStatementBase);
    }

    @NotNull
    public String getName() {
        String string = PyBundle.message("sdk.gen.stubs.for.binary.modules", this.myQualifiedName);
        if (string == null) {
            GenerateBinaryStubsFix.$$$reportNull$$$0(4);
        }
        return string;
    }

    @NotNull
    public String getFamilyName() {
        String string = PyBundle.message("QFIX.generate.binary.stubs", new Object[0]);
        if (string == null) {
            GenerateBinaryStubsFix.$$$reportNull$$$0(5);
        }
        return string;
    }

    public boolean startInWriteAction() {
        return false;
    }

    public void applyFix(@NotNull Project project, @NotNull ProblemDescriptor descriptor2) {
        if (project == null) {
            GenerateBinaryStubsFix.$$$reportNull$$$0(6);
        }
        if (descriptor2 == null) {
            GenerateBinaryStubsFix.$$$reportNull$$$0(7);
        }
        PsiFile file = descriptor2.getPsiElement().getContainingFile();
        Task.Backgroundable backgroundable = this.getFixTask(file);
        ProgressManager.getInstance().runProcessWithProgressAsynchronously(backgroundable, (ProgressIndicator)new BackgroundableProcessIndicator(backgroundable));
    }

    @NotNull
    public Task.Backgroundable getFixTask(@NotNull PsiFile fileToRunTaskIn) {
        if (fileToRunTaskIn == null) {
            GenerateBinaryStubsFix.$$$reportNull$$$0(8);
        }
        final Project project = fileToRunTaskIn.getProject();
        final String folder = fileToRunTaskIn.getContainingDirectory().getVirtualFile().getCanonicalPath();
        return new Task.Backgroundable(project, PyBundle.message("QFIX.generating.skeletons.for.binary.module", new Object[0]), false){

            public void run(@NotNull ProgressIndicator indicator) {
                if (indicator == null) {
                    1.$$$reportNull$$$0(0);
                }
                indicator.setIndeterminate(true);
                try {
                    VirtualFile skeletonDir;
                    PySkeletonRefresher refresher = new PySkeletonRefresher(project, null, GenerateBinaryStubsFix.this.mySdk, null, null, folder);
                    if (GenerateBinaryStubsFix.isFromGiRepository(GenerateBinaryStubsFix.this.myQualifiedName)) {
                        if (!GenerateBinaryStubsFix.this.generateSkeletonsForGiRepository(refresher, indicator, folder)) {
                            return;
                        }
                    } else {
                        refresher.getGenerator().commandBuilder().targetModule(GenerateBinaryStubsFix.this.myQualifiedName, null).runGeneration(indicator);
                    }
                    if ((skeletonDir = LocalFileSystem.getInstance().findFileByPath(refresher.getSkeletonsPath())) != null) {
                        skeletonDir.refresh(true, true);
                    }
                }
                catch (ExecutionException | InvalidSdkException e) {
                    LOG.error(e);
                }
            }

            private static /* synthetic */ void $$$reportNull$$$0(int n) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "indicator", "com/jetbrains/python/inspections/quickfix/GenerateBinaryStubsFix$1", "run"));
            }
        };
    }

    private boolean generateSkeletonsForGiRepository(@NotNull PySkeletonRefresher refresher, @NotNull ProgressIndicator indicator, @Nullable String currentBinaryFilesPath) throws InvalidSdkException, ExecutionException {
        String homePath;
        if (refresher == null) {
            GenerateBinaryStubsFix.$$$reportNull$$$0(9);
        }
        if (indicator == null) {
            GenerateBinaryStubsFix.$$$reportNull$$$0(10);
        }
        if ((homePath = this.mySdk.getHomePath()) == null) {
            return false;
        }
        GeneralCommandLine cmd = PythonHelper.EXTRA_SYSPATH.newCommandLine(homePath, (List<String>)Lists.newArrayList((Object[])new String[]{this.myQualifiedName}));
        ProcessOutput runResult = PySdkUtil.getProcessOutput(cmd, new File(homePath).getParent(), PySdkUtil.activateVirtualEnv(this.mySdk), 5000);
        if (runResult.checkSuccess(LOG)) {
            PySkeletonGenerator.Builder builder = refresher.getGenerator().commandBuilder().extraSysPath(StringUtil.split((String)runResult.getStdout(), (String)File.pathSeparator)).extraArgs("--name-pattern", "gi.repository.*");
            if (currentBinaryFilesPath != null) {
                builder.workingDir(currentBinaryFilesPath);
            }
            builder.runGeneration(indicator);
        }
        return true;
    }

    private static boolean isFromGiRepository(@NotNull String qualifiedName) {
        if (qualifiedName == null) {
            GenerateBinaryStubsFix.$$$reportNull$$$0(11);
        }
        return qualifiedName.startsWith("gi.repository");
    }

    public static boolean isApplicable(@NotNull PyImportStatementBase importStatementBase) {
        if (importStatementBase == null) {
            GenerateBinaryStubsFix.$$$reportNull$$$0(12);
        }
        if (!(!importStatementBase.getFullyQualifiedObjectNames().isEmpty() || importStatementBase instanceof PyFromImportStatement && ((PyFromImportStatement)importStatementBase).isStarImport())) {
            return false;
        }
        return GenerateBinaryStubsFix.isGtk(importStatementBase);
    }

    private static boolean isGtk(@NotNull PyImportStatementBase importStatementBase) {
        QualifiedName qName;
        if (importStatementBase == null) {
            GenerateBinaryStubsFix.$$$reportNull$$$0(13);
        }
        return importStatementBase instanceof PyFromImportStatement && (qName = ((PyFromImportStatement)importStatementBase).getImportSourceQName()) != null && qName.matches(new String[]{"gi", "repository"});
    }

    @Nullable
    private static Sdk getPythonSdk(@NotNull PsiElement element) {
        Module module;
        if (element == null) {
            GenerateBinaryStubsFix.$$$reportNull$$$0(14);
        }
        return (module = ModuleUtilCore.findModuleForPsiElement((PsiElement)element)) == null ? null : PythonSdkUtil.findPythonSdk(module);
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        Object[] objectArray;
        Object[] objectArray2;
        Object[] objectArray3 = new Object[switch (n) {
            default -> 3;
            case 1, 4, 5 -> 2;
        }];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "importStatementBase";
                break;
            }
            case 1: 
            case 4: 
            case 5: {
                objectArray2 = objectArray3;
                objectArray3[0] = "com/jetbrains/python/inspections/quickfix/GenerateBinaryStubsFix";
                break;
            }
            case 3: 
            case 11: {
                objectArray2 = objectArray3;
                objectArray3[0] = "qualifiedName";
                break;
            }
            case 6: {
                objectArray2 = objectArray3;
                objectArray3[0] = "project";
                break;
            }
            case 7: {
                objectArray2 = objectArray3;
                objectArray3[0] = "descriptor";
                break;
            }
            case 8: {
                objectArray2 = objectArray3;
                objectArray3[0] = "fileToRunTaskIn";
                break;
            }
            case 9: {
                objectArray2 = objectArray3;
                objectArray3[0] = "refresher";
                break;
            }
            case 10: {
                objectArray2 = objectArray3;
                objectArray3[0] = "indicator";
                break;
            }
            case 14: {
                objectArray2 = objectArray3;
                objectArray3[0] = "element";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "com/jetbrains/python/inspections/quickfix/GenerateBinaryStubsFix";
                break;
            }
            case 1: {
                objectArray = objectArray2;
                objectArray2[1] = "generateFixes";
                break;
            }
            case 4: {
                objectArray = objectArray2;
                objectArray2[1] = "getName";
                break;
            }
            case 5: {
                objectArray = objectArray2;
                objectArray2[1] = "getFamilyName";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray;
                objectArray[2] = "generateFixes";
                break;
            }
            case 1: 
            case 4: 
            case 5: {
                break;
            }
            case 2: 
            case 3: {
                objectArray = objectArray;
                objectArray[2] = "<init>";
                break;
            }
            case 6: 
            case 7: {
                objectArray = objectArray;
                objectArray[2] = "applyFix";
                break;
            }
            case 8: {
                objectArray = objectArray;
                objectArray[2] = "getFixTask";
                break;
            }
            case 9: 
            case 10: {
                objectArray = objectArray;
                objectArray[2] = "generateSkeletonsForGiRepository";
                break;
            }
            case 11: {
                objectArray = objectArray;
                objectArray[2] = "isFromGiRepository";
                break;
            }
            case 12: {
                objectArray = objectArray;
                objectArray[2] = "isApplicable";
                break;
            }
            case 13: {
                objectArray = objectArray;
                objectArray[2] = "isGtk";
                break;
            }
            case 14: {
                objectArray = objectArray;
                objectArray[2] = "getPythonSdk";
                break;
            }
        }
        String string = String.format(v0, objectArray);
        throw switch (n) {
            default -> new IllegalArgumentException(string);
            case 1, 4, 5 -> new IllegalStateException(string);
        };
    }
}

