/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.testFramework.common;

import com.intellij.util.ReflectionUtil;
import java.awt.event.ActionListener;
import java.lang.reflect.Method;
import java.util.Arrays;
import java.util.concurrent.DelayQueue;
import java.util.concurrent.TimeUnit;
import javax.swing.Timer;
import kotlin.Metadata;
import kotlin.collections.CollectionsKt;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.ApiStatus;
import org.jetbrains.annotations.TestOnly;

@Metadata(mv={2, 0, 0}, k=2, xi=48, d1={"\u0000\b\n\u0000\n\u0002\u0010\u0002\n\u0000\u001a\b\u0010\u0000\u001a\u00020\u0001H\u0007\u00a8\u0006\u0002"}, d2={"checkJavaSwingTimersAreDisposed", "", "intellij.platform.testFramework.common"})
public final class ThreadUtilKt {
    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @TestOnly
    @ApiStatus.Internal
    public static final void checkJavaSwingTimersAreDisposed() {
        Class<?> timerQueueClass = Class.forName("javax.swing.TimerQueue");
        Method sharedInstance = timerQueueClass.getMethod("sharedInstance", new Class[0]);
        sharedInstance.setAccessible(true);
        Object timerQueue = sharedInstance.invoke(null, new Object[0]);
        DelayQueue delayQueue = (DelayQueue)ReflectionUtil.getField(timerQueueClass, (Object)timerQueue, DelayQueue.class, (String)"queue");
        Object timer = delayQueue.peek();
        if (timer == null) {
            return;
        }
        long delay2 = timer.getDelay(TimeUnit.MILLISECONDS);
        String text = "(delayed for " + delay2 + "ms)";
        Method method = ReflectionUtil.getDeclaredMethod(timer.getClass(), (String)"getTimer", (Class[])new Class[0]);
        Intrinsics.checkNotNull((Object)method);
        Method getTimer = method;
        Object object = getTimer.invoke(timer, new Object[0]);
        Intrinsics.checkNotNull((Object)object, (String)"null cannot be cast to non-null type javax.swing.Timer");
        Timer swingTimer = (Timer)object;
        ActionListener[] actionListenerArray = swingTimer.getActionListeners();
        text = "Timer (listeners: " + CollectionsKt.listOf((Object[])Arrays.copyOf(actionListenerArray, actionListenerArray.length)) + ") " + text;
        try {
            throw new AssertionError((Object)("Not disposed javax.swing.Timer: " + text + "; queue:" + timerQueue));
        }
        catch (Throwable throwable) {
            swingTimer.stop();
            throw throwable;
        }
    }
}

