/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.completion.full.line.local;

import com.intellij.openapi.util.SystemInfoRt;
import com.intellij.util.system.CpuArch;
import java.util.Locale;
import kotlin.Metadata;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.completion.full.line.LocalInferenceType;
import org.jetbrains.completion.full.line.LocalModelDescriptor;
import org.jetbrains.completion.full.line.language.supporters.ModelsVersions;
import org.jetbrains.completion.full.line.local.CDNApiImpl;
import org.jetbrains.completion.full.line.local.MavenApiImpl;
import org.jetbrains.completion.full.line.local.ModelSchema;
import org.jetbrains.completion.full.line.local.NativeServerSchema;
import org.jetbrains.completion.full.line.local.UnsupportedPlatformException;

@Metadata(mv={2, 0, 0}, k=1, xi=48, d1={"\u0000$\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0003\n\u0002\u0010\u000e\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0006\n\u0002\u0018\u0002\n\u0002\b\u0004\b&\u0018\u0000 \u00122\u00020\u0001:\u0001\u0012B\u0007\u00a2\u0006\u0004\b\u0002\u0010\u0003J\u0018\u0010\u0004\u001a\u00020\u00052\u0006\u0010\u0006\u001a\u00020\u00052\u0006\u0010\u0007\u001a\u00020\bH&J(\u0010\t\u001a\u00020\u00052\u0006\u0010\n\u001a\u00020\u00052\u0006\u0010\u000b\u001a\u00020\u00052\u0006\u0010\f\u001a\u00020\u00052\u0006\u0010\r\u001a\u00020\u0005H&J\u000e\u0010\u0004\u001a\u00020\u00052\u0006\u0010\u000e\u001a\u00020\u000fJ\u0016\u0010\u0010\u001a\u00020\u00052\u0006\u0010\u000e\u001a\u00020\u000f2\u0006\u0010\n\u001a\u00020\u0005J\u0016\u0010\t\u001a\u00020\u00052\u0006\u0010\n\u001a\u00020\u00052\u0006\u0010\u0011\u001a\u00020\u0005\u00a8\u0006\u0013"}, d2={"Lorg/jetbrains/completion/full/line/local/HostApi;", "", "<init>", "()V", "model", "", "tag", "inferenceType", "Lorg/jetbrains/completion/full/line/LocalInferenceType;", "server", "version", "os", "cpuArch", "fileName", "descriptor", "Lorg/jetbrains/completion/full/line/LocalModelDescriptor;", "modelConfig", "file", "Companion", "intellij.fullLine"})
public abstract class HostApi {
    @NotNull
    public static final Companion Companion = new Companion(null);

    @NotNull
    public abstract String model(@NotNull String var1, @NotNull LocalInferenceType var2);

    @NotNull
    public abstract String server(@NotNull String var1, @NotNull String var2, @NotNull String var3, @NotNull String var4);

    @NotNull
    public final String model(@NotNull LocalModelDescriptor descriptor) {
        Intrinsics.checkNotNullParameter((Object)descriptor, (String)"descriptor");
        String string = descriptor.getCustomTag();
        if (string == null) {
            String string2 = descriptor.getLanguage().getID();
            Intrinsics.checkNotNullExpressionValue((Object)string2, (String)"getID(...)");
            String string3 = string2.toLowerCase(Locale.ROOT);
            string = string3;
            Intrinsics.checkNotNullExpressionValue((Object)string3, (String)"toLowerCase(...)");
        }
        return this.model(string, descriptor.getInferenceType());
    }

    @NotNull
    public final String modelConfig(@NotNull LocalModelDescriptor descriptor, @NotNull String version) {
        Intrinsics.checkNotNullParameter((Object)descriptor, (String)"descriptor");
        Intrinsics.checkNotNullParameter((Object)version, (String)"version");
        return this.model(descriptor) + "/" + version + "/model.xml";
    }

    @NotNull
    public final String server(@NotNull String version, @NotNull String file2) {
        Intrinsics.checkNotNullParameter((Object)version, (String)"version");
        Intrinsics.checkNotNullParameter((Object)file2, (String)"file");
        return this.server(version, Companion.getOs(), Companion.getCpu(), file2);
    }

    @Metadata(mv={2, 0, 0}, k=1, xi=48, d1={"\u0000(\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0003\n\u0002\u0010\u000e\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\b\u0086\u0003\u0018\u00002\u00020\u0001B\t\b\u0002\u00a2\u0006\u0004\b\u0002\u0010\u0003J\u0006\u0010\u0004\u001a\u00020\u0005J\u0006\u0010\u0006\u001a\u00020\u0005J\u000e\u0010\u0007\u001a\u00020\b2\u0006\u0010\t\u001a\u00020\nJ\u000e\u0010\u0007\u001a\u00020\b2\u0006\u0010\u000b\u001a\u00020\fJ\u000e\u0010\u0007\u001a\u00020\b2\u0006\u0010\r\u001a\u00020\u0005\u00a8\u0006\u000e"}, d2={"Lorg/jetbrains/completion/full/line/local/HostApi$Companion;", "", "<init>", "()V", "getOs", "", "getCpu", "getInstance", "Lorg/jetbrains/completion/full/line/local/HostApi;", "nativeSchema", "Lorg/jetbrains/completion/full/line/local/NativeServerSchema;", "model", "Lorg/jetbrains/completion/full/line/local/ModelSchema;", "version", "intellij.fullLine"})
    public static final class Companion {
        private Companion() {
        }

        @NotNull
        public final String getOs() {
            String string;
            if (SystemInfoRt.isLinux) {
                string = "linux";
            } else if (SystemInfoRt.isMac) {
                string = "macos";
            } else if (SystemInfoRt.isWindows) {
                string = "windows";
            } else {
                String string2 = SystemInfoRt.OS_NAME;
                Intrinsics.checkNotNullExpressionValue((Object)string2, (String)"OS_NAME");
                throw UnsupportedPlatformException.Companion.unsupportedOs(string2);
            }
            return string;
        }

        @NotNull
        public final String getCpu() {
            CpuArch cpuArch = CpuArch.CURRENT;
            return switch (cpuArch == null ? -1 : WhenMappings.$EnumSwitchMapping$0[cpuArch.ordinal()]) {
                case 1 -> "x86_64";
                case 2 -> "arm_64";
                default -> {
                    String v2 = System.getProperty("os.arch");
                    Intrinsics.checkNotNullExpressionValue((Object)v2, (String)"getProperty(...)");
                    throw UnsupportedPlatformException.Companion.unsupportedCpuArch(v2);
                }
            };
        }

        @NotNull
        public final HostApi getInstance(@NotNull NativeServerSchema nativeSchema) {
            Intrinsics.checkNotNullParameter((Object)nativeSchema, (String)"nativeSchema");
            return this.getInstance(nativeSchema.getArchive());
        }

        @NotNull
        public final HostApi getInstance(@NotNull ModelSchema model) {
            Intrinsics.checkNotNullParameter((Object)model, (String)"model");
            return this.getInstance(model.getVersion());
        }

        @NotNull
        public final HostApi getInstance(@NotNull String version) {
            Intrinsics.checkNotNullParameter((Object)version, (String)"version");
            boolean isBeta = ModelsVersions.Companion.isBeta(version);
            return isBeta ? (HostApi)new MavenApiImpl() : (HostApi)new CDNApiImpl();
        }

        public /* synthetic */ Companion(DefaultConstructorMarker $constructor_marker) {
            this();
        }

        @Metadata(mv={2, 0, 0}, k=3, xi=48)
        public final class WhenMappings {
            public static final /* synthetic */ int[] $EnumSwitchMapping$0;

            static {
                int[] nArray = new int[CpuArch.values().length];
                try {
                    nArray[CpuArch.X86_64.ordinal()] = 1;
                }
                catch (NoSuchFieldError noSuchFieldError) {
                    // empty catch block
                }
                try {
                    nArray[CpuArch.ARM64.ordinal()] = 2;
                }
                catch (NoSuchFieldError noSuchFieldError) {
                    // empty catch block
                }
                $EnumSwitchMapping$0 = nArray;
            }
        }
    }
}

