/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.openapi.vcs;

import com.intellij.openapi.Disposable;
import com.intellij.openapi.application.ApplicationManager;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.util.Disposer;
import com.intellij.openapi.vcs.FilesProcessor;
import com.intellij.openapi.vfs.VirtualFile;
import com.intellij.vcsUtil.VcsUtil;
import java.util.ArrayList;
import java.util.Collection;
import java.util.LinkedHashSet;
import java.util.List;
import java.util.Set;
import kotlin.Metadata;
import kotlin.Unit;
import kotlin._Assertions;
import kotlin.collections.CollectionsKt;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import org.jetbrains.annotations.ApiStatus;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.TestOnly;

@Metadata(mv={2, 0, 0}, k=1, xi=48, d1={"\u0000>\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0005\n\u0002\u0010#\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0002\n\u0002\u0010\u001e\n\u0002\b\u0004\n\u0002\u0010\u000b\n\u0002\b\u0005\n\u0002\u0010 \n\u0002\b\u0006\b'\u0018\u00002\u00020\u0001B\u0017\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\u0006\u0010\u0004\u001a\u00020\u0005\u00a2\u0006\u0004\b\u0006\u0010\u0007J\u0016\u0010\r\u001a\u00020\u000e2\f\u0010\n\u001a\b\u0012\u0004\u0012\u00020\f0\u000fH&J\u001c\u0010\u0010\u001a\b\u0012\u0004\u0012\u00020\f0\u000f2\f\u0010\n\u001a\b\u0012\u0004\u0012\u00020\f0\u000fH&J\u0016\u0010\u0011\u001a\u00020\u000e2\f\u0010\n\u001a\b\u0012\u0004\u0012\u00020\f0\u000fH\u0016J\b\u0010\u0012\u001a\u00020\u000eH\u0014J\u0016\u0010\u0013\u001a\u00020\u00142\f\u0010\u0015\u001a\b\u0012\u0004\u0012\u00020\f0\u000fH\u0004J\b\u0010\u0016\u001a\u00020\u0014H\u0004J\u0016\u0010\u0017\u001a\u00020\u000e2\f\u0010\u0018\u001a\b\u0012\u0004\u0012\u00020\f0\u000fH\u0002J\u000e\u0010\u0019\u001a\b\u0012\u0004\u0012\u00020\f0\u001aH\u0004J\u000e\u0010\u001b\u001a\b\u0012\u0004\u0012\u00020\f0\u001aH\u0004J\b\u0010\u001c\u001a\u00020\u000eH\u0004J\b\u0010\u001d\u001a\u00020\u000eH\u0016J\b\u0010\u001e\u001a\u00020\u0014H$J\b\u0010\u001f\u001a\u00020\u000eH\u0015R\u0014\u0010\u0002\u001a\u00020\u0003X\u0084\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b\b\u0010\tR\u0014\u0010\n\u001a\b\u0012\u0004\u0012\u00020\f0\u000bX\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006 "}, d2={"Lcom/intellij/openapi/vcs/FilesProcessorImpl;", "Lcom/intellij/openapi/vcs/FilesProcessor;", "project", "Lcom/intellij/openapi/project/Project;", "parentDisposable", "Lcom/intellij/openapi/Disposable;", "<init>", "(Lcom/intellij/openapi/project/Project;Lcom/intellij/openapi/Disposable;)V", "getProject", "()Lcom/intellij/openapi/project/Project;", "files", "", "Lcom/intellij/openapi/vfs/VirtualFile;", "doActionOnChosenFiles", "", "", "doFilterFiles", "processFiles", "handleProcessingForCurrentProject", "removeFiles", "", "filesToRemove", "isFilesEmpty", "addNewFiles", "filesToAdd", "selectValidFiles", "", "acquireValidFiles", "clearFiles", "dispose", "needDoForCurrentProject", "waitForEventsProcessedInTestMode", "intellij.platform.vcs.impl"})
@ApiStatus.Internal
@SourceDebugExtension(value={"SMAP\nFilesProcessorImpl.kt\nKotlin\n*S Kotlin\n*F\n+ 1 FilesProcessorImpl.kt\ncom/intellij/openapi/vcs/FilesProcessorImpl\n+ 2 _Collections.kt\nkotlin/collections/CollectionsKt___CollectionsKt\n*L\n1#1,92:1\n774#2:93\n865#2,2:94\n*S KotlinDebug\n*F\n+ 1 FilesProcessorImpl.kt\ncom/intellij/openapi/vcs/FilesProcessorImpl\n*L\n69#1:93\n69#1:94,2\n*E\n"})
public abstract class FilesProcessorImpl
implements FilesProcessor {
    @NotNull
    private final Project project;
    @NotNull
    private final Set<VirtualFile> files;

    public FilesProcessorImpl(@NotNull Project project, @NotNull Disposable parentDisposable) {
        Intrinsics.checkNotNullParameter((Object)project, (String)"project");
        Intrinsics.checkNotNullParameter((Object)parentDisposable, (String)"parentDisposable");
        this.project = project;
        this.files = new LinkedHashSet();
        Disposer.register((Disposable)parentDisposable, (Disposable)((Disposable)this));
    }

    @NotNull
    protected final Project getProject() {
        return this.project;
    }

    public abstract void doActionOnChosenFiles(@NotNull Collection<? extends VirtualFile> var1);

    @NotNull
    public abstract Collection<VirtualFile> doFilterFiles(@NotNull Collection<? extends VirtualFile> var1);

    public void processFiles(@NotNull Collection<? extends VirtualFile> files) {
        Intrinsics.checkNotNullParameter(files, (String)"files");
        Collection<VirtualFile> filteredFiles = this.doFilterFiles(files);
        if (filteredFiles.isEmpty()) {
            return;
        }
        this.addNewFiles(filteredFiles);
        if (this.needDoForCurrentProject()) {
            this.doActionOnChosenFiles((Collection<? extends VirtualFile>)this.acquireValidFiles());
        } else {
            this.handleProcessingForCurrentProject();
        }
    }

    protected void handleProcessingForCurrentProject() {
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected final boolean removeFiles(@NotNull Collection<? extends VirtualFile> filesToRemove) {
        Intrinsics.checkNotNullParameter(filesToRemove, (String)"filesToRemove");
        Set<VirtualFile> set = this.files;
        synchronized (set) {
            boolean bl = false;
            boolean bl2 = VcsUtil.removeAllFromSet(this.files, filesToRemove);
            return bl2;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected final boolean isFilesEmpty() {
        Set<VirtualFile> set = this.files;
        synchronized (set) {
            boolean bl = false;
            boolean bl2 = this.files.isEmpty();
            return bl2;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private final void addNewFiles(Collection<? extends VirtualFile> filesToAdd) {
        Set<VirtualFile> set = this.files;
        synchronized (set) {
            boolean bl = false;
            boolean bl2 = this.files.addAll(filesToAdd);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @NotNull
    protected final List<VirtualFile> selectValidFiles() {
        Set<VirtualFile> set = this.files;
        synchronized (set) {
            boolean bl = false;
            CollectionsKt.removeAll((Iterable)this.files, FilesProcessorImpl::selectValidFiles$lambda$4$lambda$3);
            List list = CollectionsKt.toList((Iterable)this.files);
            return list;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * WARNING - void declaration
     */
    @NotNull
    protected final List<VirtualFile> acquireValidFiles() {
        Set<VirtualFile> set = this.files;
        synchronized (set) {
            void $this$filterTo$iv$iv;
            boolean bl = false;
            Iterable $this$filter$iv = this.files;
            boolean $i$f$filter = false;
            Iterable iterable = $this$filter$iv;
            Collection destination$iv$iv = new ArrayList();
            boolean $i$f$filterTo = false;
            for (Object element$iv$iv : $this$filterTo$iv$iv) {
                VirtualFile it = (VirtualFile)element$iv$iv;
                boolean bl2 = false;
                if (!it.isValid()) continue;
                destination$iv$iv.add(element$iv$iv);
            }
            List result2 = (List)destination$iv$iv;
            this.files.clear();
            List list = result2;
            return list;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected final void clearFiles() {
        Set<VirtualFile> set = this.files;
        synchronized (set) {
            boolean bl = false;
            this.files.clear();
            Unit unit = Unit.INSTANCE;
        }
    }

    public void dispose() {
        this.clearFiles();
    }

    protected abstract boolean needDoForCurrentProject();

    @TestOnly
    protected void waitForEventsProcessedInTestMode() {
        boolean bl = ApplicationManager.getApplication().isUnitTestMode();
        if (_Assertions.ENABLED && !bl) {
            String string = "Assertion failed";
            throw new AssertionError((Object)string);
        }
    }

    private static final boolean selectValidFiles$lambda$4$lambda$3(VirtualFile it) {
        Intrinsics.checkNotNullParameter((Object)it, (String)"it");
        return !it.isValid();
    }
}

