/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.xml;

import com.intellij.openapi.diagnostic.Logger;
import com.intellij.openapi.editor.Editor;
import com.intellij.openapi.editor.ScrollType;
import com.intellij.openapi.module.ModuleUtilCore;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.util.text.StringUtil;
import com.intellij.openapi.vfs.VirtualFile;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiFile;
import com.intellij.psi.XmlElementFactory;
import com.intellij.psi.xml.XmlAttribute;
import com.intellij.psi.xml.XmlAttributeValue;
import com.intellij.psi.xml.XmlDocument;
import com.intellij.psi.xml.XmlFile;
import com.intellij.psi.xml.XmlTag;
import com.intellij.util.IncorrectOperationException;
import com.intellij.xml.XmlAttributeDescriptor;
import com.intellij.xml.XmlElementDescriptor;
import com.intellij.xml.XmlNSDescriptor;
import com.intellij.xml.XmlNamespaceHelper;
import com.intellij.xml.XmlSchemaProvider;
import com.intellij.xml.index.XmlNamespaceIndex;
import com.intellij.xml.index.XmlTagNamesIndex;
import com.intellij.xml.util.XmlUtil;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.HashSet;
import java.util.Iterator;
import java.util.LinkedHashSet;
import java.util.List;
import java.util.Set;
import org.jetbrains.annotations.NonNls;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class DefaultXmlNamespaceHelper
extends XmlNamespaceHelper {
    private static final Logger LOG = Logger.getInstance(DefaultXmlNamespaceHelper.class);

    @Override
    protected boolean isAvailable(PsiFile file) {
        return true;
    }

    @Override
    public void insertNamespaceDeclaration(@NotNull XmlFile file, @Nullable Editor editor, @NotNull Set<String> possibleNamespaces, @Nullable String nsPrefix, @Nullable XmlNamespaceHelper.Runner<String, IncorrectOperationException> runAfter) throws IncorrectOperationException {
        XmlAttribute xmlAttribute;
        if (file == null) {
            DefaultXmlNamespaceHelper.$$$reportNull$$$0(0);
        }
        if (possibleNamespaces == null) {
            DefaultXmlNamespaceHelper.$$$reportNull$$$0(1);
        }
        String namespace = possibleNamespaces.iterator().next();
        Project project2 = file.getProject();
        XmlTag rootTag = file.getRootTag();
        assert (rootTag != null);
        XmlAttribute anchor = DefaultXmlNamespaceHelper.getAnchor(rootTag);
        List providers = XmlSchemaProvider.getAvailableProviders((XmlFile)file);
        String prefix = DefaultXmlNamespaceHelper.getPrefix(file, nsPrefix, namespace, providers);
        XmlElementFactory elementFactory = XmlElementFactory.getInstance((Project)project2);
        String location = DefaultXmlNamespaceHelper.getLocation(file, namespace, providers);
        String xsiPrefix = null;
        if (location != null && (xsiPrefix = rootTag.getPrefixByNamespace("http://www.w3.org/2001/XMLSchema-instance")) == null) {
            xsiPrefix = "xsi";
            rootTag.add((PsiElement)elementFactory.createXmlAttribute("xmlns:xsi", "http://www.w3.org/2001/XMLSchema-instance"));
        }
        @NonNls String qname = "xmlns" + (String)(!prefix.isEmpty() ? ":" + prefix : "");
        XmlAttribute attribute = elementFactory.createXmlAttribute(qname, namespace);
        if (anchor == null) {
            rootTag.add((PsiElement)attribute);
        } else {
            rootTag.addAfter((PsiElement)attribute, (PsiElement)anchor);
        }
        if (location != null) {
            XmlAttribute locationAttribute = rootTag.getAttribute("schemaLocation", "http://www.w3.org/2001/XMLSchema-instance");
            String pair = namespace + " " + location;
            if (locationAttribute == null) {
                locationAttribute = elementFactory.createXmlAttribute(xsiPrefix + ":schemaLocation", pair);
                rootTag.add((PsiElement)locationAttribute);
            } else {
                String value = locationAttribute.getValue();
                if (!StringUtil.notNullize((String)value).contains(namespace)) {
                    if (value == null || StringUtil.isEmptyOrSpaces((String)value)) {
                        locationAttribute.setValue(pair);
                    } else {
                        locationAttribute.setValue(value.trim() + " " + pair);
                    }
                }
            }
        }
        XmlUtil.reformatTagStart(rootTag);
        if (editor != null && namespace.isEmpty() && (xmlAttribute = rootTag.getAttribute(qname)) != null) {
            XmlAttributeValue value = xmlAttribute.getValueElement();
            assert (value != null);
            int startOffset = value.getTextOffset();
            editor.getCaretModel().moveToOffset(startOffset);
            editor.getScrollingModel().scrollToCaret(ScrollType.RELATIVE);
        }
        if (runAfter != null) {
            runAfter.run(prefix);
        }
    }

    private static String getPrefix(XmlFile file, String nsPrefix, String namespace, List<XmlSchemaProvider> providers) {
        String prefix = nsPrefix;
        if (prefix == null) {
            XmlSchemaProvider provider;
            Iterator<XmlSchemaProvider> iterator = providers.iterator();
            while (iterator.hasNext() && (prefix = (provider = iterator.next()).getDefaultPrefix(namespace, file)) == null) {
            }
        }
        if (prefix == null) {
            prefix = "";
        }
        return prefix;
    }

    private static XmlAttribute getAnchor(XmlTag rootTag) {
        XmlAttribute[] attributes = rootTag.getAttributes();
        XmlAttribute anchor = null;
        for (XmlAttribute attribute : attributes) {
            XmlAttributeDescriptor descriptor = attribute.getDescriptor();
            if (!attribute.isNamespaceDeclaration() && (descriptor == null || !descriptor.isRequired())) break;
            anchor = attribute;
        }
        return anchor;
    }

    private static String getLocation(XmlFile file, String namespace, List<XmlSchemaProvider> providers) {
        String location = null;
        if (!namespace.isEmpty()) {
            for (XmlSchemaProvider provider : providers) {
                Set locations = provider.getLocations(namespace, file);
                if (locations == null || locations.isEmpty()) continue;
                location = (String)locations.iterator().next();
            }
        }
        return location;
    }

    @Override
    @NotNull
    public Set<String> guessUnboundNamespaces(@NotNull PsiElement element, @NotNull XmlFile file) {
        if (element == null) {
            DefaultXmlNamespaceHelper.$$$reportNull$$$0(2);
        }
        if (file == null) {
            DefaultXmlNamespaceHelper.$$$reportNull$$$0(3);
        }
        if (!(element instanceof XmlTag)) {
            Set<String> set = Collections.emptySet();
            if (set == null) {
                DefaultXmlNamespaceHelper.$$$reportNull$$$0(4);
            }
            return set;
        }
        XmlTag tag = (XmlTag)element;
        String name = tag.getLocalName();
        Set<String> byTagName = this.getNamespacesByTagName(name, file);
        if (!byTagName.isEmpty()) {
            HashSet<String> filtered = new HashSet<String>(byTagName);
            filtered.removeAll(Arrays.asList(tag.knownNamespaces()));
            HashSet<String> hashSet = filtered;
            if (hashSet == null) {
                DefaultXmlNamespaceHelper.$$$reportNull$$$0(5);
            }
            return hashSet;
        }
        Set<String> set = DefaultXmlNamespaceHelper.guessNamespace(file.getProject(), name);
        set.removeAll(Arrays.asList(tag.knownNamespaces()));
        XmlTag parentTag = tag.getParentTag();
        Iterator<String> i = set.iterator();
        block0: while (i.hasNext()) {
            String s = i.next();
            Collection<XmlFile> namespaces = XmlUtil.findNSFilesByURI(s, element.getProject(), ModuleUtilCore.findModuleForPsiElement((PsiElement)file));
            for (XmlFile namespace : namespaces) {
                XmlDocument document = namespace.getDocument();
                assert (document != null);
                XmlNSDescriptor nsDescriptor = (XmlNSDescriptor)document.getMetaData();
                assert (nsDescriptor != null);
                if (parentTag != null) continue block0;
                for (XmlElementDescriptor descriptor : nsDescriptor.getRootElementsDescriptors(document)) {
                    if (descriptor == null) {
                        LOG.error(nsDescriptor + " returned null element for getRootElementsDescriptors() array");
                        continue;
                    }
                    if (descriptor.getName().equals(name)) continue block0;
                }
            }
            i.remove();
        }
        Set<String> set2 = set;
        if (set2 == null) {
            DefaultXmlNamespaceHelper.$$$reportNull$$$0(6);
        }
        return set2;
    }

    @NotNull
    private static Set<String> guessNamespace(@NotNull Project project2, @NotNull String tagName) {
        Collection<VirtualFile> files;
        if (project2 == null) {
            DefaultXmlNamespaceHelper.$$$reportNull$$$0(7);
        }
        if (tagName == null) {
            DefaultXmlNamespaceHelper.$$$reportNull$$$0(8);
        }
        if ((files = XmlTagNamesIndex.getFilesByTagName(tagName, project2)).isEmpty()) {
            Set<String> set = Collections.emptySet();
            if (set == null) {
                DefaultXmlNamespaceHelper.$$$reportNull$$$0(9);
            }
            return set;
        }
        LinkedHashSet<String> possibleUris = new LinkedHashSet<String>(files.size());
        for (VirtualFile virtualFile : files) {
            String namespace = XmlNamespaceIndex.getNamespace(virtualFile, project2);
            if (namespace == null) continue;
            possibleUris.add(namespace);
        }
        LinkedHashSet<String> linkedHashSet = possibleUris;
        if (linkedHashSet == null) {
            DefaultXmlNamespaceHelper.$$$reportNull$$$0(10);
        }
        return linkedHashSet;
    }

    @Override
    @NotNull
    public Set<String> getNamespacesByTagName(@NotNull String tagName, @NotNull XmlFile file) {
        if (tagName == null) {
            DefaultXmlNamespaceHelper.$$$reportNull$$$0(11);
        }
        if (file == null) {
            DefaultXmlNamespaceHelper.$$$reportNull$$$0(12);
        }
        HashSet set = null;
        for (XmlSchemaProvider provider : XmlSchemaProvider.EP_NAME.getExtensionList()) {
            if (!provider.isAvailable(file)) continue;
            if (set == null) {
                set = new HashSet();
            }
            set.addAll(provider.getAvailableNamespaces(file, tagName));
        }
        Set<String> set2 = set == null ? Collections.emptySet() : set;
        if (set2 == null) {
            DefaultXmlNamespaceHelper.$$$reportNull$$$0(13);
        }
        return set2;
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        Object[] objectArray;
        Object[] objectArray2;
        Object[] objectArray3 = new Object[switch (n) {
            default -> 3;
            case 4, 5, 6, 9, 10, 13 -> 2;
        }];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "file";
                break;
            }
            case 1: {
                objectArray2 = objectArray3;
                objectArray3[0] = "possibleNamespaces";
                break;
            }
            case 2: {
                objectArray2 = objectArray3;
                objectArray3[0] = "element";
                break;
            }
            case 4: 
            case 5: 
            case 6: 
            case 9: 
            case 10: 
            case 13: {
                objectArray2 = objectArray3;
                objectArray3[0] = "com/intellij/xml/DefaultXmlNamespaceHelper";
                break;
            }
            case 7: {
                objectArray2 = objectArray3;
                objectArray3[0] = "project";
                break;
            }
            case 8: 
            case 11: {
                objectArray2 = objectArray3;
                objectArray3[0] = "tagName";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "com/intellij/xml/DefaultXmlNamespaceHelper";
                break;
            }
            case 4: 
            case 5: 
            case 6: {
                objectArray = objectArray2;
                objectArray2[1] = "guessUnboundNamespaces";
                break;
            }
            case 9: 
            case 10: {
                objectArray = objectArray2;
                objectArray2[1] = "guessNamespace";
                break;
            }
            case 13: {
                objectArray = objectArray2;
                objectArray2[1] = "getNamespacesByTagName";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray;
                objectArray[2] = "insertNamespaceDeclaration";
                break;
            }
            case 2: 
            case 3: {
                objectArray = objectArray;
                objectArray[2] = "guessUnboundNamespaces";
                break;
            }
            case 4: 
            case 5: 
            case 6: 
            case 9: 
            case 10: 
            case 13: {
                break;
            }
            case 7: 
            case 8: {
                objectArray = objectArray;
                objectArray[2] = "guessNamespace";
                break;
            }
            case 11: 
            case 12: {
                objectArray = objectArray;
                objectArray[2] = "getNamespacesByTagName";
                break;
            }
        }
        String string = String.format(v0, objectArray);
        throw switch (n) {
            default -> new IllegalArgumentException(string);
            case 4, 5, 6, 9, 10, 13 -> new IllegalStateException(string);
        };
    }
}

