/*
 * Decompiled with CFR 0.152.
 */
package com.carrotsearch.hppc;

import com.carrotsearch.hppc.AbstractCharCollection;
import com.carrotsearch.hppc.AbstractIterator;
import com.carrotsearch.hppc.CharCharAssociativeContainer;
import com.carrotsearch.hppc.CharCharHashMap;
import com.carrotsearch.hppc.CharCharMap;
import com.carrotsearch.hppc.CharCollection;
import com.carrotsearch.hppc.CharContainer;
import com.carrotsearch.hppc.CharLookupContainer;
import com.carrotsearch.hppc.comparators.CharCharComparator;
import com.carrotsearch.hppc.comparators.CharComparator;
import com.carrotsearch.hppc.cursors.CharCharCursor;
import com.carrotsearch.hppc.cursors.CharCursor;
import com.carrotsearch.hppc.predicates.CharCharPredicate;
import com.carrotsearch.hppc.predicates.CharPredicate;
import com.carrotsearch.hppc.procedures.CharCharProcedure;
import com.carrotsearch.hppc.procedures.CharProcedure;
import com.carrotsearch.hppc.sorting.QuickSort;
import java.util.Iterator;
import java.util.function.IntBinaryOperator;

public class SortedIterationCharCharHashMap
implements CharCharMap {
    public final CharCharHashMap delegate;
    public final int[] iterationOrder;

    public SortedIterationCharCharHashMap(CharCharHashMap delegate2, CharComparator comparator) {
        this.delegate = delegate2;
        this.iterationOrder = this.sortIterationOrder(this.createEntryIndexes(), comparator);
    }

    public SortedIterationCharCharHashMap(CharCharHashMap delegate2, CharCharComparator comparator) {
        this.delegate = delegate2;
        this.iterationOrder = this.sortIterationOrder(this.createEntryIndexes(), comparator);
    }

    private int[] createEntryIndexes() {
        char[] keys = this.delegate.keys;
        int size = this.delegate.size();
        int[] entryIndexes = new int[size];
        int entry2 = 0;
        if (this.delegate.hasEmptyKey) {
            entryIndexes[entry2++] = this.delegate.mask + 1;
        }
        int keyIndex = 0;
        while (entry2 < size) {
            if (keys[keyIndex] != '\u0000') {
                entryIndexes[entry2++] = keyIndex;
            }
            ++keyIndex;
        }
        return entryIndexes;
    }

    protected int[] sortIterationOrder(int[] entryIndexes, CharComparator comparator) {
        QuickSort.sort(entryIndexes, (i, j) -> {
            char[] keys = this.delegate.keys;
            return comparator.compare(keys[entryIndexes[i]], keys[entryIndexes[j]]);
        });
        return entryIndexes;
    }

    protected int[] sortIterationOrder(final int[] entryIndexes, final CharCharComparator comparator) {
        QuickSort.sort(entryIndexes, new IntBinaryOperator(){
            final char[] keys;
            final char[] values;
            {
                this.keys = SortedIterationCharCharHashMap.this.delegate.keys;
                this.values = SortedIterationCharCharHashMap.this.delegate.values;
            }

            @Override
            public int applyAsInt(int i, int j) {
                int index1 = entryIndexes[i];
                int index2 = entryIndexes[j];
                return comparator.compare(this.keys[index1], this.values[index1], this.keys[index2], this.values[index2]);
            }
        });
        return entryIndexes;
    }

    @Override
    public Iterator<CharCharCursor> iterator() {
        assert (this.checkUnmodified());
        return new EntryIterator();
    }

    @Override
    public boolean containsKey(char key2) {
        return this.delegate.containsKey(key2);
    }

    @Override
    public int size() {
        assert (this.checkUnmodified());
        return this.delegate.size();
    }

    @Override
    public boolean isEmpty() {
        return this.delegate.isEmpty();
    }

    @Override
    public int removeAll(CharContainer container) {
        throw SortedIterationCharCharHashMap.readOnlyException();
    }

    @Override
    public int removeAll(CharPredicate predicate) {
        throw SortedIterationCharCharHashMap.readOnlyException();
    }

    @Override
    public int removeAll(CharCharPredicate predicate) {
        throw SortedIterationCharCharHashMap.readOnlyException();
    }

    @Override
    public <T extends CharCharProcedure> T forEach(T procedure) {
        assert (this.checkUnmodified());
        int[] iterationOrder = this.iterationOrder;
        char[] keys = this.delegate.keys;
        char[] values = this.delegate.values;
        int size = this.size();
        for (int i = 0; i < size; ++i) {
            int slot = iterationOrder[i];
            procedure.apply(keys[slot], values[slot]);
        }
        return procedure;
    }

    @Override
    public <T extends CharCharPredicate> T forEach(T predicate) {
        int slot;
        assert (this.checkUnmodified());
        int[] iterationOrder = this.iterationOrder;
        char[] keys = this.delegate.keys;
        char[] values = this.delegate.values;
        int size = this.size();
        for (int i = 0; i < size && predicate.apply(keys[slot = iterationOrder[i]], values[slot]); ++i) {
        }
        return predicate;
    }

    @Override
    public CharCollection keys() {
        assert (this.checkUnmodified());
        return new KeysContainer();
    }

    @Override
    public CharContainer values() {
        assert (this.checkUnmodified());
        return new ValuesContainer();
    }

    @Override
    public char get(char key2) {
        return this.delegate.get(key2);
    }

    @Override
    public char getOrDefault(char key2, char defaultValue) {
        return this.delegate.getOrDefault(key2, defaultValue);
    }

    @Override
    public char put(char key2, char value) {
        throw SortedIterationCharCharHashMap.readOnlyException();
    }

    @Override
    public int putAll(CharCharAssociativeContainer container) {
        throw SortedIterationCharCharHashMap.readOnlyException();
    }

    @Override
    public int putAll(Iterable<? extends CharCharCursor> iterable) {
        throw SortedIterationCharCharHashMap.readOnlyException();
    }

    @Override
    public char putOrAdd(char key2, char putValue, char incrementValue) {
        throw SortedIterationCharCharHashMap.readOnlyException();
    }

    @Override
    public char addTo(char key2, char additionValue) {
        throw SortedIterationCharCharHashMap.readOnlyException();
    }

    @Override
    public char remove(char key2) {
        throw SortedIterationCharCharHashMap.readOnlyException();
    }

    @Override
    public int indexOf(char key2) {
        return this.delegate.indexOf(key2);
    }

    @Override
    public boolean indexExists(int index) {
        return this.delegate.indexExists(index);
    }

    @Override
    public char indexGet(int index) {
        return this.delegate.indexGet(index);
    }

    @Override
    public char indexReplace(int index, char newValue) {
        throw SortedIterationCharCharHashMap.readOnlyException();
    }

    @Override
    public void indexInsert(int index, char key2, char value) {
        throw SortedIterationCharCharHashMap.readOnlyException();
    }

    @Override
    public char indexRemove(int index) {
        throw SortedIterationCharCharHashMap.readOnlyException();
    }

    @Override
    public void clear() {
        throw SortedIterationCharCharHashMap.readOnlyException();
    }

    @Override
    public void release() {
        throw SortedIterationCharCharHashMap.readOnlyException();
    }

    @Override
    public String visualizeKeyDistribution(int characters) {
        return this.delegate.visualizeKeyDistribution(characters);
    }

    private static RuntimeException readOnlyException() {
        throw new UnsupportedOperationException("Read-only view cannot be modified");
    }

    private boolean checkUnmodified() {
        assert (this.delegate.size() == this.iterationOrder.length) : "The delegate map changed; this is not supported by this read-only view";
        return true;
    }

    private final class EntryIterator
    extends AbstractIterator<CharCharCursor> {
        private final CharCharCursor cursor = new CharCharCursor();
        private int index;

        private EntryIterator() {
        }

        @Override
        protected CharCharCursor fetch() {
            if (this.index < SortedIterationCharCharHashMap.this.iterationOrder.length) {
                int slot;
                this.cursor.index = slot = SortedIterationCharCharHashMap.this.iterationOrder[this.index++];
                this.cursor.key = SortedIterationCharCharHashMap.this.delegate.keys[slot];
                this.cursor.value = SortedIterationCharCharHashMap.this.delegate.values[slot];
                return this.cursor;
            }
            return (CharCharCursor)this.done();
        }
    }

    private final class KeysContainer
    extends AbstractCharCollection
    implements CharLookupContainer {
        private final SortedIterationCharCharHashMap owner;

        private KeysContainer() {
            this.owner = SortedIterationCharCharHashMap.this;
        }

        @Override
        public boolean contains(char e) {
            return this.owner.containsKey(e);
        }

        @Override
        public <T extends CharProcedure> T forEach(T procedure) {
            this.owner.forEach((k, v) -> procedure.apply(k));
            return procedure;
        }

        @Override
        public <T extends CharPredicate> T forEach(T predicate) {
            this.owner.forEach((key2, value) -> predicate.apply(key2));
            return predicate;
        }

        @Override
        public boolean isEmpty() {
            return this.owner.isEmpty();
        }

        @Override
        public Iterator<CharCursor> iterator() {
            return new KeysIterator();
        }

        @Override
        public int size() {
            return this.owner.size();
        }

        @Override
        public void clear() {
            throw SortedIterationCharCharHashMap.readOnlyException();
        }

        @Override
        public void release() {
            throw SortedIterationCharCharHashMap.readOnlyException();
        }

        @Override
        public int removeAll(CharPredicate predicate) {
            throw SortedIterationCharCharHashMap.readOnlyException();
        }

        @Override
        public int removeAll(char e) {
            throw SortedIterationCharCharHashMap.readOnlyException();
        }
    }

    private final class ValuesContainer
    extends AbstractCharCollection {
        private final SortedIterationCharCharHashMap owner;

        private ValuesContainer() {
            this.owner = SortedIterationCharCharHashMap.this;
        }

        @Override
        public int size() {
            return this.owner.size();
        }

        @Override
        public boolean isEmpty() {
            return this.owner.isEmpty();
        }

        @Override
        public boolean contains(char value) {
            for (CharCharCursor c : this.owner) {
                if (value != c.value) continue;
                return true;
            }
            return false;
        }

        @Override
        public <T extends CharProcedure> T forEach(T procedure) {
            this.owner.forEach((k, v) -> procedure.apply(v));
            return procedure;
        }

        @Override
        public <T extends CharPredicate> T forEach(T predicate) {
            this.owner.forEach((k, v) -> predicate.apply(v));
            return predicate;
        }

        @Override
        public Iterator<CharCursor> iterator() {
            return new ValuesIterator();
        }

        @Override
        public int removeAll(char e) {
            throw SortedIterationCharCharHashMap.readOnlyException();
        }

        @Override
        public int removeAll(CharPredicate predicate) {
            throw SortedIterationCharCharHashMap.readOnlyException();
        }

        @Override
        public void clear() {
            throw SortedIterationCharCharHashMap.readOnlyException();
        }

        @Override
        public void release() {
            throw SortedIterationCharCharHashMap.readOnlyException();
        }
    }

    private final class ValuesIterator
    extends AbstractIterator<CharCursor> {
        private final CharCursor cursor = new CharCursor();
        private int index;

        private ValuesIterator() {
        }

        @Override
        protected CharCursor fetch() {
            if (this.index < SortedIterationCharCharHashMap.this.iterationOrder.length) {
                int slot;
                this.cursor.index = slot = SortedIterationCharCharHashMap.this.iterationOrder[this.index++];
                this.cursor.value = SortedIterationCharCharHashMap.this.delegate.values[slot];
                return this.cursor;
            }
            return (CharCursor)this.done();
        }
    }

    private final class KeysIterator
    extends AbstractIterator<CharCursor> {
        private final CharCursor cursor = new CharCursor();
        private int index;

        private KeysIterator() {
        }

        @Override
        protected CharCursor fetch() {
            if (this.index < SortedIterationCharCharHashMap.this.iterationOrder.length) {
                int slot;
                this.cursor.index = slot = SortedIterationCharCharHashMap.this.iterationOrder[this.index++];
                this.cursor.value = SortedIterationCharCharHashMap.this.delegate.keys[slot];
                return this.cursor;
            }
            return (CharCursor)this.done();
        }
    }
}

