/*
 * Decompiled with CFR 0.152.
 */
package org.languagetool.rules.en;

import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import java.util.Map;
import java.util.ResourceBundle;
import java.util.function.Supplier;
import org.languagetool.AnalyzedTokenReadings;
import org.languagetool.Tag;
import org.languagetool.language.AmericanEnglish;
import org.languagetool.rules.AbstractRepeatedWordsRule;
import org.languagetool.rules.SynonymsData;
import org.languagetool.rules.patterns.PatternRuleBuilderHelper;
import org.languagetool.rules.patterns.PatternToken;
import org.languagetool.rules.patterns.PatternTokenBuilder;
import org.languagetool.synthesis.Synthesizer;
import org.languagetool.synthesis.en.EnglishSynthesizer;
import org.languagetool.tagging.disambiguation.rules.DisambiguationPatternRule;
import org.languagetool.tools.Tools;

public class EnglishRepeatedWordsRule
extends AbstractRepeatedWordsRule {
    private final Supplier<List<DisambiguationPatternRule>> antiPatterns;
    private static final List<List<PatternToken>> ANTI_PATTERNS = Arrays.asList(Arrays.asList(new PatternTokenBuilder().csToken("need").matchInflectedForms().build(), PatternRuleBuilderHelper.token("to")), Arrays.asList(new PatternTokenBuilder().tokenRegex("solve(s|d|ing)?").setSkip(3).build(), PatternRuleBuilderHelper.tokenRegex("problems?")), Arrays.asList(PatternRuleBuilderHelper.posRegex("SENT_START|PCT"), PatternRuleBuilderHelper.token("no"), PatternRuleBuilderHelper.token("problem"), PatternRuleBuilderHelper.pos("PCT")), Arrays.asList(PatternRuleBuilderHelper.tokenRegex("math|word"), PatternRuleBuilderHelper.tokenRegex("problems?")), Arrays.asList(PatternRuleBuilderHelper.tokenRegex("as"), PatternRuleBuilderHelper.tokenRegex("a"), PatternRuleBuilderHelper.tokenRegex("whole")), Arrays.asList(PatternRuleBuilderHelper.token("more"), PatternRuleBuilderHelper.token("often"), PatternRuleBuilderHelper.token("than"), PatternRuleBuilderHelper.token("not")), Arrays.asList(PatternRuleBuilderHelper.token("often"), PatternRuleBuilderHelper.token("times")), Arrays.asList(PatternRuleBuilderHelper.tokenRegex("details?|facts?|it|journals?|questions?|research|results?|study|studies|this|these|those|which"), new PatternTokenBuilder().pos("RB").min(0).build(), new PatternTokenBuilder().csToken("suggest").matchInflectedForms().build()), Arrays.asList(new PatternTokenBuilder().csToken("form").matchInflectedForms().build(), PatternRuleBuilderHelper.posRegex("IN|PCT|RP|TO|SENT_END")), Arrays.asList(new PatternTokenBuilder().tokenRegex("bonds?|crystals?|ions?|rocks?|.*valence").setSkip(10).build(), new PatternTokenBuilder().csToken("form").matchInflectedForms().build()), Arrays.asList(new PatternTokenBuilder().tokenRegex("form(s|ed|ing)?").setSkip(10).build(), PatternRuleBuilderHelper.tokenRegex("bonds?|crystals?|ions?|rocks?|.*valence")), Arrays.asList(PatternRuleBuilderHelper.token("interesting"), PatternRuleBuilderHelper.tokenRegex("facts?|things?")), Arrays.asList(PatternRuleBuilderHelper.token("several"), PatternRuleBuilderHelper.tokenRegex("hundreds?|thousands?|millions?")), Arrays.asList(PatternRuleBuilderHelper.token("must"), PatternRuleBuilderHelper.token("be"), PatternRuleBuilderHelper.token("nice")), Arrays.asList(PatternRuleBuilderHelper.token("nice"), PatternRuleBuilderHelper.token("day")), Arrays.asList(PatternRuleBuilderHelper.token("nice"), PatternRuleBuilderHelper.token("to"), new PatternTokenBuilder().token("meet").min(0).build(), PatternRuleBuilderHelper.posRegex("PRP_O.*")), Arrays.asList(new PatternTokenBuilder().csToken("be").matchInflectedForms().build(), PatternRuleBuilderHelper.token("nice"), PatternRuleBuilderHelper.token("and"), PatternRuleBuilderHelper.pos("JJ"), PatternRuleBuilderHelper.posRegex("PCT|SENT_END")), Arrays.asList(PatternRuleBuilderHelper.posRegex("P?DT|PRP$.*"), PatternRuleBuilderHelper.token("proposed"), PatternRuleBuilderHelper.posRegex("N.*")), Arrays.asList(new PatternTokenBuilder().csToken("propose").matchInflectedForms().build(), PatternRuleBuilderHelper.tokenRegex("to|marriage")), Arrays.asList(PatternRuleBuilderHelper.token("too"), PatternRuleBuilderHelper.token("literally")), Arrays.asList(PatternRuleBuilderHelper.token("literally"), PatternRuleBuilderHelper.token("and"), PatternRuleBuilderHelper.token("figuratively")), Arrays.asList(PatternRuleBuilderHelper.token("literally"), PatternRuleBuilderHelper.token("everything")), Arrays.asList(PatternRuleBuilderHelper.token("literally"), PatternRuleBuilderHelper.posRegex("PCT|SENT_END")), Arrays.asList(PatternRuleBuilderHelper.posRegex("CC"), PatternRuleBuilderHelper.token("maybe")));
    private static final Map<String, SynonymsData> wordsToCheck = EnglishRepeatedWordsRule.loadWords("/en/synonyms.txt");

    @Override
    public List<DisambiguationPatternRule> getAntiPatterns() {
        return this.antiPatterns.get();
    }

    public EnglishRepeatedWordsRule(ResourceBundle messages) {
        super(messages, new AmericanEnglish());
        this.setTags(Collections.singletonList(Tag.picky));
        this.antiPatterns = EnglishRepeatedWordsRule.cacheAntiPatterns(new AmericanEnglish(), ANTI_PATTERNS);
        String id = this.getId();
        if (id.equals("EN_REPEATEDWORDS_DEFINITELY")) {
            this.setUrl(Tools.getUrl("https://languagetool.org/insights/post/i-agree-synonyms/"));
        }
        if (id.equals("EN_REPEATEDWORDS_CHOOSE")) {
            this.setUrl(Tools.getUrl("https://languagetool.org/insights/post/choose-vs-chose/"));
        }
    }

    @Override
    protected String getMessage() {
        return "This word has been used in one of the immediately preceding sentences. Using a synonym could make your text more interesting to read, unless the repetition is intentional.";
    }

    @Override
    public String getDescription() {
        return "Suggest synonyms for repeated words.";
    }

    @Override
    protected Map<String, SynonymsData> getWordsToCheck() {
        return wordsToCheck;
    }

    @Override
    protected String getShortMessage() {
        return "Style: repeated word";
    }

    @Override
    protected Synthesizer getSynthesizer() {
        return EnglishSynthesizer.INSTANCE;
    }

    @Override
    protected boolean isException(AnalyzedTokenReadings[] tokens, int i, boolean sentStart, boolean isCapitalized, boolean isAllUppercase) {
        if (isAllUppercase || isCapitalized && !sentStart) {
            return true;
        }
        return tokens[i].hasPosTagStartingWith("NNP");
    }
}

