//
// ********************************************************************
// * License and Disclaimer                                           *
// *                                                                  *
// * The  Geant4 software  is  copyright of the Copyright Holders  of *
// * the Geant4 Collaboration.  It is provided  under  the terms  and *
// * conditions of the Geant4 Software License,  included in the file *
// * LICENSE and available at  http://cern.ch/geant4/license .  These *
// * include a list of copyright holders.                             *
// *                                                                  *
// * Neither the authors of this software system, nor their employing *
// * institutes,nor the agencies providing financial support for this *
// * work  make  any representation or  warranty, express or implied, *
// * regarding  this  software system or assume any liability for its *
// * use.  Please see the license in the file  LICENSE  and URL above *
// * for the full disclaimer and the limitation of liability.         *
// *                                                                  *
// * This  code  implementation is the result of  the  scientific and *
// * technical work of the GEANT4 collaboration.                      *
// * By using,  copying,  modifying or  distributing the software (or *
// * any work based  on the software)  you  agree  to acknowledge its *
// * use  in  resulting  scientific  publications,  and indicate your *
// * acceptance of all terms of the Geant4 Software license.          *
// ********************************************************************
//
// G4UIdirectory
//
// Class description:
//
// A concrete class of G4UIcommand. This class defines a command
// directory which can have commands.
// General information of G4UIcommand is given in G4UIcommand.hh

// Author: Makoto Asai, 1998
// --------------------------------------------------------------------
#ifndef G4UIdirectory_hh
#define G4UIdirectory_hh 1

#include "G4UIcommand.hh"

class G4UIdirectory : public G4UIcommand
{
  public:
    // Constructors. The argument is a full path directory which
    // starts and ends with "/".
    G4UIdirectory(char* theCommandPath, G4bool commandsToBeBroadcasted = true);
    G4UIdirectory(const char* theCommandPath, G4bool commandsToBeBroadcasted = true);

    void Sort(G4bool val = true) { ifSort = val; }

    // N.B. ifSort is defined in the base class G4UIcommand
    G4bool IfSort() const { return ifSort; }
};

#endif
