package kms

//Licensed under the Apache License, Version 2.0 (the "License");
//you may not use this file except in compliance with the License.
//You may obtain a copy of the License at
//
//http://www.apache.org/licenses/LICENSE-2.0
//
//Unless required by applicable law or agreed to in writing, software
//distributed under the License is distributed on an "AS IS" BASIS,
//WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
//See the License for the specific language governing permissions and
//limitations under the License.
//
// Code generated by Alibaba Cloud SDK Code Generator.
// Changes may cause incorrect behavior and will be lost if the code is regenerated.

import (
	"github.com/aliyun/alibaba-cloud-sdk-go/sdk/requests"
	"github.com/aliyun/alibaba-cloud-sdk-go/sdk/responses"
)

// UpdateNetworkRule invokes the kms.UpdateNetworkRule API synchronously
func (client *Client) UpdateNetworkRule(request *UpdateNetworkRuleRequest) (response *UpdateNetworkRuleResponse, err error) {
	response = CreateUpdateNetworkRuleResponse()
	err = client.DoAction(request, response)
	return
}

// UpdateNetworkRuleWithChan invokes the kms.UpdateNetworkRule API asynchronously
func (client *Client) UpdateNetworkRuleWithChan(request *UpdateNetworkRuleRequest) (<-chan *UpdateNetworkRuleResponse, <-chan error) {
	responseChan := make(chan *UpdateNetworkRuleResponse, 1)
	errChan := make(chan error, 1)
	err := client.AddAsyncTask(func() {
		defer close(responseChan)
		defer close(errChan)
		response, err := client.UpdateNetworkRule(request)
		if err != nil {
			errChan <- err
		} else {
			responseChan <- response
		}
	})
	if err != nil {
		errChan <- err
		close(responseChan)
		close(errChan)
	}
	return responseChan, errChan
}

// UpdateNetworkRuleWithCallback invokes the kms.UpdateNetworkRule API asynchronously
func (client *Client) UpdateNetworkRuleWithCallback(request *UpdateNetworkRuleRequest, callback func(response *UpdateNetworkRuleResponse, err error)) <-chan int {
	result := make(chan int, 1)
	err := client.AddAsyncTask(func() {
		var response *UpdateNetworkRuleResponse
		var err error
		defer close(result)
		response, err = client.UpdateNetworkRule(request)
		callback(response, err)
		result <- 1
	})
	if err != nil {
		defer close(result)
		callback(nil, err)
		result <- 0
	}
	return result
}

// UpdateNetworkRuleRequest is the request struct for api UpdateNetworkRule
type UpdateNetworkRuleRequest struct {
	*requests.RpcRequest
	Description     string `position:"Query" name:"Description"`
	Name            string `position:"Query" name:"Name"`
	SourcePrivateIp string `position:"Query" name:"SourcePrivateIp"`
}

// UpdateNetworkRuleResponse is the response struct for api UpdateNetworkRule
type UpdateNetworkRuleResponse struct {
	*responses.BaseResponse
	RequestId string `json:"RequestId" xml:"RequestId"`
}

// CreateUpdateNetworkRuleRequest creates a request to invoke UpdateNetworkRule API
func CreateUpdateNetworkRuleRequest() (request *UpdateNetworkRuleRequest) {
	request = &UpdateNetworkRuleRequest{
		RpcRequest: &requests.RpcRequest{},
	}
	request.InitWithApiInfo("Kms", "2016-01-20", "UpdateNetworkRule", "kms", "openAPI")
	request.Method = requests.POST
	return
}

// CreateUpdateNetworkRuleResponse creates a response to parse from UpdateNetworkRule response
func CreateUpdateNetworkRuleResponse() (response *UpdateNetworkRuleResponse) {
	response = &UpdateNetworkRuleResponse{
		BaseResponse: &responses.BaseResponse{},
	}
	return
}
