package debugger

// Code generated by cdproto-gen. DO NOT EDIT.

import (
	"github.com/chromedp/cdproto/runtime"
	"github.com/go-json-experiment/json/jsontext"
)

// EventPaused fired when the virtual machine stopped on breakpoint or
// exception or any other stop criteria.
//
// See: https://chromedevtools.github.io/devtools-protocol/tot/Debugger#event-paused
type EventPaused struct {
	CallFrames        []*CallFrame          `json:"callFrames"` // Call stack the virtual machine stopped on.
	Reason            PausedReason          `json:"reason"`     // Pause reason.
	Data              jsontext.Value        `json:"data,omitempty,omitzero"`
	HitBreakpoints    []string              `json:"hitBreakpoints,omitempty,omitzero"`    // Hit breakpoints IDs
	AsyncStackTrace   *runtime.StackTrace   `json:"asyncStackTrace,omitempty,omitzero"`   // Async stack trace, if any.
	AsyncStackTraceID *runtime.StackTraceID `json:"asyncStackTraceId,omitempty,omitzero"` // Async stack trace, if any.
}

// EventResumed fired when the virtual machine resumed execution.
//
// See: https://chromedevtools.github.io/devtools-protocol/tot/Debugger#event-resumed
type EventResumed struct{}

// EventScriptFailedToParse fired when virtual machine fails to parse the
// script.
//
// See: https://chromedevtools.github.io/devtools-protocol/tot/Debugger#event-scriptFailedToParse
type EventScriptFailedToParse struct {
	ScriptID                runtime.ScriptID           `json:"scriptId"`           // Identifier of the script parsed.
	URL                     string                     `json:"url"`                // URL or name of the script parsed (if any).
	StartLine               int64                      `json:"startLine"`          // Line offset of the script within the resource with given URL (for script tags).
	StartColumn             int64                      `json:"startColumn"`        // Column offset of the script within the resource with given URL.
	EndLine                 int64                      `json:"endLine"`            // Last line of the script.
	EndColumn               int64                      `json:"endColumn"`          // Length of the last line of the script.
	ExecutionContextID      runtime.ExecutionContextID `json:"executionContextId"` // Specifies script creation context.
	Hash                    string                     `json:"hash"`               // Content hash of the script, SHA-256.
	BuildID                 string                     `json:"buildId"`            // For Wasm modules, the content of the build_id custom section. For JavaScript the debugId magic comment.
	ExecutionContextAuxData jsontext.Value             `json:"executionContextAuxData,omitempty,omitzero"`
	SourceMapURL            string                     `json:"sourceMapURL,omitempty,omitzero"`   // URL of source map associated with script (if any).
	HasSourceURL            bool                       `json:"hasSourceURL"`                      // True, if this script has sourceURL.
	IsModule                bool                       `json:"isModule"`                          // True, if this script is ES6 module.
	Length                  int64                      `json:"length,omitempty,omitzero"`         // This script length.
	StackTrace              *runtime.StackTrace        `json:"stackTrace,omitempty,omitzero"`     // JavaScript top stack frame of where the script parsed event was triggered if available.
	CodeOffset              int64                      `json:"codeOffset,omitempty,omitzero"`     // If the scriptLanguage is WebAssembly, the code section offset in the module.
	ScriptLanguage          ScriptLanguage             `json:"scriptLanguage,omitempty,omitzero"` // The language of the script.
	EmbedderName            string                     `json:"embedderName,omitempty,omitzero"`   // The name the embedder supplied for this script.
}

// EventScriptParsed fired when virtual machine parses script. This event is
// also fired for all known and uncollected scripts upon enabling debugger.
//
// See: https://chromedevtools.github.io/devtools-protocol/tot/Debugger#event-scriptParsed
type EventScriptParsed struct {
	ScriptID                runtime.ScriptID           `json:"scriptId"`           // Identifier of the script parsed.
	URL                     string                     `json:"url"`                // URL or name of the script parsed (if any).
	StartLine               int64                      `json:"startLine"`          // Line offset of the script within the resource with given URL (for script tags).
	StartColumn             int64                      `json:"startColumn"`        // Column offset of the script within the resource with given URL.
	EndLine                 int64                      `json:"endLine"`            // Last line of the script.
	EndColumn               int64                      `json:"endColumn"`          // Length of the last line of the script.
	ExecutionContextID      runtime.ExecutionContextID `json:"executionContextId"` // Specifies script creation context.
	Hash                    string                     `json:"hash"`               // Content hash of the script, SHA-256.
	BuildID                 string                     `json:"buildId"`            // For Wasm modules, the content of the build_id custom section. For JavaScript the debugId magic comment.
	ExecutionContextAuxData jsontext.Value             `json:"executionContextAuxData,omitempty,omitzero"`
	IsLiveEdit              bool                       `json:"isLiveEdit"`                             // True, if this script is generated as a result of the live edit operation.
	SourceMapURL            string                     `json:"sourceMapURL,omitempty,omitzero"`        // URL of source map associated with script (if any).
	HasSourceURL            bool                       `json:"hasSourceURL"`                           // True, if this script has sourceURL.
	IsModule                bool                       `json:"isModule"`                               // True, if this script is ES6 module.
	Length                  int64                      `json:"length,omitempty,omitzero"`              // This script length.
	StackTrace              *runtime.StackTrace        `json:"stackTrace,omitempty,omitzero"`          // JavaScript top stack frame of where the script parsed event was triggered if available.
	CodeOffset              int64                      `json:"codeOffset,omitempty,omitzero"`          // If the scriptLanguage is WebAssembly, the code section offset in the module.
	ScriptLanguage          ScriptLanguage             `json:"scriptLanguage,omitempty,omitzero"`      // The language of the script.
	DebugSymbols            []*DebugSymbols            `json:"debugSymbols,omitempty,omitzero"`        // If the scriptLanguage is WebAssembly, the source of debug symbols for the module.
	EmbedderName            string                     `json:"embedderName,omitempty,omitzero"`        // The name the embedder supplied for this script.
	ResolvedBreakpoints     []*ResolvedBreakpoint      `json:"resolvedBreakpoints,omitempty,omitzero"` // The list of set breakpoints in this script if calls to setBreakpointByUrl matches this script's URL or hash. Clients that use this list can ignore the breakpointResolved event. They are equivalent.
}
